The following settings can be configured by sub-tags:

| Setting                            | Description                                                                                                                                             | Default             | Note                                                                                                               |
|------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------|--------------------------------------------------------------------------------------------------------------------|
| `database`                         | Name of the database.                                                                                                                                   |                     |                                                                                                                    |
| `table`                            | Name of the system table.                                                                                                                               |                     |                                                                                                                    |
| `engine`                           | [MergeTree Engine Definition](../../../engines/table-engines/mergetree-family/mergetree.md#table_engine-mergetree-creating-a-table) for a system table. |                     | Cannot be used if `partition_by` or `order_by` defined. If not specified `MergeTree` is selected by default        |
| `partition_by`                     | [Custom partitioning key](../../../engines/table-engines/mergetree-family/custom-partitioning-key.md) for a system table.                               |                     | If `engine` is specified for system table, `partition_by` parameter should be specified directly inside 'engine'   |
| `ttl`                              | Specifies the table [TTL](/engines/table-engines/mergetree-family/mergetree#table_engine-mergetree-ttl).                                              |                     | If `engine` is specified for system table, `ttl` parameter should be specified directly inside 'engine'            |
| `order_by`                         | [Custom sorting key](../../../engines/table-engines/mergetree-family/mergetree.md#order_by) for a system table. Can't be used if `engine` defined.      |                     | If `engine` is specified for system table, `order_by` parameter should be specified directly inside 'engine'       |
| `storage_policy`                   | Name of the storage policy to use for the table (optional).                                                                                             |                     | If `engine` is specified for system table, `storage_policy` parameter should be specified directly inside 'engine' |
| `settings`                         | [Additional parameters](../../../engines/table-engines/mergetree-family/mergetree.md/#settings) that control the behavior of the MergeTree (optional).   |                     | If `engine` is specified for system table, `settings` parameter should be specified directly inside 'engine'       |
| `flush_interval_milliseconds`      | Interval for flushing data from the buffer in memory to the table.                                                                                      | `7500`              |                                                                                                                    |
| `max_size_rows`                    | Maximal size in lines for the logs. When the amount of non-flushed logs reaches the max_size, logs are dumped to the disk.                              | `1048576`           |                                                                                                                    |
| `reserved_size_rows`               | Pre-allocated memory size in lines for the logs.                                                                                                        | `8192`              |                                                                                                                    |
| `buffer_size_rows_flush_threshold` | Threshold for amount of lines. If the threshold is reached, flushing logs to the disk is launched in background.                                        | `max_size_rows / 2` |                                                                                                                    |
| `flush_on_crash`                   | Sets whether logs should be dumped to the disk in case of a crash.                                                                                      | `false`             |                                                                                                                    |
