---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.7.1.3997-stable (28a03cae61b) FIXME as compared to v25.7.1.1-new (c5372bebfd3)

#### Backward Incompatible Change
* Changes in this PR: 1. Introduce a new argument `unexpected_quoting_character_strategy` to the function that controls what happens when a `quoting_character` is unexpectedly found when reading a non quoted key or value. The value can be one of: `invalid`, `accept` or `promote`. Invalid will discard the key and go back to waiting key state. Accept will treat it as part of the key. Promote will discard previous character and start parsing as a quoted key. I believe the default behavior (and maybe the only behavior) should be `INVALID`, but in 2023 on https://github.com/ClickHouse/ClickHouse/pull/56423 it was implemented the `PROMOTE` logic. So, to make it kind of backwards compatible, I created this setting. 2. After parsing a quoted value, only parse the next key if a pair delimiter is found. [#80657](https://github.com/ClickHouse/ClickHouse/pull/80657) ([Arthur Passos](https://github.com/arthurpassos)).
* Previously, function `countMatches` would stop counting at the first empty match even if the pattern accepts it. To overcome this issue, `countMatches` now continues execution by advancing by a single character when an empty match occurs. Users who like to retain the old behavior can enable setting `count_matches_stop_at_empty_match`. [#81676](https://github.com/ClickHouse/ClickHouse/pull/81676) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Previously, BACKUP queries, merges and mutations were not using server-wide throttlers for local (`max_local_read_bandwidth_for_server` and `max_local_write_bandwidth_for_server`) and remote (`max_remote_read_network_bandwidth_for_server` and `max_remote_write_network_bandwidth_for_server`) traffic, instead they were only throttled by dedicated server settings (`max_backup_bandwidth_for_server`, `max_mutations_bandwidth_for_server` and `max_merges_bandwidth_for_server`). Now, they use both types of throttlers simultaneously. [#81753](https://github.com/ClickHouse/ClickHouse/pull/81753) ([Sergei Trifonov](https://github.com/serxa)).
* Forbid the creation of a table without insertable columns. [#81835](https://github.com/ClickHouse/ClickHouse/pull/81835) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Cluster functions with archives used to send over the whole archives to replicas, making reading within archive not-parallelizable with cluster (e.g. for example with a single archive we would just send it to one of the replicas as a whole to process and all other replicas will just be idle, which is inefficient). Added a new setting `cluster_function_process_archive_on_multiple_nodes`, by default equal to `true`. If set to `true`, increases performance of processing archives in cluster functions. Should be set to `false` for compatibility and to avoid errors during upgrade to 25.7+ if using cluster functions with archives on earlier versions. [#82355](https://github.com/ClickHouse/ClickHouse/pull/82355) ([Kseniia Sumarokova](https://github.com/kssenii)).
* `SYSTEM RESTART REPLICAS` query led to the wakeup of tables in the Lazy database, even without access to that database, and it happened while these tables were being concurrently dropped. Note: Now `SYSTEM RESTART REPLICAS` will only restart replicas in the databases where you have permission to `SHOW TABLES`, which is natural. [#83321](https://github.com/ClickHouse/ClickHouse/pull/83321) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### New Feature
* Add SZ3 as a lossy yet error-bounded compression codec for columns of type `Float32` and `Float64`. [#67161](https://github.com/ClickHouse/ClickHouse/pull/67161) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Support complex types in iceberg schema evolution. [#73714](https://github.com/ClickHouse/ClickHouse/pull/73714) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* **NumericIndexedVector**: new vector data-structure backed by bit-sliced, Roaring-bitmap compression, together with more than 20 functions for building, analysing and point-wise arithmetic. Can cut storage and speed up joins, filters and aggregations on sparse data. Implements [#70582](https://github.com/ClickHouse/ClickHouse/issues/70582) and [“Large-Scale Metric Computation in Online Controlled Experiment Platform” paper](https://arxiv.org/abs/2405.08411) by T. Xiong and Y. Wang from VLDB 2024. [#74193](https://github.com/ClickHouse/ClickHouse/pull/74193) ([FriendLey](https://github.com/FriendLey)).
* Add 'format_schema_source' setting which defines the source of 'format_schema'. [#80874](https://github.com/ClickHouse/ClickHouse/pull/80874) ([Tuan Pham Anh](https://github.com/tuanpach)).
* New data types: Time ([H]HH:MM:SS) and Time64 ([H]HH:MM:SS[.fractional]), and some basic cast functions and functions to interact with other data types. Added settings for compatibility with a legacy function `ToTime`. [#81217](https://github.com/ClickHouse/ClickHouse/pull/81217) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* The workload setting `max_waiting_queries` is now supported. It can be used to limit the size of the query queue. If the limit is reached, all subsequent queries will be terminated with the `SERVER_OVERLOADED` error. [#81250](https://github.com/ClickHouse/ClickHouse/pull/81250) ([Oleg Doronin](https://github.com/dorooleg)).
* It's now possible to write USE DATABASE {name}. [#81307](https://github.com/ClickHouse/ClickHouse/pull/81307) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Add financial functions: `financialInternalRateOfReturnExtended` (`XIRR`), `financialInternalRateOfReturn` (`IRR`), `financialNetPresentValueExtended` (`XNPV`), `financialNetPresentValue` (`NPV`). [#81599](https://github.com/ClickHouse/ClickHouse/pull/81599) ([Joanna Hulboj](https://github.com/jh0x)).
* Added a new system table `system.codecs` to introspect the available codecs. (issue [#81525](https://github.com/ClickHouse/ClickHouse/issues/81525)). [#81600](https://github.com/ClickHouse/ClickHouse/pull/81600) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Add the geospatial functions `polygonIntersectsCartesian` and `polygonIntersectsSpherical` to check if two polygons intersect. [#81882](https://github.com/ClickHouse/ClickHouse/pull/81882) ([Paul Lamb](https://github.com/plamb)).
* Added support for lightweight updates for `MergeTree`-family tables. Lightweight updates can be used by a new syntax: `UPDATE <table> SET col1 = val1, col2 = val2, ... WHERE <condition>`. Added implementation of lightweight deletes via lightweight updates. It can be enabled by setting `lightweight_delete_mode = 'lightweight_update'`. [#82004](https://github.com/ClickHouse/ClickHouse/pull/82004) ([Anton Popov](https://github.com/CurtizJ)).
* Support `lag` and `lead` window functions. Closes [#9887](https://github.com/ClickHouse/ClickHouse/issues/9887). [#82108](https://github.com/ClickHouse/ClickHouse/pull/82108) ([Dmitry Novik](https://github.com/novikd)).
* Support `_part_granule_offset` virtual column in MergeTree-family tables. This column indicates the zero-based index of the granule/mark each row belongs to within its data part. This addresses [#79572](https://github.com/ClickHouse/ClickHouse/issues/79572). [#82341](https://github.com/ClickHouse/ClickHouse/pull/82341) ([Amos Bird](https://github.com/amosbird)).
* Introduce Iceberg writes for `insert` queries. [#82692](https://github.com/ClickHouse/ClickHouse/pull/82692) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Add SZ3 as a lossy yet error-bounded compression codec for columns of type `Float32` and `Float64`. [#83088](https://github.com/ClickHouse/ClickHouse/pull/83088) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Add AI-powered SQL generation to ClickHouse client. Users can now generate SQL queries from natural language descriptions by prefixing their query with "??". Supports OpenAI and Anthropic providers with automatic schema discovery. [#83314](https://github.com/ClickHouse/ClickHouse/pull/83314) ([Kaushik Iska](https://github.com/iskakaushik)).
* Read iceberg data files by field ids. This closes [#83065](https://github.com/ClickHouse/ClickHouse/issues/83065). [#83653](https://github.com/ClickHouse/ClickHouse/pull/83653) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Added SQL functions `colorSRGBToOkLCH` and `colorOkLCHToSRGB` for converting colours between the sRGB and OkLCH colour spaces. [#83679](https://github.com/ClickHouse/ClickHouse/pull/83679) ([Fgrtue](https://github.com/Fgrtue)).
* Backported in [#84005](https://github.com/ClickHouse/ClickHouse/issues/84005): AI Powered SQL generation can now infer from env ANTHROPIC_API_KEY and OPENAI_API_KEY if available, this is to make it so that we can have a zero config option to use this feature. [#83787](https://github.com/ClickHouse/ClickHouse/pull/83787) ([Kaushik Iska](https://github.com/iskakaushik)).

#### Experimental Feature
* Added functions `searchAny` and `searchAll` which are general purpose tools to search text indexes. [#80641](https://github.com/ClickHouse/ClickHouse/pull/80641) ([Elmi Ahmadov](https://github.com/ahmadov)).
* The text index now supports `string` tokenizer. [#81752](https://github.com/ClickHouse/ClickHouse/pull/81752) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Changed the default index granularity value for `text` indexes to 64. This improves the expected performance for the average test query in internal benchmarks. [#82162](https://github.com/ClickHouse/ClickHouse/pull/82162) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* The 256-bit bitmap stores the outgoing labels of a state ordered, but outgoing states are saved into disk in the order they appear in the hash table. Therefore, a label would point to a wrong next state while reading from disk. [#82783](https://github.com/ClickHouse/ClickHouse/pull/82783) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Currently, FST tree is saved into disk uncompressed. This could lead to slow performance or higher I/O bandwidth while both writing and reading into/from disk. [#83093](https://github.com/ClickHouse/ClickHouse/pull/83093) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Remove `searchAny`, `searchAll` due to a bug. See [#82385](https://github.com/ClickHouse/ClickHouse/issues/82385). [#83117](https://github.com/ClickHouse/ClickHouse/pull/83117) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Recently, fuzzer found an issue for the searchAny and searchAll functions (see [#82385](https://github.com/ClickHouse/ClickHouse/issues/82385)). This exception occurs whenever `searchAny` or `searchAll` functions get different text index parameters for the same column. This scenario is only possible when there are two different text indices for the same column. This PR limits a column to be defined only once for the text index, but wrapper around the column (e.g. `lower(column)`) is still allowed. [#83303](https://github.com/ClickHouse/ClickHouse/pull/83303) ([Elmi Ahmadov](https://github.com/ahmadov)).

#### Performance Improvement
* Trivial optimization for -If combinator. [#78454](https://github.com/ClickHouse/ClickHouse/pull/78454) ([李扬](https://github.com/taiyang-li)).
* Introduced an option to offload (de)compression and (de)serialization of blocks into pipeline threads instead of a single thread associated with a network connection. Controlled by the setting `enable_parallel_blocks_marshalling`. It should speed up distributed queries that transfer significant amounts of data between the initiator and remote nodes. [#78694](https://github.com/ClickHouse/ClickHouse/pull/78694) ([Nikita Taranov](https://github.com/nickitat)).
* Vector search queries using a vector similarity index complete with lower latency due to reduced storage reads and reduced CPU usage. [#79103](https://github.com/ClickHouse/ClickHouse/pull/79103) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Respect `merge_tree_min_{rows,bytes}_for_seek` in `filterPartsByQueryConditionCache` to align it with other methods filtering by indexes. [#80312](https://github.com/ClickHouse/ClickHouse/pull/80312) ([李扬](https://github.com/taiyang-li)).
* Make the pipeline after the TOTALS step multithreaded. [#80331](https://github.com/ClickHouse/ClickHouse/pull/80331) ([UnamedRus](https://github.com/UnamedRus)).
* Parallel distributed INSERT SELECT is enabled by default in mode where INSERT SELECT executed on each shard independently, see `parallel_distributed_insert_select` setting. [#80425](https://github.com/ClickHouse/ClickHouse/pull/80425) ([Igor Nikonov](https://github.com/devcrafter)).
* Tweak some jemalloc configs to improve performance. [#81807](https://github.com/ClickHouse/ClickHouse/pull/81807) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix filter by key for Redis and KeeperMap storages. [#81833](https://github.com/ClickHouse/ClickHouse/pull/81833) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Add new setting `min_joined_block_size_rows` (analogous to `min_joined_block_size_bytes`; defaults to 65409) to control the minimum block size (in rows) for JOIN input and output blocks (if the join algorithm supports it). Small blocks will be squashed. [#81886](https://github.com/ClickHouse/ClickHouse/pull/81886) ([Nikita Taranov](https://github.com/nickitat)).
* When the aggregation query contains only a single `COUNT()` function on a NOT NULL column, the aggregation logic is fully inlined during hash table probing. This avoids allocating and maintaining any aggregation state, significantly reducing memory usage and CPU overhead. This partially addresses [#81982](https://github.com/ClickHouse/ClickHouse/issues/81982). [#82104](https://github.com/ClickHouse/ClickHouse/pull/82104) ([Amos Bird](https://github.com/amosbird)).
* Performance of `HashJoin` optimised by removing the additional loop over hash maps in the typical case of only one key column, also `null_map` and `join_mask` checks are eliminated when they're always `true`/`false`. [#82308](https://github.com/ClickHouse/ClickHouse/pull/82308) ([Nikita Taranov](https://github.com/nickitat)).
* `ATTACH PARTITION` no longer leads to the dropping of all caches. [#82377](https://github.com/ClickHouse/ClickHouse/pull/82377) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Optimize the generated plan for correlated subqueries by removing redundant JOIN operations using equivalence classes. If there are equivalent expressions for all correlated columns, `CROSS JOIN` is not produced if `query_plan_correlated_subqueries_use_substitution` setting is enabled. [#82435](https://github.com/ClickHouse/ClickHouse/pull/82435) ([Dmitry Novik](https://github.com/novikd)).
* Read only required columns in correlated subquery when it appears to be an argument of function `EXISTS`. [#82443](https://github.com/ClickHouse/ClickHouse/pull/82443) ([Dmitry Novik](https://github.com/novikd)).
* Introduce async logging. [#82516](https://github.com/ClickHouse/ClickHouse/pull/82516) ([Raúl Marín](https://github.com/Algunenano)).
* Compress logs and profile events in the native protocol. On clusters with 100+ replicas, uncompressed profile events take 1..10 MB/sec, and the progress bar is sluggish on slow Internet connections. This closes [#82533](https://github.com/ClickHouse/ClickHouse/issues/82533). [#82535](https://github.com/ClickHouse/ClickHouse/pull/82535) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Try to speedup QueryTreeHash a bit. [#82617](https://github.com/ClickHouse/ClickHouse/pull/82617) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add alignment in the Counter of ProfileEvents to reduce false sharing. [#82697](https://github.com/ClickHouse/ClickHouse/pull/82697) ([Jiebin Sun](https://github.com/jiebinn)).
* Parallel distributed INSERT SELECT is enabled by default in mode where INSERT SELECT executed on each shard independently, see `parallel_distributed_insert_select` setting. [#83040](https://github.com/ClickHouse/ClickHouse/pull/83040) ([Igor Nikonov](https://github.com/devcrafter)).
* The optimizations for `null_map` and `JoinMask` from [#82308](https://github.com/ClickHouse/ClickHouse/issues/82308) were applied to the case of JOIN with multiple disjuncts. Also, the `KnownRowsHolder` data structure was optimized. [#83041](https://github.com/ClickHouse/ClickHouse/pull/83041) ([Nikita Taranov](https://github.com/nickitat)).
* Plain `std::vector<std::atomic_bool>` is used for join flags to avoid calculating a hash on each access to flags. [#83043](https://github.com/ClickHouse/ClickHouse/pull/83043) ([Nikita Taranov](https://github.com/nickitat)).
* Don't pre-allocate memory for result columns beforehand when `HashJoin` uses `lazy` output mode. It is suboptimal, especially when the number of matches is low. Moreover, we know the exact amount of matches after joining is done, so we can preallocate more precisely. [#83304](https://github.com/ClickHouse/ClickHouse/pull/83304) ([Nikita Taranov](https://github.com/nickitat)).
* Minimize memory copy in port headers during pipeline construction. Original [PR](https://github.com/ClickHouse/ClickHouse/pull/70105) by [heymind](https://github.com/heymind). [#83381](https://github.com/ClickHouse/ClickHouse/pull/83381) ([Raúl Marín](https://github.com/Algunenano)).
* Improve Keeper with rocksdb initial loading. [#83390](https://github.com/ClickHouse/ClickHouse/pull/83390) ([Antonio Andelic](https://github.com/antonio2368)).
* Avoid holding the lock while creating storage snapshot data to reduce lock contention with high concurrent load. [#83510](https://github.com/ClickHouse/ClickHouse/pull/83510) ([Duc Canh Le](https://github.com/canhld94)).
* Improved performance of the ProtobufSingle input format by reusing the serializer when no parsing errors occur. [#83613](https://github.com/ClickHouse/ClickHouse/pull/83613) ([Eduard Karacharov](https://github.com/korowa)).
* Improve the performance of pipeline building. [#83631](https://github.com/ClickHouse/ClickHouse/pull/83631) ([Raúl Marín](https://github.com/Algunenano)).
* Optimize MergeTreeReadersChain::getSampleBlock. [#83875](https://github.com/ClickHouse/ClickHouse/pull/83875) ([Raúl Marín](https://github.com/Algunenano)).

#### Improvement
* Introduced two new access types: `READ` and `WRITE` for sources and deprecates all previous access types related to sources. Before `GRANT S3 ON *.* TO user`, now: `GRANT READ, WRITE ON S3 TO user`. This also allows to separate `READ` and `WRITE` permissions for sources, e.g.: `GRANT READ ON * TO user`, `GRANT WRITE ON S3 TO user`. The feature is controlled by a setting `access_control_improvements.enable_read_write_grants` and disabled by default. [#73659](https://github.com/ClickHouse/ClickHouse/pull/73659) ([pufit](https://github.com/pufit)).
* Verify the part has consistent checksum.txt file right before committing it. [#76625](https://github.com/ClickHouse/ClickHouse/pull/76625) ([Sema Checherinda](https://github.com/CheSema)).
* Implement methods `moveFile` and `replaceFile` in s3_plain_rewritable to support it as a database disk. [#79424](https://github.com/ClickHouse/ClickHouse/pull/79424) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Allow backups for PostgreSQL, MySQL & DataLake databases. A backup of such a database would only save the definition and not the data inside of it. [#79982](https://github.com/ClickHouse/ClickHouse/pull/79982) ([Nikolay Degterinsky](https://github.com/evillique)).
* Support position deletes for Iceberg TableEngine. [#80237](https://github.com/ClickHouse/ClickHouse/pull/80237) ([YanghongZhong](https://github.com/yahoNanJing)).
* Setting `allow_experimental_join_condition` marked as obsolete. [#80566](https://github.com/ClickHouse/ClickHouse/pull/80566) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Add pressure metrics to ClickHouse async metrics. [#80779](https://github.com/ClickHouse/ClickHouse/pull/80779) ([Xander Garbett](https://github.com/Garbett1)).
* Added metrics `MarkCacheEvictedBytes`, `MarkCacheEvictedMarks`, `MarkCacheEvictedFiles` for tracking evictions from the mark cache. (issue [#60989](https://github.com/ClickHouse/ClickHouse/issues/60989)). [#80799](https://github.com/ClickHouse/ClickHouse/pull/80799) ([Shivji Kumar Jha](https://github.com/shiv4289)).
* Speedup tables listing in data catalogs by asynchronous requests. [#81084](https://github.com/ClickHouse/ClickHouse/pull/81084) ([alesapin](https://github.com/alesapin)).
* Support writing parquet enum as byte array as the [spec](https://github.com/apache/parquet-format/blob/master/LogicalTypes.md#enum) dictates. I'll write more info later. [#81090](https://github.com/ClickHouse/ClickHouse/pull/81090) ([Arthur Passos](https://github.com/arthurpassos)).
* An improvement for `DeltaLake` table engine: delta-kernel-rs has `ExpressionVisitor` API which is implemented in this PR and is applied to partition column expressions transform (it will replace an old deprecated within the delta-kernel-rs way, which was used before in our code). In the future this `ExpressionVisitor` will also allow to implement statistics based pruning and some delta-lake proprietary features. Additionally the purpose of this change is to support partition pruning in `DeltaLakeCluster` table engine (the result of a parsed expression - ActionsDAG - will be serialized and sent from the initiator along with the data path, because this kind of information, which is needed for pruning, is only available as meta information on data files listing, which is done by initiator only, but it has to be applied to data on each reading server). [#81136](https://github.com/ClickHouse/ClickHouse/pull/81136) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Try to preserve element names when deriving supertypes for named tuples. [#81345](https://github.com/ClickHouse/ClickHouse/pull/81345) ([lgbo](https://github.com/lgbo-ustc)).
* Allow parameters in `CREATE USER` queries for usernames. [#81387](https://github.com/ClickHouse/ClickHouse/pull/81387) ([Diskein](https://github.com/Diskein)).
* Now clickhouse supports compressed `metadata.json` files for Iceberg. Fixes [#70874](https://github.com/ClickHouse/ClickHouse/issues/70874). [#81451](https://github.com/ClickHouse/ClickHouse/pull/81451) ([alesapin](https://github.com/alesapin)).
* The `system.formats` table now contains extended information about formats, such as HTTP content type, the capabilities of schema inference, etc. [#81505](https://github.com/ClickHouse/ClickHouse/pull/81505) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Count consumed messages manually to avoid depending on previous committed offset in StorageKafka2. [#81662](https://github.com/ClickHouse/ClickHouse/pull/81662) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Added `clickhouse-keeper-utils`, a new command-line tool for managing and analyzing ClickHouse Keeper data. The tool supports dumping state from snapshots and changelogs, analyzing changelog files, and extracting specific log ranges. [#81677](https://github.com/ClickHouse/ClickHouse/pull/81677) ([Antonio Andelic](https://github.com/antonio2368)).
* The total and per-user network throttlers are never reset, which ensures that `max_network_bandwidth_for_all_users` and `max_network_bandwidth_for_all_users` limits are never exceeded. [#81729](https://github.com/ClickHouse/ClickHouse/pull/81729) ([Sergei Trifonov](https://github.com/serxa)).
* Support writing geoparquets as output format. [#81784](https://github.com/ClickHouse/ClickHouse/pull/81784) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Forbid to start `RENAME COLUMN` alter mutation if it will rename some column that right now affected by incomplete data mutation. [#81823](https://github.com/ClickHouse/ClickHouse/pull/81823) ([Mikhail Artemenko](https://github.com/Michicosun)).
* This PR introduces jitter to the S3 retry mechanism when the `s3_slow_all_threads_after_network_error` configuration is enabled. [#81849](https://github.com/ClickHouse/ClickHouse/pull/81849) ([zoomxi](https://github.com/zoomxi)).
* Try fix logical error in filesystem cache: "Having zero bytes but range is not finished". [#81868](https://github.com/ClickHouse/ClickHouse/pull/81868) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Function `addressToSymbol` and `system.symbols` table will use file offsets instead of virtual memory addresses. [#81896](https://github.com/ClickHouse/ClickHouse/pull/81896) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Use `abseil-cpp` 20250512.0. [#81945](https://github.com/ClickHouse/ClickHouse/pull/81945) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Header Connection is send at the end of headers. When we know is the connection should be preserved. [#81951](https://github.com/ClickHouse/ClickHouse/pull/81951) ([Sema Checherinda](https://github.com/CheSema)).
* Use `google-protobuf` v31.1. [#81976](https://github.com/ClickHouse/ClickHouse/pull/81976) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Tune TCP servers queue (64 by default) based on listen_backlog (4096 by default). [#82045](https://github.com/ClickHouse/ClickHouse/pull/82045) ([Azat Khuzhin](https://github.com/azat)).
* Add ability to reload `max_local_read_bandwidth_for_server` and `max_local_write_bandwidth_for_server` on fly without restart server. [#82083](https://github.com/ClickHouse/ClickHouse/pull/82083) ([Kai Zhu](https://github.com/nauu)).
* Add support for clearing all warnings from the `system.warnings` table using `TRUNCATE TABLE system.warnings`. [#82087](https://github.com/ClickHouse/ClickHouse/pull/82087) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix partition pruning with data lake cluster functions. [#82131](https://github.com/ClickHouse/ClickHouse/pull/82131) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix reading partitioned data in DeltaLakeCluster table function. In this PR cluster functions protocol version is increased, allowing to send extra info from initiator to replicas. This extra info contains delta-kernel transform expression, which is needed to parse partition columns (and some other staff in the future, like generated columns, etc). [#82132](https://github.com/ClickHouse/ClickHouse/pull/82132) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix a list of problems that can occur when trying to run integration tests on a local host. [#82135](https://github.com/ClickHouse/ClickHouse/pull/82135) ([Oleg Doronin](https://github.com/dorooleg)).
* Now database Datalake throw more convenient exception. Fixes [#81211](https://github.com/ClickHouse/ClickHouse/issues/81211). [#82304](https://github.com/ClickHouse/ClickHouse/pull/82304) ([alesapin](https://github.com/alesapin)).
* Improve HashJoin::needUsedFlagsForPerRightTableRow, returns false for cross join. [#82379](https://github.com/ClickHouse/ClickHouse/pull/82379) ([lgbo](https://github.com/lgbo-ustc)).
* Allow write/read map columns as array of tuples. [#82408](https://github.com/ClickHouse/ClickHouse/pull/82408) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Allow ALTER UPDATE in JSON and Dynamic columns. [#82419](https://github.com/ClickHouse/ClickHouse/pull/82419) ([Pavel Kruglov](https://github.com/Avogar)).
* List the licenses of rust crates in system.licenses. [#82440](https://github.com/ClickHouse/ClickHouse/pull/82440) ([Raúl Marín](https://github.com/Algunenano)).
* Exclude sensitive data from core dumps. Add two allocators: AWS library compatible `AwsNodumpMemoryManager` and STL compatible `JemallocNodumpSTLAllocator`. Both are wrappers of the Jemalloc allocator. They use Jemalloc's extent hooks and madvise to mark memory pages as "don't dump". Used for S3 credentials, user credentials, and some query data. [#82441](https://github.com/ClickHouse/ClickHouse/pull/82441) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Macros like `{uuid}` can now be used in the `keeper_path` setting of the S3Queue table engine. [#82463](https://github.com/ClickHouse/ClickHouse/pull/82463) ([Nikolay Degterinsky](https://github.com/evillique)).
* Keeper improvement: move changelog files between disk in a background thread. Previously, moving changelog to a different disk would block Keeper globally until the move is finished. This lead to performance degradation if moving is a long operation (e.g. to S3 disk). [#82485](https://github.com/ClickHouse/ClickHouse/pull/82485) ([Antonio Andelic](https://github.com/antonio2368)).
* Keeper improvement: add new config `keeper_server.cleanup_old_and_ignore_new_acl`. If enabled, all nodes will have their ACLs cleared while ACL for new requests will be ignored. If the goal is to completely remove ACL from nodes, it's important to leave the config enabled until a new snapshot is created. [#82496](https://github.com/ClickHouse/ClickHouse/pull/82496) ([Antonio Andelic](https://github.com/antonio2368)).
* Removed experimental `send_metadata` logic related to experimental zero-copy replication. It wasn't ever used and nobody supports this code. Since there were even no tests related to it, there is a high chance that it's broken long time ago. [#82508](https://github.com/ClickHouse/ClickHouse/pull/82508) ([alesapin](https://github.com/alesapin)).
* Added a new server setting `s3queue_disable_streaming` which disables streaming in tables with S3Queue table engine. This setting is changeable without server restart. [#82515](https://github.com/ClickHouse/ClickHouse/pull/82515) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Color parenthesis in multiple colors for better readability. [#82538](https://github.com/ClickHouse/ClickHouse/pull/82538) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Refactor dynamic resize feature of filesystem cache. Added more logs for introspection. [#82556](https://github.com/ClickHouse/ClickHouse/pull/82556) ([Kseniia Sumarokova](https://github.com/kssenii)).
* `SYSTEM RESTART REPLICA` may fail due to ZooKeeper connection issues. To avoid forgetting about this table, we now retry until the table is created. [#82616](https://github.com/ClickHouse/ClickHouse/pull/82616) ([Nikolay Degterinsky](https://github.com/evillique)).
* `clickhouse-server` without a configuration file will also listen to the PostgreSQL port 9005, like with the default config. [#82633](https://github.com/ClickHouse/ClickHouse/pull/82633) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Integrate `StorageKafka2` to `system.kafka_consumers`. [#82652](https://github.com/ClickHouse/ClickHouse/pull/82652) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Estimate complex cnf/dnf, for example, `(a < 1 and a > 0) or b = 3`, by statistics. [#82663](https://github.com/ClickHouse/ClickHouse/pull/82663) ([Han Fei](https://github.com/hanfei1991)).
* In `ReplicatedMergeTree::executeMetadataAlter`, we get the StorageID, and without taking DDLGuard, we try to call `IDatabase::alterTable`. In between this time we could have technically exchanged the table in question with another table, so when we get the definiton we would get the wrong one. To avoid this we add a separate check for UUIDs to match when we try to call `IDatabase::alterTable`. [#82666](https://github.com/ClickHouse/ClickHouse/pull/82666) ([Nikolay Degterinsky](https://github.com/evillique)).
* When attaching a database with a read-only remote disk, manually add table UUIDs into DatabaseCatalog. [#82670](https://github.com/ClickHouse/ClickHouse/pull/82670) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix the wrong default value for the `--reconnect` option in `clickhouse-benchmark`. It was changed by mistake in [#79465](https://github.com/ClickHouse/ClickHouse/issues/79465). [#82677](https://github.com/ClickHouse/ClickHouse/pull/82677) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Prevent user from using `nan` and `inf` with `NumericIndexedVector`. Fixes [#82239](https://github.com/ClickHouse/ClickHouse/issues/82239) and a little more. [#82681](https://github.com/ClickHouse/ClickHouse/pull/82681) ([Raufs Dunamalijevs](https://github.com/rienath)).
* After https://github.com/ClickHouse/ClickHouse/pull/73834, the `X-ClickHouse-Progress` and `X-ClickHouse-Summary` header formats have been modified to omit zero values. This PR intends to return the previous behaviour for `X-ClickHouse-Summary` only, because it makes sense. [#82727](https://github.com/ClickHouse/ClickHouse/pull/82727) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Keeper improvement: support specific permissions for world:anyone ACL. [#82755](https://github.com/ClickHouse/ClickHouse/pull/82755) ([Antonio Andelic](https://github.com/antonio2368)).
* In previous versions, multiplication of the aggregate function state with IPv4 produced a logical error instead of a proper error code. Closes [#82817](https://github.com/ClickHouse/ClickHouse/issues/82817). [#82818](https://github.com/ClickHouse/ClickHouse/pull/82818) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Do not allow RENAME COLUMN or DROP COLUMN involving explicitly listed columns to sum in SummingMergeTree. Closes [#81836](https://github.com/ClickHouse/ClickHouse/issues/81836). [#82821](https://github.com/ClickHouse/ClickHouse/pull/82821) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve the precision of conversion from `Decimal` to `Float32`. Implement conversion from `Decimal` to `BFloat16`. Closes [#82660](https://github.com/ClickHouse/ClickHouse/issues/82660). [#82823](https://github.com/ClickHouse/ClickHouse/pull/82823) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix inconsistent formatting of `CREATE DICTIONARY`. Closes [#82105](https://github.com/ClickHouse/ClickHouse/issues/82105). [#82829](https://github.com/ClickHouse/ClickHouse/pull/82829) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix inconsistent formatting of TTL when it contains a `materialize` function. Closes [#82828](https://github.com/ClickHouse/ClickHouse/issues/82828). [#82831](https://github.com/ClickHouse/ClickHouse/pull/82831) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix inconsistent formatting of EXPLAIN AST in a subquery when it contains output options such as INTO OUTFILE. Closes [#82826](https://github.com/ClickHouse/ClickHouse/issues/82826). [#82840](https://github.com/ClickHouse/ClickHouse/pull/82840) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix inconsistent formatting of parenthesized expressions with aliases in the context when no aliases are allowed. Closes [#82836](https://github.com/ClickHouse/ClickHouse/issues/82836). Closes [#82837](https://github.com/ClickHouse/ClickHouse/issues/82837). [#82867](https://github.com/ClickHouse/ClickHouse/pull/82867) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Scrollbars in the Web UI will look slightly better. [#82869](https://github.com/ClickHouse/ClickHouse/pull/82869) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `clickhouse-server` with embedded configuration will allow using the Web UI by providing an HTTP OPTIONS response. [#82870](https://github.com/ClickHouse/ClickHouse/pull/82870) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Highlight metacharacters in LIKE/REGEXP patterns as you type. We already have it in `clickhouse-format` and in the echo in `clickhouse-client`, but now it is done in the command prompt as well. [#82871](https://github.com/ClickHouse/ClickHouse/pull/82871) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Highlighting in `clickhouse-format` and in the client's echo will work in the same way as the highlighting in the command line prompt. [#82874](https://github.com/ClickHouse/ClickHouse/pull/82874) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This PR was reverted. [#82884](https://github.com/ClickHouse/ClickHouse/pull/82884) ([Mithun p](https://github.com/mithunputhusseri)).
* Add support for specifying extra Keeper ACL for paths in config. If you want to add extra ACL for a specific path you define it in the config under `zookeeper.path_acls`. [#82898](https://github.com/ClickHouse/ClickHouse/pull/82898) ([Antonio Andelic](https://github.com/antonio2368)).
* Add function to write types into wkb format. [#82935](https://github.com/ClickHouse/ClickHouse/pull/82935) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Now mutations snapshot will be built from the visible parts snapshot. Also mutation counters used in snapshot will be recalculated from the included mutations. [#82945](https://github.com/ClickHouse/ClickHouse/pull/82945) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Adds ProfileEvent when Keeper rejects a write due to soft memory limit. [#82963](https://github.com/ClickHouse/ClickHouse/pull/82963) ([Xander Garbett](https://github.com/Garbett1)).
* Add columns `commit_time`, `commit_id` to `system.s3queue_log`. [#83016](https://github.com/ClickHouse/ClickHouse/pull/83016) ([Kseniia Sumarokova](https://github.com/kssenii)).
* In some cases, we need to have multiple dimensions to our metrics. For example, counting failed merges or mutations by error codes rather than having a single counter. [#83030](https://github.com/ClickHouse/ClickHouse/pull/83030) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Consolidate unknown settings warnings in clickhouse client and log them as a summary. [#83042](https://github.com/ClickHouse/ClickHouse/pull/83042) ([Bharat Nallan](https://github.com/bharatnc)).
* Clickhouse client now reports the local port when connection error happens. [#83050](https://github.com/ClickHouse/ClickHouse/pull/83050) ([Jianfei Hu](https://github.com/incfly)).
* Slightly better error handling in `AsynchronousMetrics`. If the `/sys/block` directory exists but is not accessible, the server will start without monitoring the block devices. Closes [#79229](https://github.com/ClickHouse/ClickHouse/issues/79229). [#83115](https://github.com/ClickHouse/ClickHouse/pull/83115) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Support `TimestampTZ` in Glue catalog. This closes [#81654](https://github.com/ClickHouse/ClickHouse/issues/81654). [#83132](https://github.com/ClickHouse/ClickHouse/pull/83132) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Shutdown SystemLogs after ordinary tables (and before system tables, instead of before ordinary). [#83134](https://github.com/ClickHouse/ClickHouse/pull/83134) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add logs for s3queue shutdown process. [#83163](https://github.com/ClickHouse/ClickHouse/pull/83163) ([Kseniia Sumarokova](https://github.com/kssenii)).
* There was an incorrect dependency check for the INSERT with MVs that have malformed selects and the user might have received an obscure `std::exception` instead of a meaningful error with a clear explanation. This is now fixed. This fixes: [#82889](https://github.com/ClickHouse/ClickHouse/issues/82889). [#83190](https://github.com/ClickHouse/ClickHouse/pull/83190) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Async logs: Limit the max number of entries that are hold in the queue. [#83214](https://github.com/ClickHouse/ClickHouse/pull/83214) ([Raúl Marín](https://github.com/Algunenano)).
* This closes [#81156](https://github.com/ClickHouse/ClickHouse/issues/81156) Same "feature" in Postgres - https://github.com/ClickHouse/ClickHouse/blob/3470af8f5e8a2b4035f33e769828707430655665/src/Databases/PostgreSQL/DatabasePostgreSQL.cpp#L126. [#83298](https://github.com/ClickHouse/ClickHouse/pull/83298) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Possibility to parse Time and Time64 as MM:SS, M:SS, SS, or S. [#83299](https://github.com/ClickHouse/ClickHouse/pull/83299) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* When `distributed_ddl_output_mode='*_only_active'`, don't wait for new or recovered replicas that have replication lag bigger than `max_replication_lag_to_enqueue`. This should help to avoid `DDL task is not finished on some hosts` when a new replica becomes active after finishing initialization or recovery, but it accumulated huge replication log while initializing. Also, implement `SYSTEM SYNC DATABASE REPLICA STRICT` query that waits for replication log to become below `max_replication_lag_to_enqueue`. [#83302](https://github.com/ClickHouse/ClickHouse/pull/83302) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Do not output too long descriptions of expression actions in exception messages. Closes [#83164](https://github.com/ClickHouse/ClickHouse/issues/83164). [#83350](https://github.com/ClickHouse/ClickHouse/pull/83350) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add ability to parse part's prefix and suffix and also check coverage for non constant columns. [#83377](https://github.com/ClickHouse/ClickHouse/pull/83377) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Function `reinterpret()` function now supports conversion to `Array(T)` where `T` is a fixed-size data type (issue [#82621](https://github.com/ClickHouse/ClickHouse/issues/82621)). [#83399](https://github.com/ClickHouse/ClickHouse/pull/83399) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Unify parameter names in ODBC and JDBC when using named collections. [#83410](https://github.com/ClickHouse/ClickHouse/pull/83410) ([Andrey Zvonov](https://github.com/zvonand)).
* When the storage is shutting down, `getStatus` throws an `ErrorCodes::ABORTED` exception. Previously, this would fail the select query. Now we catch the `ErrorCodes::ABORTED` exceptions and intentionally ignore them instead. [#83435](https://github.com/ClickHouse/ClickHouse/pull/83435) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Introduced setting `enable_vector_similarity_index` which must be enabled to use the vector similarity index. The existing setting `allow_experimental_vector_similarity_index` is now obsolete. It still works in case someone needs it. [#83459](https://github.com/ClickHouse/ClickHouse/pull/83459) ([Robert Schulze](https://github.com/rschu1ze)).
* Add process resource metrics (such as `UserTimeMicroseconds`, `SystemTimeMicroseconds`, `RealTimeMicroseconds`) to part_log profile events for `MergeParts` entries. [#83460](https://github.com/ClickHouse/ClickHouse/pull/83460) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Enable `create_if_not_exists`, `check_not_exists`, `remove_recursive` feature flags in Keeper by default which enable new types of requests. [#83488](https://github.com/ClickHouse/ClickHouse/pull/83488) ([Antonio Andelic](https://github.com/antonio2368)).
* Shutdown S3(Azure/etc)Queue streaming before shutting down any tables on server shutdown. [#83530](https://github.com/ClickHouse/ClickHouse/pull/83530) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Enable Date/Date32 as integers in JSON input formats. [#83597](https://github.com/ClickHouse/ClickHouse/pull/83597) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Added support for the **`CLICKHOUSE_HOST` environment variable** to specify the ClickHouse server host, aligning with existing `CLICKHOUSE_USER` and `CLICKHOUSE_PASSWORD` environment variables. This allows for easier configuration without modifying client or configuration files directly. [#83659](https://github.com/ClickHouse/ClickHouse/pull/83659) ([Doron David](https://github.com/dorki)).
* Made exception messages for certain situations for loading and adding projections easier to read. [#83728](https://github.com/ClickHouse/ClickHouse/pull/83728) ([Robert Schulze](https://github.com/rschu1ze)).
* Introduce a configuration option to skip binary checksum integrity checks for `clickhouse-server`. Resolves [#83637](https://github.com/ClickHouse/ClickHouse/issues/83637). [#83749](https://github.com/ClickHouse/ClickHouse/pull/83749) ([Rafael Roquetto](https://github.com/rafaelroquetto)).
* Backported in [#83994](https://github.com/ClickHouse/ClickHouse/issues/83994): Fix compatibility for cluster_function_process_archive_on_multiple_nodes. [#83968](https://github.com/ClickHouse/ClickHouse/pull/83968) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84039](https://github.com/ClickHouse/ClickHouse/issues/84039): Use information from cgroup (if applicable, i.e. `memory_worker_use_cgroup` and cgroups are available) to adjust memory tracker (`memory_worker_correct_memory_tracker`). [#83981](https://github.com/ClickHouse/ClickHouse/pull/83981) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#84599](https://github.com/ClickHouse/ClickHouse/issues/84599): S3Queue ordered mode fix: quit earlier if shutdown was called. [#84463](https://github.com/ClickHouse/ClickHouse/pull/84463) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Recalculate the min-max index when TTL reduces rows to ensure the correctness of algorithms relying on it, such as `minmax_count_projection`. This resolves [#77091](https://github.com/ClickHouse/ClickHouse/issues/77091). [#77166](https://github.com/ClickHouse/ClickHouse/pull/77166) ([Amos Bird](https://github.com/amosbird)).
* For queries with combination of `ORDER BY ... LIMIT BY ... LIMIT N`, when ORDER BY is executed as a PartialSorting, the counter `rows_before_limit_at_least` now reflects the number of rows consumed by LIMIT clause instead of number of rows consumed by sorting transform. [#78999](https://github.com/ClickHouse/ClickHouse/pull/78999) ([Eduard Karacharov](https://github.com/korowa)).
* Fix excessive granule skipping for filtering over token/ngram indexes with regexp which contains alternation and non-literal first alternative. [#79373](https://github.com/ClickHouse/ClickHouse/pull/79373) ([Eduard Karacharov](https://github.com/korowa)).
* Fix logical error with <=> operator and Join storage, now query returns proper error code. [#80165](https://github.com/ClickHouse/ClickHouse/pull/80165) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix a crash in the `loop` function when used with the `remote` function family. Ensure the LIMIT clause is respected in `loop(remote(...))`. [#80299](https://github.com/ClickHouse/ClickHouse/pull/80299) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix incorrect behavior of `to_utc_timestamp` and `from_utc_timestamp` functions when handling dates before Unix epoch (1970-01-01) and after maximum date (2106-02-07 06:28:15). Now these functions properly clamp values to epoch start and maximum date respectively. [#80498](https://github.com/ClickHouse/ClickHouse/pull/80498) ([Surya Kant Ranjan](https://github.com/iit2009046)).
* For some queries executed with parallel replicas, reading in order optimization(s) could be applied on initiator while can't be applied on remote nodes. It leads to different reading modes used by parallel replicas coordinator (on initiator) and on remoted nodes, which is a logical error. [#80652](https://github.com/ClickHouse/ClickHouse/pull/80652) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix logical error during materialize projection when column type was changed to Nullable. [#80741](https://github.com/ClickHouse/ClickHouse/pull/80741) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix incorrent TTL recalculation in TTL GROUP BY when updating TTL. [#81222](https://github.com/ClickHouse/ClickHouse/pull/81222) ([Evgeniy Ulasik](https://github.com/H0uston)).
* Fixed Parquet bloom filter incorrectly applying condition like `WHERE function(key) IN (...)` as if it were `WHERE key IN (...)`. [#81255](https://github.com/ClickHouse/ClickHouse/pull/81255) ([Michael Kolupaev](https://github.com/al13n321)).
* Fixed possible crash in `Aggregator` in case of exception during merge. [#81450](https://github.com/ClickHouse/ClickHouse/pull/81450) ([Nikita Taranov](https://github.com/nickitat)).
* Fixed `InterpreterInsertQuery::extendQueryLogElemImpl` to add backquotes to database and table names when needed (f.g., when names contain special characters like `-`). [#81528](https://github.com/ClickHouse/ClickHouse/pull/81528) ([Ilia Shvyrialkin](https://github.com/Harzu)).
* Fix `IN` execution with `transform_null_in=1` with null in the left argument and non-nullable subquery result. [#81584](https://github.com/ClickHouse/ClickHouse/pull/81584) ([Pavel Kruglov](https://github.com/Avogar)).
* Don't validate experimental/suspicious types in default/materialize expression execution during reading from existing table. [#81618](https://github.com/ClickHouse/ClickHouse/pull/81618) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix "Context has expired" during merges when dict used in TTL expression. [#81690](https://github.com/ClickHouse/ClickHouse/pull/81690) ([Azat Khuzhin](https://github.com/azat)).
* This PR might close [#80742](https://github.com/ClickHouse/ClickHouse/issues/80742). [#81722](https://github.com/ClickHouse/ClickHouse/pull/81722) ([zoomxi](https://github.com/zoomxi)).
* Fix the issue where required columns are not read during scalar correlated subquery processing. Fixes [#81716](https://github.com/ClickHouse/ClickHouse/issues/81716). [#81805](https://github.com/ClickHouse/ClickHouse/pull/81805) ([Dmitry Novik](https://github.com/novikd)).
* Someone littered our code with Kusto. Cleaned it up. This closes [#81643](https://github.com/ClickHouse/ClickHouse/issues/81643). [#81885](https://github.com/ClickHouse/ClickHouse/pull/81885) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* In previous versions, the server returned excessive content for requests to `/js`. This closes [#61890](https://github.com/ClickHouse/ClickHouse/issues/61890). [#81895](https://github.com/ClickHouse/ClickHouse/pull/81895) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Previously, `MongoDB` table engine definitions could include a path component in the `host:port` argument which was silently ignored. The mongodb integration refuses to load such tables. With this fix *we allow loading such tables and ignore path component* if `MongoDB` engine has five arguments, using the database name from arguments. *Note:* The fix is not applied for newly created tables or queries with `mongo` table function, as well as for dictionary sources and named collections. [#81942](https://github.com/ClickHouse/ClickHouse/pull/81942) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fixed possible crash in `Aggregator` in case of exception during merge. [#82022](https://github.com/ClickHouse/ClickHouse/pull/82022) ([Nikita Taranov](https://github.com/nickitat)).
* Fix filter analysis when only a constant alias column is used in the query. Fixes [#79448](https://github.com/ClickHouse/ClickHouse/issues/79448). [#82037](https://github.com/ClickHouse/ClickHouse/pull/82037) ([Dmitry Novik](https://github.com/novikd)).
* Fix LOGICAL_ERROR and following crash when using the same column in the TTL for GROUP BY and SET. [#82054](https://github.com/ClickHouse/ClickHouse/pull/82054) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix S3 table function argument validation in secret masking, preventing possible `LOGICAL_ERROR`, close [#80620](https://github.com/ClickHouse/ClickHouse/issues/80620). [#82056](https://github.com/ClickHouse/ClickHouse/pull/82056) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix data races in Iceberg. [#82088](https://github.com/ClickHouse/ClickHouse/pull/82088) ([Azat Khuzhin](https://github.com/azat)).
* Fix `DatabaseReplicated::getClusterImpl`. If the first element (or elements) of `hosts` has `id == DROPPED_MARK` and there are no other elements for the same shard, the first element of `shards` will be an empty vector, leading to `std::out_of_range`. [#82093](https://github.com/ClickHouse/ClickHouse/pull/82093) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Fixing copy-paste error in arraySimilarity, disallowing the use of UInt32 and Int32 weights. Update tests and docs. [#82103](https://github.com/ClickHouse/ClickHouse/pull/82103) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix the `Not found column` error for queries with `arrayJoin` under `WHERE` condition and `IndexSet`. [#82113](https://github.com/ClickHouse/ClickHouse/pull/82113) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix bug in glue catalog integration. Now clickhouse can read tables with nested data types where some of subcolumns contain decimals, for example: `map<string, decimal(9, 2)>`. Fixes [#81301](https://github.com/ClickHouse/ClickHouse/issues/81301). [#82114](https://github.com/ClickHouse/ClickHouse/pull/82114) ([alesapin](https://github.com/alesapin)).
* Fix performance degradation in SummingMergeTree that was intorduced in 25.5 in https://github.com/ClickHouse/ClickHouse/pull/79051. [#82130](https://github.com/ClickHouse/ClickHouse/pull/82130) ([Pavel Kruglov](https://github.com/Avogar)).
* When passing settings over uri the last value is considered. [#82137](https://github.com/ClickHouse/ClickHouse/pull/82137) ([Sema Checherinda](https://github.com/CheSema)).
* Fix "Context has expired" for Iceberg. [#82146](https://github.com/ClickHouse/ClickHouse/pull/82146) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible deadlock for remote queries when server is under memory pressure. [#82160](https://github.com/ClickHouse/ClickHouse/pull/82160) ([Kirill](https://github.com/kirillgarbar)).
* Fixes overflow in `numericIndexedVectorPointwiseAdd`, `numericIndexedVectorPointwiseSubtract`, `numericIndexedVectorPointwiseMultiply`, `numericIndexedVectorPointwiseDivide` functions that happened when we applied them to large numbers. [#82165](https://github.com/ClickHouse/ClickHouse/pull/82165) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Backported in [#84398](https://github.com/ClickHouse/ClickHouse/issues/84398): Fix rollback of Dynamic column on parsing failure. [#82169](https://github.com/ClickHouse/ClickHouse/pull/82169) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix a bug in table dependencies causing Materialized Views to miss INSERT queries. [#82222](https://github.com/ClickHouse/ClickHouse/pull/82222) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix possible data-race between suggestion thread and main client thread. [#82233](https://github.com/ClickHouse/ClickHouse/pull/82233) ([Azat Khuzhin](https://github.com/azat)).
* Now ClickHouse can read iceberg tables from Glue catalog after schema evolution. Fixes [#81272](https://github.com/ClickHouse/ClickHouse/issues/81272). [#82301](https://github.com/ClickHouse/ClickHouse/pull/82301) ([alesapin](https://github.com/alesapin)).
* Fix the validation of async metrics settings `asynchronous_metrics_update_period_s` and `asynchronous_heavy_metrics_update_period_s`. [#82310](https://github.com/ClickHouse/ClickHouse/pull/82310) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix logical error when resolving matcher in query with multiple JOINs, close [#81969](https://github.com/ClickHouse/ClickHouse/issues/81969). [#82421](https://github.com/ClickHouse/ClickHouse/pull/82421) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Add expiration to AWS ECS token so it can be reloaded. [#82422](https://github.com/ClickHouse/ClickHouse/pull/82422) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fixes a bug for `NULL` arguments in `CASE` function. [#82436](https://github.com/ClickHouse/ClickHouse/pull/82436) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix data-races in client (by not using global context) and `session_timezone` overrides (previously in case of `session_timezone` was set in i.e. `users.xml`/client options to non empty and in query context to empty, then, value from `users.xml` was used, while this is wrong, now query context will always have a priority over global context). [#82444](https://github.com/ClickHouse/ClickHouse/pull/82444) ([Azat Khuzhin](https://github.com/azat)).
* Fix disabling boundary alignment for cached buffer in external table engines. It was broken in https://github.com/ClickHouse/ClickHouse/pull/81868. [#82493](https://github.com/ClickHouse/ClickHouse/pull/82493) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix the crash if key-value storage is joined with a type-casted key. [#82497](https://github.com/ClickHouse/ClickHouse/pull/82497) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix hiding named collection values in logs/query_log. Closes [#82405](https://github.com/ClickHouse/ClickHouse/issues/82405). [#82510](https://github.com/ClickHouse/ClickHouse/pull/82510) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix a possible crash in logging while terminating a session as the user_id might sometimes be empty. [#82513](https://github.com/ClickHouse/ClickHouse/pull/82513) ([Bharat Nallan](https://github.com/bharatnc)).
* Fixes cases where parsing of Time could cause msan issues. This fixes: [#82477](https://github.com/ClickHouse/ClickHouse/issues/82477). [#82514](https://github.com/ClickHouse/ClickHouse/pull/82514) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Disallow setting `threadpool_writer_pool_size` to zero to ensure that server operations don't get stuck. [#82532](https://github.com/ClickHouse/ClickHouse/pull/82532) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix `LOGICAL_ERROR` during row policy expression analysis for correlated columns. [#82618](https://github.com/ClickHouse/ClickHouse/pull/82618) ([Dmitry Novik](https://github.com/novikd)).
* Fix incorrect usage of parent metadata in `mergeTreeProjection` table function when `enable_shared_storage_snapshot_in_query = 1`. This is for [#82634](https://github.com/ClickHouse/ClickHouse/issues/82634). [#82638](https://github.com/ClickHouse/ClickHouse/pull/82638) ([Amos Bird](https://github.com/amosbird)).
* Setting `use_skip_indexes_if_final_exact_mode` implementation (introduced in 25.6) could fail to select a relevant candidate range depending upon `MergeTree` engine settings / data distribution. That has been resolved now. [#82667](https://github.com/ClickHouse/ClickHouse/pull/82667) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Functions `trim{Left,Right,Both}` now support input strings of type "FixedString(N)". For example, `SELECT trimBoth(toFixedString('abc', 3), 'ac')` now works. [#82691](https://github.com/ClickHouse/ClickHouse/pull/82691) ([Robert Schulze](https://github.com/rschu1ze)).
* In AzureBlobStorage, for native copy we compare authentication methods, during which if we get an exception, updated the code to fallback to read and copy (i.e. non native copy). [#82693](https://github.com/ClickHouse/ClickHouse/pull/82693) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Fix deserialization of `groupArraySample`/`groupArrayLast` in case of empty elements (deserialization could skip part of the binary if the input was empty, this can lead to corruption during data read and UNKNOWN_PACKET_FROM_SERVER in TCP protocol). This does not affect numbers and date time types. [#82763](https://github.com/ClickHouse/ClickHouse/pull/82763) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix backup of an empty `Memory` table, causing the backup restore to fail with with `BACKUP_ENTRY_NOT_FOUND` error. [#82791](https://github.com/ClickHouse/ClickHouse/pull/82791) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix exception safety in union/intersect/except_default_mode rewrite. Closes [#82664](https://github.com/ClickHouse/ClickHouse/issues/82664). [#82820](https://github.com/ClickHouse/ClickHouse/pull/82820) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Keep track of the number of async tables loading jobs. If there are some running jobs, do not update `tail_ptr` in `TransactionLog::removeOldEntries`. [#82824](https://github.com/ClickHouse/ClickHouse/pull/82824) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix data races in Iceberg. [#82841](https://github.com/ClickHouse/ClickHouse/pull/82841) ([Azat Khuzhin](https://github.com/azat)).
* Setting `use_skip_indexes_if_final_exact_mode` optimization (introduced in 25.6) could fail to select a relevant candidate range depending upon `MergeTree` engine settings / data distribution. That has been resolved now. [#82879](https://github.com/ClickHouse/ClickHouse/pull/82879) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Set salt for auth data when parsing from AST with type SCRAM_SHA256_PASSWORD. [#82888](https://github.com/ClickHouse/ClickHouse/pull/82888) ([Tuan Pham Anh](https://github.com/tuanpach)).
* When using a non-caching Database implementation, the metadata of the corresponding table is deleted after the columns are returned and the reference is invalidated. [#82939](https://github.com/ClickHouse/ClickHouse/pull/82939) ([buyval01](https://github.com/buyval01)).
* Fix filter modification for queries with a JOIN expression with a table with storage `Merge`. Fixes [#82092](https://github.com/ClickHouse/ClickHouse/issues/82092). [#82950](https://github.com/ClickHouse/ClickHouse/pull/82950) ([Dmitry Novik](https://github.com/novikd)).
* Fix LOGICAL_ERROR in QueryMetricLog: Mutex cannot be NULL. [#82979](https://github.com/ClickHouse/ClickHouse/pull/82979) ([Pablo Marcos](https://github.com/pamarcos)).
* Fixed incorrect output of function `formatDateTime` when formatter `%f` is used together with variable-size formatters (e.g. `%M`). [#83020](https://github.com/ClickHouse/ClickHouse/pull/83020) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix performance degradation with the enabled analyzer when secondary queries always read all columns from the VIEWs. Fixes [#81718](https://github.com/ClickHouse/ClickHouse/issues/81718). [#83036](https://github.com/ClickHouse/ClickHouse/pull/83036) ([Dmitry Novik](https://github.com/novikd)).
* Fix misleading error message when restoring a backup on a read-only disk. [#83051](https://github.com/ClickHouse/ClickHouse/pull/83051) ([Julia Kartseva](https://github.com/jkartseva)).
* Do not check for cyclic dependencies on create table with no dependencies. It fixes performance degradation of the use cases with creation of thousands of tables that was introduced in https://github.com/ClickHouse/ClickHouse/pull/65405. [#83077](https://github.com/ClickHouse/ClickHouse/pull/83077) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixes issue with implicit reading of negative Time values into the table and make the docs not confusing. [#83091](https://github.com/ClickHouse/ClickHouse/pull/83091) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Do not use unrelated parts of a shared dictionary in the `lowCardinalityKeys` function. [#83118](https://github.com/ClickHouse/ClickHouse/pull/83118) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* After https://github.com/ClickHouse/ClickHouse/pull/79963 the usage of subcolumns in Materialized Views got broken and user might have received an error `Not found column X in block`. This behaviour is fixed. This fixes: [#82784](https://github.com/ClickHouse/ClickHouse/issues/82784). [#83221](https://github.com/ClickHouse/ClickHouse/pull/83221) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix crash in client due to connection left in disconnected state after bad INSERT. [#83253](https://github.com/ClickHouse/ClickHouse/pull/83253) ([Azat Khuzhin](https://github.com/azat)).
* Fix crash when calculating the size of a block with empty columns. [#83271](https://github.com/ClickHouse/ClickHouse/pull/83271) ([Raúl Marín](https://github.com/Algunenano)).
* Fix possible crash in Variant type in UNION. [#83295](https://github.com/ClickHouse/ClickHouse/pull/83295) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix LOGICAL_ERROR in clickhouse-local for unsupported SYSTEM queries. [#83333](https://github.com/ClickHouse/ClickHouse/pull/83333) ([Surya Kant Ranjan](https://github.com/iit2009046)).
* Fix `no_sign_request` for S3 client. It can be used to explicitly avoid signing S3 requests. It can also be defined for specific endpoints using endpoint-based settings. [#83379](https://github.com/ClickHouse/ClickHouse/pull/83379) ([Antonio Andelic](https://github.com/antonio2368)).
* Fixes a crash that may happen for a query with a setting 'max_threads=1' when executed under load with CPU scheduling enabled. [#83387](https://github.com/ClickHouse/ClickHouse/pull/83387) ([Fan Ziqi](https://github.com/f2quantum)).
* Fix `TOO_DEEP_SUBQUERIES` exception when CTE definition references another table expression with the same name. [#83413](https://github.com/ClickHouse/ClickHouse/pull/83413) ([Dmitry Novik](https://github.com/novikd)).
* Fix incorrect behavior when executing `REVOKE S3 ON system.*` revokes S3 permissions for `*.*`. This fixes [#83417](https://github.com/ClickHouse/ClickHouse/issues/83417). [#83420](https://github.com/ClickHouse/ClickHouse/pull/83420) ([pufit](https://github.com/pufit)).
* Do not share async_read_counters between queries. [#83423](https://github.com/ClickHouse/ClickHouse/pull/83423) ([Azat Khuzhin](https://github.com/azat)).
* This PR addresses issue [#81401](https://github.com/ClickHouse/ClickHouse/issues/81401) by disabling parallel replicas when a subquery contains the FINAL. [#83455](https://github.com/ClickHouse/ClickHouse/pull/83455) ([zoomxi](https://github.com/zoomxi)).
* Resolve minor integer overflow in configuration of setting `role_cache_expiration_time_seconds` (issue [#83374](https://github.com/ClickHouse/ClickHouse/issues/83374)). [#83461](https://github.com/ClickHouse/ClickHouse/pull/83461) ([wushap](https://github.com/wushap)).
* Fix a bug introduced in https://github.com/ClickHouse/ClickHouse/pull/79963. When inserting into an MV with a definer, the permission check should use the definer's grants. This fixes [#79951](https://github.com/ClickHouse/ClickHouse/issues/79951). [#83502](https://github.com/ClickHouse/ClickHouse/pull/83502) ([pufit](https://github.com/pufit)).
* Disable bounds-based file pruning for iceberg array element and iceberg map values, including all their nested subfields. [#83520](https://github.com/ClickHouse/ClickHouse/pull/83520) ([Daniil Ivanik](https://github.com/divanik)).
* Fix possible file cache not initialized errors when it's used as a temporary data storage. [#83539](https://github.com/ClickHouse/ClickHouse/pull/83539) ([Bharat Nallan](https://github.com/bharatnc)).
* Keeper fix: update total watch count correctly when ephemeral nodes are deleted on session close. [#83583](https://github.com/ClickHouse/ClickHouse/pull/83583) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix incorrect memory around max_untracked_memory. [#83607](https://github.com/ClickHouse/ClickHouse/pull/83607) ([Azat Khuzhin](https://github.com/azat)).
* INSERT SELECT with UNION ALL could lead to a null pointer dereference in a corner case. This closes [#83618](https://github.com/ClickHouse/ClickHouse/issues/83618). [#83643](https://github.com/ClickHouse/ClickHouse/pull/83643) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83899](https://github.com/ClickHouse/ClickHouse/issues/83899): Skip unavailable nodes during INSERT SELECT from s3Cluster() into replicated MergeTree. [#83676](https://github.com/ClickHouse/ClickHouse/pull/83676) ([Igor Nikonov](https://github.com/devcrafter)).
* Disallow zero value for max_insert_block_size as it could cause logical error. [#83688](https://github.com/ClickHouse/ClickHouse/pull/83688) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix endless loop in estimateCompressionRatio() with block_size_bytes=0. [#83704](https://github.com/ClickHouse/ClickHouse/pull/83704) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#84111](https://github.com/ClickHouse/ClickHouse/issues/84111): Mask Avro schema registry authentication details to be not visible to user or in logs. [#83713](https://github.com/ClickHouse/ClickHouse/pull/83713) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Fix `IndexUncompressedCacheBytes`/`IndexUncompressedCacheCells`/`IndexMarkCacheBytes`/`IndexMarkCacheFiles` metrics (previously they were included into metric w/o `Cache` prefix). [#83730](https://github.com/ClickHouse/ClickHouse/pull/83730) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#83919](https://github.com/ClickHouse/ClickHouse/issues/83919): Fix the issue where, if a MergeTree table is created with `add_minmax_index_for_numeric_columns=1` or `add_minmax_index_for_string_columns=1`, the index is later materialized during an ALTER operation, and it prevents the Replicated database from initializing correctly on a new replica. [#83751](https://github.com/ClickHouse/ClickHouse/pull/83751) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix possible abort (due to joining threads from the task) and hopefully hungs (in unit tests) during `BackgroundSchedulePool` shutdown. [#83769](https://github.com/ClickHouse/ClickHouse/pull/83769) ([Azat Khuzhin](https://github.com/azat)).
* Introduce backward compatibility setting to allow new analyzer to reference outer alias in WITH clause in the case of name clashes. Fixes [#82700](https://github.com/ClickHouse/ClickHouse/issues/82700). [#83797](https://github.com/ClickHouse/ClickHouse/pull/83797) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#84060](https://github.com/ClickHouse/ClickHouse/issues/84060): When restoring from backup, the definer user may not be backed up, which will cause the whole backup to be broken. To fix this, we postpone the permissions check on the target table's creation during restore and only check it during runtime. [#83818](https://github.com/ClickHouse/ClickHouse/pull/83818) ([pufit](https://github.com/pufit)).
* Fix deadlock on shutdown due to recursive context locking during library bridge cleanup. [#83824](https://github.com/ClickHouse/ClickHouse/pull/83824) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#84226](https://github.com/ClickHouse/ClickHouse/issues/84226): Allow referencing any table in `view(...)` argument of `remote` table function with enabled analyzer. Fixes [#78717](https://github.com/ClickHouse/ClickHouse/issues/78717). Fixes [#79377](https://github.com/ClickHouse/ClickHouse/issues/79377). [#83844](https://github.com/ClickHouse/ClickHouse/pull/83844) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83952](https://github.com/ClickHouse/ClickHouse/issues/83952): Onprogress call in jsoneachrowwithprogress is synchronized with finalization. [#83879](https://github.com/ClickHouse/ClickHouse/pull/83879) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#83966](https://github.com/ClickHouse/ClickHouse/issues/83966): Fix colorSRGBToOKLCH/colorOKLCHToSRGB for mix of const and non-const args. [#83906](https://github.com/ClickHouse/ClickHouse/pull/83906) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#84131](https://github.com/ClickHouse/ClickHouse/issues/84131): Fix rare bug when `MATERIALIZE COLUMN` query could lead to unexpected files in `checksums.txt` and eventually detached data parts. [#84007](https://github.com/ClickHouse/ClickHouse/pull/84007) ([alesapin](https://github.com/alesapin)).
* Backported in [#84342](https://github.com/ClickHouse/ClickHouse/issues/84342): Fix crash with clickhouse client when used in interactive mode with syntax highlighting. [#84025](https://github.com/ClickHouse/ClickHouse/pull/84025) ([Bharat Nallan](https://github.com/bharatnc)).
* Backported in [#84274](https://github.com/ClickHouse/ClickHouse/issues/84274): Fixed wrong results when the query condition cache is used in conjunction with recursive CTEs (issue [#81506](https://github.com/ClickHouse/ClickHouse/issues/81506)). [#84026](https://github.com/ClickHouse/ClickHouse/pull/84026) ([zhongyuankai](https://github.com/zhongyuankai)).
* Backported in [#84462](https://github.com/ClickHouse/ClickHouse/issues/84462): Fix filter merging into JOIN condition in cases when equality operands have different types or they reference constants. Fixes [#83432](https://github.com/ClickHouse/ClickHouse/issues/83432). [#84145](https://github.com/ClickHouse/ClickHouse/pull/84145) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#84290](https://github.com/ClickHouse/ClickHouse/issues/84290): Fix rare clickhouse crash when table has projection, `lightweight_mutation_projection_mode = 'rebuild'` and user execute lighweight delete which deletes ALL rows from any block in table. [#84158](https://github.com/ClickHouse/ClickHouse/pull/84158) ([alesapin](https://github.com/alesapin)).
* Backported in [#84554](https://github.com/ClickHouse/ClickHouse/issues/84554): Fix deadlock caused by background cancellation checker thread. [#84203](https://github.com/ClickHouse/ClickHouse/pull/84203) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84495](https://github.com/ClickHouse/ClickHouse/issues/84495): Fixed incorrect construction of empty tuples in the `array()` function. This fixes [#84202](https://github.com/ClickHouse/ClickHouse/issues/84202). [#84297](https://github.com/ClickHouse/ClickHouse/pull/84297) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#84507](https://github.com/ClickHouse/ClickHouse/issues/84507): Fixed a logical error in lightweight updates that update all columns in the table. [#84380](https://github.com/ClickHouse/ClickHouse/pull/84380) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#84455](https://github.com/ClickHouse/ClickHouse/issues/84455): Make `zoutofmemory` hardware error, otherwise it will throw logical error. see https://github.com/clickhouse/clickhouse-core-incidents/issues/877. [#84420](https://github.com/ClickHouse/ClickHouse/pull/84420) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#84654](https://github.com/ClickHouse/ClickHouse/issues/84654): Fix out-of-order writes to Keeper changelog. Previously, we could have in-flight writes to changelog, but rollback could cause concurrent change of the destination file. This would lead to inconsistent logs, and possible data loss. [#84434](https://github.com/ClickHouse/ClickHouse/pull/84434) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84533](https://github.com/ClickHouse/ClickHouse/issues/84533): Now if all TTL are removed from table MergeTree will do nothing related to TTL. [#84441](https://github.com/ClickHouse/ClickHouse/pull/84441) ([alesapin](https://github.com/alesapin)).
* Backported in [#84636](https://github.com/ClickHouse/ClickHouse/issues/84636): Parallel distributed INSERT SELECT with LIMIT was allowed which is not correct, it leads to data duplication in target table. [#84477](https://github.com/ClickHouse/ClickHouse/pull/84477) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#84571](https://github.com/ClickHouse/ClickHouse/issues/84571): Fix pruning files by virtual column in data lakes. [#84520](https://github.com/ClickHouse/ClickHouse/pull/84520) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84634](https://github.com/ClickHouse/ClickHouse/issues/84634): Change pre-25.5 value of `allow_experimental_delta_kernel_rs` to `false` for compatibility. [#84587](https://github.com/ClickHouse/ClickHouse/pull/84587) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Build/Testing/Packaging Improvement
* Build a minimal C library (10 KB) for the ClickHouse lexer. This is needed for [#80977](https://github.com/ClickHouse/ClickHouse/issues/80977). [#81347](https://github.com/ClickHouse/ClickHouse/pull/81347) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a check for Nix submodule inputs. [#81691](https://github.com/ClickHouse/ClickHouse/pull/81691) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Compile SymbolIndex on Mac and FreeBSD. (But it will work only on ELF systems, Linux and FreeBSD). [#82347](https://github.com/ClickHouse/ClickHouse/pull/82347) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for standalone lexer, add test tag `fasttest-only`. [#82472](https://github.com/ClickHouse/ClickHouse/pull/82472) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Add license generation script to the build digest. [#82615](https://github.com/ClickHouse/ClickHouse/pull/82615) ([Raúl Marín](https://github.com/Algunenano)).
* Apply fix for CVE-2025-6375 in Poco from upstream. [#82647](https://github.com/ClickHouse/ClickHouse/pull/82647) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `libarchive` 3.8.1. [#82648](https://github.com/ClickHouse/ClickHouse/pull/82648) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `libxml2` v2.14.4. [#82649](https://github.com/ClickHouse/ClickHouse/pull/82649) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `expat` 2.7.1 inside Poco. [#82661](https://github.com/ClickHouse/ClickHouse/pull/82661) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Bumped Azure SDK to v1.15.0. [#82747](https://github.com/ClickHouse/ClickHouse/pull/82747) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Add storage module from google-cloud-cpp to build system. [#82881](https://github.com/ClickHouse/ClickHouse/pull/82881) ([Pablo Marcos](https://github.com/pamarcos)).
* Change `Dockerfile.ubuntu` for clickhouse-server to fit requirements in Docker Official Library. [#83039](https://github.com/ClickHouse/ClickHouse/pull/83039) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* A follow-up for [#83158](https://github.com/ClickHouse/ClickHouse/issues/83158) to fix uploading builds to `curl clickhouse.com`. [#83463](https://github.com/ClickHouse/ClickHouse/pull/83463) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Adding `busybox` binary and install tools in `clickhouse/clickhouse-server` and official `clickhouse` images. [#83735](https://github.com/ClickHouse/ClickHouse/pull/83735) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Increase timeout for test_ttl_compatibility under sanitizers. [#83789](https://github.com/ClickHouse/ClickHouse/pull/83789) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NO CL CATEGORY

* Backported in [#83938](https://github.com/ClickHouse/ClickHouse/issues/83938):. [#83930](https://github.com/ClickHouse/ClickHouse/pull/83930) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#84525](https://github.com/ClickHouse/ClickHouse/issues/84525):. [#84475](https://github.com/ClickHouse/ClickHouse/pull/84475) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Fix data race in `reportBrokenPart`"'. [#81909](https://github.com/ClickHouse/ClickHouse/pull/81909) ([Azat Khuzhin](https://github.com/azat)).
* NO CL ENTRY:  'Revert "Experiment with jemalloc configs"'. [#81960](https://github.com/ClickHouse/ClickHouse/pull/81960) ([Azat Khuzhin](https://github.com/azat)).
* NO CL ENTRY:  'Revert "Fix handling exception in `Aggregator::mergeBlocks`"'. [#81975](https://github.com/ClickHouse/ClickHouse/pull/81975) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'Revert "Move logging to a separate thread"'. [#82068](https://github.com/ClickHouse/ClickHouse/pull/82068) ([Azat Khuzhin](https://github.com/azat)).
* NO CL ENTRY:  'Revert "Using file offsets instead of virtual memory addresses in `system.symbols` and `addressToSymbol`"'. [#82372](https://github.com/ClickHouse/ClickHouse/pull/82372) ([Azat Khuzhin](https://github.com/azat)).
* NO CL ENTRY:  'Revert "Add _part_granule_offset column"'. [#82640](https://github.com/ClickHouse/ClickHouse/pull/82640) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Write to Merge storage"'. [#82771](https://github.com/ClickHouse/ClickHouse/pull/82771) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Revert "Add _part_granule_offset column""'. [#82808](https://github.com/ClickHouse/ClickHouse/pull/82808) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Find the correct starting candidate range in findPKRangesForFinalAfterSkipIndexImpl()"'. [#82853](https://github.com/ClickHouse/ClickHouse/pull/82853) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Refactoring of dynamic resize feature of filesystem cache"'. [#82868](https://github.com/ClickHouse/ClickHouse/pull/82868) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Revert "Refactoring of dynamic resize feature of filesystem cache""'. [#82896](https://github.com/ClickHouse/ClickHouse/pull/82896) ([Kseniia Sumarokova](https://github.com/kssenii)).
* NO CL ENTRY:  'Revert "Refactor how IInputFormat deals with reading many files at once"'. [#82934](https://github.com/ClickHouse/ClickHouse/pull/82934) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "UNION – unify types with Variant if needed "'. [#83010](https://github.com/ClickHouse/ClickHouse/pull/83010) ([Pavel Kruglov](https://github.com/Avogar)).
* NO CL ENTRY:  'Revert "Enable parallel distributed insert select by default"'. [#83018](https://github.com/ClickHouse/ClickHouse/pull/83018) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Merge pull request [#78841](https://github.com/ClickHouse/ClickHouse/issues/78841) from ClickHouse/improve-ordinary-database-warning"'. [#83049](https://github.com/ClickHouse/ClickHouse/pull/83049) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Add SZ3 compression codec"'. [#83076](https://github.com/ClickHouse/ClickHouse/pull/83076) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Reintroduce async logging"'. [#83116](https://github.com/ClickHouse/ClickHouse/pull/83116) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Revert "Reintroduce async logging""'. [#83121](https://github.com/ClickHouse/ClickHouse/pull/83121) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Compress logs and profile events in the native protocol"'. [#83490](https://github.com/ClickHouse/ClickHouse/pull/83490) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Do not build stripped binary by default"'. [#83492](https://github.com/ClickHouse/ClickHouse/pull/83492) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Vector search by reading only the vector similarity index"'. [#83709](https://github.com/ClickHouse/ClickHouse/pull/83709) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "[core dumps] exclude sensitive data"'. [#83856](https://github.com/ClickHouse/ClickHouse/pull/83856) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Backport [#84026](https://github.com/ClickHouse/ClickHouse/issues/84026) to 25.7: Disable query condition cache for recursive CTEs"'. [#84407](https://github.com/ClickHouse/ClickHouse/pull/84407) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Fix query condition cache usage with non-deterministic IN sets'. [#84585](https://github.com/ClickHouse/ClickHouse/pull/84585) ([Robert Schulze](https://github.com/rschu1ze)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* MultiSelect operation for MergeSelectors. [#77405](https://github.com/ClickHouse/ClickHouse/pull/77405) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix logical error in DwarfBlockInputFormat. [#78656](https://github.com/ClickHouse/ClickHouse/pull/78656) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix refresh time randomization. [#78702](https://github.com/ClickHouse/ClickHouse/pull/78702) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix 'Unexpected exception in refresh scheduling'. [#79318](https://github.com/ClickHouse/ClickHouse/pull/79318) ([Michael Kolupaev](https://github.com/al13n321)).
* Add test for [#78907](https://github.com/ClickHouse/ClickHouse/issues/78907). [#80840](https://github.com/ClickHouse/ClickHouse/pull/80840) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Refactor how IInputFormat deals with reading many files at once. [#80931](https://github.com/ClickHouse/ClickHouse/pull/80931) ([Michael Kolupaev](https://github.com/al13n321)).
* Just moving important class to a separate file. Nothing special. [#81069](https://github.com/ClickHouse/ClickHouse/pull/81069) ([alesapin](https://github.com/alesapin)).
* Do not send full exception message in reporting of logical errors. [#81416](https://github.com/ClickHouse/ClickHouse/pull/81416) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Post CI summary in PR comment. [#81471](https://github.com/ClickHouse/ClickHouse/pull/81471) ([Max Kainov](https://github.com/maxknv)).
* Preserve connection when final empty chunk is left by client. [#81597](https://github.com/ClickHouse/ClickHouse/pull/81597) ([Sema Checherinda](https://github.com/CheSema)).
* Include info about the current repository into CI logs cluster. [#81816](https://github.com/ClickHouse/ClickHouse/pull/81816) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* CI: Remove unused files. [#81873](https://github.com/ClickHouse/ClickHouse/pull/81873) ([Max Kainov](https://github.com/maxknv)).
* Update version after release. [#81914](https://github.com/ClickHouse/ClickHouse/pull/81914) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* tests: improve stateless tests for clickhouse-server. [#81916](https://github.com/ClickHouse/ClickHouse/pull/81916) ([Azat Khuzhin](https://github.com/azat)).
* Fix `test_keeper_snapshot_on_exit`. [#81922](https://github.com/ClickHouse/ClickHouse/pull/81922) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix `test_keeper_invalid_digest`. [#81925](https://github.com/ClickHouse/ClickHouse/pull/81925) ([Antonio Andelic](https://github.com/antonio2368)).
* CI: Fix corner case in changed files check. [#81941](https://github.com/ClickHouse/ClickHouse/pull/81941) ([Max Kainov](https://github.com/maxknv)).
* ci: enable tests tracing for flaky check. [#81943](https://github.com/ClickHouse/ClickHouse/pull/81943) ([Azat Khuzhin](https://github.com/azat)).
* Minor fixes for 25.6 settings. [#81947](https://github.com/ClickHouse/ClickHouse/pull/81947) ([Raúl Marín](https://github.com/Algunenano)).
* Update README.md. [#81961](https://github.com/ClickHouse/ClickHouse/pull/81961) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* CI: Fix parse error in functional tests. [#81962](https://github.com/ClickHouse/ClickHouse/pull/81962) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix minio access denied failure. [#81965](https://github.com/ClickHouse/ClickHouse/pull/81965) ([Max Kainov](https://github.com/maxknv)).
* Fix: set Expression description after moving Filter to prewhere. [#81970](https://github.com/ClickHouse/ClickHouse/pull/81970) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix test_refreshable_mat_view_replicated test_append flakiness. [#81973](https://github.com/ClickHouse/ClickHouse/pull/81973) ([Michael Kolupaev](https://github.com/al13n321)).
* Do commit the implicit transaction before query_finish_callback because:. [#81989](https://github.com/ClickHouse/ClickHouse/pull/81989) ([Tuan Pham Anh](https://github.com/tuanpach)).
* CI: Fixes for GH summary comment. [#81997](https://github.com/ClickHouse/ClickHouse/pull/81997) ([Max Kainov](https://github.com/maxknv)).
* Next update for `La Casa Del Dolor` and small fixes. [#81998](https://github.com/ClickHouse/ClickHouse/pull/81998) ([Pedro Ferreira](https://github.com/PedroTadim)).
* If merge task was cancelled it may cancel the single column merge and in this case this error will be thrown. [#82000](https://github.com/ClickHouse/ClickHouse/pull/82000) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Msan fix of sparse grams. this closes https://github.com/clickhouse/clickhouse/issues/81903. [#82002](https://github.com/ClickHouse/ClickHouse/pull/82002) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Inject authentication for Keeper session randomly in checks. [#82006](https://github.com/ClickHouse/ClickHouse/pull/82006) ([Antonio Andelic](https://github.com/antonio2368)).
* CI: Improve report. [#82007](https://github.com/ClickHouse/ClickHouse/pull/82007) ([Max Kainov](https://github.com/maxknv)).
* Fix: avoid stale connections with -Cluster functions. [#82018](https://github.com/ClickHouse/ClickHouse/pull/82018) ([Igor Nikonov](https://github.com/devcrafter)).
* Update version_date.tsv and changelog after v25.4.7.66-stable. [#82020](https://github.com/ClickHouse/ClickHouse/pull/82020) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Respect MemoryTracker for ORC format. [#82038](https://github.com/ClickHouse/ClickHouse/pull/82038) ([Azat Khuzhin](https://github.com/azat)).
* Broken in https://github.com/ClickHouse/ClickHouse/pull/81245. [#82039](https://github.com/ClickHouse/ClickHouse/pull/82039) ([Alexander Tokmakov](https://github.com/tavplubix)).
* CI: Team notifications hook. [#82042](https://github.com/ClickHouse/ClickHouse/pull/82042) ([Max Kainov](https://github.com/maxknv)).
* test: disable parallel run for test_backup_restore_on_cluster/test_concurrency.py. [#82044](https://github.com/ClickHouse/ClickHouse/pull/82044) ([Azat Khuzhin](https://github.com/azat)).
* tests: limit concurrency in 03540_system_dashboards (to fix possible flakiness). [#82046](https://github.com/ClickHouse/ClickHouse/pull/82046) ([Azat Khuzhin](https://github.com/azat)).
* CI: Show entire stack trace in Fatal messages info. [#82049](https://github.com/ClickHouse/ClickHouse/pull/82049) ([Max Kainov](https://github.com/maxknv)).
* Simplify variable naming. [#82053](https://github.com/ClickHouse/ClickHouse/pull/82053) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix possible uncaught exception in offloaded serialization. [#82065](https://github.com/ClickHouse/ClickHouse/pull/82065) ([Azat Khuzhin](https://github.com/azat)).
* fix flaky test_storage_url_http_headers. [#82066](https://github.com/ClickHouse/ClickHouse/pull/82066) ([Bharat Nallan](https://github.com/bharatnc)).
* tests: fix SMT rewriter in case of test restarts. [#82071](https://github.com/ClickHouse/ClickHouse/pull/82071) ([Azat Khuzhin](https://github.com/azat)).
* Fix refreshable MV throwing 'Shutdown is called for table'. [#82072](https://github.com/ClickHouse/ClickHouse/pull/82072) ([Michael Kolupaev](https://github.com/al13n321)).
* tests/01161_all_system_tables: disable it for S3 and simplify. [#82074](https://github.com/ClickHouse/ClickHouse/pull/82074) ([Azat Khuzhin](https://github.com/azat)).
* Try fix flaky test_dns_cache::test_user_access_ip_change. [#82075](https://github.com/ClickHouse/ClickHouse/pull/82075) ([Bharat Nallan](https://github.com/bharatnc)).
* Add session_timeout_ms to system.zookeeper_connection. [#82076](https://github.com/ClickHouse/ClickHouse/pull/82076) ([Azat Khuzhin](https://github.com/azat)).
* ci: relax local disk checks (increase local_disk_check_period_ms). [#82077](https://github.com/ClickHouse/ClickHouse/pull/82077) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix flaky 03403_read_in_order_streams_memory_usage (increase memory limit). [#82090](https://github.com/ClickHouse/ClickHouse/pull/82090) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix report links for reused artifacts. [#82107](https://github.com/ClickHouse/ClickHouse/pull/82107) ([Max Kainov](https://github.com/maxknv)).
* The script has had a bug for `trace_log` creation, as well as a manually calculated `sipHash` hidden deep in the internals. This fixes both. [#82109](https://github.com/ClickHouse/ClickHouse/pull/82109) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix bloom filter index column selection for mapContains functions. [#82110](https://github.com/ClickHouse/ClickHouse/pull/82110) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Keeper: some small digest and auth related fixes. [#82111](https://github.com/ClickHouse/ClickHouse/pull/82111) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix crash in flattened Dynamic serialization. [#82117](https://github.com/ClickHouse/ClickHouse/pull/82117) ([Pavel Kruglov](https://github.com/Avogar)).
* CI: Enable auto merge in backports. [#82119](https://github.com/ClickHouse/ClickHouse/pull/82119) ([Max Kainov](https://github.com/maxknv)).
* Update README.md. [#82129](https://github.com/ClickHouse/ClickHouse/pull/82129) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* CI: Move test check from pre to post hook. [#82150](https://github.com/ClickHouse/ClickHouse/pull/82150) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix upgrade check job. [#82156](https://github.com/ClickHouse/ClickHouse/pull/82156) ([Max Kainov](https://github.com/maxknv)).
* CI: Functional tests: fix attached artifacts. [#82158](https://github.com/ClickHouse/ClickHouse/pull/82158) ([Max Kainov](https://github.com/maxknv)).
* Follow up to [#81868](https://github.com/ClickHouse/ClickHouse/issues/81868). [#82163](https://github.com/ClickHouse/ClickHouse/pull/82163) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update version_date.tsv and changelog after v25.5.3.75-stable. [#82166](https://github.com/ClickHouse/ClickHouse/pull/82166) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix build of mysqlxx_pool_test. [#82167](https://github.com/ClickHouse/ClickHouse/pull/82167) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix expect test that interacts with bash. [#82168](https://github.com/ClickHouse/ClickHouse/pull/82168) ([Azat Khuzhin](https://github.com/azat)).
* Apply changes to the settings in httphandler earlier. [#82191](https://github.com/ClickHouse/ClickHouse/pull/82191) ([Sema Checherinda](https://github.com/CheSema)).
* parallel format flushes at final. [#82192](https://github.com/ClickHouse/ClickHouse/pull/82192) ([Sema Checherinda](https://github.com/CheSema)).
* attach to a group more accurate. [#82193](https://github.com/ClickHouse/ClickHouse/pull/82193) ([Sema Checherinda](https://github.com/CheSema)).
* Rename haveExplicitNames and have_explicit_names. [#82194](https://github.com/ClickHouse/ClickHouse/pull/82194) ([Pablo Marcos](https://github.com/pamarcos)).
* Make `use_legacy_to_time` not important. [#82195](https://github.com/ClickHouse/ClickHouse/pull/82195) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* CI: Do not crash FT job on stateful data prepare. [#82204](https://github.com/ClickHouse/ClickHouse/pull/82204) ([Max Kainov](https://github.com/maxknv)).
* ci: fix capturing server logs (from /var/log) with clickhouse-local. [#82220](https://github.com/ClickHouse/ClickHouse/pull/82220) ([Azat Khuzhin](https://github.com/azat)).
* tests: fail the test itself in case of Fatal/sanitizer alerts. [#82234](https://github.com/ClickHouse/ClickHouse/pull/82234) ([Azat Khuzhin](https://github.com/azat)).
* Rename test. [#82238](https://github.com/ClickHouse/ClickHouse/pull/82238) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Having disabled tests is prohibited. [#82249](https://github.com/ClickHouse/ClickHouse/pull/82249) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove tests for zero-copy replication. [#82250](https://github.com/ClickHouse/ClickHouse/pull/82250) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Separate log for clickhouse-local in functional tests. [#82257](https://github.com/ClickHouse/ClickHouse/pull/82257) ([Max Kainov](https://github.com/maxknv)).
* If operation is disabled via feature flag include node's path into error message. [#82265](https://github.com/ClickHouse/ClickHouse/pull/82265) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix compatibility for `use_legacy_to_time`. It should be enabled on old instances. [#82271](https://github.com/ClickHouse/ClickHouse/pull/82271) ([Nikita Fomichev](https://github.com/fm4v)).
* Fix always match case for the searchAny function. [#82272](https://github.com/ClickHouse/ClickHouse/pull/82272) ([Elmi Ahmadov](https://github.com/ahmadov)).
* CI: Move docker files and remove deprecated ci scripts. [#82273](https://github.com/ClickHouse/ClickHouse/pull/82273) ([Max Kainov](https://github.com/maxknv)).
* Try fix test_database_delta/test.py::test_timestamp_ntz. [#82274](https://github.com/ClickHouse/ClickHouse/pull/82274) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CI: Fix azure functional tests. [#82282](https://github.com/ClickHouse/ClickHouse/pull/82282) ([Max Kainov](https://github.com/maxknv)).
* Better 'uuid' macro exception. [#82284](https://github.com/ClickHouse/ClickHouse/pull/82284) ([Nikolay Degterinsky](https://github.com/evillique)).
* Sync changes. [#82287](https://github.com/ClickHouse/ClickHouse/pull/82287) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CI: Post CI summary from finish job only. [#82288](https://github.com/ClickHouse/ClickHouse/pull/82288) ([Max Kainov](https://github.com/maxknv)).
* Change search functions interface to accept array instead of string. [#82299](https://github.com/ClickHouse/ClickHouse/pull/82299) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Add comment to bypass large objects check. [#82300](https://github.com/ClickHouse/ClickHouse/pull/82300) ([Pablo Marcos](https://github.com/pamarcos)).
* ci: fix stress tests (disable auth injection in keeper). [#82307](https://github.com/ClickHouse/ClickHouse/pull/82307) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix fatal/sanitizers log unlink. [#82342](https://github.com/ClickHouse/ClickHouse/pull/82342) ([Azat Khuzhin](https://github.com/azat)).
* Bump usearch from 2.17.7 to 2.17.12. [#82343](https://github.com/ClickHouse/ClickHouse/pull/82343) ([Robert Schulze](https://github.com/rschu1ze)).
* CI/Tests: Sync with private. [#82344](https://github.com/ClickHouse/ClickHouse/pull/82344) ([Nikita Fomichev](https://github.com/fm4v)).
* tests: various tiny fixes for clickhouse-test. [#82353](https://github.com/ClickHouse/ClickHouse/pull/82353) ([Azat Khuzhin](https://github.com/azat)).
* CI: Functional tests: fix scraping system tables. [#82356](https://github.com/ClickHouse/ClickHouse/pull/82356) ([Max Kainov](https://github.com/maxknv)).
* Replacing Block with Columns in HashJoin state. [#82358](https://github.com/ClickHouse/ClickHouse/pull/82358) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Mark functions `searchAll` and `searchAny` as experimental. [#82359](https://github.com/ClickHouse/ClickHouse/pull/82359) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Ensure minio is started before starting ch. [#82360](https://github.com/ClickHouse/ClickHouse/pull/82360) ([Max Kainov](https://github.com/maxknv)).
* CI: Functional tests: sort by status. [#82367](https://github.com/ClickHouse/ClickHouse/pull/82367) ([Max Kainov](https://github.com/maxknv)).
* Changelog 25.6. [#82375](https://github.com/ClickHouse/ClickHouse/pull/82375) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Some renames in bech32. [#82376](https://github.com/ClickHouse/ClickHouse/pull/82376) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added some more server settings for `La Casa Del Dolor`. - Experiment killing running mutations. - Fix when creating a view, make sure columns are available when generating expressions. - Add lag and lead window functions. - Cleaned expression generation to be fairer in BuzzHouse. - Added `table.*` expressions. [#82386](https://github.com/ClickHouse/ClickHouse/pull/82386) ([Pedro Ferreira](https://github.com/PedroTadim)).
* CI: Use same inject auth value for all nodes. [#82387](https://github.com/ClickHouse/ClickHouse/pull/82387) ([Antonio Andelic](https://github.com/antonio2368)).
* Bundle chdig into clickhouse binary. [#82388](https://github.com/ClickHouse/ClickHouse/pull/82388) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.3.4.190-lts. [#82389](https://github.com/ClickHouse/ClickHouse/pull/82389) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Disable `03532_crash_in_aggregation_because_of_lost_exception` with distr. [#82399](https://github.com/ClickHouse/ClickHouse/pull/82399) ([Nikita Taranov](https://github.com/nickitat)).
* Add FIPS libs to stateless image. [#82415](https://github.com/ClickHouse/ClickHouse/pull/82415) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* CI: Docker files clean up. [#82418](https://github.com/ClickHouse/ClickHouse/pull/82418) ([Max Kainov](https://github.com/maxknv)).
* tests: fix sanitizers reports (log_path contains prefix, not the file path). [#82423](https://github.com/ClickHouse/ClickHouse/pull/82423) ([Azat Khuzhin](https://github.com/azat)).
* Test s3Cluster() with restarting server. [#82427](https://github.com/ClickHouse/ClickHouse/pull/82427) ([Igor Nikonov](https://github.com/devcrafter)).
* Revert "Merge pull request [#81347](https://github.com/ClickHouse/ClickHouse/issues/81347) from ClickHouse/lexer-standalone". [#82433](https://github.com/ClickHouse/ClickHouse/pull/82433) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* CI: Fix praktika.gh.post_pr_comment. [#82437](https://github.com/ClickHouse/ClickHouse/pull/82437) ([Max Kainov](https://github.com/maxknv)).
* Remove `clickhouse_functions_text` library and make search functions part of `libdbms`. [#82442](https://github.com/ClickHouse/ClickHouse/pull/82442) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fix test_refreshable_mv_in_replicated_db flakiness yet again. [#82462](https://github.com/ClickHouse/ClickHouse/pull/82462) ([Michael Kolupaev](https://github.com/al13n321)).
* fix bug fix validation script. [#82465](https://github.com/ClickHouse/ClickHouse/pull/82465) ([Bharat Nallan](https://github.com/bharatnc)).
* tests: ignore "ASan doesn't fully support makecontext/swapcontext functions and may produce false positives in some cases!". [#82474](https://github.com/ClickHouse/ClickHouse/pull/82474) ([Azat Khuzhin](https://github.com/azat)).
* Update the clickhouse local command. [#82475](https://github.com/ClickHouse/ClickHouse/pull/82475) ([Tuan Pham Anh](https://github.com/tuanpach)).
* tests: make 03443_shared_storage_snapshots more stable. [#82476](https://github.com/ClickHouse/ClickHouse/pull/82476) ([Azat Khuzhin](https://github.com/azat)).
* Ping reopened ignored cherrypick PRs. [#82479](https://github.com/ClickHouse/ClickHouse/pull/82479) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Style: Forbid the use of quotes for includes (programs and utils). [#82483](https://github.com/ClickHouse/ClickHouse/pull/82483) ([Raúl Marín](https://github.com/Algunenano)).
* Fix settings changes after backport. [#82484](https://github.com/ClickHouse/ClickHouse/pull/82484) ([Raúl Marín](https://github.com/Algunenano)).
* Sync settings from cloud. [#82492](https://github.com/ClickHouse/ClickHouse/pull/82492) ([Alexander Gololobov](https://github.com/davenger)).
* Fix injecting auth in Keeper in CI. [#82507](https://github.com/ClickHouse/ClickHouse/pull/82507) ([Antonio Andelic](https://github.com/antonio2368)).
* Miscellaneous. [#82512](https://github.com/ClickHouse/ClickHouse/pull/82512) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Restore tz randomization in Functional Tests. [#82526](https://github.com/ClickHouse/ClickHouse/pull/82526) ([Max Kainov](https://github.com/maxknv)).
* Add a setting to preserve old behaviour of dateTrunc function. [#82530](https://github.com/ClickHouse/ClickHouse/pull/82530) ([Pavel Kruglov](https://github.com/Avogar)).
* Multithreaded benchmarks with c++expr. [#82534](https://github.com/ClickHouse/ClickHouse/pull/82534) ([Sergei Trifonov](https://github.com/serxa)).
* Allow writing `ch dig`. [#82540](https://github.com/ClickHouse/ClickHouse/pull/82540) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* ci: fix waiting for queries in stress check. [#82562](https://github.com/ClickHouse/ClickHouse/pull/82562) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix logs export config in stress tests. [#82597](https://github.com/ClickHouse/ClickHouse/pull/82597) ([Max Kainov](https://github.com/maxknv)).
* Add error response for getSessionID. [#82600](https://github.com/ClickHouse/ClickHouse/pull/82600) ([JIaQi](https://github.com/JiaQiTang98)).
* CI: Run 00002_log_and_exception_messages_formatting in the end. [#82602](https://github.com/ClickHouse/ClickHouse/pull/82602) ([Max Kainov](https://github.com/maxknv)).
* Fix 01276_system_licenses after including rust licenses. [#82603](https://github.com/ClickHouse/ClickHouse/pull/82603) ([Raúl Marín](https://github.com/Algunenano)).
* Trying to get rid of second S3Settings. [#82604](https://github.com/ClickHouse/ClickHouse/pull/82604) ([alesapin](https://github.com/alesapin)).
* Update setup_ch_cluster.sh. [#82605](https://github.com/ClickHouse/ClickHouse/pull/82605) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update 02995_new_settings_history for 25.7+. [#82611](https://github.com/ClickHouse/ClickHouse/pull/82611) ([Raúl Marín](https://github.com/Algunenano)).
* Update clickhouse_proc.py. [#82619](https://github.com/ClickHouse/ClickHouse/pull/82619) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update CHANGELOG.md. [#82624](https://github.com/ClickHouse/ClickHouse/pull/82624) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add an option to skip tests failing in FIPS mode. [#82630](https://github.com/ClickHouse/ClickHouse/pull/82630) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Update README.md. [#82650](https://github.com/ClickHouse/ClickHouse/pull/82650) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix distributed_cache_credentials_refresh_period_seconds default value. [#82653](https://github.com/ClickHouse/ClickHouse/pull/82653) ([Raúl Marín](https://github.com/Algunenano)).
* Next fuzzer fixes. [#82654](https://github.com/ClickHouse/ClickHouse/pull/82654) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Update version_date.tsv and changelog after v25.5.4.38-stable. [#82655](https://github.com/ClickHouse/ClickHouse/pull/82655) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Add new tool to inspect and dump the FST index tree. [#82665](https://github.com/ClickHouse/ClickHouse/pull/82665) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Update version_date.tsv and changelog after v25.6.1.3206-stable. [#82673](https://github.com/ClickHouse/ClickHouse/pull/82673) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* fix possible datarace while setting s3queue_disable_streaming. [#82695](https://github.com/ClickHouse/ClickHouse/pull/82695) ([Bharat Nallan](https://github.com/bharatnc)).
* CI: Update minio and mc to latest versions. [#82698](https://github.com/ClickHouse/ClickHouse/pull/82698) ([Max Kainov](https://github.com/maxknv)).
* Use proper logging with formatted string for "Failed to make request to" in PocoHTTPClient. [#82702](https://github.com/ClickHouse/ClickHouse/pull/82702) ([Azat Khuzhin](https://github.com/azat)).
* PR: logging for coordinator responses. [#82705](https://github.com/ClickHouse/ClickHouse/pull/82705) ([Igor Nikonov](https://github.com/devcrafter)).
* Update version_date.tsv and changelog after v25.6.2.5-stable. [#82717](https://github.com/ClickHouse/ClickHouse/pull/82717) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Prevent the use of include with quotes in part of src/. [#82720](https://github.com/ClickHouse/ClickHouse/pull/82720) ([Raúl Marín](https://github.com/Algunenano)).
* Fix rainbow parenthesis highlighting issues. [#82721](https://github.com/ClickHouse/ClickHouse/pull/82721) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix building all targets in debug build. [#82723](https://github.com/ClickHouse/ClickHouse/pull/82723) ([Azat Khuzhin](https://github.com/azat)).
* Preparations for labels syncing. [#82724](https://github.com/ClickHouse/ClickHouse/pull/82724) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Limit the number of changelogs in `docs/changelogs`. [#82744](https://github.com/ClickHouse/ClickHouse/pull/82744) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix binary build in MasterCI. [#82749](https://github.com/ClickHouse/ClickHouse/pull/82749) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix typos in AccessRights.cpp comments. [#82769](https://github.com/ClickHouse/ClickHouse/pull/82769) ([pufit](https://github.com/pufit)).
* tests: fix test_replicated_database flakiness. [#82782](https://github.com/ClickHouse/ClickHouse/pull/82782) ([Azat Khuzhin](https://github.com/azat)).
* Fix infinite loop in rainbow parenthesis. [#82788](https://github.com/ClickHouse/ClickHouse/pull/82788) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Improvements for CI/tests wrapper. [#82804](https://github.com/ClickHouse/ClickHouse/pull/82804) ([Azat Khuzhin](https://github.com/azat)).
* Minor follow-up to [#82630](https://github.com/ClickHouse/ClickHouse/issues/82630). [#82805](https://github.com/ClickHouse/ClickHouse/pull/82805) ([Robert Schulze](https://github.com/rschu1ze)).
* Remove a feature from the changelog. [#82811](https://github.com/ClickHouse/ClickHouse/pull/82811) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix race condition in the client test coverage collection in `clickhouse-test`. [#82812](https://github.com/ClickHouse/ClickHouse/pull/82812) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Probably will fix [#82366](https://github.com/ClickHouse/ClickHouse/issues/82366). [#82816](https://github.com/ClickHouse/ClickHouse/pull/82816) ([pufit](https://github.com/pufit)).
* Fix test for CoalescingMergeTree. [#82819](https://github.com/ClickHouse/ClickHouse/pull/82819) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Revert Iceberg. [#82822](https://github.com/ClickHouse/ClickHouse/pull/82822) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Rename DatabasesOverlay to DatabaseOverlay. [#82830](https://github.com/ClickHouse/ClickHouse/pull/82830) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Bump skim/chdig to latest (removes patched tuikit dependency). [#82849](https://github.com/ClickHouse/ClickHouse/pull/82849) ([Azat Khuzhin](https://github.com/azat)).
* Cleanup windows crates. [#82887](https://github.com/ClickHouse/ClickHouse/pull/82887) ([Azat Khuzhin](https://github.com/azat)).
* Build examples for AMD debug on the CI. [#82905](https://github.com/ClickHouse/ClickHouse/pull/82905) ([Pablo Marcos](https://github.com/pamarcos)).
* Continue fixing the project's include style. [#82906](https://github.com/ClickHouse/ClickHouse/pull/82906) ([Raúl Marín](https://github.com/Algunenano)).
* Enable time types back on AST fuzzer. [#82918](https://github.com/ClickHouse/ClickHouse/pull/82918) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Closes [#82725](https://github.com/ClickHouse/ClickHouse/issues/82725). [#82930](https://github.com/ClickHouse/ClickHouse/pull/82930) ([Dmitry Novik](https://github.com/novikd)).
* tests: fix test_system_metrics (with remote disk database can be unavailable). [#82931](https://github.com/ClickHouse/ClickHouse/pull/82931) ([Azat Khuzhin](https://github.com/azat)).
* clickhouse-test: fix `--test-runs`. [#82937](https://github.com/ClickHouse/ClickHouse/pull/82937) ([Nikita Fomichev](https://github.com/fm4v)).
* Add update hash to datatype. [#82938](https://github.com/ClickHouse/ClickHouse/pull/82938) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* adjust setting description deduplicate_blocks_in_dependent_materialized_views. [#82940](https://github.com/ClickHouse/ClickHouse/pull/82940) ([Sema Checherinda](https://github.com/CheSema)).
* Update README.md. [#82944](https://github.com/ClickHouse/ClickHouse/pull/82944) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Bump rapidjson four years into the future. [#82948](https://github.com/ClickHouse/ClickHouse/pull/82948) ([Robert Schulze](https://github.com/rschu1ze)).
* Unrevert "Refactor how IInputFormat deals with reading many files at once". [#82949](https://github.com/ClickHouse/ClickHouse/pull/82949) ([Michael Kolupaev](https://github.com/al13n321)).
* Comments do not matter in context of metadata consistency, and we don't change `/metadata` during ALTER COMMENT COLUMN queries. So ignore them when creating a new replica. [#82952](https://github.com/ClickHouse/ClickHouse/pull/82952) ([Nikolay Degterinsky](https://github.com/evillique)).
* PR: logical error in case of unexpected request from replica. [#82977](https://github.com/ClickHouse/ClickHouse/pull/82977) ([Igor Nikonov](https://github.com/devcrafter)).
* Speedup test_storage_s3_queue:test_s3_client_reused. [#82978](https://github.com/ClickHouse/ClickHouse/pull/82978) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix system.filesystem_read_prefetches_log (fix types mismatch and add support for local reads). [#82983](https://github.com/ClickHouse/ClickHouse/pull/82983) ([Azat Khuzhin](https://github.com/azat)).
* Add getPosition() interface for CompressedReadBufferBase. [#82984](https://github.com/ClickHouse/ClickHouse/pull/82984) ([Azat Khuzhin](https://github.com/azat)).
* Remove unused AsynchronousReadBufferFromFile. [#82985](https://github.com/ClickHouse/ClickHouse/pull/82985) ([Azat Khuzhin](https://github.com/azat)).
* Process reopened cherry-pick PRs. Remove the code for X-repository backporting. [#82986](https://github.com/ClickHouse/ClickHouse/pull/82986) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Update version_date.tsv and changelog after v25.3.5.42-lts. [#82987](https://github.com/ClickHouse/ClickHouse/pull/82987) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix 03254_timeseries_to_grid_aggregate_function with PR. [#82998](https://github.com/ClickHouse/ClickHouse/pull/82998) ([Igor Nikonov](https://github.com/devcrafter)).
* Update version_date.tsv and changelog after v25.4.8.56-stable. [#83000](https://github.com/ClickHouse/ClickHouse/pull/83000) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.5.5.19-stable. [#83003](https://github.com/ClickHouse/ClickHouse/pull/83003) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix prefetch_buffer_size. [#83004](https://github.com/ClickHouse/ClickHouse/pull/83004) ([Azat Khuzhin](https://github.com/azat)).
* Sync metrics from cloud. [#83011](https://github.com/ClickHouse/ClickHouse/pull/83011) ([Alexander Gololobov](https://github.com/davenger)).
* Remove Array/Map support from text index. [#83031](https://github.com/ClickHouse/ClickHouse/pull/83031) ([Robert Schulze](https://github.com/rschu1ze)).
* Remove pending exceptions for include style check. [#83032](https://github.com/ClickHouse/ClickHouse/pull/83032) ([Raúl Marín](https://github.com/Algunenano)).
* CI: silence and add debug information for incorrect parsing of test reports. [#83033](https://github.com/ClickHouse/ClickHouse/pull/83033) ([Nikita Fomichev](https://github.com/fm4v)).
* Prevent the long running groups from timing out. [#83034](https://github.com/ClickHouse/ClickHouse/pull/83034) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix tidy build. [#83035](https://github.com/ClickHouse/ClickHouse/pull/83035) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Remove dependencies between ARM and AMD tidy build checks. [#83037](https://github.com/ClickHouse/ClickHouse/pull/83037) ([Raúl Marín](https://github.com/Algunenano)).
* CI: FT fix exception in parsing test results. [#83044](https://github.com/ClickHouse/ClickHouse/pull/83044) ([Max Kainov](https://github.com/maxknv)).
* Better test "02875_show_functions.sh". [#83046](https://github.com/ClickHouse/ClickHouse/pull/83046) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix test "02875_show_functions.sh". [#83047](https://github.com/ClickHouse/ClickHouse/pull/83047) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Not for changelog (changelog entry is not required). [#83052](https://github.com/ClickHouse/ClickHouse/pull/83052) ([Yang Jiang](https://github.com/Ted-Jiang)).
* Next fuzzer updates. [#83054](https://github.com/ClickHouse/ClickHouse/pull/83054) ([Pedro Ferreira](https://github.com/PedroTadim)).
* disconnect broken-connection. [#83056](https://github.com/ClickHouse/ClickHouse/pull/83056) ([Sema Checherinda](https://github.com/CheSema)).
* Delete security warning about session_log in config.xml. [#83057](https://github.com/ClickHouse/ClickHouse/pull/83057) ([Roman Vasin](https://github.com/rvasin)).
* fix tcp connection polls, reconnect broken connections. [#83059](https://github.com/ClickHouse/ClickHouse/pull/83059) ([Sema Checherinda](https://github.com/CheSema)).
* Test avro patch (just to make sure that I didn't break anything). [#83066](https://github.com/ClickHouse/ClickHouse/pull/83066) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Cleanup Protocol code. [#83074](https://github.com/ClickHouse/ClickHouse/pull/83074) ([Azat Khuzhin](https://github.com/azat)).
* This closes [#82601](https://github.com/ClickHouse/ClickHouse/issues/82601). [#83089](https://github.com/ClickHouse/ClickHouse/pull/83089) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* hold the temporary part lock when executeReplaceRange. [#83095](https://github.com/ClickHouse/ClickHouse/pull/83095) ([Sema Checherinda](https://github.com/CheSema)).
* Small improvement for `JoinMask`. [#83097](https://github.com/ClickHouse/ClickHouse/pull/83097) ([Nikita Taranov](https://github.com/nickitat)).
* Remove bad test `03315_executable_table_function_threads`. [#83098](https://github.com/ClickHouse/ClickHouse/pull/83098) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove manual flush of async insert queue for coverage. [#83127](https://github.com/ClickHouse/ClickHouse/pull/83127) ([Raúl Marín](https://github.com/Algunenano)).
* Fix equivalence classes in sub-query decorrelation. [#83150](https://github.com/ClickHouse/ClickHouse/pull/83150) ([Alexander Gololobov](https://github.com/davenger)).
* Update version_date.tsv and changelog after v25.4.9.14-stable. [#83151](https://github.com/ClickHouse/ClickHouse/pull/83151) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Improve clang-tidy-cache's stats report to help debugging tidy issues. [#83153](https://github.com/ClickHouse/ClickHouse/pull/83153) ([Pablo Marcos](https://github.com/pamarcos)).
* Update version_date.tsv and changelog after v25.5.6.14-stable. [#83155](https://github.com/ClickHouse/ClickHouse/pull/83155) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Do not build stripped binary by default. [#83158](https://github.com/ClickHouse/ClickHouse/pull/83158) ([Azat Khuzhin](https://github.com/azat)).
* Sync private changes. [#83160](https://github.com/ClickHouse/ClickHouse/pull/83160) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix test `00764_max_query_size_allocation.sh`. [#83170](https://github.com/ClickHouse/ClickHouse/pull/83170) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix build (amd_tidy). [#83191](https://github.com/ClickHouse/ClickHouse/pull/83191) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Minor stuff. [#83213](https://github.com/ClickHouse/ClickHouse/pull/83213) ([Robert Schulze](https://github.com/rschu1ze)).
* Improve rabbitmq's wait for availability. [#83227](https://github.com/ClickHouse/ClickHouse/pull/83227) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix comment that was the other way around. [#83228](https://github.com/ClickHouse/ClickHouse/pull/83228) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix wrong log level. [#83230](https://github.com/ClickHouse/ClickHouse/pull/83230) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Translate exception messages from Chinese. [#83231](https://github.com/ClickHouse/ClickHouse/pull/83231) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* clickhouse-test: obtain stacktrace with gdb if we failed to do this with SIGTSTP. [#83236](https://github.com/ClickHouse/ClickHouse/pull/83236) ([Azat Khuzhin](https://github.com/azat)).
* add comments for InsertDependenciesBuilder::root_view. [#83243](https://github.com/ClickHouse/ClickHouse/pull/83243) ([Sema Checherinda](https://github.com/CheSema)).
* Add a comment. [#83247](https://github.com/ClickHouse/ClickHouse/pull/83247) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Text index: Remove multi-column support leftovers. [#83248](https://github.com/ClickHouse/ClickHouse/pull/83248) ([Robert Schulze](https://github.com/rschu1ze)).
* The stale remote branch `ClickHouse-docker-library` could cause issues for the freshly created PRs. [#83251](https://github.com/ClickHouse/ClickHouse/pull/83251) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Docs: Move video about full-text search to References section. [#83258](https://github.com/ClickHouse/ClickHouse/pull/83258) ([Robert Schulze](https://github.com/rschu1ze)).
* Text index: Remove support for legacy names. [#83274](https://github.com/ClickHouse/ClickHouse/pull/83274) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix flaky `test_keeper_invalid_digest`. [#83275](https://github.com/ClickHouse/ClickHouse/pull/83275) ([Antonio Andelic](https://github.com/antonio2368)).
* Minor: Call utility function to identify GIN index files. [#83276](https://github.com/ClickHouse/ClickHouse/pull/83276) ([Robert Schulze](https://github.com/rschu1ze)).
* turn off msan for 03008_deduplication_mv_generates_several_blocks_nonreplicated.sh. [#83293](https://github.com/ClickHouse/ClickHouse/pull/83293) ([Sema Checherinda](https://github.com/CheSema)).
* Print biggest subtree in snapshot analyzer of Keeper utils. [#83296](https://github.com/ClickHouse/ClickHouse/pull/83296) ([Antonio Andelic](https://github.com/antonio2368)).
* Miscellaneous. [#83316](https://github.com/ClickHouse/ClickHouse/pull/83316) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix test `01606_merge_from_wide_to_compact`. [#83325](https://github.com/ClickHouse/ClickHouse/pull/83325) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix test `02483_elapsed_time`. [#83326](https://github.com/ClickHouse/ClickHouse/pull/83326) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix fuzzer build. [#83327](https://github.com/ClickHouse/ClickHouse/pull/83327) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* See https://play.clickhouse.com/play?user=play#U0VMRUNUIGNoZWNrX3N0YXJ0X3RpbWUsIGNoZWNrX25hbWUsIHRlc3RfbmFtZSwgcmVwb3J0X3VybApGUk9NIGNoZWNrcwpXSEVSRSBjaGVja19zdGFydF90aW1lID49IG5vdygpIC0gSU5URVJWQUwgMSBZRUFSCiAgICBBTkQgKGhlYWRfcmVmID0gJ21hc3RlcicgQU5EIHN0YXJ0c1dpdGgoaGVhZF9yZXBvLCAnQ2xpY2tIb3VzZS8nKSkKICAgIEFORCB0ZXN0X3N0YXR1cyAhPSAnU0tJUFBFRCcKICAgIEFORCAodGVzdF9zdGF0dXMgTElLRSAnRiUnIE9SIHRlc3Rfc3RhdHVzIExJS0UgJ0UlJykgCiAgICBBTkQgY2hlY2tfc3RhdHVzICE9ICdzdWNjZXNzJwogICAgQU5EIHBvc2l0aW9uKHRlc3RfbmFtZSwgJ3Rlc3Rfb3B0aW9uc19wcm9wYWdhdGlvbl9lbmFibGVkJykgPiAwCk9SREVSIEJZIGNoZWNrX3N0YXJ0X3RpbWU=. [#83354](https://github.com/ClickHouse/ClickHouse/pull/83354) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Related issue [#79109](https://github.com/ClickHouse/ClickHouse/issues/79109). [#83356](https://github.com/ClickHouse/ClickHouse/pull/83356) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Bump chdig to v25.6.2 (better and faster UI, and some minor bug fixes and improvements). [#83357](https://github.com/ClickHouse/ClickHouse/pull/83357) ([Azat Khuzhin](https://github.com/azat)).
* Performance improvements for applying patch parts. [#83359](https://github.com/ClickHouse/ClickHouse/pull/83359) ([Anton Popov](https://github.com/CurtizJ)).
* Improved the logging for unmarking PRs to backport due to re-/opened cherry-pick PRs. [#83362](https://github.com/ClickHouse/ClickHouse/pull/83362) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Update rust toolchain to nightly-2025-07-07. [#83370](https://github.com/ClickHouse/ClickHouse/pull/83370) ([Azat Khuzhin](https://github.com/azat)).
* Next fuzz update. [#83375](https://github.com/ClickHouse/ClickHouse/pull/83375) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Add possibility to use `ClickHouseVersion` in other code modules. [#83382](https://github.com/ClickHouse/ClickHouse/pull/83382) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Update NuRaft. [#83384](https://github.com/ClickHouse/ClickHouse/pull/83384) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix test `03100_lwu_31_merge_memory_usage`. [#83385](https://github.com/ClickHouse/ClickHouse/pull/83385) ([Anton Popov](https://github.com/CurtizJ)).
* Fix write buffer not finalized in destructor. [#83391](https://github.com/ClickHouse/ClickHouse/pull/83391) ([Kseniia Sumarokova](https://github.com/kssenii)).
* This closes [#79998](https://github.com/ClickHouse/ClickHouse/issues/79998). [#83414](https://github.com/ClickHouse/ClickHouse/pull/83414) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fix MarkCacheHits/MarkCacheMisses for save_marks_in_cache=false. [#83415](https://github.com/ClickHouse/ClickHouse/pull/83415) ([Azat Khuzhin](https://github.com/azat)).
* Use FIPS-permissive mode in CI. [#83418](https://github.com/ClickHouse/ClickHouse/pull/83418) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use rainbow parenthesis coloring only on matching braces. [#83419](https://github.com/ClickHouse/ClickHouse/pull/83419) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* no-msan in 00804_test_alter_compression_codecs. [#83421](https://github.com/ClickHouse/ClickHouse/pull/83421) ([Michael Kolupaev](https://github.com/al13n321)).
* Better tests for lightweight updates with SMT. [#83438](https://github.com/ClickHouse/ClickHouse/pull/83438) ([Anton Popov](https://github.com/CurtizJ)).
* Sync changes. [#83439](https://github.com/ClickHouse/ClickHouse/pull/83439) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Tiny fix for query-latency-analyzer. [#83446](https://github.com/ClickHouse/ClickHouse/pull/83446) ([Azat Khuzhin](https://github.com/azat)).
* Fix SZ3 for float32. [#83457](https://github.com/ClickHouse/ClickHouse/pull/83457) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Support FST format v2 in FST dump tree tool. [#83482](https://github.com/ClickHouse/ClickHouse/pull/83482) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fuzzer for codec SZ3 on top of libFuzzer. [#83486](https://github.com/ClickHouse/ClickHouse/pull/83486) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Add profile events for patch part locks. [#83487](https://github.com/ClickHouse/ClickHouse/pull/83487) ([Anton Popov](https://github.com/CurtizJ)).
* Make HMS tests less flaky. [#83506](https://github.com/ClickHouse/ClickHouse/pull/83506) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Own our copy of CMake files for google-cloud-cpp. [#83518](https://github.com/ClickHouse/ClickHouse/pull/83518) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix a crash in S3Queue. Introduced in https://github.com/ClickHouse/ClickHouse/pull/82463. [#83522](https://github.com/ClickHouse/ClickHouse/pull/83522) ([Nikolay Degterinsky](https://github.com/evillique)).
* Small follow-up to [#83304](https://github.com/ClickHouse/ClickHouse/issues/83304). [#83527](https://github.com/ClickHouse/ClickHouse/pull/83527) ([Nikita Taranov](https://github.com/nickitat)).
* Bring back `--pre-pull` command to the integration tests jobs, it was deleted in [#73291](https://github.com/ClickHouse/ClickHouse/issues/73291). [#83528](https://github.com/ClickHouse/ClickHouse/pull/83528) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add simple text index performance test. [#83538](https://github.com/ClickHouse/ClickHouse/pull/83538) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Delete dead code. [#83546](https://github.com/ClickHouse/ClickHouse/pull/83546) ([Robert Schulze](https://github.com/rschu1ze)).
* Add codecs for patch parts system columns. [#83554](https://github.com/ClickHouse/ClickHouse/pull/83554) ([Anton Popov](https://github.com/CurtizJ)).
* Add warning about databases that were potentially created to save broken tables. [#83558](https://github.com/ClickHouse/ClickHouse/pull/83558) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Update version_date.tsv and changelog after v25.4.10.45-stable. [#83582](https://github.com/ClickHouse/ClickHouse/pull/83582) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.6.3.116-stable. [#83585](https://github.com/ClickHouse/ClickHouse/pull/83585) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix explain for key-value engines with optimize=0. [#83588](https://github.com/ClickHouse/ClickHouse/pull/83588) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* This closes [#83576](https://github.com/ClickHouse/ClickHouse/issues/83576). [#83596](https://github.com/ClickHouse/ClickHouse/pull/83596) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Less flaky test_cluster_discovery/test_password.py. [#83598](https://github.com/ClickHouse/ClickHouse/pull/83598) ([Vladimir Cherkasov](https://github.com/vdimir)).
* This class is quite complex and deserves to be in a separate file. [#83599](https://github.com/ClickHouse/ClickHouse/pull/83599) ([alesapin](https://github.com/alesapin)).
* Increase flush interval. [#83602](https://github.com/ClickHouse/ClickHouse/pull/83602) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Fix overflow in NumericIndexedVector. [#83603](https://github.com/ClickHouse/ClickHouse/pull/83603) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Update flake.nix with new Rust toolchain. [#83605](https://github.com/ClickHouse/ClickHouse/pull/83605) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix usage of KafkaConsumer2::EXCEPTIONS_DEPTH. [#83606](https://github.com/ClickHouse/ClickHouse/pull/83606) ([Azat Khuzhin](https://github.com/azat)).
* Fix typos and small language improvements in server config, only inside comments. [#83616](https://github.com/ClickHouse/ClickHouse/pull/83616) ([bluikko](https://github.com/bluikko)).
* Better logging when external sort creates temporary files. [#83625](https://github.com/ClickHouse/ClickHouse/pull/83625) ([Azat Khuzhin](https://github.com/azat)).
* Small fuzzer update. [#83629](https://github.com/ClickHouse/ClickHouse/pull/83629) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix test `03223_analyzer_with_cube_fuzz`. [#83642](https://github.com/ClickHouse/ClickHouse/pull/83642) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove a mention of zero-copy replication. [#83675](https://github.com/ClickHouse/ClickHouse/pull/83675) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* See https://s3.amazonaws.com/clickhouse-test-reports/json.html?REF=master&sha=dce62d318322ab448a93c13f0571ad1ce16ac01f&name_0=MasterCI&name_1=Stateless%20tests%20%28amd_asan%2C%20distributed%20plan%2C%202%2F2%29 Probably some of the randomized settings, like `max_threads`, affected it. [#83681](https://github.com/ClickHouse/ClickHouse/pull/83681) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The test was stupid, fix it. [#83684](https://github.com/ClickHouse/ClickHouse/pull/83684) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix regexp highlighting. [#83685](https://github.com/ClickHouse/ClickHouse/pull/83685) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add sanity check for setting `vector_search_postfilter_multiplier` + add more tests. [#83689](https://github.com/ClickHouse/ClickHouse/pull/83689) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Replace getting organizations for a user with getting users for trusted organizations. This allows as to get private users for ClickHouse organizations as well. [#83710](https://github.com/ClickHouse/ClickHouse/pull/83710) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix error messages from workload test. [#83717](https://github.com/ClickHouse/ClickHouse/pull/83717) ([Sergei Trifonov](https://github.com/serxa)).
* Decrease log level for noisy message from keeper. [#83718](https://github.com/ClickHouse/ClickHouse/pull/83718) ([Max Kainov](https://github.com/maxknv)).
* Fixes [#83719](https://github.com/ClickHouse/ClickHouse/issues/83719). [#83725](https://github.com/ClickHouse/ClickHouse/pull/83725) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Remove double-initialization of iterator in ReadFromObjectStorage and make name fixed. [#83726](https://github.com/ClickHouse/ClickHouse/pull/83726) ([alesapin](https://github.com/alesapin)).
* Make more tests parallelizable. [#83732](https://github.com/ClickHouse/ClickHouse/pull/83732) ([Raúl Marín](https://github.com/Algunenano)).
* Update version_date.tsv and changelog after v25.3.6.56-lts. [#83736](https://github.com/ClickHouse/ClickHouse/pull/83736) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Bump usearch from 2.17.12 to v2.19.1. [#83746](https://github.com/ClickHouse/ClickHouse/pull/83746) ([Robert Schulze](https://github.com/rschu1ze)).
* Sync default value allow_remote_fs_zero_copy_replication from private. [#83752](https://github.com/ClickHouse/ClickHouse/pull/83752) ([Azat Khuzhin](https://github.com/azat)).
* Minor changes around MemoryTracker. [#83755](https://github.com/ClickHouse/ClickHouse/pull/83755) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.4.11.15-stable. [#83778](https://github.com/ClickHouse/ClickHouse/pull/83778) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.5.7.52-stable. [#83780](https://github.com/ClickHouse/ClickHouse/pull/83780) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.6.4.12-stable. [#83783](https://github.com/ClickHouse/ClickHouse/pull/83783) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Syncing serialization of MergingAggregatedStep and related settings from cloud. [#83785](https://github.com/ClickHouse/ClickHouse/pull/83785) ([Alexander Gololobov](https://github.com/davenger)).
* 03144_parallel_alter_add_drop_column_zookeeper_on_steroids.sh reduce noise in logs. [#83790](https://github.com/ClickHouse/ClickHouse/pull/83790) ([Max Kainov](https://github.com/maxknv)).
* small fixes to ArenaAllocator.h. [#83802](https://github.com/ClickHouse/ClickHouse/pull/83802) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix abort in `WriteBufferValidUTF8`. This closes [#83514](https://github.com/ClickHouse/ClickHouse/issues/83514). [#83816](https://github.com/ClickHouse/ClickHouse/pull/83816) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* 25.7 webinar. [#83820](https://github.com/ClickHouse/ClickHouse/pull/83820) ([Raúl Marín](https://github.com/Algunenano)).
* Decrease log level to TEST for Nothing to merge. [#83822](https://github.com/ClickHouse/ClickHouse/pull/83822) ([Max Kainov](https://github.com/maxknv)).
* Allow concurrent tables creation when `max_database_replicated_create_table_thread_pool_size` setting is 0 (automatic pool size). [#83834](https://github.com/ClickHouse/ClickHouse/pull/83834) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Update README.md. [#83836](https://github.com/ClickHouse/ClickHouse/pull/83836) ([Tyler Hannan](https://github.com/tylerhannan)).
* Add ci-build to the list of forbidden labels. [#83841](https://github.com/ClickHouse/ClickHouse/pull/83841) ([Pablo Marcos](https://github.com/pamarcos)).
* Sync changes. [#83845](https://github.com/ClickHouse/ClickHouse/pull/83845) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix test `03100_lwu_24_renames`. [#83857](https://github.com/ClickHouse/ClickHouse/pull/83857) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#83940](https://github.com/ClickHouse/ClickHouse/issues/83940): Fix 02233_HTTP_ranged. [#83891](https://github.com/ClickHouse/ClickHouse/pull/83891) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84065](https://github.com/ClickHouse/ClickHouse/issues/84065): Fix E2E test. [#83903](https://github.com/ClickHouse/ClickHouse/pull/83903) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84148](https://github.com/ClickHouse/ClickHouse/issues/84148): Fix disabling of skip indexes for columns updated in patches. [#83976](https://github.com/ClickHouse/ClickHouse/pull/83976) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#84185](https://github.com/ClickHouse/ClickHouse/issues/84185): Highlight regexps in REGEXP_REPLACE. [#84086](https://github.com/ClickHouse/ClickHouse/pull/84086) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#84363](https://github.com/ClickHouse/ClickHouse/issues/84363): Fix test_storage_rabbitmq timeouts. [#84234](https://github.com/ClickHouse/ClickHouse/pull/84234) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#84608](https://github.com/ClickHouse/ClickHouse/issues/84608): Removing temprary parts may take a while (especially with S3), and currently we do it while holding a global lock in `MergeTreeBackgroundExecutor`. When we need to restart all tables due to connection loss and we wait for background tasks to finish - tables may even stuck in readonly mode for an hour. But looks like we don't need this lock for calling `cancel`. [#84311](https://github.com/ClickHouse/ClickHouse/pull/84311) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#84347](https://github.com/ClickHouse/ClickHouse/issues/84347): Fix `repo` field in exported CI logs. [#84321](https://github.com/ClickHouse/ClickHouse/pull/84321) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backported in [#84413](https://github.com/ClickHouse/ClickHouse/issues/84413): Revert "Revert "Revert "Add SZ3 compression codec""". [#84358](https://github.com/ClickHouse/ClickHouse/pull/84358) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#84573](https://github.com/ClickHouse/ClickHouse/issues/84573): Fix bad function call in cache policy. [#84519](https://github.com/ClickHouse/ClickHouse/pull/84519) ([Kseniia Sumarokova](https://github.com/kssenii)).

