---
sidebar_position: 1
sidebar_label: 2024
---

# 2024 Changelog

### ClickHouse release v24.8.9.95-lts (386a2469df1) FIXME as compared to v24.8.8.17-lts (81036bd118b)

#### Backward Incompatible Change
* Backported in [#72165](https://github.com/ClickHouse/ClickHouse/issues/72165): Forbid Dynamic/Variant types in min/max functions to avoid confusion. [#71761](https://github.com/ClickHouse/ClickHouse/pull/71761) ([Pavel Kruglov](https://github.com/Avogar)).

#### Performance Improvement
* Backported in [#73029](https://github.com/ClickHouse/ClickHouse/issues/73029): Bring back optimization for reading subcolumns of single column in Compact parts from https://github.com/ClickHouse/ClickHouse/pull/57631. It was deleted accidentally. [#72285](https://github.com/ClickHouse/ClickHouse/pull/72285) ([Pavel Kruglov](https://github.com/Avogar)).

#### Improvement
* Backported in [#72568](https://github.com/ClickHouse/ClickHouse/issues/72568): Fix the metadata_version record in ZooKeeper in restarting thread rather than in attach thread. [#70297](https://github.com/ClickHouse/ClickHouse/pull/70297) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#73561](https://github.com/ClickHouse/ClickHouse/issues/73561): Fix the issue where ClickHouse in Docker containers printed "get_mempolicy: Operation not permitted" into stderr due to restricted syscalls. [#70900](https://github.com/ClickHouse/ClickHouse/pull/70900) ([filimonov](https://github.com/filimonov)).
* Backported in [#72671](https://github.com/ClickHouse/ClickHouse/issues/72671): Better memory usage approximation of cached marks to reduce total memory usage of the cache. [#72630](https://github.com/ClickHouse/ClickHouse/pull/72630) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#72410](https://github.com/ClickHouse/ClickHouse/issues/72410): The parts deduplicated during `ATTACH PART` query don't get stuck with the `attaching_` prefix anymore. [#65636](https://github.com/ClickHouse/ClickHouse/pull/65636) ([Kirill](https://github.com/kirillgarbar)).
* Backported in [#73503](https://github.com/ClickHouse/ClickHouse/issues/73503): Fix [#68239](https://github.com/ClickHouse/ClickHouse/issues/68239) SAMPLE n where n is an integer. [#68499](https://github.com/ClickHouse/ClickHouse/pull/68499) ([Denis Hananein](https://github.com/denis-hananein)).
* Backported in [#73356](https://github.com/ClickHouse/ClickHouse/issues/73356): Fixed zombie processes after after library bridge crash. [#71301](https://github.com/ClickHouse/ClickHouse/pull/71301) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#73355](https://github.com/ClickHouse/ClickHouse/issues/73355): Fix error column "attgenerated" does not exist for old PostgreSQL, fix [#60651](https://github.com/ClickHouse/ClickHouse/issues/60651). [#71396](https://github.com/ClickHouse/ClickHouse/pull/71396) ([0xMihalich](https://github.com/0xMihalich)).
* Backported in [#72726](https://github.com/ClickHouse/ClickHouse/issues/72726): Fix NoSuchKey error during transaction rollback when creating a directory fails for the palin_rewritable disk. [#71439](https://github.com/ClickHouse/ClickHouse/pull/71439) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#72170](https://github.com/ClickHouse/ClickHouse/issues/72170): Fix counting column size in wide part for Dynamic and JSON types. [#71526](https://github.com/ClickHouse/ClickHouse/pull/71526) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72269](https://github.com/ClickHouse/ClickHouse/issues/72269): Fix serialization of Dynamic values in Pretty JSON formats. [#71923](https://github.com/ClickHouse/ClickHouse/pull/71923) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72181](https://github.com/ClickHouse/ClickHouse/issues/72181): Fix rows_processed column in system.s3/azure_queue_log broken in 24.6. Closes [#69975](https://github.com/ClickHouse/ClickHouse/issues/69975). [#71946](https://github.com/ClickHouse/ClickHouse/pull/71946) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73397](https://github.com/ClickHouse/ClickHouse/issues/73397): Add inferred format name to create query in File/S3/URL/HDFS/Azure engines. Previously the format name was inferred each time the server was restarted, and if the specified data files were removed, it led to errors during server startup. [#72108](https://github.com/ClickHouse/ClickHouse/pull/72108) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72305](https://github.com/ClickHouse/ClickHouse/issues/72305): Fix bugs when using UDF in join on expression with the old analyzer. [#72179](https://github.com/ClickHouse/ClickHouse/pull/72179) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#72250](https://github.com/ClickHouse/ClickHouse/issues/72250): Fix a bug where `min_age_to_force_merge_on_partition_only` was getting stuck trying to merge down the same partition repeatedly that was already merged to a single part and not merging partitions that had multiple parts. [#72209](https://github.com/ClickHouse/ClickHouse/pull/72209) ([Christoph Wurm](https://github.com/cwurm)).
* Backported in [#72323](https://github.com/ClickHouse/ClickHouse/issues/72323): Fixed data race in `GraceHashJoin` as the result of which some rows might be missing in the join output. [#72233](https://github.com/ClickHouse/ClickHouse/pull/72233) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#72312](https://github.com/ClickHouse/ClickHouse/issues/72312): Fixed data race when `ColumnDynamic::dumpStructure()` is called concurrently e.g. in `ConcurrentHashJoin` constructor. [#72278](https://github.com/ClickHouse/ClickHouse/pull/72278) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#72523](https://github.com/ClickHouse/ClickHouse/issues/72523): Fixed mismatched types in several cases after applying `optimize_functions_to_subcolumns`. [#72394](https://github.com/ClickHouse/ClickHouse/pull/72394) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72502](https://github.com/ClickHouse/ClickHouse/issues/72502): Fix failure on parsing `BACKUP DATABASE db EXCEPT TABLES db.table` queries. [#72429](https://github.com/ClickHouse/ClickHouse/pull/72429) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#72952](https://github.com/ClickHouse/ClickHouse/issues/72952): Don't allow creating empty Variant. [#72454](https://github.com/ClickHouse/ClickHouse/pull/72454) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72709](https://github.com/ClickHouse/ClickHouse/issues/72709): Fix parsing a glob with one element. [#72572](https://github.com/ClickHouse/ClickHouse/pull/72572) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#72926](https://github.com/ClickHouse/ClickHouse/issues/72926): Fix query generation for the follower server in case of a distributed query with ARRAY JOIN. Fixes [#69276](https://github.com/ClickHouse/ClickHouse/issues/69276). [#72608](https://github.com/ClickHouse/ClickHouse/pull/72608) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#72846](https://github.com/ClickHouse/ClickHouse/issues/72846): Fixed inconsistent metadata when adding a new replica to a Replicated database that has a table created with `flatten_nested=0`. [#72685](https://github.com/ClickHouse/ClickHouse/pull/72685) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#73314](https://github.com/ClickHouse/ClickHouse/issues/73314): Fix the situation when a user can't run `REVOKE ALL ON *.*` because of implicit grants in the target access entity. [#72872](https://github.com/ClickHouse/ClickHouse/pull/72872) ([pufit](https://github.com/pufit)).
* Backported in [#72979](https://github.com/ClickHouse/ClickHouse/issues/72979): Fix potential crash during backup restore. [#72947](https://github.com/ClickHouse/ClickHouse/pull/72947) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73155](https://github.com/ClickHouse/ClickHouse/issues/73155): Fix crash in transactions with unsupported storage. [#73045](https://github.com/ClickHouse/ClickHouse/pull/73045) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73124](https://github.com/ClickHouse/ClickHouse/issues/73124): Fix possible overestimate memory tracking (difference between `MemoryTracking` and `MemoryResident` kept growing). [#73081](https://github.com/ClickHouse/ClickHouse/pull/73081) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#73106](https://github.com/ClickHouse/ClickHouse/issues/73106): Check for duplicate JSON keys during Tuple parsing. Previously it could lead to logical error `Invalid number of rows in Chunk` during parsing. [#73082](https://github.com/ClickHouse/ClickHouse/pull/73082) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73610](https://github.com/ClickHouse/ClickHouse/issues/73610): Fix ObjectStorageQueue with ZooKeeper and older Keeper. [#73420](https://github.com/ClickHouse/ClickHouse/pull/73420) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73620](https://github.com/ClickHouse/ClickHouse/issues/73620): Fixed error in function `tupleElement` which may appear in some cases for tuples with `LowCardinality` elelments and enabled setting `optimize_functions_to_subcolumns`. [#73548](https://github.com/ClickHouse/ClickHouse/pull/73548) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73759](https://github.com/ClickHouse/ClickHouse/issues/73759): Fix parsing enum glob followed by range one. Fixes [#73473](https://github.com/ClickHouse/ClickHouse/issues/73473). [#73569](https://github.com/ClickHouse/ClickHouse/pull/73569) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#73684](https://github.com/ClickHouse/ClickHouse/issues/73684): Do not interpret queries in `EXPLAIN SYNTAX` to avoid logical errors with incorrect processing stage for distributed queries. Fixes [#65205](https://github.com/ClickHouse/ClickHouse/issues/65205). [#73634](https://github.com/ClickHouse/ClickHouse/pull/73634) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#73730](https://github.com/ClickHouse/ClickHouse/issues/73730): Fix crash in LIMIT BY COLUMNS. [#73686](https://github.com/ClickHouse/ClickHouse/pull/73686) ([Raúl Marín](https://github.com/Algunenano)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#72484](https://github.com/ClickHouse/ClickHouse/issues/72484): Fix flaky test 03262_column_sizes_with_dynamic_structure. [#71931](https://github.com/ClickHouse/ClickHouse/pull/71931) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73191](https://github.com/ClickHouse/ClickHouse/issues/73191): fix cancelation for PartitionedSink. [#72126](https://github.com/ClickHouse/ClickHouse/pull/72126) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72840](https://github.com/ClickHouse/ClickHouse/issues/72840): Fix calculating dynamic columns sizes on vertical merge. Follow-up for https://github.com/ClickHouse/ClickHouse/pull/71526. [#72211](https://github.com/ClickHouse/ClickHouse/pull/72211) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72476](https://github.com/ClickHouse/ClickHouse/issues/72476): Remove flaky test test_move_shared_lock_fail_keeper_unavailable and extend the stable one. [#72357](https://github.com/ClickHouse/ClickHouse/pull/72357) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Backported in [#73225](https://github.com/ClickHouse/ClickHouse/issues/73225): fix finalize/cancel write buffers. [#72386](https://github.com/ClickHouse/ClickHouse/pull/72386) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72446](https://github.com/ClickHouse/ClickHouse/issues/72446): make operations_to_execute as shared ptr. [#72400](https://github.com/ClickHouse/ClickHouse/pull/72400) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73458](https://github.com/ClickHouse/ClickHouse/issues/73458): Fix data race in `ProfileEvents::Counters::setParent()`. This PR fixes [#60376](https://github.com/ClickHouse/ClickHouse/issues/60376). [#72518](https://github.com/ClickHouse/ClickHouse/pull/72518) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#72763](https://github.com/ClickHouse/ClickHouse/issues/72763): Fix potential `Context has expired` error for Y-shaped JOIN. Was triggered in [#71429](https://github.com/ClickHouse/ClickHouse/issues/71429). [#72735](https://github.com/ClickHouse/ClickHouse/pull/72735) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#73299](https://github.com/ClickHouse/ClickHouse/issues/73299): fix missing finalize call. [#73279](https://github.com/ClickHouse/ClickHouse/pull/73279) ([Sema Checherinda](https://github.com/CheSema)).

