---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v24.8.14.39-lts (502d03925cf) FIXME as compared to v24.8.13.16-lts (c8a1e828dcf)

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#75642](https://github.com/ClickHouse/ClickHouse/issues/75642): Fix docker init script fail log message for more clean understanding. [#71734](https://github.com/ClickHouse/ClickHouse/pull/71734) ([Андрей](https://github.com/andreineustroev)).
* Backported in [#75118](https://github.com/ClickHouse/ClickHouse/issues/75118): Fix crash when inserting interval (issue [#74299](https://github.com/ClickHouse/ClickHouse/issues/74299)). [#74478](https://github.com/ClickHouse/ClickHouse/pull/74478) ([NamHoaiNguyen](https://github.com/NamHoaiNguyen)).
* Backported in [#75305](https://github.com/ClickHouse/ClickHouse/issues/75305): Fix crash during JSON type declaration parsing when type name is not uppercase. [#74784](https://github.com/ClickHouse/ClickHouse/pull/74784) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#76228](https://github.com/ClickHouse/ClickHouse/issues/76228): Fix crash due to uncaught exception in PSQL replication. [#75062](https://github.com/ClickHouse/ClickHouse/pull/75062) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#76245](https://github.com/ClickHouse/ClickHouse/issues/76245): Sasl can fail any rpc call, the fix helps to repeat the call in case if krb5 ticker is expired. [#75063](https://github.com/ClickHouse/ClickHouse/pull/75063) ([inv2004](https://github.com/inv2004)).
* Backported in [#75403](https://github.com/ClickHouse/ClickHouse/issues/75403): Fixed usage of indexes (primary and secondary) for `Array`, `Map` and `Nullable(..)` columns with enabled setting `optimize_function_to_subcolumns`. Previously, indexes for these columns could have been ignored. [#75081](https://github.com/ClickHouse/ClickHouse/pull/75081) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#76102](https://github.com/ClickHouse/ClickHouse/issues/76102): Fix nullsafe JOIN handling for LowCardinality nullable data type. Previously JOIN ON with nullsafe comparison, such as `IS NOT DISTINCT FROM`, `<=>` , `a IS NULL AND b IS NULL OR a == b` didn't work correctly with LowCardinality columns. [#75143](https://github.com/ClickHouse/ClickHouse/pull/75143) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#75566](https://github.com/ClickHouse/ClickHouse/issues/75566): Keeper fix: avoid writing to broken changelogs when rolling back logs. [#75197](https://github.com/ClickHouse/ClickHouse/pull/75197) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#75742](https://github.com/ClickHouse/ClickHouse/issues/75742): Fix crash in protobuf schema cache that can happen during output in Protobuf format and parallel query `SYSTEM DROP FORMAT SCHEMA CACHE`. [#75357](https://github.com/ClickHouse/ClickHouse/pull/75357) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#76094](https://github.com/ClickHouse/ClickHouse/issues/76094): Fix possible error `Elements ... and ... of Nested data structure ... (Array columns) have different array sizes` when JSON subcolumns with Array type are used in JOIN over distributed tables. [#75512](https://github.com/ClickHouse/ClickHouse/pull/75512) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75890](https://github.com/ClickHouse/ClickHouse/issues/75890): Fixed rare crashes while reading from `MergeTree` table after multiple asynchronous `RENAME` queries (with `alter_sync = 0`) between columns with different types. [#75693](https://github.com/ClickHouse/ClickHouse/pull/75693) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#75831](https://github.com/ClickHouse/ClickHouse/issues/75831): Fixed null pointer dereference in `DistinctSortedStreamTransform`. [#75734](https://github.com/ClickHouse/ClickHouse/pull/75734) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#76215](https://github.com/ClickHouse/ClickHouse/issues/76215): `clickhouse-library-bridge` allows opening arbitrary libraries from the filesystem, which makes it safe to run only inside an isolated environment. To prevent a vulnerability when it is run near the clickhouse-server, we will limit the paths of libraries to a location, provided in the configuration. This vulnerability was found with the [ClickHouse Bug Bounty Program](https://github.com/ClickHouse/ClickHouse/issues/38986) by **Arseniy Dugin**. [#75954](https://github.com/ClickHouse/ClickHouse/pull/75954) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Build/Testing/Packaging Improvement
* Backported in [#76219](https://github.com/ClickHouse/ClickHouse/issues/76219): Make all clickhouse-server related actions a function, and execute them only when launching the default binary in `entrypoint.sh`. A long-postponed improvement was suggested in [#50724](https://github.com/ClickHouse/ClickHouse/issues/50724). Added switch `--users` to `clickhouse-extract-from-config` to get values from the `users.xml`. [#75643](https://github.com/ClickHouse/ClickHouse/pull/75643) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#75506](https://github.com/ClickHouse/ClickHouse/issues/75506): Fix the flaky test in `test_replicated_merge_tree_s3_zero_copy/test.py::test_drop_table` by reducing the loop count and backoff period to avoid exceeding the client timeout. [#73102](https://github.com/ClickHouse/ClickHouse/pull/73102) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#76367](https://github.com/ClickHouse/ClickHouse/issues/76367): Fix normalizing function names inside ASTTTLElement. [#75757](https://github.com/ClickHouse/ClickHouse/pull/75757) ([Michael Kolupaev](https://github.com/al13n321)).

