---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.2.1.3085-stable (09989205d6f) FIXME as compared to v25.2.1.1-new (602ecc3b8da)

#### Backward Incompatible Change
* Completely enable async_load_databases by default (even for those installations that do not upgrade `config.xml`). [#74772](https://github.com/ClickHouse/ClickHouse/pull/74772) ([Azat Khuzhin](https://github.com/azat)).
* Add `JSONCompactEachRowWithProgress` and `JSONCompactStringsEachRowWithProgress` formats. Continuation of [#69989](https://github.com/ClickHouse/ClickHouse/issues/69989). The `JSONCompactWithNames` and `JSONCompactWithNamesAndTypes` no longer output "totals" - apparently, it was a mistake in the implementation. [#75037](https://github.com/ClickHouse/ClickHouse/pull/75037) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Change format_alter_operations_with_parentheses default to true to disambiguate alter commands list (see https://github.com/ClickHouse/ClickHouse/pull/59532). This breaks replication with clusters prior to 24.3. If you are upgrading a cluster using older releases turn off the setting in the server config or upgrade to 24.3 first. [#75302](https://github.com/ClickHouse/ClickHouse/pull/75302) ([Raúl Marín](https://github.com/Algunenano)).
* Validate settings in cache configuration. Non existing settings were ignored before, now they will throw an error and they should be removed. [#75452](https://github.com/ClickHouse/ClickHouse/pull/75452) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove possibility to filter log messages using regular expressions. The implementation introduced a data race, so it has to be removed. [#75577](https://github.com/ClickHouse/ClickHouse/pull/75577) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).

#### New Feature
* Added a new setting `enable_adaptive_memory_spill_scheduler` that allows multiple grace JOINs in the same query to monitor their combined memory footprint and trigger spilling into an external storage adaptively to prevent MEMORY_LIMIT_EXCEEDED. [#72728](https://github.com/ClickHouse/ClickHouse/pull/72728) ([lgbo](https://github.com/lgbo-ustc)).
* Add a new string comparison function `stringCompare` to compare parts of two strings. Example: `SELECT stringCompare('Saxony', 'Anglo-Saxon', 0, 6, 5) AS result` means "compare 6 bytes of strings 'Saxon' and 'Anglo-Saxon' lexicographically, starting at offset 0 in the first string, offset 5 in the second string". [#74070](https://github.com/ClickHouse/ClickHouse/pull/74070) ([lgbo](https://github.com/lgbo-ustc)).
* Added an ability to apply non-finished (not materialized by background process) mutations during the execution of `SELECT` queries immediately after submitting. It can be enabled by setting `apply_mutations_on_fly`. [#74877](https://github.com/ClickHouse/ClickHouse/pull/74877) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed some previously unexpected cases when `toStartOfInterval` datetime arguments are negative. Done by implementing a new function called toStartOfIntervalAllowNegative, which does pretty much the same but returns only Date32/DateTime64. [#74933](https://github.com/ClickHouse/ClickHouse/pull/74933) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* A new function initialQueryStartTime has been added. It returns the start time of the current query. The value is the same across all shards during a distributed query. [#75087](https://github.com/ClickHouse/ClickHouse/pull/75087) ([Roman Lomonosov](https://github.com/lomik)).
* Add new Database engine `DatabaseBackup` that allows to instantly attach table/database from backup. [#75725](https://github.com/ClickHouse/ClickHouse/pull/75725) ([Maksim Kita](https://github.com/kitaisreal)).
* Add ability to ATTACH tables without database layer (avoids UUID hack). [#75788](https://github.com/ClickHouse/ClickHouse/pull/75788) ([Azat Khuzhin](https://github.com/azat)).
* Restore QPL codec which has been removed in v24.10 due to licensing issues. [#76021](https://github.com/ClickHouse/ClickHouse/pull/76021) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### Performance Improvement
* Reintroduce respect `ttl_only_drop_parts` on `materialize ttl`; only read necessary columns to recalculate TTL and drop parts by replacing them with an empty one. [#72751](https://github.com/ClickHouse/ClickHouse/pull/72751) ([Andrey Zvonov](https://github.com/zvonand)).
* Fixed calculation of size in memory for `LowCardinality` columns. [#74688](https://github.com/ClickHouse/ClickHouse/pull/74688) ([Nikita Taranov](https://github.com/nickitat)).
* Improve performance of the whole JSON column reading in Wide parts from S3. It's done by adding prefetches for subcolumn prefixes deserialization, cache of deserialized prefixes and parallel deserialization of subcolumn prefixes. It improves reading of the JSON column from S3 4 times in query like `SELECT data FROM table` and about 10 times in query like `SELECT data FROM table LIMIT 10`. [#74827](https://github.com/ClickHouse/ClickHouse/pull/74827) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixed double preallocation in `ConcurrentHashJoin` in case join sides are swapped by the optimizer. [#75149](https://github.com/ClickHouse/ClickHouse/pull/75149) ([Nikita Taranov](https://github.com/nickitat)).
* Fixed unnecessary contention in `parallel_hash` when `max_rows_in_join = max_bytes_in_join = 0`. [#75155](https://github.com/ClickHouse/ClickHouse/pull/75155) ([Nikita Taranov](https://github.com/nickitat)).
* Slight improvement in some join scenarios: precalculate number of output rows and reserve memory for them. [#75376](https://github.com/ClickHouse/ClickHouse/pull/75376) ([Alexander Gololobov](https://github.com/davenger)).
* `plain_rewritable` metadata files are small and do not need a large default buffer. Use a write buffer sized appropriately to fit the given path, improving memory utilization for a large number of active parts. ### Documentation entry for user-facing changes. [#75758](https://github.com/ClickHouse/ClickHouse/pull/75758) ([Julia Kartseva](https://github.com/jkartseva)).
* It was discovered that concurrency control could lead to unfair CPU distribution between INSERTs and SELECTs. When all CPU slots are allocated unconditionally (w/o competition) to INSERTs with `max_threads` = 1 while SELECTs with high `max_threads` values suffer from poor performance due to using only a single thread. [#75941](https://github.com/ClickHouse/ClickHouse/pull/75941) ([Sergei Trifonov](https://github.com/serxa)).
* Backported in [#76849](https://github.com/ClickHouse/ClickHouse/issues/76849): Actively evict data from the cache on parts removal. Do not let the cache grow to the maximum size if the amount of data is less. [#76641](https://github.com/ClickHouse/ClickHouse/pull/76641) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* Add support for SSL authentication with named collections for MySQL. Closes [#59111](https://github.com/ClickHouse/ClickHouse/issues/59111). [#59452](https://github.com/ClickHouse/ClickHouse/pull/59452) ([Nikolay Degterinsky](https://github.com/evillique)).
* Drop blocks as early as possible to reduce the memory requirements. [#65647](https://github.com/ClickHouse/ClickHouse/pull/65647) ([lgbo](https://github.com/lgbo-ustc)).
* `processors_profile_log` table now has default configuration with TTL of 30 days. [#66139](https://github.com/ClickHouse/ClickHouse/pull/66139) ([Ilya Yatsishin](https://github.com/qoega)).
* Introduce latency buckets and use them to track first byte read/write and connect times for S3 requests. That way we can later use gathered data to calculate approximate percentiles and adapt timeouts. [#69783](https://github.com/ClickHouse/ClickHouse/pull/69783) ([Alexey Katsman](https://github.com/alexkats)).
* Queries passed to `Executable` storage are no longer limited to single threaded execution. [#70084](https://github.com/ClickHouse/ClickHouse/pull/70084) ([yawnt](https://github.com/yawnt)).
* Evaluate parquet bloom filters and min/max indexes together. Necessary to properly support: `x = 3 or x > 5` where data = [1, 2, 4, 5]. [#71383](https://github.com/ClickHouse/ClickHouse/pull/71383) ([Arthur Passos](https://github.com/arthurpassos)).
* Allow to shard names in cluster configuration. [#72276](https://github.com/ClickHouse/ClickHouse/pull/72276) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* For query like, where a<b and b<c and c<5, can generate new comparing conditions (a<5 and b<5) to have better filter ability. [#73164](https://github.com/ClickHouse/ClickHouse/pull/73164) ([Shichao Jin](https://github.com/jsc0218)).
* Support type Nullable(JSON). [#73556](https://github.com/ClickHouse/ClickHouse/pull/73556) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix type mapping for SQLite (integer types into `int64`, floating points into `float64`). [#73853](https://github.com/ClickHouse/ClickHouse/pull/73853) ([Joanna Hulboj](https://github.com/jh0x)).
* Change prometheus remote write response success status from 200/OK to 204/NoContent. [#74170](https://github.com/ClickHouse/ClickHouse/pull/74170) ([Michael Dempsey](https://github.com/bluestealth)).
* Add ability to reload `max_remote_read_network_bandwidth_for_serve` and `max_remote_write_network_bandwidth_for_server` on fly without restart server. [#74206](https://github.com/ClickHouse/ClickHouse/pull/74206) ([Kai Zhu](https://github.com/nauu)).
* Support subcolumns in default and materialized expressions. [#74403](https://github.com/ClickHouse/ClickHouse/pull/74403) ([Pavel Kruglov](https://github.com/Avogar)).
* Added `dfs.client.use.datanode.hostname` libhdfs3 config option support. [#74635](https://github.com/ClickHouse/ClickHouse/pull/74635) ([Mikhail Tiukavkin](https://github.com/freshertm)).
* Allow using blob paths to calculate checksums while making a backup. [#74729](https://github.com/ClickHouse/ClickHouse/pull/74729) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fetch parts in parallel in ALTER TABLE FETCH PARTITION (thread pool size is controlled with `max_fetch_partition_thread_pool_size`). [#74978](https://github.com/ClickHouse/ClickHouse/pull/74978) ([Azat Khuzhin](https://github.com/azat)).
* Added a query ID column to `system.query_cache` (issue [#68205](https://github.com/ClickHouse/ClickHouse/issues/68205)). [#74982](https://github.com/ClickHouse/ClickHouse/pull/74982) ([NamHoaiNguyen](https://github.com/NamHoaiNguyen)).
* Fix formatting of exceptions using a custom format if they appear during query interpretation. In previous versions, exceptions were formatted using the default format rather than the format specified in the query. This closes [#55422](https://github.com/ClickHouse/ClickHouse/issues/55422). [#74994](https://github.com/ClickHouse/ClickHouse/pull/74994) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* It is allowed to cancel `ALTER TABLE ... FREEZE ...` queries with `KILL QUERY` and timeout(`max_execution_time`). [#75016](https://github.com/ClickHouse/ClickHouse/pull/75016) ([Kirill](https://github.com/kirillgarbar)).
* Add support for `groupUniqArrayArrayMap` as `SimpleAggregateFunction`. [#75034](https://github.com/ClickHouse/ClickHouse/pull/75034) ([Miel Donkers](https://github.com/mdonkers)).
* Support prepared statements in postgres wire protocol. [#75035](https://github.com/ClickHouse/ClickHouse/pull/75035) ([scanhex12](https://github.com/scanhex12)).
* Hide catalog credential settings in database engine `Iceberg`. Closes [#74559](https://github.com/ClickHouse/ClickHouse/issues/74559). [#75080](https://github.com/ClickHouse/ClickHouse/pull/75080) ([Kseniia Sumarokova](https://github.com/kssenii)).
* ... Added a few missing features into BuzzHouse: `ILIKE` and `REGEXP` operators, plus <=> and `IS NOT DISTINCT FROM`. [#75168](https://github.com/ClickHouse/ClickHouse/pull/75168) ([Pedro Ferreira](https://github.com/PedroTadim)).
* The setting `min_chunk_bytes_for_parallel_parsing` cannot be zero anymore. This fixes: [#71110](https://github.com/ClickHouse/ClickHouse/issues/71110). [#75239](https://github.com/ClickHouse/ClickHouse/pull/75239) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* `intExp2` / `intExp10`: Define undefined behaviour: return 0 for too small argument, `18446744073709551615` for too big argument, throw exception if `nan`. [#75312](https://github.com/ClickHouse/ClickHouse/pull/75312) ([Vitaly Baranov](https://github.com/vitlibar)).
* Support `s3.endpoint` natively from catalog config in `DatabaseIceberg`. Closes [#74558](https://github.com/ClickHouse/ClickHouse/issues/74558). [#75375](https://github.com/ClickHouse/ClickHouse/pull/75375) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Don't fail silently if user executing `SYSTEM DROP REPLICA` doesn't have enough permissions. [#75377](https://github.com/ClickHouse/ClickHouse/pull/75377) ([Bharat Nallan](https://github.com/bharatnc)).
* Add a ProfileEvent about the number of times any of system logs has failed to flush. [#75466](https://github.com/ClickHouse/ClickHouse/pull/75466) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add check and logging for decrypting and decompressing. [#75471](https://github.com/ClickHouse/ClickHouse/pull/75471) ([Vitaly Baranov](https://github.com/vitlibar)).
* Added support for the micro sign (U+00B5) in the `parseTimeDelta` function. Now both the micro sign (U+00B5) and the Greek letter mu (U+03BC) are recognized as valid representations for microseconds, aligning ClickHouse's behavior with Go’s implementation ([see time.go](https://github.com/golang/go/blob/ad7b46ee4ac1cee5095d64b01e8cf7fcda8bee5e/src/time/time.go#L983C19-L983C20) and [time/format.go](https://github.com/golang/go/blob/ad7b46ee4ac1cee5095d64b01e8cf7fcda8bee5e/src/time/format.go#L1608-L1609)). [#75472](https://github.com/ClickHouse/ClickHouse/pull/75472) ([Vitaly Orlov](https://github.com/orloffv)).
* Replace server setting (`send_settings_to_client`) with client setting (`apply_settings_from_server`) that controls whether client-side code (e.g. parsing INSERT data and formatting query output) should use settings from server's `users.xml` and user profile. Otherwise only settings from client command line, session, and the query are used. Note that this only applies to native client (not e.g. HTTP), and doesn't apply to most of query processing (which happens on the server). [#75478](https://github.com/ClickHouse/ClickHouse/pull/75478) ([Michael Kolupaev](https://github.com/al13n321)).
* Keeper improvement: disable digest calculation when committing to in-memory storage for better performance. It can be enabled with `keeper_server.digest_enabled_on_commit` config. Digest is still calculated when preprocessing requests. [#75490](https://github.com/ClickHouse/ClickHouse/pull/75490) ([Antonio Andelic](https://github.com/antonio2368)).
* Push down filter expression from JOIN ON when possible. [#75536](https://github.com/ClickHouse/ClickHouse/pull/75536) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Better error messages at syntax errors. Previously, if the query was too large, and the token whose length exceeds the limit is a very large string literal, the message about the reason was lost in the middle of two examples of this very long token. Fix the issue when a query with UTF-8 was cut incorrectly in the error message. Fix excessive quoting of query fragments. This closes [#75473](https://github.com/ClickHouse/ClickHouse/issues/75473). [#75561](https://github.com/ClickHouse/ClickHouse/pull/75561) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add profile events in storage `S3(Azure)Queue`. [#75618](https://github.com/ClickHouse/ClickHouse/pull/75618) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Disable sending settings from server to client (`send_settings_to_client=false`) for compatibility (This feature will be re-implemented as client setting later for better usability). [#75648](https://github.com/ClickHouse/ClickHouse/pull/75648) ([Michael Kolupaev](https://github.com/al13n321)).
* Add a config `memory_worker_correct_memory_tracker` to enable correction of internal memory tracker with information from different source read in the background thread periodically. [#75714](https://github.com/ClickHouse/ClickHouse/pull/75714) ([Antonio Andelic](https://github.com/antonio2368)).
* Use Analyzer in PrometheusRemoteReadProtocol. [#75729](https://github.com/ClickHouse/ClickHouse/pull/75729) ([Dmitry Novik](https://github.com/novikd)).
* Add column `normalized_query_hash` into `system.processes`. Note: while it can be easily calculated on the fly with the `normalizedQueryHash` function, this is needed to prepare for subsequent changes. [#75756](https://github.com/ClickHouse/ClickHouse/pull/75756) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Querying `system.tables` will not throw even if there is a `Merge` table created over a database that no longer exists. Remove the `getTotalRows` method from `Hive` tables, because we don't allow it to do complex work. [#75772](https://github.com/ClickHouse/ClickHouse/pull/75772) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Web UI now has interactive database navigation. [#75777](https://github.com/ClickHouse/ClickHouse/pull/75777) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to combine read-only and read-write disks in storage policy (as multiple volumes, or multiple disks). This allows to read data from the entire volume, while inserts will prefer the writable disk (i.e. Copy-on-Write storage policy). [#75862](https://github.com/ClickHouse/ClickHouse/pull/75862) ([Azat Khuzhin](https://github.com/azat)).
* Store start_time/end_time for Backups with microseconds. [#75929](https://github.com/ClickHouse/ClickHouse/pull/75929) ([Aleksandr Musorin](https://github.com/AVMusorin)).
* Add `MemoryTrackingUncorrected` metric showing value of internal global memory tracker which is not corrected by RSS. [#75935](https://github.com/ClickHouse/ClickHouse/pull/75935) ([Antonio Andelic](https://github.com/antonio2368)).
* Calculate columns and indices sizes lazily in MergeTree. [#75938](https://github.com/ClickHouse/ClickHouse/pull/75938) ([Pavel Kruglov](https://github.com/Avogar)).
* Allow to parse endpoints like `localhost:1234/handle` in `postgresql` or `mysql` table functions. This fixes a regression introduced in https://github.com/ClickHouse/ClickHouse/pull/52503. [#75944](https://github.com/ClickHouse/ClickHouse/pull/75944) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Added a server setting `throw_on_unknown_workload` that allows to choose behavior on query with `workload` setting set to unknown value: either allow unlimited access (default) or throw a `RESOURCE_ACCESS_DENIED` error. It is useful to force all queries to use workload scheduling. [#75999](https://github.com/ClickHouse/ClickHouse/pull/75999) ([Sergei Trifonov](https://github.com/serxa)).
* Make the new, experimental Kafka table engine fully respect Keeper feature flags. [#76004](https://github.com/ClickHouse/ClickHouse/pull/76004) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Don't rewrite subcolumns to getSubcolumn in ARRAY JOIN if not necessary. [#76018](https://github.com/ClickHouse/ClickHouse/pull/76018) ([Pavel Kruglov](https://github.com/Avogar)).
* Retry coordination errors when loading tables. [#76020](https://github.com/ClickHouse/ClickHouse/pull/76020) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Support flushing individual logs in SYSTEM FLUSH LOGS. [#76132](https://github.com/ClickHouse/ClickHouse/pull/76132) ([Raúl Marín](https://github.com/Algunenano)).
* Improved the `/binary` server's page. Using the Hilbert curve instead of the Morton curve. Display 512 MB worth of addresses in the square, which fills the square better (in previous versions, addresses fill only half of the square). Color addresses closer to the library name rather than the function name. Allow scrolling a bit more outside of the area. [#76192](https://github.com/ClickHouse/ClickHouse/pull/76192) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Retry ON CLUSTER queries in case of TOO_MANY_SIMULTANEOUS_QUERIES. [#76352](https://github.com/ClickHouse/ClickHouse/pull/76352) ([Patrick Galbraith](https://github.com/CaptTofu)).
* Add the `CPUOverload` asynchronous metric, which calculates the relative CPU deficit of the server. [#76404](https://github.com/ClickHouse/ClickHouse/pull/76404) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Changed the default value of `output_format_pretty_max_rows` from 10000 to 1000. I think it is better for usability. [#76407](https://github.com/ClickHouse/ClickHouse/pull/76407) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#76611](https://github.com/ClickHouse/ClickHouse/issues/76611): Use correct fallback when multipart copy to S3 fails during backup with Access Denied. Multi part copy can generate Access Denied error when backup is done between buckets that have different credentials. [#76515](https://github.com/ClickHouse/ClickHouse/pull/76515) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76735](https://github.com/ClickHouse/ClickHouse/issues/76735): Fix validation of s3 request settings. [#76658](https://github.com/ClickHouse/ClickHouse/pull/76658) ([Vitaly Baranov](https://github.com/vitlibar)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Fix identifier resolution from parent scopes. Allow the use of aliases to expressions in the WITH clause. Fixes [#58994](https://github.com/ClickHouse/ClickHouse/issues/58994). Fixes [#62946](https://github.com/ClickHouse/ClickHouse/issues/62946). Fixes [#63239](https://github.com/ClickHouse/ClickHouse/issues/63239). Fixes [#65233](https://github.com/ClickHouse/ClickHouse/issues/65233). Fixes [#71659](https://github.com/ClickHouse/ClickHouse/issues/71659). Fixes [#71828](https://github.com/ClickHouse/ClickHouse/issues/71828). Fixes [#68749](https://github.com/ClickHouse/ClickHouse/issues/68749). [#66143](https://github.com/ClickHouse/ClickHouse/pull/66143) ([Dmitry Novik](https://github.com/novikd)).
* Fix negate function monotonicity. In previous versions, the query `select * from a where -x = -42;` where `x` is the primary key, can return a wrong result. [#71440](https://github.com/ClickHouse/ClickHouse/pull/71440) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix empty tuple handling in arrayIntersect. This fixes [#72578](https://github.com/ClickHouse/ClickHouse/issues/72578). [#72581](https://github.com/ClickHouse/ClickHouse/pull/72581) ([Amos Bird](https://github.com/amosbird)).
* Fix reading JSON sub-object subcolumns with incorrect prefix. [#73182](https://github.com/ClickHouse/ClickHouse/pull/73182) ([Pavel Kruglov](https://github.com/Avogar)).
* Propogate Native format settings properly for client-server communication. [#73924](https://github.com/ClickHouse/ClickHouse/pull/73924) ([Pavel Kruglov](https://github.com/Avogar)).
* Check for not supported types for some storages. [#74218](https://github.com/ClickHouse/ClickHouse/pull/74218) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix crash with query `INSERT INTO SELECT` over PostgreSQL interface on macOS (issue [#72938](https://github.com/ClickHouse/ClickHouse/issues/72938)). [#74231](https://github.com/ClickHouse/ClickHouse/pull/74231) ([Artem Yurov](https://github.com/ArtemYurov)).
* Fixed uninitialized max_log_ptr in the replicated database. [#74336](https://github.com/ClickHouse/ClickHouse/pull/74336) ([Konstantin Morozov](https://github.com/k-morozov)).
* Fix crash when inserting interval (issue [#74299](https://github.com/ClickHouse/ClickHouse/issues/74299)). [#74478](https://github.com/ClickHouse/ClickHouse/pull/74478) ([NamHoaiNguyen](https://github.com/NamHoaiNguyen)).
* Fix formatting constant JSON literals. Previously it could lead to syntax errors during sending the query to another server. [#74533](https://github.com/ClickHouse/ClickHouse/pull/74533) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix broken create query when using constant partition expressions with implicit projections enabled. This fixes [#74596](https://github.com/ClickHouse/ClickHouse/issues/74596) . [#74634](https://github.com/ClickHouse/ClickHouse/pull/74634) ([Amos Bird](https://github.com/amosbird)).
* Avoid leaving connection in broken state after INSERT finishes with exception. [#74740](https://github.com/ClickHouse/ClickHouse/pull/74740) ([Azat Khuzhin](https://github.com/azat)).
* Avoid reusing connections that had been left in the intermediate state. [#74749](https://github.com/ClickHouse/ClickHouse/pull/74749) ([Azat Khuzhin](https://github.com/azat)).
* Fix crash during JSON type declaration parsing when type name is not uppercase. [#74784](https://github.com/ClickHouse/ClickHouse/pull/74784) ([Pavel Kruglov](https://github.com/Avogar)).
* Keeper: fix logical_error when the connection had been terminated before establishing. [#74844](https://github.com/ClickHouse/ClickHouse/pull/74844) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix a behavior when the server couldn't startup when there's a table using `AzureBlobStorage`. Tables are loaded without any requests to Azure. [#74880](https://github.com/ClickHouse/ClickHouse/pull/74880) ([Alexey Katsman](https://github.com/alexkats)).
* Fix missing `used_privileges` and `missing_privileges` fields in `query_log` for BACKUP and RESTORE operations. [#74887](https://github.com/ClickHouse/ClickHouse/pull/74887) ([Alexey Katsman](https://github.com/alexkats)).
* HDFS refresh krb ticket if sasl error during hdfs select request. [#74930](https://github.com/ClickHouse/ClickHouse/pull/74930) ([inv2004](https://github.com/inv2004)).
* Fix queries to Replicated database in startup_scripts. [#74942](https://github.com/ClickHouse/ClickHouse/pull/74942) ([Azat Khuzhin](https://github.com/azat)).
* Fix issues with expressions type aliased in the JOIN ON clause when a null-safe comparison is used. [#74970](https://github.com/ClickHouse/ClickHouse/pull/74970) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Revert part's state from deleting back to outdated when remove operation has failed. [#74985](https://github.com/ClickHouse/ClickHouse/pull/74985) ([Sema Checherinda](https://github.com/CheSema)).
* In previous versions, when there was a scalar subquery, we started writing the progress (accumulated from processing the subquery) during the initialization of the data format, which was before HTTP headers were written. This led to the loss of HTTP headers, such as X-ClickHouse-QueryId and X-ClickHouse-Format, as well as Content-Type. [#74991](https://github.com/ClickHouse/ClickHouse/pull/74991) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix `CREATE TABLE AS...` queries for `database_replicated_allow_replicated_engine_arguments=0`. [#75000](https://github.com/ClickHouse/ClickHouse/pull/75000) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix leaving connection in a bad state in client after INSERT exceptions. [#75030](https://github.com/ClickHouse/ClickHouse/pull/75030) ([Azat Khuzhin](https://github.com/azat)).
* Fix crash due to uncaught exception in PSQL replication. [#75062](https://github.com/ClickHouse/ClickHouse/pull/75062) ([Azat Khuzhin](https://github.com/azat)).
* Sasl can fail any rpc call, the fix helps to repeat the call in case if krb5 ticker is expired. [#75063](https://github.com/ClickHouse/ClickHouse/pull/75063) ([inv2004](https://github.com/inv2004)).
* Fixed usage of indexes (primary and secondary) for `Array`, `Map` and `Nullable(..)` columns with enabled setting `optimize_function_to_subcolumns`. Previously, indexes for these columns could have been ignored. [#75081](https://github.com/ClickHouse/ClickHouse/pull/75081) ([Anton Popov](https://github.com/CurtizJ)).
* Disable `flatten_nested` when creating materialized views with inner tables since it will not be possible to use such flattened columns. [#75085](https://github.com/ClickHouse/ClickHouse/pull/75085) ([Christoph Wurm](https://github.com/cwurm)).
* Fix for some of IPv6 addresses (such as ::ffff:1.1.1.1) in forwarded_for field is wrongly interpreted resulting in client disconnect with exception. [#75133](https://github.com/ClickHouse/ClickHouse/pull/75133) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix nullsafe JOIN handling for LowCardinality nullable data type. Previously JOIN ON with nullsafe comparison, such as `IS NOT DISTINCT FROM`, `<=>` , `a IS NULL AND b IS NULL OR a == b` didn't work correctly with LowCardinality columns. [#75143](https://github.com/ClickHouse/ClickHouse/pull/75143) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Checks that we don't specify key_condition when counting total_number_of_rows for NumRowsCache. [#75164](https://github.com/ClickHouse/ClickHouse/pull/75164) ([Daniil Ivanik](https://github.com/divanik)).
* Fix queries with unused interpolation with the new analyzer. [#75173](https://github.com/ClickHouse/ClickHouse/pull/75173) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Fix the crash bug of CTE with Insert. [#75188](https://github.com/ClickHouse/ClickHouse/pull/75188) ([Shichao Jin](https://github.com/jsc0218)).
* Keeper fix: avoid writing to broken changelogs when rolling back logs. [#75197](https://github.com/ClickHouse/ClickHouse/pull/75197) ([Antonio Andelic](https://github.com/antonio2368)).
* Use `BFloat16` as a supertype where appropriate. This closes: [#74404](https://github.com/ClickHouse/ClickHouse/issues/74404). [#75236](https://github.com/ClickHouse/ClickHouse/pull/75236) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix unexpected defaults in join result with any_join_distinct_right_table_keys and OR in JOIN ON. [#75262](https://github.com/ClickHouse/ClickHouse/pull/75262) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Mask azureblobstorage table engine credentials. [#75319](https://github.com/ClickHouse/ClickHouse/pull/75319) ([Garrett Thomas](https://github.com/garrettthomaskth)).
* Fixed behavior when ClickHouse may erroneously do a filter pushdown to an external database like PostgreSQL, MySQL, or SQLite. This closes: [#71423](https://github.com/ClickHouse/ClickHouse/issues/71423). [#75320](https://github.com/ClickHouse/ClickHouse/pull/75320) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix crash in protobuf schema cache that can happen during output in Protobuf format and parallel query `SYSTEM DROP FORMAT SCHEMA CACHE`. [#75357](https://github.com/ClickHouse/ClickHouse/pull/75357) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix a possible logical error or uninitialized memory issue when a filter from `HAVING` is pushed down with parallel replicas. [#75363](https://github.com/ClickHouse/ClickHouse/pull/75363) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Hide sensitive info for `icebergS3`, `icebergAzure` table functions and table engines. [#75378](https://github.com/ClickHouse/ClickHouse/pull/75378) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Function `TRIM` with computed empty trim characters are now correctly handled. Example: `SELECT TRIM(LEADING concat('') FROM 'foo')` (Issue [#69922](https://github.com/ClickHouse/ClickHouse/issues/69922)). [#75399](https://github.com/ClickHouse/ClickHouse/pull/75399) ([Manish Gill](https://github.com/mgill25)).
* Fix data race in IOutputFormat. [#75448](https://github.com/ClickHouse/ClickHouse/pull/75448) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix possible error `Elements ... and ... of Nested data structure ... (Array columns) have different array sizes` when JSON subcolumns with Array type are used in JOIN over distributed tables. [#75512](https://github.com/ClickHouse/ClickHouse/pull/75512) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix invalid result buffer size calculation. Closes [#70031](https://github.com/ClickHouse/ClickHouse/issues/70031). [#75548](https://github.com/ClickHouse/ClickHouse/pull/75548) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix interaction between allow_feature_tier and compatibility mergetree setting. [#75635](https://github.com/ClickHouse/ClickHouse/pull/75635) ([Raúl Marín](https://github.com/Algunenano)).
* Fix incorrect processed_rows value in system.s3queue_log in case file was retried. [#75666](https://github.com/ClickHouse/ClickHouse/pull/75666) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Respect `materialized_views_ignore_errors` when a materialized view writes to a URL engine and there is a connectivity issue. [#75679](https://github.com/ClickHouse/ClickHouse/pull/75679) ([Christoph Wurm](https://github.com/cwurm)).
* Fixed rare crashes while reading from `MergeTree` table after multiple asynchronous `RENAME` queries (with `alter_sync = 0`) between columns with different types. [#75693](https://github.com/ClickHouse/ClickHouse/pull/75693) ([Anton Popov](https://github.com/CurtizJ)).
* Fix `Block structure mismatch in QueryPipeline stream` error for some queries with `UNION ALL`. [#75715](https://github.com/ClickHouse/ClickHouse/pull/75715) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Rebuild projection on alter modify of its PK column. Previously it could lead to `CANNOT_READ_ALL_DATA` errors during selects after alter modify of the column used in projection PK. [#75720](https://github.com/ClickHouse/ClickHouse/pull/75720) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix incorrect result of `ARRAY JOIN` for scalar subqueries (with analyzer). [#75732](https://github.com/ClickHouse/ClickHouse/pull/75732) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed null pointer dereference in `DistinctSortedStreamTransform`. [#75734](https://github.com/ClickHouse/ClickHouse/pull/75734) ([Nikita Taranov](https://github.com/nickitat)).
* Fix `allow_suspicious_ttl_expressions` behaviour. [#75771](https://github.com/ClickHouse/ClickHouse/pull/75771) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Fix uninitialized memory read in function `translate`. This closes [#75592](https://github.com/ClickHouse/ClickHouse/issues/75592). [#75794](https://github.com/ClickHouse/ClickHouse/pull/75794) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Propagate format settings to JSON as string formatting in Native format. [#75832](https://github.com/ClickHouse/ClickHouse/pull/75832) ([Pavel Kruglov](https://github.com/Avogar)).
* Recorded the default enablement of parallel hash as join algorithm in v24.12 in the settings change history. This means that ClickHouse will continue to join using non-parallel hash if an older compatibility level than v24.12 is configured. [#75870](https://github.com/ClickHouse/ClickHouse/pull/75870) ([Robert Schulze](https://github.com/rschu1ze)).
* Fixed a bug that tables with implicitly added min-max indices could not be copied into a new table (issue [#75677](https://github.com/ClickHouse/ClickHouse/issues/75677)). [#75877](https://github.com/ClickHouse/ClickHouse/pull/75877) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* `clickhouse-library-bridge` allows opening arbitrary libraries from the filesystem, which makes it safe to run only inside an isolated environment. To prevent a vulnerability when it is run near the clickhouse-server, we will limit the paths of libraries to a location, provided in the configuration. This vulnerability was found with the [ClickHouse Bug Bounty Program](https://github.com/ClickHouse/ClickHouse/issues/38986) by **Arseniy Dugin**. [#75954](https://github.com/ClickHouse/ClickHouse/pull/75954) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* We happened to use JSON serialization for some metadata, which was a mistake, because JSON does not support binary data inside string literals, including zero bytes. SQL queries can contain binary data and invalid UTF-8, so we have to support this in our metadata files as well. At the same time, ClickHouse's `JSONEachRow` and similar formats work around that by deviating from the JSON standard in favor of a perfect roundtrip for the binary data. See the motivation here: https://github.com/ClickHouse/ClickHouse/pull/73668#issuecomment-2560501790. The solution is to make `Poco::JSON` library consistent with the JSON format serialization in ClickHouse. This closes [#73668](https://github.com/ClickHouse/ClickHouse/issues/73668). [#75963](https://github.com/ClickHouse/ClickHouse/pull/75963) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix check for commit limits in storage `S3Queue`. [#76104](https://github.com/ClickHouse/ClickHouse/pull/76104) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix attaching MergeTree tables with auto indexes (`add_minmax_index_for_numeric_columns`/`add_minmax_index_for_string_columns`). [#76139](https://github.com/ClickHouse/ClickHouse/pull/76139) ([Azat Khuzhin](https://github.com/azat)).
* Fixed issue of stack traces from parent threads of a job (`enable_job_stack_trace` setting) are not printed out. Fixed issue `enable_job_stack_trace` setting is not properly propagated to the threads resulting stack trace content not always respects this setting. [#76191](https://github.com/ClickHouse/ClickHouse/pull/76191) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix incorrect permission check where `ALTER RENAME` required `CREATE USER` grant. Closes [#74372](https://github.com/ClickHouse/ClickHouse/issues/74372). [#76241](https://github.com/ClickHouse/ClickHouse/pull/76241) ([pufit](https://github.com/pufit)).
* Fix reinterpretAs with FixedString on big-endian architecture. [#76253](https://github.com/ClickHouse/ClickHouse/pull/76253) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#76620](https://github.com/ClickHouse/ClickHouse/issues/76620): Fix all sort of bugs due to race between UUID and table names (for instance it will fix the race between `RENAME` and `RESTART REPLICA`, in case of concurrent `RENAME` with `SYSTEM RESTART REPLICA` you may get end up restarting wrong replica, or/and leaving one of the tables in a `Table X is being restarted` state). [#76308](https://github.com/ClickHouse/ClickHouse/pull/76308) ([Azat Khuzhin](https://github.com/azat)).
* Fix logical error in S3Queue "Expected current processor {} to be equal to {} for bucket {}". [#76358](https://github.com/ClickHouse/ClickHouse/pull/76358) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix deadlock for ALTER with Memory database. [#76359](https://github.com/ClickHouse/ClickHouse/pull/76359) ([Azat Khuzhin](https://github.com/azat)).
* Fix logical error in index analysis if condition in `WHERE` has `pointInPolygon` function. [#76360](https://github.com/ClickHouse/ClickHouse/pull/76360) ([Anton Popov](https://github.com/CurtizJ)).
* Removed allocation from the signal handler. [#76446](https://github.com/ClickHouse/ClickHouse/pull/76446) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#76649](https://github.com/ClickHouse/ClickHouse/issues/76649): Fixed `used_flag` initialization in parallel hash. It might cause a server crash. [#76580](https://github.com/ClickHouse/ClickHouse/pull/76580) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#76783](https://github.com/ClickHouse/ClickHouse/issues/76783): Fix an error `Not found column in block` after altering a table with a subcolumn in PK. After https://github.com/ClickHouse/ClickHouse/pull/72644, requires https://github.com/ClickHouse/ClickHouse/pull/74403. [#76686](https://github.com/ClickHouse/ClickHouse/pull/76686) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#76835](https://github.com/ClickHouse/ClickHouse/issues/76835): Flush output write buffers before finalizing them. Fix `LOGICAL_ERROR` generated during the finalization of some output format, e.g. `JSONEachRowWithProgressRowOutputFormat`. [#76726](https://github.com/ClickHouse/ClickHouse/pull/76726) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76876](https://github.com/ClickHouse/ClickHouse/issues/76876): Fix reverse key analysis for explicitly defined primary keys. Similar to [#76654](https://github.com/ClickHouse/ClickHouse/issues/76654). [#76846](https://github.com/ClickHouse/ClickHouse/pull/76846) ([Amos Bird](https://github.com/amosbird)).

#### Build/Testing/Packaging Improvement
* Restore deleted nats integration tests and fix errors. - fixed some race conditions in nats engine - fixed data loss when streaming data to nats in case of connection loss - fixed freeze of receiving the last chunk of data when streaming from nats ended - nats_max_reconnect is deprecated and has no effect, reconnect is performed permanently with nats_reconnect_wait timeout. [#69772](https://github.com/ClickHouse/ClickHouse/pull/69772) ([Dmitry Novikov](https://github.com/dmitry-sles-novikov)).
* Support build HDFS on both ARM and Intel mac. [#74244](https://github.com/ClickHouse/ClickHouse/pull/74244) ([Yan Xin](https://github.com/yxheartipp)).
* Update to embedded LLVM 19. [#75148](https://github.com/ClickHouse/ClickHouse/pull/75148) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* *Potentially breaking*: Improvement to set even more restrictive defaults. The current defaults are already secure - the user has to specify an option to publish ports explicitly. But when the `default` user doesn’t have a password set by `CLICKHOUSE_PASSWORD` and/or a username changed by `CLICKHOUSE_USER` environment variables, it should be available only from the local system as an additional level of protection. [#75259](https://github.com/ClickHouse/ClickHouse/pull/75259) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Integration tests have 1 hour timeout for single batch of parallel tests running. When this timeout is reached `pytest` is killed without some logs. Internal pytest timeout is set to 55 minutes to print results from a session and not trigger external timeout signal. Closes [#75532](https://github.com/ClickHouse/ClickHouse/issues/75532). [#75533](https://github.com/ClickHouse/ClickHouse/pull/75533) ([Ilya Yatsishin](https://github.com/qoega)).
* Make all clickhouse-server related actions a function, and execute them only when launching the default binary in `entrypoint.sh`. A long-postponed improvement was suggested in [#50724](https://github.com/ClickHouse/ClickHouse/issues/50724). Added switch `--users` to `clickhouse-extract-from-config` to get values from the `users.xml`. [#75643](https://github.com/ClickHouse/ClickHouse/pull/75643) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* For stress tests if server did not exit while we collected stacktraces via gdb additional wait time is added to make `Possible deadlock on shutdown (see gdb.log)` detection less noisy. It will only add delay for cases when test did not finish successfully. [#75668](https://github.com/ClickHouse/ClickHouse/pull/75668) ([Ilya Yatsishin](https://github.com/qoega)).
* Enable ICU and GRPC when cross-compiling for Darwin. [#75922](https://github.com/ClickHouse/ClickHouse/pull/75922) ([Raúl Marín](https://github.com/Algunenano)).
* Fixing splitting test's output because of `sleep` during the process group killing. [#76090](https://github.com/ClickHouse/ClickHouse/pull/76090) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Do not collect the `docker-compose` logs at the end of running since the script is often killed. Instead, collect them in the background. [#76140](https://github.com/ClickHouse/ClickHouse/pull/76140) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Split tests for kafka storage into a few files. Fixes [#69452](https://github.com/ClickHouse/ClickHouse/issues/69452). [#76208](https://github.com/ClickHouse/ClickHouse/pull/76208) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Remove about 20MB of dead code from the binary. [#76226](https://github.com/ClickHouse/ClickHouse/pull/76226) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The long time outdated `pytest-random` is replaced by `pytest-random-order`. Enable `random-order` for flaky tests. Fix `test_dns_cache_update`. [#76233](https://github.com/ClickHouse/ClickHouse/pull/76233) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Raise minimum required CMake version to 3.25 due to `block()` introduction. [#76316](https://github.com/ClickHouse/ClickHouse/pull/76316) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Bump `lz4` to `1.10.0`. [#76571](https://github.com/ClickHouse/ClickHouse/pull/76571) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Bump `curl` to `8.12.1`. [#76572](https://github.com/ClickHouse/ClickHouse/pull/76572) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Fix toStartOfInterval with negative values (toStartOfIntevalAllowNegative) "'. [#75130](https://github.com/ClickHouse/ClickHouse/pull/75130) ([Robert Schulze](https://github.com/rschu1ze)).
* NO CL ENTRY:  'Revert "Fix NATS integration tests"'. [#75415](https://github.com/ClickHouse/ClickHouse/pull/75415) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "CI: Fix merge-commit toggle in praktika"'. [#76125](https://github.com/ClickHouse/ClickHouse/pull/76125) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Revert "CI: Fix merge-commit toggle in praktika""'. [#76162](https://github.com/ClickHouse/ClickHouse/pull/76162) ([Max Kainov](https://github.com/maxknv)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix wrong diagnostic in Client and Local apps. [#66999](https://github.com/ClickHouse/ClickHouse/pull/66999) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* optimize rockskeeper. [#69784](https://github.com/ClickHouse/ClickHouse/pull/69784) ([Han Fei](https://github.com/hanfei1991)).
* Write Parquet bloom filters. [#71681](https://github.com/ClickHouse/ClickHouse/pull/71681) ([Michael Kolupaev](https://github.com/al13n321)).
* Enable reverse key support in PartsSplitter. This fixes [#73400](https://github.com/ClickHouse/ClickHouse/issues/73400). Not included in changelog as the experimental feature has not been released yet. [#73418](https://github.com/ClickHouse/ClickHouse/pull/73418) ([Amos Bird](https://github.com/amosbird)).
* Buzzhouse update. [#74361](https://github.com/ClickHouse/ClickHouse/pull/74361) ([Pedro Ferreira](https://github.com/PedroTadim)).
* CollapsingMergeTree: Do not include rows with invalid sign for FINAL. [#74486](https://github.com/ClickHouse/ClickHouse/pull/74486) ([Christoph Wurm](https://github.com/cwurm)).
* Add missed include <stdlib.h> && <vector>. [#74490](https://github.com/ClickHouse/ClickHouse/pull/74490) ([Mikhnenko Sasha](https://github.com/4JustMe4)).
* MergerMutator minor improvements. [#74544](https://github.com/ClickHouse/ClickHouse/pull/74544) ([Mikhail Artemenko](https://github.com/Michicosun)).
* clickhouse-test: add randomization for setting `optimize_extract_common_expressions`. [#74679](https://github.com/ClickHouse/ClickHouse/pull/74679) ([Nikita Fomichev](https://github.com/fm4v)).
* CI: Improve docs check logs readability. [#74693](https://github.com/ClickHouse/ClickHouse/pull/74693) ([Damian Maślanka](https://github.com/DamianMaslanka5)).
* The gdb command is executed inside the container and trying to pass the path of our script directory causes `No such file or directory`. [#74695](https://github.com/ClickHouse/ClickHouse/pull/74695) ([Nikolay Degterinsky](https://github.com/evillique)).
* More forward declarations around S3/Azure/IObjectStorage/IDisk. [#74705](https://github.com/ClickHouse/ClickHouse/pull/74705) ([Azat Khuzhin](https://github.com/azat)).
* A long hanging task to improve docs. [#74724](https://github.com/ClickHouse/ClickHouse/pull/74724) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix `02597_column_update_and_replication`. [#74826](https://github.com/ClickHouse/ClickHouse/pull/74826) ([Nikita Taranov](https://github.com/nickitat)).
* Fix misuse seconds and microseconds in system.kafka_consumers. [#74834](https://github.com/ClickHouse/ClickHouse/pull/74834) ([Aleksandr Musorin](https://github.com/AVMusorin)).
* This closes: [#71930](https://github.com/ClickHouse/ClickHouse/issues/71930). [#74842](https://github.com/ClickHouse/ClickHouse/pull/74842) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Stateless tests: move stateful tests to stateless. [#74882](https://github.com/ClickHouse/ClickHouse/pull/74882) ([Nikita Fomichev](https://github.com/fm4v)).
* Backported in [#76798](https://github.com/ClickHouse/ClickHouse/issues/76798): Use delta-kernel-rs for delta lake integration. [#74884](https://github.com/ClickHouse/ClickHouse/pull/74884) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Enabling JoinStepLogical. [#74909](https://github.com/ClickHouse/ClickHouse/pull/74909) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix test_storage_s3_queue/test.py::test_alter_table. [#74938](https://github.com/ClickHouse/ClickHouse/pull/74938) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Closes [#74860](https://github.com/ClickHouse/ClickHouse/issues/74860). [#74947](https://github.com/ClickHouse/ClickHouse/pull/74947) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Closes [#74357](https://github.com/ClickHouse/ClickHouse/issues/74357). [#74948](https://github.com/ClickHouse/ClickHouse/pull/74948) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Tidy the logic of using database disk. [#74961](https://github.com/ClickHouse/ClickHouse/pull/74961) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Support "from_zk" attribute in encrypt_decrypt tool. [#74968](https://github.com/ClickHouse/ClickHouse/pull/74968) ([Mikhail Gorshkov](https://github.com/mgorshkov)).
* Minor refactoring of `MergeTree` data parts. [#74972](https://github.com/ClickHouse/ClickHouse/pull/74972) ([Anton Popov](https://github.com/CurtizJ)).
* fix msan use-of-uninitialized-value in scheduler test. [#74973](https://github.com/ClickHouse/ClickHouse/pull/74973) ([Sergei Trifonov](https://github.com/serxa)).
* Refactoring of `MergeTreeRangeReader`. [#74975](https://github.com/ClickHouse/ClickHouse/pull/74975) ([Anton Popov](https://github.com/CurtizJ)).
* Disable PR for 00755_avg_value_size_hint_passing. [#74979](https://github.com/ClickHouse/ClickHouse/pull/74979) ([Igor Nikonov](https://github.com/devcrafter)).
* Just to better understand how many rows were filtered at each step. [#74981](https://github.com/ClickHouse/ClickHouse/pull/74981) ([Alexander Gololobov](https://github.com/davenger)).
* CI: Update CH version log in praktika CI. [#74984](https://github.com/ClickHouse/ClickHouse/pull/74984) ([Max Kainov](https://github.com/maxknv)).
* Allow to move predicates with `indexHint` function to `PREWHERE`. [#74987](https://github.com/ClickHouse/ClickHouse/pull/74987) ([Anton Popov](https://github.com/CurtizJ)).
* Prepare ci.py and job scripts to be called from praktika runner - jobs are to read artifact_report instead of build report if available, read job batch num from check name if set - ci.py option --run-from-praktika to trigger job run and post commit status with legacy report on completion - isort and black were temporarily disabled due to challenges in toggling autofix feature across workflows during migration **praktika:** - add feature to toggle GH's CI merge-commit via GH vars - artifact report to serve as legacy build report to adopt old jobs - all old jobs added as is into praktika job configuration. [#74992](https://github.com/ClickHouse/ClickHouse/pull/74992) ([Max Kainov](https://github.com/maxknv)).
* Expose more X-ClickHouse headers to the browser. [#74995](https://github.com/ClickHouse/ClickHouse/pull/74995) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add validation if cache disk fs size is less than specified cache disk max size. [#74997](https://github.com/ClickHouse/ClickHouse/pull/74997) ([Pradeep Chhetri](https://github.com/chhetripradeep)).
* Update README.md. [#74998](https://github.com/ClickHouse/ClickHouse/pull/74998) ([Tanya Bragin](https://github.com/tbragin)).
* Update version after release. [#75002](https://github.com/ClickHouse/ClickHouse/pull/75002) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Changelog for 25.1. [#75009](https://github.com/ClickHouse/ClickHouse/pull/75009) ([Raúl Marín](https://github.com/Algunenano)).
* Rename setting `bg_reconnect_mysql_dict_interval` to `dictionary_background_reconnect_interval`. [#75013](https://github.com/ClickHouse/ClickHouse/pull/75013) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Add a description for `skip_redundant_aliases_in_udf` setting. [#75014](https://github.com/ClickHouse/ClickHouse/pull/75014) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix settings changes history for 25.1 and 24.12. [#75015](https://github.com/ClickHouse/ClickHouse/pull/75015) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Small usability improvements for Sasha. [#75022](https://github.com/ClickHouse/ClickHouse/pull/75022) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix `03319_http_exception_formatting_during_interpretation`. [#75059](https://github.com/ClickHouse/ClickHouse/pull/75059) ([Antonio Andelic](https://github.com/antonio2368)).
* Update README.md. [#75064](https://github.com/ClickHouse/ClickHouse/pull/75064) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix flaky 01674_filter_by_uint8.sql. [#75066](https://github.com/ClickHouse/ClickHouse/pull/75066) ([Igor Nikonov](https://github.com/devcrafter)).
* ci: fix "can't subtract offset-naive and offset-aware datetimes". [#75067](https://github.com/ClickHouse/ClickHouse/pull/75067) ([Azat Khuzhin](https://github.com/azat)).
* Rework test 03307_parallel_hash_max_joined_rows. [#75071](https://github.com/ClickHouse/ClickHouse/pull/75071) ([Nikita Taranov](https://github.com/nickitat)).
* Exclude `00157_cache_dictionary` from msan. [#75073](https://github.com/ClickHouse/ClickHouse/pull/75073) ([Robert Schulze](https://github.com/rschu1ze)).
* Fixed missing dependency causing [missing reports](https://s3.amazonaws.com/clickhouse-test-reports/66999/122223eaa39c9e8c45045c9e2cc3ce7d7a43dd02/builds/report.html). [#75082](https://github.com/ClickHouse/ClickHouse/pull/75082) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add a test for client start up speed. [#75083](https://github.com/ClickHouse/ClickHouse/pull/75083) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix 03312_squashing_with_low_card_mem_usage for private. [#75084](https://github.com/ClickHouse/ClickHouse/pull/75084) ([Nikita Taranov](https://github.com/nickitat)).
* Add README.md for `Bridge*/` and `Function/` directories. [#75089](https://github.com/ClickHouse/ClickHouse/pull/75089) ([Robert Schulze](https://github.com/rschu1ze)).
* Build_check and performance_comparison jobs adapted to run from praktika. [#75103](https://github.com/ClickHouse/ClickHouse/pull/75103) ([Max Kainov](https://github.com/maxknv)).
* Compressor: add --no-checksum-validation option. [#75104](https://github.com/ClickHouse/ClickHouse/pull/75104) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix master workflow dependencies. [#75110](https://github.com/ClickHouse/ClickHouse/pull/75110) ([Max Kainov](https://github.com/maxknv)).
* Follow up to [#74715](https://github.com/ClickHouse/ClickHouse/issues/74715) (fixes flaky `test_storage_s3_queue/test.py::test_shards`). [#75127](https://github.com/ClickHouse/ClickHouse/pull/75127) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Minor changelog update. [#75131](https://github.com/ClickHouse/ClickHouse/pull/75131) ([Robert Schulze](https://github.com/rschu1ze)).
* Better perf test for 74082. [#75132](https://github.com/ClickHouse/ClickHouse/pull/75132) ([Nikita Taranov](https://github.com/nickitat)).
* Explicit instantiation of LowCardinalityDictionaryCache::cache. [#75141](https://github.com/ClickHouse/ClickHouse/pull/75141) ([Raúl Marín](https://github.com/Algunenano)).
* Intexp: try to reduce compilation time. [#75142](https://github.com/ClickHouse/ClickHouse/pull/75142) ([Raúl Marín](https://github.com/Algunenano)).
* Fix flaky 03047_on_fly_mutations_multiple_updates_rmt when PR is enabled. [#75144](https://github.com/ClickHouse/ClickHouse/pull/75144) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix `chcache` reporting on compiler failure. [#75147](https://github.com/ClickHouse/ClickHouse/pull/75147) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Remove dependencies on VersionNumber.h. [#75153](https://github.com/ClickHouse/ClickHouse/pull/75153) ([Raúl Marín](https://github.com/Algunenano)).
* Add README.md for Analyzer/ and Planner/ directories. [#75157](https://github.com/ClickHouse/ClickHouse/pull/75157) ([Dmitry Novik](https://github.com/novikd)).
* Tests: add 'error' test hint for functional tests. [#75158](https://github.com/ClickHouse/ClickHouse/pull/75158) ([Nikita Fomichev](https://github.com/fm4v)).
* Fixes assert in job script. [#75172](https://github.com/ClickHouse/ClickHouse/pull/75172) ([Max Kainov](https://github.com/maxknv)).
* Toggling merge-commit in runtime causes inconsistencies in config. hardcode checkout from branch head to fix this. [#75178](https://github.com/ClickHouse/ClickHouse/pull/75178) ([Max Kainov](https://github.com/maxknv)).
* Update version_date.tsv and changelog after v25.1.1.4165-stable. [#75179](https://github.com/ClickHouse/ClickHouse/pull/75179) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix unit test `FindSymbols.RunTimeNeedle` on ARM. [#75182](https://github.com/ClickHouse/ClickHouse/pull/75182) ([Harish Subramanian](https://github.com/harishisnow)).
* Do not ask for auth prematurally in the Play UI. [#75183](https://github.com/ClickHouse/ClickHouse/pull/75183) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add More Info for 01852_dictionary_found_rate_long. [#75184](https://github.com/ClickHouse/ClickHouse/pull/75184) ([Shichao Jin](https://github.com/jsc0218)).
* Remove slightly incorrect assert in ~ZooKeeperMetadataTransaction. [#75185](https://github.com/ClickHouse/ClickHouse/pull/75185) ([Michael Kolupaev](https://github.com/al13n321)).
* CI: Fix in PR workflow. [#75193](https://github.com/ClickHouse/ClickHouse/pull/75193) ([Max Kainov](https://github.com/maxknv)).
* Doing the rewrite in the last major PR for BuzzHouse, I didn't test inserts with the Nested type, because I disabled it on my settings. This PR reduces the allocations needed during inserts with Nested types and fixes a bad pointer dereference. [#75198](https://github.com/ClickHouse/ClickHouse/pull/75198) ([Pedro Ferreira](https://github.com/PedroTadim)).
* CI: Checkout reference agnostic to fork/non-fork repo. [#75199](https://github.com/ClickHouse/ClickHouse/pull/75199) ([Max Kainov](https://github.com/maxknv)).
* Fix flaky `02812_from_to_utc_timestamp.sh`. [#75212](https://github.com/ClickHouse/ClickHouse/pull/75212) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix `02350_views_max_insert_threads`. [#75216](https://github.com/ClickHouse/ClickHouse/pull/75216) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Improve compilation of Analyzer/Identifier.h. [#75218](https://github.com/ClickHouse/ClickHouse/pull/75218) ([Raúl Marín](https://github.com/Algunenano)).
* Fix test `02782_uniq_exact_parallel_merging_bug`. [#75222](https://github.com/ClickHouse/ClickHouse/pull/75222) ([Nikita Taranov](https://github.com/nickitat)).
* Don't print RSS in memory limit exceeded for query. [#75224](https://github.com/ClickHouse/ClickHouse/pull/75224) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix `nan` in Aggregator.cpp. [#75226](https://github.com/ClickHouse/ClickHouse/pull/75226) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Example of huge memory consumption: https://pastila.nl/?00c71791/9d38194748974c011c7183e0d554b6f1#FO0nldzVRCZMVIywj7kHaw==. Integration tests are the not place where we test merge algorithm, so I thing "vertical" by default is okay. For stateless test is more complex. Potentially helps [#49399](https://github.com/ClickHouse/ClickHouse/issues/49399). [#75235](https://github.com/ClickHouse/ClickHouse/pull/75235) ([alesapin](https://github.com/alesapin)).
* CI: Fix local test run for praktika. [#75238](https://github.com/ClickHouse/ClickHouse/pull/75238) ([Max Kainov](https://github.com/maxknv)).
* Fix test `03237_insert_sparse_columns_mem`. [#75242](https://github.com/ClickHouse/ClickHouse/pull/75242) ([Anton Popov](https://github.com/CurtizJ)).
* Update version_date.tsv and changelog after v25.1.2.3-stable. [#75257](https://github.com/ClickHouse/ClickHouse/pull/75257) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Relax active parts filter. [#75265](https://github.com/ClickHouse/ClickHouse/pull/75265) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Reopen [#74865](https://github.com/ClickHouse/ClickHouse/issues/74865). [#75268](https://github.com/ClickHouse/ClickHouse/pull/75268) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Reduce compilation time of magic_enum related units. [#75269](https://github.com/ClickHouse/ClickHouse/pull/75269) ([Raúl Marín](https://github.com/Algunenano)).
* Fix `PREWHERE` with constant condition and tables with non-adaptive graularity. [#75270](https://github.com/ClickHouse/ClickHouse/pull/75270) ([Anton Popov](https://github.com/CurtizJ)).
* Use smaller buffers when writing small metadata files. [#75274](https://github.com/ClickHouse/ClickHouse/pull/75274) ([Alexander Gololobov](https://github.com/davenger)).
* It doesn't reproduce on master, let's pin the behaviour by adding a test. This closes: [#71180](https://github.com/ClickHouse/ClickHouse/issues/71180). [#75275](https://github.com/ClickHouse/ClickHouse/pull/75275) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fixing 02310_clickhouse_local_INSERT_progress_profile_events test. [#75277](https://github.com/ClickHouse/ClickHouse/pull/75277) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Doesn't reproduce on master. This closes: [#70895](https://github.com/ClickHouse/ClickHouse/issues/70895). [#75278](https://github.com/ClickHouse/ClickHouse/pull/75278) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix test `01290_max_execution_speed_distributed`. [#75280](https://github.com/ClickHouse/ClickHouse/pull/75280) ([Nikita Taranov](https://github.com/nickitat)).
* CI: Fix woolenwolfdog ci mode. [#75281](https://github.com/ClickHouse/ClickHouse/pull/75281) ([Max Kainov](https://github.com/maxknv)).
* Add TSA annotations to BackgroundSchedulePool. [#75292](https://github.com/ClickHouse/ClickHouse/pull/75292) ([Pablo Marcos](https://github.com/pamarcos)).
* fix stale read race in `ReadFromRemote`. [#75293](https://github.com/ClickHouse/ClickHouse/pull/75293) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Calculate total size and allocate only once in ColumnSparse::replicate(). [#75298](https://github.com/ClickHouse/ClickHouse/pull/75298) ([Alexander Gololobov](https://github.com/davenger)).
* Introduce IColumn_fwd.h. [#75299](https://github.com/ClickHouse/ClickHouse/pull/75299) ([Raúl Marín](https://github.com/Algunenano)).
* Praktika ci cache to: - reuse job results in prs from any other ci run - reuse job results in push (master, release) from the same branch only. [#75313](https://github.com/ClickHouse/ClickHouse/pull/75313) ([Max Kainov](https://github.com/maxknv)).
* Add option to skip user setup in entrypoint.sh. [#75316](https://github.com/ClickHouse/ClickHouse/pull/75316) ([Nikita Fomichev](https://github.com/fm4v)).
* Fix LOGICAL_ERROR when Merge table tries to read from parameterized view. [#75318](https://github.com/ClickHouse/ClickHouse/pull/75318) ([Michael Kolupaev](https://github.com/al13n321)).
* The issue no longer reproduces. This closes: [#68533](https://github.com/ClickHouse/ClickHouse/issues/68533). [#75321](https://github.com/ClickHouse/ClickHouse/pull/75321) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Hopefully fix shutdown crash in ObjectStorageQueueMetadata. [#75323](https://github.com/ClickHouse/ClickHouse/pull/75323) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix `TOO_MANY_ROWS` error in `01158_zookeeper_log_long`. [#75324](https://github.com/ClickHouse/ClickHouse/pull/75324) ([Julia Kartseva](https://github.com/jkartseva)).
* Reduce includes for BackgroundSchedulePool. [#75333](https://github.com/ClickHouse/ClickHouse/pull/75333) ([Pablo Marcos](https://github.com/pamarcos)).
* Adding meetups. [#75339](https://github.com/ClickHouse/ClickHouse/pull/75339) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Revert "Merge pull request [#75015](https://github.com/ClickHouse/ClickHouse/issues/75015) from ClickHouse/fix-settings-change…. [#75340](https://github.com/ClickHouse/ClickHouse/pull/75340) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Remove unnecessary call to logQueryMetricLogFinish. [#75350](https://github.com/ClickHouse/ClickHouse/pull/75350) ([Pablo Marcos](https://github.com/pamarcos)).
* Better exception message. [#75354](https://github.com/ClickHouse/ClickHouse/pull/75354) ([Kseniia Sumarokova](https://github.com/kssenii)).
* s3queue: do not throw exception about duplicated settings on attach. [#75355](https://github.com/ClickHouse/ClickHouse/pull/75355) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Potential fix for test_disk_configuration. [#75356](https://github.com/ClickHouse/ClickHouse/pull/75356) ([Max Vostrikov](https://github.com/max-vostrikov)).
* Fix SettingsChangesHistory. [#75358](https://github.com/ClickHouse/ClickHouse/pull/75358) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Add curl to Docs dockerfile. [#75360](https://github.com/ClickHouse/ClickHouse/pull/75360) ([Shaun Struwig](https://github.com/Blargian)).
* Disable tests `test_rename_column` with sanitizers because they consume 10-40 gigabytes of memory. Fixes [#49399](https://github.com/ClickHouse/ClickHouse/issues/49399). [#75361](https://github.com/ClickHouse/ClickHouse/pull/75361) ([alesapin](https://github.com/alesapin)).
* CI: Support custom GH auth in praktika. [#75380](https://github.com/ClickHouse/ClickHouse/pull/75380) ([Max Kainov](https://github.com/maxknv)).
* Previously in case an exception happened on the client ClickHouse may stop executing other queries. This behaviour is fixed. This closes: [#69110](https://github.com/ClickHouse/ClickHouse/issues/69110). [#75383](https://github.com/ClickHouse/ClickHouse/pull/75383) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* As _Mergeable check_ and _Sync_ are now two separate _required for merge_ statuses - dependency one on another can be removed from code. [#75384](https://github.com/ClickHouse/ClickHouse/pull/75384) ([Max Kainov](https://github.com/maxknv)).
* CI: Do not block MergeQueue on Sync status. [#75388](https://github.com/ClickHouse/ClickHouse/pull/75388) ([Max Kainov](https://github.com/maxknv)).
* Update README.md - Update meetups. [#75389](https://github.com/ClickHouse/ClickHouse/pull/75389) ([Tanya Bragin](https://github.com/tbragin)).
* CI: Onboard all jobs from legacy CI to praktika workflow. [#75390](https://github.com/ClickHouse/ClickHouse/pull/75390) ([Max Kainov](https://github.com/maxknv)).
* Update Dockerfile to add sudo. [#75391](https://github.com/ClickHouse/ClickHouse/pull/75391) ([Shaun Struwig](https://github.com/Blargian)).
* Deconstruct ClusterDiscovery in Context shutdown. [#75395](https://github.com/ClickHouse/ClickHouse/pull/75395) ([RinChanNOW](https://github.com/RinChanNOWWW)).
* Update README with LA meetup. [#75396](https://github.com/ClickHouse/ClickHouse/pull/75396) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Add ClickHouse to docs dockerfile. [#75397](https://github.com/ClickHouse/ClickHouse/pull/75397) ([Shaun Struwig](https://github.com/Blargian)).
* Try to fix rabbit mq. [#75411](https://github.com/ClickHouse/ClickHouse/pull/75411) ([alesapin](https://github.com/alesapin)).
* s3queue: update error check. [#75416](https://github.com/ClickHouse/ClickHouse/pull/75416) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix test `02871_peak_threads_usage`. [#75445](https://github.com/ClickHouse/ClickHouse/pull/75445) ([Nikita Taranov](https://github.com/nickitat)).
* Fix UBSAN issue in `toStartOfNanosecond`. [#75446](https://github.com/ClickHouse/ClickHouse/pull/75446) ([Robert Schulze](https://github.com/rschu1ze)).
* Ignore some jemalloc messages. [#75449](https://github.com/ClickHouse/ClickHouse/pull/75449) ([Antonio Andelic](https://github.com/antonio2368)).
* Attempt to fix https://s3.amazonaws.com/clickhouse-test-reports/0/25fbafb780c53202e29a5fa05f6be09f275b3137/ast_fuzzer__tsan_/stderr.log. [#75454](https://github.com/ClickHouse/ClickHouse/pull/75454) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixing flaky 03272_parallel_replicas_read_in_order. [#75455](https://github.com/ClickHouse/ClickHouse/pull/75455) ([Igor Nikonov](https://github.com/devcrafter)).
* CI: Bugfix validation job fix. [#75465](https://github.com/ClickHouse/ClickHouse/pull/75465) ([Max Kainov](https://github.com/maxknv)).
* Fix logical error in Hypothesis index. [#75468](https://github.com/ClickHouse/ClickHouse/pull/75468) ([Michael Kolupaev](https://github.com/al13n321)).
* Stricter checks when attaching/detaching threads to groups. [#75474](https://github.com/ClickHouse/ClickHouse/pull/75474) ([Michael Kolupaev](https://github.com/al13n321)).
* [trivial] Fix typo DataTime -> DateTime. [#75476](https://github.com/ClickHouse/ClickHouse/pull/75476) ([Michael Kolupaev](https://github.com/al13n321)).
* Add various profile events for CHECKSUM_DOESNT_MATCH. [#75477](https://github.com/ClickHouse/ClickHouse/pull/75477) ([Azat Khuzhin](https://github.com/azat)).
* Add test with .sql file for incremental backup. [#75479](https://github.com/ClickHouse/ClickHouse/pull/75479) ([Aleksandr Musorin](https://github.com/AVMusorin)).
* Fix codecs_int_select perf test flakiness. [#75486](https://github.com/ClickHouse/ClickHouse/pull/75486) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.1.3.23-stable. [#75488](https://github.com/ClickHouse/ClickHouse/pull/75488) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v24.3.16.16-lts. [#75497](https://github.com/ClickHouse/ClickHouse/pull/75497) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* tests: fix 01720_country_intersection flakiness. [#75500](https://github.com/ClickHouse/ClickHouse/pull/75500) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v24.8.13.16-lts. [#75501](https://github.com/ClickHouse/ClickHouse/pull/75501) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Split `gtest_coordination`. [#75513](https://github.com/ClickHouse/ClickHouse/pull/75513) ([Antonio Andelic](https://github.com/antonio2368)).
* Update version_date.tsv and changelog after v24.11.4.45-stable. [#75514](https://github.com/ClickHouse/ClickHouse/pull/75514) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Add testcase for [#74934](https://github.com/ClickHouse/ClickHouse/issues/74934). [#75515](https://github.com/ClickHouse/ClickHouse/pull/75515) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Increase margins in query_metric_log test to make it less flaky. [#75516](https://github.com/ClickHouse/ClickHouse/pull/75516) ([Pablo Marcos](https://github.com/pamarcos)).
* `02812_from_to_utc_timestamp.sh` -> `.sql`. [#75518](https://github.com/ClickHouse/ClickHouse/pull/75518) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Closes [#75167](https://github.com/ClickHouse/ClickHouse/issues/75167). [#75519](https://github.com/ClickHouse/ClickHouse/pull/75519) ([Pavel Kruglov](https://github.com/Avogar)).
* ci: tune errors injection and allow replicated database in stress tests. [#75521](https://github.com/ClickHouse/ClickHouse/pull/75521) ([Nikita Fomichev](https://github.com/fm4v)).
* Fix flaky test 03272_json_to_json_cast_2. Closes [#74624](https://github.com/ClickHouse/ClickHouse/issues/74624). [#75522](https://github.com/ClickHouse/ClickHouse/pull/75522) ([Pavel Kruglov](https://github.com/Avogar)).
* tests: make 02597_column_delete_and_replication less flaky. [#75529](https://github.com/ClickHouse/ClickHouse/pull/75529) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v24.12.4.49-stable. [#75531](https://github.com/ClickHouse/ClickHouse/pull/75531) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* s3(azure)queue fix. [#75537](https://github.com/ClickHouse/ClickHouse/pull/75537) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove dependencies on CompressionFactory.h. [#75543](https://github.com/ClickHouse/ClickHouse/pull/75543) ([Raúl Marín](https://github.com/Algunenano)).
* tests: avoid relying on existing sort order in 01720_country_intersection. [#75546](https://github.com/ClickHouse/ClickHouse/pull/75546) ([Azat Khuzhin](https://github.com/azat)).
* add a test for SYSTEM_VIEWS grant. [#75550](https://github.com/ClickHouse/ClickHouse/pull/75550) ([Bharat Nallan](https://github.com/bharatnc)).
* Update error message for join expression. [#75576](https://github.com/ClickHouse/ClickHouse/pull/75576) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Stricter validation of ASTs passed to fuzzJSON. [#75581](https://github.com/ClickHouse/ClickHouse/pull/75581) ([Julia Kartseva](https://github.com/jkartseva)).
* Force rebuild sqlancer. [#75589](https://github.com/ClickHouse/ClickHouse/pull/75589) ([Ilya Yatsishin](https://github.com/qoega)).
* CI: Build legacy test docker images in praktika CI. [#75591](https://github.com/ClickHouse/ClickHouse/pull/75591) ([Max Kainov](https://github.com/maxknv)).
* Drop the database after each test run, regardless of its status, and do so in sync mode. [#75594](https://github.com/ClickHouse/ClickHouse/pull/75594) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Sync MergeTree settings. [#75602](https://github.com/ClickHouse/ClickHouse/pull/75602) ([Alexander Gololobov](https://github.com/davenger)).
* CI: Prepare and test new ci workflow. [#75603](https://github.com/ClickHouse/ClickHouse/pull/75603) ([Max Kainov](https://github.com/maxknv)).
* Fix test_storage_s3_queue/test.py::test_alter_settings. [#75614](https://github.com/ClickHouse/ClickHouse/pull/75614) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Refactor Keeper-related files to improve build time. [#75616](https://github.com/ClickHouse/ClickHouse/pull/75616) ([Antonio Andelic](https://github.com/antonio2368)).
* Groom more IColumn headers. [#75617](https://github.com/ClickHouse/ClickHouse/pull/75617) ([Pablo Marcos](https://github.com/pamarcos)).
* Closes [#74624](https://github.com/ClickHouse/ClickHouse/issues/74624). [#75619](https://github.com/ClickHouse/ClickHouse/pull/75619) ([Pavel Kruglov](https://github.com/Avogar)).
* tests: fix 01111_create_drop_replicated_db_stress flakiness. [#75621](https://github.com/ClickHouse/ClickHouse/pull/75621) ([Azat Khuzhin](https://github.com/azat)).
* Keeper startup fail when rocksdb path which is optional not configured. [#75625](https://github.com/ClickHouse/ClickHouse/pull/75625) ([Vallish Pai](https://github.com/Vallishp)).
* Fix compiler error in ClientInfo. [#75626](https://github.com/ClickHouse/ClickHouse/pull/75626) ([Nikita Taranov](https://github.com/nickitat)).
* Optimize transitive includes of TableExpressionData.h. [#75636](https://github.com/ClickHouse/ClickHouse/pull/75636) ([Raúl Marín](https://github.com/Algunenano)).
* Add fault injection for PostgreSQL replication on CI. [#75638](https://github.com/ClickHouse/ClickHouse/pull/75638) ([Azat Khuzhin](https://github.com/azat)).
* better test for system drop replica permissions. [#75645](https://github.com/ClickHouse/ClickHouse/pull/75645) ([Bharat Nallan](https://github.com/bharatnc)).
* Added the possibility of generating `EXPLAIN` in subqueries, plus comparing and explaining plans with queries between different ClickHouse servers. Enable it with `compare_explains` option. - Important fixes when measuring query performance. Wait for the query log to flush before retrieving the performance results of the query. The sleep time can be changed by `flush_log_wait_time` setting in milliseconds. - Added `Distributed` tables and `merge` and `cluster` functions. [#75653](https://github.com/ClickHouse/ClickHouse/pull/75653) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Reduce CacheBase instantiations. [#75659](https://github.com/ClickHouse/ClickHouse/pull/75659) ([Antonio Andelic](https://github.com/antonio2368)).
* ci: avoid relying on internal AWS DNS. [#75663](https://github.com/ClickHouse/ClickHouse/pull/75663) ([Azat Khuzhin](https://github.com/azat)).
* clickhouse-benchmark: fix data race for writing logs (fixes CI flakiness). [#75665](https://github.com/ClickHouse/ClickHouse/pull/75665) ([Azat Khuzhin](https://github.com/azat)).
* ci/stress: ensure that the distributed sends will be stopped. [#75670](https://github.com/ClickHouse/ClickHouse/pull/75670) ([Azat Khuzhin](https://github.com/azat)).
* s3queue: add more profile events. [#75672](https://github.com/ClickHouse/ClickHouse/pull/75672) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix flaky stress tests due to RESTORE of V0-format tables. [#75674](https://github.com/ClickHouse/ClickHouse/pull/75674) ([Sergei Trifonov](https://github.com/serxa)).
* s3queue: better handling of errors during read. [#75678](https://github.com/ClickHouse/ClickHouse/pull/75678) ([Kseniia Sumarokova](https://github.com/kssenii)).
* need parentheses when formatting the expression of ast assignment. [#75680](https://github.com/ClickHouse/ClickHouse/pull/75680) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* This is the beginning of big migration. This change switches CI in PR to the new workflow. [#75684](https://github.com/ClickHouse/ClickHouse/pull/75684) ([Max Kainov](https://github.com/maxknv)).
* CI: Dark theme for the new CI report. [#75691](https://github.com/ClickHouse/ClickHouse/pull/75691) ([Max Kainov](https://github.com/maxknv)).
* Make parquet encoder change page on record boundaries only (when page index is enabled). [#75692](https://github.com/ClickHouse/ClickHouse/pull/75692) ([Michael Kolupaev](https://github.com/al13n321)).
* Remove flaky `test_compare_parallel_inserts_durations_for_adaptive_and_fixed_async_timeouts`. [#75695](https://github.com/ClickHouse/ClickHouse/pull/75695) ([Julia Kartseva](https://github.com/jkartseva)).
* CI: Fixes pr_description workflow's pre-hook. [#75710](https://github.com/ClickHouse/ClickHouse/pull/75710) ([Max Kainov](https://github.com/maxknv)).
* Fast test mistakenly gets skipped with updates in source code. [#75712](https://github.com/ClickHouse/ClickHouse/pull/75712) ([Max Kainov](https://github.com/maxknv)).
* Revert "Reduce memory usage for some window functions". [#75713](https://github.com/ClickHouse/ClickHouse/pull/75713) ([Alexander Gololobov](https://github.com/davenger)).
* Add log message. [#75716](https://github.com/ClickHouse/ClickHouse/pull/75716) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Reduce `ExpressionActions.h` dependencies. [#75721](https://github.com/ClickHouse/ClickHouse/pull/75721) ([Antonio Andelic](https://github.com/antonio2368)).
* Python implementation of `ClickHouse/checkout` github action. [#75724](https://github.com/ClickHouse/ClickHouse/pull/75724) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* More forward declares around IColumn. [#75730](https://github.com/ClickHouse/ClickHouse/pull/75730) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Add timeout for Config Workflow job. [#75731](https://github.com/ClickHouse/ClickHouse/pull/75731) ([Max Kainov](https://github.com/maxknv)).
* Support multiple orgs in trust check for a user. [#75733](https://github.com/ClickHouse/ClickHouse/pull/75733) ([Max Kainov](https://github.com/maxknv)).
* `ThreadPoolCallbackRunnerLocal` should be destroyed before `combined_pipeline` cause internal lambda can modify it. Fixes https://s3.amazonaws.com/clickhouse-test-reports/0/5344d701fc0cc7dba6af7a01302c63ab8f955511/stress_test__msan_/stderr.log. [#75737](https://github.com/ClickHouse/ClickHouse/pull/75737) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Replace metrics for on fly mutations to properties in `system.tables`. [#75738](https://github.com/ClickHouse/ClickHouse/pull/75738) ([Anton Popov](https://github.com/CurtizJ)).
* Update README.md - Update meetups. [#75739](https://github.com/ClickHouse/ClickHouse/pull/75739) ([Tanya Bragin](https://github.com/tbragin)).
* Switch MaterCI workflow to praktika. [#75749](https://github.com/ClickHouse/ClickHouse/pull/75749) ([Max Kainov](https://github.com/maxknv)).
* Try fix test 01245_limit_infinite_sources. [#75750](https://github.com/ClickHouse/ClickHouse/pull/75750) ([Nikita Taranov](https://github.com/nickitat)).
* Improvements for the Web UI. [#75753](https://github.com/ClickHouse/ClickHouse/pull/75753) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix window function argument validation. [#75755](https://github.com/ClickHouse/ClickHouse/pull/75755) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix normalizing function names inside ASTTTLElement. [#75757](https://github.com/ClickHouse/ClickHouse/pull/75757) ([Michael Kolupaev](https://github.com/al13n321)).
* tests: fix test_merge_tree_s3 flakiness. [#75762](https://github.com/ClickHouse/ClickHouse/pull/75762) ([Azat Khuzhin](https://github.com/azat)).
* Bump black (some distributions have 25 already). [#75763](https://github.com/ClickHouse/ClickHouse/pull/75763) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix test_distributed_ddl in multiple places. [#75767](https://github.com/ClickHouse/ClickHouse/pull/75767) ([Azat Khuzhin](https://github.com/azat)).
* Miscellaneous change for merges. [#75770](https://github.com/ClickHouse/ClickHouse/pull/75770) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad test `03286_reverse_sorting_key_final`. [#75773](https://github.com/ClickHouse/ClickHouse/pull/75773) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Fix concurrent report update. [#75780](https://github.com/ClickHouse/ClickHouse/pull/75780) ([Max Kainov](https://github.com/maxknv)).
* Move opentelemetry_span_log defaults into the server. [#75784](https://github.com/ClickHouse/ClickHouse/pull/75784) ([Azat Khuzhin](https://github.com/azat)).
* Fix typo. [#75786](https://github.com/ClickHouse/ClickHouse/pull/75786) ([Shaun Struwig](https://github.com/Blargian)).
* ci: enable kernel.task_delayacct for OSIOWaitMicroseconds. [#75789](https://github.com/ClickHouse/ClickHouse/pull/75789) ([Azat Khuzhin](https://github.com/azat)).
* Remove strange field in ProfileInfo. [#75790](https://github.com/ClickHouse/ClickHouse/pull/75790) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor adjustment to the Web UI. [#75791](https://github.com/ClickHouse/ClickHouse/pull/75791) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#74976](https://github.com/ClickHouse/ClickHouse/issues/74976). [#75795](https://github.com/ClickHouse/ClickHouse/pull/75795) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allows to override CI settings for forks with praktika. [#75802](https://github.com/ClickHouse/ClickHouse/pull/75802) ([Max Kainov](https://github.com/maxknv)).
* ci: relaxed DNS check after applying workaround for AWS resolvers. [#75803](https://github.com/ClickHouse/ClickHouse/pull/75803) ([Azat Khuzhin](https://github.com/azat)).
* Updated version for pytest-timeout to make session-timeout work from https://github.com/ClickHouse/ClickHouse/pull/75533. [#75812](https://github.com/ClickHouse/ClickHouse/pull/75812) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix error message during accessing https in case of ClickHouse built without SSL. [#75848](https://github.com/ClickHouse/ClickHouse/pull/75848) ([Azat Khuzhin](https://github.com/azat)).
* tests: avoid using /var/lib static paths in 02714_local_object_storage. [#75849](https://github.com/ClickHouse/ClickHouse/pull/75849) ([Azat Khuzhin](https://github.com/azat)).
* Fix typo in DiskFromAST (DiskFomAST). [#75851](https://github.com/ClickHouse/ClickHouse/pull/75851) ([Azat Khuzhin](https://github.com/azat)).
* Add test for case that did not work without analyzer. Closes [#32743](https://github.com/ClickHouse/ClickHouse/issues/32743). [#75861](https://github.com/ClickHouse/ClickHouse/pull/75861) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix build. [#75867](https://github.com/ClickHouse/ClickHouse/pull/75867) ([Mikhail Artemenko](https://github.com/Michicosun)).
* CI: Post statuses for all failed jobs from praktika. [#75871](https://github.com/ClickHouse/ClickHouse/pull/75871) ([Max Kainov](https://github.com/maxknv)).
* Issue is fixed with analyzer. Closes: [#31184](https://github.com/ClickHouse/ClickHouse/issues/31184). [#75872](https://github.com/ClickHouse/ClickHouse/pull/75872) ([Ilya Yatsishin](https://github.com/qoega)).
* DisksApp: fix 'Placement info has not been loaded' and 'The IOThreadPool is not initialized'. [#75873](https://github.com/ClickHouse/ClickHouse/pull/75873) ([Michael Kolupaev](https://github.com/al13n321)).
* keeper: fix data-race for latest_snapshot_{info,meta,buf}. [#75878](https://github.com/ClickHouse/ClickHouse/pull/75878) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky `test_hedged_requests`. [#75886](https://github.com/ClickHouse/ClickHouse/pull/75886) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix: test test_background_dictionary_reconnect. [#75897](https://github.com/ClickHouse/ClickHouse/pull/75897) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix flaky backup throttling. [#75906](https://github.com/ClickHouse/ClickHouse/pull/75906) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Closes [#53752](https://github.com/ClickHouse/ClickHouse/issues/53752). [#75910](https://github.com/ClickHouse/ClickHouse/pull/75910) ([Dmitry Novik](https://github.com/novikd)).
* Sha in the report link must not be "latest" for master ci. [#75926](https://github.com/ClickHouse/ClickHouse/pull/75926) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix merge-commit toggle in praktika. [#75927](https://github.com/ClickHouse/ClickHouse/pull/75927) ([Max Kainov](https://github.com/maxknv)).
* Ensure that after MemoryTracker::setParent() total_memory_tracker is in the chain. [#75932](https://github.com/ClickHouse/ClickHouse/pull/75932) ([Azat Khuzhin](https://github.com/azat)).
* CMake: Make messages about keeper-data-dumper and keeper-bench less noisy. [#75933](https://github.com/ClickHouse/ClickHouse/pull/75933) ([Robert Schulze](https://github.com/rschu1ze)).
* backport code from lightweight snapshot. [#75940](https://github.com/ClickHouse/ClickHouse/pull/75940) ([Han Fei](https://github.com/hanfei1991)).
* CI: Fix insert into cidb. [#75946](https://github.com/ClickHouse/ClickHouse/pull/75946) ([Max Kainov](https://github.com/maxknv)).
* Fix upgrade settings checker, update stateless test settings baseline and fix SettingsChangesHistory. [#75948](https://github.com/ClickHouse/ClickHouse/pull/75948) ([Raúl Marín](https://github.com/Algunenano)).
* The GitHub icon will not overflow with the list of tables. The "no tables" text is gray. [#75953](https://github.com/ClickHouse/ClickHouse/pull/75953) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor improvements of L2/cosineDistance. [#75955](https://github.com/ClickHouse/ClickHouse/pull/75955) ([Robert Schulze](https://github.com/rschu1ze)).
* Add a test for [#73947](https://github.com/ClickHouse/ClickHouse/issues/73947). [#75964](https://github.com/ClickHouse/ClickHouse/pull/75964) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* ci: remove setup of CI workers via actions (moved to the init script). [#75973](https://github.com/ClickHouse/ClickHouse/pull/75973) ([Azat Khuzhin](https://github.com/azat)).
* Fix `test_keeper_disks`. [#75975](https://github.com/ClickHouse/ClickHouse/pull/75975) ([Antonio Andelic](https://github.com/antonio2368)).
* tests: avoid relying on existing order in 01257_dictionary_mismatch_types. [#75978](https://github.com/ClickHouse/ClickHouse/pull/75978) ([Azat Khuzhin](https://github.com/azat)).
* CI: Jepsen scheduled workflow by praktika. [#75980](https://github.com/ClickHouse/ClickHouse/pull/75980) ([Max Kainov](https://github.com/maxknv)).
* Fixes new jepsen workflow * removes legacy jepsen workflow. [#75991](https://github.com/ClickHouse/ClickHouse/pull/75991) ([Max Kainov](https://github.com/maxknv)).
* Fix a pity check bug introduced in [#75643](https://github.com/ClickHouse/ClickHouse/issues/75643). The Docker library test should affect the check status but should not run for the `--push` case. [#76002](https://github.com/ClickHouse/ClickHouse/pull/76002) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* CI: Add concurrency lock for scheduled workflows. [#76008](https://github.com/ClickHouse/ClickHouse/pull/76008) ([Max Kainov](https://github.com/maxknv)).
* Do not throw from `~Workload()`. [#76010](https://github.com/ClickHouse/ClickHouse/pull/76010) ([Sergei Trifonov](https://github.com/serxa)).
* Untangle Block, Chunk and Port headers. [#76012](https://github.com/ClickHouse/ClickHouse/pull/76012) ([Raúl Marín](https://github.com/Algunenano)).
* Fix 03326_parallel_replicas_out_of_range.sql. [#76015](https://github.com/ClickHouse/ClickHouse/pull/76015) ([Raúl Marín](https://github.com/Algunenano)).
* Display longer strings in test failures. [#76019](https://github.com/ClickHouse/ClickHouse/pull/76019) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add more test logs for decompressing. [#76023](https://github.com/ClickHouse/ClickHouse/pull/76023) ([Vitaly Baranov](https://github.com/vitlibar)).
* CI: Updates in UI. [#76024](https://github.com/ClickHouse/ClickHouse/pull/76024) ([Max Kainov](https://github.com/maxknv)).
* Docs: Minor note about Git. [#76025](https://github.com/ClickHouse/ClickHouse/pull/76025) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Remove legacy CI Running commit status. [#76041](https://github.com/ClickHouse/ClickHouse/pull/76041) ([Max Kainov](https://github.com/maxknv)).
* Praktika to support job-level setting to enable gh commit status * enables commit status for performance comparison job. [#76042](https://github.com/ClickHouse/ClickHouse/pull/76042) ([Max Kainov](https://github.com/maxknv)).
* CI: Add Performance arm job to PR workflow. [#76050](https://github.com/ClickHouse/ClickHouse/pull/76050) ([Max Kainov](https://github.com/maxknv)).
* Replace suboptimal unshallow command. [#76051](https://github.com/ClickHouse/ClickHouse/pull/76051) ([Max Kainov](https://github.com/maxknv)).
* Docs: Fix typo. [#76057](https://github.com/ClickHouse/ClickHouse/pull/76057) ([Raufs Dunamalijevs](https://github.com/rienath)).
* tests: fix RAFT configuration in test_keeper_disks. [#76058](https://github.com/ClickHouse/ClickHouse/pull/76058) ([Azat Khuzhin](https://github.com/azat)).
* ci: remove useless store/metadata.tar artifacts to reduce cost. [#76068](https://github.com/ClickHouse/ClickHouse/pull/76068) ([Azat Khuzhin](https://github.com/azat)).
* Refactor IdentifierResolver to simplify interface. [#76072](https://github.com/ClickHouse/ClickHouse/pull/76072) ([Dmitry Novik](https://github.com/novikd)).
* CI: UI add page title. [#76077](https://github.com/ClickHouse/ClickHouse/pull/76077) ([Max Kainov](https://github.com/maxknv)).
* Follow-up to [#75470](https://github.com/ClickHouse/ClickHouse/issues/75470), [#75756](https://github.com/ClickHouse/ClickHouse/issues/75756), [#66143](https://github.com/ClickHouse/ClickHouse/issues/66143), [#75671](https://github.com/ClickHouse/ClickHouse/issues/75671). [#76082](https://github.com/ClickHouse/ClickHouse/pull/76082) ([Robert Schulze](https://github.com/rschu1ze)).
* Ignore specific fields in the job digest calculation to allow reusing results from different workflows where the job config might differ. [#76086](https://github.com/ClickHouse/ClickHouse/pull/76086) ([Max Kainov](https://github.com/maxknv)).
* Add a test, the bug was fixed by https://github.com/ClickHouse/ClickHouse/pull/66143. Close [#69343](https://github.com/ClickHouse/ClickHouse/issues/69343). [#76087](https://github.com/ClickHouse/ClickHouse/pull/76087) ([Dmitry Novik](https://github.com/novikd)).
* Add base/README.md and src/Core/README.md. [#76089](https://github.com/ClickHouse/ClickHouse/pull/76089) ([Raúl Marín](https://github.com/Algunenano)).
* Docs: Follow-up to [#75338](https://github.com/ClickHouse/ClickHouse/issues/75338). [#76105](https://github.com/ClickHouse/ClickHouse/pull/76105) ([Robert Schulze](https://github.com/rschu1ze)).
* Apply libunwind fix for DwarfFDECache. [#76107](https://github.com/ClickHouse/ClickHouse/pull/76107) ([Michael Kolupaev](https://github.com/al13n321)).
* Slightly better error message when failing to parse server settings from config. [#76109](https://github.com/ClickHouse/ClickHouse/pull/76109) ([Michael Kolupaev](https://github.com/al13n321)).
* Without it CI is not starting for https://github.com/ClickHouse/ClickHouse/pull/76078. And we have "Experimental Feature" in template. https://github.com/ClickHouse/ClickHouse/blob/master/.github/PULL_REQUEST_TEMPLATE.md. [#76113](https://github.com/ClickHouse/ClickHouse/pull/76113) ([Ilya Yatsishin](https://github.com/qoega)).
* Docs: Update config files guide. [#76114](https://github.com/ClickHouse/ClickHouse/pull/76114) ([Robert Schulze](https://github.com/rschu1ze)).
* refine test 02481_async_insert_dedup. [#76117](https://github.com/ClickHouse/ClickHouse/pull/76117) ([Han Fei](https://github.com/hanfei1991)).
* Miscellaneous changes in Web UI. [#76119](https://github.com/ClickHouse/ClickHouse/pull/76119) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve 02968_file_log_multiple_read. [#76120](https://github.com/ClickHouse/ClickHouse/pull/76120) ([Julia Kartseva](https://github.com/jkartseva)).
* Respect submodule updates in the build job digest so that jobs are not unfairly skipped if only a submodule is updated. [#76124](https://github.com/ClickHouse/ClickHouse/pull/76124) ([Max Kainov](https://github.com/maxknv)).
* Return the correct version for every CI run, despite it's master or PRs. [#76127](https://github.com/ClickHouse/ClickHouse/pull/76127) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Improve logging for decrypting files from encrypted disks. [#76128](https://github.com/ClickHouse/ClickHouse/pull/76128) ([Vitaly Baranov](https://github.com/vitlibar)).
* Make trace visualizer readme up to date. [#76129](https://github.com/ClickHouse/ClickHouse/pull/76129) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* A few additions and fixes for BuzzHouse: Added views in remote table functions and `ON CLUSTER` clause, updated some settings and important fix, check system tables were fetched before using them in queries. [#76130](https://github.com/ClickHouse/ClickHouse/pull/76130) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Update version_date.tsv and changelog after v25.1.4.53-stable. [#76131](https://github.com/ClickHouse/ClickHouse/pull/76131) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Fix performance artifact path. [#76135](https://github.com/ClickHouse/ClickHouse/pull/76135) ([Max Kainov](https://github.com/maxknv)).
* Revert "Apply libunwind fix for DwarfFDECache". [#76136](https://github.com/ClickHouse/ClickHouse/pull/76136) ([Max Kainov](https://github.com/maxknv)).
* ci: tune threadpool_writer_pool_size (to avoid one test affect another for S3). [#76137](https://github.com/ClickHouse/ClickHouse/pull/76137) ([Azat Khuzhin](https://github.com/azat)).
* ci: fix MEMORY_LIMIT_EXCEEDED for UBsan jobs (due to 00980_alter_settings_race). [#76143](https://github.com/ClickHouse/ClickHouse/pull/76143) ([Azat Khuzhin](https://github.com/azat)).
* Praktika to support user's job filter hook * adds filter hook to skip non-docs job for docs pr * adds filter hook to skip non-docs job for push to master * adds hook to skip arm perf tests for non performance pr. [#76168](https://github.com/ClickHouse/ClickHouse/pull/76168) ([Max Kainov](https://github.com/maxknv)).
* Apply libunwind fix for DwarfFDECache, attempt 2. [#76178](https://github.com/ClickHouse/ClickHouse/pull/76178) ([Michael Kolupaev](https://github.com/al13n321)).
* Make now() use the same clock as now64. [#76189](https://github.com/ClickHouse/ClickHouse/pull/76189) ([Michael Kolupaev](https://github.com/al13n321)).
* Remove dead code from MaterializedMySQL. [#76190](https://github.com/ClickHouse/ClickHouse/pull/76190) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove bloat from two-argument floating point math functions. [#76193](https://github.com/ClickHouse/ClickHouse/pull/76193) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* tests: disable flaky query in 03040_recursive_cte_postgres_6. [#76202](https://github.com/ClickHouse/ClickHouse/pull/76202) ([Azat Khuzhin](https://github.com/azat)).
* Remove outdated notice. [#76213](https://github.com/ClickHouse/ClickHouse/pull/76213) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Hide RSS completely for non-global MemoryTracker ("N/A" looks odd). [#76234](https://github.com/ClickHouse/ClickHouse/pull/76234) ([Azat Khuzhin](https://github.com/azat)).
* Tiny cleanup around calculateCacheKey() (remove unused method and add some comments). [#76235](https://github.com/ClickHouse/ClickHouse/pull/76235) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 03277_join_adaptive_spill_oom flakiness. [#76237](https://github.com/ClickHouse/ClickHouse/pull/76237) ([Azat Khuzhin](https://github.com/azat)).
* Remove some outdated workarounds and fix few minor issues in CI bash scripts. [#76238](https://github.com/ClickHouse/ClickHouse/pull/76238) ([Azat Khuzhin](https://github.com/azat)).
* Fix CMake string replace function usage. [#76244](https://github.com/ClickHouse/ClickHouse/pull/76244) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Miscellaneous changes around disks. [#76249](https://github.com/ClickHouse/ClickHouse/pull/76249) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update meetups and next Community call. [#76262](https://github.com/ClickHouse/ClickHouse/pull/76262) ([Raúl Marín](https://github.com/Algunenano)).
* ci: some cleanup and retries for dpkg -i. [#76267](https://github.com/ClickHouse/ClickHouse/pull/76267) ([Azat Khuzhin](https://github.com/azat)).
* Fix errors and flakiness in test_broken_projections. [#76274](https://github.com/ClickHouse/ClickHouse/pull/76274) ([Azat Khuzhin](https://github.com/azat)).
* `Core settings` --> `Session settings`. [#76275](https://github.com/ClickHouse/ClickHouse/pull/76275) ([Robert Schulze](https://github.com/rschu1ze)).
* Tiny CMake cleanup. [#76295](https://github.com/ClickHouse/ClickHouse/pull/76295) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Fix changed files retrieval in MasterCI. [#76298](https://github.com/ClickHouse/ClickHouse/pull/76298) ([Max Kainov](https://github.com/maxknv)).
* Start untangling Exception.h and Field.h. [#76299](https://github.com/ClickHouse/ClickHouse/pull/76299) ([Raúl Marín](https://github.com/Algunenano)).
* Add healthycheck to test_database_iceberg docker-compose. [#76304](https://github.com/ClickHouse/ClickHouse/pull/76304) ([Daniil Ivanik](https://github.com/divanik)).
* The bug seems to be fixed in `24.10`. Adding a test from the issue. Closes [#65981](https://github.com/ClickHouse/ClickHouse/issues/65981). [#76305](https://github.com/ClickHouse/ClickHouse/pull/76305) ([Dmitry Novik](https://github.com/novikd)).
* This closes: [#62763](https://github.com/ClickHouse/ClickHouse/issues/62763). [#76310](https://github.com/ClickHouse/ClickHouse/pull/76310) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* This closes: [#71217](https://github.com/ClickHouse/ClickHouse/issues/71217). [#76311](https://github.com/ClickHouse/ClickHouse/pull/76311) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Close: [#70547](https://github.com/ClickHouse/ClickHouse/issues/70547). [#76312](https://github.com/ClickHouse/ClickHouse/pull/76312) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add `prefetch` method to `ReadBufferFromEncryptedFile`. [#76322](https://github.com/ClickHouse/ClickHouse/pull/76322) ([Antonio Andelic](https://github.com/antonio2368)).
* Rename file KnowRowsHolder -> KnownRowsHolder. [#76323](https://github.com/ClickHouse/ClickHouse/pull/76323) ([Vladimir Cherkasov](https://github.com/vdimir)).
* tests: fix flakiness of integration tests with NGINX. [#76332](https://github.com/ClickHouse/ClickHouse/pull/76332) ([Azat Khuzhin](https://github.com/azat)).
* ci: add clickhouse binary into fasttest artifacts. [#76333](https://github.com/ClickHouse/ClickHouse/pull/76333) ([Azat Khuzhin](https://github.com/azat)).
* Close: [#73689](https://github.com/ClickHouse/ClickHouse/issues/73689). [#76335](https://github.com/ClickHouse/ClickHouse/pull/76335) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Close: [#70133](https://github.com/ClickHouse/ClickHouse/issues/70133). [#76351](https://github.com/ClickHouse/ClickHouse/pull/76351) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Close: [#72936](https://github.com/ClickHouse/ClickHouse/issues/72936). [#76355](https://github.com/ClickHouse/ClickHouse/pull/76355) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Close: [#63900](https://github.com/ClickHouse/ClickHouse/issues/63900). [#76386](https://github.com/ClickHouse/ClickHouse/pull/76386) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Remove unused table function registration declarations. [#76410](https://github.com/ClickHouse/ClickHouse/pull/76410) ([Aris Tritas](https://github.com/aris-aiven)).
* Update version_date.tsv and changelog after v24.3.17.18-lts. [#76411](https://github.com/ClickHouse/ClickHouse/pull/76411) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v24.8.14.39-lts. [#76417](https://github.com/ClickHouse/ClickHouse/pull/76417) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* tests: suppress "/etc/timezone is deprecated on Debian" in 03279_with_clickhouse_driver. [#76419](https://github.com/ClickHouse/ClickHouse/pull/76419) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v24.11.5.49-stable. [#76420](https://github.com/ClickHouse/ClickHouse/pull/76420) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.1.5.31-stable. [#76423](https://github.com/ClickHouse/ClickHouse/pull/76423) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v24.12.5.81-stable. [#76426](https://github.com/ClickHouse/ClickHouse/pull/76426) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Backported in [#76794](https://github.com/ClickHouse/ClickHouse/issues/76794): Using parallel replicas without analyzer is not supported. New setting `parallel_replicas_only_with_analyzer` is introduced to prevent using parallel replicas without analyzer in backward-compatible way. [#76427](https://github.com/ClickHouse/ClickHouse/pull/76427) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix `setReadUntilPosition` in `AsynchronousBoundedReadBuffer`. [#76429](https://github.com/ClickHouse/ClickHouse/pull/76429) ([Antonio Andelic](https://github.com/antonio2368)).
* We report in milliseconds, but calculate seconds. This closes: [#76449](https://github.com/ClickHouse/ClickHouse/issues/76449). [#76453](https://github.com/ClickHouse/ClickHouse/pull/76453) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Support JWT authorization in interserver communication. [#76472](https://github.com/ClickHouse/ClickHouse/pull/76472) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Update version_date.tsv and changelog after v24.3.18.7-lts. [#76476](https://github.com/ClickHouse/ClickHouse/pull/76476) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* A workflow part of [#74605](https://github.com/ClickHouse/ClickHouse/issues/74605) to be able to debug it. Schedule is disabled, and it will work only from the branches with `tests/ci/official_docker_update.py`. [#76509](https://github.com/ClickHouse/ClickHouse/pull/76509) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Sync settings. [#76513](https://github.com/ClickHouse/ClickHouse/pull/76513) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#76634](https://github.com/ClickHouse/ClickHouse/issues/76634): Add `LoggerElapsedNanoseconds` to Keeper metrics. [#76517](https://github.com/ClickHouse/ClickHouse/pull/76517) ([Antonio Andelic](https://github.com/antonio2368)).
* Adjust a few old tests to flush individual logs. [#76532](https://github.com/ClickHouse/ClickHouse/pull/76532) ([Raúl Marín](https://github.com/Algunenano)).
* tests: fix 02122_4letter_words_stress_zookeeper (previously 4LW was ignored). [#76541](https://github.com/ClickHouse/ClickHouse/pull/76541) ([Azat Khuzhin](https://github.com/azat)).
* Tiny usability improvements for CLI utilities (disks and keeper-client). [#76542](https://github.com/ClickHouse/ClickHouse/pull/76542) ([Azat Khuzhin](https://github.com/azat)).
* Update README.md. [#76543](https://github.com/ClickHouse/ClickHouse/pull/76543) ([Tyler Hannan](https://github.com/tylerhannan)).
* Fix latency_log saver for stateless tests. [#76544](https://github.com/ClickHouse/ClickHouse/pull/76544) ([Alexey Katsman](https://github.com/alexkats)).
* Fix potentially unsafe call in signal handler. [#76549](https://github.com/ClickHouse/ClickHouse/pull/76549) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Docs: Mention Q22 uses a correlated subquery. [#76552](https://github.com/ClickHouse/ClickHouse/pull/76552) ([Robert Schulze](https://github.com/rschu1ze)).
* ci: Fix Logical error: Ephemeral node still exists after 90s in DatabaseReplicated. [#76554](https://github.com/ClickHouse/ClickHouse/pull/76554) ([Azat Khuzhin](https://github.com/azat)).
* ci: disable 02711_server_uuid_macro for SharedCatalog (breaks some invariants). [#76555](https://github.com/ClickHouse/ClickHouse/pull/76555) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#76606](https://github.com/ClickHouse/ClickHouse/issues/76606): Return back progress for merges. [#76556](https://github.com/ClickHouse/ClickHouse/pull/76556) ([Anton Popov](https://github.com/CurtizJ)).
* Sync ErrorCodes. [#76557](https://github.com/ClickHouse/ClickHouse/pull/76557) ([Azat Khuzhin](https://github.com/azat)).
* Skip 02435_rollback_cancelled_queries test when running with Azure blob storage. [#76561](https://github.com/ClickHouse/ClickHouse/pull/76561) ([Alexey Katsman](https://github.com/alexkats)).
* Backported in [#76604](https://github.com/ClickHouse/ClickHouse/issues/76604): Use `MultiRead` when querying `system.distributed_ddl_queue`. [#76575](https://github.com/ClickHouse/ClickHouse/pull/76575) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76897](https://github.com/ClickHouse/ClickHouse/issues/76897): Add log for HTTP Bad Request. [#76594](https://github.com/ClickHouse/ClickHouse/pull/76594) ([Christoph Wurm](https://github.com/cwurm)).
* Backported in [#76884](https://github.com/ClickHouse/ClickHouse/issues/76884): Enable reverse key support in PartsSplitter. This fixes [#75928](https://github.com/ClickHouse/ClickHouse/issues/75928). [#76654](https://github.com/ClickHouse/ClickHouse/pull/76654) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#76759](https://github.com/ClickHouse/ClickHouse/issues/76759): Fix crash in outer join. [#76683](https://github.com/ClickHouse/ClickHouse/pull/76683) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#76837](https://github.com/ClickHouse/ClickHouse/issues/76837): Fix OptimizeAndCompareChain Setting. [#76704](https://github.com/ClickHouse/ClickHouse/pull/76704) ([Shichao Jin](https://github.com/jsc0218)).
* Backported in [#76764](https://github.com/ClickHouse/ClickHouse/issues/76764): Fix logical error while using query_plan_join_swap_table. [#76722](https://github.com/ClickHouse/ClickHouse/pull/76722) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#76825](https://github.com/ClickHouse/ClickHouse/issues/76825): CI: Disable cross-compile for ARM in release and backport. [#76808](https://github.com/ClickHouse/ClickHouse/pull/76808) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#76912](https://github.com/ClickHouse/ClickHouse/issues/76912): Rename shard_name to name in config. [#76826](https://github.com/ClickHouse/ClickHouse/pull/76826) ([Igor Nikonov](https://github.com/devcrafter)).

