---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.1.4.53-stable (c3f28b8bf5d) FIXME as compared to v25.1.3.23-stable (5fc2cf71991)

#### Performance Improvement
* Backported in [#75990](https://github.com/ClickHouse/ClickHouse/issues/75990): It was discovered that concurrency control could lead to unfair CPU distribution between INSERTs and SELECTs. When all CPU slots are allocated unconditionally (w/o competition) to INSERTs with `max_threads` = 1 while SELECTs with high `max_threads` values suffer from poor performance due to using only a single thread. [#75941](https://github.com/ClickHouse/ClickHouse/pull/75941) ([Sergei Trifonov](https://github.com/serxa)).

#### Improvement
* Backported in [#75918](https://github.com/ClickHouse/ClickHouse/issues/75918): Support `s3.endpoint` natively from catalog config in `DatabaseIceberg`. Closes [#74558](https://github.com/ClickHouse/ClickHouse/issues/74558). [#75375](https://github.com/ClickHouse/ClickHouse/pull/75375) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#75846](https://github.com/ClickHouse/ClickHouse/issues/75846): Add check and logging for decrypting and decompressing. [#75471](https://github.com/ClickHouse/ClickHouse/pull/75471) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#75705](https://github.com/ClickHouse/ClickHouse/issues/75705): Disable sending settings from server to client (`send_settings_to_client=false`) for compatibility (This feature will be re-implemented as client setting later for better usability). [#75648](https://github.com/ClickHouse/ClickHouse/pull/75648) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#75801](https://github.com/ClickHouse/ClickHouse/issues/75801): Add a config `memory_worker_correct_memory_tracker` to enable correction of internal memory tracker with information from different source read in the background thread periodically. [#75714](https://github.com/ClickHouse/ClickHouse/pull/75714) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76070](https://github.com/ClickHouse/ClickHouse/issues/76070): Add `MemoryTrackingUncorrected` metric showing value of internal global memory tracker which is not corrected by RSS. [#75935](https://github.com/ClickHouse/ClickHouse/pull/75935) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#75612](https://github.com/ClickHouse/ClickHouse/issues/75612): Propogate Native format settings properly for client-server communication. [#73924](https://github.com/ClickHouse/ClickHouse/pull/73924) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75560](https://github.com/ClickHouse/ClickHouse/issues/75560): Fix crash with query `INSERT INTO SELECT` over PostgreSQL interface on macOS (issue [#72938](https://github.com/ClickHouse/ClickHouse/issues/72938)). [#74231](https://github.com/ClickHouse/ClickHouse/pull/74231) ([Artem Yurov](https://github.com/ArtemYurov)).
* Backported in [#75779](https://github.com/ClickHouse/ClickHouse/issues/75779): Keeper: fix logical_error when the connection had been terminated before establishing. [#74844](https://github.com/ClickHouse/ClickHouse/pull/74844) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76085](https://github.com/ClickHouse/ClickHouse/issues/76085): Fix nullsafe JOIN handling for LowCardinality nullable data type. Previously JOIN ON with nullsafe comparison, such as `IS NOT DISTINCT FROM`, `<=>` , `a IS NULL AND b IS NULL OR a == b` didn't work correctly with LowCardinality columns. [#75143](https://github.com/ClickHouse/ClickHouse/pull/75143) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#75572](https://github.com/ClickHouse/ClickHouse/issues/75572): Keeper fix: avoid writing to broken changelogs when rolling back logs. [#75197](https://github.com/ClickHouse/ClickHouse/pull/75197) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#75587](https://github.com/ClickHouse/ClickHouse/issues/75587): Mask azureblobstorage table engine credentials. [#75319](https://github.com/ClickHouse/ClickHouse/pull/75319) ([Garrett Thomas](https://github.com/garrettthomaskth)).
* Backported in [#75748](https://github.com/ClickHouse/ClickHouse/issues/75748): Fix crash in protobuf schema cache that can happen during output in Protobuf format and parallel query `SYSTEM DROP FORMAT SCHEMA CACHE`. [#75357](https://github.com/ClickHouse/ClickHouse/pull/75357) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75425](https://github.com/ClickHouse/ClickHouse/issues/75425): Hide sensitive info for `icebergS3`, `icebergAzure` table functions and table engines. [#75378](https://github.com/ClickHouse/ClickHouse/pull/75378) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#76100](https://github.com/ClickHouse/ClickHouse/issues/76100): Fix possible error `Elements ... and ... of Nested data structure ... (Array columns) have different array sizes` when JSON subcolumns with Array type are used in JOIN over distributed tables. [#75512](https://github.com/ClickHouse/ClickHouse/pull/75512) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75858](https://github.com/ClickHouse/ClickHouse/issues/75858): Fix interaction between allow_feature_tier and compatibility mergetree setting. [#75635](https://github.com/ClickHouse/ClickHouse/pull/75635) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#75896](https://github.com/ClickHouse/ClickHouse/issues/75896): Fixed rare crashes while reading from `MergeTree` table after multiple asynchronous `RENAME` queries (with `alter_sync = 0`) between columns with different types. [#75693](https://github.com/ClickHouse/ClickHouse/pull/75693) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#75827](https://github.com/ClickHouse/ClickHouse/issues/75827): Fixed null pointer dereference in `DistinctSortedStreamTransform`. [#75734](https://github.com/ClickHouse/ClickHouse/pull/75734) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#75838](https://github.com/ClickHouse/ClickHouse/issues/75838): Fix uninitialized memory read in function `translate`. This closes [#75592](https://github.com/ClickHouse/ClickHouse/issues/75592). [#75794](https://github.com/ClickHouse/ClickHouse/pull/75794) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#75998](https://github.com/ClickHouse/ClickHouse/issues/75998): Fixed a bug that tables with implicitly added min-max indices could not be copied into a new table (issue [#75677](https://github.com/ClickHouse/ClickHouse/issues/75677)). [#75877](https://github.com/ClickHouse/ClickHouse/pull/75877) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).

#### Build/Testing/Packaging Improvement
* Backported in [#76074](https://github.com/ClickHouse/ClickHouse/issues/76074): Make all clickhouse-server related actions a function, and execute them only when launching the default binary in `entrypoint.sh`. A long-postponed improvement was suggested in [#50724](https://github.com/ClickHouse/ClickHouse/issues/50724). Added switch `--users` to `clickhouse-extract-from-config` to get values from the `users.xml`. [#75643](https://github.com/ClickHouse/ClickHouse/pull/75643) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#75925](https://github.com/ClickHouse/ClickHouse/issues/75925): Fix 03312_squashing_with_low_card_mem_usage for private. [#75084](https://github.com/ClickHouse/ClickHouse/pull/75084) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#75528](https://github.com/ClickHouse/ClickHouse/issues/75528): Don't print RSS in memory limit exceeded for query. [#75224](https://github.com/ClickHouse/ClickHouse/pull/75224) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#75579](https://github.com/ClickHouse/ClickHouse/issues/75579): Fix SettingsChangesHistory. [#75358](https://github.com/ClickHouse/ClickHouse/pull/75358) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Backported in [#75596](https://github.com/ClickHouse/ClickHouse/issues/75596): Disable tests `test_rename_column` with sanitizers because they consume 10-40 gigabytes of memory. Fixes [#49399](https://github.com/ClickHouse/ClickHouse/issues/49399). [#75361](https://github.com/ClickHouse/ClickHouse/pull/75361) ([alesapin](https://github.com/alesapin)).

