---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.1.1.4165-stable (8629bc54796) FIXME as compared to v25.1.1.1-new (204fd5b5431)

#### Backward Incompatible Change
* Parquet output format converts Date and DateTime columns to date/time types supported by Parquet, instead of writing them as raw numbers. DateTime becomes DateTime64(3) (was: UInt32); setting `output_format_parquet_datetime_as_uint32` brings back the old behavior. Date becomes Date32 (was: UInt16). [#70950](https://github.com/ClickHouse/ClickHouse/pull/70950) ([Michael Kolupaev](https://github.com/al13n321)).
* Don't allow not comparable types (like JSON/Object/AggregateFunction) in ORDER BY and comparison functions `less/greater/equal/etc` by default. [#73276](https://github.com/ClickHouse/ClickHouse/pull/73276) ([Pavel Kruglov](https://github.com/Avogar)).
* `JSONEachRowWithProgress` will write the progress whenever the progress happens. In previous versions, the progress was shown only after each block of the result, which made it useless. Change the way how the progress is displayed: it will not show zero values. Keep in mind that the progress is sent even if it happens frequently. It can generate a significant volume of traffic. Keep in mind that the progress is not flushed when the output is compressed. This closes [#70800](https://github.com/ClickHouse/ClickHouse/issues/70800). [#73834](https://github.com/ClickHouse/ClickHouse/pull/73834) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The obsolete `MaterializedMySQL` database engine has been removed and is no longer available. [#73879](https://github.com/ClickHouse/ClickHouse/pull/73879) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The `mysql` dictionary source no longer does `SHOW TABLE STATUS` query, because it does not provide any value for InnoDB tables, as long as for any recent MySQL versions. This closes [#72636](https://github.com/ClickHouse/ClickHouse/issues/72636). This change is backward compatible, but put in this category so you have a chance to notice it. [#73914](https://github.com/ClickHouse/ClickHouse/pull/73914) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `Merge` tables will unify the structure of underlying tables by using a union of their columns and deriving common types. This closes [#64864](https://github.com/ClickHouse/ClickHouse/issues/64864). In certain cases, this change could be backward incompatible. One example is when there is no common type between tables, but conversion to the type of the first table is still possible, such as in the case of UInt64 and Int64 or any numeric type and String. If you want to return to the old behavior, set `merge_table_max_tables_to_look_for_schema_inference` to `1` or set `compatibility` to `24.12` or earlier. [#73956](https://github.com/ClickHouse/ClickHouse/pull/73956) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `CHECK TABLE` queries now require a separate, `CHECK` grant. In previous versions, it was enough to have `SHOW TABLES` grant to run these queries. But a `CHECK TABLE` query can be heavy, and usual query complexity limits for `SELECT` queries don't apply to it. It led to the potential of DoS. [#74471](https://github.com/ClickHouse/ClickHouse/pull/74471) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Function `h3ToGeo()` now returns the results in the order `(lat, lon)` (which is the standard order for geometric functions). Users who wish to retain the legacy result order `(lon, lat)` can set setting `h3togeo_lon_lat_result_order = true`. [#74719](https://github.com/ClickHouse/ClickHouse/pull/74719) ([Manish Gill](https://github.com/mgill25)).

#### New Feature
* SSH interface has been added. It is now possible to connect to the ClickHouse server using any SSH client and execute queries in an interactive fashion using PTY with an embedded clickhouse-client. [#48902](https://github.com/ClickHouse/ClickHouse/pull/48902) ([George Gamezardashvili](https://github.com/InfJoker)).
* Added an in-memory cache for deserialized skipping index granules. This should make repeated queries that use skipping indexes faster. The size of the new cache is controlled by server settings `skipping_index_cache_size` and `skipping_index_cache_max_entries`. The original motivation for the cache were vector similarity indexes which became a lot faster now. [#70102](https://github.com/ClickHouse/ClickHouse/pull/70102) ([Robert Schulze](https://github.com/rschu1ze)).
* Implement Iceberg tables partition pruning for time-related transform partition operations in Iceberg. [#72044](https://github.com/ClickHouse/ClickHouse/pull/72044) ([Daniil Ivanik](https://github.com/divanik)).
* Add the ability to create min-max (skipping) indices by default for columns managed by MergeTree using settings `enable_minmax_index_for_all_numeric_columns` (for numeric columns) and `enable_minmax_index_for_all_string_columns` (for string columns). For now, both settings are disabled, so there is no behavior change yet. [#72090](https://github.com/ClickHouse/ClickHouse/pull/72090) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Added aggregation function sequenceMatchEvents which return timestamps of matched events for longest chain of events in pattern. [#72349](https://github.com/ClickHouse/ClickHouse/pull/72349) ([UnamedRus](https://github.com/UnamedRus)).
* `SELECT` and `VIEW` statements now support aliases, e.g. `SELECT b FROM (SELECT number, number*2 FROM numbers(2)) AS x (a, b);`. This enables TPC-H query 15 to run without modifications. [#72480](https://github.com/ClickHouse/ClickHouse/pull/72480) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Added function `arrayNormalizedGini`. [#72823](https://github.com/ClickHouse/ClickHouse/pull/72823) ([flynn](https://github.com/ucasfl)).
* When `min_age_to_force_merge_seconds` and `min_age_to_force_merge_on_partition_only` are both enabled, the part merging will ignore the max bytes limit. [#73656](https://github.com/ClickHouse/ClickHouse/pull/73656) ([Kai Zhu](https://github.com/nauu)).
* Support reading HALF_FLOAT values from Apache Arrow/Parquet/ORC (they are read into Float32). This closes [#72960](https://github.com/ClickHouse/ClickHouse/issues/72960). Keep in mind that IEEE-754 half float is not the same as BFloat16. Closes [#73835](https://github.com/ClickHouse/ClickHouse/issues/73835). [#73836](https://github.com/ClickHouse/ClickHouse/pull/73836) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The `system.trace_log` table will contain two new columns, `symbols` and `lines` containing symbolized stack trace. It allows for easy collection and export of profile information. This is controlled by the server configuration value `symbolize` inside `trace_log` and is enabled by default. [#73896](https://github.com/ClickHouse/ClickHouse/pull/73896) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a new function, `generateSerialID`, which can be used to generate auto-incremental numbers in tables. Continuation of [#64310](https://github.com/ClickHouse/ClickHouse/issues/64310) by [kazalika](https://github.com/kazalika). This closes [#62485](https://github.com/ClickHouse/ClickHouse/issues/62485). [#73950](https://github.com/ClickHouse/ClickHouse/pull/73950) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add syntax `query1 PARALLEL WITH query2 PARALLEL WITH query3 ... PARALLEL WITH queryN` That means subqueries `{query1, query2, ... queryN}` are allowed to run in parallel with each other (and it's preferable). [#73983](https://github.com/ClickHouse/ClickHouse/pull/73983) ([Vitaly Baranov](https://github.com/vitlibar)).
* Now, Play UI has a progress bar during query runtime. It allows cancelling queries. It displays the total number of records and the extended information about the speed. The table can be rendered incrementally as soon as data arrives. Enable HTTP compression. Rendering of the table became faster. The table header became sticky. It allows selecting cells and navigating them by arrow keys. Fix the issue when the outline of the selected cell makes it smaller. Cells no longer expand on mouse hover but only on selection. The moment to stop rendering the incoming data is decided on the client rather than on the server side. Highlight digit groups for numbers. The overall design was refreshed and became bolder. It checks if the server is reachable and the correctness of credentials and displays the server version and uptime. The cloud icon is contoured in every font, even in Safari. Big integers inside nested data types will be rendered better. It will display inf/nan correctly. It will display data types when the mouse is over a column header. [#74204](https://github.com/ClickHouse/ClickHouse/pull/74204) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add the ability to create min-max (skipping) indices by default for columns managed by MergeTree using settings `add_minmax_index_for_numeric_columns` (for numeric columns) and `add_minmax_index_for_string_columns` (for string columns). For now, both settings are disabled, so there is no behavior change yet. [#74266](https://github.com/ClickHouse/ClickHouse/pull/74266) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Add `script_query_number` and `script_line_number` fields to `system.query_log`, to the ClientInfo in the native protocol, and to server logs. This closes [#67542](https://github.com/ClickHouse/ClickHouse/issues/67542). Credits to [pinsvin00](https://github.com/pinsvin00) for kicking off this feature earlier in [#68133](https://github.com/ClickHouse/ClickHouse/issues/68133). [#74477](https://github.com/ClickHouse/ClickHouse/pull/74477) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add minus operator support for DateTime64, to allow subtraction between DateTime64 values, as well as DateTime. [#74482](https://github.com/ClickHouse/ClickHouse/pull/74482) ([Li Yin](https://github.com/liyinsg)).
* Backported in [#75020](https://github.com/ClickHouse/ClickHouse/issues/75020): Added an ability to apply non-finished (not materialized by background process) mutations during the execution of `SELECT` queries immediately after submitting. It can be enabled by setting `apply_mutations_on_fly`. [#74877](https://github.com/ClickHouse/ClickHouse/pull/74877) ([Anton Popov](https://github.com/CurtizJ)).

#### Performance Improvement
* Start to compare rows from most likely unequal columns first. [#63780](https://github.com/ClickHouse/ClickHouse/pull/63780) ([UnamedRus](https://github.com/UnamedRus)).
* Optimize RowBinary input format. Closes [#63805](https://github.com/ClickHouse/ClickHouse/issues/63805). [#65059](https://github.com/ClickHouse/ClickHouse/pull/65059) ([Pavel Kruglov](https://github.com/Avogar)).
* Speedup string deserialisation by some low-level optimisation. [#65948](https://github.com/ClickHouse/ClickHouse/pull/65948) ([Nikita Taranov](https://github.com/nickitat)).
* Improve grace hash join performance by rerange the right join table by keys. [#72237](https://github.com/ClickHouse/ClickHouse/pull/72237) ([kevinyhzou](https://github.com/KevinyhZou)).
* Allow `arrayROCAUC` and `arrayAUCPR` to compute partial area of the whole curve, so that its calculation can be parallelized over huge datasets. [#72904](https://github.com/ClickHouse/ClickHouse/pull/72904) ([Emmanuel](https://github.com/emmanuelsdias)).
* Avoid spawn too many idle threads. [#72920](https://github.com/ClickHouse/ClickHouse/pull/72920) ([Guo Wangyang](https://github.com/guowangy)).
* Splitting of left table blocks by hash was removed from the probe phase of the `parallel_hash` JOIN algorithm. [#73089](https://github.com/ClickHouse/ClickHouse/pull/73089) ([Nikita Taranov](https://github.com/nickitat)).
* Don't list blob storage keys if we only have curly brackets expansion in table function. Closes [#73333](https://github.com/ClickHouse/ClickHouse/issues/73333). [#73518](https://github.com/ClickHouse/ClickHouse/pull/73518) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Revert "Revert "Short circuit optimization for functions executed over Nullable arguments"" . Add fast path for functions with all argument types is numeric. Fix performance issues in https://github.com/ClickHouse/ClickHouse/pull/72258. [#73820](https://github.com/ClickHouse/ClickHouse/pull/73820) ([李扬](https://github.com/taiyang-li)).
* Do not apply `maskedExecute` on non-function columns, improve the performance of short circuit execution. [#73965](https://github.com/ClickHouse/ClickHouse/pull/73965) ([lgbo](https://github.com/lgbo-ustc)).
* Disable header detection for Kafka/NATS/RabbitMQ/FileLog to improve performance. [#74006](https://github.com/ClickHouse/ClickHouse/pull/74006) ([Azat Khuzhin](https://github.com/azat)).
* Use log wrappers by value and don't allocate them in a heap. [#74034](https://github.com/ClickHouse/ClickHouse/pull/74034) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Execute pipeline with a higher degree of parallelism after aggregation with grouping sets. [#74082](https://github.com/ClickHouse/ClickHouse/pull/74082) ([Nikita Taranov](https://github.com/nickitat)).
* Reduce critical section in `MergeTreeReadPool`. [#74202](https://github.com/ClickHouse/ClickHouse/pull/74202) ([Guo Wangyang](https://github.com/guowangy)).
* Optimized function `indexHint`. Now, columns that are only used as arguments of function `indexHint` are not read from the table. [#74314](https://github.com/ClickHouse/ClickHouse/pull/74314) ([Anton Popov](https://github.com/CurtizJ)).
* Parallel replicas performance improvement. Packets deserialization on query initiator, for packets not related to parallel replicas protocol, now always happens in pipeline thread. Before, it could happen in a thread responsible for pipeline scheduling, which could make initiator less responsive and delay pipeline execution. [#74398](https://github.com/ClickHouse/ClickHouse/pull/74398) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#75069](https://github.com/ClickHouse/ClickHouse/issues/75069): Fixed calculation of size in memory for `LowCardinality` columns. [#74688](https://github.com/ClickHouse/ClickHouse/pull/74688) ([Nikita Taranov](https://github.com/nickitat)).

#### Improvement
* Improve new analyzer infrastructure performance via storing `ColumnPtr` instead of `Field` in the `ConstantNode`. Related to [#62245](https://github.com/ClickHouse/ClickHouse/issues/62245). [#63198](https://github.com/ClickHouse/ClickHouse/pull/63198) ([Dmitry Novik](https://github.com/novikd)).
* Allow to create bloom_filter index on columns with datatype DateTime64. [#66416](https://github.com/ClickHouse/ClickHouse/pull/66416) ([Yutong Xiao](https://github.com/YutSean)).
* Added HTTP headers to OpenTelemetry span logs table for enhanced traceability. [#70516](https://github.com/ClickHouse/ClickHouse/pull/70516) ([jonymohajanGmail](https://github.com/jonymohajanGmail)).
* Support write orc file by custom time zone, not always by `GMT` time zone. [#70615](https://github.com/ClickHouse/ClickHouse/pull/70615) ([kevinyhzou](https://github.com/KevinyhZou)).
* Respect IO scheduling settings when writing backups across clouds. [#71093](https://github.com/ClickHouse/ClickHouse/pull/71093) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Reestablish connection to MySQL and Postgres dictionary replicas in background so it wouldn't delay requests to corresponding dictionaries. [#71101](https://github.com/ClickHouse/ClickHouse/pull/71101) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Add metric alias name to system.asynchronous_metrics. [#71164](https://github.com/ClickHouse/ClickHouse/pull/71164) ([megao](https://github.com/jetgm)).
* Interactive metrics improvements. Fix metrics from parallel replicas not being fully displayed. Display the metrics in order of the most recent update, then lexicographically by name. Do not display stale metrics. [#71631](https://github.com/ClickHouse/ClickHouse/pull/71631) ([Julia Kartseva](https://github.com/jkartseva)).
* Historically for some reason, the query `ALTER TABLE MOVE PARTITION TO TABLE` checked `SELECT` and `ALTER DELETE` rights instead of dedicated `ALTER_MOVE_PARTITION`. This PR makes use of this access type. For compatibility, this permission is also will be granted implicitly if `SELECT` and `ALTER DELETE` are granted, but this behavior will be removed in future releases. Closes [#16403](https://github.com/ClickHouse/ClickHouse/issues/16403). [#71632](https://github.com/ClickHouse/ClickHouse/pull/71632) ([pufit](https://github.com/pufit)).
* Enables setting `use_hive_partitioning` by default. [#71636](https://github.com/ClickHouse/ClickHouse/pull/71636) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Throw an exception when trying to materialize a column in the sort key instead of allowing it to break the sort order. Does not solve [#71777](https://github.com/ClickHouse/ClickHouse/issues/71777), though. [#71891](https://github.com/ClickHouse/ClickHouse/pull/71891) ([Peter Nguyen](https://github.com/petern48)).
* Allow more general join planning algorithm when hash join algorithm is enabled. [#71926](https://github.com/ClickHouse/ClickHouse/pull/71926) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Hide secrets in `EXPLAIN QUERY TREE`. [#72025](https://github.com/ClickHouse/ClickHouse/pull/72025) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Allow to use a configurable disk to store metadata files of databases and tables. The disk name can be set via `database_disk.disk` config parameter. [#72027](https://github.com/ClickHouse/ClickHouse/pull/72027) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Support parquet integer logical types on native reader. [#72105](https://github.com/ClickHouse/ClickHouse/pull/72105) ([Arthur Passos](https://github.com/arthurpassos)).
* Make JSON output format pretty by default. Add new setting `output_format_json_pretty_print` to control it and enable it by default. [#72148](https://github.com/ClickHouse/ClickHouse/pull/72148) ([Pavel Kruglov](https://github.com/Avogar)).
* Interactively request credentials in the browser if the default user requires a password. In previous versions, the server returned HTTP 403; now, it returns HTTP 401. [#72198](https://github.com/ClickHouse/ClickHouse/pull/72198) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This PR converts access types `CREATE_USER`, `ALTER_USER`, `DROP_USER`, `CREATE_ROLE`, `ALTER_ROLE`, `DROP_ROLE` from global to parameterized. That means users can now grant access management grants more precise:. [#72246](https://github.com/ClickHouse/ClickHouse/pull/72246) ([pufit](https://github.com/pufit)).
* Support CAST and ALTER between JSON types with different parameters. [#72303](https://github.com/ClickHouse/ClickHouse/pull/72303) ([Pavel Kruglov](https://github.com/Avogar)).
* Add the `latest_fail_error_code_name` column to `system.mutations`. We need this column to introduce a new metric on stuck mutations and use it to build graphs of the errors encountered in the cloud as well as, optionally, adding a new less-noisy alert. [#72398](https://github.com/ClickHouse/ClickHouse/pull/72398) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Reduce amount of allocation in attach partition. [#72583](https://github.com/ClickHouse/ClickHouse/pull/72583) ([Konstantin Morozov](https://github.com/k-morozov)).
* Make max_bytes_before_external_sort limit depends on total query memory consumption (previously it was number of bytes in the sorting block for one sorting thread, now it has the same meaning as `max_bytes_before_external_group_by` - it is total limit for the whole query memory for all threads). Also one more setting added to control on disk block size - `min_external_sort_block_bytes`. [#72598](https://github.com/ClickHouse/ClickHouse/pull/72598) ([Azat Khuzhin](https://github.com/azat)).
* Ignore memory restrictions by trace collector. [#72606](https://github.com/ClickHouse/ClickHouse/pull/72606) ([Azat Khuzhin](https://github.com/azat)).
* Support subcolumns in MergeTree sorting key and skip indexes. [#72644](https://github.com/ClickHouse/ClickHouse/pull/72644) ([Pavel Kruglov](https://github.com/Avogar)).
* Add server settings `dictionaries_lazy_load` and `wait_dictionaries_load_at_startup` to `system.server_settings`. [#72664](https://github.com/ClickHouse/ClickHouse/pull/72664) ([Christoph Wurm](https://github.com/cwurm)).
* Adds setting `max_backup_bandwidth` to the list of settings that can be specified as part of `BACKUP`/`RESTORE` queries. [#72665](https://github.com/ClickHouse/ClickHouse/pull/72665) ([Christoph Wurm](https://github.com/cwurm)).
* Parallel replicas used historical information about replica availability to improve replica selection but did not update the replica's error count when the connection was unavailable. This PR updates the replica's error count when unavailable. [#72666](https://github.com/ClickHouse/ClickHouse/pull/72666) ([zoomxi](https://github.com/zoomxi)).
* Reducing the log level for appearing replicated parts in the ReplicatedMergeTree engine to help minimize the volume of logs generated in a replicated cluster. [#72876](https://github.com/ClickHouse/ClickHouse/pull/72876) ([mor-akamai](https://github.com/morkalfon)).
* A lot of new features will require better code incapsulation (what relates to Iceberg metadata) and better code abstractions. [#72941](https://github.com/ClickHouse/ClickHouse/pull/72941) ([Daniil Ivanik](https://github.com/divanik)).
* Support equal comparison for values of JSON column. [#72991](https://github.com/ClickHouse/ClickHouse/pull/72991) ([Pavel Kruglov](https://github.com/Avogar)).
* Improve formatting of identifiers with JSON subcolumns to avoid unnecessary back quotes. [#73085](https://github.com/ClickHouse/ClickHouse/pull/73085) ([Pavel Kruglov](https://github.com/Avogar)).
* Log `PREWHERE` conditions with `Test` level. [#73116](https://github.com/ClickHouse/ClickHouse/pull/73116) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Support SETTINGS with implicit ENGINE and mixing engine and query settings. [#73120](https://github.com/ClickHouse/ClickHouse/pull/73120) ([Raúl Marín](https://github.com/Algunenano)).
* Write parts with level 1 if `optimize_on_insert` is enabled. It allows to use several optimizations of queries with `FINAL` for freshly written parts. [#73132](https://github.com/ClickHouse/ClickHouse/pull/73132) ([Anton Popov](https://github.com/CurtizJ)).
* Improve extraction of common expression in disjunctions. Allow simplifying the resulting filter expression even if there's no common subexpression for all the disjuncts. Continuation of [#71537](https://github.com/ClickHouse/ClickHouse/issues/71537). [#73271](https://github.com/ClickHouse/ClickHouse/pull/73271) ([Dmitry Novik](https://github.com/novikd)).
* In Storage `S3(Azure)Queue` allow to add settings where table was created without settings. [#73283](https://github.com/ClickHouse/ClickHouse/pull/73283) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Clickhouse-client supports Ctrl+D to finish the query. Allow using Ctrl+D instead of typing a semicolon and pressing Enter. Additionally, make Ctrl+D work as Enter in the single-line mode. [#73293](https://github.com/ClickHouse/ClickHouse/pull/73293) ([Wudidapaopao](https://github.com/wudidapaopao)).
* Introduce a setting `least_greatest_legacy_null_behavior` (default: `false`) which controls if functions `least` and `greatest` handle `NULL` arguments by unconditionally returning `NULL` (if `true`) or by ignoring them (if `false`). [#73344](https://github.com/ClickHouse/ClickHouse/pull/73344) ([Robert Schulze](https://github.com/rschu1ze)).
* Use Keeper multi requests in cleanup thread ObjectStorageQueueMetadata. [#73357](https://github.com/ClickHouse/ClickHouse/pull/73357) ([Antonio Andelic](https://github.com/antonio2368)).
* A new MongoDB driver is now the default. Users who like to continue using the legacy driver can set server setting `use_legacy_mongodb_integration` to true. [#73359](https://github.com/ClickHouse/ClickHouse/pull/73359) ([Robert Schulze](https://github.com/rschu1ze)).
* When ClickHouse runs under cgroup we will still collect system-wide asynchronous metrics related to system load, process scheduling, memory etc. They might provide useful signals when ClickHouse is the only process on the host with high resource consumption. [#73369](https://github.com/ClickHouse/ClickHouse/pull/73369) ([Nikita Taranov](https://github.com/nickitat)).
* In storage S3Queue allow to transfer old ordered tables created before 24.6 to new structure with buckets. [#73467](https://github.com/ClickHouse/ClickHouse/pull/73467) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add `system.azure_queue` similar to existing `system.s3queue`. [#73477](https://github.com/ClickHouse/ClickHouse/pull/73477) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed a regression that using collation locales with modifiers throws an error. As an example, `SELECT arrayJoin(['kk 50', 'KK 01', ' KK 2', ' KK 3', 'kk 1', 'x9y99', 'x9y100']) item ORDER BY item ASC COLLATE 'tr-u-kn-true-ka-shifted` now works. [#73544](https://github.com/ClickHouse/ClickHouse/pull/73544) ([Robert Schulze](https://github.com/rschu1ze)).
* Function `parseDateTime64` (and its variants) now produces correct results for input dates before 1970 / after 2106. Example: `SELECT parseDateTime64InJodaSyntax('2200-01-01 00:00:00.000', 'yyyy-MM-dd HH:mm:ss.SSS')`. [#73594](https://github.com/ClickHouse/ClickHouse/pull/73594) ([zhanglistar](https://github.com/zhanglistar)).
* Address some clickhouse-disks usability issues addressed by users. Closes [#67136](https://github.com/ClickHouse/ClickHouse/issues/67136). [#73616](https://github.com/ClickHouse/ClickHouse/pull/73616) ([Daniil Ivanik](https://github.com/divanik)).
* Allow to alter commit settings in storage S3(Azure)Queue. (Commit settings are: max_processed_files_before_commit, max_processed_rows_before_commit, max_processed_bytes_before_commit, max_processing_time_sec_before_commit). [#73635](https://github.com/ClickHouse/ClickHouse/pull/73635) ([Kseniia Sumarokova](https://github.com/kssenii)).
* In storage S3(Azure)Queue aggregate progress between sources to compare with commit limit settings. [#73641](https://github.com/ClickHouse/ClickHouse/pull/73641) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support core settings in `BACKUP`/`RESTORE` query. [#73650](https://github.com/ClickHouse/ClickHouse/pull/73650) ([Vitaly Baranov](https://github.com/vitlibar)).
* Read `output_format_compression_level` on Parquet output. [#73651](https://github.com/ClickHouse/ClickHouse/pull/73651) ([Arthur Passos](https://github.com/arthurpassos)).
* Adds reading arrow fixed_size_list as an Array instead of treating it as an unsupported type. [#73654](https://github.com/ClickHouse/ClickHouse/pull/73654) ([Julian Meyers](https://github.com/J-Meyers)).
* This PR adds two backup engines: `Memory` (keeps backups inside the current user session), and `Null` (doesn't keep backups anywhere):. [#73690](https://github.com/ClickHouse/ClickHouse/pull/73690) ([Vitaly Baranov](https://github.com/vitlibar)).
* `concurrent_threads_soft_limit_num` and `concurrent_threads_soft_limit_num_ratio_to_cores` could be changed w/o restart of a server. [#73713](https://github.com/ClickHouse/ClickHouse/pull/73713) ([Sergei Trifonov](https://github.com/serxa)).
* Add support for extended numeric types (Decimal, big integers) in formatReadable functions. [#73765](https://github.com/ClickHouse/ClickHouse/pull/73765) ([Raúl Marín](https://github.com/Algunenano)).
* Support TLS for Postgres wire protocol. [#73812](https://github.com/ClickHouse/ClickHouse/pull/73812) ([scanhex12](https://github.com/scanhex12)).
* Allow `LowCardinality(UUID)` by default. This has proven practical among ClickHouse Cloud customers. [#73826](https://github.com/ClickHouse/ClickHouse/pull/73826) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better message during installation. [#73827](https://github.com/ClickHouse/ClickHouse/pull/73827) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better message about password reset for ClickHouse Cloud. [#73831](https://github.com/ClickHouse/ClickHouse/pull/73831) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve the error message with a File table that cannot perform appends into a file. [#73832](https://github.com/ClickHouse/ClickHouse/pull/73832) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Ask when a user accidentally requests to output binary format (such as Native, Parquet, Avro) in the terminal. This closes [#59524](https://github.com/ClickHouse/ClickHouse/issues/59524). [#73833](https://github.com/ClickHouse/ClickHouse/pull/73833) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The `BFloat16` data type is production-ready. [#73840](https://github.com/ClickHouse/ClickHouse/pull/73840) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Highlight trailing spaces in Pretty and Vertical formats in the terminal for better clarity. This is controlled with the `output_format_pretty_highlight_trailing_spaces` setting. Initial implementation by [Braden Burns](https://github.com/bradenburns) from [#72996](https://github.com/ClickHouse/ClickHouse/issues/72996). Closes [#71590](https://github.com/ClickHouse/ClickHouse/issues/71590). [#73847](https://github.com/ClickHouse/ClickHouse/pull/73847) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `clickhouse-client` and `clickhouse-local` will autodetect compression of stdin when it is redirected from a file. This closes [#70865](https://github.com/ClickHouse/ClickHouse/issues/70865). [#73848](https://github.com/ClickHouse/ClickHouse/pull/73848) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Cut too long column names in pretty formats by default. This is controlled by the `output_format_pretty_max_column_name_width_cut_to` and `output_format_pretty_max_column_name_width_min_chars_to_cut` settings. This is the continuation of the work of [tanmaydatta](https://github.com/tanmaydatta) in [#66502](https://github.com/ClickHouse/ClickHouse/issues/66502). This closes [#65968](https://github.com/ClickHouse/ClickHouse/issues/65968). [#73851](https://github.com/ClickHouse/ClickHouse/pull/73851) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make `Pretty` formats prettier: squash blocks if not much time passed since the output of the previous block. This is controlled by new settings `output_format_pretty_squash_consecutive_ms` (50 ms by default) and `output_format_pretty_squash_max_wait_ms` (1000 ms by default). Continuation of [#49537](https://github.com/ClickHouse/ClickHouse/issues/49537). This closes [#49153](https://github.com/ClickHouse/ClickHouse/issues/49153). [#73852](https://github.com/ClickHouse/ClickHouse/pull/73852) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a metric on the number of currently merging source parts. This closes [#70809](https://github.com/ClickHouse/ClickHouse/issues/70809). [#73868](https://github.com/ClickHouse/ClickHouse/pull/73868) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Highlight columns in the `Vertical` format if the output is to a terminal. This can be disabled with the `output_format_pretty_color` setting. [#73898](https://github.com/ClickHouse/ClickHouse/pull/73898) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enhanced the MySQL compatibility to a level that now, `mysqlsh` (a rich MySQL CLI from Oracle) can connect to ClickHouse. This is needed to facilitate testing. [#73912](https://github.com/ClickHouse/ClickHouse/pull/73912) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* If the number of output records is larger than N = `output_format_pretty_max_rows`, instead of displaying only the first N rows, we will cut the output table in the middle, displaying N/2 first rows and N/2 last rows. Continuation of [#64200](https://github.com/ClickHouse/ClickHouse/issues/64200). This closes [#59502](https://github.com/ClickHouse/ClickHouse/issues/59502). [#73929](https://github.com/ClickHouse/ClickHouse/pull/73929) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The function `isIPv4String` returned true if the correct IPv4 address was followed by a zero byte, while it should return false in this case. Continuation of [#65387](https://github.com/ClickHouse/ClickHouse/issues/65387). [#73946](https://github.com/ClickHouse/ClickHouse/pull/73946) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make the error code in the MySQL wire protocol compatible with MySQL. Continuation of [#56831](https://github.com/ClickHouse/ClickHouse/issues/56831). Closes [#50957](https://github.com/ClickHouse/ClickHouse/issues/50957). [#73948](https://github.com/ClickHouse/ClickHouse/pull/73948) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add setting `validate_enum_literals_in_opearators` to validate enum literals in operators like `IN`, `NOT IN` against the enum type and throw an exception if the literal is not a valid enum value. [#73985](https://github.com/ClickHouse/ClickHouse/pull/73985) ([Vladimir Cherkasov](https://github.com/vdimir)).
* In Storage `S3(Azure)Queue` commit all files (in a single butch defined by commit settings) in a single keeper transaction. [#73991](https://github.com/ClickHouse/ClickHouse/pull/73991) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Disable header detection for executable UDFs and dictionaries (could lead to Function 'X': wrong result, expected Y row(s), actual Y-1). [#73992](https://github.com/ClickHouse/ClickHouse/pull/73992) ([Azat Khuzhin](https://github.com/azat)).
* Add the `distributed` option for `EXPLAIN PLAN.` Now, `EXPLAIN distributed=1 ... ` appends remote plan to `ReadFromParallelRemote*` steps. [#73994](https://github.com/ClickHouse/ClickHouse/pull/73994) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Use correct return type for not/xor with Dynamic arguments. [#74013](https://github.com/ClickHouse/ClickHouse/pull/74013) ([Pavel Kruglov](https://github.com/Avogar)).
* Allow changing `add_implicit_sign_column_constraint_for_collapsing_engine` after table creation. [#74014](https://github.com/ClickHouse/ClickHouse/pull/74014) ([Christoph Wurm](https://github.com/cwurm)).
* Support subcolumns in materialized view select query. [#74030](https://github.com/ClickHouse/ClickHouse/pull/74030) ([Pavel Kruglov](https://github.com/Avogar)).
* Pretty formats can render multi-line fields inside a table cell, which improves readability. This is enabled by default and can be controlled by the setting `output_format_pretty_multiline_fields`. Continuation of the work by [Volodyachan](https://github.com/Volodyachan) in [#64094](https://github.com/ClickHouse/ClickHouse/issues/64094). This closes [#56912](https://github.com/ClickHouse/ClickHouse/issues/56912). [#74032](https://github.com/ClickHouse/ClickHouse/pull/74032) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Support `predicate-push-down` optimization on the query plan level for the `MergingAggregated` step. It improves performance for some queries with the new analyzer. [#74073](https://github.com/ClickHouse/ClickHouse/pull/74073) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* There are now three simple ways to set a custom prompt in `clickhouse-client`: 1. via command-line parameter `--prompt`, 2. in the configuration file, via settings `<prompt>[...]</prompt>`, and 3. also in the configuration file, via per-connection settings `<connections_credentials><prompt>[...]</prompt></connection_credentials>`. [#74168](https://github.com/ClickHouse/ClickHouse/pull/74168) ([Christoph Wurm](https://github.com/cwurm)).
* Expose X-ClickHouse HTTP headers to JavaScript in the browser. It makes writing applications more convenient. [#74180](https://github.com/ClickHouse/ClickHouse/pull/74180) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The `JSONEachRowWithProgress` format will include events with metadata, as well as totals and extremes. It also includes `rows_before_limit_at_least` and `rows_before_aggregation`. The format prints the exception properly if it arrives after partial results. The progress now includes elapsed nanoseconds. One final progress event is emitted at the end. The progress during query runtime will be printed no more frequently than the value of the `interactive_delay` setting. [#74181](https://github.com/ClickHouse/ClickHouse/pull/74181) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Hourglass will rotate smoothly in Play UI. [#74182](https://github.com/ClickHouse/ClickHouse/pull/74182) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Even if the HTTP response is compressed, send packets as soon as they arrive. This allows the browser to receive progress packets and compressed data. [#74201](https://github.com/ClickHouse/ClickHouse/pull/74201) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Autodetect secure connection based on connecting to port 9440 in ClickHouse Client. [#74212](https://github.com/ClickHouse/ClickHouse/pull/74212) ([Christoph Wurm](https://github.com/cwurm)).
* Authenticate users with username only for http_handlers (previously it requires user to put the password as well). [#74221](https://github.com/ClickHouse/ClickHouse/pull/74221) ([Azat Khuzhin](https://github.com/azat)).
* Support for the alternative query languages PRQL and KQL was marked experimental. To use them, specify settings `allow_experimental_prql_dialect = 1` and `allow_experimental_kusto_dialect = 1`. [#74224](https://github.com/ClickHouse/ClickHouse/pull/74224) ([Robert Schulze](https://github.com/rschu1ze)).
* Support returning the default Enum type in more aggregate functions. [#74272](https://github.com/ClickHouse/ClickHouse/pull/74272) ([Raúl Marín](https://github.com/Algunenano)).
* In `OPTIMIZE TABLE`, it is now possible to specify keyword `FORCE` as an alternative to existing keyword `FINAL`. [#74342](https://github.com/ClickHouse/ClickHouse/pull/74342) ([Robert Schulze](https://github.com/rschu1ze)).
* Added a merge tree setting `materialize_skip_indexes_on_merge` which suppresses the creation of skip indexes during merge. This allows users to control explicitly (via `ALTER TABLE [..] MATERIALIZE INDEX [...]`) when skip indexes are created. This can be useful if skip indexes are expensive to build (e.g. vector similarity indexes). [#74401](https://github.com/ClickHouse/ClickHouse/pull/74401) ([Robert Schulze](https://github.com/rschu1ze)).
* Optimize keeper requests in Storage(S3/Azure)Queue. [#74410](https://github.com/ClickHouse/ClickHouse/pull/74410) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add the IsServerShuttingDown metric, which is needed to trigger an alert when the server shutdown takes too much time. [#74429](https://github.com/ClickHouse/ClickHouse/pull/74429) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Added iceberg tables names to EXPLAIN. [#74485](https://github.com/ClickHouse/ClickHouse/pull/74485) ([alekseev-maksim](https://github.com/alekseev-maksim)).
* Use up to `1000` parallel replicas by default. [#74504](https://github.com/ClickHouse/ClickHouse/pull/74504) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Provide a better error message when using RECURSIVE CTE with the old analyzer. [#74523](https://github.com/ClickHouse/ClickHouse/pull/74523) ([Raúl Marín](https://github.com/Algunenano)).
* Optimize keeper requests in Storage(S3/Azure)Queue. [#74538](https://github.com/ClickHouse/ClickHouse/pull/74538) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Improve HTTP session reuse when reading from s3 disk ([#72401](https://github.com/ClickHouse/ClickHouse/issues/72401)). [#74548](https://github.com/ClickHouse/ClickHouse/pull/74548) ([Julian Maicher](https://github.com/jmaicher)).
* Show extended error messages in `system.errors`. [#74574](https://github.com/ClickHouse/ClickHouse/pull/74574) ([Vitaly Baranov](https://github.com/vitlibar)).
* More accurate accounting for `max_joined_block_size_rows` setting for `parallel_hash` JOIN algorithm. Helps to avoid increased memory consumption compared to `hash` algorithm. [#74630](https://github.com/ClickHouse/ClickHouse/pull/74630) ([Nikita Taranov](https://github.com/nickitat)).
* Fixes Invalid: Codec 'snappy' doesn't support setting a compression level. [#74659](https://github.com/ClickHouse/ClickHouse/pull/74659) ([Arthur Passos](https://github.com/arthurpassos)).
* Allow to use password for client communication with clickhouse-keeper. This feature is not very useful if you specify proper SSL configuration for server and client, but still can be useful for some cases. Password cannot be longer than 16 characters. It's not connected with Keeper Auth model. [#74673](https://github.com/ClickHouse/ClickHouse/pull/74673) ([alesapin](https://github.com/alesapin)).
* Add error code for config reloader. [#74746](https://github.com/ClickHouse/ClickHouse/pull/74746) ([Garrett Thomas](https://github.com/garrettthomaskth)).
* Added support for IPv6 addresses in MySQL and PostgreSQL table functions and engines. [#74796](https://github.com/ClickHouse/ClickHouse/pull/74796) ([Mikhail Koviazin](https://github.com/mkmkme)).
* Implement short circuit optimization for `divideDecimal`. Fixes [#74280](https://github.com/ClickHouse/ClickHouse/issues/74280). [#74843](https://github.com/ClickHouse/ClickHouse/pull/74843) ([Kevin Mingtarja](https://github.com/kevinmingtarja)).
* Improve performance of larger multi requests in Keeper. [#74849](https://github.com/ClickHouse/ClickHouse/pull/74849) ([Antonio Andelic](https://github.com/antonio2368)).
* Now users can be specified inside the startup scripts. [#74894](https://github.com/ClickHouse/ClickHouse/pull/74894) ([pufit](https://github.com/pufit)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Fix cannot create SEQUENTIAL node with keeper-client. [#64177](https://github.com/ClickHouse/ClickHouse/pull/64177) ([Duc Canh Le](https://github.com/canhld94)).
* Fix incorrect character counting in PositionImpl::vectorVector. [#71003](https://github.com/ClickHouse/ClickHouse/pull/71003) ([思维](https://github.com/heymind)).
* `RESTORE` operations for access entities required more permission than necessary because of unhandled partial revokes. This PR fixes the issue. Closes [#71853](https://github.com/ClickHouse/ClickHouse/issues/71853). [#71958](https://github.com/ClickHouse/ClickHouse/pull/71958) ([pufit](https://github.com/pufit)).
* Avoid pause after `ALTER TABLE REPLACE/MOVE PARTITION FROM/TO TABLE`. Retrieve correct settings for background task scheduling. [#72024](https://github.com/ClickHouse/ClickHouse/pull/72024) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Fix handling of empty tuples in some input and output formats (e.g. Parquet, Arrow). [#72616](https://github.com/ClickHouse/ClickHouse/pull/72616) ([Michael Kolupaev](https://github.com/al13n321)).
* Column-level GRANT SELECT/INSERT statements on wildcard databases/tables now throw an error. [#72646](https://github.com/ClickHouse/ClickHouse/pull/72646) ([Johann Gan](https://github.com/johanngan)).
* Fix the situation when a user can't run `REVOKE ALL ON *.*` because of implicit grants in the target access entity. [#72872](https://github.com/ClickHouse/ClickHouse/pull/72872) ([pufit](https://github.com/pufit)).
* Add support for Azure SAS Tokens. [#72959](https://github.com/ClickHouse/ClickHouse/pull/72959) ([Azat Khuzhin](https://github.com/azat)).
* Fix positive timezone formatting of formatDateTime scalar function. [#73091](https://github.com/ClickHouse/ClickHouse/pull/73091) ([ollidraese](https://github.com/ollidraese)).
* Fix to correctly reflect source port when connection made through PROXYv1 and `auth_use_forwarded_address` is set - previously proxy port was incorrectly used. Add `currentQueryID()` function. [#73095](https://github.com/ClickHouse/ClickHouse/pull/73095) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Propagate format settings to NativeWriter in TCPHandler, so settings like `output_format_native_write_json_as_string` are applied correctly. [#73179](https://github.com/ClickHouse/ClickHouse/pull/73179) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix crash in StorageObjectStorageQueue. [#73274](https://github.com/ClickHouse/ClickHouse/pull/73274) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix rare crash in refreshable materialized view during server shutdown. [#73323](https://github.com/ClickHouse/ClickHouse/pull/73323) ([Michael Kolupaev](https://github.com/al13n321)).
* The `%f` placeholder of function `formatDateTime` now unconditionally generates six (sub-second) digits. This makes the behavior compatible with MySQL `DATE_FORMAT` function. The previous behavior can be restored using setting `formatdatetime_f_prints_scale_number_of_digits = 1`. [#73324](https://github.com/ClickHouse/ClickHouse/pull/73324) ([ollidraese](https://github.com/ollidraese)).
* Fixed filtering by `_etag` column while reading from `s3` storage and table function. [#73353](https://github.com/ClickHouse/ClickHouse/pull/73353) ([Anton Popov](https://github.com/CurtizJ)).
* Fix `Not-ready Set is passed as the second argument for function 'in'` error when `IN (subquery)` is used in `JOIN ON` expression, with the old analyzer. [#73382](https://github.com/ClickHouse/ClickHouse/pull/73382) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix preparing for squashin for Dynamic and JSON columns. Previously in some cases new types could be inserted into shared variant/shared data even when the limit on types/paths is not reached. [#73388](https://github.com/ClickHouse/ClickHouse/pull/73388) ([Pavel Kruglov](https://github.com/Avogar)).
* Check for corrupted sizes during types binary decoding to avoid too big allocations. [#73390](https://github.com/ClickHouse/ClickHouse/pull/73390) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixed a logical error when reading from single-replica cluster with parallel replicas enabled. [#73403](https://github.com/ClickHouse/ClickHouse/pull/73403) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix ObjectStorageQueue with ZooKeeper and older Keeper. [#73420](https://github.com/ClickHouse/ClickHouse/pull/73420) ([Antonio Andelic](https://github.com/antonio2368)).
* Implements fix, needed to enable hive partitioning by default. [#73479](https://github.com/ClickHouse/ClickHouse/pull/73479) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix data race when creating vector similarity index. [#73517](https://github.com/ClickHouse/ClickHouse/pull/73517) ([Antonio Andelic](https://github.com/antonio2368)).
* Fixes segfault when the source of the dictionary contains a function with wrong data. [#73535](https://github.com/ClickHouse/ClickHouse/pull/73535) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix retries on failed insert in storage S3(Azure)Queue. Closes [#70951](https://github.com/ClickHouse/ClickHouse/issues/70951). [#73546](https://github.com/ClickHouse/ClickHouse/pull/73546) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed error in function `tupleElement` which may appear in some cases for tuples with `LowCardinality` elelments and enabled setting `optimize_functions_to_subcolumns`. [#73548](https://github.com/ClickHouse/ClickHouse/pull/73548) ([Anton Popov](https://github.com/CurtizJ)).
* Fix parsing enum glob followed by range one. Fixes [#73473](https://github.com/ClickHouse/ClickHouse/issues/73473). [#73569](https://github.com/ClickHouse/ClickHouse/pull/73569) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fixed parallel_replicas_for_non_replicated_merge_tree being ignored in subqueries for non-replicated tables. [#73584](https://github.com/ClickHouse/ClickHouse/pull/73584) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix for std::logical_error thrown when task cannot be scheduled. Found in stress tests. Example stacktrace: ``` 2024.12.19 02:05:46.171833 [ 18190 ] {01f0daba-d3cc-4898-9e0e-c2c263306427} <Fatal> : Logical error: 'std::exception. Code: 1001, type: std::__1::future_error, e.what() = The associated promise has been destructed prior to the associated state becoming ready. (version 25.1.1.18724), Stack trace:. [#73629](https://github.com/ClickHouse/ClickHouse/pull/73629) ([Alexander Gololobov](https://github.com/davenger)).
* Do not interpret queries in `EXPLAIN SYNTAX` to avoid logical errors with incorrect processing stage for distributed queries. Fixes [#65205](https://github.com/ClickHouse/ClickHouse/issues/65205). [#73634](https://github.com/ClickHouse/ClickHouse/pull/73634) ([Dmitry Novik](https://github.com/novikd)).
* Fix possible data inconsistency in Dynamic column. Fixes possible logical error `Nested columns sizes are inconsistent with local_discriminators column size`. [#73644](https://github.com/ClickHouse/ClickHouse/pull/73644) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixed `NOT_FOUND_COLUMN_IN_BLOCK` in queries with `FINAL` and `SAMPLE`. Fixed incorrect result in selects with `FINAL` from `CollapsingMergeTree` and enabled optimizations of `FINAL` . [#73682](https://github.com/ClickHouse/ClickHouse/pull/73682) ([Anton Popov](https://github.com/CurtizJ)).
* Fix crash in LIMIT BY COLUMNS. [#73686](https://github.com/ClickHouse/ClickHouse/pull/73686) ([Raúl Marín](https://github.com/Algunenano)).
* Fix the bug when the normal projection is forced to use, and query is exactly the same as the projection defined, but the projection is not selected and thus error is prompted. [#73700](https://github.com/ClickHouse/ClickHouse/pull/73700) ([Shichao Jin](https://github.com/jsc0218)).
* Fix deserialization of Dynamic/Object structure. It could lead to CANNOT_READ_ALL_DATA exceptions. [#73767](https://github.com/ClickHouse/ClickHouse/pull/73767) ([Pavel Kruglov](https://github.com/Avogar)).
* Skip `metadata_version.txt` in while restoring parts from a backup. [#73768](https://github.com/ClickHouse/ClickHouse/pull/73768) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix [#73737](https://github.com/ClickHouse/ClickHouse/issues/73737). [#73775](https://github.com/ClickHouse/ClickHouse/pull/73775) ([zhanglistar](https://github.com/zhanglistar)).
* Fixes [#72078](https://github.com/ClickHouse/ClickHouse/issues/72078) ( S3 Express Support was broken ). [#73777](https://github.com/ClickHouse/ClickHouse/pull/73777) ([Sameer Tamsekar](https://github.com/stamsekar)).
* Allow merging of rows with invalid sign column values in CollapsingMergeTree tables. [#73864](https://github.com/ClickHouse/ClickHouse/pull/73864) ([Christoph Wurm](https://github.com/cwurm)).
* Fix the following error ``` Row 1: ────── hostname: c-test-wy-37-server-nlkyjyb-0.c-test-wy-37-server-headless.ns-test-wy-37.svc.cluster.local type: ExceptionWhileProcessing event_date: 2024-12-23 event_time: 2024-12-23 16:21:19 event_time_microseconds: 2024-12-23 16:21:19.824624 query_start_time: 2024-12-23 16:21:19 query_start_time_microseconds: 2024-12-23 16:21:19.747142 query_duration_ms: 77 read_rows: 1 read_bytes: 134 written_rows: 0 written_bytes: 0 result_rows: 0 result_bytes: 0 memory_usage: 7824 current_database: default query: CREATE DATABASE db0 formatted_query: normalized_query_hash: 7820917191074023511 -- 7.82 quintillion query_kind: Create databases: ['db0'] tables: [] columns: [] partitions: [] projections: [] views: [] exception_code: 170 exception: Code: 170. DB::Exception: Bad get: has Null, requested Int64: While executing DDLOnClusterQueryStatus. (BAD_GET) (version 25.1.1.19134 (official build)) stack_trace: 0. ./build_docker/./src/Common/Exception.cpp:107: DB::Exception::Exception(DB::Exception::MessageMasked&&, int, bool) @ 0x000000000da5e53b 1. DB::Exception::Exception(PreformattedMessage&&, int) @ 0x00000000088aca4c 2. DB::Exception::Exception<std::basic_string_view<char, std::char_traits<char>>, std::basic_string_view<char, std::char_traits<char>>>(int, FormatStringHelperImpl<std::type_identity<std::basic_string_view<char, std::char_traits<char>>>::type, std::type_identity<std::basic_string_view<char, std::char_traits<char>>>::type>, std::basic_string_view<char, std::char_traits<char>>&&, std::basic_string_view<char, std::char_traits<char>>&&) @ 0x00000000088bae8b 3. auto& DB::Field::safeGet<long>() & @ 0x0000000008a3c748 4. ./src/Core/Field.h:484: DB::ColumnVector<long>::insert(DB::Field const&) @ 0x0000000012e44c0f 5. ./build_docker/./src/Interpreters/DDLOnClusterQueryStatusSource.cpp:53: DB::DDLOnClusterQueryStatusSource::generateChunkWithUnfinishedHosts() const @ 0x0000000012a40214 6. ./build_docker/./src/Interpreters/DDLOnClusterQueryStatusSource.cpp:104: DB::DDLOnClusterQueryStatusSource::handleTimeoutExceeded() @ 0x0000000012a41640 7. ./build_docker/./src/Interpreters/DDLOnClusterQueryStatusSource.cpp:109: DB::DDLOnClusterQueryStatusSource::stopWaitingOfflineHosts() @ 0x0000000012a41be9 8. ./build_docker/./src/Interpreters/DistributedQueryStatusSource.cpp:182: DB::DistributedQueryStatusSource::generate() @ 0x0000000011feb3bf 9. ./build_docker/./src/Processors/ISource.cpp:139: DB::ISource::tryGenerate() @ 0x0000000014148f5b 10. ./build_docker/./src/Processors/ISource.cpp:108: DB::ISource::work() @ 0x0000000014148c47 11. ./build_docker/./src/Processors/Executors/ExecutionThreadContext.cpp:49: DB::ExecutionThreadContext::executeTask() @ 0x0000000014164fc7 12. ./build_docker/./src/Processors/Executors/PipelineExecutor.cpp:290: DB::PipelineExecutor::executeStepImpl(unsigned long, std::atomic<bool>*) @ 0x00000000141577e5 ```. [#73876](https://github.com/ClickHouse/ClickHouse/pull/73876) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fixes occasional failure to compare `map()` types due to possibility to create `Map` lacking explicit naming ('keys','values') of its nested tuple. [#73878](https://github.com/ClickHouse/ClickHouse/pull/73878) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Ignore window functions during GROUP BY ALL clause resolution. Fix [#73501](https://github.com/ClickHouse/ClickHouse/issues/73501). [#73916](https://github.com/ClickHouse/ClickHouse/pull/73916) ([Dmitry Novik](https://github.com/novikd)).
* Fix implicit privileges (worked as wildcard before). [#73932](https://github.com/ClickHouse/ClickHouse/pull/73932) ([Azat Khuzhin](https://github.com/azat)).
* Fix high memory usage during nested Maps creation. [#73982](https://github.com/ClickHouse/ClickHouse/pull/73982) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix parsing nested JSON with empty keys. [#73993](https://github.com/ClickHouse/ClickHouse/pull/73993) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix: alias can be not added to the projection if it is referenced by another alias and selected in inverse order. [#74033](https://github.com/ClickHouse/ClickHouse/pull/74033) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* A disk using the plain_rewritable metadata can be shared among multiple server instances. It is expected for one instance to read a metadata object while another modifies it. Object not found errors are ignored during plain_rewritable initialization with Azure storage, similar to the behavior implemented for S3. [#74059](https://github.com/ClickHouse/ClickHouse/pull/74059) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix behaviour of `any` and `anyLast` with enum types and empty table. [#74061](https://github.com/ClickHouse/ClickHouse/pull/74061) ([Joanna Hulboj](https://github.com/jh0x)).
* Fixes case when the user specifies keyword arguments in the kafka table engine. [#74064](https://github.com/ClickHouse/ClickHouse/pull/74064) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix altering Storage `S3Queue` settings with "s3queue_" prefix to without and vice versa. [#74075](https://github.com/ClickHouse/ClickHouse/pull/74075) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add a setting `allow_push_predicate_ast_for_distributed_subqueries`. This adds AST-based predicate push-down for distributed queries with the analyzer. This is a temporary solution that we use until distributed queries with query plan serialization are supported. Closes [#66878](https://github.com/ClickHouse/ClickHouse/issues/66878) [#69472](https://github.com/ClickHouse/ClickHouse/issues/69472) [#65638](https://github.com/ClickHouse/ClickHouse/issues/65638) [#68030](https://github.com/ClickHouse/ClickHouse/issues/68030) [#73718](https://github.com/ClickHouse/ClickHouse/issues/73718). [#74085](https://github.com/ClickHouse/ClickHouse/pull/74085) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixes issue when after [#73095](https://github.com/ClickHouse/ClickHouse/issues/73095) port can be present in the forwarded_for field, which leads to inability to resolve host name with port included. [#74116](https://github.com/ClickHouse/ClickHouse/pull/74116) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fixed incorrect formatting of `ALTER TABLE (DROP STATISTICS ...) (DROP STATISTICS ...)`. [#74126](https://github.com/ClickHouse/ClickHouse/pull/74126) ([Han Fei](https://github.com/hanfei1991)).
* Fix for issue [#66112](https://github.com/ClickHouse/ClickHouse/issues/66112). [#74128](https://github.com/ClickHouse/ClickHouse/pull/74128) ([Anton Ivashkin](https://github.com/ianton-ru)).
* It is no longer possible to use `Loop` as a table engine in `CREATE TABLE`. This combination was previously causing segfaults. [#74137](https://github.com/ClickHouse/ClickHouse/pull/74137) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix security issue to prevent SQL injection in postgresql and sqlite table functions. [#74144](https://github.com/ClickHouse/ClickHouse/pull/74144) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix crash when reading a subcolumn from the compressed Memory engine table. Fixes [#74009](https://github.com/ClickHouse/ClickHouse/issues/74009). [#74161](https://github.com/ClickHouse/ClickHouse/pull/74161) ([Nikita Taranov](https://github.com/nickitat)).
* Fixed an infinite loop occurring with queries to the system.detached_tables. [#74190](https://github.com/ClickHouse/ClickHouse/pull/74190) ([Konstantin Morozov](https://github.com/k-morozov)).
* Fix logical error in s3queue during setting file as failed. [#74216](https://github.com/ClickHouse/ClickHouse/pull/74216) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix native copy settings (`allow_s3_native_copy`/`allow_azure_native_copy`) for `RESTORE` from base backup. [#74286](https://github.com/ClickHouse/ClickHouse/pull/74286) ([Azat Khuzhin](https://github.com/azat)).
* Fixed the issue when the number of detached tables in the database is a multiple of max_block_size. [#74289](https://github.com/ClickHouse/ClickHouse/pull/74289) ([Konstantin Morozov](https://github.com/k-morozov)).
* Fix copying via ObjectStorage (i.e. S3) when source and destination credentials differs. [#74331](https://github.com/ClickHouse/ClickHouse/pull/74331) ([Azat Khuzhin](https://github.com/azat)).
* Fix detection of "use the Rewrite method in the JSON API" for native copy on GCS. [#74338](https://github.com/ClickHouse/ClickHouse/pull/74338) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#75126](https://github.com/ClickHouse/ClickHouse/issues/75126): Fix crash when inserting interval (issue [#74299](https://github.com/ClickHouse/ClickHouse/issues/74299)). [#74478](https://github.com/ClickHouse/ClickHouse/pull/74478) ([NamHoaiNguyen](https://github.com/NamHoaiNguyen)).
* Fix incorrect calculation of `BackgroundMergesAndMutationsPoolSize` (it was x2 from real value). [#74509](https://github.com/ClickHouse/ClickHouse/pull/74509) ([alesapin](https://github.com/alesapin)).
* Fix the bug of leaking keeper watches when enable Cluster Discovery. [#74521](https://github.com/ClickHouse/ClickHouse/pull/74521) ([RinChanNOW](https://github.com/RinChanNOWWW)).
* Fix mem alignment issue reported by UBSan [#74512](https://github.com/ClickHouse/ClickHouse/issues/74512). [#74534](https://github.com/ClickHouse/ClickHouse/pull/74534) ([Arthur Passos](https://github.com/arthurpassos)).
* Fix KeeperMap concurrent cleanup during table creation. [#74568](https://github.com/ClickHouse/ClickHouse/pull/74568) ([Antonio Andelic](https://github.com/antonio2368)).
* Do not remove unused projection columns in subqueries in the presence of `EXCEPT` or `INTERSECT` to preserve the correct query result. Fixes [#73930](https://github.com/ClickHouse/ClickHouse/issues/73930). Fixes [#66465](https://github.com/ClickHouse/ClickHouse/issues/66465). [#74577](https://github.com/ClickHouse/ClickHouse/pull/74577) ([Dmitry Novik](https://github.com/novikd)).
* Fixed `INSERT SELECT` queries between tables with `Tuple` columns and enabled sparse serialization. [#74698](https://github.com/ClickHouse/ClickHouse/pull/74698) ([Anton Popov](https://github.com/CurtizJ)).
* Function `right` works incorrectly for const negative offset. [#74701](https://github.com/ClickHouse/ClickHouse/pull/74701) ([Daniil Ivanik](https://github.com/divanik)).
* Fix insertion of gzip-ed data sometimes fails due to flawed decompression on client side. [#74707](https://github.com/ClickHouse/ClickHouse/pull/74707) ([siyuan](https://github.com/linkwk7)).
* Partial revokes with wildcard grants could remove more privileges than expected. Closes [#74263](https://github.com/ClickHouse/ClickHouse/issues/74263). [#74751](https://github.com/ClickHouse/ClickHouse/pull/74751) ([pufit](https://github.com/pufit)).
* Keeper fix: fix reading log entries from disk. [#74785](https://github.com/ClickHouse/ClickHouse/pull/74785) ([Antonio Andelic](https://github.com/antonio2368)).
* Fixed checking grants for SYSTEM REFRESH/START/STOP VIEW, now it's not required to have this grant on `*.*` to execute a query for a specific view, only grant for this view are required. [#74789](https://github.com/ClickHouse/ClickHouse/pull/74789) ([Alexander Tokmakov](https://github.com/tavplubix)).
* The `hasColumnInTable` function doesn't account for alias columns. Fix it to also work for alias columns. [#74841](https://github.com/ClickHouse/ClickHouse/pull/74841) ([Bharat Nallan](https://github.com/bharatnc)).
* Backported in [#75078](https://github.com/ClickHouse/ClickHouse/issues/75078): Fix missing `used_privileges` and `missing_privileges` fields in `query_log` for BACKUP and RESTORE operations. [#74887](https://github.com/ClickHouse/ClickHouse/pull/74887) ([Alexey Katsman](https://github.com/alexkats)).
* Fix FILE_DOESNT_EXIST error occurring during data parts merge for a table with an empty column in Azure Blob Storage. [#74892](https://github.com/ClickHouse/ClickHouse/pull/74892) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix projection column name when joining temporary tables, close [#68872](https://github.com/ClickHouse/ClickHouse/issues/68872). [#74897](https://github.com/ClickHouse/ClickHouse/pull/74897) ([Vladimir Cherkasov](https://github.com/vdimir)).

#### Build/Testing/Packaging Improvement
* The internal dependency LLVM is bumped from 16 to 18. [#66053](https://github.com/ClickHouse/ClickHouse/pull/66053) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix the issue that asm files of contrib openssl cannot be generated. [#72622](https://github.com/ClickHouse/ClickHouse/pull/72622) ([RinChanNOW](https://github.com/RinChanNOWWW)).
* Fix stability for test 03210_variant_with_aggregate_function_type. [#74012](https://github.com/ClickHouse/ClickHouse/pull/74012) ([Anton Ivashkin](https://github.com/ianton-ru)).
* The universal installation script will propose installation even on macOS. [#74339](https://github.com/ClickHouse/ClickHouse/pull/74339) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix build when kerberos does not enabled. [#74771](https://github.com/ClickHouse/ClickHouse/pull/74771) ([flynn](https://github.com/ucasfl)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Revert "Revert "Revert "make d-tor Finalizer more obvious""""'. [#72898](https://github.com/ClickHouse/ClickHouse/pull/72898) ([Sema Checherinda](https://github.com/CheSema)).
* NO CL ENTRY:  'Revert "Add connection reestablisher to mysql and postgres dictionary pools"'. [#73539](https://github.com/ClickHouse/ClickHouse/pull/73539) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Second attempt: Add connection reestablisher to mysql and postgres dictionary pools'. [#73549](https://github.com/ClickHouse/ClickHouse/pull/73549) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* NO CL ENTRY:  'Revert "CI: Performance tests with praktika"'. [#73589](https://github.com/ClickHouse/ClickHouse/pull/73589) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'CI: Performance tests with praktika'. [#73596](https://github.com/ClickHouse/ClickHouse/pull/73596) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Clickhouse-client supports Ctrl+D in the multiline mode"'. [#74045](https://github.com/ClickHouse/ClickHouse/pull/74045) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Update links to clickhouse-presentations (after naming schema changes)"'. [#74195](https://github.com/ClickHouse/ClickHouse/pull/74195) ([Robert Schulze](https://github.com/rschu1ze)).
* NO CL ENTRY:  'Revert "make documentation for `anyHeavy` clearer"'. [#74260](https://github.com/ClickHouse/ClickHouse/pull/74260) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Add minmax indices by default"'. [#74264](https://github.com/ClickHouse/ClickHouse/pull/74264) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Analyzer: Refactor ConstantNode"'. [#74294](https://github.com/ClickHouse/ClickHouse/pull/74294) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Analyzer: second attemp - Refactor ConstantNode'. [#74355](https://github.com/ClickHouse/ClickHouse/pull/74355) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* NO CL ENTRY:  'Revert "CI: Remove hdfs from Integration tests"'. [#74405](https://github.com/ClickHouse/ClickHouse/pull/74405) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Revert "CI: Remove hdfs from Integration tests""'. [#74413](https://github.com/ClickHouse/ClickHouse/pull/74413) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Clickable breadcrumbs in docs"'. [#74443](https://github.com/ClickHouse/ClickHouse/pull/74443) ([Shaun Struwig](https://github.com/Blargian)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Trace if adding query into query log is disabled by query settings. [#62452](https://github.com/ClickHouse/ClickHouse/pull/62452) ([Igor Nikonov](https://github.com/devcrafter)).
* Stateless tests: add 24.5 regression tests. [#68155](https://github.com/ClickHouse/ClickHouse/pull/68155) ([Nikita Fomichev](https://github.com/fm4v)).
* Bumped LLVM to 16 version. This is an internal dependency. [#69654](https://github.com/ClickHouse/ClickHouse/pull/69654) ([Robert Schulze](https://github.com/rschu1ze)).
* Introducing JoinStepLogical. [#70974](https://github.com/ClickHouse/ClickHouse/pull/70974) ([Vladimir Cherkasov](https://github.com/vdimir)).
* First iteration of Buzzhouse. [#71085](https://github.com/ClickHouse/ClickHouse/pull/71085) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Style: Disallow using DEPRECATED settings. [#71148](https://github.com/ClickHouse/ClickHouse/pull/71148) ([Raúl Marín](https://github.com/Algunenano)).
* Enable analyzer support for vector search. [#71545](https://github.com/ClickHouse/ClickHouse/pull/71545) ([Robert Schulze](https://github.com/rschu1ze)).
* fs cache: allow to shrink file segment only to aligned size. [#71653](https://github.com/ClickHouse/ClickHouse/pull/71653) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix full-text index type name in the inverted index error message. [#72055](https://github.com/ClickHouse/ClickHouse/pull/72055) ([ruslandoga](https://github.com/ruslandoga)).
* Trying to fix [#69143](https://github.com/ClickHouse/ClickHouse/issues/69143). [#72146](https://github.com/ClickHouse/ClickHouse/pull/72146) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Add a test for recursive CTEs. [#72195](https://github.com/ClickHouse/ClickHouse/pull/72195) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove Dead Code. [#72229](https://github.com/ClickHouse/ClickHouse/pull/72229) ([Shichao Jin](https://github.com/jsc0218)).
* Make 01086_window_view_cleanup more stable. [#72232](https://github.com/ClickHouse/ClickHouse/pull/72232) ([Ilya Golshtein](https://github.com/ilejn)).
* make consistent default value of max_connections. [#72262](https://github.com/ClickHouse/ClickHouse/pull/72262) ([Denny [DBA at Innervate]](https://github.com/den-crane)).
* Randomize settings `enable_block_number_column` and `enable_block_offset_column`. [#72263](https://github.com/ClickHouse/ClickHouse/pull/72263) ([Anton Popov](https://github.com/CurtizJ)).
* Add Gary Dotzler's suggestion. [#72355](https://github.com/ClickHouse/ClickHouse/pull/72355) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Performance tests with praktika. [#72422](https://github.com/ClickHouse/ClickHouse/pull/72422) ([Max Kainov](https://github.com/maxknv)).
* Sync cloud settings. [#72481](https://github.com/ClickHouse/ClickHouse/pull/72481) ([Raúl Marín](https://github.com/Algunenano)).
* Fix: threesome joins with parallel replicas. [#72510](https://github.com/ClickHouse/ClickHouse/pull/72510) ([Igor Nikonov](https://github.com/devcrafter)).
* Added logging information to better understand skipped old parts. [#72533](https://github.com/ClickHouse/ClickHouse/pull/72533) ([Kai Zhu](https://github.com/nauu)).
* clickhouse-test: do hung check only under --hung-check. [#72806](https://github.com/ClickHouse/ClickHouse/pull/72806) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix flakiness of 03001_consider_lwd_when_merge. [#72809](https://github.com/ClickHouse/ClickHouse/pull/72809) ([Azat Khuzhin](https://github.com/azat)).
* fix clickhouse_driver inserts. [#72813](https://github.com/ClickHouse/ClickHouse/pull/72813) ([Sema Checherinda](https://github.com/CheSema)).
* output format does not write to the canceled buffer. [#72815](https://github.com/ClickHouse/ClickHouse/pull/72815) ([Sema Checherinda](https://github.com/CheSema)).
* attach_gdb.lib: print stack traces if server shutdown times out. [#72819](https://github.com/ClickHouse/ClickHouse/pull/72819) ([Michael Kolupaev](https://github.com/al13n321)).
* Adding `CrossJoinNode` to `QueryTree`. [#72856](https://github.com/ClickHouse/ClickHouse/pull/72856) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Some clang-tidy fixes. [#72869](https://github.com/ClickHouse/ClickHouse/pull/72869) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix use-after-free in loadPathPrefixMap on thread pool exception. [#72870](https://github.com/ClickHouse/ClickHouse/pull/72870) ([Michael Kolupaev](https://github.com/al13n321)).
* Using $FASTTEST_SOURCE to get path to process_functional_tests_result.py. [#72886](https://github.com/ClickHouse/ClickHouse/pull/72886) ([alekseev-maksim](https://github.com/alekseev-maksim)).
* Provides exception in case the second argument is shorter than the third for the `translate` function, so now queries like `SELECT translate('aAbBcC', 'ab', 'abc')` throw an exception. [#72893](https://github.com/ClickHouse/ClickHouse/pull/72893) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Update error type to SUPPORT_IS_DISABLED when expression is used for dictionaries where its not supported. [#72897](https://github.com/ClickHouse/ClickHouse/pull/72897) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* fix race on getDataPartStorage().getFullPath(). [#72940](https://github.com/ClickHouse/ClickHouse/pull/72940) ([Sema Checherinda](https://github.com/CheSema)).
* Remove needless code duplication between `arrayROCAUC` and `arrrayAUCPR`. [#72950](https://github.com/ClickHouse/ClickHouse/pull/72950) ([Emmanuel](https://github.com/emmanuelsdias)).
* Add missing `.cargo/config.toml` to use vendored deps in `chcache`. [#72988](https://github.com/ClickHouse/ClickHouse/pull/72988) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Remove parallel_replicas_single_task_marks_count_multiplier. [#73014](https://github.com/ClickHouse/ClickHouse/pull/73014) ([Igor Nikonov](https://github.com/devcrafter)).
* ci: use tmpfs for temporary ClickHouse files. [#73097](https://github.com/ClickHouse/ClickHouse/pull/73097) ([Azat Khuzhin](https://github.com/azat)).
* Fix the flaky test in `test_replicated_merge_tree_s3_zero_copy/test.py::test_drop_table` by reducing the loop count and backoff period to avoid exceeding the client timeout. [#73102](https://github.com/ClickHouse/ClickHouse/pull/73102) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Build with -Wvla-cxx-extension. [#73119](https://github.com/ClickHouse/ClickHouse/pull/73119) ([Nikita Taranov](https://github.com/nickitat)).
* Unify identifier resolution result from ARRAY JOIN with nested. [#73144](https://github.com/ClickHouse/ClickHouse/pull/73144) ([Dmitry Novik](https://github.com/novikd)).
* Fix an issue when the log files aren't added to the failed groups. [#73145](https://github.com/ClickHouse/ClickHouse/pull/73145) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix flaky test: test_recover_after_bridge. [#73148](https://github.com/ClickHouse/ClickHouse/pull/73148) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Better IAST::format() interface: - `IAST::formatImpl()` is now protected, and `IAST::format()` is called instead. - class `IAST::FormattingBuffer` was added as preparation for https://github.com/ClickHouse/ClickHouse/pull/45649. [#73163](https://github.com/ClickHouse/ClickHouse/pull/73163) ([Vitaly Baranov](https://github.com/vitlibar)).
* Closes [#73143](https://github.com/ClickHouse/ClickHouse/issues/73143). [#73172](https://github.com/ClickHouse/ClickHouse/pull/73172) ([flynn](https://github.com/ucasfl)).
* RMV: fix flaky test_real_wait_refresh. [#73174](https://github.com/ClickHouse/ClickHouse/pull/73174) ([Nikita Fomichev](https://github.com/fm4v)).
* Update version after release. [#73176](https://github.com/ClickHouse/ClickHouse/pull/73176) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix autogenerated_versions.txt. [#73178](https://github.com/ClickHouse/ClickHouse/pull/73178) ([Raúl Marín](https://github.com/Algunenano)).
* Remove unused code. [#73181](https://github.com/ClickHouse/ClickHouse/pull/73181) ([alesapin](https://github.com/alesapin)).
* Fixes https://s3.amazonaws.com/clickhouse-test-reports/0/ca2813bacf22895eed99581069d5a634bf95f3ff/stress_test__ubsan_.html. [#73184](https://github.com/ClickHouse/ClickHouse/pull/73184) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add cancel reason `CANCELLED_BY_ERROR`. [#73187](https://github.com/ClickHouse/ClickHouse/pull/73187) ([Vitaly Baranov](https://github.com/vitlibar)).
* Follow-up for https://github.com/ClickHouse/ClickHouse/pull/71095. [#73196](https://github.com/ClickHouse/ClickHouse/pull/73196) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Minor follow-up to [#72869](https://github.com/ClickHouse/ClickHouse/issues/72869). [#73250](https://github.com/ClickHouse/ClickHouse/pull/73250) ([Robert Schulze](https://github.com/rschu1ze)).
* Mark server setting `use_legacy_mongodb_integration` as obsolete. [#73253](https://github.com/ClickHouse/ClickHouse/pull/73253) ([Robert Schulze](https://github.com/rschu1ze)).
* More accurate parsing for `ALTER USER ... DROP ALL PROFILES/SETTINGS`. [#73257](https://github.com/ClickHouse/ClickHouse/pull/73257) ([pufit](https://github.com/pufit)).
* Updated version check for baseline 24.11. [#73260](https://github.com/ClickHouse/ClickHouse/pull/73260) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Minor. [#73262](https://github.com/ClickHouse/ClickHouse/pull/73262) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix clang-tidy build. [#73265](https://github.com/ClickHouse/ClickHouse/pull/73265) ([Robert Schulze](https://github.com/rschu1ze)).
* Add metric. [#73266](https://github.com/ClickHouse/ClickHouse/pull/73266) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Cleanup. [#73268](https://github.com/ClickHouse/ClickHouse/pull/73268) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix bug in global join without key. [#73269](https://github.com/ClickHouse/ClickHouse/pull/73269) ([Vladimir Cherkasov](https://github.com/vdimir)).
* fix logical error attempt to write after close. [#73277](https://github.com/ClickHouse/ClickHouse/pull/73277) ([Sema Checherinda](https://github.com/CheSema)).
* fix missing finalize call. [#73279](https://github.com/ClickHouse/ClickHouse/pull/73279) ([Sema Checherinda](https://github.com/CheSema)).
* Add a setting. [#73281](https://github.com/ClickHouse/ClickHouse/pull/73281) ([Kseniia Sumarokova](https://github.com/kssenii)).
* More jobs integrated with praktika ci * many improvements and fixes in praktika. [#73291](https://github.com/ClickHouse/ClickHouse/pull/73291) ([Max Kainov](https://github.com/maxknv)).
* CI: Migrate Docs check to praktika. [#73292](https://github.com/ClickHouse/ClickHouse/pull/73292) ([Max Kainov](https://github.com/maxknv)).
* Make MergerMutator more customizable. [#73294](https://github.com/ClickHouse/ClickHouse/pull/73294) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Update README.md. [#73325](https://github.com/ClickHouse/ClickHouse/pull/73325) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update index.md. [#73329](https://github.com/ClickHouse/ClickHouse/pull/73329) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor: Clarify docs of `join_algorithm = default`. [#73332](https://github.com/ClickHouse/ClickHouse/pull/73332) ([Robert Schulze](https://github.com/rschu1ze)).
* Log filename when assert fails in `test_merge_tree_nested_custom_disk_setting`. [#73358](https://github.com/ClickHouse/ClickHouse/pull/73358) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Add column `serialization_hint` to table `system.columns`. [#73365](https://github.com/ClickHouse/ClickHouse/pull/73365) ([Anton Popov](https://github.com/CurtizJ)).
* Remove unused and confusing setting. [#73368](https://github.com/ClickHouse/ClickHouse/pull/73368) ([Raúl Marín](https://github.com/Algunenano)).
* Minor. [#73371](https://github.com/ClickHouse/ClickHouse/pull/73371) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix some of failures from here: https://s3.amazonaws.com/clickhouse-test-reports/0/2c4e63e523636c9e88bf40b64e05a3339bc148fe/libfuzzer_tests.html. [#73372](https://github.com/ClickHouse/ClickHouse/pull/73372) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Make the delimiter as a second argument for `groupConcat`. [#73380](https://github.com/ClickHouse/ClickHouse/pull/73380) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Support scheduled workflows in praktika. [#73381](https://github.com/ClickHouse/ClickHouse/pull/73381) ([Max Kainov](https://github.com/maxknv)).
* Maybe it will fix something, maybe not. Who knows. [#73386](https://github.com/ClickHouse/ClickHouse/pull/73386) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix previous value of `least_greatest_legacy_null_behavior` in SettingsChangesHistory. [#73387](https://github.com/ClickHouse/ClickHouse/pull/73387) ([Robert Schulze](https://github.com/rschu1ze)).
* Evaluate setting `max_limit_for_ann_queries` during optimization pass. [#73393](https://github.com/ClickHouse/ClickHouse/pull/73393) ([Robert Schulze](https://github.com/rschu1ze)).
* Make CHANGELOG.md account for [#73344](https://github.com/ClickHouse/ClickHouse/issues/73344). [#73398](https://github.com/ClickHouse/ClickHouse/pull/73398) ([Robert Schulze](https://github.com/rschu1ze)).
* Add inline documentation for `getMaxTableNameLength` function. [#73402](https://github.com/ClickHouse/ClickHouse/pull/73402) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Enable automatic spilling to disk by default. [#73422](https://github.com/ClickHouse/ClickHouse/pull/73422) ([Mikhail Artemenko](https://github.com/Michicosun)).
* RMV: fix flaky test_query_fail. [#73432](https://github.com/ClickHouse/ClickHouse/pull/73432) ([Nikita Fomichev](https://github.com/fm4v)).
* clickhouse-test: Remove global variables to support 'spawn' fork method in MacOS. [#73440](https://github.com/ClickHouse/ClickHouse/pull/73440) ([Nikita Fomichev](https://github.com/fm4v)).
* CI: Enable autorelease by schedule. [#73442](https://github.com/ClickHouse/ClickHouse/pull/73442) ([Max Kainov](https://github.com/maxknv)).
* Fixing `Unexpected node type for table expression` after https://github.com/ClickHouse/ClickHouse/pull/72856. [#73451](https://github.com/ClickHouse/ClickHouse/pull/73451) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Make QueryPlanSerializationSettings a pImpl. [#73463](https://github.com/ClickHouse/ClickHouse/pull/73463) ([Raúl Marín](https://github.com/Algunenano)).
* Update CHANGELOG.md to account for [#73359](https://github.com/ClickHouse/ClickHouse/issues/73359). [#73490](https://github.com/ClickHouse/ClickHouse/pull/73490) ([Robert Schulze](https://github.com/rschu1ze)).
* Disable ThinLTO for clang-tidy builds. [#73493](https://github.com/ClickHouse/ClickHouse/pull/73493) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix if condition in [#63151](https://github.com/ClickHouse/ClickHouse/issues/63151). [#73504](https://github.com/ClickHouse/ClickHouse/pull/73504) ([Andrey Zvonov](https://github.com/zvonand)).
* RMV tests: fix flaky `test_real_wait_refresh`. [#73505](https://github.com/ClickHouse/ClickHouse/pull/73505) ([Nikita Fomichev](https://github.com/fm4v)).
* add session_token to AWS named collection. [#73506](https://github.com/ClickHouse/ClickHouse/pull/73506) ([Constantine Peresypkin](https://github.com/pkit)).
* Update README.md - Update meetups. [#73508](https://github.com/ClickHouse/ClickHouse/pull/73508) ([Tanya Bragin](https://github.com/tbragin)).
* Less noisy minio in stateless logs. [#73516](https://github.com/ClickHouse/ClickHouse/pull/73516) ([Antonio Andelic](https://github.com/antonio2368)).
* Added some tests with meta-array functions. [#73521](https://github.com/ClickHouse/ClickHouse/pull/73521) ([Max Vostrikov](https://github.com/max-vostrikov)).
* Take amount of filtered into account for query_plan_join_swap_table. [#73534](https://github.com/ClickHouse/ClickHouse/pull/73534) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Minor edit in CHANGELOG.md. [#73536](https://github.com/ClickHouse/ClickHouse/pull/73536) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Follow-up for https://github.com/ClickHouse/ClickHouse/pull/72941. I forgot to remove some files after moving them to another folder. [#73538](https://github.com/ClickHouse/ClickHouse/pull/73538) ([Daniil Ivanik](https://github.com/divanik)).
* Sync Google Cloud config. [#73545](https://github.com/ClickHouse/ClickHouse/pull/73545) ([Pablo Marcos](https://github.com/pamarcos)).
* Update README.md. [#73566](https://github.com/ClickHouse/ClickHouse/pull/73566) ([Tyler Hannan](https://github.com/tylerhannan)).
* Fix possible 'associated promise has been destructed' in TestKeeper. [#73570](https://github.com/ClickHouse/ClickHouse/pull/73570) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Integration tests: add missing port allocation for mongo from port pool. [#73571](https://github.com/ClickHouse/ClickHouse/pull/73571) ([Nikita Fomichev](https://github.com/fm4v)).
* Update README.md. [#73595](https://github.com/ClickHouse/ClickHouse/pull/73595) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update `test_storage_s3_queue/test.py::test_upgrade(2)`. [#73607](https://github.com/ClickHouse/ClickHouse/pull/73607) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Enable parallel replicas CI configuration for stateless tests. [#73609](https://github.com/ClickHouse/ClickHouse/pull/73609) ([Nikita Fomichev](https://github.com/fm4v)).
* CI: Fix parsing GH 'schedule' event in praktika. [#73613](https://github.com/ClickHouse/ClickHouse/pull/73613) ([Max Kainov](https://github.com/maxknv)).
* Update version_date.tsv and changelog after v24.11.2.101-stable. [#73614](https://github.com/ClickHouse/ClickHouse/pull/73614) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fixed index_granularity in 02798_explain_settings_not_applied_bug. [#73615](https://github.com/ClickHouse/ClickHouse/pull/73615) ([Vladimir Cherkasov](https://github.com/vdimir)).
* enable IfExists remove file for BackupWriterS3. [#73617](https://github.com/ClickHouse/ClickHouse/pull/73617) ([Han Fei](https://github.com/hanfei1991)).
* Fix test_storage_s3_queue/test.py::test_alter_settings. [#73632](https://github.com/ClickHouse/ClickHouse/pull/73632) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Sync some tests. [#73636](https://github.com/ClickHouse/ClickHouse/pull/73636) ([Raúl Marín](https://github.com/Algunenano)).
* Speed up binary_tidy: 37min -> 8min. [#73647](https://github.com/ClickHouse/ClickHouse/pull/73647) ([Pablo Marcos](https://github.com/pamarcos)).
* Update version_date.tsv and changelog after v24.12.1.1614-stable. [#73649](https://github.com/ClickHouse/ClickHouse/pull/73649) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Fix build packaging script. [#73652](https://github.com/ClickHouse/ClickHouse/pull/73652) ([Max Kainov](https://github.com/maxknv)).
* Increase the length of the random suffix of the temporary table from 4 to 16 when creating tables. Closes [#70319](https://github.com/ClickHouse/ClickHouse/issues/70319). [#73655](https://github.com/ClickHouse/ClickHouse/pull/73655) ([Tuan Pham Anh](https://github.com/tuanpach)).
* CI: ClickBench Job with praktika. [#73688](https://github.com/ClickHouse/ClickHouse/pull/73688) ([Max Kainov](https://github.com/maxknv)).
* Refactor query engine settings. [#73693](https://github.com/ClickHouse/ClickHouse/pull/73693) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Docker build job with praktika. [#73698](https://github.com/ClickHouse/ClickHouse/pull/73698) ([Max Kainov](https://github.com/maxknv)).
* Followup for https://github.com/ClickHouse/ClickHouse/pull/73629 Fix for the case when first cal to waitForAllToFinishAndRethrowFirstError throws exception from some task, and the next call see tasks with invalid futures - those that for which .get() was already called. [#73699](https://github.com/ClickHouse/ClickHouse/pull/73699) ([Alexander Gololobov](https://github.com/davenger)).
* Re-enable CheckInternalHash in htmltest and fail on new errors. [#73705](https://github.com/ClickHouse/ClickHouse/pull/73705) ([Damian Maślanka](https://github.com/DamianMaslanka5)).
* Replace boost/tti dependency with c++20 concepts. [#73708](https://github.com/ClickHouse/ClickHouse/pull/73708) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Corrections after reworking backup/restore synchronization #4. [#73715](https://github.com/ClickHouse/ClickHouse/pull/73715) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix compilation with `clang20`. [#73719](https://github.com/ClickHouse/ClickHouse/pull/73719) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix default hostname in `chcache` configuration. [#73727](https://github.com/ClickHouse/ClickHouse/pull/73727) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix huge initializer_list in SettingsChangesHistory. [#73728](https://github.com/ClickHouse/ClickHouse/pull/73728) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Reverts ClickHouse/ClickHouse[#62944](https://github.com/ClickHouse/ClickHouse/issues/62944) (there was a crash in the CI because of this). [#73738](https://github.com/ClickHouse/ClickHouse/pull/73738) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Better error message when applying row policy. [#73739](https://github.com/ClickHouse/ClickHouse/pull/73739) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Revert [#72490](https://github.com/ClickHouse/ClickHouse/issues/72490) because the new `MergeTreeIndexGranularityInternalArraysTotalSize` metric is incorrect. [#73740](https://github.com/ClickHouse/ClickHouse/pull/73740) ([Alexander Tokmakov](https://github.com/tavplubix)).
* `chcache`: fix disabled build path mapping. [#73756](https://github.com/ClickHouse/ClickHouse/pull/73756) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix thread count assumption in CI. [#73773](https://github.com/ClickHouse/ClickHouse/pull/73773) ([Guo Wangyang](https://github.com/guowangy)).
* Update version_date.tsv and changelog after v24.8.9.95-lts. [#73782](https://github.com/ClickHouse/ClickHouse/pull/73782) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update CHANGELOG.md to account for [#72644](https://github.com/ClickHouse/ClickHouse/issues/72644). [#73785](https://github.com/ClickHouse/ClickHouse/pull/73785) ([Pavel Kruglov](https://github.com/Avogar)).
* Try to avoid timeouts in test 03207_json_read_subcolumns_2_compact_merge_tree. [#73786](https://github.com/ClickHouse/ClickHouse/pull/73786) ([Pavel Kruglov](https://github.com/Avogar)).
* Forbid to create tables as `*Cluster`. [#73804](https://github.com/ClickHouse/ClickHouse/pull/73804) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Part of https://github.com/ClickHouse/ClickHouse/pull/69652. Adds serialization of the QueryPlan and Sets. [#73811](https://github.com/ClickHouse/ClickHouse/pull/73811) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add span for handling Parallel Replicas packet. [#73813](https://github.com/ClickHouse/ClickHouse/pull/73813) ([Nikita Taranov](https://github.com/nickitat)).
* A step towards the deprecation of window views. [#73822](https://github.com/ClickHouse/ClickHouse/pull/73822) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Cleanup trusted contributors. [#73824](https://github.com/ClickHouse/ClickHouse/pull/73824) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better check for changelog categories. [#73825](https://github.com/ClickHouse/ClickHouse/pull/73825) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove tests for MaterializedMySQL. [#73828](https://github.com/ClickHouse/ClickHouse/pull/73828) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Miscellaneous. [#73830](https://github.com/ClickHouse/ClickHouse/pull/73830) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This closes [#73522](https://github.com/ClickHouse/ClickHouse/issues/73522). [#73837](https://github.com/ClickHouse/ClickHouse/pull/73837) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make logs more accurate. [#73842](https://github.com/ClickHouse/ClickHouse/pull/73842) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad code in `CancellationChecker`. [#73843](https://github.com/ClickHouse/ClickHouse/pull/73843) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better comments for system logs. [#73844](https://github.com/ClickHouse/ClickHouse/pull/73844) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This closes [#49244](https://github.com/ClickHouse/ClickHouse/issues/49244). [#73846](https://github.com/ClickHouse/ClickHouse/pull/73846) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad test `detach_attach_partition`. [#73863](https://github.com/ClickHouse/ClickHouse/pull/73863) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better checks for timeouts in `test_cancel_backup.py`. This PR fixes [#73167](https://github.com/ClickHouse/ClickHouse/issues/73167). [#73865](https://github.com/ClickHouse/ClickHouse/pull/73865) ([Vitaly Baranov](https://github.com/vitlibar)).
* Replaces flaky stateless test `01606_git_import.sh` with a more reliable test for the `clickhouse-git-import` utility. This PR fixes [#73280](https://github.com/ClickHouse/ClickHouse/issues/73280). [#73866](https://github.com/ClickHouse/ClickHouse/pull/73866) ([Vitaly Baranov](https://github.com/vitlibar)).
* Better progress table. [#73867](https://github.com/ClickHouse/ClickHouse/pull/73867) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad test `mutations_isolation`. [#73869](https://github.com/ClickHouse/ClickHouse/pull/73869) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove an obsolete format setting. [#73874](https://github.com/ClickHouse/ClickHouse/pull/73874) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Revert [#70957](https://github.com/ClickHouse/ClickHouse/issues/70957). [#73875](https://github.com/ClickHouse/ClickHouse/pull/73875) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad test about parallel replicas. [#73877](https://github.com/ClickHouse/ClickHouse/pull/73877) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* RMV: remove flaky test_real_wait_refresh. [#73881](https://github.com/ClickHouse/ClickHouse/pull/73881) ([Nikita Fomichev](https://github.com/fm4v)).
* Remove ru changelogs. [#73882](https://github.com/ClickHouse/ClickHouse/pull/73882) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Docs: fix `min_block_number` and `max_block_number`. [#73886](https://github.com/ClickHouse/ClickHouse/pull/73886) ([jesse-triplewhale](https://github.com/jesse-triplewhale)).
* send logs and InsertProfileEvents for each block even for async insert. [#73915](https://github.com/ClickHouse/ClickHouse/pull/73915) ([Sema Checherinda](https://github.com/CheSema)).
* Fix mutations counter in non-replicated `MergeTree`. [#73926](https://github.com/ClickHouse/ClickHouse/pull/73926) ([Anton Popov](https://github.com/CurtizJ)).
* Use minimum of memory limits for external aggregation/sort. [#73933](https://github.com/ClickHouse/ClickHouse/pull/73933) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Minor: Sightly more consise log messages (follow-up to [#62452](https://github.com/ClickHouse/ClickHouse/issues/62452)). [#73951](https://github.com/ClickHouse/ClickHouse/pull/73951) ([Robert Schulze](https://github.com/rschu1ze)).
* Remove obsolete `expected` submodule. [#73952](https://github.com/ClickHouse/ClickHouse/pull/73952) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix build after [#73324](https://github.com/ClickHouse/ClickHouse/issues/73324). [#73953](https://github.com/ClickHouse/ClickHouse/pull/73953) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix the Kafka test. [#73955](https://github.com/ClickHouse/ClickHouse/pull/73955) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Experiment: Enable SLP vectorizer for faster codegen. [#73957](https://github.com/ClickHouse/ClickHouse/pull/73957) ([Robert Schulze](https://github.com/rschu1ze)).
* Bump nanodbc. [#73960](https://github.com/ClickHouse/ClickHouse/pull/73960) ([Robert Schulze](https://github.com/rschu1ze)).
* Update error message about JSON type. [#73975](https://github.com/ClickHouse/ClickHouse/pull/73975) ([Pavel Kruglov](https://github.com/Avogar)).
* make the `test_grpc_protocol` integration test sequential. [#73977](https://github.com/ClickHouse/ClickHouse/pull/73977) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Fix assert asof_conditions.size() == 1. [#73979](https://github.com/ClickHouse/ClickHouse/pull/73979) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Refactor BackupKeeperSettings. [#73984](https://github.com/ClickHouse/ClickHouse/pull/73984) ([Robert Schulze](https://github.com/rschu1ze)).
* Add a test with JOIN filter push down after merge_filters optimization. [#73988](https://github.com/ClickHouse/ClickHouse/pull/73988) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* In-source docs: `categories` --> `category`. [#73989](https://github.com/ClickHouse/ClickHouse/pull/73989) ([Robert Schulze](https://github.com/rschu1ze)).
* fix client when local format error. [#73995](https://github.com/ClickHouse/ClickHouse/pull/73995) ([Sema Checherinda](https://github.com/CheSema)).
* Fix test `01099_parallel_distributed_insert_select`. [#73998](https://github.com/ClickHouse/ClickHouse/pull/73998) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Unify pretty formats. [#74003](https://github.com/ClickHouse/ClickHouse/pull/74003) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update version_date.tsv and changelog after v24.12.2.29-stable. [#74008](https://github.com/ClickHouse/ClickHouse/pull/74008) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix a typo. [#74010](https://github.com/ClickHouse/ClickHouse/pull/74010) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update version_date.tsv and changelog after v24.8.10.5-lts. [#74011](https://github.com/ClickHouse/ClickHouse/pull/74011) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* ci: increase threshold for the functional tests log. [#74047](https://github.com/ClickHouse/ClickHouse/pull/74047) ([Azat Khuzhin](https://github.com/azat)).
* Minor: remove experimental flag from `use_hive_partitioning` setting. [#74065](https://github.com/ClickHouse/ClickHouse/pull/74065) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Support chinese zodiac when exit the client. [#74068](https://github.com/ClickHouse/ClickHouse/pull/74068) ([Kai Zhu](https://github.com/nauu)).
* Fix `Bad cast` error for distributed explain. [#74071](https://github.com/ClickHouse/ClickHouse/pull/74071) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Update version_date.tsv and changelog after v24.8.11.5-lts. [#74074](https://github.com/ClickHouse/ClickHouse/pull/74074) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Improve the waiting mechanism for keeper in integration tests. [#74076](https://github.com/ClickHouse/ClickHouse/pull/74076) ([Azat Khuzhin](https://github.com/azat)).
* Add log entry for header detection (since it consume rows). [#74078](https://github.com/ClickHouse/ClickHouse/pull/74078) ([Azat Khuzhin](https://github.com/azat)).
* CI: Use temp directory inside repo dir in praktika ci. [#74081](https://github.com/ClickHouse/ClickHouse/pull/74081) ([Max Kainov](https://github.com/maxknv)).
* Add trace to QueryMetricLog to help identifying issues. [#74086](https://github.com/ClickHouse/ClickHouse/pull/74086) ([Pablo Marcos](https://github.com/pamarcos)).
* Move min_external_sort_block_bytes into 25.1 in settings changes. [#74101](https://github.com/ClickHouse/ClickHouse/pull/74101) ([Azat Khuzhin](https://github.com/azat)).
* ci: fix ClickBench link in CI comment. [#74112](https://github.com/ClickHouse/ClickHouse/pull/74112) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 02350_views_max_insert_threads. [#74113](https://github.com/ClickHouse/ClickHouse/pull/74113) ([Azat Khuzhin](https://github.com/azat)).
* Minor follow-up for [#73647](https://github.com/ClickHouse/ClickHouse/issues/73647). [#74114](https://github.com/ClickHouse/ClickHouse/pull/74114) ([Robert Schulze](https://github.com/rschu1ze)).
* I didn't understand this code and it has no comments in StorageMerge. [#74117](https://github.com/ClickHouse/ClickHouse/pull/74117) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add `endpoint_subpath` parameter to Azure endpoint configuration. [#74118](https://github.com/ClickHouse/ClickHouse/pull/74118) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix data race for updating ZooKeeper client on DROP in ReplicatedMergeTree. [#74124](https://github.com/ClickHouse/ClickHouse/pull/74124) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky `03291_json_big_structure_deserialization`. [#74125](https://github.com/ClickHouse/ClickHouse/pull/74125) ([Nikita Taranov](https://github.com/nickitat)).
* Configure clangd to always use angled brackets. [#74166](https://github.com/ClickHouse/ClickHouse/pull/74166) ([Azat Khuzhin](https://github.com/azat)).
* ci: fix skipping of some integration tests. [#74169](https://github.com/ClickHouse/ClickHouse/pull/74169) ([Azat Khuzhin](https://github.com/azat)).
* Fix keeper shutdown in case of initialization failed. [#74187](https://github.com/ClickHouse/ClickHouse/pull/74187) ([Azat Khuzhin](https://github.com/azat)).
* Update links to clickhouse-presentations (after naming schema changes). [#74189](https://github.com/ClickHouse/ClickHouse/pull/74189) ([Robert Schulze](https://github.com/rschu1ze)).
* tests: fix test_keeper_disks/test.py::test_logs_with_disks flakiness. [#74197](https://github.com/ClickHouse/ClickHouse/pull/74197) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 01107_atomic_db_detach_attach flakiness. [#74198](https://github.com/ClickHouse/ClickHouse/pull/74198) ([Azat Khuzhin](https://github.com/azat)).
* Fix error in the error message about timeout. [#74203](https://github.com/ClickHouse/ClickHouse/pull/74203) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bug in unreleased changes. [#74205](https://github.com/ClickHouse/ClickHouse/pull/74205) ([李扬](https://github.com/taiyang-li)).
* tests: fix 00626_replace_partition_from_table flakiness. [#74209](https://github.com/ClickHouse/ClickHouse/pull/74209) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible segfault in CollapsingMergeTree when `optimize_on_insert = 0`. [#74223](https://github.com/ClickHouse/ClickHouse/pull/74223) ([Christoph Wurm](https://github.com/cwurm)).
* With this patch you can set handler.user to some existing user for remote_read handler and client will not need to provide authentication. [#74225](https://github.com/ClickHouse/ClickHouse/pull/74225) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix flakiness of 01700_deltasum (due to allow_not_comparable_types_in_order_by). [#74240](https://github.com/ClickHouse/ClickHouse/pull/74240) ([Azat Khuzhin](https://github.com/azat)).
* Fix race in Keeper Changelog. [#74252](https://github.com/ClickHouse/ClickHouse/pull/74252) ([Antonio Andelic](https://github.com/antonio2368)).
* refine dashboard SQLs. [#74256](https://github.com/ClickHouse/ClickHouse/pull/74256) ([Han Fei](https://github.com/hanfei1991)).
* Try fixing `test_memory_limit`. [#74258](https://github.com/ClickHouse/ClickHouse/pull/74258) ([Antonio Andelic](https://github.com/antonio2368)).
* Remove obsolete class member. [#74259](https://github.com/ClickHouse/ClickHouse/pull/74259) ([Raúl Marín](https://github.com/Algunenano)).
* Minor: convert test from .sh to .sql. [#74261](https://github.com/ClickHouse/ClickHouse/pull/74261) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix lifetime of callback in `threadPoolCallbackRunner`. [#74267](https://github.com/ClickHouse/ClickHouse/pull/74267) ([Anton Popov](https://github.com/CurtizJ)).
* bump node version to 20 for docs. [#74268](https://github.com/ClickHouse/ClickHouse/pull/74268) ([Dale McDiarmid](https://github.com/gingerwizard)).
* CI: SQLancer and InstallCheck job with praktika. [#74270](https://github.com/ClickHouse/ClickHouse/pull/74270) ([Max Kainov](https://github.com/maxknv)).
* Remove unused method `isStoredOnDisk`. [#74271](https://github.com/ClickHouse/ClickHouse/pull/74271) ([Anton Popov](https://github.com/CurtizJ)).
* Fix CREATE DATABASE with SETTINGS. [#74274](https://github.com/ClickHouse/ClickHouse/pull/74274) ([Raúl Marín](https://github.com/Algunenano)).
* CI: SQLTest in praktika CI. [#74290](https://github.com/ClickHouse/ClickHouse/pull/74290) ([Max Kainov](https://github.com/maxknv)).
* CI: Remove hdfs from Integration tests. [#74295](https://github.com/ClickHouse/ClickHouse/pull/74295) ([Max Kainov](https://github.com/maxknv)).
* use class for temporary replace table name. [#74313](https://github.com/ClickHouse/ClickHouse/pull/74313) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Sync more settings. [#74321](https://github.com/ClickHouse/ClickHouse/pull/74321) ([Raúl Marín](https://github.com/Algunenano)).
* Add WRS A-ES Algorithm to Common. [#74325](https://github.com/ClickHouse/ClickHouse/pull/74325) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix `UnicodeDecodeError` in `cluster.shutdown()`. [#74334](https://github.com/ClickHouse/ClickHouse/pull/74334) ([Vitaly Baranov](https://github.com/vitlibar)).
* chcache: add support for configurable source and target tables. [#74351](https://github.com/ClickHouse/ClickHouse/pull/74351) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Enable writing the NO_REPLICA_HAS_PART exception in the system.replication_queue for merge/mutate tasks. [#74359](https://github.com/ClickHouse/ClickHouse/pull/74359) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* tests: fix test_store_cleanup flakiness. [#74371](https://github.com/ClickHouse/ClickHouse/pull/74371) ([Azat Khuzhin](https://github.com/azat)).
* Fix "Failed to make request to X redirect to X" log message. [#74373](https://github.com/ClickHouse/ClickHouse/pull/74373) ([Azat Khuzhin](https://github.com/azat)).
* CI: Support for preliminary pipeline checks in praktika. [#74394](https://github.com/ClickHouse/ClickHouse/pull/74394) ([Max Kainov](https://github.com/maxknv)).
* Add address to socket errors. [#74395](https://github.com/ClickHouse/ClickHouse/pull/74395) ([Azat Khuzhin](https://github.com/azat)).
* Update README.md. [#74396](https://github.com/ClickHouse/ClickHouse/pull/74396) ([Tyler Hannan](https://github.com/tylerhannan)).
* Use `datetime.now` instead of `utcnow`. [#74397](https://github.com/ClickHouse/ClickHouse/pull/74397) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Make `version_helper` populated from every commit. [#74399](https://github.com/ClickHouse/ClickHouse/pull/74399) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Avoid special PR packet processing if PR is disabled. [#74402](https://github.com/ClickHouse/ClickHouse/pull/74402) ([Igor Nikonov](https://github.com/devcrafter)).
* remove existing broken hashes from docs_check (htmltest). [#74407](https://github.com/ClickHouse/ClickHouse/pull/74407) ([Shaun Struwig](https://github.com/Blargian)).
* Unflake `test_non_default_compression`. [#74409](https://github.com/ClickHouse/ClickHouse/pull/74409) ([Robert Schulze](https://github.com/rschu1ze)).
* change `system.replicas.readonly_duration` type from `DateTime` to `UInt64`. [#74444](https://github.com/ClickHouse/ClickHouse/pull/74444) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Clickhouse-test: sleep between checks in parallel runs. [#74449](https://github.com/ClickHouse/ClickHouse/pull/74449) ([Raúl Marín](https://github.com/Algunenano)).
* Remove IPartMetadataManager. [#74455](https://github.com/ClickHouse/ClickHouse/pull/74455) ([Raúl Marín](https://github.com/Algunenano)).
* Fix calculation of metrics `BackupsThreadsActive` and `RestoreThreadsActive`. Those metrics were not updated before this PR. [#74456](https://github.com/ClickHouse/ClickHouse/pull/74456) ([Vitaly Baranov](https://github.com/vitlibar)).
* Disable SSH server (unreleased). [#74473](https://github.com/ClickHouse/ClickHouse/pull/74473) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove `LRUHashMap` - doesn't seem to be used anywhere. [#74494](https://github.com/ClickHouse/ClickHouse/pull/74494) ([Nikita Taranov](https://github.com/nickitat)).
* Fix typo in validate_enum_literals_in_operators. [#74505](https://github.com/ClickHouse/ClickHouse/pull/74505) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix a bug introduced in [#74407](https://github.com/ClickHouse/ClickHouse/issues/74407). [#74535](https://github.com/ClickHouse/ClickHouse/pull/74535) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* The last reference of `contrib/expected` is removed from the codebase. It seems not needed after: https://github.com/ClickHouse/ClickHouse/pull/73952. [#74540](https://github.com/ClickHouse/ClickHouse/pull/74540) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Parallel replicas tests: rollback parallel replicas config for stateful tests. [#74545](https://github.com/ClickHouse/ClickHouse/pull/74545) ([Nikita Fomichev](https://github.com/fm4v)).
* Misc changes to the changelog. [#74550](https://github.com/ClickHouse/ClickHouse/pull/74550) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix binary_build job in master. [#74552](https://github.com/ClickHouse/ClickHouse/pull/74552) ([Pablo Marcos](https://github.com/pamarcos)).
* Update version_date.tsv and changelog after v24.12.3.47-stable. [#74553](https://github.com/ClickHouse/ClickHouse/pull/74553) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix sync settings. [#74555](https://github.com/ClickHouse/ClickHouse/pull/74555) ([Raúl Marín](https://github.com/Algunenano)).
* Update version_date.tsv and changelog after v24.10.4.191-stable. [#74556](https://github.com/ClickHouse/ClickHouse/pull/74556) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* prep for local and yarn install for docs. [#74557](https://github.com/ClickHouse/ClickHouse/pull/74557) ([Dale McDiarmid](https://github.com/gingerwizard)).
* Update version_date.tsv and changelog after v24.11.3.66-stable. [#74562](https://github.com/ClickHouse/ClickHouse/pull/74562) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Parallel replicas tests: unify configuration for stateful and stateless tests. [#74565](https://github.com/ClickHouse/ClickHouse/pull/74565) ([Nikita Fomichev](https://github.com/fm4v)).
* CI: Support generating dispatched workflow by praktika. [#74573](https://github.com/ClickHouse/ClickHouse/pull/74573) ([Max Kainov](https://github.com/maxknv)).
* Continuation of https://github.com/ClickHouse/ClickHouse/pull/74569. [#74575](https://github.com/ClickHouse/ClickHouse/pull/74575) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix for real the binary_tidy build in master. [#74579](https://github.com/ClickHouse/ClickHouse/pull/74579) ([Pablo Marcos](https://github.com/pamarcos)).
* Update version_date.tsv and changelog after v24.3.15.72-lts. [#74580](https://github.com/ClickHouse/ClickHouse/pull/74580) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v24.8.12.28-lts. [#74581](https://github.com/ClickHouse/ClickHouse/pull/74581) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Set docs check job status to fail when htmltest fails. [#74582](https://github.com/ClickHouse/ClickHouse/pull/74582) ([Damian Maślanka](https://github.com/DamianMaslanka5)).
* Unflake `02354_vector_search_multiple_marks`. [#74584](https://github.com/ClickHouse/ClickHouse/pull/74584) ([Robert Schulze](https://github.com/rschu1ze)).
* Follow-up to [#73965](https://github.com/ClickHouse/ClickHouse/issues/73965). [#74589](https://github.com/ClickHouse/ClickHouse/pull/74589) ([lgbo](https://github.com/lgbo-ustc)).
* Disable merge-commit in PR template. [#74598](https://github.com/ClickHouse/ClickHouse/pull/74598) ([Pablo Marcos](https://github.com/pamarcos)).
* It looks a little bit ugly... [#74608](https://github.com/ClickHouse/ClickHouse/pull/74608) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Increase spectre width for trace-visualizer. [#74609](https://github.com/ClickHouse/ClickHouse/pull/74609) ([Nikita Taranov](https://github.com/nickitat)).
* Fix `00183_prewhere_conditions_order` with parallel replicas. [#74619](https://github.com/ClickHouse/ClickHouse/pull/74619) ([Nikita Taranov](https://github.com/nickitat)).
* `chcache`: limit upload attempts. [#74625](https://github.com/ClickHouse/ClickHouse/pull/74625) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* `chcache`: exclude build directory from hashes. [#74626](https://github.com/ClickHouse/ClickHouse/pull/74626) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix fuzzer issue [#74627](https://github.com/ClickHouse/ClickHouse/issues/74627). [#74631](https://github.com/ClickHouse/ClickHouse/pull/74631) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Refine PR template. [#74636](https://github.com/ClickHouse/ClickHouse/pull/74636) ([Max Kainov](https://github.com/maxknv)).
* Destroy remote reader in FileSegment. [#74662](https://github.com/ClickHouse/ClickHouse/pull/74662) ([Antonio Andelic](https://github.com/antonio2368)).
* Check tidy results asap. [#74665](https://github.com/ClickHouse/ClickHouse/pull/74665) ([Max Kainov](https://github.com/maxknv)).
* A follow-up for [#74399](https://github.com/ClickHouse/ClickHouse/issues/74399), send the event as early as possible. [#74666](https://github.com/ClickHouse/ClickHouse/pull/74666) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Review compatibility settings for 24.12 release. [#74670](https://github.com/ClickHouse/ClickHouse/pull/74670) ([Nikita Fomichev](https://github.com/fm4v)).
* Parallel replicas tests: fix flaky 02884_create_view_with_sql_security_option. [#74674](https://github.com/ClickHouse/ClickHouse/pull/74674) ([Nikita Fomichev](https://github.com/fm4v)).
* Revert GDB dump threads in cluster.py. [#74697](https://github.com/ClickHouse/ClickHouse/pull/74697) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Allow to alter settings `list_objects_batch_size` and `enable_hash_ring_filtering`. [#74706](https://github.com/ClickHouse/ClickHouse/pull/74706) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Set Integration test flaky as required to move it to Tests_1. [#74710](https://github.com/ClickHouse/ClickHouse/pull/74710) ([Pablo Marcos](https://github.com/pamarcos)).
* s3queue: fix assert in tests. [#74715](https://github.com/ClickHouse/ClickHouse/pull/74715) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CI: Less ambiguity in PR template. [#74717](https://github.com/ClickHouse/ClickHouse/pull/74717) ([Robert Schulze](https://github.com/rschu1ze)).
* Optimize some Field.h dependencies. [#74727](https://github.com/ClickHouse/ClickHouse/pull/74727) ([Raúl Marín](https://github.com/Algunenano)).
* When an ephemeral lock is to be created and znode_data is specified - an ephemeral node will be created with that data. [#74731](https://github.com/ClickHouse/ClickHouse/pull/74731) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Parallel replicas tests: add vector search tests to blacklist. [#74752](https://github.com/ClickHouse/ClickHouse/pull/74752) ([Nikita Fomichev](https://github.com/fm4v)).
* CI: Enable CI DB with praktika. [#74760](https://github.com/ClickHouse/ClickHouse/pull/74760) ([Max Kainov](https://github.com/maxknv)).
* tests: fix test_system_metrics::test_broken_tables_readonly_metric flakiness. [#74773](https://github.com/ClickHouse/ClickHouse/pull/74773) ([Azat Khuzhin](https://github.com/azat)).
* CI: Optimize praktika report for quick navigation. [#74777](https://github.com/ClickHouse/ClickHouse/pull/74777) ([Max Kainov](https://github.com/maxknv)).
* Update README.md. [#74781](https://github.com/ClickHouse/ClickHouse/pull/74781) ([Robert Schulze](https://github.com/rschu1ze)).
* A clearer description of the `woolen_wolfdog` toggle. [#74783](https://github.com/ClickHouse/ClickHouse/pull/74783) ([Nikita Taranov](https://github.com/nickitat)).
* Remove useless code in backup. [#74790](https://github.com/ClickHouse/ClickHouse/pull/74790) ([Han Fei](https://github.com/hanfei1991)).
* This closes: [#73520](https://github.com/ClickHouse/ClickHouse/issues/73520). [#74793](https://github.com/ClickHouse/ClickHouse/pull/74793) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* This closes: [#72208](https://github.com/ClickHouse/ClickHouse/issues/72208). [#74797](https://github.com/ClickHouse/ClickHouse/pull/74797) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* s3queue: fix code check. [#74800](https://github.com/ClickHouse/ClickHouse/pull/74800) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add assert in ~KeeperTCPHandler. [#74811](https://github.com/ClickHouse/ClickHouse/pull/74811) ([Nikita Taranov](https://github.com/nickitat)).
* Add needed includes and files to use Azure's key vault. [#74812](https://github.com/ClickHouse/ClickHouse/pull/74812) ([Pablo Marcos](https://github.com/pamarcos)).
* Parallel replica tests: Disable test 03080_incorrect_join_with_merge, which is causing a segfault. [#74824](https://github.com/ClickHouse/ClickHouse/pull/74824) ([Nikita Fomichev](https://github.com/fm4v)).
* The issue doesn't reproduce anymore. This closes: [#70155](https://github.com/ClickHouse/ClickHouse/issues/70155). [#74825](https://github.com/ClickHouse/ClickHouse/pull/74825) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Failure is a success. [#74832](https://github.com/ClickHouse/ClickHouse/pull/74832) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Refine the logical error message in BackImpl.cpp. [#74856](https://github.com/ClickHouse/ClickHouse/pull/74856) ([Han Fei](https://github.com/hanfei1991)).
* Fix strange error message when missing columns. [#74875](https://github.com/ClickHouse/ClickHouse/pull/74875) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix finishing after failure in `BACKUP/RESTORE ON CLUSTER`. [#74885](https://github.com/ClickHouse/ClickHouse/pull/74885) ([Vitaly Baranov](https://github.com/vitlibar)).
* CI: Support on-push workflow in praktika CI. [#74907](https://github.com/ClickHouse/ClickHouse/pull/74907) ([Max Kainov](https://github.com/maxknv)).
* Run StyleCheck and FastTest in parallel. [#74916](https://github.com/ClickHouse/ClickHouse/pull/74916) ([Pablo Marcos](https://github.com/pamarcos)).
* Add debug info to test. [#74939](https://github.com/ClickHouse/ClickHouse/pull/74939) ([Kseniia Sumarokova](https://github.com/kssenii)).
* test for [#74893](https://github.com/ClickHouse/ClickHouse/issues/74893). [#74940](https://github.com/ClickHouse/ClickHouse/pull/74940) ([Denny [DBA at Innervate]](https://github.com/den-crane)).
* Backported in [#75025](https://github.com/ClickHouse/ClickHouse/issues/75025): Closes [#74357](https://github.com/ClickHouse/ClickHouse/issues/74357). [#74948](https://github.com/ClickHouse/ClickHouse/pull/74948) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix fuzzing failure in `AggregateFunctionCombinatorResample`. [#74966](https://github.com/ClickHouse/ClickHouse/pull/74966) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Move tidy build back to Builds_2: Having Tidy build in Builds_0 or Builds_1 blocks Tests stages on build failure - Make all builds stages starting in parallel to not wait too long for tidy results. [#74967](https://github.com/ClickHouse/ClickHouse/pull/74967) ([Max Kainov](https://github.com/maxknv)).
* Decouple shared part from [#74605](https://github.com/ClickHouse/ClickHouse/issues/74605). [#74971](https://github.com/ClickHouse/ClickHouse/pull/74971) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add filter for spans in utils/trace-visualizer. [#74983](https://github.com/ClickHouse/ClickHouse/pull/74983) ([Sergei Trifonov](https://github.com/serxa)).
* Minor changes to Web UI. [#74990](https://github.com/ClickHouse/ClickHouse/pull/74990) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#75111](https://github.com/ClickHouse/ClickHouse/issues/75111): Rename setting `bg_reconnect_mysql_dict_interval` to `dictionary_background_reconnect_interval`. [#75013](https://github.com/ClickHouse/ClickHouse/pull/75013) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#75108](https://github.com/ClickHouse/ClickHouse/issues/75108): Add a description for `skip_redundant_aliases_in_udf` setting. [#75014](https://github.com/ClickHouse/ClickHouse/pull/75014) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#75042](https://github.com/ClickHouse/ClickHouse/issues/75042): Small usability improvements for Sasha. [#75022](https://github.com/ClickHouse/ClickHouse/pull/75022) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

