---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v24.11.3.66-stable (01b8a197a87) FIXME as compared to v24.11.2.101-stable (3cc965d6095)

#### New Feature
* Backported in [#74318](https://github.com/ClickHouse/ClickHouse/issues/74318): When `min_age_to_force_merge_seconds` and `min_age_to_force_merge_on_partition_only` are both enabled, the part merging will ignore the max bytes limit. [#73656](https://github.com/ClickHouse/ClickHouse/pull/73656) ([Kai Zhu](https://github.com/nauu)).

#### Improvement
* Backported in [#73907](https://github.com/ClickHouse/ClickHouse/issues/73907): Add the `latest_fail_error_code_name` column to `system.mutations`. We need this column to introduce a new metric on stuck mutations and use it to build graphs of the errors encountered in the cloud as well as, optionally, adding a new less-noisy alert. [#72398](https://github.com/ClickHouse/ClickHouse/pull/72398) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#73071](https://github.com/ClickHouse/ClickHouse/issues/73071): Implement creating tables in parallel while restoring from a backup. Before this PR the `RESTORE` command always created tables in one thread, which could be slow in case of backups containing many tables. [#72427](https://github.com/ClickHouse/ClickHouse/pull/72427) ([Vitaly Baranov](https://github.com/vitlibar)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#74158](https://github.com/ClickHouse/ClickHouse/issues/74158): Avoid pause after `ALTER TABLE REPLACE/MOVE PARTITION FROM/TO TABLE`. Retrieve correct settings for background task scheduling. [#72024](https://github.com/ClickHouse/ClickHouse/pull/72024) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Backported in [#73320](https://github.com/ClickHouse/ClickHouse/issues/73320): Fix the situation when a user can't run `REVOKE ALL ON *.*` because of implicit grants in the target access entity. [#72872](https://github.com/ClickHouse/ClickHouse/pull/72872) ([pufit](https://github.com/pufit)).
* Backported in [#74142](https://github.com/ClickHouse/ClickHouse/issues/74142): Propagate format settings to NativeWriter in TCPHandler, so settings like `output_format_native_write_json_as_string` are applied correctly. [#73179](https://github.com/ClickHouse/ClickHouse/pull/73179) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73893](https://github.com/ClickHouse/ClickHouse/issues/73893): Fix preparing for squashin for Dynamic and JSON columns. Previously in some cases new types could be inserted into shared variant/shared data even when the limit on types/paths is not reached. [#73388](https://github.com/ClickHouse/ClickHouse/pull/73388) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73603](https://github.com/ClickHouse/ClickHouse/issues/73603): Fix ObjectStorageQueue with ZooKeeper and older Keeper. [#73420](https://github.com/ClickHouse/ClickHouse/pull/73420) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#74439](https://github.com/ClickHouse/ClickHouse/issues/74439): Fixes segfault when the source of the dictionary contains a function with wrong data. [#73535](https://github.com/ClickHouse/ClickHouse/pull/73535) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#73626](https://github.com/ClickHouse/ClickHouse/issues/73626): Fixed error in function `tupleElement` which may appear in some cases for tuples with `LowCardinality` elelments and enabled setting `optimize_functions_to_subcolumns`. [#73548](https://github.com/ClickHouse/ClickHouse/pull/73548) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73801](https://github.com/ClickHouse/ClickHouse/issues/73801): Fix parsing enum glob followed by range one. Fixes [#73473](https://github.com/ClickHouse/ClickHouse/issues/73473). [#73569](https://github.com/ClickHouse/ClickHouse/pull/73569) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#73817](https://github.com/ClickHouse/ClickHouse/issues/73817): Fixed parallel_replicas_for_non_replicated_merge_tree being ignored in subqueries for non-replicated tables. [#73584](https://github.com/ClickHouse/ClickHouse/pull/73584) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#73679](https://github.com/ClickHouse/ClickHouse/issues/73679): Do not interpret queries in `EXPLAIN SYNTAX` to avoid logical errors with incorrect processing stage for distributed queries. Fixes [#65205](https://github.com/ClickHouse/ClickHouse/issues/65205). [#73634](https://github.com/ClickHouse/ClickHouse/pull/73634) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#73797](https://github.com/ClickHouse/ClickHouse/issues/73797): Fix possible data inconsistency in Dynamic column. Fixes possible logical error `Nested columns sizes are inconsistent with local_discriminators column size`. [#73644](https://github.com/ClickHouse/ClickHouse/pull/73644) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74379](https://github.com/ClickHouse/ClickHouse/issues/74379): Fixed `NOT_FOUND_COLUMN_IN_BLOCK` in queries with `FINAL` and `SAMPLE`. Fixed incorrect result in selects with `FINAL` from `CollapsingMergeTree` and enabled optimizations of `FINAL` . [#73682](https://github.com/ClickHouse/ClickHouse/pull/73682) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73732](https://github.com/ClickHouse/ClickHouse/issues/73732): Fix crash in LIMIT BY COLUMNS. [#73686](https://github.com/ClickHouse/ClickHouse/pull/73686) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#74027](https://github.com/ClickHouse/ClickHouse/issues/74027): Fix deserialization of Dynamic/Object structure. It could lead to CANNOT_READ_ALL_DATA exceptions. [#73767](https://github.com/ClickHouse/ClickHouse/pull/73767) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74518](https://github.com/ClickHouse/ClickHouse/issues/74518): Skip `metadata_version.txt` in while restoring parts from a backup. [#73768](https://github.com/ClickHouse/ClickHouse/pull/73768) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#74098](https://github.com/ClickHouse/ClickHouse/issues/74098): Fixes [#72078](https://github.com/ClickHouse/ClickHouse/issues/72078) ( S3 Express Support was broken ). [#73777](https://github.com/ClickHouse/ClickHouse/pull/73777) ([Sameer Tamsekar](https://github.com/stamsekar)).
* Backported in [#74042](https://github.com/ClickHouse/ClickHouse/issues/74042): Fix high memory usage during nested Maps creation. [#73982](https://github.com/ClickHouse/ClickHouse/pull/73982) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74055](https://github.com/ClickHouse/ClickHouse/issues/74055): Fix: alias can be not added to the projection if it is referenced by another alias and selected in inverse order. [#74033](https://github.com/ClickHouse/ClickHouse/pull/74033) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#74108](https://github.com/ClickHouse/ClickHouse/issues/74108): A disk using the plain_rewritable metadata can be shared among multiple server instances. It is expected for one instance to read a metadata object while another modifies it. Object not found errors are ignored during plain_rewritable initialization with Azure storage, similar to the behavior implemented for S3. [#74059](https://github.com/ClickHouse/ClickHouse/pull/74059) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#74134](https://github.com/ClickHouse/ClickHouse/issues/74134): Fixes case when the user specifies keyword arguments in the kafka table engine. [#74064](https://github.com/ClickHouse/ClickHouse/pull/74064) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#74177](https://github.com/ClickHouse/ClickHouse/issues/74177): Fix crash when reading a subcolumn from the compressed Memory engine table. Fixes [#74009](https://github.com/ClickHouse/ClickHouse/issues/74009). [#74161](https://github.com/ClickHouse/ClickHouse/pull/74161) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#74390](https://github.com/ClickHouse/ClickHouse/issues/74390): Fix logical error in s3queue during setting file as failed. [#74216](https://github.com/ClickHouse/ClickHouse/pull/74216) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Backport [#72398](https://github.com/ClickHouse/ClickHouse/issues/72398) to 24.11: add the `latest_fail_error_code_name` column to `system.mutations`"'. [#73974](https://github.com/ClickHouse/ClickHouse/pull/73974) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#73860](https://github.com/ClickHouse/ClickHouse/issues/73860): Fix use-after-free in loadPathPrefixMap on thread pool exception. [#72870](https://github.com/ClickHouse/ClickHouse/pull/72870) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#73671](https://github.com/ClickHouse/ClickHouse/issues/73671): Add a setting. [#73281](https://github.com/ClickHouse/ClickHouse/pull/73281) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73790](https://github.com/ClickHouse/ClickHouse/issues/73790): Fix if condition in [#63151](https://github.com/ClickHouse/ClickHouse/issues/63151). [#73504](https://github.com/ClickHouse/ClickHouse/pull/73504) ([Andrey Zvonov](https://github.com/zvonand)).
* Backported in [#73753](https://github.com/ClickHouse/ClickHouse/issues/73753): Update `test_storage_s3_queue/test.py::test_upgrade(2)`. [#73607](https://github.com/ClickHouse/ClickHouse/pull/73607) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73745](https://github.com/ClickHouse/ClickHouse/issues/73745): Fix test_storage_s3_queue/test.py::test_alter_settings. [#73632](https://github.com/ClickHouse/ClickHouse/pull/73632) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73943](https://github.com/ClickHouse/ClickHouse/issues/73943): Reverts ClickHouse/ClickHouse[#62944](https://github.com/ClickHouse/ClickHouse/issues/62944) (there was a crash in the CI because of this). [#73738](https://github.com/ClickHouse/ClickHouse/pull/73738) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#74463](https://github.com/ClickHouse/ClickHouse/issues/74463): Make `version_helper` populated from every commit. [#74399](https://github.com/ClickHouse/ClickHouse/pull/74399) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

