---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v22.5.1.2079-stable (df0cb062098) FIXME as compared to v22.4.1.2305-prestable (77a82cc090d)

#### Backward Incompatible Change
* Updated the BoringSSL module to the official FIPS compliant version. This makes ClickHouse FIPS compliant. [#35914](https://github.com/ClickHouse/ClickHouse/pull/35914) ([Deleted user](https://github.com/ghost)).
* Now, background merges, mutations and `OPTIMIZE` will not increment `SelectedRows` and `SelectedBytes` metrics. They (still) will increment `MergedRows` and `MergedUncompressedBytes` as it was before. [#37040](https://github.com/ClickHouse/ClickHouse/pull/37040) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### New Feature
* add implementation of MeiliSearch storage and table function. [#33332](https://github.com/ClickHouse/ClickHouse/pull/33332) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Add support of GROUPING SETS in GROUP BY clause. Follow up after [#33186](https://github.com/ClickHouse/ClickHouse/issues/33186). This implementation supports a parallel processing of grouping sets. [#33631](https://github.com/ClickHouse/ClickHouse/pull/33631) ([Dmitry Novik](https://github.com/novikd)).
* According to the design mentioned at ：[#19627](https://github.com/ClickHouse/ClickHouse/issues/19627)#issuecomment-1068772646. [#35318](https://github.com/ClickHouse/ClickHouse/pull/35318) ([徐炘](https://github.com/weeds085490)).
* Added `SYSTEM SYNC DATABASE REPLICA` query which allows to sync tables metadata inside Replicated database, because currently synchronisation is asynchronous. [#35944](https://github.com/ClickHouse/ClickHouse/pull/35944) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* - Add output format Prometheus, [#36051](https://github.com/ClickHouse/ClickHouse/issues/36051). [#36206](https://github.com/ClickHouse/ClickHouse/pull/36206) ([Vladimir C](https://github.com/vdimir)).
* Parse collations in CREATE TABLE, throw exception or ignore. closes [#35892](https://github.com/ClickHouse/ClickHouse/issues/35892). [#36271](https://github.com/ClickHouse/ClickHouse/pull/36271) ([yuuch](https://github.com/yuuch)).
* Add aliases JSONLines and NDJSON for JSONEachRow. Closes [#36303](https://github.com/ClickHouse/ClickHouse/issues/36303). [#36327](https://github.com/ClickHouse/ClickHouse/pull/36327) ([flynn](https://github.com/ucasfl)).
* Set parts_to_delay_insert and parts_to_throw_insert as query-level settings. If they are defined, they can override table-level settings. [#36371](https://github.com/ClickHouse/ClickHouse/pull/36371) ([Memo](https://github.com/Joeywzr)).
* temporary table can show total rows and total bytes. [#36401](https://github.com/ClickHouse/ClickHouse/issues/36401). [#36439](https://github.com/ClickHouse/ClickHouse/pull/36439) ([chen](https://github.com/xiedeyantu)).
* Added new hash function - wyHash64. [#36467](https://github.com/ClickHouse/ClickHouse/pull/36467) ([olevino](https://github.com/olevino)).
* Window function nth_value was added. [#36601](https://github.com/ClickHouse/ClickHouse/pull/36601) ([Nikolay](https://github.com/ndchikin)).
* Add MySQLDump input format. It reads all data from INSERT queries belonging to one table in dump. If there are more than one table, by default it reads data from the first one. [#36667](https://github.com/ClickHouse/ClickHouse/pull/36667) ([Kruglov Pavel](https://github.com/Avogar)).
* New single binary based diagnostics tool. [#36705](https://github.com/ClickHouse/ClickHouse/pull/36705) ([Dale McDiarmid](https://github.com/gingerwizard)).
* **Description:** It is used to count the system table of a request for remote file access, which can help users analyze the causes of performance fluctuations in the scenario of separation of storage and computer. The current system table structure is as follows. When a query reads a segment of a remote file, a record is generated. Read type include **READ_FROM_FS_AND_DOWNLOADED_TO_CACHE、READ_FROM_CACHE、READ_FROM_FS_BYPASSING_CACHE**, which used to indicate whether the query accesses the segment from the cache or from a remote file. [#36802](https://github.com/ClickHouse/ClickHouse/pull/36802) ([Han Shukai](https://github.com/KinderRiven)).
* Adds `h3Line`, `h3Distance` and `h3HexRing` functions. [#37030](https://github.com/ClickHouse/ClickHouse/pull/37030) ([Bharat Nallan](https://github.com/bharatnc)).
* Related issue - [#35101](https://github.com/ClickHouse/ClickHouse/issues/35101). [#37033](https://github.com/ClickHouse/ClickHouse/pull/37033) ([qieqieplus](https://github.com/qieqieplus)).
* Added system.certificates table. [#37142](https://github.com/ClickHouse/ClickHouse/pull/37142) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).

#### Performance Improvement
* Improve performance or ORDER BY, MergeJoin, insertion into MergeTree using JIT compilation of sort columns comparator. [#34469](https://github.com/ClickHouse/ClickHouse/pull/34469) ([Maksim Kita](https://github.com/kitaisreal)).
* First commit is to increase the inline threshold. Next commits will improve queries by inlining for those who have shown better performance. This way we will not increase the compile time and binary size and optimize the program. [#34544](https://github.com/ClickHouse/ClickHouse/pull/34544) ([Daniel Kutenin](https://github.com/danlark1)).
* Transform OR LIKE chain to multiMatchAny. Will enable once we have more confidence it works. [#34932](https://github.com/ClickHouse/ClickHouse/pull/34932) ([Daniel Kutenin](https://github.com/danlark1)).
* Rewrite 'select countDistinct(a) from t' to 'select count(1) from (select a from t groupBy a)'. [#35993](https://github.com/ClickHouse/ClickHouse/pull/35993) ([zhanglistar](https://github.com/zhanglistar)).
* Change structure of `system.asynchronous_metric_log`. It will take about 10 times less space. This closes [#36357](https://github.com/ClickHouse/ClickHouse/issues/36357). The field `event_time_microseconds` was removed, because it is useless. [#36360](https://github.com/ClickHouse/ClickHouse/pull/36360) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The default `HashJoin` is not thread safe for inserting right table's rows and run it in a single thread. When the right table is large, the join process is too slow with low cpu utilization. [#36415](https://github.com/ClickHouse/ClickHouse/pull/36415) ([lgbo](https://github.com/lgbo-ustc)).
* Improve performance of reading from storage `File` and table functions `file` in case when path has globs and matched directory contains large number of files. [#36647](https://github.com/ClickHouse/ClickHouse/pull/36647) ([Anton Popov](https://github.com/CurtizJ)).
* Appy parallel parsing for input format `HiveText`, which can speed up HiveText parsing by 2x when reading local file. [#36650](https://github.com/ClickHouse/ClickHouse/pull/36650) ([李扬](https://github.com/taiyang-li)).
* Improves performance of file descriptor cache by narrowing mutex scopes. [#36682](https://github.com/ClickHouse/ClickHouse/pull/36682) ([Anton Kozlov](https://github.com/tonickkozlov)).
* This PR improves the `WATCH` query in WindowView: 1. Reduce the latency of providing query results by calling the `fire_condition` signal. 2. Makes the cancel query operation(ctrl-c) faster, by checking `isCancelled()` more frequently. [#37226](https://github.com/ClickHouse/ClickHouse/pull/37226) ([vxider](https://github.com/Vxider)).
* Improve performance of `avg`, `sum` aggregate functions if used without GROUP BY expression. [#37257](https://github.com/ClickHouse/ClickHouse/pull/37257) ([Maksim Kita](https://github.com/kitaisreal)).
* Improve performance of unary arithmetic functions (`bitCount`, `bitNot`, `abs`, `intExp2`, `intExp10`, `negate`, `roundAge`, `roundDuration`, `roundToExp2`, `sign`) using dynamic dispatch. [#37289](https://github.com/ClickHouse/ClickHouse/pull/37289) ([Maksim Kita](https://github.com/kitaisreal)).

#### Improvement
* Remind properly if use clickhouse-client --file without preceeding --external. Close [#34747](https://github.com/ClickHouse/ClickHouse/issues/34747). [#34765](https://github.com/ClickHouse/ClickHouse/pull/34765) ([李扬](https://github.com/taiyang-li)).
* Added support for specifying `content_type` in predefined and static HTTP handler config. [#34916](https://github.com/ClickHouse/ClickHouse/pull/34916) ([Roman Nikonov](https://github.com/nic11)).
* Implement partial GROUP BY key for optimize_aggregation_in_order. [#35111](https://github.com/ClickHouse/ClickHouse/pull/35111) ([Azat Khuzhin](https://github.com/azat)).
* Nullables detection in protobuf using Google wrappers. [#35149](https://github.com/ClickHouse/ClickHouse/pull/35149) ([Jakub Kuklis](https://github.com/jkuklis)).
* If the required amount of memory is available before the selected query stopped, all waiting queries continue execution. Now we don't stop any query if memory is freed before the moment when the selected query knows about the cancellation. [#35637](https://github.com/ClickHouse/ClickHouse/pull/35637) ([Dmitry Novik](https://github.com/novikd)).
* Enable memory overcommit by default. [#35921](https://github.com/ClickHouse/ClickHouse/pull/35921) ([Dmitry Novik](https://github.com/novikd)).
* - Add branch to avoid unnecessary memcpy in readbig. [#36095](https://github.com/ClickHouse/ClickHouse/pull/36095) ([jasperzhu](https://github.com/jinjunzh)).
* Refactor code around schema inference with globs. Try next file from glob only if it makes sense (previously we tried next file in case of any error). Also it fixes [#36317](https://github.com/ClickHouse/ClickHouse/issues/36317). [#36205](https://github.com/ClickHouse/ClickHouse/pull/36205) ([Kruglov Pavel](https://github.com/Avogar)).
* Improve schema inference for json objects. [#36207](https://github.com/ClickHouse/ClickHouse/pull/36207) ([Kruglov Pavel](https://github.com/Avogar)).
* Add support for force recovery which allows you to reconfigure cluster without quorum. [#36258](https://github.com/ClickHouse/ClickHouse/pull/36258) ([Antonio Andelic](https://github.com/antonio2368)).
* We create a local interpreter if we want to execute query on localhost replica. But for when executing query on multiple replicas we rely on the fact that a connection exists so replicas can talk to coordinator. It is now improved and localhost replica can talk to coordinator directly in the same process. [#36281](https://github.com/ClickHouse/ClickHouse/pull/36281) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Show names of erroneous files in case of parsing errors while executing table functions `file`, `s3` and `url`. [#36314](https://github.com/ClickHouse/ClickHouse/pull/36314) ([Anton Popov](https://github.com/CurtizJ)).
* Allowed to increase the number of threads for executing background operations (merges, mutations, moves and fetches) at runtime if they are specified at top level config. [#36425](https://github.com/ClickHouse/ClickHouse/pull/36425) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* clickhouse-benchmark can read auth from environment variables. [#36497](https://github.com/ClickHouse/ClickHouse/pull/36497) ([Anton Kozlov](https://github.com/tonickkozlov)).
* Allow names of tuple elements that start from digits. [#36544](https://github.com/ClickHouse/ClickHouse/pull/36544) ([Anton Popov](https://github.com/CurtizJ)).
* Allow file descriptors in table function file if it is run in clickhouse-local. [#36562](https://github.com/ClickHouse/ClickHouse/pull/36562) ([wuxiaobai24](https://github.com/wuxiaobai24)).
* Allow to cast columns of type `Object(...)` to `Object(Nullable(...))`. [#36564](https://github.com/ClickHouse/ClickHouse/pull/36564) ([awakeljw](https://github.com/awakeljw)).
* Cleanup CSS in Play UI. The pixels are more evenly placed. Better usability for long content in table cells. [#36569](https://github.com/ClickHouse/ClickHouse/pull/36569) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The metrics about time spent reading from s3 now calculated correctly. Close [#35483](https://github.com/ClickHouse/ClickHouse/issues/35483). [#36572](https://github.com/ClickHouse/ClickHouse/pull/36572) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve `SYSTEM DROP FILESYSTEM CACHE` query: `<path>` option and `FORCE` option. [#36639](https://github.com/ClickHouse/ClickHouse/pull/36639) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add `is_all_data_sent` column into `system.processes`, and improve internal testing hardening check based on it. [#36649](https://github.com/ClickHouse/ClickHouse/pull/36649) ([Azat Khuzhin](https://github.com/azat)).
* Now date time conversion functions that generates time before 1970-01-01 00:00:00 with partial hours/minutes timezones will be saturated to zero instead of overflow. This is the continuation of https://github.com/ClickHouse/ClickHouse/pull/29953 which addresses https://github.com/ClickHouse/ClickHouse/pull/29953#discussion_r800550280 . Mark as improvement because it's implementation defined behavior (and very rare case) and we are allowed to break it. [#36656](https://github.com/ClickHouse/ClickHouse/pull/36656) ([Amos Bird](https://github.com/amosbird)).
* Allow to cancel query while still keep decent query id in MySQLHandler. [#36699](https://github.com/ClickHouse/ClickHouse/pull/36699) ([Amos Bird](https://github.com/amosbird)).
* Properly cancel INSERT queries in `clickhouse-client`/`clickhouse-local`. [#36710](https://github.com/ClickHouse/ClickHouse/pull/36710) ([Azat Khuzhin](https://github.com/azat)).
* Allow cluster macro in s3Cluster table function. [#36726](https://github.com/ClickHouse/ClickHouse/pull/36726) ([Vadim Volodin](https://github.com/PolyProgrammist)).
* Added `user_defined_path` config setting. [#36753](https://github.com/ClickHouse/ClickHouse/pull/36753) ([Maksim Kita](https://github.com/kitaisreal)).
* Allow to execute hash functions with arguments of type `Array(Tuple(..))`. [#36812](https://github.com/ClickHouse/ClickHouse/pull/36812) ([Anton Popov](https://github.com/CurtizJ)).
* Add warning if someone running clickhouse-server with log level "test". The log level "test" was added recently and cannot be used in production due to inevitable, unavoidable, fatal and life-threatening performance degradation. [#36824](https://github.com/ClickHouse/ClickHouse/pull/36824) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Play UI: If there is one row in result and more than a few columns, display the result vertically. Continuation of [#36811](https://github.com/ClickHouse/ClickHouse/issues/36811). [#36842](https://github.com/ClickHouse/ClickHouse/pull/36842) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add extra diagnostic info (if applicable) when sending exception to other server. [#36872](https://github.com/ClickHouse/ClickHouse/pull/36872) ([Alexander Tokmakov](https://github.com/tavplubix)).
* After [#36425](https://github.com/ClickHouse/ClickHouse/issues/36425) settings like `background_fetches_pool_size` became obsolete and can appear in top level config, but clickhouse throws and exception like `Error updating configuration from '/etc/clickhouse-server/config.xml' config.: Code: 137. DB::Exception: A setting 'background_fetches_pool_size' appeared at top level in config /etc/clickhouse-server/config.xml.` This is fixed. [#36917](https://github.com/ClickHouse/ClickHouse/pull/36917) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Finalize write buffers in case of exception to avoid doing it in destructors. Hope it fixes: [#36907](https://github.com/ClickHouse/ClickHouse/issues/36907). [#36979](https://github.com/ClickHouse/ClickHouse/pull/36979) ([Kruglov Pavel](https://github.com/Avogar)).
* Play UI: Nullable numbers will be aligned to the right in table cells. This closes [#36982](https://github.com/ClickHouse/ClickHouse/issues/36982). [#36988](https://github.com/ClickHouse/ClickHouse/pull/36988) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Implemented a new mode of handling row policies which can be enabled in the main configuration which enables users without permissive row policies to read rows. [#36997](https://github.com/ClickHouse/ClickHouse/pull/36997) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix bug which can lead to forgotten outdated parts in MergeTree table engines family in case of filesystem failures during parts removal. Before fix they will be removed only after first server restart. [#37014](https://github.com/ClickHouse/ClickHouse/pull/37014) ([alesapin](https://github.com/alesapin)).
* Modify query div in play.html to be extendable beyond 200px height. In case of very long queries it is helpful to extend the textarea element, only today, since the div is fixed height, the extended textarea hides the data div underneath. With this fix, extending the textarea element will push the data div down/up such the extended textarea won't hide it. [#37051](https://github.com/ClickHouse/ClickHouse/pull/37051) ([guyco87](https://github.com/guyco87)).
* Better read from cache. [#37054](https://github.com/ClickHouse/ClickHouse/pull/37054) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix progress indication for `INSERT SELECT` in clickhouse-local for any query and for file progress in client, more correct file progress. [#37075](https://github.com/ClickHouse/ClickHouse/pull/37075) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Disable `log_query_threads` setting by default. It controls the logging of statistics about every thread participating in query execution. After supporting asynchronous reads, the total number of distinct thread ids became too large, and logging into the `query_thread_log` has become too heavy. [#37077](https://github.com/ClickHouse/ClickHouse/pull/37077) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Option `compatibility_ignore_auto_increment_in_create_table` allows ignoring `AUTO_INCREMENT` keyword in a column declaration to simplify migration from MySQL. [#37178](https://github.com/ClickHouse/ClickHouse/pull/37178) ([Igor Nikonov](https://github.com/devcrafter)).
* Added implicit cast for `h3kRing` function second argument to improve usability. Closes [#35432](https://github.com/ClickHouse/ClickHouse/issues/35432). [#37189](https://github.com/ClickHouse/ClickHouse/pull/37189) ([Maksim Kita](https://github.com/kitaisreal)).
* Limit the max partitions could be queried for each hive table. Avoid resource overruns. [#37281](https://github.com/ClickHouse/ClickHouse/pull/37281) ([lgbo](https://github.com/lgbo-ustc)).

#### Bug Fix
* Extracts Version ID if present from the URI and adds a request to the AWS HTTP URI. Closes [#31221](https://github.com/ClickHouse/ClickHouse/issues/31221). - [x] Extract `Version ID` from URI if present and reassemble without it. - [x] Configure `AWS HTTP URI` object with request. - [x] Unit Tests: [`gtest_s3_uri`](https://github.com/ClickHouse/ClickHouse/blob/2340a6c6849ebc05a8efbf97ba8de3ff9dc0eff4/src/IO/tests/gtest_s3_uri.cpp) - [x] Drop instrumentation commit. [#34571](https://github.com/ClickHouse/ClickHouse/pull/34571) ([Saad Ur Rahman](https://github.com/surahman)).

#### Build/Testing/Packaging Improvement
* Now `clickhouse-keeper` for the `x86_64` architecture is statically linked with [musl](https://musl.libc.org/) and doesn't depend on any system libraries. [#31833](https://github.com/ClickHouse/ClickHouse/pull/31833) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fail performance comparison on errors in the report. [#34797](https://github.com/ClickHouse/ClickHouse/pull/34797) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Check out the most of build jobs with depth=1. [#36091](https://github.com/ClickHouse/ClickHouse/pull/36091) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Bump minizip-ng to a sane version, or else old git won't be able to address dangling remote ref. [#35656](https://github.com/ClickHouse/ClickHouse/issues/35656). [#36295](https://github.com/ClickHouse/ClickHouse/pull/36295) ([Amos Bird](https://github.com/amosbird)).
* Use consistent `force tests` label in CI. [#36496](https://github.com/ClickHouse/ClickHouse/pull/36496) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Limit PowerPC code generation to Power8 for better compatibility. This closes [#36025](https://github.com/ClickHouse/ClickHouse/issues/36025). [#36529](https://github.com/ClickHouse/ClickHouse/pull/36529) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* - More robust handling of unknown architectures in CMake. [#36614](https://github.com/ClickHouse/ClickHouse/pull/36614) ([Robert Schulze](https://github.com/rschu1ze)).
* Simplify performance test. This will give a chance for us to use it. [#36769](https://github.com/ClickHouse/ClickHouse/pull/36769) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix checking for rabbitmq liveness in tests. Fixed incorrect import. [#36938](https://github.com/ClickHouse/ClickHouse/pull/36938) ([tchepavel](https://github.com/tchepavel)).
* ClickHouse builds for `PowerPC64LE` architecture are now available in universal installation script `curl https://clickhouse.com/ | sh` and by direct link `https://builds.clickhouse.com/master/powerpc64le/clickhouse`. [#37095](https://github.com/ClickHouse/ClickHouse/pull/37095) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* - Make cmake build scripts a bit more robust. [#37169](https://github.com/ClickHouse/ClickHouse/pull/37169) ([Robert Schulze](https://github.com/rschu1ze)).

#### Bug Fix (user-visible misbehavior in official stable release)

* The ilike() function on FixedString columns could have returned wrong results (i.e. match less than it should). [#37117](https://github.com/ClickHouse/ClickHouse/pull/37117) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix implicit cast for optimize_skip_unused_shards_rewrite_in. [#37153](https://github.com/ClickHouse/ClickHouse/pull/37153) ([Azat Khuzhin](https://github.com/azat)).
* Enable `enable_global_with_statement` for subqueries, close [#37141](https://github.com/ClickHouse/ClickHouse/issues/37141). [#37166](https://github.com/ClickHouse/ClickHouse/pull/37166) ([Vladimir C](https://github.com/vdimir)).
* Now WindowView `WATCH EVENTS` query will not be terminated due to the nonempty Chunk created in `WindowViewSource.h:58`. [#37182](https://github.com/ClickHouse/ClickHouse/pull/37182) ([vxider](https://github.com/Vxider)).
* Fix "Cannot create column of type Set" for distributed queries with LIMIT BY. [#37193](https://github.com/ClickHouse/ClickHouse/pull/37193) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible overflow during `OvercommitRatio` comparison. cc @tavplubix. [#37197](https://github.com/ClickHouse/ClickHouse/pull/37197) ([Dmitry Novik](https://github.com/novikd)).
* Update `max_fired_watermark ` after blocks **actually** fired, in case delete data that hasn't been fired yet. [#37225](https://github.com/ClickHouse/ClickHouse/pull/37225) ([vxider](https://github.com/Vxider)).
* Kafka does not need `group.id` on producer stage. In console log you can find Warning that describe this issue: ``` 2022.05.15 17:59:13.270227 [ 137 ] {} <Warning> StorageKafka (topic-name): [rdk:CONFWARN] [thrd:app]: Configuration property group.id is a consumer property and will be ignored by this producer instance ```. [#37228](https://github.com/ClickHouse/ClickHouse/pull/37228) ([Mark Andreev](https://github.com/mrk-andreev)).
* fix MySQL database engine to compatible with binary(0) dataType. [#37232](https://github.com/ClickHouse/ClickHouse/pull/37232) ([zzsmdfj](https://github.com/zzsmdfj)).
* Fix execution of mutations in tables, in which there exist columns of type `Object`. Using subcolumns of type `Object` in `WHERE` expression of `UPDATE` or `DELETE` queries is now allowed yet, as well as manipulating (`DROP`, `MODIFY`) of separate subcolumns. Fixes [#37205](https://github.com/ClickHouse/ClickHouse/issues/37205). [#37266](https://github.com/ClickHouse/ClickHouse/pull/37266) ([Anton Popov](https://github.com/CurtizJ)).
* Fix Nullable(String) to Nullable(Bool/IPv4/IPv6) conversion Closes [#37221](https://github.com/ClickHouse/ClickHouse/issues/37221). [#37270](https://github.com/ClickHouse/ClickHouse/pull/37270) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix system.opentelemetry_span_log attribute.values alias to values instead of keys. [#37275](https://github.com/ClickHouse/ClickHouse/pull/37275) ([Aleksandr Razumov](https://github.com/ernado)).
* Fix possible deadlock in OvercommitTracker during logging. cc @alesapin @tavplubix Fixes [#37272](https://github.com/ClickHouse/ClickHouse/issues/37272). [#37299](https://github.com/ClickHouse/ClickHouse/pull/37299) ([Dmitry Novik](https://github.com/novikd)).

#### Bug Fix (user-visible misbehaviour in official stable release)

* - fix substring function range error length when `offset` and `length` is negative constant and `s` is not constant. [#33861](https://github.com/ClickHouse/ClickHouse/pull/33861) ([RogerYK](https://github.com/RogerYK)).
* Accidentally ZSTD support for Arrow was not being built. This fixes [#35283](https://github.com/ClickHouse/ClickHouse/issues/35283). [#35486](https://github.com/ClickHouse/ClickHouse/pull/35486) ([Sean Lafferty](https://github.com/seanlaff)).
* Fix ALTER DROP COLUMN of nested column with compact parts (i.e. `ALTER TABLE x DROP COLUMN n`, when there is column `n.d`). [#35797](https://github.com/ClickHouse/ClickHouse/pull/35797) ([Azat Khuzhin](https://github.com/azat)).
* Fix insertion of complex JSONs with nested arrays to columns of type `Object`. [#36077](https://github.com/ClickHouse/ClickHouse/pull/36077) ([Anton Popov](https://github.com/CurtizJ)).
* Queries with aliases inside special operators returned parsing error (was broken in 22.1). Example: `SELECT substring('test' AS t, 1, 1)`. [#36167](https://github.com/ClickHouse/ClickHouse/pull/36167) ([Maksim Kita](https://github.com/kitaisreal)).
* - Fix assertion in JOIN, close [#36199](https://github.com/ClickHouse/ClickHouse/issues/36199). [#36201](https://github.com/ClickHouse/ClickHouse/pull/36201) ([Vladimir C](https://github.com/vdimir)).
* Fix dictionary reload for `ClickHouseDictionarySource` if it contains scalar subqueries. [#36390](https://github.com/ClickHouse/ClickHouse/pull/36390) ([lthaooo](https://github.com/lthaooo)).
* Fix nullptr dereference in JOIN and COLUMNS matcher. This fixes [#36416](https://github.com/ClickHouse/ClickHouse/issues/36416) . This is for https://github.com/ClickHouse/ClickHouse/pull/36417. [#36430](https://github.com/ClickHouse/ClickHouse/pull/36430) ([Amos Bird](https://github.com/amosbird)).
* Fix bug in s3Cluster schema inference that let to the fact that not all data was read in the select from s3Cluster. The bug appeared in https://github.com/ClickHouse/ClickHouse/pull/35544. [#36434](https://github.com/ClickHouse/ClickHouse/pull/36434) ([Kruglov Pavel](https://github.com/Avogar)).
* Server might fail to start if it cannot resolve hostname of external ClickHouse dictionary. It's fixed. Fixes [#36451](https://github.com/ClickHouse/ClickHouse/issues/36451). [#36463](https://github.com/ClickHouse/ClickHouse/pull/36463) ([Alexander Tokmakov](https://github.com/tavplubix)).
* This code segment can prove bug. ``` int main() { RangeGenerator g{1230, 100}; std::cout << g.totalRanges() << std::endl; int count = 0; while(g.nextRange()) ++count; std::cout << "count:" << count << std::endl; return 0; }. [#36469](https://github.com/ClickHouse/ClickHouse/pull/36469) ([李扬](https://github.com/taiyang-li)).
* Fix clickhouse-benchmark json report results. [#36473](https://github.com/ClickHouse/ClickHouse/pull/36473) ([Tian Xinhui](https://github.com/xinhuitian)).
* Add missing enum values in system.session_log table. Closes [#36474](https://github.com/ClickHouse/ClickHouse/issues/36474). [#36480](https://github.com/ClickHouse/ClickHouse/pull/36480) ([Memo](https://github.com/Joeywzr)).
* Fix possible exception with unknown packet from server in client. [#36481](https://github.com/ClickHouse/ClickHouse/pull/36481) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix usage of executable user defined functions in GROUP BY. Before executable user defined functions cannot be used as expressions in GROUP BY. Closes [#36448](https://github.com/ClickHouse/ClickHouse/issues/36448). [#36486](https://github.com/ClickHouse/ClickHouse/pull/36486) ([Maksim Kita](https://github.com/kitaisreal)).
* close [#33906](https://github.com/ClickHouse/ClickHouse/issues/33906). [#36489](https://github.com/ClickHouse/ClickHouse/pull/36489) ([awakeljw](https://github.com/awakeljw)).
* Fix hostname sanity checks for Keeper cluster configuration. Add `keeper_server.host_checks_enabled` config to enable/disable those checks. [#36492](https://github.com/ClickHouse/ClickHouse/pull/36492) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix offset update ReadBufferFromEncryptedFile, which could cause undefined behaviour. [#36493](https://github.com/ClickHouse/ClickHouse/pull/36493) ([Kseniia Sumarokova](https://github.com/kssenii)).
* - Fix potential error with literals in `WHERE` for join queries. Close [#36279](https://github.com/ClickHouse/ClickHouse/issues/36279). [#36542](https://github.com/ClickHouse/ClickHouse/pull/36542) ([Vladimir C](https://github.com/vdimir)).
* Fix `Missing column` exception which could happen while using `INTERPOLATE` with `ENGINE = MergeTree` table. [#36549](https://github.com/ClickHouse/ClickHouse/pull/36549) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix format crash when default expression follow EPHEMERAL not literal. Closes [#36618](https://github.com/ClickHouse/ClickHouse/issues/36618). [#36633](https://github.com/ClickHouse/ClickHouse/pull/36633) ([flynn](https://github.com/ucasfl)).
* Fix merges of wide parts with type `Object`. [#36637](https://github.com/ClickHouse/ClickHouse/pull/36637) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed parsing of query settings in `CREATE` query when engine is not specified. Fixes https://github.com/ClickHouse/ClickHouse/pull/34187#issuecomment-1103812419. [#36642](https://github.com/ClickHouse/ClickHouse/pull/36642) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix possible heap-use-after-free in schema inference. Closes [#36661](https://github.com/ClickHouse/ClickHouse/issues/36661). [#36679](https://github.com/ClickHouse/ClickHouse/pull/36679) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix server restart if cache configuration changed. [#36685](https://github.com/ClickHouse/ClickHouse/pull/36685) ([Kseniia Sumarokova](https://github.com/kssenii)).
* In the previous [PR](https://github.com/ClickHouse/ClickHouse/pull/36376), I found that testing **(stateless tests, flaky check (address, actions))** is timeout. Moreover, testing locally can also trigger unstable system deadlocks. This problem still exists when using the latest source code of master. [#36697](https://github.com/ClickHouse/ClickHouse/pull/36697) ([Han Shukai](https://github.com/KinderRiven)).
* Fix server reload on port change (do not wait for current connections from query context). [#36700](https://github.com/ClickHouse/ClickHouse/pull/36700) ([Azat Khuzhin](https://github.com/azat)).
* Fix vertical merges in wide parts. Previously an exception `There is no column` can be thrown during merge. [#36707](https://github.com/ClickHouse/ClickHouse/pull/36707) ([Anton Popov](https://github.com/CurtizJ)).
* During the [test](https://s3.amazonaws.com/clickhouse-test-reports/36376/1cb1c7275cb53769ab826772db9b71361bb3e413/stress_test__thread__actions_/clickhouse-server.clean.log) in [PR](https://github.com/ClickHouse/ClickHouse/pull/36376), I found that the one cache class was initialized twice, it throws a exception. Although the cause of this problem is not clear, there should be code logic of repeatedly loading disk in ClickHouse, so we need to make special judgment for this situation. [#36737](https://github.com/ClickHouse/ClickHouse/pull/36737) ([Han Shukai](https://github.com/KinderRiven)).
* Fix a bug of `groupBitmapAndState`/`groupBitmapOrState`/`groupBitmapXorState` on distributed table. [#36739](https://github.com/ClickHouse/ClickHouse/pull/36739) ([Zhang Yifan](https://github.com/zhangyifan27)).
* Fix timeouts in Hedged requests. Connection hang right after sending remote query could lead to eternal waiting. [#36749](https://github.com/ClickHouse/ClickHouse/pull/36749) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix insertion to columns of type `Object` from multiple files, e.g. via table function `file` with globs. [#36762](https://github.com/ClickHouse/ClickHouse/pull/36762) ([Anton Popov](https://github.com/CurtizJ)).
* Fix some issues with async reads from remote filesystem which happened when reading low cardinality. [#36763](https://github.com/ClickHouse/ClickHouse/pull/36763) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix creation of tables with `flatten_nested = 0`. Previously unflattened `Nested` columns could be flattened after server restart. [#36803](https://github.com/ClickHouse/ClickHouse/pull/36803) ([Anton Popov](https://github.com/CurtizJ)).
* Fix incorrect cast in cached buffer from remote fs. [#36809](https://github.com/ClickHouse/ClickHouse/pull/36809) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove function `groupArraySorted` which has a bug. [#36822](https://github.com/ClickHouse/ClickHouse/pull/36822) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix fire in window view with hop window [#34044](https://github.com/ClickHouse/ClickHouse/issues/34044). [#36861](https://github.com/ClickHouse/ClickHouse/pull/36861) ([vxider](https://github.com/Vxider)).
* Fix `current_size` count in cache. [#36887](https://github.com/ClickHouse/ClickHouse/pull/36887) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix incorrect query result when doing constant aggregation. This fixes [#36728](https://github.com/ClickHouse/ClickHouse/issues/36728) . [#36888](https://github.com/ClickHouse/ClickHouse/pull/36888) ([Amos Bird](https://github.com/amosbird)).
* Fix bug in clickhouse-keeper which can lead to corrupted compressed log files in case of small load and restarts. [#36910](https://github.com/ClickHouse/ClickHouse/pull/36910) ([alesapin](https://github.com/alesapin)).
* Fix bugs when using multiple columns in WindowView by adding converting actions to make it possible to call`writeIntoWindowView` with a slightly different schema. [#36928](https://github.com/ClickHouse/ClickHouse/pull/36928) ([vxider](https://github.com/Vxider)).
* Fix issue: [#36671](https://github.com/ClickHouse/ClickHouse/issues/36671). [#36929](https://github.com/ClickHouse/ClickHouse/pull/36929) ([李扬](https://github.com/taiyang-li)).
* Fix stuck when dropping source table in WindowView. Closes [#35678](https://github.com/ClickHouse/ClickHouse/issues/35678). [#36967](https://github.com/ClickHouse/ClickHouse/pull/36967) ([vxider](https://github.com/Vxider)).
* Fixed logical error on `TRUNCATE` query in `Replicated` database. Fixes [#33747](https://github.com/ClickHouse/ClickHouse/issues/33747). [#36976](https://github.com/ClickHouse/ClickHouse/pull/36976) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix sending external tables data in HedgedConnections with max_parallel_replicas != 1. [#36981](https://github.com/ClickHouse/ClickHouse/pull/36981) ([Kruglov Pavel](https://github.com/Avogar)).
* Fixed problem with infs in `quantileTDigest`. Fixes [#32107](https://github.com/ClickHouse/ClickHouse/issues/32107). [#37021](https://github.com/ClickHouse/ClickHouse/pull/37021) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix LowCardinality->ArrowDictionary invalid output when type of indexes is not UInt8. Closes [#36832](https://github.com/ClickHouse/ClickHouse/issues/36832). [#37043](https://github.com/ClickHouse/ClickHouse/pull/37043) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix in-order `GROUP BY` (`optimize_aggregation_in_order=1`) with `*Array` (`groupArrayArray`/...) aggregate functions. [#37046](https://github.com/ClickHouse/ClickHouse/pull/37046) ([Azat Khuzhin](https://github.com/azat)).
* Fixed performance degradation of some INSERT SELECT queries with implicit aggregation. Fixes [#36792](https://github.com/ClickHouse/ClickHouse/issues/36792). [#37047](https://github.com/ClickHouse/ClickHouse/pull/37047) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix optimize_aggregation_in_order with prefix GROUP BY and *Array aggregate functions. [#37050](https://github.com/ClickHouse/ClickHouse/pull/37050) ([Azat Khuzhin](https://github.com/azat)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Minor refactor to prefer C++ Standard Algorithms"'. [#36511](https://github.com/ClickHouse/ClickHouse/pull/36511) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Strict taskstats parser"'. [#36591](https://github.com/ClickHouse/ClickHouse/pull/36591) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Translate  docs/zh/sql-reference/data-types/map.md"'. [#36594](https://github.com/ClickHouse/ClickHouse/pull/36594) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Update setting.md"'. [#36595](https://github.com/ClickHouse/ClickHouse/pull/36595) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Documentation: Add a missing **ESTIMATE** in explain syntax'. [#36717](https://github.com/ClickHouse/ClickHouse/pull/36717) ([小蝌蚪](https://github.com/kayhaw)).
* NO CL ENTRY:  '[Snyk] Security upgrade numpy from 1.16.6 to 1.22.2'. [#36729](https://github.com/ClickHouse/ClickHouse/pull/36729) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* NO CL ENTRY:  'Translate playground.md to Chinese'. [#36821](https://github.com/ClickHouse/ClickHouse/pull/36821) ([小蝌蚪](https://github.com/kayhaw)).
* NO CL ENTRY:  'Revert "Memory overcommit: continue query execution if memory is available"'. [#36858](https://github.com/ClickHouse/ClickHouse/pull/36858) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Revert "Revert "Memory overcommit: continue query execution if memory is available""'. [#36859](https://github.com/ClickHouse/ClickHouse/pull/36859) ([Dmitry Novik](https://github.com/novikd)).
* NO CL ENTRY:  'Revert "BLAKE3 hash function documentation"'. [#37092](https://github.com/ClickHouse/ClickHouse/pull/37092) ([Rich Raposa](https://github.com/rfraposa)).
* NO CL ENTRY:  'Revert "Remove height restrictions from the query div in play web tool."'. [#37261](https://github.com/ClickHouse/ClickHouse/pull/37261) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Cleanup GROUPING SETS formating [#32999](https://github.com/ClickHouse/ClickHouse/pull/32999) ([Dmitry Novik](https://github.com/novikd)).
* Minor renames [#35272](https://github.com/ClickHouse/ClickHouse/pull/35272) ([Anton Popov](https://github.com/CurtizJ)).
* clickhouse-test: fix left-queries-check, to fix test log parser [#35865](https://github.com/ClickHouse/ClickHouse/pull/35865) ([Azat Khuzhin](https://github.com/azat)).
* Regression test for CHECKSUM_DOESNT_MATCH error because of per-column TTL bug [#35971](https://github.com/ClickHouse/ClickHouse/pull/35971) ([Azat Khuzhin](https://github.com/azat)).
* Fix performance tests [#35976](https://github.com/ClickHouse/ClickHouse/pull/35976) ([Maksim Kita](https://github.com/kitaisreal)).
* Backup for replicated tables and other improvements [#36198](https://github.com/ClickHouse/ClickHouse/pull/36198) ([Vitaly Baranov](https://github.com/vitlibar)).
* Trying to fix some trash in zero copy replication [#36299](https://github.com/ClickHouse/ClickHouse/pull/36299) ([alesapin](https://github.com/alesapin)).
* Speed up build a little [#36319](https://github.com/ClickHouse/ClickHouse/pull/36319) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Replace remove-erase idiom by C++20 erase()/erase_if() [#36348](https://github.com/ClickHouse/ClickHouse/pull/36348) ([Robert Schulze](https://github.com/rschu1ze)).
* Strict taskstats parser [#36351](https://github.com/ClickHouse/ClickHouse/pull/36351) ([Azat Khuzhin](https://github.com/azat)).
* Draft changelog for version 22.4 [#36397](https://github.com/ClickHouse/ClickHouse/pull/36397) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update int-uint.md [#36404](https://github.com/ClickHouse/ClickHouse/pull/36404) ([hardstep33](https://github.com/hardstep33)).
* Return back [#36126](https://github.com/ClickHouse/ClickHouse/issues/36126) [#36423](https://github.com/ClickHouse/ClickHouse/pull/36423) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed warnings of clang-tidy check "bugprone-branch-clone" [#36431](https://github.com/ClickHouse/ClickHouse/pull/36431) ([Robert Schulze](https://github.com/rschu1ze)).
* Clang tidy fixes [#36444](https://github.com/ClickHouse/ClickHouse/pull/36444) ([Robert Schulze](https://github.com/rschu1ze)).
* fixed /common/example cow_compositions.cpp clone the inner column when there is no need [#36453](https://github.com/ClickHouse/ClickHouse/pull/36453) ([zombee0](https://github.com/zombee0)).
* Refactoring dependency for ParserAttachAccessEntity [#36468](https://github.com/ClickHouse/ClickHouse/pull/36468) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* more specific warning text about low disk space [#36472](https://github.com/ClickHouse/ClickHouse/pull/36472) ([Sergei Trifonov](https://github.com/serxa)).
* Fixed missing enum values for ClientInfo::Interface [#36482](https://github.com/ClickHouse/ClickHouse/pull/36482) ([Vasily Nemkov](https://github.com/Enmk)).
* Add passphrase for certificates [#36487](https://github.com/ClickHouse/ClickHouse/pull/36487) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Update version after release [#36502](https://github.com/ClickHouse/ClickHouse/pull/36502) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Followup on [#36172](https://github.com/ClickHouse/ClickHouse/issues/36172) password hash salt feature [#36510](https://github.com/ClickHouse/ClickHouse/pull/36510) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Update version_date.tsv after v22.4.2.1-stable [#36533](https://github.com/ClickHouse/ClickHouse/pull/36533) ([github-actions[bot]](https://github.com/apps/github-actions)).
* fix log should print 'from' path [#36535](https://github.com/ClickHouse/ClickHouse/pull/36535) ([chen](https://github.com/xiedeyantu)).
* Add function bin tests for Int/UInt128/UInt256 [#36537](https://github.com/ClickHouse/ClickHouse/pull/36537) ([Memo](https://github.com/Joeywzr)).
* Fix 01161_all_system_tables [#36539](https://github.com/ClickHouse/ClickHouse/pull/36539) ([Antonio Andelic](https://github.com/antonio2368)).
* Update PULL_REQUEST_TEMPLATE.md [#36543](https://github.com/ClickHouse/ClickHouse/pull/36543) ([Ivan Blinkov](https://github.com/blinkov)).
* Fixed integer overflow in toStartOfInterval [#36546](https://github.com/ClickHouse/ClickHouse/pull/36546) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix issue with broken git ownership [#36548](https://github.com/ClickHouse/ClickHouse/pull/36548) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix version autodetection for docker_server.py [#36552](https://github.com/ClickHouse/ClickHouse/pull/36552) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Snyk fixes [#36554](https://github.com/ClickHouse/ClickHouse/pull/36554) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Use just index to split performance tests by group [#36559](https://github.com/ClickHouse/ClickHouse/pull/36559) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Update quantiledeterministic.md [#36560](https://github.com/ClickHouse/ClickHouse/pull/36560) ([ifinik](https://github.com/ifinik)).
* CodeQL Experiment - Exclude contrib Dependencies [#36561](https://github.com/ClickHouse/ClickHouse/pull/36561) ([Julio Jimenez](https://github.com/juliojimenez)).
* Small refactoring of Processors and QueryPipeline [#36579](https://github.com/ClickHouse/ClickHouse/pull/36579) ([Amos Bird](https://github.com/amosbird)).
* Simplify 01834_alias_columns_laziness_filimonov test [#36585](https://github.com/ClickHouse/ClickHouse/pull/36585) ([Azat Khuzhin](https://github.com/azat)).
* bash-completion: add completion for send_logs_level [#36586](https://github.com/ClickHouse/ClickHouse/pull/36586) ([Azat Khuzhin](https://github.com/azat)).
* client: add a message on reconnect (under warning log level) [#36587](https://github.com/ClickHouse/ClickHouse/pull/36587) ([Azat Khuzhin](https://github.com/azat)).
* Fix strange whitespace (or I do not know YAML) [#36590](https://github.com/ClickHouse/ClickHouse/pull/36590) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Strict taskstats parser (resubmit) [#36602](https://github.com/ClickHouse/ClickHouse/pull/36602) ([Azat Khuzhin](https://github.com/azat)).
* Exclude test `02271_fix_column_matcher_and_column_transformer` from bc check [#36607](https://github.com/ClickHouse/ClickHouse/pull/36607) ([alesapin](https://github.com/alesapin)).
* Ancient cmake version cleanup [#36612](https://github.com/ClickHouse/ClickHouse/pull/36612) ([Robert Schulze](https://github.com/rschu1ze)).
* Cleanup clang-tidy integration. [#36613](https://github.com/ClickHouse/ClickHouse/pull/36613) ([Robert Schulze](https://github.com/rschu1ze)).
* ParallelReadBuffer small improvements [#36619](https://github.com/ClickHouse/ClickHouse/pull/36619) ([Antonio Andelic](https://github.com/antonio2368)).
* Lambda cancel sync [#36622](https://github.com/ClickHouse/ClickHouse/pull/36622) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Version history benchmarks [#36628](https://github.com/ClickHouse/ClickHouse/pull/36628) ([Ilya Yatsishin](https://github.com/qoega)).
* fix typo [#36629](https://github.com/ClickHouse/ClickHouse/pull/36629) ([Sergei Trifonov](https://github.com/serxa)).
* Tiny Mutator code cleanup [#36630](https://github.com/ClickHouse/ClickHouse/pull/36630) ([Azat Khuzhin](https://github.com/azat)).
* Disble test postgresql replica with asan [#36631](https://github.com/ClickHouse/ClickHouse/pull/36631) ([alesapin](https://github.com/alesapin)).
* Minor Coverity defects fixes [#36632](https://github.com/ClickHouse/ClickHouse/pull/36632) ([Heena Bansal](https://github.com/HeenaBansal2009)).
* Properly wait for queries in 01502_long_log_tinylog_deadlock_race test [#36634](https://github.com/ClickHouse/ClickHouse/pull/36634) ([Azat Khuzhin](https://github.com/azat)).
* remove unneeded if statement [#36636](https://github.com/ClickHouse/ClickHouse/pull/36636) ([flynn](https://github.com/ucasfl)).
* Fix SortingStep::updateOutputStream() [#36638](https://github.com/ClickHouse/ClickHouse/pull/36638) ([Nikita Taranov](https://github.com/nickitat)).
* CodeQL - Run Daily Analysis [#36640](https://github.com/ClickHouse/ClickHouse/pull/36640) ([Julio Jimenez](https://github.com/juliojimenez)).
* Simplify check_branch, prefetch target branches [#36641](https://github.com/ClickHouse/ClickHouse/pull/36641) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Make backward compatible integration tests runner [#36643](https://github.com/ClickHouse/ClickHouse/pull/36643) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix some flaky tests [#36644](https://github.com/ClickHouse/ClickHouse/pull/36644) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Update version_date.tsv after v22.4.3.3-stable [#36651](https://github.com/ClickHouse/ClickHouse/pull/36651) ([github-actions[bot]](https://github.com/apps/github-actions)).
* Fix flaky test [#36652](https://github.com/ClickHouse/ClickHouse/pull/36652) ([Amos Bird](https://github.com/amosbird)).
* add missing pandas package [#36653](https://github.com/ClickHouse/ClickHouse/pull/36653) ([Ramazan Polat](https://github.com/ramazanpolat)).
* Fix style issue reported by black formatter [#36655](https://github.com/ClickHouse/ClickHouse/pull/36655) ([Alexander Gololobov](https://github.com/davenger)).
* Fix formatting in drop cache system query [#36658](https://github.com/ClickHouse/ClickHouse/pull/36658) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix stress test after 36639 [#36660](https://github.com/ClickHouse/ClickHouse/pull/36660) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update version_date.tsv after v22.3.4.20-lts [#36668](https://github.com/ClickHouse/ClickHouse/pull/36668) ([github-actions[bot]](https://github.com/apps/github-actions)).
* Update 00170_s3_cache.sql [#36669](https://github.com/ClickHouse/ClickHouse/pull/36669) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Better version of SeekableReadBufferWithSize [#36676](https://github.com/ClickHouse/ClickHouse/pull/36676) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Better logs for virtual parts [#36680](https://github.com/ClickHouse/ClickHouse/pull/36680) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Check socket is connected in HTTPSession [#36683](https://github.com/ClickHouse/ClickHouse/pull/36683) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* fix typo [#36684](https://github.com/ClickHouse/ClickHouse/pull/36684) ([flynn](https://github.com/ucasfl)).
* Remove excessive logging from S3 [#36689](https://github.com/ClickHouse/ClickHouse/pull/36689) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Tests report [#36701](https://github.com/ClickHouse/ClickHouse/pull/36701) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Use correct nodes in test_keeper_znode_time [#36711](https://github.com/ClickHouse/ClickHouse/pull/36711) ([Antonio Andelic](https://github.com/antonio2368)).
* Reorganize source files so that base won't depend on Common [#36715](https://github.com/ClickHouse/ClickHouse/pull/36715) ([Amos Bird](https://github.com/amosbird)).
* tests: fix 02015_async_inserts_stress_long flakiness [#36731](https://github.com/ClickHouse/ClickHouse/pull/36731) ([Azat Khuzhin](https://github.com/azat)).
* Add an extra check for RAFT config change [#36736](https://github.com/ClickHouse/ClickHouse/pull/36736) ([Antonio Andelic](https://github.com/antonio2368)).
* Update 00170_s3_cache.sql [#36743](https://github.com/ClickHouse/ClickHouse/pull/36743) ([Kseniia Sumarokova](https://github.com/kssenii)).
* ClickHouseDictionarySource context copy [#36744](https://github.com/ClickHouse/ClickHouse/pull/36744) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix build SeekableReadBufferWithSize -> SeekableReadBuffer [#36745](https://github.com/ClickHouse/ClickHouse/pull/36745) ([Vladimir C](https://github.com/vdimir)).
* Better error message from NuRaft in case of CRC mismatch [#36746](https://github.com/ClickHouse/ClickHouse/pull/36746) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix certs (finishing pr [#36457](https://github.com/ClickHouse/ClickHouse/issues/36457)) [#36747](https://github.com/ClickHouse/ClickHouse/pull/36747) ([Nikita Taranov](https://github.com/nickitat)).
* Another fix for Hung Check [#36752](https://github.com/ClickHouse/ClickHouse/pull/36752) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Deduce `UInt8` type for bools from json instead of `UInt64` [#36756](https://github.com/ClickHouse/ClickHouse/pull/36756) ([Anton Popov](https://github.com/CurtizJ)).
* Add small script for keeper check [#36758](https://github.com/ClickHouse/ClickHouse/pull/36758) ([alesapin](https://github.com/alesapin)).
* Fix ungrammatical error message [#36760](https://github.com/ClickHouse/ClickHouse/pull/36760) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix flaky test `test_ddl_worker_non_leader` [#36765](https://github.com/ClickHouse/ClickHouse/pull/36765) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix evaluateConstantExpression for subqueries [#36766](https://github.com/ClickHouse/ClickHouse/pull/36766) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix clickhouse-test for server without `is_all_data_sent` in system.processes [#36767](https://github.com/ClickHouse/ClickHouse/pull/36767) ([Azat Khuzhin](https://github.com/azat)).
* Init thread pools for clickhouse-local [#36778](https://github.com/ClickHouse/ClickHouse/pull/36778) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix performance test [#36779](https://github.com/ClickHouse/ClickHouse/pull/36779) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better exception messages while socket timeouts [#36781](https://github.com/ClickHouse/ClickHouse/pull/36781) ([Kruglov Pavel](https://github.com/Avogar)).
* Improve docs_check to be used in clickhouse-docs [#36796](https://github.com/ClickHouse/ClickHouse/pull/36796) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* pull poco #58 [#36798](https://github.com/ClickHouse/ClickHouse/pull/36798) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Tiny cleanup [#36799](https://github.com/ClickHouse/ClickHouse/pull/36799) ([Azat Khuzhin](https://github.com/azat)).
* Use mutex per worker in ParallelReadBuffer [#36801](https://github.com/ClickHouse/ClickHouse/pull/36801) ([Antonio Andelic](https://github.com/antonio2368)).
* Update version_date.tsv after v22.3.5.5-lts [#36805](https://github.com/ClickHouse/ClickHouse/pull/36805) ([github-actions[bot]](https://github.com/apps/github-actions)).
* play.html: add button to transpose table [#36811](https://github.com/ClickHouse/ClickHouse/pull/36811) ([Vladimir C](https://github.com/vdimir)).
* Fix style error in DocsCheck [#36813](https://github.com/ClickHouse/ClickHouse/pull/36813) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Set is_all_data_sent on exceptions too [#36816](https://github.com/ClickHouse/ClickHouse/pull/36816) ([Azat Khuzhin](https://github.com/azat)).
* Clang -Tidy Fixes [#36817](https://github.com/ClickHouse/ClickHouse/pull/36817) ([Heena Bansal](https://github.com/HeenaBansal2009)).
* Protection from incorrect build [#36819](https://github.com/ClickHouse/ClickHouse/pull/36819) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Avoid recreation of system.asynchronous_metric_log (due to difference in codec) [#36820](https://github.com/ClickHouse/ClickHouse/pull/36820) ([Azat Khuzhin](https://github.com/azat)).
* Removed forceful drop cache command, fix detached status state [#36825](https://github.com/ClickHouse/ClickHouse/pull/36825) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Log hash table's cache messages with TRACE level [#36830](https://github.com/ClickHouse/ClickHouse/pull/36830) ([Nikita Taranov](https://github.com/nickitat)).
* Cleanup: Remove switches for obsolete GCC version [#36831](https://github.com/ClickHouse/ClickHouse/pull/36831) ([Robert Schulze](https://github.com/rschu1ze)).
* Add functions from CREATE FUNCTION to completion [#36834](https://github.com/ClickHouse/ClickHouse/pull/36834) ([Azat Khuzhin](https://github.com/azat)).
* Validate that function had been passed in CREATE FUNCTION [#36835](https://github.com/ClickHouse/ClickHouse/pull/36835) ([Azat Khuzhin](https://github.com/azat)).
* [RFC] Remove unimplemented RAID1 support [#36836](https://github.com/ClickHouse/ClickHouse/pull/36836) ([Azat Khuzhin](https://github.com/azat)).
* Disable `merge_tree_metadata_cache` by default  [#36838](https://github.com/ClickHouse/ClickHouse/pull/36838) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Replace uses of SFINAE by C++20 concepts [#36839](https://github.com/ClickHouse/ClickHouse/pull/36839) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix performance test (4) [#36840](https://github.com/ClickHouse/ClickHouse/pull/36840) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove "preconditions" from performance tests (overengineering, unneeded feature) [#36841](https://github.com/ClickHouse/ClickHouse/pull/36841) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove inherited create() method + disallow copying of storages [#36844](https://github.com/ClickHouse/ClickHouse/pull/36844) ([Robert Schulze](https://github.com/rschu1ze)).
* tests: disable 02260_alter_compact_part_drop_nested_column for <=22.4 [#36845](https://github.com/ClickHouse/ClickHouse/pull/36845) ([Azat Khuzhin](https://github.com/azat)).
* Fix check black [#36850](https://github.com/ClickHouse/ClickHouse/pull/36850) ([Kruglov Pavel](https://github.com/Avogar)).
* Aggregator JIT compilation lock fix [#36852](https://github.com/ClickHouse/ClickHouse/pull/36852) ([Maksim Kita](https://github.com/kitaisreal)).
* Add Other Query Time Microseconds Profile Event [#36853](https://github.com/ClickHouse/ClickHouse/pull/36853) ([Ilya Yatsishin](https://github.com/qoega)).
* Reproduce and a little bit better fix for LC dict right offset. [#36856](https://github.com/ClickHouse/ClickHouse/pull/36856) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Terminate if S3 buffer is not finalized [#36857](https://github.com/ClickHouse/ClickHouse/pull/36857) ([alesapin](https://github.com/alesapin)).
* Activated a bunch of LLVM 12/13/14 clang-tidy warnings [#36862](https://github.com/ClickHouse/ClickHouse/pull/36862) ([Robert Schulze](https://github.com/rschu1ze)).
* Replace `Timeout` with `Tests not finished` [#36863](https://github.com/ClickHouse/ClickHouse/pull/36863) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backup improvements [#36864](https://github.com/ClickHouse/ClickHouse/pull/36864) ([Vitaly Baranov](https://github.com/vitlibar)).
* Integration tests [#36866](https://github.com/ClickHouse/ClickHouse/pull/36866) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Relax cmake check for CFLAGS/CXXFLAGS/LDFLAGS [#36869](https://github.com/ClickHouse/ClickHouse/pull/36869) ([Azat Khuzhin](https://github.com/azat)).
* Fix insertion of complex JSONs with nested arrays [2] [#36873](https://github.com/ClickHouse/ClickHouse/pull/36873) ([Anton Popov](https://github.com/CurtizJ)).
* Add column to system.filesystem_cache_log [#36874](https://github.com/ClickHouse/ClickHouse/pull/36874) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Log into filesystem_cache_log when cache not even attempted [#36876](https://github.com/ClickHouse/ClickHouse/pull/36876) ([Kseniia Sumarokova](https://github.com/kssenii)).
* fix typo in comment [#36880](https://github.com/ClickHouse/ClickHouse/pull/36880) ([Sergei Trifonov](https://github.com/serxa)).
* Add some CurrentMetrics for fs cache [#36882](https://github.com/ClickHouse/ClickHouse/pull/36882) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add some asynchronous metrics for fs cache [#36883](https://github.com/ClickHouse/ClickHouse/pull/36883) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Save system logs in functionsl tests if server crashed [#36885](https://github.com/ClickHouse/ClickHouse/pull/36885) ([Alexander Tokmakov](https://github.com/tavplubix)).
* quick tmp fix for stress test [#36900](https://github.com/ClickHouse/ClickHouse/pull/36900) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Some fixes for replicated merge tree [#36909](https://github.com/ClickHouse/ClickHouse/pull/36909) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Invert .clang-tidy [#36911](https://github.com/ClickHouse/ClickHouse/pull/36911) ([Robert Schulze](https://github.com/rschu1ze)).
* Replace make_pair()/make_tuple() by pair()/tuple() [#36913](https://github.com/ClickHouse/ClickHouse/pull/36913) ([Robert Schulze](https://github.com/rschu1ze)).
* Remove log message on client reconnects (reverts [#36587](https://github.com/ClickHouse/ClickHouse/issues/36587)) [#36915](https://github.com/ClickHouse/ClickHouse/pull/36915) ([Azat Khuzhin](https://github.com/azat)).
* Fix profile events in fs cached buffer [#36916](https://github.com/ClickHouse/ClickHouse/pull/36916) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Benchmark was not loaded properly [#36918](https://github.com/ClickHouse/ClickHouse/pull/36918) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Force keeper snapshot equality on different replicas [#36947](https://github.com/ClickHouse/ClickHouse/pull/36947) ([alesapin](https://github.com/alesapin)).
* Remove strange code [#36951](https://github.com/ClickHouse/ClickHouse/pull/36951) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove nested exception [#36952](https://github.com/ClickHouse/ClickHouse/pull/36952) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable clangtidies [#36960](https://github.com/ClickHouse/ClickHouse/pull/36960) ([Robert Schulze](https://github.com/rschu1ze)).
* Improve stress tests report a little bit [#36961](https://github.com/ClickHouse/ClickHouse/pull/36961) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Follow up for ConcurrentHashJoin [#36970](https://github.com/ClickHouse/ClickHouse/pull/36970) ([Vladimir C](https://github.com/vdimir)).
* Fix formats docs [#36972](https://github.com/ClickHouse/ClickHouse/pull/36972) ([Kruglov Pavel](https://github.com/Avogar)).
* Support secure connection in clickhouse-test [#36977](https://github.com/ClickHouse/ClickHouse/pull/36977) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix installation_id filter, minimize docker images diff [#36978](https://github.com/ClickHouse/ClickHouse/pull/36978) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Update version_date.tsv after v22.3.6.5-lts [#36985](https://github.com/ClickHouse/ClickHouse/pull/36985) ([github-actions[bot]](https://github.com/apps/github-actions)).
* Update version_date.tsv after v22.4.5.9-stable [#36986](https://github.com/ClickHouse/ClickHouse/pull/36986) ([github-actions[bot]](https://github.com/apps/github-actions)).
* Removing ReplacingWindowColumnTransform in WindowView [#36998](https://github.com/ClickHouse/ClickHouse/pull/36998) ([vxider](https://github.com/Vxider)).
* Merging [#34765](https://github.com/ClickHouse/ClickHouse/issues/34765) [#37002](https://github.com/ClickHouse/ClickHouse/pull/37002) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove CodeQL [#37006](https://github.com/ClickHouse/ClickHouse/pull/37006) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove obsolete code [#37009](https://github.com/ClickHouse/ClickHouse/pull/37009) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Try fix flaky test [#37010](https://github.com/ClickHouse/ClickHouse/pull/37010) ([Nikita Taranov](https://github.com/nickitat)).
* fix output error in LabelsCheck [#37016](https://github.com/ClickHouse/ClickHouse/pull/37016) ([wuxiaobai24](https://github.com/wuxiaobai24)).
* remove useless code [#37020](https://github.com/ClickHouse/ClickHouse/pull/37020) ([flynn](https://github.com/ucasfl)).
* Merging [#34932](https://github.com/ClickHouse/ClickHouse/issues/34932). [#37023](https://github.com/ClickHouse/ClickHouse/pull/37023) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix benchmark build code [#37025](https://github.com/ClickHouse/ClickHouse/pull/37025) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add benchmark script for testing clouds [#37027](https://github.com/ClickHouse/ClickHouse/pull/37027) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky integration mongodb test [#37035](https://github.com/ClickHouse/ClickHouse/pull/37035) ([Kruglov Pavel](https://github.com/Avogar)).
* Print stacks if we cannot terminate server in stress tests [#37052](https://github.com/ClickHouse/ClickHouse/pull/37052) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Remove last mentions of data streams [#37053](https://github.com/ClickHouse/ClickHouse/pull/37053) ([Anton Popov](https://github.com/CurtizJ)).
* Changelog script [#37057](https://github.com/ClickHouse/ClickHouse/pull/37057) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* This evening I started using Grammarly. [#37058](https://github.com/ClickHouse/ClickHouse/pull/37058) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* update sanity checks warning message text [#37063](https://github.com/ClickHouse/ClickHouse/pull/37063) ([Sergei Trifonov](https://github.com/serxa)).
* Continue fixing [#36199](https://github.com/ClickHouse/ClickHouse/issues/36199). [#37071](https://github.com/ClickHouse/ClickHouse/pull/37071) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* just fix a number [#37072](https://github.com/ClickHouse/ClickHouse/pull/37072) ([jiahui-97](https://github.com/jiahui-97)).
* Disable thread fuzzer after server restart [#37079](https://github.com/ClickHouse/ClickHouse/pull/37079) ([alesapin](https://github.com/alesapin)).
* Option to force cross_to_inner_join_rewrite [#37085](https://github.com/ClickHouse/ClickHouse/pull/37085) ([Vladimir C](https://github.com/vdimir)).
* fix wrong argument in proxy resolver of DiskS3 [#37100](https://github.com/ClickHouse/ClickHouse/pull/37100) ([flynn](https://github.com/ucasfl)).
* tests: fix 01119_optimize_trivial_insert_select (due to max_threads randomization) [#37101](https://github.com/ClickHouse/ClickHouse/pull/37101) ([Azat Khuzhin](https://github.com/azat)).
* Support SELECT query in WindowView [#37105](https://github.com/ClickHouse/ClickHouse/pull/37105) ([vxider](https://github.com/Vxider)).
* Fix workflow style check [#37113](https://github.com/ClickHouse/ClickHouse/pull/37113) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add check for columns size in Block::cloneWithColumns [#37124](https://github.com/ClickHouse/ClickHouse/pull/37124) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update documentation and defaults for memory overcommit [#37129](https://github.com/ClickHouse/ClickHouse/pull/37129) ([Dmitry Novik](https://github.com/novikd)).
* Update default remote fs read method in ReadSettings [#37130](https://github.com/ClickHouse/ClickHouse/pull/37130) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update Exception Message for allowed auth types [#37132](https://github.com/ClickHouse/ClickHouse/pull/37132) ([Marcelo Rodriguez](https://github.com/e-mars)).
* tests/integration: fix possible race for iptables user rules inside containers [#37138](https://github.com/ClickHouse/ClickHouse/pull/37138) ([Azat Khuzhin](https://github.com/azat)).
* Fix fasttest ccache permissions [#37143](https://github.com/ClickHouse/ClickHouse/pull/37143) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add const qualifier for few methods from Context [#37154](https://github.com/ClickHouse/ClickHouse/pull/37154) ([Azat Khuzhin](https://github.com/azat)).
* Reload listen_reuse_port/listen_backlog from config [#37156](https://github.com/ClickHouse/ClickHouse/pull/37156) ([Azat Khuzhin](https://github.com/azat)).
* Enable DNS cache for HTTPSClientSession. [#37157](https://github.com/ClickHouse/ClickHouse/pull/37157) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* fix async reads from remote fs internal setting not being always turned on [#37164](https://github.com/ClickHouse/ClickHouse/pull/37164) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backups Improvements 5 [#37168](https://github.com/ClickHouse/ClickHouse/pull/37168) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add S3Requests metric [#37200](https://github.com/ClickHouse/ClickHouse/pull/37200) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix coverity build problem with LD_PRELOAD [#37203](https://github.com/ClickHouse/ClickHouse/pull/37203) ([Boris Kuschel](https://github.com/bkuschel)).
* Relax log level for some checks in check thread [#37208](https://github.com/ClickHouse/ClickHouse/pull/37208) ([alesapin](https://github.com/alesapin)).
* update poco [#37209](https://github.com/ClickHouse/ClickHouse/pull/37209) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Ignore harmful env variables in clickhouse binaries (reexec w/o them) [#37211](https://github.com/ClickHouse/ClickHouse/pull/37211) ([Azat Khuzhin](https://github.com/azat)).
* Fix wrong comment in IVolume.h [#37218](https://github.com/ClickHouse/ClickHouse/pull/37218) ([Sergei Trifonov](https://github.com/serxa)).
* Cmake cleanup pt2 [#37222](https://github.com/ClickHouse/ClickHouse/pull/37222) ([Robert Schulze](https://github.com/rschu1ze)).
* Temporarily fix flaky test `01825_type_json_insert_select.sql` [#37245](https://github.com/ClickHouse/ClickHouse/pull/37245) ([Anton Popov](https://github.com/CurtizJ)).
* Pass need_filter, has_null_map to joinRightColumns [#37256](https://github.com/ClickHouse/ClickHouse/pull/37256) ([Vladimir C](https://github.com/vdimir)).
* Activate more clangtidies [#37259](https://github.com/ClickHouse/ClickHouse/pull/37259) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix docker cleaner in workflows [#37271](https://github.com/ClickHouse/ClickHouse/pull/37271) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* tidy build fix [#37291](https://github.com/ClickHouse/ClickHouse/pull/37291) ([Alexander Gololobov](https://github.com/davenger)).
* Update run-check.py to match PR template, add comments [#37301](https://github.com/ClickHouse/ClickHouse/pull/37301) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Release without prestable [#37306](https://github.com/ClickHouse/ClickHouse/pull/37306) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fixed typos [#37322](https://github.com/ClickHouse/ClickHouse/pull/37322) ([Alexander Gololobov](https://github.com/davenger)).
