---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v22.2.1.2139-prestable FIXME as compared to v22.1.1.2542-prestable

#### New Feature
* (Not ready for production, put into experimental features) Add memory overcommit to `MemoryTracker`. Added `guaranteed` settings for memory limits which represent soft memory limits. In case when hard memory limit is reached, `MemoryTracker` tries to cancel the most overcommited query. New setting `memory_usage_overcommit_max_wait_microseconds` specifies how long queries may wait another query to stop. Closes [#28375](https://github.com/ClickHouse/ClickHouse/issues/28375). [#31182](https://github.com/ClickHouse/ClickHouse/pull/31182) ([Dmitry Novik](https://github.com/novikd)).
* The setting allows a user to provide own deduplication semantic in MergeTree/ReplicatedMergeTree If provided, it's used instead of data digest to generate block ID. So, for example, by providing a unique value for the setting in each INSERT statement, the user can avoid the same inserted data being deduplicated. This closes: [#7461](https://github.com/ClickHouse/ClickHouse/issues/7461). [#32304](https://github.com/ClickHouse/ClickHouse/pull/32304) ([Igor Nikonov](https://github.com/devcrafter)).
* Add support of DEFAULT keyword for INSERT statements. Closes [#6331](https://github.com/ClickHouse/ClickHouse/issues/6331). [#33141](https://github.com/ClickHouse/ClickHouse/pull/33141) ([Andrii Buriachevskyi](https://github.com/0over)).
* Add confidence intervals to ttests. [#33260](https://github.com/ClickHouse/ClickHouse/pull/33260) ([achimbab](https://github.com/achimbab)).
* Allow to create new files on insert for File/S3/HDFS engines. Allow to owerwrite file in HDFS. Throw an exception in attempt to overwrite a file in S3 by default. Throw an exception in attempt to append data to file in formats that have suffix. Closes [#31640](https://github.com/ClickHouse/ClickHouse/issues/31640) Closes [#31622](https://github.com/ClickHouse/ClickHouse/issues/31622) Closes [#23862](https://github.com/ClickHouse/ClickHouse/issues/23862) Closes [#15022](https://github.com/ClickHouse/ClickHouse/issues/15022) Closes [#16674](https://github.com/ClickHouse/ClickHouse/issues/16674). [#33302](https://github.com/ClickHouse/ClickHouse/pull/33302) ([Kruglov Pavel](https://github.com/Avogar)).
* Add `h3ToCenterChild` function. [#33313](https://github.com/ClickHouse/ClickHouse/pull/33313) ([Bharat Nallan](https://github.com/bharatnc)).
* Merge functions for text classification. See [#23271](https://github.com/ClickHouse/ClickHouse/issues/23271). [#33314](https://github.com/ClickHouse/ClickHouse/pull/33314) ([Nikolay Degterinsky](https://github.com/evillique)).
* Implemented meanZTest. [#33354](https://github.com/ClickHouse/ClickHouse/pull/33354) ([achimbab](https://github.com/achimbab)).
* - Add function bitSlice. [#33360](https://github.com/ClickHouse/ClickHouse/pull/33360) ([RogerYK](https://github.com/RogerYK)).
* Add new h3 miscellaneous functions: `edgeLengthKm`,`exactEdgeLengthKm`,`exactEdgeLengthM`,`exactEdgeLengthRads`,`numHexagons`. [#33621](https://github.com/ClickHouse/ClickHouse/pull/33621) ([Bharat Nallan](https://github.com/bharatnc)).
* Add `DEGREES` and `RADIANS` functions. [#33769](https://github.com/ClickHouse/ClickHouse/pull/33769) ([Bharat Nallan](https://github.com/bharatnc)).
* Parameter `--host` can accept multiple hosts. In case of unavailability of one of them, the client will try to connect to the next one. [#33824](https://github.com/ClickHouse/ClickHouse/pull/33824) ([Filippov Denis](https://github.com/DF5HSE)).
* Detect format in clickhouse-local by file name. [#33829](https://github.com/ClickHouse/ClickHouse/pull/33829) ([Kruglov Pavel](https://github.com/Avogar)).
* Add a new method `expire()` in PoolBase which is used to reallocate an invalid object in the pool. [#34076](https://github.com/ClickHouse/ClickHouse/pull/34076) ([lgbo](https://github.com/lgbo-ustc)).
* Add table function `format(format_name, data)`. [#34125](https://github.com/ClickHouse/ClickHouse/pull/34125) ([Kruglov Pavel](https://github.com/Avogar)).
* Allow to create default table engine. [#34187](https://github.com/ClickHouse/ClickHouse/pull/34187) ([Ilya Yatsishin](https://github.com/qoega)).
* `EPHEMERAL` column specifier is added to `CREATE TABLE` query. Closes [#9436](https://github.com/ClickHouse/ClickHouse/issues/9436). [#34424](https://github.com/ClickHouse/ClickHouse/pull/34424) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).

#### Performance Improvement
* For inserts and merges into S3, write files in parallel whenever possible. [#33291](https://github.com/ClickHouse/ClickHouse/pull/33291) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Improve RangeHashedDictionary performance if for key there are a lot of intervals. Fixes [#23821](https://github.com/ClickHouse/ClickHouse/issues/23821). [#33516](https://github.com/ClickHouse/ClickHouse/pull/33516) ([Maksim Kita](https://github.com/kitaisreal)).
* Add x86 avx512 support for memcmpSmall functions to accelerate memory comparison. It works only if you compile ClickHouse by yourself. [#33706](https://github.com/ClickHouse/ClickHouse/pull/33706) ([hanqf-git](https://github.com/hanqf-git)).
* Reworks and reintroduces the scalar cache to MV execution. [#33958](https://github.com/ClickHouse/ClickHouse/pull/33958) ([Raúl Marín](https://github.com/Algunenano)).
* Make ORDER BY tuple almost as fast as ORDER BY columns. We have special optimizations for multiple column ORDER BY: https://github.com/ClickHouse/ClickHouse/pull/10831 . It's beneficial to also apply to tuple columns. [#34060](https://github.com/ClickHouse/ClickHouse/pull/34060) ([Amos Bird](https://github.com/amosbird)).
* Minor improvement to potential hot-path in `ExecuteScalarSubqueriesMatcher::visit` , where `std::set<String>` was constructed on every function invocation. [#34128](https://github.com/ClickHouse/ClickHouse/pull/34128) ([Federico Rodriguez](https://github.com/fedrod)).
* Slightly improve performance of `Regexp` format. [#34202](https://github.com/ClickHouse/ClickHouse/pull/34202) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Optimize quantilesExact{Low,High} to use nth_element instead of sort. [#34287](https://github.com/ClickHouse/ClickHouse/pull/34287) ([Daniel Kutenin](https://github.com/danlark1)).
* Improve performance of `LineAsString` format. This closes [#34303](https://github.com/ClickHouse/ClickHouse/issues/34303). [#34306](https://github.com/ClickHouse/ClickHouse/pull/34306) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Speed up loading of data parts. It was not parallelized before: the setting `part_loading_threads` did not have effect. See [#4699](https://github.com/ClickHouse/ClickHouse/issues/4699). [#34310](https://github.com/ClickHouse/ClickHouse/pull/34310) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `_file` and `_path` virtual columns (in file-like table engines) are made `LowCardinality` - it will make queries for multiple files faster. Closes [#34300](https://github.com/ClickHouse/ClickHouse/issues/34300). [#34317](https://github.com/ClickHouse/ClickHouse/pull/34317) ([flynn](https://github.com/ucasfl)).
* Improve performance of `mapPopulateSeries` function. Closes [#33944](https://github.com/ClickHouse/ClickHouse/issues/33944). [#34318](https://github.com/ClickHouse/ClickHouse/pull/34318) ([Maksim Kita](https://github.com/kitaisreal)).
* Use a vector to collect useless list iterators when doing a snapshot, and in latter clearOutdatedNodes, we can just traverse the vector, not the list, which is faster. [#34484](https://github.com/ClickHouse/ClickHouse/pull/34484) ([zhanglistar](https://github.com/zhanglistar)).
* Improve performance of insert into table functions URL, S3, File, HDFS. Closes [#34348](https://github.com/ClickHouse/ClickHouse/issues/34348). [#34510](https://github.com/ClickHouse/ClickHouse/pull/34510) ([Maksim Kita](https://github.com/kitaisreal)).
* According https://github.com/eBay/NuRaft/issues/209, there is no need to lock the mothod. [#34523](https://github.com/ClickHouse/ClickHouse/pull/34523) ([zhanglistar](https://github.com/zhanglistar)).

#### Improvement
* Now ReplicatedMergeTree can recover data when some of its disks are broken. [#13544](https://github.com/ClickHouse/ClickHouse/pull/13544) ([Amos Bird](https://github.com/amosbird)).
* Dynamic reload of server TLS certificates on config reload. Closes [#15764](https://github.com/ClickHouse/ClickHouse/issues/15764). [#15765](https://github.com/ClickHouse/ClickHouse/pull/15765) ([johnskopis](https://github.com/johnskopis)).
* Merge [#15765](https://github.com/ClickHouse/ClickHouse/issues/15765) (Dynamic reload of server TLS certificates on config reload) cc @johnskopis. [#31257](https://github.com/ClickHouse/ClickHouse/pull/31257) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Added `UUID` data type support for functions `hex`, `bin`. [#32170](https://github.com/ClickHouse/ClickHouse/pull/32170) ([Frank Chen](https://github.com/FrankChen021)).
* Support `optimize_read_in_order` if prefix of sorting key is already sorted. E.g. if we have sorting key `ORDER BY (a, b)` in table and query with `WHERE a = const ORDER BY b` clauses, now it will be applied reading in order of sorting key instead of full sort. [#32748](https://github.com/ClickHouse/ClickHouse/pull/32748) ([Anton Popov](https://github.com/CurtizJ)).
* Add new keeper setting `min_session_timeout_ms`. Now keeper server will determine client session timeout according to `min_session_timeout_ms` and `session_timeout_ms` settings. [#33288](https://github.com/ClickHouse/ClickHouse/pull/33288) ([JackyWoo](https://github.com/JackyWoo)).
* Improve keeper performance and fix several memory leaks. [#33329](https://github.com/ClickHouse/ClickHouse/pull/33329) ([alesapin](https://github.com/alesapin)).
* Respect cgroup limits for CPU quota. [#33342](https://github.com/ClickHouse/ClickHouse/pull/33342) ([JaySon](https://github.com/JaySon-Huang)).
* Enable binary arithmetic(plus, minus, multiply, division, least, greates) between Decimal and Float. [#33355](https://github.com/ClickHouse/ClickHouse/pull/33355) ([flynn](https://github.com/ucasfl)).
* Replace `_shard_num` via constants (from [#7624](https://github.com/ClickHouse/ClickHouse/issues/7624)) with `shardNum()` function (from [#27020](https://github.com/ClickHouse/ClickHouse/issues/27020)), to avoid possible issues (like those that had been found in [#16947](https://github.com/ClickHouse/ClickHouse/issues/16947)). [#33392](https://github.com/ClickHouse/ClickHouse/pull/33392) ([Azat Khuzhin](https://github.com/azat)).
* Support `SET`, `YEAR`, `TIME` and `GEOMETRY` data types in `MaterializedMySQL`. Fixes [#18091](https://github.com/ClickHouse/ClickHouse/issues/18091), [#21536](https://github.com/ClickHouse/ClickHouse/issues/21536), [#26361](https://github.com/ClickHouse/ClickHouse/issues/26361). [#33429](https://github.com/ClickHouse/ClickHouse/pull/33429) ([zzsmdfj](https://github.com/zzsmdfj)).
* add function addressToLineWithInlines. Close [#26211](https://github.com/ClickHouse/ClickHouse/issues/26211). [#33467](https://github.com/ClickHouse/ClickHouse/pull/33467) ([SuperDJY](https://github.com/cmsxbc)).
* Improvement for `fromUnixTimestamp64` family functions.. They now accept any integer value that can be converted to `Int64`. This closes: [#14648](https://github.com/ClickHouse/ClickHouse/issues/14648). [#33505](https://github.com/ClickHouse/ClickHouse/pull/33505) ([Andrey Zvonov](https://github.com/zvonand)).
* Functions `dictGet`, `dictHas` implicitly cast key argument to dictionary key structure, if they are different. [#33672](https://github.com/ClickHouse/ClickHouse/pull/33672) ([Maksim Kita](https://github.com/kitaisreal)).
* - Parse and store OpenTelemetry trace-id in big-endian order. [#33723](https://github.com/ClickHouse/ClickHouse/pull/33723) ([Frank Chen](https://github.com/FrankChen021)).
* Enable stream to table join in WindowView. [#33729](https://github.com/ClickHouse/ClickHouse/pull/33729) ([vxider](https://github.com/Vxider)).
* Create parent directories in DiskS3::restoreFileOperations method. [#33730](https://github.com/ClickHouse/ClickHouse/pull/33730) ([ianton-ru](https://github.com/ianton-ru)).
* Add some improvements and fixes for Bool data type. Fixes [#33244](https://github.com/ClickHouse/ClickHouse/issues/33244). [#33737](https://github.com/ClickHouse/ClickHouse/pull/33737) ([Kruglov Pavel](https://github.com/Avogar)).
* Added support for cast from `Map(Key, Value)` to `Array(Tuple(Key, Value))`. [#33794](https://github.com/ClickHouse/ClickHouse/pull/33794) ([Maksim Kita](https://github.com/kitaisreal)).
* Support explain create function query ``` sql :) explain ast create function mycast AS (n) -> cast(n as String); EXPLAIN AST CREATE FUNCTION mycast AS n -> CAST(n, 'String'). [#33819](https://github.com/ClickHouse/ClickHouse/pull/33819) ([李扬](https://github.com/taiyang-li)).
* Try every resolved ip address while getting S3 proxy. [#33862](https://github.com/ClickHouse/ClickHouse/pull/33862) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* `FlatDictionary` improve performance of dictionary data load. [#33871](https://github.com/ClickHouse/ClickHouse/pull/33871) ([Maksim Kita](https://github.com/kitaisreal)).
* fix disk using the same path, close [#29072](https://github.com/ClickHouse/ClickHouse/issues/29072). [#33905](https://github.com/ClickHouse/ClickHouse/pull/33905) ([zhongyuankai](https://github.com/zhongyuankai)).
* Dictionaries added support for DateTime64. [#33914](https://github.com/ClickHouse/ClickHouse/pull/33914) ([Maksim Kita](https://github.com/kitaisreal)).
* `FlatDictionary`, `HashedDictionary`, `HashedArrayDictionary` added support for creating with empty attributes, with support of read all keys, and `dictHas`. Fixes [#33820](https://github.com/ClickHouse/ClickHouse/issues/33820). [#33918](https://github.com/ClickHouse/ClickHouse/pull/33918) ([Maksim Kita](https://github.com/kitaisreal)).
* `RangeHashedDictionary` improvements. Improve performance of load time if there are multiple attributes. Allow to create without attributes. Added option to specify strategy when intervals `start` and `end` have `Nullable` type `convert_null_range_bound_to_open` by default is `true`. Closes [#29791](https://github.com/ClickHouse/ClickHouse/issues/29791). Allow to specify `Float`, `Decimal`, `DateTime64`, `Int128`, `Int256`, `UInt128`, `UInt256` as range types. `RangeHashedDictionary` added support for range values that extend `Int64` type. Closes [#28322](https://github.com/ClickHouse/ClickHouse/issues/28322). Added option `range_lookup_strategy` to specify range lookup type `min`, `max` by default is `min` . Closes [#21647](https://github.com/ClickHouse/ClickHouse/issues/21647). Fixed allocated bytes calculations. Fixed type name in `system.dictionaries` in case of `ComplexKeyHashedDictionary`. [#33927](https://github.com/ClickHouse/ClickHouse/pull/33927) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix getauxval() in glibc-compatibility, this should fix vsyscalls after `setenv` (i.e. timezone is set in config), and LSan (and also fix some leaks that had been found by LSan). [#33957](https://github.com/ClickHouse/ClickHouse/pull/33957) ([Azat Khuzhin](https://github.com/azat)).
* Detect format and schema from stdin in clickhouse-local. [#33960](https://github.com/ClickHouse/ClickHouse/pull/33960) ([Kruglov Pavel](https://github.com/Avogar)).
* Fixed UTF-8 string case-insensitive search when lowercase and uppercase characters are represented by different number of bytes. Example is `ẞ` and `ß`. This closes [#7334](https://github.com/ClickHouse/ClickHouse/issues/7334). [#33992](https://github.com/ClickHouse/ClickHouse/pull/33992) ([Harry Lee](https://github.com/HarryLeeIBM)).
* Fix memory accounting for queries that uses < max_untracker_memory. [#34001](https://github.com/ClickHouse/ClickHouse/pull/34001) ([Azat Khuzhin](https://github.com/azat)).
* Supports all types of SYSTEM query ON CLUSTER clause. [#34005](https://github.com/ClickHouse/ClickHouse/pull/34005) ([小路](https://github.com/nicelulu)).
* Add schema inference for values() table function. Closes [#33811](https://github.com/ClickHouse/ClickHouse/issues/33811). [#34017](https://github.com/ClickHouse/ClickHouse/pull/34017) ([Kruglov Pavel](https://github.com/Avogar)).
* Tracing context is now propagated from GRPC client metadata. [#34064](https://github.com/ClickHouse/ClickHouse/pull/34064) ([andremarianiello](https://github.com/andremarianiello)).
* Add UUID suport in MsgPack input/output format. [#34065](https://github.com/ClickHouse/ClickHouse/pull/34065) ([Kruglov Pavel](https://github.com/Avogar)).
* Improving the experience of multiple line editing for clickhouse-client. This is a follow-up of https://github.com/ClickHouse/ClickHouse/pull/31123. [#34114](https://github.com/ClickHouse/ClickHouse/pull/34114) ([Amos Bird](https://github.com/amosbird)).
* Maxsplit argument for splitByChar. close [#34081](https://github.com/ClickHouse/ClickHouse/issues/34081). [#34140](https://github.com/ClickHouse/ClickHouse/pull/34140) ([李扬](https://github.com/taiyang-li)).
* Allow to parse dictionary `PRIMARY KEY` as `PRIMARY KEY (id, value)`, previously supported only `PRIMARY KEY id, value`. Closes [#34135](https://github.com/ClickHouse/ClickHouse/issues/34135). [#34141](https://github.com/ClickHouse/ClickHouse/pull/34141) ([Maksim Kita](https://github.com/kitaisreal)).
* Allow carriage return in the middle of the line while parsing by `Regexp` format. This closes [#34200](https://github.com/ClickHouse/ClickHouse/issues/34200). [#34205](https://github.com/ClickHouse/ClickHouse/pull/34205) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Recognize `YYYYMMDD-hhmmss` format in `parseDateTimeBestEffort` function. This closes [#34206](https://github.com/ClickHouse/ClickHouse/issues/34206). [#34208](https://github.com/ClickHouse/ClickHouse/pull/34208) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add ability to compose PostgreSQL-style cast operator `::` with `ArrayElement` and `TupleElement`. [#34229](https://github.com/ClickHouse/ClickHouse/pull/34229) ([Nikolay Degterinsky](https://github.com/evillique)).
* Added `#!` and `# ` as a recognised start of a single line comment. Reference to task [#34138](https://github.com/ClickHouse/ClickHouse/issues/34138). [#34230](https://github.com/ClickHouse/ClickHouse/pull/34230) ([Aaron Katz](https://github.com/aaronstephenkatz)).
* Change severity of the "Cancelled merging parts" message in logs, because it's not an error. This closes [#34148](https://github.com/ClickHouse/ClickHouse/issues/34148). [#34232](https://github.com/ClickHouse/ClickHouse/pull/34232) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Apply data skipping indexes for queries with FINAL may produce incorrect result. Disable data skipping indexes by default for queries with FINAL (introduce new `use_skip_indexes_if_final` setting and disable it by default). [#34243](https://github.com/ClickHouse/ClickHouse/pull/34243) ([Azat Khuzhin](https://github.com/azat)).
* Support asynchronous inserts in `clickhouse-client` for queries with inlined data. [#34267](https://github.com/ClickHouse/ClickHouse/pull/34267) ([Anton Popov](https://github.com/CurtizJ)).
* Cancel merges before acquiring table lock for `TRUNCATE` query to avoid `DEADLOCK_AVOIDED` error in some cases. Fixes [#34302](https://github.com/ClickHouse/ClickHouse/issues/34302). [#34304](https://github.com/ClickHouse/ClickHouse/pull/34304) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Some servers expect a User-Agent header in their HTTP requests. A `User-Agent` header entry has been added to HTTP requests of the form: User-Agent: ClickHouse/VERSION_STRING. [#34330](https://github.com/ClickHouse/ClickHouse/pull/34330) ([Saad Ur Rahman](https://github.com/surahman)).
* REGEXP_MATCHES and REGEXP_REPLACE function aliases for compatibility with PostgreSQL. Close [#30885](https://github.com/ClickHouse/ClickHouse/issues/30885). [#34334](https://github.com/ClickHouse/ClickHouse/pull/34334) ([李扬](https://github.com/taiyang-li)).
* Better handle pre-inputs before client start. This is for [#34308](https://github.com/ClickHouse/ClickHouse/issues/34308) . [#34336](https://github.com/ClickHouse/ClickHouse/pull/34336) ([Amos Bird](https://github.com/amosbird)).
* Add options for clickhouse-format. Which close [#30528](https://github.com/ClickHouse/ClickHouse/issues/30528) - max_query_size - max_parser_depth. [#34349](https://github.com/ClickHouse/ClickHouse/pull/34349) ([李扬](https://github.com/taiyang-li)).
* Default input and output formats that can be overriden by --input-format and --output-format. Close [#30631](https://github.com/ClickHouse/ClickHouse/issues/30631). [#34352](https://github.com/ClickHouse/ClickHouse/pull/34352) ([李扬](https://github.com/taiyang-li)).
* Allow to skip not found urls for globs when using URL storage / table function. Also closes [#34359](https://github.com/ClickHouse/ClickHouse/issues/34359). [#34392](https://github.com/ClickHouse/ClickHouse/pull/34392) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add two new settings: `s3_upload_part_size_multiply_factor` and `s3_upload_part_size_multiply_parts_count_threshold`. Now each time `s3_upload_part_size_multiply_parts_count_threshold` uploaded to S3 from a single query `s3_min_upload_part_size` multiplied by `s3_upload_part_size_multiply_factor`. Fixes [#34244](https://github.com/ClickHouse/ClickHouse/issues/34244). [#34422](https://github.com/ClickHouse/ClickHouse/pull/34422) ([alesapin](https://github.com/alesapin)).
* Allow `allow_experimental_projection_optimization` by default. [#34456](https://github.com/ClickHouse/ClickHouse/pull/34456) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Privileges CREATE/ALTER/DROP ROW POLICY now can be granted on a table or on `database.*` as well as globally `*.*`. [#34489](https://github.com/ClickHouse/ClickHouse/pull/34489) ([Vitaly Baranov](https://github.com/vitlibar)).
* Refactor client fault tolerant connection (https://github.com/ClickHouse/ClickHouse/pull/33824#issuecomment-1033690860). The new way to use it: ```bash clickhouse-client ... --host host1 --host host2 --port port2 --host host3 --port port --host host4 ```. [#34490](https://github.com/ClickHouse/ClickHouse/pull/34490) ([Kruglov Pavel](https://github.com/Avogar)).
* Improve schema inference in clickhouse-local. Allow to write just `clickhouse-local -q "select * from table" < data.format`. [#34495](https://github.com/ClickHouse/ClickHouse/pull/34495) ([Kruglov Pavel](https://github.com/Avogar)).
* Support `.jsonl` extension for JSONEachRow format. [#34496](https://github.com/ClickHouse/ClickHouse/pull/34496) ([Kruglov Pavel](https://github.com/Avogar)).
* Send ProfileEvents statistics in case of INSERT SELECT query. [#34498](https://github.com/ClickHouse/ClickHouse/pull/34498) ([Dmitry Novik](https://github.com/novikd)).
* Added sending of the output format back to client like it's done in HTTP protocol as suggested in [#34362](https://github.com/ClickHouse/ClickHouse/issues/34362). Closes [#34362](https://github.com/ClickHouse/ClickHouse/issues/34362). [#34499](https://github.com/ClickHouse/ClickHouse/pull/34499) ([Vitaly Baranov](https://github.com/vitlibar)).
* Allow to write `s3(url, access_key_id, secret_access_key)`. [#34503](https://github.com/ClickHouse/ClickHouse/pull/34503) ([Kruglov Pavel](https://github.com/Avogar)).
* Support `IF EXISTS` clause for `TTL expr TO [DISK|VOLUME] [IF EXISTS] 'xxx'` feature. Parts will be moved to disk or volume only if it exists on replica, so `MOVE TTL` rules will be able to behave differently on replicas according to the existing storage policies. Resolves [#34455](https://github.com/ClickHouse/ClickHouse/issues/34455). [#34504](https://github.com/ClickHouse/ClickHouse/pull/34504) ([Anton Popov](https://github.com/CurtizJ)).
* Little improvement no need to clone log entry. [#34587](https://github.com/ClickHouse/ClickHouse/pull/34587) ([zhanglistar](https://github.com/zhanglistar)).
* Slightly improve performance in case of filtering by sparse columns (which can be enabled by setting `ratio_of_defaults_for_sparse_serialization` in `MergeTree` tables). [#34601](https://github.com/ClickHouse/ClickHouse/pull/34601) ([Anton Popov](https://github.com/CurtizJ)).

#### Bug Fix
* This PR allows using multiple LDAP storages in the same list of user directories. It worked earlier but was broken because LDAP tests are disabled (they are part of the testflows tests). [#33574](https://github.com/ClickHouse/ClickHouse/pull/33574) ([Vitaly Baranov](https://github.com/vitlibar)).
* This PR fixes [#18206](https://github.com/ClickHouse/ClickHouse/issues/18206). [#33977](https://github.com/ClickHouse/ClickHouse/pull/33977) ([Vitaly Baranov](https://github.com/vitlibar)).
* This PR fixes [#19429](https://github.com/ClickHouse/ClickHouse/issues/19429). [#34225](https://github.com/ClickHouse/ClickHouse/pull/34225) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix inserting to temporary tables via gRPC. This PR fixes [#34347](https://github.com/ClickHouse/ClickHouse/issues/34347), issue `#2`. [#34364](https://github.com/ClickHouse/ClickHouse/pull/34364) ([Vitaly Baranov](https://github.com/vitlibar)).
* add HashMethodSingleLowCardinalityColumn::findKey, avoid crash. [#34506](https://github.com/ClickHouse/ClickHouse/pull/34506) ([DR](https://github.com/freedomDR)).

#### Build/Testing/Packaging Improvement
* Add action for published releases. [#32218](https://github.com/ClickHouse/ClickHouse/pull/32218) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Remove unbundled support. [#33690](https://github.com/ClickHouse/ClickHouse/pull/33690) ([Azat Khuzhin](https://github.com/azat)).
* Some improvement over current build system. [#33695](https://github.com/ClickHouse/ClickHouse/pull/33695) ([Amos Bird](https://github.com/amosbird)).
* Removed "Yandex ClickHouse" terms from descriptions. Change to default mirrors for packages. [#33745](https://github.com/ClickHouse/ClickHouse/pull/33745) ([Ilya Yatsishin](https://github.com/qoega)).
* - Fix unconditional `--build-arg FROM_TAG=` docker argument - Add some tests for docker tests/ci. [#33751](https://github.com/ClickHouse/ClickHouse/pull/33751) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Disable dh_update_autotools_config that updates config.guess/config.sub in sources directory on build. It will be more deterministic in terms of different build hosts used as config.guess is provided with sources. [#33752](https://github.com/ClickHouse/ClickHouse/pull/33752) ([Ilya Yatsishin](https://github.com/qoega)).
* clickhouse-test.deb is not used in stateless CI checks. [#33948](https://github.com/ClickHouse/ClickHouse/pull/33948) ([Ilya Yatsishin](https://github.com/qoega)).
* - Add on-demand style-checker-aarch64 hosts - Run dockerpush CI jobs there. [#33954](https://github.com/ClickHouse/ClickHouse/pull/33954) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add back the missing `-Werror` flag globally. This fixes https://github.com/ClickHouse/ClickHouse/pull/33940#issuecomment-1020466537. [#33970](https://github.com/ClickHouse/ClickHouse/pull/33970) ([Amos Bird](https://github.com/amosbird)).
* Separate base parts out of SystemLog. Common code can use system log without fully linking to Interpreters. This helps with errors like https://s3.amazonaws.com/clickhouse-builds/33970/49b229f9c781854861254350d3407f209fb99dfd/binary_splitted/build_log.log. [#33978](https://github.com/ClickHouse/ClickHouse/pull/33978) ([Amos Bird](https://github.com/amosbird)).
* Fix broken dependencies tree building, improve tests. [#33983](https://github.com/ClickHouse/ClickHouse/pull/33983) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* - Add get_with_retries to a download helper - Use it un PRInfo class - Replace `labels_from_api` by `pr_event_from_api` - Use it in description check to have always actual body and labels. [#34012](https://github.com/ClickHouse/ClickHouse/pull/34012) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* - Fix style check for tags_stable.yml - Run StyleCheck always in PR - Mark `Run Check` as failed only for some cases. [#34283](https://github.com/ClickHouse/ClickHouse/pull/34283) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add verbosity to a style check. [#34289](https://github.com/ClickHouse/ClickHouse/pull/34289) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix previously wrong OK_SKIP_LABELS in run_check.py. [#34340](https://github.com/ClickHouse/ClickHouse/pull/34340) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* - Migrate docker images from Moscow timezone to UTC - Update ubuntu version for performance comparison from 18.04 to 20.04. [#34373](https://github.com/ClickHouse/ClickHouse/pull/34373) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Ensure that tests don't depend on the result of non-stable sorting of equal elements. Added equal items ranges randomization in debug after sort to prevent issues when we rely on equal items sort order. [#34393](https://github.com/ClickHouse/ClickHouse/pull/34393) ([Maksim Kita](https://github.com/kitaisreal)).
* - Rebuild docker images on a daily base - Add `--all` flag to rebuild all images - Add `only_amd64` parameter for some images - Revert all workarounds for `only_amd64` images - Fix all broken images. [#34492](https://github.com/ClickHouse/ClickHouse/pull/34492) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix broken Hadoop tests after updated paths in an image. [#34556](https://github.com/ClickHouse/ClickHouse/pull/34556) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* I test compile ClickHouse without HDFS but failed, because the code in DiskHDFS doesn`t judge whether use HDFS. [#34573](https://github.com/ClickHouse/ClickHouse/pull/34573) ([zxealous](https://github.com/zxealous)).
* Set timeout 40 minutes for fast tests. [#34614](https://github.com/ClickHouse/ClickHouse/pull/34614) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Reverts ClickHouse/ClickHouse[#34614](https://github.com/ClickHouse/ClickHouse/issues/34614). [#34622](https://github.com/ClickHouse/ClickHouse/pull/34622) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* - Rework version_helper, make it executable - Reimplement StorageSystemContributors.sh in version_helper - Create a release script. [#34641](https://github.com/ClickHouse/ClickHouse/pull/34641) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* - Fix path in workflows/release.yml - To be backported to branch 22.1. [#34646](https://github.com/ClickHouse/ClickHouse/pull/34646) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### Bug Fix (user-visible misbehaviour in official stable release)

* Fix lz4 compression for output. Closes [#31421](https://github.com/ClickHouse/ClickHouse/issues/31421). [#31862](https://github.com/ClickHouse/ClickHouse/pull/31862) ([Kruglov Pavel](https://github.com/Avogar)).
* Create a function escapeForLDAPFilter and use it to escape characters '(' and ')' in a final_user_dn variable. [#33401](https://github.com/ClickHouse/ClickHouse/pull/33401) ([IlyaTsoi](https://github.com/IlyaTsoi)).
* TODO. [#33492](https://github.com/ClickHouse/ClickHouse/pull/33492) ([huzhichengdd](https://github.com/huzhichengdd)).
* Fix error `Bad cast from type ... to DB::DataTypeArray` which may happen when table has `Nested` column with dots in name, and default value is generated for it (e.g. during insert, when column is not listed). Continuation of [#28762](https://github.com/ClickHouse/ClickHouse/issues/28762). [#33588](https://github.com/ClickHouse/ClickHouse/pull/33588) ([Alexey Pavlenko](https://github.com/alexeypavlenko)).
* Fix `Chunk should have AggregatedChunkInfo in GroupingAggregatedTransform` (in case of `optimize_aggregation_in_order=1`). [#33637](https://github.com/ClickHouse/ClickHouse/pull/33637) ([Azat Khuzhin](https://github.com/azat)).
* Fix bug in zero copy replication which lead to data duplication in case of TTL move. Fixes [#33643](https://github.com/ClickHouse/ClickHouse/issues/33643). [#33642](https://github.com/ClickHouse/ClickHouse/pull/33642) ([alesapin](https://github.com/alesapin)).
* Allow some queries with sorting, LIMIT BY, ARRAY JOIN and lambda functions. This closes [#7462](https://github.com/ClickHouse/ClickHouse/issues/7462). [#33675](https://github.com/ClickHouse/ClickHouse/pull/33675) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Correctly determine current database if `CREATE TEMPORARY TABLE AS SELECT` is queried inside a named HTTP session. This is a very rare use case. This closes [#8340](https://github.com/ClickHouse/ClickHouse/issues/8340). [#33676](https://github.com/ClickHouse/ClickHouse/pull/33676) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix mutation when table contains projections. This fixes [#33010](https://github.com/ClickHouse/ClickHouse/issues/33010) . This fixes [#33275](https://github.com/ClickHouse/ClickHouse/issues/33275) . [#33679](https://github.com/ClickHouse/ClickHouse/pull/33679) ([Amos Bird](https://github.com/amosbird)).
* Throw exception when storage hdfs list directory failed. [#33724](https://github.com/ClickHouse/ClickHouse/pull/33724) ([LiuNeng](https://github.com/liuneng1994)).
* Fix tiny race between count() and INSERT/merges/... in MergeTree (it is possible to return incorrect number of rows for SELECT with optimize_trivial_count_query). [#33753](https://github.com/ClickHouse/ClickHouse/pull/33753) ([Azat Khuzhin](https://github.com/azat)).
* Fix bug of check table when creating data part with wide format and projection. [#33774](https://github.com/ClickHouse/ClickHouse/pull/33774) ([李扬](https://github.com/taiyang-li)).
* Fix parsing query INSERT INTO ... VALUES SETTINGS ... (...), ... [#33776](https://github.com/ClickHouse/ClickHouse/pull/33776) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix bug in client that led to 'Connection reset by peer' in server. Closes [#33309](https://github.com/ClickHouse/ClickHouse/issues/33309). [#33790](https://github.com/ClickHouse/ClickHouse/pull/33790) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix usage of external dictionaries with `Redis` source and large number of keys. [#33804](https://github.com/ClickHouse/ClickHouse/pull/33804) ([Anton Popov](https://github.com/CurtizJ)).
* Fix schema inference for JSONEachRow and JSONCompactEachRow. [#33830](https://github.com/ClickHouse/ClickHouse/pull/33830) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix KeyCondition with no common types available. [#33833](https://github.com/ClickHouse/ClickHouse/pull/33833) ([Amos Bird](https://github.com/amosbird)).
* Fix memory leak in `clickhouse-keeper` in case of compression is used (default). [#33840](https://github.com/ClickHouse/ClickHouse/pull/33840) ([Azat Khuzhin](https://github.com/azat)).
* Fixed `replica is not readonly` logical error on `SYSTEM RESTORE REPLICA` query when replica is actually readonly. Fixes [#33806](https://github.com/ClickHouse/ClickHouse/issues/33806). [#33847](https://github.com/ClickHouse/ClickHouse/pull/33847) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix usage of sparse columns (which can be enabled by experimental setting `ratio_of_defaults_for_sparse_serialization`). [#33849](https://github.com/ClickHouse/ClickHouse/pull/33849) ([Anton Popov](https://github.com/CurtizJ)).
* Fix crash if sql user defined function is created with lambda with non identifier arguments. Closes [#33866](https://github.com/ClickHouse/ClickHouse/issues/33866). [#33868](https://github.com/ClickHouse/ClickHouse/pull/33868) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix potential race condition when doing remote disk read. cc @Jokser. [#33912](https://github.com/ClickHouse/ClickHouse/pull/33912) ([Amos Bird](https://github.com/amosbird)).
* Aggregate function combinator `-If` did not correctly process `Nullable` filter argument. This closes [#27073](https://github.com/ClickHouse/ClickHouse/issues/27073). [#33920](https://github.com/ClickHouse/ClickHouse/pull/33920) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix parsing ZK metadata: now metadata from zookeeper compared with local metadata in canonical form. [#33933](https://github.com/ClickHouse/ClickHouse/pull/33933) ([sunny](https://github.com/sunny19930321)).
* Fix usage of functions `array` and `tuple` with literal arguments in distributed queries. Previously it could lead to `Not found columns` exception. [#33938](https://github.com/ClickHouse/ClickHouse/pull/33938) ([Anton Popov](https://github.com/CurtizJ)).
* Fix crash while reading of nested tuples. Fixes [#33838](https://github.com/ClickHouse/ClickHouse/issues/33838). [#33956](https://github.com/ClickHouse/ClickHouse/pull/33956) ([Anton Popov](https://github.com/CurtizJ)).
* Fix parsing IPv6 from query parameter and fix IPv6 to string conversion. Closes [#33928](https://github.com/ClickHouse/ClickHouse/issues/33928). [#33971](https://github.com/ClickHouse/ClickHouse/pull/33971) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix segfault while parsing ORC file with corrupted footer. Closes [#33797](https://github.com/ClickHouse/ClickHouse/issues/33797). [#33984](https://github.com/ClickHouse/ClickHouse/pull/33984) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix bug which lead to inability for server to start when both replicated access storage and keeper are used. Introduced two settings for keeper socket timeout instead of settings from default user: `keeper_server.socket_receive_timeout_sec` and `keeper_server.socket_send_timeout_sec`. Fixes [#33973](https://github.com/ClickHouse/ClickHouse/issues/33973). [#33988](https://github.com/ClickHouse/ClickHouse/pull/33988) ([alesapin](https://github.com/alesapin)).
* - Fixes `parallel_view_processing=0` not working when inserting into a table using `VALUES`. - Fixes `view_duration_ms` in the `query_views_log` not being set correctly for materialized views. [#34067](https://github.com/ClickHouse/ClickHouse/pull/34067) ([Raúl Marín](https://github.com/Algunenano)).
* Fix asynchronous inserts with `Native` format. [#34068](https://github.com/ClickHouse/ClickHouse/pull/34068) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed minor race condition that might cause "intersecting parts" error in extremely rare cases after ZooKeeper connection loss. [#34096](https://github.com/ClickHouse/ClickHouse/pull/34096) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix possible data race in StorageFile that was introduced in https://github.com/ClickHouse/ClickHouse/pull/33960. Closes [#34111](https://github.com/ClickHouse/ClickHouse/issues/34111). [#34113](https://github.com/ClickHouse/ClickHouse/pull/34113) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix inserts to distributed tables in case of change of native protocol. The last change was in the version version 22.1, so there may be some failures of inserts to distributed tables after upgrade to that version. [#34132](https://github.com/ClickHouse/ClickHouse/pull/34132) ([Anton Popov](https://github.com/CurtizJ)).
* Fix bug which can rarely lead to error "Cannot read all data" while reading LowCardinality columns of MergeTree table engines family which stores data on remote file system like S3. [#34139](https://github.com/ClickHouse/ClickHouse/pull/34139) ([alesapin](https://github.com/alesapin)).
* Fix rare and benign race condition in `HDFS`, `S3` and `URL` storage engines which can lead to additional connections. [#34172](https://github.com/ClickHouse/ClickHouse/pull/34172) ([alesapin](https://github.com/alesapin)).
* Fix schema inference for table runction s3. [#34186](https://github.com/ClickHouse/ClickHouse/pull/34186) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix metric `Query`, which shows number of executing queries. In last several releases it was always 0. [#34224](https://github.com/ClickHouse/ClickHouse/pull/34224) ([Anton Popov](https://github.com/CurtizJ)).
* Fix reading of subcolumns with dots in their names. In particular fixed reading of `Nested` columns, if their element names contain dots (e.g ```Nested(`keys.name` String, `keys.id` UInt64, values UInt64)```). [#34228](https://github.com/ClickHouse/ClickHouse/pull/34228) ([Anton Popov](https://github.com/CurtizJ)).
* Fix memory leak in case of some Exception during query processing with `optimize_aggregation_in_order=1`. [#34234](https://github.com/ClickHouse/ClickHouse/pull/34234) ([Azat Khuzhin](https://github.com/azat)).
* Fix current_user/current_address for interserver mode (Before this patch current_user/current_address will be preserved from the previous query). [#34263](https://github.com/ClickHouse/ClickHouse/pull/34263) ([Azat Khuzhin](https://github.com/azat)).
* Fix progress bar width. It was incorrectly rounded to integer number of characters. [#34275](https://github.com/ClickHouse/ClickHouse/pull/34275) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed a couple of extremely rare race conditions that might lead to broken state of replication queue and "intersecting parts" error. [#34297](https://github.com/ClickHouse/ClickHouse/pull/34297) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix various issues when projection is enabled by default. Each issue is described in separate commit. This is for [#33678](https://github.com/ClickHouse/ClickHouse/issues/33678) . This fixes [#34273](https://github.com/ClickHouse/ClickHouse/issues/34273). [#34305](https://github.com/ClickHouse/ClickHouse/pull/34305) ([Amos Bird](https://github.com/amosbird)).
* Try to fix rare bug while reading of empty arrays, which could lead to `Data compressed with different methods` error. [#34327](https://github.com/ClickHouse/ClickHouse/pull/34327) ([Anton Popov](https://github.com/CurtizJ)).
* Fix wrong engine syntax in result of `SHOW CREATE DATABASE` query for databases with engine `Memory`. This closes [#34335](https://github.com/ClickHouse/ClickHouse/issues/34335). [#34345](https://github.com/ClickHouse/ClickHouse/pull/34345) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* For SQLUserDefinedFunctions change privilege level from DATABASE to GLOBAL. Closes [#34281](https://github.com/ClickHouse/ClickHouse/issues/34281). [#34404](https://github.com/ClickHouse/ClickHouse/pull/34404) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix segfault in schema inference from url. Closes [#34147](https://github.com/ClickHouse/ClickHouse/issues/34147). [#34405](https://github.com/ClickHouse/ClickHouse/pull/34405) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix possible error 'Cannot convert column Function to mask' in short circuit function evaluation. Closes [#34171](https://github.com/ClickHouse/ClickHouse/issues/34171). [#34415](https://github.com/ClickHouse/ClickHouse/pull/34415) ([Kruglov Pavel](https://github.com/Avogar)).
* Add missing lock for storage. Fixes possible race with table deletion. [#34416](https://github.com/ClickHouse/ClickHouse/pull/34416) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix possible error 'file_size: Operation not supported'. [#34479](https://github.com/ClickHouse/ClickHouse/pull/34479) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix compression support in URL engine. [#34524](https://github.com/ClickHouse/ClickHouse/pull/34524) ([Frank Chen](https://github.com/FrankChen021)).
* Fix comparison between integers and floats in index analysis. Previously it could lead to skipping some granules for reading by mistake. Fixes [#34493](https://github.com/ClickHouse/ClickHouse/issues/34493). [#34528](https://github.com/ClickHouse/ClickHouse/pull/34528) ([Anton Popov](https://github.com/CurtizJ)).
* Fix exception `Chunk should have AggregatedChunkInfo in MergingAggregatedTransform` (in case of `optimize_aggregation_in_order=1` and `distributed_aggregation_memory_efficient=0`). Fixes [#34526](https://github.com/ClickHouse/ClickHouse/issues/34526). [#34532](https://github.com/ClickHouse/ClickHouse/pull/34532) ([Anton Popov](https://github.com/CurtizJ)).
* In case of cancelation S3 and HDFS canceled only current reader, but continued to execute the initial query. Fixes [#34301](https://github.com/ClickHouse/ClickHouse/issues/34301) Relates to [#34397](https://github.com/ClickHouse/ClickHouse/issues/34397). [#34539](https://github.com/ClickHouse/ClickHouse/pull/34539) ([Dmitry Novik](https://github.com/novikd)).
* Fix bug of round/roundBankers, close [#33267](https://github.com/ClickHouse/ClickHouse/issues/33267). [#34562](https://github.com/ClickHouse/ClickHouse/pull/34562) ([李扬](https://github.com/taiyang-li)).
* Fixed the assertion in case of using `allow_experimental_parallel_reading_from_replicas` with `max_parallel_replicas` equals to 1. This fixes [#34525](https://github.com/ClickHouse/ClickHouse/issues/34525). [#34613](https://github.com/ClickHouse/ClickHouse/pull/34613) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* - Add Debug workflow to get variables for all actions on demand - Fix lack of pr_info.number for some edge case. [#34644](https://github.com/ClickHouse/ClickHouse/pull/34644) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NO CL CATEGORY

* Reverting to previous docker images, will take a closer look at failing tests from [#34373](https://github.com/ClickHouse/ClickHouse/issues/34373). [#34413](https://github.com/ClickHouse/ClickHouse/pull/34413) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NO CL ENTRY

* NO CL ENTRY:  'Switch gosu to su-exec'. [#33563](https://github.com/ClickHouse/ClickHouse/pull/33563) ([Anselmo D. Adams](https://github.com/anselmodadams)).
* NO CL ENTRY:  'Revert "Additionally check remote_fs_execute_merges_on_single_replica_time_threshold inside ReplicatedMergeTreeQueue"'. [#34201](https://github.com/ClickHouse/ClickHouse/pull/34201) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Add func tests run with s3"'. [#34211](https://github.com/ClickHouse/ClickHouse/pull/34211) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Add pool to WriteBufferFromS3"'. [#34212](https://github.com/ClickHouse/ClickHouse/pull/34212) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Add support agreement page and snippets.'. [#34512](https://github.com/ClickHouse/ClickHouse/pull/34512) ([Tom Risse](https://github.com/flickerbox-tom)).
* NO CL ENTRY:  'Add Gigasheet to adopters'. [#34589](https://github.com/ClickHouse/ClickHouse/pull/34589) ([Brian Hunter](https://github.com/bjhunter)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix status of SKIPPED integration tests (was incorrectly marked as ERROR) [#33162](https://github.com/ClickHouse/ClickHouse/pull/33162) ([Azat Khuzhin](https://github.com/azat)).
* Client interactive suggest (extract info from CREATE queries) [#33201](https://github.com/ClickHouse/ClickHouse/pull/33201) ([Azat Khuzhin](https://github.com/azat)).
* Fix flushing of in-memory parts [#33234](https://github.com/ClickHouse/ClickHouse/pull/33234) ([Anton Popov](https://github.com/CurtizJ)).
* improvements to tests for h3kRing and h3ToChildren funcs [#33311](https://github.com/ClickHouse/ClickHouse/pull/33311) ([Bharat Nallan](https://github.com/bharatnc)).
* Simplify different block structure (i.e. after ALTER) support for Buffer [#33324](https://github.com/ClickHouse/ClickHouse/pull/33324) ([Azat Khuzhin](https://github.com/azat)).
* Dictionary rename fix [#33526](https://github.com/ClickHouse/ClickHouse/pull/33526) ([Maksim Kita](https://github.com/kitaisreal)).
* RFC: Split headers, move SystemLog into module, more forward declarations [#33534](https://github.com/ClickHouse/ClickHouse/pull/33534) ([Azat Khuzhin](https://github.com/azat)).
* add check for h3 empty column arguments [#33552](https://github.com/ClickHouse/ClickHouse/pull/33552) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix testflows tests [#33575](https://github.com/ClickHouse/ClickHouse/pull/33575) ([Vitaly Baranov](https://github.com/vitlibar)).
* Ignore parse failure of opentelemetry header. Another try. [#33595](https://github.com/ClickHouse/ClickHouse/pull/33595) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix mongo no_auth compose [#33634](https://github.com/ClickHouse/ClickHouse/pull/33634) ([Ilya Yatsishin](https://github.com/qoega)).
* AsynchronousMetrics: Ignore inaccessible sensors [#33639](https://github.com/ClickHouse/ClickHouse/pull/33639) ([Raúl Marín](https://github.com/Algunenano)).
* Slightly reduce memory usage for parsing collections (by using move ctor) [#33665](https://github.com/ClickHouse/ClickHouse/pull/33665) ([Azat Khuzhin](https://github.com/azat)).
* Merge [#33563](https://github.com/ClickHouse/ClickHouse/issues/33563) [#33669](https://github.com/ClickHouse/ClickHouse/pull/33669) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update version after release 22.1 [#33673](https://github.com/ClickHouse/ClickHouse/pull/33673) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix sumIf rewrite [#33677](https://github.com/ClickHouse/ClickHouse/pull/33677) ([flynn](https://github.com/ucasfl)).
* DictionarySourceCoordinator update interface [#33682](https://github.com/ClickHouse/ClickHouse/pull/33682) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix LDAP and Kerberos config handling [#33689](https://github.com/ClickHouse/ClickHouse/pull/33689) ([Denis Glazachev](https://github.com/traceon)).
* Add some helping comments for API endpoints [#33700](https://github.com/ClickHouse/ClickHouse/pull/33700) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix hive tests [#33703](https://github.com/ClickHouse/ClickHouse/pull/33703) ([Kseniia Sumarokova](https://github.com/kssenii)).
* H3 remove functions degsToRads, radsToDegs [#33707](https://github.com/ClickHouse/ClickHouse/pull/33707) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove unused variable [#33731](https://github.com/ClickHouse/ClickHouse/pull/33731) ([vxider](https://github.com/Vxider)).
* Add test issue_31009 [#33739](https://github.com/ClickHouse/ClickHouse/pull/33739) ([Vladimir C](https://github.com/vdimir)).
* Cleanup build: .gitignore more debian directories, libpqxx-cmake without configure_file [#33742](https://github.com/ClickHouse/ClickHouse/pull/33742) ([Ilya Yatsishin](https://github.com/qoega)).
* Better exception text on suspicious broken parts [#33743](https://github.com/ClickHouse/ClickHouse/pull/33743) ([alesapin](https://github.com/alesapin)).
* Fix release_branches workflow for some cases [#33744](https://github.com/ClickHouse/ClickHouse/pull/33744) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add new team members to company page [#33755](https://github.com/ClickHouse/ClickHouse/pull/33755) ([Cody Baker](https://github.com/codyrobert)).
* Remove duplicated header [#33760](https://github.com/ClickHouse/ClickHouse/pull/33760) ([vxider](https://github.com/Vxider)).
* Hotfix of missing header [#33765](https://github.com/ClickHouse/ClickHouse/pull/33765) ([Amos Bird](https://github.com/amosbird)).
* rewrite bitHammingDistance with FunctionBinaryArithmetic [#33772](https://github.com/ClickHouse/ClickHouse/pull/33772) ([flynn](https://github.com/ucasfl)).
* Use tb64senc for base64Decode on aarch64 [#33779](https://github.com/ClickHouse/ClickHouse/pull/33779) ([Vladimir C](https://github.com/vdimir)).
* Support USE_* build flags in tests' tags [#33780](https://github.com/ClickHouse/ClickHouse/pull/33780) ([Vladimir C](https://github.com/vdimir)).
* Use workflow names in approve lambda [#33789](https://github.com/ClickHouse/ClickHouse/pull/33789) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Dictionaries remove unnecessary copy of keys during read [#33791](https://github.com/ClickHouse/ClickHouse/pull/33791) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove debug logging from TableFunctionFile [#33796](https://github.com/ClickHouse/ClickHouse/pull/33796) ([Kruglov Pavel](https://github.com/Avogar)).
* RangeHashedDictionary handle invalid intervals [#33827](https://github.com/ClickHouse/ClickHouse/pull/33827) ([Maksim Kita](https://github.com/kitaisreal)).
* Dictionaries added Date32 type support [#33831](https://github.com/ClickHouse/ClickHouse/pull/33831) ([Maksim Kita](https://github.com/kitaisreal)).
* TypeId better naming [#33832](https://github.com/ClickHouse/ClickHouse/pull/33832) ([Maksim Kita](https://github.com/kitaisreal)).
* FunctionsConversion fix typo [#33841](https://github.com/ClickHouse/ClickHouse/pull/33841) ([Maksim Kita](https://github.com/kitaisreal)).
* More cmake external modules cleanups [#33842](https://github.com/ClickHouse/ClickHouse/pull/33842) ([Azat Khuzhin](https://github.com/azat)).
* Remove harmful code and check what will happen [#33844](https://github.com/ClickHouse/ClickHouse/pull/33844) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix DESCRIBE TABLE query formatting [#33846](https://github.com/ClickHouse/ClickHouse/pull/33846) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix build with ENABLE_EXAMPLES [#33848](https://github.com/ClickHouse/ClickHouse/pull/33848) ([Maksim Kita](https://github.com/kitaisreal)).
* Add Trademark Policy Page [#33851](https://github.com/ClickHouse/ClickHouse/pull/33851) ([Cody Baker](https://github.com/codyrobert)).
* updates to min2 and max2 funcs [#33852](https://github.com/ClickHouse/ClickHouse/pull/33852) ([Bharat Nallan](https://github.com/bharatnc)).
* Use correct logging level [#33857](https://github.com/ClickHouse/ClickHouse/pull/33857) ([李扬](https://github.com/taiyang-li)).
* Fix zookeeper library dependency from interpreters (by marking library STATIC) [#33860](https://github.com/ClickHouse/ClickHouse/pull/33860) ([Azat Khuzhin](https://github.com/azat)).
* FunctionBase64Conversion warning fix [#33863](https://github.com/ClickHouse/ClickHouse/pull/33863) ([Maksim Kita](https://github.com/kitaisreal)).
* Dictionary ATTACH, DETACH added test [#33870](https://github.com/ClickHouse/ClickHouse/pull/33870) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix perf comparison rerun [#33872](https://github.com/ClickHouse/ClickHouse/pull/33872) ([alesapin](https://github.com/alesapin)).
* Improve postgresql integration test [#33880](https://github.com/ClickHouse/ClickHouse/pull/33880) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix cmake for mac. [#33882](https://github.com/ClickHouse/ClickHouse/pull/33882) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* SQLUserDefinedFunctions invalid lambda additional fixes [#33889](https://github.com/ClickHouse/ClickHouse/pull/33889) ([Maksim Kita](https://github.com/kitaisreal)).
* Update upcoming and past webinar links on homepage [#33890](https://github.com/ClickHouse/ClickHouse/pull/33890) ([Cody Baker](https://github.com/codyrobert)).
* disable animation on docs menu [#33903](https://github.com/ClickHouse/ClickHouse/pull/33903) ([SuperDJY](https://github.com/cmsxbc)).
* Add more retries in CI for AWS "spot" instances [#33907](https://github.com/ClickHouse/ClickHouse/pull/33907) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* FunctionMathUnary remove macro usage [#33916](https://github.com/ClickHouse/ClickHouse/pull/33916) ([Maksim Kita](https://github.com/kitaisreal)).
* explicitly checkAndGetColumn for remaining H3 funcs [#33921](https://github.com/ClickHouse/ClickHouse/pull/33921) ([Bharat Nallan](https://github.com/bharatnc)).
* SQLUserDefinedFunctions invalid lambda additional cases [#33924](https://github.com/ClickHouse/ClickHouse/pull/33924) ([Maksim Kita](https://github.com/kitaisreal)).
* when not DEBUG set USE_DEBUG_HELPERS OFF [#33925](https://github.com/ClickHouse/ClickHouse/pull/33925) ([Ben](https://github.com/benbiti)).
* Fix test_replica_is_active flaky test [#33926](https://github.com/ClickHouse/ClickHouse/pull/33926) ([alesapin](https://github.com/alesapin)).
* Fix bug in keeper which can lead to inconsistent snapshots [#33941](https://github.com/ClickHouse/ClickHouse/pull/33941) ([alesapin](https://github.com/alesapin)).
* Fix keeper data dumper build [#33942](https://github.com/ClickHouse/ClickHouse/pull/33942) ([alesapin](https://github.com/alesapin)).
* Remove MAKE_STATIC_LIBRARIES (in favor of USE_STATIC_LIBRARIES) [#33946](https://github.com/ClickHouse/ClickHouse/pull/33946) ([Azat Khuzhin](https://github.com/azat)).
* Revert glibc compatibility (via .symver) in favor of hermetic build (bundled libc) [#33950](https://github.com/ClickHouse/ClickHouse/pull/33950) ([Azat Khuzhin](https://github.com/azat)).
* add c++expr script for C++ one-liners [#33962](https://github.com/ClickHouse/ClickHouse/pull/33962) ([Sergei Trifonov](https://github.com/serxa)).
* docker: fix root squashed data dirs [#33963](https://github.com/ClickHouse/ClickHouse/pull/33963) ([Constantine Peresypkin](https://github.com/pkit)).
* Disable parallel run for 00985_merge_stack_overflow [#33976](https://github.com/ClickHouse/ClickHouse/pull/33976) ([Azat Khuzhin](https://github.com/azat)).
* Cancel lambda [#33990](https://github.com/ClickHouse/ClickHouse/pull/33990) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* reduce signal_pipe_buf_size  [#33996](https://github.com/ClickHouse/ClickHouse/pull/33996) ([save-my-heart](https://github.com/save-my-heart)).
* make systemd to use EnvironmentFile [#34024](https://github.com/ClickHouse/ClickHouse/pull/34024) ([Denny Crane](https://github.com/den-crane)).
* CurrentlyExecuting: Require mutex usage explicitly [#34034](https://github.com/ClickHouse/ClickHouse/pull/34034) ([Raúl Marín](https://github.com/Algunenano)).
* Add symlinks to keeper [#34042](https://github.com/ClickHouse/ClickHouse/pull/34042) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove DecimalPaddedPODArray [#34052](https://github.com/ClickHouse/ClickHouse/pull/34052) ([Maksim Kita](https://github.com/kitaisreal)).
* Less flaky test_inconsistent_parts_if_drop_while_replica_not_active [#34057](https://github.com/ClickHouse/ClickHouse/pull/34057) ([Raúl Marín](https://github.com/Algunenano)).
* Small test for `FINAL` [#34058](https://github.com/ClickHouse/ClickHouse/pull/34058) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Slightly optimize ColumnArray::get()/operator[] (by using reserve over resize) [#34074](https://github.com/ClickHouse/ClickHouse/pull/34074) ([Azat Khuzhin](https://github.com/azat)).
* Tiny cleanup of AggregateFunctionSimpleState/AggregateFunctionState [#34075](https://github.com/ClickHouse/ClickHouse/pull/34075) ([Azat Khuzhin](https://github.com/azat)).
* Fix builds [#34090](https://github.com/ClickHouse/ClickHouse/pull/34090) ([Alexander Tokmakov](https://github.com/tavplubix)).
* add c++expr script examples [#34112](https://github.com/ClickHouse/ClickHouse/pull/34112) ([Sergei Trifonov](https://github.com/serxa)).
* Make clickhouse-diagnostics also work for altinity release [#34116](https://github.com/ClickHouse/ClickHouse/pull/34116) ([Ramazan Polat](https://github.com/ramazanpolat)).
* Small improvement in schema inference from stdin in local [#34117](https://github.com/ClickHouse/ClickHouse/pull/34117) ([Kruglov Pavel](https://github.com/Avogar)).
* Slightly optimize Array/Tuple/Map [#34126](https://github.com/ClickHouse/ClickHouse/pull/34126) ([Azat Khuzhin](https://github.com/azat)).
* Sort block refactoring [#34143](https://github.com/ClickHouse/ClickHouse/pull/34143) ([Maksim Kita](https://github.com/kitaisreal)).
* pdqsort performance check [#34145](https://github.com/ClickHouse/ClickHouse/pull/34145) ([Maksim Kita](https://github.com/kitaisreal)).
* Revert [#33957](https://github.com/ClickHouse/ClickHouse/issues/33957) [#34146](https://github.com/ClickHouse/ClickHouse/pull/34146) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add func tests run with s3 [#34153](https://github.com/ClickHouse/ClickHouse/pull/34153) ([alesapin](https://github.com/alesapin)).
* Close [#10197](https://github.com/ClickHouse/ClickHouse/issues/10197) [#34159](https://github.com/ClickHouse/ClickHouse/pull/34159) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Cmake leftovers cleanup [#34167](https://github.com/ClickHouse/ClickHouse/pull/34167) ([Azat Khuzhin](https://github.com/azat)).
* bitsetsort peformance check [#34175](https://github.com/ClickHouse/ClickHouse/pull/34175) ([Maksim Kita](https://github.com/kitaisreal)).
* Add authorisation for dockerhub proxy container [#34183](https://github.com/ClickHouse/ClickHouse/pull/34183) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Additionally check remote_fs_execute_merges_on_single_replica_time_threshold inside ReplicatedMergeTreeQueue [#34189](https://github.com/ClickHouse/ClickHouse/pull/34189) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix some perf tests [#34191](https://github.com/ClickHouse/ClickHouse/pull/34191) ([Kruglov Pavel](https://github.com/Avogar)).
* Clean up: insert_deduplication_token setting for INSERT statement [#34192](https://github.com/ClickHouse/ClickHouse/pull/34192) ([Igor Nikonov](https://github.com/devcrafter)).
* Add func tests run with s3 and fix several bugs [#34215](https://github.com/ClickHouse/ClickHouse/pull/34215) ([alesapin](https://github.com/alesapin)).
* Revert "Revert "Add pool to WriteBufferFromS3"" [#34219](https://github.com/ClickHouse/ClickHouse/pull/34219) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Revert "Revert "Additionally check remote_fs_execute_merges_on_single_replica_time_threshold inside ReplicatedMergeTreeQueue"" [#34221](https://github.com/ClickHouse/ClickHouse/pull/34221) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add const to make clang-tidy happy [#34222](https://github.com/ClickHouse/ClickHouse/pull/34222) ([Vitaly Baranov](https://github.com/vitlibar)).
*  Bump fmtlib from 7.0.0 to 8.1.1 [#34223](https://github.com/ClickHouse/ClickHouse/pull/34223) ([Azat Khuzhin](https://github.com/azat)).
* Add submodule minizip [#34226](https://github.com/ClickHouse/ClickHouse/pull/34226) ([Vitaly Baranov](https://github.com/vitlibar)).
* Update list-versions.sh, update version_date.tsv [#34240](https://github.com/ClickHouse/ClickHouse/pull/34240) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add missing fmt::runtime() in MergeTreeBackgroundExecutor (fixes the build) [#34245](https://github.com/ClickHouse/ClickHouse/pull/34245) ([Azat Khuzhin](https://github.com/azat)).
* Update clickhouse-keeper.md [#34264](https://github.com/ClickHouse/ClickHouse/pull/34264) ([Andrew](https://github.com/andycol)).
* print query id when using `--interactive` with `--queries-file` in client/local [#34265](https://github.com/ClickHouse/ClickHouse/pull/34265) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update and add new team members [#34268](https://github.com/ClickHouse/ClickHouse/pull/34268) ([Cody Baker](https://github.com/codyrobert)).
* Add a test for shebang [#34274](https://github.com/ClickHouse/ClickHouse/pull/34274) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix fractional_progress_bar test [#34282](https://github.com/ClickHouse/ClickHouse/pull/34282) ([Maksim Kita](https://github.com/kitaisreal)).
* Minor fixes for [#34267](https://github.com/ClickHouse/ClickHouse/issues/34267) [#34284](https://github.com/ClickHouse/ClickHouse/pull/34284) ([Anton Popov](https://github.com/CurtizJ)).
* Add support policy page content. [#34309](https://github.com/ClickHouse/ClickHouse/pull/34309) ([Tom Risse](https://github.com/flickerbox-tom)).
* Probably fix data race in WriteBufferFromS3 destructor. [#34316](https://github.com/ClickHouse/ClickHouse/pull/34316) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Decrease severity for "Reading ... ranges ..." log message to Trace [#34319](https://github.com/ClickHouse/ClickHouse/pull/34319) ([Azat Khuzhin](https://github.com/azat)).
* use LowCardinality type for _file and _path in some Storages, continue of [#34317](https://github.com/ClickHouse/ClickHouse/issues/34317) [#34333](https://github.com/ClickHouse/ClickHouse/pull/34333) ([flynn](https://github.com/ucasfl)).
* Function mapPopulateSeries added additional performance test [#34339](https://github.com/ClickHouse/ClickHouse/pull/34339) ([Maksim Kita](https://github.com/kitaisreal)).
* Add test for propagating OpenTelemetry context via gRPC protocol [#34341](https://github.com/ClickHouse/ClickHouse/pull/34341) ([Vitaly Baranov](https://github.com/vitlibar)).
* explicitly check and get columns for s2 funcs [#34344](https://github.com/ClickHouse/ClickHouse/pull/34344) ([Bharat Nallan](https://github.com/bharatnc)).
* Small improvements [#34351](https://github.com/ClickHouse/ClickHouse/pull/34351) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix USE database for clickhouse-local [#34357](https://github.com/ClickHouse/ClickHouse/pull/34357) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix clang-tidy issue [#34365](https://github.com/ClickHouse/ClickHouse/pull/34365) ([Heena Bansal](https://github.com/HeenaBansal2009)).
* Delete empty file DateOrDateTimeFunctionsConvertion.cpp [#34371](https://github.com/ClickHouse/ClickHouse/pull/34371) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix consecutive backward seeks in seekable read buffers [#34376](https://github.com/ClickHouse/ClickHouse/pull/34376) ([Anton Popov](https://github.com/CurtizJ)).
* Enable one more check for clang-tidy [#34388](https://github.com/ClickHouse/ClickHouse/pull/34388) ([Heena Bansal](https://github.com/HeenaBansal2009)).
* Method called on already moved [#34398](https://github.com/ClickHouse/ClickHouse/pull/34398) ([Rajkumar Varada](https://github.com/varadarajkumar)).
* Fix wrong destruction order in CreatingSetsTransform. [#34406](https://github.com/ClickHouse/ClickHouse/pull/34406) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Split and rename compression fields in gRPC [#34408](https://github.com/ClickHouse/ClickHouse/pull/34408) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fixing test_storage_postgresql [#34410](https://github.com/ClickHouse/ClickHouse/pull/34410) ([Kseniia Sumarokova](https://github.com/kssenii)).
* asynchronous_inserts engine AsynchronousInserts -> SystemAsynchronousInserts [#34429](https://github.com/ClickHouse/ClickHouse/pull/34429) ([filimonov](https://github.com/filimonov)).
* clang-tidy move fix build [#34431](https://github.com/ClickHouse/ClickHouse/pull/34431) ([Maksim Kita](https://github.com/kitaisreal)).
* `static-files-disk-uploader`: add a mode to create symlinks [#34432](https://github.com/ClickHouse/ClickHouse/pull/34432) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bug in URL engine [#34448](https://github.com/ClickHouse/ClickHouse/pull/34448) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix style [#34450](https://github.com/ClickHouse/ClickHouse/pull/34450) ([alesapin](https://github.com/alesapin)).
* Added test 33734 [#34454](https://github.com/ClickHouse/ClickHouse/pull/34454) ([Maksim Kita](https://github.com/kitaisreal)).
* Update http_max_tries setting default [#34457](https://github.com/ClickHouse/ClickHouse/pull/34457) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Use `cpp_bin_float_double` in `set_multiplier` for `wide_integer_from_builtin` for aarch64 [#34463](https://github.com/ClickHouse/ClickHouse/pull/34463) ([Vladimir C](https://github.com/vdimir)).
* test for [#13907](https://github.com/ClickHouse/ClickHouse/issues/13907) toColumnTypeName_toLowCardinality_const [#34471](https://github.com/ClickHouse/ClickHouse/pull/34471) ([Denny Crane](https://github.com/den-crane)).
* Remove invalid IOS setting for RocksDB CMAKE to fix Apple M1 build [#34472](https://github.com/ClickHouse/ClickHouse/pull/34472) ([Geoff Genz](https://github.com/genzgd)).
* clang-tidy reported potential chance for divide by zero exception [#34473](https://github.com/ClickHouse/ClickHouse/pull/34473) ([Rajkumar Varada](https://github.com/varadarajkumar)).
* accessing nested_column after already moved to data [#34475](https://github.com/ClickHouse/ClickHouse/pull/34475) ([Rajkumar Varada](https://github.com/varadarajkumar)).
* Avoid unnecessary copying of `Settings` [#34476](https://github.com/ClickHouse/ClickHouse/pull/34476) ([Anton Popov](https://github.com/CurtizJ)).
* Update buildPushingToViewsChain.h [#34515](https://github.com/ClickHouse/ClickHouse/pull/34515) ([William.Walliams.Wong](https://github.com/wangzhen11aaa)).
* More gdb introspection on CI [#34517](https://github.com/ClickHouse/ClickHouse/pull/34517) ([Azat Khuzhin](https://github.com/azat)).
* add BeforeLambdaBody to .clang-format [#34533](https://github.com/ClickHouse/ClickHouse/pull/34533) ([Vladimir C](https://github.com/vdimir)).
* Remove very old cruft [#34547](https://github.com/ClickHouse/ClickHouse/pull/34547) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Tiny fixes for client/local suggestions [#34550](https://github.com/ClickHouse/ClickHouse/pull/34550) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix gtest_archive_reader_and_writer in case of !USE_MINIZIP [#34554](https://github.com/ClickHouse/ClickHouse/pull/34554) ([Azat Khuzhin](https://github.com/azat)).
* TableFunctionFile added performance test [#34555](https://github.com/ClickHouse/ClickHouse/pull/34555) ([Maksim Kita](https://github.com/kitaisreal)).
* check and get columns in geoToH3 func [#34557](https://github.com/ClickHouse/ClickHouse/pull/34557) ([Bharat Nallan](https://github.com/bharatnc)).
* try fix data race in StorageLog [#34558](https://github.com/ClickHouse/ClickHouse/pull/34558) ([flynn](https://github.com/ucasfl)).
* Postpone a bit nightly builds to the least loaded time [#34569](https://github.com/ClickHouse/ClickHouse/pull/34569) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Always remove unused actions from addMissingDefaults [#34577](https://github.com/ClickHouse/ClickHouse/pull/34577) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix indentation in ARRAY JOIN formatting [#34578](https://github.com/ClickHouse/ClickHouse/pull/34578) ([Azat Khuzhin](https://github.com/azat)).
* Fix deadlock in OvercommitTracker [#34591](https://github.com/ClickHouse/ClickHouse/pull/34591) ([Dmitry Novik](https://github.com/novikd)).
* ASTCreateQuery: Remove usused `tables` member [#34610](https://github.com/ClickHouse/ClickHouse/pull/34610) ([Raúl Marín](https://github.com/Algunenano)).
* Add test for [#19222](https://github.com/ClickHouse/ClickHouse/issues/19222) [#34615](https://github.com/ClickHouse/ClickHouse/pull/34615) ([Raúl Marín](https://github.com/Algunenano)).
* Attempt to fix freeBSD build [#34617](https://github.com/ClickHouse/ClickHouse/pull/34617) ([Raúl Marín](https://github.com/Algunenano)).
* Fix quadratic complexity while adding subcolumns [#34623](https://github.com/ClickHouse/ClickHouse/pull/34623) ([Anton Popov](https://github.com/CurtizJ)).
* Fix typo in welchttest.md [#34634](https://github.com/ClickHouse/ClickHouse/pull/34634) ([achimbab](https://github.com/achimbab)).
* Improve the release.py script [#34659](https://github.com/ClickHouse/ClickHouse/pull/34659) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Disable memory overcommit if timeout is not set [#34663](https://github.com/ClickHouse/ClickHouse/pull/34663) ([Dmitry Novik](https://github.com/novikd)).
