---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.8.1.7409-prestable FIXME as compared to v21.7.1.7283-prestable

#### Backward Incompatible Change
* - Backward Incompatible Change:. [#23934](https://github.com/ClickHouse/ClickHouse/pull/23934) ([hexiaoting](https://github.com/hexiaoting)).

#### New Feature
* Add an ability to reset custom setting to default and remove it from table's metadata. This will allow to rollback the change without knowing the system/config's default. Closes [#14449](https://github.com/ClickHouse/ClickHouse/issues/14449). [#17769](https://github.com/ClickHouse/ClickHouse/pull/17769) ([xjewer](https://github.com/xjewer)).
* Add MaterializedPostgreSQL table engine and database engine. Database engine allows to replicate a whole database or any subset of database tables. [#20470](https://github.com/ClickHouse/ClickHouse/pull/20470) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Adding support for a part of SQLJSON standard. [#24148](https://github.com/ClickHouse/ClickHouse/pull/24148) ([l1tsolaiki](https://github.com/l1tsolaiki)).
* Collect common system metrics (in `system.asynchronous_metrics` and `system.asynchronous_metric_log`) about CPU usage, disk usage, memory usage, IO, network, files, load average, CPU frequencies, thermal sensors, EDAC counters, system uptime; also added metrics about the scheduling jitter and the time spent collecting the metrics. It works like `atop` in ClickHouse and allows to get monitoring data even if you have no additional tools installed. This closes [#9430](https://github.com/ClickHouse/ClickHouse/issues/9430). [#24416](https://github.com/ClickHouse/ClickHouse/pull/24416) ([Yegor Levankov](https://github.com/elevankoff)).
* Add support `DISTINCT ON (columns)` expression, close [#25404](https://github.com/ClickHouse/ClickHouse/issues/25404). [#25589](https://github.com/ClickHouse/ClickHouse/pull/25589) ([Zijie Lu](https://github.com/TszKitLo40)).
* * Support Map type in `mapAdd` and `mapSubtract` functions * Support (U)Int128, U(Int256) types in `mapAdd` and `mapSubtract` functions. [#25596](https://github.com/ClickHouse/ClickHouse/pull/25596) ([Ildus Kurbangaliev](https://github.com/ildus)).
* Add bin/unbin functions support. [#25609](https://github.com/ClickHouse/ClickHouse/pull/25609) ([zhaoyu](https://github.com/zxc111)).
* Introduce `system.data_skipping_indices` table containing information about existing data skipping indices. Closes [#7659](https://github.com/ClickHouse/ClickHouse/issues/7659). [#25693](https://github.com/ClickHouse/ClickHouse/pull/25693) ([Dmitry Novik](https://github.com/novikd)).
* in addition to https://github.com/ClickHouse/ClickHouse/pull/12073 add the FIRST keyword to the ADD INDEX command to be able to add index in the beginning of the indices list. [#25904](https://github.com/ClickHouse/ClickHouse/pull/25904) ([xjewer](https://github.com/xjewer)).
* Render pipelines as graphs in Web UI if `EXPLAIN PIPELINE graph = 1` query is given. [#26067](https://github.com/ClickHouse/ClickHouse/pull/26067) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add new functions `leftPad()`, `rightPad()`, `leftPadUTF8()`, `rightPadUTF8()`. [#26075](https://github.com/ClickHouse/ClickHouse/pull/26075) ([Vitaly Baranov](https://github.com/vitlibar)).

#### Performance Improvement
* Added option to compile aggregate functions if `compile_aggregate_expressions` settings is on. [#24789](https://github.com/ClickHouse/ClickHouse/pull/24789) ([Maksim Kita](https://github.com/kitaisreal)).

#### Improvement
* `Database` argument for `StorageMerge` support regular expression. This closes #776. [#25064](https://github.com/ClickHouse/ClickHouse/pull/25064) ([flynn](https://github.com/ucasfl)).
* Allow extract non-string element as string using JSONExtract. This is for [#25414](https://github.com/ClickHouse/ClickHouse/issues/25414). [#25452](https://github.com/ClickHouse/ClickHouse/pull/25452) ([Amos Bird](https://github.com/amosbird)).
* Support for dynamic reloading of config to change number of threads in pool for background jobs execution (merges, mutations, fetches). [#25548](https://github.com/ClickHouse/ClickHouse/pull/25548) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Support TRUNCATE TABLE for StorageS3 and StorageHDFS. Closes [#25530](https://github.com/ClickHouse/ClickHouse/issues/25530). [#25550](https://github.com/ClickHouse/ClickHouse/pull/25550) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make `NetworkReceiveElapsedMicroseconds` metric to correctly include the time spent waiting for data from the client to INSERT. This closes [#9958](https://github.com/ClickHouse/ClickHouse/issues/9958). [#25602](https://github.com/ClickHouse/ClickHouse/pull/25602) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix possible logical race condition between `ALTER TABLE ... DETACH` and background merges. [#25605](https://github.com/ClickHouse/ClickHouse/pull/25605) ([Azat Khuzhin](https://github.com/azat)).
* Support materialized and aliased columns in joins, close [#13274](https://github.com/ClickHouse/ClickHouse/issues/13274). [#25634](https://github.com/ClickHouse/ClickHouse/pull/25634) ([Vladimir C](https://github.com/vdimir)).
* MaterializeMySQL now supports `ENUM` data type. [#25676](https://github.com/ClickHouse/ClickHouse/pull/25676) ([Storozhuk Kostiantyn](https://github.com/sand6255)).
* Cancel already running merges in partition on `DROP PARTITION` and `TRUNCATE` for `ReplicatedMergeTree`. Resolves [#17151](https://github.com/ClickHouse/ClickHouse/issues/17151). [#25684](https://github.com/ClickHouse/ClickHouse/pull/25684) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Use `Map` data type for key-value dictionaries in system logs tables (`system.query_log`, `system.query_thread_log`, `system.processes`, `system.opentelemetry_span_log`). Virtual columns are created to support old queries. Closes [#18698](https://github.com/ClickHouse/ClickHouse/issues/18698). Authors @hexiaoting, @sundy-li. [#25773](https://github.com/ClickHouse/ClickHouse/pull/25773) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix inconsistent behaviour of GROUP BY constant on empty set. Closes [#6842](https://github.com/ClickHouse/ClickHouse/issues/6842). [#25786](https://github.com/ClickHouse/ClickHouse/pull/25786) ([Kseniia Sumarokova](https://github.com/kssenii)).
* MySQL Engine now supports the exchange of column comments between MySQL and ClickHouse. [#25795](https://github.com/ClickHouse/ClickHouse/pull/25795) ([Storozhuk Kostiantyn](https://github.com/sand6255)).
* Fix "No available columns" for Merge() storage. [#25801](https://github.com/ClickHouse/ClickHouse/pull/25801) ([Azat Khuzhin](https://github.com/azat)).
* Allow to start clickhouse-client with unreadable working directory. [#25817](https://github.com/ClickHouse/ClickHouse/pull/25817) ([ianton-ru](https://github.com/ianton-ru)).
* Better handling of lost parts for ReplicatedMergeTree tables. Fixes rare inconsistencies in ReplicationQueue. Nothing should be visible to the user. Fixes [#10368](https://github.com/ClickHouse/ClickHouse/issues/10368). [#25820](https://github.com/ClickHouse/ClickHouse/pull/25820) ([alesapin](https://github.com/alesapin)).
* Fix an extremely rare bug which can lead to intersecting parts after `DROP PART` or background deletion of an empty part. [#25884](https://github.com/ClickHouse/ClickHouse/pull/25884) ([alesapin](https://github.com/alesapin)).
* Convert history file from readline format to replxx format. [#25888](https://github.com/ClickHouse/ClickHouse/pull/25888) ([Azat Khuzhin](https://github.com/azat)).
* Support LowCardinality, Decimal and UUID for JSON extract. Closes [#24606](https://github.com/ClickHouse/ClickHouse/issues/24606). [#25900](https://github.com/ClickHouse/ClickHouse/pull/25900) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add support for queries with a column named `"null"` (it must be specified in backticks or double quotes) and ON CLUSTER. This closes [#24035](https://github.com/ClickHouse/ClickHouse/issues/24035). [#25907](https://github.com/ClickHouse/ClickHouse/pull/25907) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Correctly throw exception on attempt to parse invalid Date. This closes [#6481](https://github.com/ClickHouse/ClickHouse/issues/6481). [#25909](https://github.com/ClickHouse/ClickHouse/pull/25909) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow parameters for parametric aggregate functions to be arbitrary constant expressions (e.g. `1 + 2`), not just literals. This also allows to use query parameters (in parameterized queries like `{param:UInt8}`) for parameters of parametric aggregate functions. This closes [#11607](https://github.com/ClickHouse/ClickHouse/issues/11607). [#25910](https://github.com/ClickHouse/ClickHouse/pull/25910) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow `quantiles*` functions to work with `aggregate_functions_null_for_empty`. This closes [#25892](https://github.com/ClickHouse/ClickHouse/issues/25892). [#25919](https://github.com/ClickHouse/ClickHouse/pull/25919) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make `sudo service clickhouse-server start` to work on systems with `systemd` like Centos 8. This closes [#14298](https://github.com/ClickHouse/ClickHouse/issues/14298). This closes [#17799](https://github.com/ClickHouse/ClickHouse/issues/17799). [#25921](https://github.com/ClickHouse/ClickHouse/pull/25921) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add support for unicode (e.g. Chinese, Cyrillic) components in `Nested` data types. This closes [#25594](https://github.com/ClickHouse/ClickHouse/issues/25594). [#25923](https://github.com/ClickHouse/ClickHouse/pull/25923) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow complex quoted identifiers of JOINed tables. This closes [#17861](https://github.com/ClickHouse/ClickHouse/issues/17861). [#25924](https://github.com/ClickHouse/ClickHouse/pull/25924) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added setting `optimize_move_to_prewhere_if_final`. If query has `FINAL`, the optimization `move_to_prewhere` will be enabled only if both `optimize_move_to_prewhere` and `optimize_move_to_prewhere_if_final` are enabled. Closes [#8684](https://github.com/ClickHouse/ClickHouse/issues/8684). [#25940](https://github.com/ClickHouse/ClickHouse/pull/25940) ([Kseniia Sumarokova](https://github.com/kssenii)).
* More instrumentation for network interaction: add counters for recv/send bytes; add gauges for recvs/sends. Added missing documentation. This closes [#5897](https://github.com/ClickHouse/ClickHouse/issues/5897). [#25962](https://github.com/ClickHouse/ClickHouse/pull/25962) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Web UI: if value looks like an URL, automatically generate a link. [#25965](https://github.com/ClickHouse/ClickHouse/pull/25965) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix error with query `SET SQL_SELECT_LIMIT` in mysql protocol. Closes [#17115](https://github.com/ClickHouse/ClickHouse/issues/17115). [#25972](https://github.com/ClickHouse/ClickHouse/pull/25972) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add support for argument of `UUID` type for `empty` and `notEmpty` functions. `UUID` is empty if it is all zeros (nil UUID). This closes [#3446](https://github.com/ClickHouse/ClickHouse/issues/3446). [#25974](https://github.com/ClickHouse/ClickHouse/pull/25974) ([zhaoyu](https://github.com/zxc111)).
* Add support for argument of AggregateFunction type for bin and hex functions. [#26094](https://github.com/ClickHouse/ClickHouse/pull/26094) ([zhaoyu](https://github.com/zxc111)).
* For dictionary with complex key if complex key contains only one attribute allow to not wrap key expression in tuple for functions `dictGet`, `dictHas`. [#26130](https://github.com/ClickHouse/ClickHouse/pull/26130) ([Maksim Kita](https://github.com/kitaisreal)).

#### Bug Fix
* `CAST` from `Date` to `DateTime` (or `DateTime64`) was not using the timezone of the `DateTime` type. It can also affect the comparison between `Date` and `DateTime`. Inference of the common type for `Date` and `DateTime` also was not using the corresponding timezone. It affected the results of function `if` and array construction. Closes [#24128](https://github.com/ClickHouse/ClickHouse/issues/24128). [#24129](https://github.com/ClickHouse/ClickHouse/pull/24129) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix assertion in PREWHERE with non-uint8 type, close [#19589](https://github.com/ClickHouse/ClickHouse/issues/19589). [#25484](https://github.com/ClickHouse/ClickHouse/pull/25484) ([Vladimir C](https://github.com/vdimir)).
* Fix `ALTER MODIFY COLUMN` of columns, which participates in TTL expressions. [#25554](https://github.com/ClickHouse/ClickHouse/pull/25554) ([Anton Popov](https://github.com/CurtizJ)).
* Fix slow dict join in some cases, close [#24209](https://github.com/ClickHouse/ClickHouse/issues/24209). [#25618](https://github.com/ClickHouse/ClickHouse/pull/25618) ([Vladimir C](https://github.com/vdimir)).
* Allow StorageMerge to access tables with aliases. Closes [#6051](https://github.com/ClickHouse/ClickHouse/issues/6051). [#25694](https://github.com/ClickHouse/ClickHouse/pull/25694) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix bug in `TTL` with `GROUP BY` expression which refuses to execute `TTL` after first execution in part. [#25743](https://github.com/ClickHouse/ClickHouse/pull/25743) ([alesapin](https://github.com/alesapin)).
* Fix rare bug with `DROP PART` query for `ReplicatedMergeTree` tables which can lead to error message `Unexpected merged part intersecting drop range`. [#25783](https://github.com/ClickHouse/ClickHouse/pull/25783) ([alesapin](https://github.com/alesapin)).
* Fix ARM exception handling with non default page size. Fixes [#25512](https://github.com/ClickHouse/ClickHouse/issues/25512). Fixes [#25044](https://github.com/ClickHouse/ClickHouse/issues/25044). Fixes [#24901](https://github.com/ClickHouse/ClickHouse/issues/24901). Fixes [#23183](https://github.com/ClickHouse/ClickHouse/issues/23183). Fixes [#20221](https://github.com/ClickHouse/ClickHouse/issues/20221). Fixes [#19703](https://github.com/ClickHouse/ClickHouse/issues/19703). Fixes [#19028](https://github.com/ClickHouse/ClickHouse/issues/19028). Fixes [#18391](https://github.com/ClickHouse/ClickHouse/issues/18391). Fixes [#18121](https://github.com/ClickHouse/ClickHouse/issues/18121). Fixes [#17994](https://github.com/ClickHouse/ClickHouse/issues/17994). Fixes [#12483](https://github.com/ClickHouse/ClickHouse/issues/12483). [#25854](https://github.com/ClickHouse/ClickHouse/pull/25854) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix extremely long backoff for background tasks when the background pool is full. Fixes [#25836](https://github.com/ClickHouse/ClickHouse/issues/25836). [#25893](https://github.com/ClickHouse/ClickHouse/pull/25893) ([alesapin](https://github.com/alesapin)).
* Fixed `scram-sha-256` authentication for PostgreSQL engines. Closes [#24516](https://github.com/ClickHouse/ClickHouse/issues/24516). [#25906](https://github.com/ClickHouse/ClickHouse/pull/25906) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix crash on call dictGet() with bad arguments. [#25913](https://github.com/ClickHouse/ClickHouse/pull/25913) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix possible deadlock during query profiler stack unwinding. Fixes [#25968](https://github.com/ClickHouse/ClickHouse/issues/25968). [#25970](https://github.com/ClickHouse/ClickHouse/pull/25970) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix formatting of type `Map` with integer keys to `JSON`. [#25982](https://github.com/ClickHouse/ClickHouse/pull/25982) ([Anton Popov](https://github.com/CurtizJ)).
* Fix wrong thread estimation for right subquery join in some cases. Close [#24075](https://github.com/ClickHouse/ClickHouse/issues/24075). [#26052](https://github.com/ClickHouse/ClickHouse/pull/26052) ([Vladimir C](https://github.com/vdimir)).
* Fix rare server crash because of `abort` in ZooKeeper client. Fixes [#25813](https://github.com/ClickHouse/ClickHouse/issues/25813). [#26079](https://github.com/ClickHouse/ClickHouse/pull/26079) ([alesapin](https://github.com/alesapin)).
* Fix throwing exception when iterate over non existing remote directory. [#26087](https://github.com/ClickHouse/ClickHouse/pull/26087) ([ianton-ru](https://github.com/ianton-ru)).
* Fix possible crash in `pointInPolygon` if the setting `validate_polygons` is turned off. [#26113](https://github.com/ClickHouse/ClickHouse/pull/26113) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix `joinGet` with LowCarinality columns, close [#25993](https://github.com/ClickHouse/ClickHouse/issues/25993). [#26118](https://github.com/ClickHouse/ClickHouse/pull/26118) ([Vladimir C](https://github.com/vdimir)).

#### Build/Testing/Packaging Improvement
* - Syntax update: changing 'is' to '==' when necessary. [#25559](https://github.com/ClickHouse/ClickHouse/pull/25559) ([MyroTk](https://github.com/MyroTk)).
* Add new tests for checking access rights for columns used in filters (WHERE / PREWHERE / row policy) of the `SELECT` statement after changes in https://github.com/ClickHouse/ClickHouse/pull/24405. [#25619](https://github.com/ClickHouse/ClickHouse/pull/25619) ([Vitaly Baranov](https://github.com/vitlibar)).
* Enabling all TestFlows modules and fixing some tests. [#26011](https://github.com/ClickHouse/ClickHouse/pull/26011) ([vzakaznikov](https://github.com/vzakaznikov)).
* Disabling TestFlows LDAP module due to test fails. [#26065](https://github.com/ClickHouse/ClickHouse/pull/26065) ([vzakaznikov](https://github.com/vzakaznikov)).

#### Other
* Add `clickhouse-keeper-converter` tool which allows converting zookeeper logs and snapshots into `clickhouse-keeper` snapshot format. [#25428](https://github.com/ClickHouse/ClickHouse/pull/25428) ([alesapin](https://github.com/alesapin)).

#### NO CL ENTRY

* NO CL ENTRY:  '[ImgBot] Optimize images'. [#26054](https://github.com/ClickHouse/ClickHouse/pull/26054) ([imgbot[bot]](https://github.com/apps/imgbot)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix hang and incorrect exit code returned from clickhouse-test [#25537](https://github.com/ClickHouse/ClickHouse/pull/25537) ([nvartolomei](https://github.com/nvartolomei)).
* Remove PrewhereDAGInfo. [#25719](https://github.com/ClickHouse/ClickHouse/pull/25719) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix 01641_memory_tracking_insert_optimize [#25731](https://github.com/ClickHouse/ClickHouse/pull/25731) ([Azat Khuzhin](https://github.com/azat)).
* Separate log files for separate runs in stress test [#25741](https://github.com/ClickHouse/ClickHouse/pull/25741) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix slow performance test [#25742](https://github.com/ClickHouse/ClickHouse/pull/25742) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* DatabaseAtomic EXCHANGE DICTIONARIES fix test [#25753](https://github.com/ClickHouse/ClickHouse/pull/25753) ([Maksim Kita](https://github.com/kitaisreal)).
* Try fix flaky rabbitmq test [#25756](https://github.com/ClickHouse/ClickHouse/pull/25756) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add a test for [#13993](https://github.com/ClickHouse/ClickHouse/issues/13993) [#25758](https://github.com/ClickHouse/ClickHouse/pull/25758) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Set follow-fork-mode child for gdb in stress/fasttest/fuzzer [#25769](https://github.com/ClickHouse/ClickHouse/pull/25769) ([Azat Khuzhin](https://github.com/azat)).
* Ignore TOO_DEEP_RECURSION server exception during fuzzing [#25770](https://github.com/ClickHouse/ClickHouse/pull/25770) ([Azat Khuzhin](https://github.com/azat)).
* Add comments for VERSION_REVISION vs DBMS_TCP_PROTOCOL_VERSION [#25771](https://github.com/ClickHouse/ClickHouse/pull/25771) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky test and wrong message [#25772](https://github.com/ClickHouse/ClickHouse/pull/25772) ([alesapin](https://github.com/alesapin)).
* MaterializeMySQL: Improved column comments support [#25781](https://github.com/ClickHouse/ClickHouse/pull/25781) ([Storozhuk Kostiantyn](https://github.com/sand6255)).
* Fix ANTRL merge_prewhere_table test [#25782](https://github.com/ClickHouse/ClickHouse/pull/25782) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove dead code from VirtualColumnUtils.cpp [#25787](https://github.com/ClickHouse/ClickHouse/pull/25787) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix some typos in Storage classes [#25796](https://github.com/ClickHouse/ClickHouse/pull/25796) ([Raúl Marín](https://github.com/Algunenano)).
* Fix DateLUT on Darwin [#25803](https://github.com/ClickHouse/ClickHouse/pull/25803) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better test_version_update_after_mutation [#25810](https://github.com/ClickHouse/ClickHouse/pull/25810) ([alesapin](https://github.com/alesapin)).
* Collect stderr.log and stdout.log in all integration tests by default. [#25816](https://github.com/ClickHouse/ClickHouse/pull/25816) ([Vitaly Baranov](https://github.com/vitlibar)).
* METR-41529 [#25819](https://github.com/ClickHouse/ClickHouse/pull/25819) ([egatov](https://github.com/egatov)).
* tests/integration: use iptables --wait [#25823](https://github.com/ClickHouse/ClickHouse/pull/25823) ([Azat Khuzhin](https://github.com/azat)).
* Add a test for [#25611](https://github.com/ClickHouse/ClickHouse/issues/25611) [#25831](https://github.com/ClickHouse/ClickHouse/pull/25831) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix odbc test [#25834](https://github.com/ClickHouse/ClickHouse/pull/25834) ([Kseniia Sumarokova](https://github.com/kssenii)).
* ExpressionCache destruction fix [#25835](https://github.com/ClickHouse/ClickHouse/pull/25835) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix performance tests after converting ProfileEvents to Map type [#25837](https://github.com/ClickHouse/ClickHouse/pull/25837) ([Azat Khuzhin](https://github.com/azat)).
* Correct messages in integration tests. [#25861](https://github.com/ClickHouse/ClickHouse/pull/25861) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix typo in the test 00900_orc_arrow_parquet_maps [#25874](https://github.com/ClickHouse/ClickHouse/pull/25874) ([Kruglov Pavel](https://github.com/Avogar)).
* Improve logging in integration tests. [#25899](https://github.com/ClickHouse/ClickHouse/pull/25899) ([Vitaly Baranov](https://github.com/vitlibar)).
* kerberized HDFS test fix if run in parallel [#25908](https://github.com/ClickHouse/ClickHouse/pull/25908) ([Ilya Golshtein](https://github.com/ilejn)).
* fix special build on clang 11 [#25912](https://github.com/ClickHouse/ClickHouse/pull/25912) ([flynn](https://github.com/ucasfl)).
* Remove obsolete code from init script [#25920](https://github.com/ClickHouse/ClickHouse/pull/25920) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* FunctionInitializeAggregation build fix [#25922](https://github.com/ClickHouse/ClickHouse/pull/25922) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix clang tidy build check [#25939](https://github.com/ClickHouse/ClickHouse/pull/25939) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Build subquery in replaceJoinedTable without parsing [#25941](https://github.com/ClickHouse/ClickHouse/pull/25941) ([Vladimir C](https://github.com/vdimir)).
* Remove experimental ANTLR parser [#25942](https://github.com/ClickHouse/ClickHouse/pull/25942) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Follow-up for [#20470](https://github.com/ClickHouse/ClickHouse/issues/20470) [#25975](https://github.com/ClickHouse/ClickHouse/pull/25975) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Correct test [#25984](https://github.com/ClickHouse/ClickHouse/pull/25984) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix parallel execution of integration tests [#25986](https://github.com/ClickHouse/ClickHouse/pull/25986) ([Vitaly Baranov](https://github.com/vitlibar)).
* Compile aggregate functions perf tests fix [#25989](https://github.com/ClickHouse/ClickHouse/pull/25989) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix alter of settings in `MergeTree` tables [#25995](https://github.com/ClickHouse/ClickHouse/pull/25995) ([Anton Popov](https://github.com/CurtizJ)).
* Fix arcadia [#26002](https://github.com/ClickHouse/ClickHouse/pull/26002) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove old code [#26014](https://github.com/ClickHouse/ClickHouse/pull/26014) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* FunctionsLogical const result for non const arguments fix [#26018](https://github.com/ClickHouse/ClickHouse/pull/26018) ([Maksim Kita](https://github.com/kitaisreal)).
* FunctionSQLJSON ContextPtr build fix [#26022](https://github.com/ClickHouse/ClickHouse/pull/26022) ([Maksim Kita](https://github.com/kitaisreal)).
* Replace print() with logging.debug() in integration tests. [#26023](https://github.com/ClickHouse/ClickHouse/pull/26023) ([Vitaly Baranov](https://github.com/vitlibar)).
* Try to fix some flaky tests [#26032](https://github.com/ClickHouse/ClickHouse/pull/26032) ([Anton Popov](https://github.com/CurtizJ)).
* Fix for ZK watch metric drift in rare conditions [#26034](https://github.com/ClickHouse/ClickHouse/pull/26034) ([nvartolomei](https://github.com/nvartolomei)).
* AsynchronousMetrics: Don't assume temperature is always positive [#26045](https://github.com/ClickHouse/ClickHouse/pull/26045) ([Raúl Marín](https://github.com/Algunenano)).
* Proper fix of serialization of type Map to JSON [#26048](https://github.com/ClickHouse/ClickHouse/pull/26048) ([Anton Popov](https://github.com/CurtizJ)).
* ClickHouse dictionary source secure setting added documentation [#26055](https://github.com/ClickHouse/ClickHouse/pull/26055) ([Maksim Kita](https://github.com/kitaisreal)).
* Add changelog for 21.7 [#26057](https://github.com/ClickHouse/ClickHouse/pull/26057) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix 01791_dist_INSERT_block_structure_mismatch flakiness [#26058](https://github.com/ClickHouse/ClickHouse/pull/26058) ([Azat Khuzhin](https://github.com/azat)).
* Fix logical error with signed and unsigned offset in WindowFrame::checkValid [#26072](https://github.com/ClickHouse/ClickHouse/pull/26072) ([Vladimir C](https://github.com/vdimir)).
* Remove unused code [#26077](https://github.com/ClickHouse/ClickHouse/pull/26077) ([Anton Popov](https://github.com/CurtizJ)).
* Disabling annoying copier tests [#26099](https://github.com/ClickHouse/ClickHouse/pull/26099) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Make graph pipeline rendering compatible with Dagre.JS [#26114](https://github.com/ClickHouse/ClickHouse/pull/26114) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
