---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.7.1.7283-prestable FIXME as compared to v21.6.1.6891-prestable

#### Backward Incompatible Change
* Improved performance of queries with explicitly defined large sets. Added compatibility setting `legacy_column_name_of_tuple_literal`. It makes sense to set it to `true`, while doing rolling update of cluster from version lower than 21.7 to any higher version. Otherwise distributed queries with explicitly defined sets at `IN` clause may fail during update. [#25371](https://github.com/ClickHouse/ClickHouse/pull/25371) ([Anton Popov](https://github.com/CurtizJ)).
* Forward/backward incompatible change of maximum buffer size in clickhouse-keeper. Better to do it now (before production), than later. [#25421](https://github.com/ClickHouse/ClickHouse/pull/25421) ([alesapin](https://github.com/alesapin)).

#### New Feature
* Add support for VFS over HDFS. [#11058](https://github.com/ClickHouse/ClickHouse/pull/11058) ([overshov](https://github.com/overshov)).
* Provides a way to restore replicated table when the data is (possibly) present, but the ZooKeeper metadata is lost. Resolves [#13458](https://github.com/ClickHouse/ClickHouse/issues/13458). [#13652](https://github.com/ClickHouse/ClickHouse/pull/13652) ([Mike Kot](https://github.com/myrrc)).
* Implement `sequenceNextNode()` function useful for `flow analysis`. [#19766](https://github.com/ClickHouse/ClickHouse/pull/19766) ([achimbab](https://github.com/achimbab)).
* Added YAML configuration support to configuration loader. This closes [#3607](https://github.com/ClickHouse/ClickHouse/issues/3607). [#21858](https://github.com/ClickHouse/ClickHouse/pull/21858) ([BoloniniD](https://github.com/BoloniniD)).
* Added dateName function. [#23085](https://github.com/ClickHouse/ClickHouse/pull/23085) ([Daniil Kondratyev](https://github.com/dankondr)).
* Add `quantileBFloat16` aggregate function as well as the corresponding `quantilesBFloat16` and `medianBFloat16`. It is very simple and fast quantile estimator with relative error not more than 0.390625%. This closes [#16641](https://github.com/ClickHouse/ClickHouse/issues/16641). [#23204](https://github.com/ClickHouse/ClickHouse/pull/23204) ([Ivan Novitskiy](https://github.com/RedClusive)).
* Support `ALTER DELETE` queries for `Join` table engine. [#23260](https://github.com/ClickHouse/ClickHouse/pull/23260) ([foolchi](https://github.com/foolchi)).
* Add a new boolean setting `prefer_global_in_and_join` which defaults all IN/JOIN as GLOBAL IN/JOIN. [#23434](https://github.com/ClickHouse/ClickHouse/pull/23434) ([Amos Bird](https://github.com/amosbird)).
* add bitpositionToArray function. [#23843](https://github.com/ClickHouse/ClickHouse/pull/23843) ([kevin wan](https://github.com/MaxWk)).
* Add aggregate function `segmentLengthSum`. [#24250](https://github.com/ClickHouse/ClickHouse/pull/24250) ([flynn](https://github.com/ucasfl)).
* Support structs and maps in Arrow/Parquet/ORC and dictionaries in Arrow input/output formats. Present new setting `output_format_arrow_low_cardinality_as_dictionary`. [#24341](https://github.com/ClickHouse/ClickHouse/pull/24341) ([Kruglov Pavel](https://github.com/Avogar)).
* Support `compile_expression` setting for AARCH64. [#24342](https://github.com/ClickHouse/ClickHouse/pull/24342) ([Maksim Kita](https://github.com/kitaisreal)).
* Now clickhouse-keeper supports ZooKeeper-like `digest` ACLs. [#24448](https://github.com/ClickHouse/ClickHouse/pull/24448) ([alesapin](https://github.com/alesapin)).
* Implements the `h3ToGeo` function. [#24867](https://github.com/ClickHouse/ClickHouse/pull/24867) ([Bharat Nallan](https://github.com/bharatnc)).
* Now query_log has two new columns : initial_query_start_time / initial_query_start_time_microsecond that record the starting time of a distributed query if any. [#25022](https://github.com/ClickHouse/ClickHouse/pull/25022) ([Amos Bird](https://github.com/amosbird)).
* Dictionaries added support for Array type. [#25119](https://github.com/ClickHouse/ClickHouse/pull/25119) ([Maksim Kita](https://github.com/kitaisreal)).
* Add `toJSONString` function to serialize columns to their JSON representations. [#25164](https://github.com/ClickHouse/ClickHouse/pull/25164) ([Amos Bird](https://github.com/amosbird)).
* ClickHouse database created with MaterializeMySQL now contains all column comments from the MySQL database that materialized. [#25199](https://github.com/ClickHouse/ClickHouse/pull/25199) ([Storozhuk Kostiantyn](https://github.com/sand6255)).
* Added function `dateName`. Author [Daniil Kondratyev] (@dankondr). [#25372](https://github.com/ClickHouse/ClickHouse/pull/25372) ([Maksim Kita](https://github.com/kitaisreal)).
* Added function `bitPositionsToArray`. Closes [#23792](https://github.com/ClickHouse/ClickHouse/issues/23792). Author [Kevin Wan] (@MaxWk). [#25394](https://github.com/ClickHouse/ClickHouse/pull/25394) ([Maksim Kita](https://github.com/kitaisreal)).

#### Performance Improvement
* (remove from changelog) Integrate and test experimental compression libraries. Will be available under the flag `allow_experimental_codecs`. This closes [#16775](https://github.com/ClickHouse/ClickHouse/issues/16775). [#17847](https://github.com/ClickHouse/ClickHouse/pull/17847) ([Abi Palagashvili](https://github.com/fibersel)).
* Add exponential backoff to reschedule read attempt in case RabbitMQ queues are empty. Closes [#24340](https://github.com/ClickHouse/ClickHouse/issues/24340). [#24415](https://github.com/ClickHouse/ClickHouse/pull/24415) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Index of type bloom_filter can be used for expressions with `hasAny` function with constant arrays. This closes: [#24291](https://github.com/ClickHouse/ClickHouse/issues/24291). [#24900](https://github.com/ClickHouse/ClickHouse/pull/24900) ([Vasily Nemkov](https://github.com/Enmk)).

#### Improvement
* Fix Zero-Copy replication with several S3 volumes (Fixes [#22679](https://github.com/ClickHouse/ClickHouse/issues/22679)). [#22864](https://github.com/ClickHouse/ClickHouse/pull/22864) ([ianton-ru](https://github.com/ianton-ru)).
* Add ability to push down LIMIT for distributed queries. [#23027](https://github.com/ClickHouse/ClickHouse/pull/23027) ([Azat Khuzhin](https://github.com/azat)).
* Respect `insert_allow_materialized_columns` (allows materialized columns) for INSERT into `Distributed` table. [#23349](https://github.com/ClickHouse/ClickHouse/pull/23349) ([Azat Khuzhin](https://github.com/azat)).
* Here will be listed all the bugs that I am gonna to fix in this PR. [#23518](https://github.com/ClickHouse/ClickHouse/pull/23518) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Display progress for File table engine in clickhouse-local and on INSERT query in clickhouse-client when data is passed to stdin. Closes [#18209](https://github.com/ClickHouse/ClickHouse/issues/18209). [#23656](https://github.com/ClickHouse/ClickHouse/pull/23656) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Handle column name clashes for storage join, close [#20309](https://github.com/ClickHouse/ClickHouse/issues/20309). [#23769](https://github.com/ClickHouse/ClickHouse/pull/23769) ([Vladimir C](https://github.com/vdimir)).
* Add ability to split distributed batch on failures (i.e. due to memory limits, corruptions), under `distributed_directory_monitor_split_batch_on_failure` (OFF by default). [#23864](https://github.com/ClickHouse/ClickHouse/pull/23864) ([Azat Khuzhin](https://github.com/azat)).
* Add standalone `clickhouse-keeper` symlink to the main `clickhouse` binary. Now it's possible to run coordination without the main clickhouse server. [#24059](https://github.com/ClickHouse/ClickHouse/pull/24059) ([alesapin](https://github.com/alesapin)).
* Suppress exceptions from logger code. [#24069](https://github.com/ClickHouse/ClickHouse/pull/24069) ([Azat Khuzhin](https://github.com/azat)).
* Use global settings for query to `VIEW`. Fixed the behavior when queries to `VIEW` use local settings, that leads to errors if setting on `CREATE VIEW` and `SELECT` were different. As for now, `VIEW` won't use these modified settings, but you can still pass additional settings in `SETTINGS` section of `CREATE VIEW` query. Close [#20551](https://github.com/ClickHouse/ClickHouse/issues/20551). [#24095](https://github.com/ClickHouse/ClickHouse/pull/24095) ([Vladimir C](https://github.com/vdimir)).
* Add settings (`connection_auto_close`/`connection_max_tries`/`connection_pool_size`) for MySQL storage engine. [#24146](https://github.com/ClickHouse/ClickHouse/pull/24146) ([Azat Khuzhin](https://github.com/azat)).
* Fix trailing whitespaces in FROM clause with subqueries in multiline mode, and also changes the output of the queries slightly in a more human friendly way. [#24151](https://github.com/ClickHouse/ClickHouse/pull/24151) ([Azat Khuzhin](https://github.com/azat)).
* Recognize IPv4 addresses like `127.0.1.1` as local. This is controversial and closes [#23504](https://github.com/ClickHouse/ClickHouse/issues/23504). Michael Filimonov will test this feature. [#24316](https://github.com/ClickHouse/ClickHouse/pull/24316) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix IPv6 addresses resolving (i.e. fixes `select * from remote('[::1]', system.one)`). [#24319](https://github.com/ClickHouse/ClickHouse/pull/24319) ([Azat Khuzhin](https://github.com/azat)).
* Now query_log has two new columns : `initial_query_start_time / initial_query_start_time_microsecond` that record the starting time of a distributed query if any. [#24388](https://github.com/ClickHouse/ClickHouse/pull/24388) ([Amos Bird](https://github.com/amosbird)).
* Rewrite more columns to possible alias expressions. This may enable better optimization, such as projections. [#24405](https://github.com/ClickHouse/ClickHouse/pull/24405) ([Amos Bird](https://github.com/amosbird)).
* Added optimization, that transforms some functions to reading of subcolumns to reduce amount of read data. E.g., statement `col IS NULL` is transformed to reading of subcolumn `col.null`. Optimization can be enabled by setting `optimize_functions_to_subcolumns`. [#24406](https://github.com/ClickHouse/ClickHouse/pull/24406) ([Anton Popov](https://github.com/CurtizJ)).
* Fix a data race on Keeper shutdown. [#24412](https://github.com/ClickHouse/ClickHouse/pull/24412) ([alesapin](https://github.com/alesapin)).
* Support postgres schema for insert queries. Closes [#24149](https://github.com/ClickHouse/ClickHouse/issues/24149). [#24413](https://github.com/ClickHouse/ClickHouse/pull/24413) ([Kseniia Sumarokova](https://github.com/kssenii)).
* If SSDDictionary is created with DDL query, it can be created only inside user_files directory. [#24466](https://github.com/ClickHouse/ClickHouse/pull/24466) ([Maksim Kita](https://github.com/kitaisreal)).
* Make String-to-Int parser stricter so that `toInt64('+')` will throw. [#24475](https://github.com/ClickHouse/ClickHouse/pull/24475) ([Amos Bird](https://github.com/amosbird)).
* Add merge tree setting `max_parts_to_merge_at_once` which limits the number of parts that can be merged in the background at once. Doesn't affect `OPTIMIZE FINAL` query. Fixes [#1820](https://github.com/ClickHouse/ClickHouse/issues/1820). [#24496](https://github.com/ClickHouse/ClickHouse/pull/24496) ([alesapin](https://github.com/alesapin)).
* Avoid hiding errors like `Limit for rows or bytes to read exceeded` for scalar subqueries. [#24545](https://github.com/ClickHouse/ClickHouse/pull/24545) ([nvartolomei](https://github.com/nvartolomei)).
* Add two Replicated*MergeTree settings: `max_replicated_fetches_network_bandwidth` and `max_replicated_sends_network_bandwidth` which allows to limit maximum speed of replicated fetches/sends for table. Add two server-wide settings (in `default` user profile): `max_replicated_fetches_network_bandwidth_for_server` and `max_replicated_sends_network_bandwidth_for_server` which limit maximum speed of replication for all tables. The settings are not followed perfectly accurately. Turned off by default. Fixes [#1821](https://github.com/ClickHouse/ClickHouse/issues/1821). [#24573](https://github.com/ClickHouse/ClickHouse/pull/24573) ([alesapin](https://github.com/alesapin)).
* Respect `max_distributed_connections` for `insert_distributed_sync` (otherwise for huge clusters and sync insert it may run out of `max_thread_pool_size`). [#24754](https://github.com/ClickHouse/ClickHouse/pull/24754) ([Azat Khuzhin](https://github.com/azat)).
* Fixed a bug in `Replicated` database engine that might rarely cause some replica to skip enqueued DDL query. [#24805](https://github.com/ClickHouse/ClickHouse/pull/24805) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Some queries require multi-pass semantic analysis. Try reusing built sets for `IN` in this case. [#24874](https://github.com/ClickHouse/ClickHouse/pull/24874) ([Amos Bird](https://github.com/amosbird)).
* Allow `not in` operator to be used in partition pruning. [#24894](https://github.com/ClickHouse/ClickHouse/pull/24894) ([Amos Bird](https://github.com/amosbird)).
* Improved logging of S3 errors, no more double spaces in case of empty keys and buckets. [#24897](https://github.com/ClickHouse/ClickHouse/pull/24897) ([Vladimir Chebotarev](https://github.com/excitoon)).
* For distributed query, when `optimize_skip_unused_shards=1`, allow to skip shard with condition like `(sharding key) IN (one-element-tuple)`. (Tuples with many elements were supported. Tuple with single element did not work because it is parsed as literal). [#24930](https://github.com/ClickHouse/ClickHouse/pull/24930) ([Amos Bird](https://github.com/amosbird)).
* Detect linux version at runtime (for worked nested epoll, that is required for `async_socket_for_remote`/`use_hedged_requests`, otherwise remote queries may stuck). [#25067](https://github.com/ClickHouse/ClickHouse/pull/25067) ([Azat Khuzhin](https://github.com/azat)).
* Increase size of background schedule pool to 128 (`background_schedule_pool_size` setting). It allows avoiding replication queue hung on slow zookeeper connection. [#25072](https://github.com/ClickHouse/ClickHouse/pull/25072) ([alesapin](https://github.com/alesapin)).
* Fix topLevelDomain() for IDN hosts (i.e. `example.рф`), before it returns empty string for such hosts. [#25103](https://github.com/ClickHouse/ClickHouse/pull/25103) ([Azat Khuzhin](https://github.com/azat)).
* On server start, parts with incorrect partition ID would not be ever removed, but always detached. [#25070](https://github.com/ClickHouse/ClickHouse/issues/25070). [#25166](https://github.com/ClickHouse/ClickHouse/pull/25166) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Correct memory tracking in aggregate function `topK`. This closes [#25259](https://github.com/ClickHouse/ClickHouse/issues/25259). [#25260](https://github.com/ClickHouse/ClickHouse/pull/25260) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Use separate `clickhouse-bridge` group and user for bridge processes. Set oom_score_adj so the bridges will be first subjects for OOM killer. Set set maximum RSS to 1 GiB. Closes [#23861](https://github.com/ClickHouse/ClickHouse/issues/23861). [#25280](https://github.com/ClickHouse/ClickHouse/pull/25280) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update prompt in `clickhouse-client` and display a message when reconnecting. This closes [#10577](https://github.com/ClickHouse/ClickHouse/issues/10577). [#25281](https://github.com/ClickHouse/ClickHouse/pull/25281) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add support for function `if` with Decimal and Int types on its branches. This closes [#20549](https://github.com/ClickHouse/ClickHouse/issues/20549). This closes [#10142](https://github.com/ClickHouse/ClickHouse/issues/10142). [#25283](https://github.com/ClickHouse/ClickHouse/pull/25283) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add settings `http_max_fields`, `http_max_field_name_size`, `http_max_field_value_size`. [#25296](https://github.com/ClickHouse/ClickHouse/pull/25296) ([Ivan](https://github.com/abyss7)).
* Add == operator on time conditions for sequenceMatch and sequenceCount functions. For eg: sequenceMatch('(?1)(?t==1)(?2)')(time, data = 1, data = 2). [#25299](https://github.com/ClickHouse/ClickHouse/pull/25299) ([Christophe Kalenzaga](https://github.com/mga-chka)).
* Support Interval for LowCardinality, close [#21730](https://github.com/ClickHouse/ClickHouse/issues/21730). [#25410](https://github.com/ClickHouse/ClickHouse/pull/25410) ([Vladimir C](https://github.com/vdimir)).
* Flatbuffers library updated to v.2.0.0. Improvements list https://github.com/google/flatbuffers/releases/tag/v2.0.0. [#25474](https://github.com/ClickHouse/ClickHouse/pull/25474) ([Ilya Yatsishin](https://github.com/qoega)).
* Drop replicas from dirname for internal_replication=true (allows INSERT into Distributed with cluster from any number of replicas, before only 15 replicas was supported, everything more will fail with ENAMETOOLONG while creating directory for async blocks). [#25513](https://github.com/ClickHouse/ClickHouse/pull/25513) ([Azat Khuzhin](https://github.com/azat)).
* Resolve the actual port number bound when a user requests any available port from the operating system. [#25569](https://github.com/ClickHouse/ClickHouse/pull/25569) ([bnaecker](https://github.com/bnaecker)).
* Improve startup time of Distributed engine. [#25663](https://github.com/ClickHouse/ClickHouse/pull/25663) ([Azat Khuzhin](https://github.com/azat)).

#### Bug Fix
* Fix the bug in failover behavior when Engine=Kafka was not able to start consumption if the same consumer had an empty assignment previously. Closes [#21118](https://github.com/ClickHouse/ClickHouse/issues/21118). [#21267](https://github.com/ClickHouse/ClickHouse/pull/21267) ([filimonov](https://github.com/filimonov)).
* Fix waiting of automatic dropping of empty parts. It could lead to full filling of background pool and stuck of replication. [#23315](https://github.com/ClickHouse/ClickHouse/pull/23315) ([Anton Popov](https://github.com/CurtizJ)).
* Column cardinality in join output same as at the input, close [#23351](https://github.com/ClickHouse/ClickHouse/issues/23351), close [#20315](https://github.com/ClickHouse/ClickHouse/issues/20315). [#24061](https://github.com/ClickHouse/ClickHouse/pull/24061) ([Vladimir C](https://github.com/vdimir)).
* Use old modulo function version when used in partition key. Closes [#23508](https://github.com/ClickHouse/ClickHouse/issues/23508). [#24157](https://github.com/ClickHouse/ClickHouse/pull/24157) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Set `max_threads = 1` to fix mutation fail of StorageMemory. Closes [#24274](https://github.com/ClickHouse/ClickHouse/issues/24274). [#24275](https://github.com/ClickHouse/ClickHouse/pull/24275) ([flynn](https://github.com/ucasfl)).
* Allow empty HTTP headers. Fixes [#23901](https://github.com/ClickHouse/ClickHouse/issues/23901). [#24285](https://github.com/ClickHouse/ClickHouse/pull/24285) ([Ivan](https://github.com/abyss7)).
* Fixed a bug in moving Materialized View from Ordinary to Atomic database (`RENAME TABLE` query). Now inner table is moved to new database together with Materialized View. Fixes [#23926](https://github.com/ClickHouse/ClickHouse/issues/23926). [#24309](https://github.com/ClickHouse/ClickHouse/pull/24309) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix drop partition with intersect fake parts. In rare cases there might be parts with mutation version greater than current block number. [#24321](https://github.com/ClickHouse/ClickHouse/pull/24321) ([Amos Bird](https://github.com/amosbird)).
* In "multipart/form-data" message consider the CRLF preceding a boundary as part of it. Fixes [#23905](https://github.com/ClickHouse/ClickHouse/issues/23905). [#24399](https://github.com/ClickHouse/ClickHouse/pull/24399) ([Ivan](https://github.com/abyss7)).
* - Fixed the deadlock that can happen during LDAP role (re)mapping, when LDAP group is mapped to a nonexistent local role. [#24431](https://github.com/ClickHouse/ClickHouse/pull/24431) ([Denis Glazachev](https://github.com/traceon)).
* Fix incorrect monotonicity of toWeek function. This fixes [#24422](https://github.com/ClickHouse/ClickHouse/issues/24422) . This bug was introduced in https://github.com/ClickHouse/ClickHouse/pull/5212 , and was exposed later by smarter partition pruner. [#24446](https://github.com/ClickHouse/ClickHouse/pull/24446) ([Amos Bird](https://github.com/amosbird)).
* In current CH version total_writes.bytes counter decreases too much during the buffer flush. It leads to counter overflow and totalBytes return something around 17.44 EB some time after the flush. This pr should fix it. ... [#24450](https://github.com/ClickHouse/ClickHouse/pull/24450) ([DimasKovas](https://github.com/DimasKovas)).
* Fixed the behavior when query `SYSTEM RESTART REPLICA` or `SYSTEM SYNC REPLICA` is being processed infinitely. This was detected on server with extremely little amount of RAM. [#24457](https://github.com/ClickHouse/ClickHouse/pull/24457) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix usage of tuples in `CREATE .. AS SELECT` queries. [#24464](https://github.com/ClickHouse/ClickHouse/pull/24464) ([Anton Popov](https://github.com/CurtizJ)).
* Enable reading of subcolumns for distributed tables. [#24472](https://github.com/ClickHouse/ClickHouse/pull/24472) ([Anton Popov](https://github.com/CurtizJ)).
* Disallow building uniqXXXXStates of other aggregation states. [#24523](https://github.com/ClickHouse/ClickHouse/pull/24523) ([Raúl Marín](https://github.com/Algunenano)).
* Fixed bug in deserialization of random generator state with might cause some data types such as `AggregateFunction(groupArraySample(N), T))` to behave in a non-deterministic way. [#24538](https://github.com/ClickHouse/ClickHouse/pull/24538) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix bug which can lead to ZooKeeper client hung inside clickhouse-server. [#24721](https://github.com/ClickHouse/ClickHouse/pull/24721) ([alesapin](https://github.com/alesapin)).
* - If ZooKeeper connection was lost and replica was cloned after restoring the connection, its replication queue might contain outdated entries. It's fixed. - Fixed crash when replication queue contains intersecting virtual parts. It may rarely happen if some data part was lost. Print error in log instead of terminating. [#24777](https://github.com/ClickHouse/ClickHouse/pull/24777) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix bug when exception `Mutation was killed` can be thrown to the client on mutation wait when mutation not loaded into memory yet. [#24809](https://github.com/ClickHouse/ClickHouse/pull/24809) ([alesapin](https://github.com/alesapin)).
* Allow NULL values in postgresql protocol. Closes [#22622](https://github.com/ClickHouse/ClickHouse/issues/22622). [#24857](https://github.com/ClickHouse/ClickHouse/pull/24857) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix "Missing columns" exception when joining Distributed Materialized View. [#24870](https://github.com/ClickHouse/ClickHouse/pull/24870) ([Azat Khuzhin](https://github.com/azat)).
* Fix extremely rare bug on low-memory servers which can lead to the inability to perform merges without restart. Possibly fixes [#24603](https://github.com/ClickHouse/ClickHouse/issues/24603). [#24872](https://github.com/ClickHouse/ClickHouse/pull/24872) ([alesapin](https://github.com/alesapin)).
* Fixed possible error 'Cannot read from istream at offset 0' when reading a file from DiskS3. [#24885](https://github.com/ClickHouse/ClickHouse/pull/24885) ([Pavel Kovalenko](https://github.com/Jokser)).
* Fixed bug with declaring S3 disk at root of bucket. Earlier, it reported an error: ``` [heather] 2021.05.10 02:11:11.932234 [ 72790 ] {2ff80b7b-ec53-41cb-ac35-19bb390e1759} <Error> executeQuery: Code: 36, e.displayText() = DB::Exception: Key name is empty in path style S3 URI: (http://172.17.0.2/bucket/) (version 21.6.1.1) (from 127.0.0.1:47994) (in query: SELECT policy_name FROM system.storage_policies), Stack trace (when copying this message, always include the lines below):. [#24898](https://github.com/ClickHouse/ClickHouse/pull/24898) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix possible heap-buffer-overflow in Arrow. [#24922](https://github.com/ClickHouse/ClickHouse/pull/24922) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix limit/offset settings for distributed queries (ignore on the remote nodes). [#24940](https://github.com/ClickHouse/ClickHouse/pull/24940) ([Azat Khuzhin](https://github.com/azat)).
* Fix extremely rare error `Tagging already tagged part` in replication queue during concurrent `alter move/replace partition`. Possibly fixes [#22142](https://github.com/ClickHouse/ClickHouse/issues/22142). [#24961](https://github.com/ClickHouse/ClickHouse/pull/24961) ([alesapin](https://github.com/alesapin)).
* Fix serialization of splitted nested messages in Protobuf format. This PR fixes [#24647](https://github.com/ClickHouse/ClickHouse/issues/24647). [#25000](https://github.com/ClickHouse/ClickHouse/pull/25000) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix potential crash when calculating aggregate function states by aggregation of aggregate function states of other aggregate functions (not a practical use case). See [#24523](https://github.com/ClickHouse/ClickHouse/issues/24523). [#25015](https://github.com/ClickHouse/ClickHouse/pull/25015) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Distinguish KILL MUTATION for different tables (fixes unexpected `Cancelled mutating parts` error). [#25025](https://github.com/ClickHouse/ClickHouse/pull/25025) ([Azat Khuzhin](https://github.com/azat)).
* Fix wrong result when using aggregate projection with **not empty** `GROUP BY` key to execute query with `GROUP BY` by **empty** key. [#25055](https://github.com/ClickHouse/ClickHouse/pull/25055) ([Amos Bird](https://github.com/amosbird)).
* Fix bug which allows creating tables with columns referencing themselves like `a UInt32 ALIAS a + 1` or `b UInt32 MATERIALIZED b`. Fixes [#24910](https://github.com/ClickHouse/ClickHouse/issues/24910), [#24292](https://github.com/ClickHouse/ClickHouse/issues/24292). [#25059](https://github.com/ClickHouse/ClickHouse/pull/25059) ([alesapin](https://github.com/alesapin)).
* Fix bug with constant maps in mapContains that lead to error `empty column was returned by function mapContains`. Closes [#25077](https://github.com/ClickHouse/ClickHouse/issues/25077). [#25080](https://github.com/ClickHouse/ClickHouse/pull/25080) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix crash in query with cross join and `joined_subquery_requires_alias = 0`. Fixes [#24011](https://github.com/ClickHouse/ClickHouse/issues/24011). [#25082](https://github.com/ClickHouse/ClickHouse/pull/25082) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix possible parts loss after updating up to 21.5 in case table used `UUID` in partition key. (It is not recommended to use `UUID` in partition key). Fixes [#25070](https://github.com/ClickHouse/ClickHouse/issues/25070). [#25127](https://github.com/ClickHouse/ClickHouse/pull/25127) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Do not use table's projection for `SELECT` with `FINAL`. It is not supported yet. [#25163](https://github.com/ClickHouse/ClickHouse/pull/25163) ([Amos Bird](https://github.com/amosbird)).
* Fixed an error which occurred while inserting a subset of columns using CSVWithNames format. Fixes [#25129](https://github.com/ClickHouse/ClickHouse/issues/25129). [#25169](https://github.com/ClickHouse/ClickHouse/pull/25169) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix TOCTOU error in installation script. [#25277](https://github.com/ClickHouse/ClickHouse/pull/25277) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix incorrect behaviour and UBSan report in big integers. In previous versions `CAST(1e19 AS UInt128)` returned zero. [#25279](https://github.com/ClickHouse/ClickHouse/pull/25279) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix joinGetOrNull with not-nullable columns. This fixes [#24261](https://github.com/ClickHouse/ClickHouse/issues/24261). [#25288](https://github.com/ClickHouse/ClickHouse/pull/25288) ([Amos Bird](https://github.com/amosbird)).
* Fix error `Bad cast from type DB::ColumnLowCardinality to DB::ColumnVector<char8_t>` for queries where `LowCardinality` argument was used for IN (this bug appeared in 21.6). Fixes [#25187](https://github.com/ClickHouse/ClickHouse/issues/25187). [#25290](https://github.com/ClickHouse/ClickHouse/pull/25290) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix Logical Error Cannot sum Array/Tuple in min/maxMap. [#25298](https://github.com/ClickHouse/ClickHouse/pull/25298) ([Kruglov Pavel](https://github.com/Avogar)).
* Support `SimpleAggregateFunction(LowCardinality)` for `SummingMergeTree`. Fixes [#25134](https://github.com/ClickHouse/ClickHouse/issues/25134). [#25300](https://github.com/ClickHouse/ClickHouse/pull/25300) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* On ZooKeeper connection loss `ReplicatedMergeTree` table might wait for background operations to complete before trying to reconnect. It's fixed, now background operations are stopped forcefully. [#25306](https://github.com/ClickHouse/ClickHouse/pull/25306) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix the possibility of non-deterministic behaviour of the `quantileDeterministic` function and similar. This closes [#20480](https://github.com/ClickHouse/ClickHouse/issues/20480). [#25313](https://github.com/ClickHouse/ClickHouse/pull/25313) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix lost `WHERE` condition in expression-push-down optimization of query plan (setting `query_plan_filter_push_down = 1` by default). Fixes [#25368](https://github.com/ClickHouse/ClickHouse/issues/25368). [#25370](https://github.com/ClickHouse/ClickHouse/pull/25370) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix `REPLACE` column transformer when used in DDL by correctly quoting the formatted query. This fixes [#23925](https://github.com/ClickHouse/ClickHouse/issues/23925). [#25391](https://github.com/ClickHouse/ClickHouse/pull/25391) ([Amos Bird](https://github.com/amosbird)).
* Fix segfault when sharding_key is absent in task config for copier. [#25419](https://github.com/ClickHouse/ClickHouse/pull/25419) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix excessive underscore before the names of the preprocessed configuration files. [#25431](https://github.com/ClickHouse/ClickHouse/pull/25431) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix convertion of datetime with timezone for MySQL, PostgreSQL, ODBC. Closes [#5057](https://github.com/ClickHouse/ClickHouse/issues/5057). [#25528](https://github.com/ClickHouse/ClickHouse/pull/25528) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix segfault in `Arrow` format when using `Decimal256`. Add arrow `Decimal256` support. [#25531](https://github.com/ClickHouse/ClickHouse/pull/25531) ([Kruglov Pavel](https://github.com/Avogar)).
* Fixed case, when sometimes conversion of postgres arrays resulted in String data type, not n-dimensional array, because `attndims` works incorrectly in some cases. Closes [#24804](https://github.com/ClickHouse/ClickHouse/issues/24804). [#25538](https://github.com/ClickHouse/ClickHouse/pull/25538) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix wrong totals for query `WITH TOTALS` and `WITH FILL`. Fixes [#20872](https://github.com/ClickHouse/ClickHouse/issues/20872). [#25539](https://github.com/ClickHouse/ClickHouse/pull/25539) ([Anton Popov](https://github.com/CurtizJ)).
* Fix error `Key expression contains comparison between inconvertible types` for queries with `ARRAY JOIN` in case if array is used in primary key. Fixes [#8247](https://github.com/ClickHouse/ClickHouse/issues/8247). [#25546](https://github.com/ClickHouse/ClickHouse/pull/25546) ([Anton Popov](https://github.com/CurtizJ)).
* Fix bug which can lead to intersecting parts after merges with TTL: `Part all_40_40_0 is covered by all_40_40_1 but should be merged into all_40_41_1. This shouldn't happen often.`. [#25549](https://github.com/ClickHouse/ClickHouse/pull/25549) ([alesapin](https://github.com/alesapin)).
* Fix restore S3 table. [#25601](https://github.com/ClickHouse/ClickHouse/pull/25601) ([ianton-ru](https://github.com/ianton-ru)).
* Fix null pointer dereference in `EXPLAIN AST` without query. [#25631](https://github.com/ClickHouse/ClickHouse/pull/25631) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* `REPLACE PARTITION` might be ignored in rare cases if the source partition was empty. It's fixed. Fixes [#24869](https://github.com/ClickHouse/ClickHouse/issues/24869). [#25665](https://github.com/ClickHouse/ClickHouse/pull/25665) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed `No such file or directory` error on moving `Distributed` table between databases. Fixes [#24971](https://github.com/ClickHouse/ClickHouse/issues/24971). [#25667](https://github.com/ClickHouse/ClickHouse/pull/25667) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix mysql select user() return empty. Fixes [#25683](https://github.com/ClickHouse/ClickHouse/issues/25683). [#25697](https://github.com/ClickHouse/ClickHouse/pull/25697) ([sundyli](https://github.com/sundy-li)).
* Fix data race when querying `system.clusters` while reloading the cluster configuration at the same time. [#25737](https://github.com/ClickHouse/ClickHouse/pull/25737) ([Amos Bird](https://github.com/amosbird)).

#### Build/Testing/Packaging Improvement
* Ubuntu 20.04 is now used to run integration tests, docker-compose version used to run integration tests is updated to 1.28.2. Environment variables now take effect on docker-compose. Rework test_dictionaries_all_layouts_separate_sources to allow parallel run. [#20393](https://github.com/ClickHouse/ClickHouse/pull/20393) ([Ilya Yatsishin](https://github.com/qoega)).
* - Testing for big ints using the following functions: * Arithmetic * Array, tuple, and map * Bit * Comparison * Conversion * Logical * Mathematical * Null * Rounding - Creating a table with columns that use the data types. [#24350](https://github.com/ClickHouse/ClickHouse/pull/24350) ([MyroTk](https://github.com/MyroTk)).
* Add libfuzzer tests for YAMLParser class. [#24480](https://github.com/ClickHouse/ClickHouse/pull/24480) ([BoloniniD](https://github.com/BoloniniD)).
* Adding support to save clickhouse server logs in TestFlows check. [#24504](https://github.com/ClickHouse/ClickHouse/pull/24504) ([vzakaznikov](https://github.com/vzakaznikov)).
* Integration tests configuration has special treatment for dictionaries. Removed remaining dictionaries manual setup. [#24728](https://github.com/ClickHouse/ClickHouse/pull/24728) ([Ilya Yatsishin](https://github.com/qoega)).
* Add integration test cases to cover JDBC bridge. [#25047](https://github.com/ClickHouse/ClickHouse/pull/25047) ([Zhichun Wu](https://github.com/zhicwu)).
* Disabling extended precision data types TestFlows tests. [#25125](https://github.com/ClickHouse/ClickHouse/pull/25125) ([vzakaznikov](https://github.com/vzakaznikov)).
* Fix using Yandex dockerhub registries for TestFlows. [#25133](https://github.com/ClickHouse/ClickHouse/pull/25133) ([vzakaznikov](https://github.com/vzakaznikov)).
* Adding `leadInFrame` and `lagInFrame` window functions TestFlows tests. [#25144](https://github.com/ClickHouse/ClickHouse/pull/25144) ([vzakaznikov](https://github.com/vzakaznikov)).
* Enable build with s3 module in osx [#25217](https://github.com/ClickHouse/ClickHouse/issues/25217). [#25218](https://github.com/ClickHouse/ClickHouse/pull/25218) ([kevin wan](https://github.com/MaxWk)).
* - Added rounding to mathematical and arithmetic function tests for consistent snapshot comparison. - Cleaned up test names so they're more uniform. [#25297](https://github.com/ClickHouse/ClickHouse/pull/25297) ([MyroTk](https://github.com/MyroTk)).
* Increase LDAP verification cooldown performance tests timeout to 600 sec. [#25374](https://github.com/ClickHouse/ClickHouse/pull/25374) ([vzakaznikov](https://github.com/vzakaznikov)).
* Enabling TestFlows RBAC tests. [#25498](https://github.com/ClickHouse/ClickHouse/pull/25498) ([vzakaznikov](https://github.com/vzakaznikov)).
* Add CI check for darwin-aarch64 cross-compilation. [#25560](https://github.com/ClickHouse/ClickHouse/pull/25560) ([Ivan](https://github.com/abyss7)).
* Changed CSS theme to dark for better code highlighting. [#25682](https://github.com/ClickHouse/ClickHouse/pull/25682) ([Mike Kot](https://github.com/myrrc)).

#### Other
* Introduce ASTTableIdentifier into the code. [#16401](https://github.com/ClickHouse/ClickHouse/pull/16401) ([Ivan](https://github.com/abyss7)).
* Use std::filesystem instad of Poco::File. [#23657](https://github.com/ClickHouse/ClickHouse/pull/23657) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix init script so it does not print 'usage' message for each 'status' command run. [#25046](https://github.com/ClickHouse/ClickHouse/pull/25046) ([Denis Korenevskiy](https://github.com/DenKoren)).
* Fix cron.d task so it does not spam with email messages about current service status. [#25050](https://github.com/ClickHouse/ClickHouse/pull/25050) ([Denis Korenevskiy](https://github.com/DenKoren)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Pass Settings to aggregate function creator"'. [#24524](https://github.com/ClickHouse/ClickHouse/pull/24524) ([Vladimir C](https://github.com/vdimir)).
* NO CL ENTRY:  'Revert "Add initial_query_start_time to query log"'. [#25021](https://github.com/ClickHouse/ClickHouse/pull/25021) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Add run-id option to integration tests"'. [#25526](https://github.com/ClickHouse/ClickHouse/pull/25526) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Revert "Implement h3ToGeo function"'. [#25593](https://github.com/ClickHouse/ClickHouse/pull/25593) ([Alexander Tokmakov](https://github.com/tavplubix)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Part movement between shards [#17871](https://github.com/ClickHouse/ClickHouse/pull/17871) ([nvartolomei](https://github.com/nvartolomei)).
* Pass Settings to aggregate function creator [#22762](https://github.com/ClickHouse/ClickHouse/pull/22762) ([Vladimir C](https://github.com/vdimir)).
* Add uniqTheta in performance test [#23311](https://github.com/ClickHouse/ClickHouse/pull/23311) ([Kruglov Pavel](https://github.com/Avogar)).
* More pytest fixes [#23538](https://github.com/ClickHouse/ClickHouse/pull/23538) ([Ivan](https://github.com/abyss7)).
* Improved `test_storage_s3_get_unstable` [#23976](https://github.com/ClickHouse/ClickHouse/pull/23976) ([Vladimir Chebotarev](https://github.com/excitoon)).
* CompileExpressions comparison function constant case fix [#24023](https://github.com/ClickHouse/ClickHouse/pull/24023) ([Maksim Kita](https://github.com/kitaisreal)).
* Added llvm-project submodule [#24030](https://github.com/ClickHouse/ClickHouse/pull/24030) ([Maksim Kita](https://github.com/kitaisreal)).
* complain about unstable perf test queries [#24049](https://github.com/ClickHouse/ClickHouse/pull/24049) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Changelog 21.5 [#24098](https://github.com/ClickHouse/ClickHouse/pull/24098) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Implement antlr parser for projections [#24245](https://github.com/ClickHouse/ClickHouse/pull/24245) ([Amos Bird](https://github.com/amosbird)).
* Try to fix GROUP BY _shard_num in a different way [#24252](https://github.com/ClickHouse/ClickHouse/pull/24252) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Use memmove in PODArray::insert to handle memory overlapping. [#24271](https://github.com/ClickHouse/ClickHouse/pull/24271) ([Fu Zhe](https://github.com/fuzhe1989)).
* ExpressionActions compile only necessary places [#24273](https://github.com/ClickHouse/ClickHouse/pull/24273) ([Maksim Kita](https://github.com/kitaisreal)).
* consolidate connection loss handling in fuzzer [#24290](https://github.com/ClickHouse/ClickHouse/pull/24290) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Skip data finalization when doing projection materialization. [#24296](https://github.com/ClickHouse/ClickHouse/pull/24296) ([Amos Bird](https://github.com/amosbird)).
* One more error to retry in clickhouse-test [#24307](https://github.com/ClickHouse/ClickHouse/pull/24307) ([alesapin](https://github.com/alesapin)).
* Merging [#23461](https://github.com/ClickHouse/ClickHouse/issues/23461) [#24311](https://github.com/ClickHouse/ClickHouse/pull/24311) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Remove AutoArray [#24320](https://github.com/ClickHouse/ClickHouse/pull/24320) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Compile expressions added partition by test [#24323](https://github.com/ClickHouse/ClickHouse/pull/24323) ([Maksim Kita](https://github.com/kitaisreal)).
* PODArray insert in the middle tests [#24333](https://github.com/ClickHouse/ClickHouse/pull/24333) ([Maksim Kita](https://github.com/kitaisreal)).
* remove retries from fast test [#24338](https://github.com/ClickHouse/ClickHouse/pull/24338) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Better parallelism for functional tests [#24349](https://github.com/ClickHouse/ClickHouse/pull/24349) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* AARCH64 hash tables benchmark [#24364](https://github.com/ClickHouse/ClickHouse/pull/24364) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix diagnostics in documentation script [#24379](https://github.com/ClickHouse/ClickHouse/pull/24379) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky 01033_quota_dcl [#24393](https://github.com/ClickHouse/ClickHouse/pull/24393) ([alesapin](https://github.com/alesapin)).
* Fix logical error AggregateFunctionFactory returned nullptr [#24398](https://github.com/ClickHouse/ClickHouse/pull/24398) ([Kruglov Pavel](https://github.com/Avogar)).
* Add log record for removed from AWS S3 keys [#24400](https://github.com/ClickHouse/ClickHouse/pull/24400) ([ianton-ru](https://github.com/ianton-ru)).
* Added AggregateFunctionSegmentLengthSum to ya.make [#24408](https://github.com/ClickHouse/ClickHouse/pull/24408) ([Maksim Kita](https://github.com/kitaisreal)).
* Stateless tests fixes [#24411](https://github.com/ClickHouse/ClickHouse/pull/24411) ([Azat Khuzhin](https://github.com/azat)).
* Function constant result with nonconstant arguments [#24417](https://github.com/ClickHouse/ClickHouse/pull/24417) ([Maksim Kita](https://github.com/kitaisreal)).
* Libunwind update version [#24419](https://github.com/ClickHouse/ClickHouse/pull/24419) ([Maksim Kita](https://github.com/kitaisreal)).
* Do not built clickhouse-keeper w/o NuRaft [#24421](https://github.com/ClickHouse/ClickHouse/pull/24421) ([Azat Khuzhin](https://github.com/azat)).
* Switch message level to WARNING for FAIL_ON_UNSUPPORTED_OPTIONS_COMBINATION=OFF [#24423](https://github.com/ClickHouse/ClickHouse/pull/24423) ([Azat Khuzhin](https://github.com/azat)).
* Merging "experimental compression codecs" [#24424](https://github.com/ClickHouse/ClickHouse/pull/24424) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix formatting of negative values [#24427](https://github.com/ClickHouse/ClickHouse/pull/24427) ([Azat Khuzhin](https://github.com/azat)).
* Fix dictionary functions documentation [#24432](https://github.com/ClickHouse/ClickHouse/pull/24432) ([Maksim Kita](https://github.com/kitaisreal)).
* Mark false positives for PVS-Studio [#24434](https://github.com/ClickHouse/ClickHouse/pull/24434) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* ActionsDAG compile expressions update [#24442](https://github.com/ClickHouse/ClickHouse/pull/24442) ([Maksim Kita](https://github.com/kitaisreal)).
* LLVM remove orc jit library [#24443](https://github.com/ClickHouse/ClickHouse/pull/24443) ([Maksim Kita](https://github.com/kitaisreal)).
* Add YAMLParser to ya.make [#24447](https://github.com/ClickHouse/ClickHouse/pull/24447) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix cli argument in clickhouse-server.init [#24449](https://github.com/ClickHouse/ClickHouse/pull/24449) ([Vladimir C](https://github.com/vdimir)).
* Fix fast test [#24454](https://github.com/ClickHouse/ClickHouse/pull/24454) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix flaky test 01085_max_distributed_connections [#24455](https://github.com/ClickHouse/ClickHouse/pull/24455) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Manually disable LLVM parts submodule update [#24460](https://github.com/ClickHouse/ClickHouse/pull/24460) ([Maksim Kita](https://github.com/kitaisreal)).
* Account total_rows_approx as soon as possible [#24462](https://github.com/ClickHouse/ClickHouse/pull/24462) ([Azat Khuzhin](https://github.com/azat)).
* Fix header mismatch for UNION. [#24463](https://github.com/ClickHouse/ClickHouse/pull/24463) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Try to improve kafka flaky test [#24465](https://github.com/ClickHouse/ClickHouse/pull/24465) ([filimonov](https://github.com/filimonov)).
* CompileExpression cached functions with context fix [#24468](https://github.com/ClickHouse/ClickHouse/pull/24468) ([Maksim Kita](https://github.com/kitaisreal)).
* Fixed IFunction then typos [#24469](https://github.com/ClickHouse/ClickHouse/pull/24469) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix several cases in cast operator [#24471](https://github.com/ClickHouse/ClickHouse/pull/24471) ([Anton Popov](https://github.com/CurtizJ)).
* MemoryTracker new no throw [#24483](https://github.com/ClickHouse/ClickHouse/pull/24483) ([Maksim Kita](https://github.com/kitaisreal)).
* Revent libunwind [#24485](https://github.com/ClickHouse/ClickHouse/pull/24485) ([Maksim Kita](https://github.com/kitaisreal)).
* Log file name on error in FileChecker ctor [#24489](https://github.com/ClickHouse/ClickHouse/pull/24489) ([Vladimir C](https://github.com/vdimir)).
* Remove containers in intergational runner entrypoint [#24492](https://github.com/ClickHouse/ClickHouse/pull/24492) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix benign race (detected by clang-12) in Keeper snapshots [#24499](https://github.com/ClickHouse/ClickHouse/pull/24499) ([alesapin](https://github.com/alesapin)).
* [backport] Find only opened PRs by label [#24501](https://github.com/ClickHouse/ClickHouse/pull/24501) ([Ivan](https://github.com/abyss7)).
* shellcheck fix [#24512](https://github.com/ClickHouse/ClickHouse/pull/24512) ([Ilya Yatsishin](https://github.com/qoega)).
* Do not peerdir enabled-by-default libcxxabi-parts [#24518](https://github.com/ClickHouse/ClickHouse/pull/24518) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Merging [#22762](https://github.com/ClickHouse/ClickHouse/issues/22762) [#24525](https://github.com/ClickHouse/ClickHouse/pull/24525) ([Vladimir C](https://github.com/vdimir)).
* Fix Arcadia  [#24527](https://github.com/ClickHouse/ClickHouse/pull/24527) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Make `get/check/read/list` requests always read in Keeper [#24533](https://github.com/ClickHouse/ClickHouse/pull/24533) ([alesapin](https://github.com/alesapin)).
* calculate perf test precision thresholds from historical data [#24534](https://github.com/ClickHouse/ClickHouse/pull/24534) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Update jit_example [#24550](https://github.com/ClickHouse/ClickHouse/pull/24550) ([Maksim Kita](https://github.com/kitaisreal)).
* Update test_multiple_disks [#24560](https://github.com/ClickHouse/ClickHouse/pull/24560) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix flaky test [#24561](https://github.com/ClickHouse/ClickHouse/pull/24561) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix arcadia [#24563](https://github.com/ClickHouse/ClickHouse/pull/24563) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix avro [#24569](https://github.com/ClickHouse/ClickHouse/pull/24569) ([Ilya Yatsishin](https://github.com/qoega)).
* Refactor MergeTreeDataSelectExecutor [#24574](https://github.com/ClickHouse/ClickHouse/pull/24574) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* allow inheriting from a named window in window definition [#24576](https://github.com/ClickHouse/ClickHouse/pull/24576) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* do not auto-apply -OrNull combinator to pure window functions [#24579](https://github.com/ClickHouse/ClickHouse/pull/24579) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* fix ORDER BY after window fuctions over Distributed [#24580](https://github.com/ClickHouse/ClickHouse/pull/24580) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* ast fuzzer: determine server death more robustly [#24584](https://github.com/ClickHouse/ClickHouse/pull/24584) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Enable tests, utils and examples in builds with clang-tidy [#24587](https://github.com/ClickHouse/ClickHouse/pull/24587) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* more fuzzer fixes [#24690](https://github.com/ClickHouse/ClickHouse/pull/24690) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix flaky integration tests [#24691](https://github.com/ClickHouse/ClickHouse/pull/24691) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix alter table drop projection if exists [#24692](https://github.com/ClickHouse/ClickHouse/pull/24692) ([Amos Bird](https://github.com/amosbird)).
* Block memory tracker earlier in `tryLogCurrentException` [#24722](https://github.com/ClickHouse/ClickHouse/pull/24722) ([alesapin](https://github.com/alesapin)).
* Minor fixes in AggregateFunctionSegmentLengthSumData [#24729](https://github.com/ClickHouse/ClickHouse/pull/24729) ([Vladimir C](https://github.com/vdimir)).
* remove mutable references to Context from IFunction interface [#24732](https://github.com/ClickHouse/ClickHouse/pull/24732) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* MemoryTracker enable throw logical error [#24733](https://github.com/ClickHouse/ClickHouse/pull/24733) ([Maksim Kita](https://github.com/kitaisreal)).
* support expressions in window frame [#24734](https://github.com/ClickHouse/ClickHouse/pull/24734) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Updated libunwind [#24735](https://github.com/ClickHouse/ClickHouse/pull/24735) ([Maksim Kita](https://github.com/kitaisreal)).
* ExecuteScalarSubqueriesVisitor fix error code style check [#24736](https://github.com/ClickHouse/ClickHouse/pull/24736) ([Maksim Kita](https://github.com/kitaisreal)).
* Process config w/o extensions as XML format [#24763](https://github.com/ClickHouse/ClickHouse/pull/24763) ([Azat Khuzhin](https://github.com/azat)).
* Update NuRaft [#24775](https://github.com/ClickHouse/ClickHouse/pull/24775) ([alesapin](https://github.com/alesapin)).
* Fix empty part set with force_use_projection = 1 [#24782](https://github.com/ClickHouse/ClickHouse/pull/24782) ([Amos Bird](https://github.com/amosbird)).
* Better exception for invalid projection creation [#24785](https://github.com/ClickHouse/ClickHouse/pull/24785) ([Amos Bird](https://github.com/amosbird)).
* Improve "Cannot schedule a task" error message [#24786](https://github.com/ClickHouse/ClickHouse/pull/24786) ([Azat Khuzhin](https://github.com/azat)).
* Fix 00953_zookeeper_suetin_deduplication_bug [#24801](https://github.com/ClickHouse/ClickHouse/pull/24801) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Don't capture temporary references in ZooKeeper client callbacks. [#24803](https://github.com/ClickHouse/ClickHouse/pull/24803) ([alesapin](https://github.com/alesapin)).
* Small improvement for StorageMaterializedView::getActionLock(...) [#24806](https://github.com/ClickHouse/ClickHouse/pull/24806) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Make ContextPtr const by default. [#24808](https://github.com/ClickHouse/ClickHouse/pull/24808) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix typo. Remove the "allow_experimental_bigint_types" setting. [#24812](https://github.com/ClickHouse/ClickHouse/pull/24812) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* ExpressionJIT remove unncecessary logging [#24813](https://github.com/ClickHouse/ClickHouse/pull/24813) ([Maksim Kita](https://github.com/kitaisreal)).
* ExpressionJIT simplify loop [#24814](https://github.com/ClickHouse/ClickHouse/pull/24814) ([Maksim Kita](https://github.com/kitaisreal)).
* Fixed clang tidy [#24821](https://github.com/ClickHouse/ClickHouse/pull/24821) ([Maksim Kita](https://github.com/kitaisreal)).
* Merging [#23260](https://github.com/ClickHouse/ClickHouse/issues/23260) [#24822](https://github.com/ClickHouse/ClickHouse/pull/24822) ([Anton Popov](https://github.com/CurtizJ)).
* Simplify code around TraceCollector, alternative to [#24829](https://github.com/ClickHouse/ClickHouse/issues/24829) [#24833](https://github.com/ClickHouse/ClickHouse/pull/24833) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Some improvements in stress test [#24835](https://github.com/ClickHouse/ClickHouse/pull/24835) ([alesapin](https://github.com/alesapin)).
* Rename ContextConstPtr to ContextPtr. [#24855](https://github.com/ClickHouse/ClickHouse/pull/24855) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Reverted libunwind from upstream [#24860](https://github.com/ClickHouse/ClickHouse/pull/24860) ([Maksim Kita](https://github.com/kitaisreal)).
* Testflows Extended Precision Data Type testing - Adding snapshots for output comparison. [#24861](https://github.com/ClickHouse/ClickHouse/pull/24861) ([MyroTk](https://github.com/MyroTk)).
* clickhouse-client: echo hint improvements [#24863](https://github.com/ClickHouse/ClickHouse/pull/24863) ([Azat Khuzhin](https://github.com/azat)).
* docs: update requests (to fix conflicts with urllib3) [#24865](https://github.com/ClickHouse/ClickHouse/pull/24865) ([Azat Khuzhin](https://github.com/azat)).
* Trying to resurrect woboq [#24875](https://github.com/ClickHouse/ClickHouse/pull/24875) ([alesapin](https://github.com/alesapin)).
* Get rid of std::stringstream in Suggest [#24882](https://github.com/ClickHouse/ClickHouse/pull/24882) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Suppress RocksDB error [#24886](https://github.com/ClickHouse/ClickHouse/pull/24886) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Remove some outdated integration tests [#24911](https://github.com/ClickHouse/ClickHouse/pull/24911) ([alesapin](https://github.com/alesapin)).
* Mute test_memory_consumption before [#24784](https://github.com/ClickHouse/ClickHouse/issues/24784) [#24919](https://github.com/ClickHouse/ClickHouse/pull/24919) ([Ilya Yatsishin](https://github.com/qoega)).
* Update something in KeyCondition [#24920](https://github.com/ClickHouse/ClickHouse/pull/24920) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Relax hung check [#24929](https://github.com/ClickHouse/ClickHouse/pull/24929) ([alesapin](https://github.com/alesapin)).
* some perf test script improvements [#24938](https://github.com/ClickHouse/ClickHouse/pull/24938) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* RFC: clickhouse-test: do not substitude db name in stderr by default [#24939](https://github.com/ClickHouse/ClickHouse/pull/24939) ([Azat Khuzhin](https://github.com/azat)).
* Add test issue [#23430](https://github.com/ClickHouse/ClickHouse/issues/23430) [#24941](https://github.com/ClickHouse/ClickHouse/pull/24941) ([filimonov](https://github.com/filimonov)).
* Followup fixes for integration tests [#24954](https://github.com/ClickHouse/ClickHouse/pull/24954) ([alesapin](https://github.com/alesapin)).
* Fix bad error message in docker entrypoint [#24955](https://github.com/ClickHouse/ClickHouse/pull/24955) ([filimonov](https://github.com/filimonov)).
* Fix endless wait in replica clone [#24957](https://github.com/ClickHouse/ClickHouse/pull/24957) ([alesapin](https://github.com/alesapin)).
* Remove subprocess_call from cluster.py [#24959](https://github.com/ClickHouse/ClickHouse/pull/24959) ([Ilya Yatsishin](https://github.com/qoega)).
* Delete support for waiting on queue- entries, is this dead code? [#24960](https://github.com/ClickHouse/ClickHouse/pull/24960) ([nvartolomei](https://github.com/nvartolomei)).
* Fix the test after [#20393](https://github.com/ClickHouse/ClickHouse/issues/20393) [#24967](https://github.com/ClickHouse/ClickHouse/pull/24967) ([filimonov](https://github.com/filimonov)).
* Try fix `test_consistent_parts_after_clone_replica` [#24968](https://github.com/ClickHouse/ClickHouse/pull/24968) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix typo in usage section in s3 documentation [#24970](https://github.com/ClickHouse/ClickHouse/pull/24970) ([presto53](https://github.com/presto53)).
* Cleanup iptables and containers on session start [#24973](https://github.com/ClickHouse/ClickHouse/pull/24973) ([Ilya Yatsishin](https://github.com/qoega)).
* Part movement between shards ACL [#24979](https://github.com/ClickHouse/ClickHouse/pull/24979) ([nvartolomei](https://github.com/nvartolomei)).
* Cleanup changelog script [#24987](https://github.com/ClickHouse/ClickHouse/pull/24987) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add changelog for 21.6 [#24989](https://github.com/ClickHouse/ClickHouse/pull/24989) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* clickhouse-test: fix log_comment for .sql tests [#24999](https://github.com/ClickHouse/ClickHouse/pull/24999) ([Azat Khuzhin](https://github.com/azat)).
* DictionaryLoader unnecessary dictionary configuration creation fix [#25001](https://github.com/ClickHouse/ClickHouse/pull/25001) ([Maksim Kita](https://github.com/kitaisreal)).
* Compression codecs refactoring [#25002](https://github.com/ClickHouse/ClickHouse/pull/25002) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Maybe Minio starts for too long in tests [#25007](https://github.com/ClickHouse/ClickHouse/pull/25007) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad test [#25012](https://github.com/ClickHouse/ClickHouse/pull/25012) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Disks fix ya.make [#25031](https://github.com/ClickHouse/ClickHouse/pull/25031) ([Maksim Kita](https://github.com/kitaisreal)).
* tests: disable suggestions for expect tests that does not requires it [#25033](https://github.com/ClickHouse/ClickHouse/pull/25033) ([Azat Khuzhin](https://github.com/azat)).
* fix jemalloc build on OS_DARWIN [#25034](https://github.com/ClickHouse/ClickHouse/pull/25034) ([sdk2](https://github.com/sdk2)).
* Update waitForTableReplicaToProcessLogEntry comments [#25037](https://github.com/ClickHouse/ClickHouse/pull/25037) ([nvartolomei](https://github.com/nvartolomei)).
* Remove database before model name in docs [#25038](https://github.com/ClickHouse/ClickHouse/pull/25038) ([Kruglov Pavel](https://github.com/Avogar)).
* odbc fix [#25045](https://github.com/ClickHouse/ClickHouse/pull/25045) ([Kseniia Sumarokova](https://github.com/kssenii)).
* test for attach partition from [#25060](https://github.com/ClickHouse/ClickHouse/pull/25060) ([Denny Crane](https://github.com/den-crane)).
* AggregateFunctionAnyHeavyData use fixed size type [#25066](https://github.com/ClickHouse/ClickHouse/pull/25066) ([Maksim Kita](https://github.com/kitaisreal)).
* Update Dockerfile [#25078](https://github.com/ClickHouse/ClickHouse/pull/25078) ([Ivan](https://github.com/abyss7)).
* Trying to debug fetches bandwith test failures [#25079](https://github.com/ClickHouse/ClickHouse/pull/25079) ([alesapin](https://github.com/alesapin)).
* Remove strange timeout in test [#25084](https://github.com/ClickHouse/ClickHouse/pull/25084) ([alesapin](https://github.com/alesapin)).
* Remove copypaste from StorageReplicatedMergeTree [#25087](https://github.com/ClickHouse/ClickHouse/pull/25087) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Less timeouts in integration tests [#25111](https://github.com/ClickHouse/ClickHouse/pull/25111) ([alesapin](https://github.com/alesapin)).
* Better odbc integration test [#25113](https://github.com/ClickHouse/ClickHouse/pull/25113) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix flaky check report in CI runner [#25126](https://github.com/ClickHouse/ClickHouse/pull/25126) ([alesapin](https://github.com/alesapin)).
* Better hdfs tests [#25128](https://github.com/ClickHouse/ClickHouse/pull/25128) ([Ilya Yatsishin](https://github.com/qoega)).
* Use zstd/include in ya.make [#25145](https://github.com/ClickHouse/ClickHouse/pull/25145) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Adds a better way to include binary resources [#25146](https://github.com/ClickHouse/ClickHouse/pull/25146) ([bnaecker](https://github.com/bnaecker)).
* check for row_policy defined using user() function [#25147](https://github.com/ClickHouse/ClickHouse/pull/25147) ([Denny Crane](https://github.com/den-crane)).
* Update Roaring Bitmaps just in case [#25151](https://github.com/ClickHouse/ClickHouse/pull/25151) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Move code to more appropriate place [#25152](https://github.com/ClickHouse/ClickHouse/pull/25152) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Dictionary sources add update lag option [#25161](https://github.com/ClickHouse/ClickHouse/pull/25161) ([Maksim Kita](https://github.com/kitaisreal)).
* RewriteFunctionToSubcolumnVisitor add into ya.make [#25162](https://github.com/ClickHouse/ClickHouse/pull/25162) ([Maksim Kita](https://github.com/kitaisreal)).
* Enable back the ANTLR in .sql [#25170](https://github.com/ClickHouse/ClickHouse/pull/25170) ([Ivan](https://github.com/abyss7)).
* Added ExecutablePool documentation [#25196](https://github.com/ClickHouse/ClickHouse/pull/25196) ([Maksim Kita](https://github.com/kitaisreal)).
* Do not optimize query plan for mutations. [#25197](https://github.com/ClickHouse/ClickHouse/pull/25197) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Dictionary added update field documentation [#25198](https://github.com/ClickHouse/ClickHouse/pull/25198) ([Maksim Kita](https://github.com/kitaisreal)).
* Dictionaries attribute support default nullable type [#25203](https://github.com/ClickHouse/ClickHouse/pull/25203) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix tests [#25204](https://github.com/ClickHouse/ClickHouse/pull/25204) ([Ivan](https://github.com/abyss7)).
* Try run tests with Replicated database in parallel [#25210](https://github.com/ClickHouse/ClickHouse/pull/25210) ([Alexander Tokmakov](https://github.com/tavplubix)).
* More integration tests improvements [#25212](https://github.com/ClickHouse/ClickHouse/pull/25212) ([Ilya Yatsishin](https://github.com/qoega)).
* Add function toJSONString to ya.make [#25246](https://github.com/ClickHouse/ClickHouse/pull/25246) ([Maksim Kita](https://github.com/kitaisreal)).
* Minor change [#25247](https://github.com/ClickHouse/ClickHouse/pull/25247) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add missed #include <condition_variable> [#25248](https://github.com/ClickHouse/ClickHouse/pull/25248) ([Matwey V. Kornilov](https://github.com/matwey)).
* Add test for [#4113](https://github.com/ClickHouse/ClickHouse/issues/4113) [#25249](https://github.com/ClickHouse/ClickHouse/pull/25249) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for [#11535](https://github.com/ClickHouse/ClickHouse/issues/11535) [#25250](https://github.com/ClickHouse/ClickHouse/pull/25250) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#9932](https://github.com/ClickHouse/ClickHouse/issues/9932) [#25253](https://github.com/ClickHouse/ClickHouse/pull/25253) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Copy-paste some code [#25264](https://github.com/ClickHouse/ClickHouse/pull/25264) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor change [#25265](https://github.com/ClickHouse/ClickHouse/pull/25265) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#20315](https://github.com/ClickHouse/ClickHouse/issues/20315) [#25266](https://github.com/ClickHouse/ClickHouse/pull/25266) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add missed #include <optional> [#25267](https://github.com/ClickHouse/ClickHouse/pull/25267) ([Matwey V. Kornilov](https://github.com/matwey)).
* test for `PARTITION BY 0 * id` [#25274](https://github.com/ClickHouse/ClickHouse/pull/25274) ([Denny Crane](https://github.com/den-crane)).
* Enable TestFlows LDAP tests [#25278](https://github.com/ClickHouse/ClickHouse/pull/25278) ([vzakaznikov](https://github.com/vzakaznikov)).
* Add a test for [#17964](https://github.com/ClickHouse/ClickHouse/issues/17964) [#25285](https://github.com/ClickHouse/ClickHouse/pull/25285) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#17367](https://github.com/ClickHouse/ClickHouse/issues/17367) [#25286](https://github.com/ClickHouse/ClickHouse/pull/25286) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove some code from KeyCondition. [#25295](https://github.com/ClickHouse/ClickHouse/pull/25295) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* CMake dictionaries disable debug info fix [#25301](https://github.com/ClickHouse/ClickHouse/pull/25301) ([Maksim Kita](https://github.com/kitaisreal)).
* Merge ext into common [#25303](https://github.com/ClickHouse/ClickHouse/pull/25303) ([Maksim Kita](https://github.com/kitaisreal)).
* test for null array orc load [#25304](https://github.com/ClickHouse/ClickHouse/pull/25304) ([Denny Crane](https://github.com/den-crane)).
* Improve Replicated database tests [#25305](https://github.com/ClickHouse/ClickHouse/pull/25305) ([Alexander Tokmakov](https://github.com/tavplubix)).
* SimpleCache key constructor improvement [#25307](https://github.com/ClickHouse/ClickHouse/pull/25307) ([Maksim Kita](https://github.com/kitaisreal)).
* Catch ErrnoException during parts cleaning [#25309](https://github.com/ClickHouse/ClickHouse/pull/25309) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky test 01520_client_print_query_id and others. [#25311](https://github.com/ClickHouse/ClickHouse/pull/25311) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in quantileTiming [#25314](https://github.com/ClickHouse/ClickHouse/pull/25314) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update test_ttl_replicated [#25317](https://github.com/ClickHouse/ClickHouse/pull/25317) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix `00601_kill_running_query` [#25318](https://github.com/ClickHouse/ClickHouse/pull/25318) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Use signal 15 in restart_with_latest_version [#25323](https://github.com/ClickHouse/ClickHouse/pull/25323) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Setting min_count_to_compile_expression fix [#25332](https://github.com/ClickHouse/ClickHouse/pull/25332) ([Maksim Kita](https://github.com/kitaisreal)).
* Function formatDateTime fix code comments [#25334](https://github.com/ClickHouse/ClickHouse/pull/25334) ([Maksim Kita](https://github.com/kitaisreal)).
* Improve Replicated database tests 2 [#25373](https://github.com/ClickHouse/ClickHouse/pull/25373) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add a test for [#23163](https://github.com/ClickHouse/ClickHouse/issues/23163) [#25390](https://github.com/ClickHouse/ClickHouse/pull/25390) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Rename & reimport murmurhash sources from smhasher repo [#25400](https://github.com/ClickHouse/ClickHouse/pull/25400) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Add test from issue [#20624](https://github.com/ClickHouse/ClickHouse/issues/20624) [#25409](https://github.com/ClickHouse/ClickHouse/pull/25409) ([Vladimir C](https://github.com/vdimir)).
* Turn off WITH_COVERAGE in build with clang-tidy [#25417](https://github.com/ClickHouse/ClickHouse/pull/25417) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix container-overflow in replxx during incremental search (Ctrl-R) [#25427](https://github.com/ClickHouse/ClickHouse/pull/25427) ([Azat Khuzhin](https://github.com/azat)).
* DatabaseMySQL rename [#25430](https://github.com/ClickHouse/ClickHouse/pull/25430) ([Maksim Kita](https://github.com/kitaisreal)).
* Support REPLACE DICTIONARY, CREATE OR REPLACE DICTIONARY queries [#25444](https://github.com/ClickHouse/ClickHouse/pull/25444) ([Maksim Kita](https://github.com/kitaisreal)).
* Add a test for [#8417](https://github.com/ClickHouse/ClickHouse/issues/8417) [#25446](https://github.com/ClickHouse/ClickHouse/pull/25446) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove assumeMutable from removeColumnNullability [#25454](https://github.com/ClickHouse/ClickHouse/pull/25454) ([Vladimir C](https://github.com/vdimir)).
* DataTypeLowCardinality support DataTypeInterval tests [#25458](https://github.com/ClickHouse/ClickHouse/pull/25458) ([Maksim Kita](https://github.com/kitaisreal)).
* Add run-id option to integration tests [#25459](https://github.com/ClickHouse/ClickHouse/pull/25459) ([alesapin](https://github.com/alesapin)).
* Stable NOT chain formatting [#25494](https://github.com/ClickHouse/ClickHouse/pull/25494) ([Azat Khuzhin](https://github.com/azat)).
* Fix alternative stack for SIGSEGV handling [#25509](https://github.com/ClickHouse/ClickHouse/pull/25509) ([Azat Khuzhin](https://github.com/azat)).
* Catch "Maximum parse depth" error in fuzzer [#25510](https://github.com/ClickHouse/ClickHouse/pull/25510) ([Azat Khuzhin](https://github.com/azat)).
* Fix NOT parsing [#25520](https://github.com/ClickHouse/ClickHouse/pull/25520) ([Azat Khuzhin](https://github.com/azat)).
* Catch TOO_DEEP_RECURSION in fuzzer for formatted query too [#25521](https://github.com/ClickHouse/ClickHouse/pull/25521) ([Azat Khuzhin](https://github.com/azat)).
* Fix some bugs in integration tests [#25525](https://github.com/ClickHouse/ClickHouse/pull/25525) ([alesapin](https://github.com/alesapin)).
* Fix query progress [#25545](https://github.com/ClickHouse/ClickHouse/pull/25545) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add test for progress bar [#25551](https://github.com/ClickHouse/ClickHouse/pull/25551) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix some tests [#25564](https://github.com/ClickHouse/ClickHouse/pull/25564) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix flaky test 01249_flush_interactive.sh [#25565](https://github.com/ClickHouse/ClickHouse/pull/25565) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* METR-41529 [#25568](https://github.com/ClickHouse/ClickHouse/pull/25568) ([egatov](https://github.com/egatov)).
* clickhouse-client: fix NULL dereference for --param w/o value [#25579](https://github.com/ClickHouse/ClickHouse/pull/25579) ([Azat Khuzhin](https://github.com/azat)).
* Remove only symlinks during force_restore_data of Atomic engine [#25582](https://github.com/ClickHouse/ClickHouse/pull/25582) ([Azat Khuzhin](https://github.com/azat)).
* clickhouse-test: use basename (instead of full path) for log_comment [#25583](https://github.com/ClickHouse/ClickHouse/pull/25583) ([Azat Khuzhin](https://github.com/azat)).
* Fix typo in hardware failure error message [#25584](https://github.com/ClickHouse/ClickHouse/pull/25584) ([Stas Kelvich](https://github.com/kelvich)).
* Small change in Roaring Bitmaps [#25604](https://github.com/ClickHouse/ClickHouse/pull/25604) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix ANTLR parser and enable it back in CI [#25638](https://github.com/ClickHouse/ClickHouse/pull/25638) ([Ivan](https://github.com/abyss7)).
* Fix alternative stack (MINSIGSTKSZ) and stack size check under osx [#25654](https://github.com/ClickHouse/ClickHouse/pull/25654) ([Azat Khuzhin](https://github.com/azat)).
* Enable MurmurHash in ArcadiaBuild [#25666](https://github.com/ClickHouse/ClickHouse/pull/25666) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Add working test [#25720](https://github.com/ClickHouse/ClickHouse/pull/25720) ([alesapin](https://github.com/alesapin)).
* Compile expressions updated documentation [#25725](https://github.com/ClickHouse/ClickHouse/pull/25725) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix some more missed includes [#25732](https://github.com/ClickHouse/ClickHouse/pull/25732) ([Matwey V. Kornilov](https://github.com/matwey)).
* Fix native macOS (Xcode) builds [#25736](https://github.com/ClickHouse/ClickHouse/pull/25736) ([Denis Glazachev](https://github.com/traceon)).
* Fix arcadia [#25738](https://github.com/ClickHouse/ClickHouse/pull/25738) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Change error code in LIVE VIEW [#25739](https://github.com/ClickHouse/ClickHouse/pull/25739) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Testing Improvement

* * Add join related options to stress tests. [#25200](https://github.com/ClickHouse/ClickHouse/pull/25200) ([Vladimir C](https://github.com/vdimir)).
