---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.5.8.21-stable FIXME as compared to v21.5.7.9-stable

#### Bug Fix
* Backported in [#25849](https://github.com/ClickHouse/ClickHouse/issues/25849): `CAST` from `Date` to `DateTime` (or `DateTime64`) was not using the timezone of the `DateTime` type. It can also affect the comparison between `Date` and `DateTime`. Inference of the common type for `Date` and `DateTime` also was not using the corresponding timezone. It affected the results of function `if` and array construction. Closes [#24128](https://github.com/ClickHouse/ClickHouse/issues/24128). [#24129](https://github.com/ClickHouse/ClickHouse/pull/24129) ([Maksim Kita](https://github.com/kitaisreal)).
* Backported in [#25679](https://github.com/ClickHouse/ClickHouse/issues/25679): Fixed bug in deserialization of random generator state with might cause some data types such as `AggregateFunction(groupArraySample(N), T))` to behave in a non-deterministic way. [#24538](https://github.com/ClickHouse/ClickHouse/pull/24538) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#25556](https://github.com/ClickHouse/ClickHouse/issues/25556): Fix potential crash when calculating aggregate function states by aggregation of aggregate function states of other aggregate functions (not a practical use case). See [#24523](https://github.com/ClickHouse/ClickHouse/issues/24523). [#25015](https://github.com/ClickHouse/ClickHouse/pull/25015) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#25767](https://github.com/ClickHouse/ClickHouse/issues/25767): Fix assertion in PREWHERE with non-uint8 type, close [#19589](https://github.com/ClickHouse/ClickHouse/issues/19589). [#25484](https://github.com/ClickHouse/ClickHouse/pull/25484) ([Vladimir C](https://github.com/vdimir)).
* Backported in [#25636](https://github.com/ClickHouse/ClickHouse/issues/25636): Fix wrong totals for query `WITH TOTALS` and `WITH FILL`. Fixes [#20872](https://github.com/ClickHouse/ClickHouse/issues/20872). [#25539](https://github.com/ClickHouse/ClickHouse/pull/25539) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#25653](https://github.com/ClickHouse/ClickHouse/issues/25653): Fix null pointer dereference in `EXPLAIN AST` without query. [#25631](https://github.com/ClickHouse/ClickHouse/pull/25631) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#25715](https://github.com/ClickHouse/ClickHouse/issues/25715): `REPLACE PARTITION` might be ignored in rare cases if the source partition was empty. It's fixed. Fixes [#24869](https://github.com/ClickHouse/ClickHouse/issues/24869). [#25665](https://github.com/ClickHouse/ClickHouse/pull/25665) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#25695](https://github.com/ClickHouse/ClickHouse/issues/25695): Fixed `No such file or directory` error on moving `Distributed` table between databases. Fixes [#24971](https://github.com/ClickHouse/ClickHouse/issues/24971). [#25667](https://github.com/ClickHouse/ClickHouse/pull/25667) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#25754](https://github.com/ClickHouse/ClickHouse/issues/25754): Fix data race when querying `system.clusters` while reloading the cluster configuration at the same time. [#25737](https://github.com/ClickHouse/ClickHouse/pull/25737) ([Amos Bird](https://github.com/amosbird)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backport unrelated changes, which fixes aliases bug [#25680](https://github.com/ClickHouse/ClickHouse/pull/25680) ([alesapin](https://github.com/alesapin)).
* ExpressionCache destruction fix [#25835](https://github.com/ClickHouse/ClickHouse/pull/25835) ([Maksim Kita](https://github.com/kitaisreal)).
