---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.1.1.5646-prestable FIXME as compared to v20.12.1.5236-prestable

#### Backward Incompatible Change
* Prohibit toUnixTimestamp(Date()) (before it just returns UInt16 representation of Date). [#17376](https://github.com/ClickHouse/ClickHouse/pull/17376) ([Azat Khuzhin](https://github.com/azat)).
* Removed aggregate functions `timeSeriesGroupSum`, `timeSeriesGroupRateSum` because a friend of mine said they never worked. This fixes [#16869](https://github.com/ClickHouse/ClickHouse/issues/16869). If you have luck using these functions, write a email to clickhouse-feedback@yandex-team.com. [#17423](https://github.com/ClickHouse/ClickHouse/pull/17423) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The setting `input_format_null_as_default` is enabled by default. [#17525](https://github.com/ClickHouse/ClickHouse/pull/17525) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Set `insert_quorum_parallel` to 1 by default. It is significantly more convenient to use than "sequential" quorum inserts. But if you rely to sequential consistency, you should set the setting back to zero. [#17567](https://github.com/ClickHouse/ClickHouse/pull/17567) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Restrict `ALTER MODIFY SETTING` from changing storage settings that affects data parts (`write_final_mark` and `enable_mixed_granularity_parts`). [#18306](https://github.com/ClickHouse/ClickHouse/pull/18306) ([Amos Bird](https://github.com/amosbird)).
* Check settings constraints for profile settings from config. Server will fail to start if users.xml contain settings that do not meet corresponding constraints. [#18486](https://github.com/ClickHouse/ClickHouse/pull/18486) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Remove `sumburConsistentHash` function. This closes [#18120](https://github.com/ClickHouse/ClickHouse/issues/18120). [#18656](https://github.com/ClickHouse/ClickHouse/pull/18656) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add `DIV` and `MOD` operators. `DIV` implements integer division. This is needed for MySQL compatibility and for `sqllogictest`. This closes [#18707](https://github.com/ClickHouse/ClickHouse/issues/18707). It may introduce incompatibilities if you are using DIV or MOD as column names or aliases. In case of incompatibility, write aliases after AS keyword or wrap identifiers in quotes (either double quotes or backquotes). [#18760](https://github.com/ClickHouse/ClickHouse/pull/18760) ([Du Chuan](https://github.com/spongedu)).

#### New Feature
* Use https://github.com/lemire/fast_float to parse floating point numbers. [#16787](https://github.com/ClickHouse/ClickHouse/pull/16787) ([Maksim Kita](https://github.com/kitaisreal)).
* ... [#16819](https://github.com/ClickHouse/ClickHouse/pull/16819) ([pronvis](https://github.com/pronvis)).
* Provide a new aggregator combinator : `-SimpleState` to build SimpleAggregateFunction types via query. It's useful for defining MaterializedView of AggregatingMergeTree engine, and will benefit projections too. [#16853](https://github.com/ClickHouse/ClickHouse/pull/16853) ([Amos Bird](https://github.com/amosbird)).
* Added `mannWitneyUTest`, `studentTTest` and `welchTTest` aggregate functions. Refactored RankCorr a bit. [#16883](https://github.com/ClickHouse/ClickHouse/pull/16883) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add a setting optimize_on_insert. When enabled, do the same transformation for INSERTed block of data as if merge was done on this block (e.g. Replacing, Collapsing, Aggregating...). This setting will be enabled as default. This can influence Materialized View and MaterializeMySQL behaviour (see detailed description). This closes [#10683](https://github.com/ClickHouse/ClickHouse/issues/10683). [#16954](https://github.com/ClickHouse/ClickHouse/pull/16954) ([Kruglov Pavel](https://github.com/Avogar)).
* add ```*.zst``` compression/decompression support.It enables using ```*.zst``` in ```file()``` function and ```Content-encoding: zstd``` in http client.This closes [#16791 ](https://github.com/ClickHouse/ClickHouse/issues/16791). [#17144](https://github.com/ClickHouse/ClickHouse/pull/17144) ([Abi Palagashvili](https://github.com/fibersel)).
* * IP Dictionary supports `IPv4` / `IPv6` types directly. [#17571](https://github.com/ClickHouse/ClickHouse/pull/17571) ([Vladimir C](https://github.com/vdimir)).
* related: [#16176](https://github.com/ClickHouse/ClickHouse/issues/16176) Usage: ``` set limit = 10; set offset = 20; ``` this two settings will affect SELECT query as if it is added like ``` select * from ($your_original_select_query) tmp limit xxx offset xxx; ```. [#17633](https://github.com/ClickHouse/ClickHouse/pull/17633) ([hexiaoting](https://github.com/hexiaoting)).
* Add asynchronous metrics on total amount of rows, bytes and parts in MergeTree tables. This fix [#11714](https://github.com/ClickHouse/ClickHouse/issues/11714). [#17639](https://github.com/ClickHouse/ClickHouse/pull/17639) ([flynn](https://github.com/ucasfl)).
* Introduce `DETACH TABLE/VIEW ... PERMANENTLY` syntax, so that after restarting the table does not reappear back automatically (only by explicit request). The table can still be attached back using the short syntax ATTACH TABLE. Implements [#5555](https://github.com/ClickHouse/ClickHouse/issues/5555). Fixes [#13850](https://github.com/ClickHouse/ClickHouse/issues/13850). [#17642](https://github.com/ClickHouse/ClickHouse/pull/17642) ([filimonov](https://github.com/filimonov)).
* Adds a new table called `system.distributed_ddl_queue` that displays the queries in the DDL worker queue. [#17656](https://github.com/ClickHouse/ClickHouse/pull/17656) ([Bharat Nallan](https://github.com/bharatnc)).
* Add function `encodeXMLComponent` to escape characters to place string into XML text node or attribute. [#17659](https://github.com/ClickHouse/ClickHouse/pull/17659) ([nauta](https://github.com/nautaa)).
* Now clickhouse-client supports opening EDITOR to edit commands. `Alt-Shift-E`. [#17665](https://github.com/ClickHouse/ClickHouse/pull/17665) ([Amos Bird](https://github.com/amosbird)).
* Add support for PROXYv1 protocol to wrap native TCP interface. Allow quotas to be keyed by proxy-forwarded IP address (applied for PROXYv1 address and for X-Forwarded-For from HTTP interface). This is useful when you provide access to ClickHouse only via trusted proxy (e.g. CloudFlare) but want to account user resources by their original IP addresses. This fixes [#17268](https://github.com/ClickHouse/ClickHouse/issues/17268). [#17707](https://github.com/ClickHouse/ClickHouse/pull/17707) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add ability to use custom TLD list in functions `firstSignificantSubdomainCustom`, `cutToFirstSignificantSubdomainCustom`. [#17748](https://github.com/ClickHouse/ClickHouse/pull/17748) ([Azat Khuzhin](https://github.com/azat)).
* Clickhouse-benchmark added query parameter. [#17832](https://github.com/ClickHouse/ClickHouse/pull/17832) ([Maksim Kita](https://github.com/kitaisreal)).
* Extended `OPTIMIZE ... DEDUPLICATE` syntax to allow explicit (or implicit with asterisk/column transformers) list of columns to check for duplicates on. ... [#17846](https://github.com/ClickHouse/ClickHouse/pull/17846) ([Vasily Nemkov](https://github.com/Enmk)).
* Add settings `min_compress_block_size` and `max_compress_block_size` to MergeTreeSettings, which have higher priority than the global settings and take effect when they are set. close [13890](https://github.com/ClickHouse/ClickHouse/issues/13890). [#17867](https://github.com/ClickHouse/ClickHouse/pull/17867) ([flynn](https://github.com/ucasfl)).
* Implemented `ATTACH TABLE name FROM 'path/to/data/' (col1 Type1, ...` query. It creates new table with provided structure and attaches table data from provided directory in `user_files`. [#17903](https://github.com/ClickHouse/ClickHouse/pull/17903) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Added `arrayMin`, `arrayMax`, `arrayAvg` aggregation functions. [#18032](https://github.com/ClickHouse/ClickHouse/pull/18032) ([Maksim Kita](https://github.com/kitaisreal)).
* Support `SHOW SETTINGS` statement to show parameters in system.settings. `SHOW CHANGED SETTINGS` and `LIKE/ILIKE` clause are also supported. [#18056](https://github.com/ClickHouse/ClickHouse/pull/18056) ([Jianmei Zhang](https://github.com/zhangjmruc)).
* Allow create table as select with columns specification. Example `CREATE TABLE t1 (x String) ENGINE = Memory AS SELECT 1;`. [#18060](https://github.com/ClickHouse/ClickHouse/pull/18060) ([Maksim Kita](https://github.com/kitaisreal)).
* - IP Dictionary supports key fetching. Resolves [#18241](https://github.com/ClickHouse/ClickHouse/issues/18241). [#18480](https://github.com/ClickHouse/ClickHouse/pull/18480) ([Vladimir C](https://github.com/vdimir)).
* Implemented `REPLACE TABLE` and `CREATE OR REPLACE TABLE` queries. [#18521](https://github.com/ClickHouse/ClickHouse/pull/18521) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Added function `byteSize` to estimate of uncompressed byte size of its arguments in memory. E.g. for UInt32 argument it will return constant 4, for String argument - the string length + 9. The function can take multiple arguments. The typical application is byteSize(*). [#18579](https://github.com/ClickHouse/ClickHouse/pull/18579) ([Ping Yu](https://github.com/pingyu)).
* Add `query_id` column to `system.part_log` for inserted parts. closes [#10097](https://github.com/ClickHouse/ClickHouse/issues/10097). [#18644](https://github.com/ClickHouse/ClickHouse/pull/18644) ([flynn](https://github.com/ucasfl)).
* Now we have a new storage setting `max_partitions_to_read` for tables in the MergeTree family. It limits the max number of partitions that can be accessed in one query. A user setting `force_max_partition_limit` is also added to enforce this constraint. [#18712](https://github.com/ClickHouse/ClickHouse/pull/18712) ([Amos Bird](https://github.com/amosbird)).
* Function `position` now supports `position(needle in haystack)` synax for SQL compatibility. This closes [#18701](https://github.com/ClickHouse/ClickHouse/issues/18701). ... [#18779](https://github.com/ClickHouse/ClickHouse/pull/18779) ([Jianmei Zhang](https://github.com/zhangjmruc)).

#### Performance Improvement
* Slightly improved performance of float parsing. [#16809](https://github.com/ClickHouse/ClickHouse/pull/16809) ([Maksim Kita](https://github.com/kitaisreal)).
* Improved performance of function `repeat`. [#16937](https://github.com/ClickHouse/ClickHouse/pull/16937) ([satanson](https://github.com/satanson)).
* Fix performance of reading from `Merge` tables over huge number of `MergeTree` tables. Fixes [#7748](https://github.com/ClickHouse/ClickHouse/issues/7748). [#16988](https://github.com/ClickHouse/ClickHouse/pull/16988) ([Anton Popov](https://github.com/CurtizJ)).
* Now the `-If` combinator is devirtualized, and `count` is properly vectorized. This is for https://github.com/ClickHouse/ClickHouse/pull/17041. [#17043](https://github.com/ClickHouse/ClickHouse/pull/17043) ([Amos Bird](https://github.com/amosbird)).
* Improve performance of AggregatingMergeTree w/ SimpleAggregateFunction(String) in PK. [#17109](https://github.com/ClickHouse/ClickHouse/pull/17109) ([Azat Khuzhin](https://github.com/azat)).
* Add `remerge_sort_lowered_memory_bytes_ratio` setting (If memory usage after remerge does not reduced by this ratio, remerge will be disabled). [#17539](https://github.com/ClickHouse/ClickHouse/pull/17539) ([Azat Khuzhin](https://github.com/azat)).
* Speedup `IPv6CIDRToRange` implementation. [#17569](https://github.com/ClickHouse/ClickHouse/pull/17569) ([Vladimir C](https://github.com/vdimir)).
* Using dragonbox algorithm for float to string conversion instead of ryu. [#17831](https://github.com/ClickHouse/ClickHouse/pull/17831) ([Maksim Kita](https://github.com/kitaisreal)).
* Optimized read for StorageMemory. [#18052](https://github.com/ClickHouse/ClickHouse/pull/18052) ([Maksim Kita](https://github.com/kitaisreal)).
* Don't send empty blocks to shards on synchronous INSERT into Distributed table. This closes [#14571](https://github.com/ClickHouse/ClickHouse/issues/14571). [#18775](https://github.com/ClickHouse/ClickHouse/pull/18775) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Replace `PODArray` with `PODArrayWithStackMemory` in `AggregateFunctionWindowFunnelData` to improvement `windowFunnel` function performance. [#18817](https://github.com/ClickHouse/ClickHouse/pull/18817) ([flynn](https://github.com/ucasfl)).
* Add `--no-system-table` option for `clickhouse-local` to run without system tables. This avoids initialization of `DateLUT` that may take noticeable amount of time (tens of milliseconds) at startup. [#18899](https://github.com/ClickHouse/ClickHouse/pull/18899) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* - New IP Dictionary implementation with lower memory consumption, improved performance for some cases, and fixed bugs. [#16804](https://github.com/ClickHouse/ClickHouse/pull/16804) ([Vladimir C](https://github.com/vdimir)).
* Added proper authentication using environment, `~/.aws` and `AssumeRole` for S3 client. [#16856](https://github.com/ClickHouse/ClickHouse/pull/16856) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Support HTTP proxy and HTTPS S3 endpoint configuration. [#16861](https://github.com/ClickHouse/ClickHouse/pull/16861) ([Pavel Kovalenko](https://github.com/Jokser)).
* When `-OrNull` combinator combined `-If`, `-Merge`, `-MergeState`, `-State` combinators, we should put `-OrNull` in front. [#16935](https://github.com/ClickHouse/ClickHouse/pull/16935) ([flynn](https://github.com/ucasfl)).
* - Add configuration for multi zookeeper clusters. [#17070](https://github.com/ClickHouse/ClickHouse/pull/17070) ([fastio](https://github.com/fastio)).
* - Add limit for http redirects in request to S3 storage ('s3_max_redirects'). [#17220](https://github.com/ClickHouse/ClickHouse/pull/17220) ([ianton-ru](https://github.com/ianton-ru)).
* Now set indices will work with `GLOBAL IN`. This fixes [#17232](https://github.com/ClickHouse/ClickHouse/issues/17232) , [#5576](https://github.com/ClickHouse/ClickHouse/issues/5576) . [#17253](https://github.com/ClickHouse/ClickHouse/pull/17253) ([Amos Bird](https://github.com/amosbird)).
* Avoid possible stack overflow in bigint conversion. Big integers are experimental. [#17269](https://github.com/ClickHouse/ClickHouse/pull/17269) ([flynn](https://github.com/ucasfl)).
* Improved minimal Web UI: add history; add sharing support; avoid race condition of different requests; add request in-flight and ready indicators; add favicon; detect Ctrl+Enter if textarea is not in focus. [#17293](https://github.com/ClickHouse/ClickHouse/pull/17293) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to use `optimize_move_to_prewhere` optimization with compact parts, when sizes of columns are unknown. [#17330](https://github.com/ClickHouse/ClickHouse/pull/17330) ([Anton Popov](https://github.com/CurtizJ)).
* Implement `countSubstrings()`/`countSubstringsCaseInsensitive()`/`countSubstringsCaseInsensitiveUTF8()` (Count the number of substring occurrences). [#17347](https://github.com/ClickHouse/ClickHouse/pull/17347) ([Azat Khuzhin](https://github.com/azat)).
* Add eof check in receiveHello to prevent getting `Attempt to read after eof` exception. [#17365](https://github.com/ClickHouse/ClickHouse/pull/17365) ([Kruglov Pavel](https://github.com/Avogar)).
* Replaced `malloc` with `new`, so that the `MemoryTracker` takes this memory into account. [#17412](https://github.com/ClickHouse/ClickHouse/pull/17412) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix parsing of SETTINGS clause of the INSERT ... SELECT ... SETTINGS query. [#17414](https://github.com/ClickHouse/ClickHouse/pull/17414) ([Azat Khuzhin](https://github.com/azat)).
* Multiple improvements in `./clickhouse install` script. [#17421](https://github.com/ClickHouse/ClickHouse/pull/17421) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Simplify Sys/V init script. It was not working on Ubuntu 12.04. [#17428](https://github.com/ClickHouse/ClickHouse/pull/17428) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Now queries coming to the server via MySQL and PostgreSQL protocols have distinctive interface types (which can be seen in the `interface` column of the table`system.query_log`): `4` for MySQL, and `5` for PostgreSQL, instead of formerly used `1` which is now used for the native protocol only. [#17437](https://github.com/ClickHouse/ClickHouse/pull/17437) ([Vitaly Baranov](https://github.com/vitlibar)).
* Allow specifying [TTL](https://clickhouse.tech/docs/en/engines/table-engines/mergetree-family/mergetree/#mergetree-table-ttl) to remove old entries from [system log tables](https://clickhouse.tech/docs/en/operations/system-tables/), using the `<ttl>` attribute in `config.xml`. [#17438](https://github.com/ClickHouse/ClickHouse/pull/17438) ([Du Chuan](https://github.com/spongedu)).
* Add functions countMatches/countMatchesCaseInsensitive. [#17459](https://github.com/ClickHouse/ClickHouse/pull/17459) ([Azat Khuzhin](https://github.com/azat)).
* Return dynamic columns like MATERIALIZED / ALIAS for wildcard query when switches `asterisk_include_materialized_columns` and `asterisk_include_alias_columns` are turned on. [#17462](https://github.com/ClickHouse/ClickHouse/pull/17462) ([Ken Chen](https://github.com/chenziliang)).
* Export asynchronous metrics of all servers current threads. It's useful to track down issues like https://github.com/ClickHouse-Extras/poco/pull/28. [#17463](https://github.com/ClickHouse/ClickHouse/pull/17463) ([Amos Bird](https://github.com/amosbird)).
* Export current max ddl entry executed by DDLWorker. It's useful to check if DDLWorker hangs somewhere. [#17464](https://github.com/ClickHouse/ClickHouse/pull/17464) ([Amos Bird](https://github.com/amosbird)).
* Query obfuscator: avoid usage of some SQL keywords for identifier names. [#17526](https://github.com/ClickHouse/ClickHouse/pull/17526) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow query parameters in UPDATE statement of ALTER query. Fixes [#10976](https://github.com/ClickHouse/ClickHouse/issues/10976). [#17563](https://github.com/ClickHouse/ClickHouse/pull/17563) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Don't throw "Too many parts" error in the middle of INSERT query. [#17566](https://github.com/ClickHouse/ClickHouse/pull/17566) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to reload symbols from debug file. This PR also fixes a build-id issue. [#17637](https://github.com/ClickHouse/ClickHouse/pull/17637) ([Amos Bird](https://github.com/amosbird)).
* This fixes [#17457](https://github.com/ClickHouse/ClickHouse/issues/17457). [#17641](https://github.com/ClickHouse/ClickHouse/pull/17641) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Switch to patched version of RocksDB (from ClickHouse-Extras). [#17643](https://github.com/ClickHouse/ClickHouse/pull/17643) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Do not ignore server memory limits during Buffer flush. [#17646](https://github.com/ClickHouse/ClickHouse/pull/17646) ([Azat Khuzhin](https://github.com/azat)).
* Removed exception throwing at table initialization if there was no connection (it will be reconnecting in the background). [#17709](https://github.com/ClickHouse/ClickHouse/pull/17709) ([Kseniia Sumarokova](https://github.com/kssenii)).
* system.query_log now has extensive information to achieve better query analysis. [#17726](https://github.com/ClickHouse/ClickHouse/pull/17726) ([Amos Bird](https://github.com/amosbird)).
* Check system log tables' engine definition grammatically to prevent some configuration errors. Notes that this grammar check is not semantical, that means such mistakes as non-existent columns / expression functions would be not found out util the table is created. [#17739](https://github.com/ClickHouse/ClickHouse/pull/17739) ([Du Chuan](https://github.com/spongedu)).
* Improves the path concatenation of zookeeper paths inside DDLWorker. [#17767](https://github.com/ClickHouse/ClickHouse/pull/17767) ([Bharat Nallan](https://github.com/bharatnc)).
* Improvement of Web UI: do not add empty query to browser history. [#17770](https://github.com/ClickHouse/ClickHouse/pull/17770) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* - Let the possibility to override timeout value for running script using the ClickHouse docker image. [#17818](https://github.com/ClickHouse/ClickHouse/pull/17818) ([Guillaume Tassery](https://github.com/YiuRULE)).
* Add metrics(Parts, PartsActive, PartsInactive) for part number in MergeTree in clickhouse. [#17838](https://github.com/ClickHouse/ClickHouse/pull/17838) ([徐炘](https://github.com/weeds085490)).
* Add diagnostic information when two merge tables try to read each other's data. [#17854](https://github.com/ClickHouse/ClickHouse/pull/17854) ([徐炘](https://github.com/weeds085490)).
* Hints for column names. [#17112](https://github.com/ClickHouse/ClickHouse/issues/17112). [#17857](https://github.com/ClickHouse/ClickHouse/pull/17857) ([fastio](https://github.com/fastio)).
* Support for async tasks in `PipelineExecutor`. Initial support of async sockets for remote queries. [#17868](https://github.com/ClickHouse/ClickHouse/pull/17868) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* `allow_introspection_functions=0` prohibits usage of introspection functions but doesn't prohibit giving grants for them anymore (the grantee will need to set `allow_introspection_functions=1` for himself to be able to use that grant). Similarly `allow_ddl=0` prohibits usage of DDL commands but doesn't prohibit giving grants for them anymore. [#17908](https://github.com/ClickHouse/ClickHouse/pull/17908) ([Vitaly Baranov](https://github.com/vitlibar)).
* Ability to set custom metadata when putting S3 object. [#17909](https://github.com/ClickHouse/ClickHouse/pull/17909) ([Pavel Kovalenko](https://github.com/Jokser)).
* Adaptive choose of single/multi part upload in WriteBufferFromS3. Single part upload is controlled by a new setting 'max_single_part_upload_size'. [#17934](https://github.com/ClickHouse/ClickHouse/pull/17934) ([Pavel Kovalenko](https://github.com/Jokser)).
* Forcibly removing empty or bad metadata files from filesystem for DiskS3. S3 is an experimental feature. [#17935](https://github.com/ClickHouse/ClickHouse/pull/17935) ([Pavel Kovalenko](https://github.com/Jokser)).
* Now the table function `merge()` requires the current user to have the `SELECT` privilege on each table it receives data from. This PR fixes [#16964](https://github.com/ClickHouse/ClickHouse/issues/16964). [#17983](https://github.com/ClickHouse/ClickHouse/pull/17983) ([Vitaly Baranov](https://github.com/vitlibar)).
* Decrease log verbosity of the events when the client drops the connection from WARNING to INFORMATION. [#18005](https://github.com/ClickHouse/ClickHouse/pull/18005) ([filimonov](https://github.com/filimonov)).
* Fix clickhouse-client rendering issue when the size of terminal window changes. [#18009](https://github.com/ClickHouse/ClickHouse/pull/18009) ([Amos Bird](https://github.com/amosbird)).
* Temporary tables are visible in the system tables `system.tables` and `system.columns` now only in those session where they have been created. The internal database `_temporary_and_external_tables` is now hidden in those system tables; temporary tables are shown as tables with empty database with the `is_temporary` flag set instead. [#18014](https://github.com/ClickHouse/ClickHouse/pull/18014) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix dead list watches removal for TestKeeperStorage. [#18065](https://github.com/ClickHouse/ClickHouse/pull/18065) ([alesapin](https://github.com/alesapin)).
* Support `SHOW CREATE VIEW name` syntax like [MySQL](https://dev.mysql.com/doc/refman/5.7/en/show-create-view.html). [#18095](https://github.com/ClickHouse/ClickHouse/pull/18095) ([Du Chuan](https://github.com/spongedu)).
* Now the table function `merge()` requires the current user to have the `SELECT` privilege on each table it receives data from. This PR fixes [#16964](https://github.com/ClickHouse/ClickHouse/issues/16964). [#18104](https://github.com/ClickHouse/ClickHouse/pull/18104) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add `disk` to Set and Join storage settings. [#18112](https://github.com/ClickHouse/ClickHouse/pull/18112) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* `EXPLAIN AST` now support queries other then `SELECT`. [#18136](https://github.com/ClickHouse/ClickHouse/pull/18136) ([李扬](https://github.com/taiyang-li)).
* All queries of type `Decimal * Float` or vice versa are allowed, including aggregate ones (e.g. `SELECT sum(decimal_field * 1.1)` or `SELECT dec_col * float_col`), the result type is Float32 or Float64. [#18145](https://github.com/ClickHouse/ClickHouse/pull/18145) ([Mike Kot](https://github.com/myrrc)).
* Array aggregation `arrayMin`, `arrayMax`, `arraySum`, `arrayAvg` support for `Int128`, `Int256`, `UInt256`. [#18147](https://github.com/ClickHouse/ClickHouse/pull/18147) ([Maksim Kita](https://github.com/kitaisreal)).
* Better hints for `SHOW ...` query syntax. [#18183](https://github.com/ClickHouse/ClickHouse/pull/18183) ([Du Chuan](https://github.com/spongedu)).
* Now clickhouse-install could work on Mac. The problem was that there is no procfs on this platform. [#18201](https://github.com/ClickHouse/ClickHouse/pull/18201) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Make better adaptive granularity calculation for merge tree wide parts. [#18223](https://github.com/ClickHouse/ClickHouse/pull/18223) ([alesapin](https://github.com/alesapin)).
* Allow to parse Array fields from CSV if it is represented as a string containing array that was serialized as nested CSV. Example: `"[""Hello"", ""world"", ""42"""" TV""]"` will parse as `['Hello', 'world', '42" TV']`. Allow to parse array in CSV in a string without enclosing braces. Example: `"'Hello', 'world', '42"" TV'"` will parse as `['Hello', 'world', '42" TV']`. [#18271](https://github.com/ClickHouse/ClickHouse/pull/18271) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* In case of unexpected exceptions automatically restart background thread which is responsible for execution of distributed DDL queries. Fixes [#17991](https://github.com/ClickHouse/ClickHouse/issues/17991). [#18285](https://github.com/ClickHouse/ClickHouse/pull/18285) ([徐炘](https://github.com/weeds085490)).
* Add a new setting `insert_distributed_one_random_shard = 1` to allow insertion into multi-sharded distributed table without any distributed key. [#18294](https://github.com/ClickHouse/ClickHouse/pull/18294) ([Amos Bird](https://github.com/amosbird)).
* related to [#18133](https://github.com/ClickHouse/ClickHouse/issues/18133). [#18309](https://github.com/ClickHouse/ClickHouse/pull/18309) ([hexiaoting](https://github.com/hexiaoting)).
* Fix potential server crash during Buffer rollback (that is impossible in current ClickHouse version). [#18329](https://github.com/ClickHouse/ClickHouse/pull/18329) ([Azat Khuzhin](https://github.com/azat)).
* Support builtin function `isIPv4String` && `isIPv6String` like [MySQL](https://github.com/ClickHouse/ClickHouse/compare/master...spongedu:support_is_ipv4?expand=1). [#18349](https://github.com/ClickHouse/ClickHouse/pull/18349) ([Du Chuan](https://github.com/spongedu)).
* Add ability to modify primary and partition key column type from `LowCardinality(Type)` to `Type` and vice versa. Also add an ability to modify primary key column type from `EnumX ` to `IntX` type. Fixes [#5604](https://github.com/ClickHouse/ClickHouse/issues/5604). [#18362](https://github.com/ClickHouse/ClickHouse/pull/18362) ([alesapin](https://github.com/alesapin)).
* Fix bug: no newline after exception message in some tools. [#18444](https://github.com/ClickHouse/ClickHouse/pull/18444) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* support syntax `EXISTS DATABASE name`. [#18458](https://github.com/ClickHouse/ClickHouse/pull/18458) ([Du Chuan](https://github.com/spongedu)).
* Fixed assertion error inside allocator in case when last argument of function bar is NaN. Now simple ClickHouse's exception is being thrown. This fixes [#17876](https://github.com/ClickHouse/ClickHouse/issues/17876). [#18520](https://github.com/ClickHouse/ClickHouse/pull/18520) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* PODArray: Avoid call to memcpy with (nullptr, 0) arguments (Fix UBSan report). This fixes [#18525](https://github.com/ClickHouse/ClickHouse/issues/18525). [#18526](https://github.com/ClickHouse/ClickHouse/pull/18526) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix SimpleAggregateFunction in SummingMergeTree. Now it works like AggregateFunction. In previous versions values were summed together regardless to the aggregate function. This fixes [#18564](https://github.com/ClickHouse/ClickHouse/issues/18564) . [#8052](https://github.com/ClickHouse/ClickHouse/issues/8052). [#18637](https://github.com/ClickHouse/ClickHouse/pull/18637) ([Amos Bird](https://github.com/amosbird)).
* Another fix of using SimpleAggregateFunction in SummingMergeTree. This fixes [#18676](https://github.com/ClickHouse/ClickHouse/issues/18676) . [#18677](https://github.com/ClickHouse/ClickHouse/pull/18677) ([Amos Bird](https://github.com/amosbird)).
* Allow column transformer `EXCEPT` to accept a string as regular expression matcher. This resolves [#18685](https://github.com/ClickHouse/ClickHouse/issues/18685) . [#18699](https://github.com/ClickHouse/ClickHouse/pull/18699) ([Amos Bird](https://github.com/amosbird)).
* Apply `ALTER TABLE <replicated_table> ON CLUSTER MODIFY SETTING ...` to all replicas. Because we don't replicate such alter commands. [#18789](https://github.com/ClickHouse/ClickHouse/pull/18789) ([Amos Bird](https://github.com/amosbird)).
* Expand macros in the zk path when executing fetchPartition. [#18839](https://github.com/ClickHouse/ClickHouse/pull/18839) ([fastio](https://github.com/fastio)).
* `SYSTEM KILL` command started to work in Docker. This closes [#18847](https://github.com/ClickHouse/ClickHouse/issues/18847). [#18848](https://github.com/ClickHouse/ClickHouse/pull/18848) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Two new settings (by analogy with MergeTree family) has been added: - `fsync_after_insert` - Do fsync for every inserted. Will decreases performance of inserts. - `fsync_directories` - Do fsync for temporary directory (that is used for async INSERT only) after all operations (writes, renames, etc.). [#18864](https://github.com/ClickHouse/ClickHouse/pull/18864) ([Azat Khuzhin](https://github.com/azat)).
* change the sorting key of events_list from timestamp to (timestamp, event_index). [#18884](https://github.com/ClickHouse/ClickHouse/pull/18884) ([Fuwang Hu](https://github.com/fuwhu)).
* Aliases declared in `WITH` statement are properly used in index analysis. Queries like `WITH column AS alias SELECT ... WHERE alias = ...` may use index now. [#18896](https://github.com/ClickHouse/ClickHouse/pull/18896) ([Amos Bird](https://github.com/amosbird)).

#### Bug Fix
* Fix bug when clickhouse-server doesn't send `close` request to ZooKeeper server. [#16837](https://github.com/ClickHouse/ClickHouse/pull/16837) ([alesapin](https://github.com/alesapin)).
* TODO. [#16866](https://github.com/ClickHouse/ClickHouse/pull/16866) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix optimization of group by with enabled setting `optimize_aggregators_of_group_by_keys` and joins. Fixes [#12604](https://github.com/ClickHouse/ClickHouse/issues/12604). [#16951](https://github.com/ClickHouse/ClickHouse/pull/16951) ([Anton Popov](https://github.com/CurtizJ)).
* Fix incorrect comparison of types `DateTime64` with different scales. Fixes [#16655](https://github.com/ClickHouse/ClickHouse/issues/16655) ... [#16952](https://github.com/ClickHouse/ClickHouse/pull/16952) ([Vasily Nemkov](https://github.com/Enmk)).
* Fix order by optimization with monotonous functions. Fixes [#16107](https://github.com/ClickHouse/ClickHouse/issues/16107). [#16956](https://github.com/ClickHouse/ClickHouse/pull/16956) ([Anton Popov](https://github.com/CurtizJ)).
* Fix Merge(Distributed()) with JOIN. [#16993](https://github.com/ClickHouse/ClickHouse/pull/16993) ([Azat Khuzhin](https://github.com/azat)).
* - Fix optimize_distributed_group_by_sharding_key for query with OFFSET only. [#16996](https://github.com/ClickHouse/ClickHouse/pull/16996) ([Azat Khuzhin](https://github.com/azat)).
* Bug fix for funciton fuzzBits, related issue: [#16980](https://github.com/ClickHouse/ClickHouse/issues/16980). [#17051](https://github.com/ClickHouse/ClickHouse/pull/17051) ([hexiaoting](https://github.com/hexiaoting)).
* Fix possible wrong index analysis when the types of the index comparison are different. This fixes [#17122](https://github.com/ClickHouse/ClickHouse/issues/17122). [#17145](https://github.com/ClickHouse/ClickHouse/pull/17145) ([Amos Bird](https://github.com/amosbird)).
* Fixed possible not-working mutations for parts stored on S3 disk. [#17227](https://github.com/ClickHouse/ClickHouse/pull/17227) ([Pavel Kovalenko](https://github.com/Jokser)).
* Fix [#15235](https://github.com/ClickHouse/ClickHouse/issues/15235). When clickhouse-copier handle non-partitioned table, throws segfault error. [#17248](https://github.com/ClickHouse/ClickHouse/pull/17248) ([Qi Chen](https://github.com/kaka11chen)).
* Fix set index invalidation when there are const columns in the subquery. This fixes [#17246](https://github.com/ClickHouse/ClickHouse/issues/17246) . [#17249](https://github.com/ClickHouse/ClickHouse/pull/17249) ([Amos Bird](https://github.com/amosbird)).
* Fix possible `Unexpected packet Data received from client` error for Distributed queries with `LIMIT`. [#17254](https://github.com/ClickHouse/ClickHouse/pull/17254) ([Azat Khuzhin](https://github.com/azat)).
* Fix indeterministic functions with predicate optimizer. This fixes [#17244](https://github.com/ClickHouse/ClickHouse/issues/17244). [#17273](https://github.com/ClickHouse/ClickHouse/pull/17273) ([Winter Zhang](https://github.com/zhang2014)).
* fixes [#16835](https://github.com/ClickHouse/ClickHouse/issues/16835) try fix miss match header with MySQL SHOW statement. [#17366](https://github.com/ClickHouse/ClickHouse/pull/17366) ([Winter Zhang](https://github.com/zhang2014)).
* Fix crash while reading from `JOIN` table with `LowCardinality` types. Fixes [#17228](https://github.com/ClickHouse/ClickHouse/issues/17228). [#17397](https://github.com/ClickHouse/ClickHouse/pull/17397) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed high CPU usage in background tasks of *MergeTree tables. [#17416](https://github.com/ClickHouse/ClickHouse/pull/17416) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix duplicates after `DISTINCT` which were possible because of incorrect optimization. Fixes [#17294](https://github.com/ClickHouse/ClickHouse/issues/17294). [#17296](https://github.com/ClickHouse/ClickHouse/pull/17296) ([li chengxiang](https://github.com/chengxianglibra)). [#17439](https://github.com/ClickHouse/ClickHouse/pull/17439) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Avoid server abnormal termination in case of too low memory limits (`max_memory_usage=1`/`max_untracked_memory=1`). [#17453](https://github.com/ClickHouse/ClickHouse/pull/17453) ([Azat Khuzhin](https://github.com/azat)).
* Fix `ORDER BY` with enabled setting `optimize_redundant_functions_in_order_by`. [#17471](https://github.com/ClickHouse/ClickHouse/pull/17471) ([Anton Popov](https://github.com/CurtizJ)).
* Fix bug when mark cache size was underestimated by clickhouse. It may happen when there are a lot of tiny files with marks. [#17496](https://github.com/ClickHouse/ClickHouse/pull/17496) ([alesapin](https://github.com/alesapin)).
* Fix alter query hang when the corresponding mutation was killed on the different replica. Fixes [#16953](https://github.com/ClickHouse/ClickHouse/issues/16953). [#17499](https://github.com/ClickHouse/ClickHouse/pull/17499) ([alesapin](https://github.com/alesapin)).
* Fix the issue when server can stop accepting connections in very rare cases. [#17542](https://github.com/ClickHouse/ClickHouse/pull/17542) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* When clickhouse-client is used in interactive mode with multiline queries, single line comment was erronously extended till the end of query. This fixes [#13654](https://github.com/ClickHouse/ClickHouse/issues/13654). [#17565](https://github.com/ClickHouse/ClickHouse/pull/17565) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Exception `fmt::v7::format_error` can be logged in background for MergeTree tables. This fixes [#17613](https://github.com/ClickHouse/ClickHouse/issues/17613). [#17615](https://github.com/ClickHouse/ClickHouse/pull/17615) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix empty `system.stack_trace` table when server is running in daemon mode. [#17630](https://github.com/ClickHouse/ClickHouse/pull/17630) ([Amos Bird](https://github.com/amosbird)).
* In might be determined incorrectly if cluster is circular- (cross-) replicated or not when executing `ON CLUSTER` query due to race condition when `pool_size` > 1. It's fixed. [#17640](https://github.com/ClickHouse/ClickHouse/pull/17640) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed `Function not implemented` error when executing `RENAME` query in `Atomic` database with ClickHouse running on Windows Subsystem for Linux. Fixes [#17661](https://github.com/ClickHouse/ClickHouse/issues/17661). [#17664](https://github.com/ClickHouse/ClickHouse/pull/17664) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed problem when ClickHouse fails to resume connection to MySQL servers. [#17681](https://github.com/ClickHouse/ClickHouse/pull/17681) ([Alexander Kazakov](https://github.com/Akazz)).
* Fixed segfault when there is not enough space when inserting into `Distributed` table. [#17737](https://github.com/ClickHouse/ClickHouse/pull/17737) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Exception message about max table size to drop was displayed incorrectly. [#17764](https://github.com/ClickHouse/ClickHouse/pull/17764) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Do not restore parts from WAL if `in_memory_parts_enable_wal` is disabled. [#17802](https://github.com/ClickHouse/ClickHouse/pull/17802) ([detailyang](https://github.com/detailyang)).
* fix incorrect initialize `max_compress_block_size` of MergeTreeWriterSettings with `min_compress_block_size`. [#17833](https://github.com/ClickHouse/ClickHouse/pull/17833) ([flynn](https://github.com/ucasfl)).
* Fix possible segfault in `topK` aggregate function. This closes [#17404](https://github.com/ClickHouse/ClickHouse/issues/17404). [#17845](https://github.com/ClickHouse/ClickHouse/pull/17845) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix max_distributed_connections (affects `prefer_localhost_replica=1` and `max_threads!=max_distributed_connections`). [#17848](https://github.com/ClickHouse/ClickHouse/pull/17848) ([Azat Khuzhin](https://github.com/azat)).
* Trivial query optimization was producing wrong result if query contains ARRAY JOIN (so query is actually non trivial). [#17887](https://github.com/ClickHouse/ClickHouse/pull/17887) ([sundyli](https://github.com/sundy-li)).
* Fix comparison of `DateTime64` and `Date`. Fixes [#13804](https://github.com/ClickHouse/ClickHouse/issues/13804) and [#11222](https://github.com/ClickHouse/ClickHouse/issues/11222). ... [#17895](https://github.com/ClickHouse/ClickHouse/pull/17895) ([Vasily Nemkov](https://github.com/Enmk)).
* When server log rotation was configured using `logger.size` parameter with numeric value larger than 2^32, the logs were not rotated properly. This is fixed. [#17905](https://github.com/ClickHouse/ClickHouse/pull/17905) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* fixes [#15187](https://github.com/ClickHouse/ClickHouse/issues/15187) fixes [#17912](https://github.com/ClickHouse/ClickHouse/issues/17912) support convert MySQL prefix index for MaterializeMySQL CC: @tavplubix. [#17944](https://github.com/ClickHouse/ClickHouse/pull/17944) ([Winter Zhang](https://github.com/zhang2014)).
* Fix comparison of `DateTime64` and `Date`. Fixes [#13804](https://github.com/ClickHouse/ClickHouse/issues/13804) and [#11222](https://github.com/ClickHouse/ClickHouse/issues/11222). ... [#18050](https://github.com/ClickHouse/ClickHouse/pull/18050) ([Vasily Nemkov](https://github.com/Enmk)).
* Fix corruption in librdkafka snappy decompression (was a problem only for gcc10 builds, but official builds uses clang already, so at least recent official releases are not affected). [#18053](https://github.com/ClickHouse/ClickHouse/pull/18053) ([Azat Khuzhin](https://github.com/azat)).
* Fixed `std::out_of_range: basic_string` in S3 URL parsing. [#18059](https://github.com/ClickHouse/ClickHouse/pull/18059) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix error when query `MODIFY COLUMN ... REMOVE TTL` doesn't actually remove column TTL. [#18130](https://github.com/ClickHouse/ClickHouse/pull/18130) ([alesapin](https://github.com/alesapin)).
* Fix `Unknown setting profile` error on attempt to set settings profile. [#18167](https://github.com/ClickHouse/ClickHouse/pull/18167) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix inserting a row with default value in case of parsing error in the last column. Fixes [#17712](https://github.com/ClickHouse/ClickHouse/issues/17712). [#18182](https://github.com/ClickHouse/ClickHouse/pull/18182) ([Jianmei Zhang](https://github.com/zhangjmruc)).
* fixes [#18186](https://github.com/ClickHouse/ClickHouse/issues/18186) fixes [#16372](https://github.com/ClickHouse/ClickHouse/issues/16372) fix unique key convert crash in MaterializeMySQL database engine. [#18211](https://github.com/ClickHouse/ClickHouse/pull/18211) ([Winter Zhang](https://github.com/zhang2014)).
* Fix key comparison between Enum and Int types. This fixes [#17989](https://github.com/ClickHouse/ClickHouse/issues/17989). [#18214](https://github.com/ClickHouse/ClickHouse/pull/18214) ([Amos Bird](https://github.com/amosbird)).
* Fix possible incomplete query result while reading from `MergeTree*` in case of read backoff (message `<Debug> MergeTreeReadPool: Will lower number of threads` in logs). Was introduced in [#16423](https://github.com/ClickHouse/ClickHouse/issues/16423). Fixes [#18137](https://github.com/ClickHouse/ClickHouse/issues/18137). [#18216](https://github.com/ClickHouse/ClickHouse/pull/18216) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* `SELECT JOIN` now requires the `SELECT` privilege on each of the joined tables. This PR fixes [#17654](https://github.com/ClickHouse/ClickHouse/issues/17654). [#18232](https://github.com/ClickHouse/ClickHouse/pull/18232) ([Vitaly Baranov](https://github.com/vitlibar)).
* - Fixed issue when `clickhouse-odbc-bridge` process is unreachable by server on machines with dual IPv4/IPv6 stack; - Fixed issue when ODBC dictionary updates are performed using malformed queries and/or cause crashes; Possibly closes [#14489](https://github.com/ClickHouse/ClickHouse/issues/14489). [#18278](https://github.com/ClickHouse/ClickHouse/pull/18278) ([Denis Glazachev](https://github.com/traceon)).
* Fix possible crashes in aggregate functions with combinator `Distinct`, while using two-level aggregation. Fixes [#17682](https://github.com/ClickHouse/ClickHouse/issues/17682). [#18365](https://github.com/ClickHouse/ClickHouse/pull/18365) ([Anton Popov](https://github.com/CurtizJ)).
* Fix filling table `system.settings_profile_elements`. This PR fixes [#18231](https://github.com/ClickHouse/ClickHouse/issues/18231). [#18379](https://github.com/ClickHouse/ClickHouse/pull/18379) ([Vitaly Baranov](https://github.com/vitlibar)).
* Restrict merges from wide to compact parts. In case of vertical merge it led to broken result part. [#18381](https://github.com/ClickHouse/ClickHouse/pull/18381) ([Anton Popov](https://github.com/CurtizJ)).
* Fix possible race condition in concurrent usage of `Set` or `Join` tables and selects from `system.tables`. [#18385](https://github.com/ClickHouse/ClickHouse/pull/18385) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix -SimpleState combinator generates incompatible arugment type and return type. [#18404](https://github.com/ClickHouse/ClickHouse/pull/18404) ([Amos Bird](https://github.com/amosbird)).
* Fix the unexpected behaviour of `SHOW TABLES`. [#18431](https://github.com/ClickHouse/ClickHouse/pull/18431) ([fastio](https://github.com/fastio)).
* Fixed `value is too short` error when executing `toType(...)` functions (`toDate`, `toUInt32`, etc) with argument of type `Nullable(String)`. Now such functions return `NULL` on parsing errors instead of throwing exception. Fixes [#7673](https://github.com/ClickHouse/ClickHouse/issues/7673). [#18445](https://github.com/ClickHouse/ClickHouse/pull/18445) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Proper support for 12AM in `parseDateTimeBestEffort` function. This fixes [#18402](https://github.com/ClickHouse/ClickHouse/issues/18402). [#18449](https://github.com/ClickHouse/ClickHouse/pull/18449) ([vladimir-golovchenko](https://github.com/vladimir-golovchenko)).
* Disable write with AIO during merges because it can lead to extremely rare data corruption of primary key columns during merge. [#18481](https://github.com/ClickHouse/ClickHouse/pull/18481) ([alesapin](https://github.com/alesapin)).
* Fix bug which may lead to `ALTER` queries hung after corresponding mutation kill. Found by thread fuzzer. [#18518](https://github.com/ClickHouse/ClickHouse/pull/18518) ([alesapin](https://github.com/alesapin)).
* Fix possible `Pipeline stuck` error while using `ORDER BY` after subquery with `RIGHT` or `FULL` join. [#18550](https://github.com/ClickHouse/ClickHouse/pull/18550) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add FixedString Data type support. I'll get this exception "Code: 50, e.displayText() = DB::Exception: Unsupported type FixedString(1)" when replicating data from MySQL to ClickHouse. This patch fixes bug [#18450](https://github.com/ClickHouse/ClickHouse/issues/18450) Also fixes [#6556](https://github.com/ClickHouse/ClickHouse/issues/6556). [#18553](https://github.com/ClickHouse/ClickHouse/pull/18553) ([awesomeleo](https://github.com/awesomeleo)).
* Fix previous bug when date overflow with different values. Strict Date value limit to "2106-02-07", cast date > "2106-02-07" to value 0. [#18565](https://github.com/ClickHouse/ClickHouse/pull/18565) ([hexiaoting](https://github.com/hexiaoting)).
* Fix removing of empty parts in `ReplicatedMergeTree` tables, created with old syntax. Fixes [#18582](https://github.com/ClickHouse/ClickHouse/issues/18582). [#18614](https://github.com/ClickHouse/ClickHouse/pull/18614) ([Anton Popov](https://github.com/CurtizJ)).
* Fix Logger with unmatched arg size. [#18717](https://github.com/ClickHouse/ClickHouse/pull/18717) ([sundyli](https://github.com/sundy-li)).
* Fixed `Attempt to read after eof` error when trying to `CAST` `NULL` from `Nullable(String)` to `Nullable(Decimal(P, S))`. Now function `CAST` returns `NULL` when it cannot parse decimal from nullable string. Fixes [#7690](https://github.com/ClickHouse/ClickHouse/issues/7690). [#18718](https://github.com/ClickHouse/ClickHouse/pull/18718) ([Winter Zhang](https://github.com/zhang2014)).
* Asynchronous distributed INSERTs can be rejected by the server if the setting `network_compression_method` is globally set to non-default value. This fixes [#18741](https://github.com/ClickHouse/ClickHouse/issues/18741). [#18776](https://github.com/ClickHouse/ClickHouse/pull/18776) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix *If combinator with unary function and Nullable types. [#18806](https://github.com/ClickHouse/ClickHouse/pull/18806) ([Azat Khuzhin](https://github.com/azat)).
* - Fix never worked `fsync_part_directory`/`fsync_after_insert`/`in_memory_parts_insert_sync`. [#18845](https://github.com/ClickHouse/ClickHouse/pull/18845) ([Azat Khuzhin](https://github.com/azat)).
* Fix use after free bug in rocksdb. [#18862](https://github.com/ClickHouse/ClickHouse/pull/18862) ([sundyli](https://github.com/sundy-li)).
* Queries for external databases (MySQL, ODBC, JDBC) were incorrectly rewritten if there was an expression in form of `x IN table`. This fixes [#9756](https://github.com/ClickHouse/ClickHouse/issues/9756). [#18876](https://github.com/ClickHouse/ClickHouse/pull/18876) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix possible hang at shutdown in clickhouse-local. This fixes [#18891](https://github.com/ClickHouse/ClickHouse/issues/18891). [#18893](https://github.com/ClickHouse/ClickHouse/pull/18893) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix issue with `bitmapOrCardinality` that may lead to nullptr dereference. This closes [#18911](https://github.com/ClickHouse/ClickHouse/issues/18911). [#18912](https://github.com/ClickHouse/ClickHouse/pull/18912) ([sundyli](https://github.com/sundy-li)).

#### Build/Testing/Packaging Improvement
* Add some test for MaterializeMySQL. e.g. network partition, MySQL kill sync thread... [#16806](https://github.com/ClickHouse/ClickHouse/pull/16806) ([TCeason](https://github.com/TCeason)).
* Now ClickHouse can pretend to be a fake ZooKeeper. Currently, storage implementation is just stored in-memory hash-table, and server partially support ZooKeeper protocol. [#16877](https://github.com/ClickHouse/ClickHouse/pull/16877) ([alesapin](https://github.com/alesapin)).
* * Added RBAC tests for `ATTACH`, `CREATE`, `DROP`, and `DETACH`. [#16977](https://github.com/ClickHouse/ClickHouse/pull/16977) ([MyroTk](https://github.com/MyroTk)).
* `PODArray` does not initialize "new" elements when resizing, unlike `std::vector`. This probably fixes [this failure](https://clickhouse-test-reports.s3.yandex.net/17309/065cd002578f2e8228f12a2744bd40c970065e0c/stress_test_(memory)/stderr.log) from [#17309](https://github.com/ClickHouse/ClickHouse/issues/17309). [#17344](https://github.com/ClickHouse/ClickHouse/pull/17344) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* There was an uninitialized variable in the code of Copier. [#17363](https://github.com/ClickHouse/ClickHouse/pull/17363) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Send info about official build, memory, cpu and free disk space to Sentry if it is enabled. Sentry is opt-in feature to help ClickHouse developers. This closes [#17279](https://github.com/ClickHouse/ClickHouse/issues/17279). [#17543](https://github.com/ClickHouse/ClickHouse/pull/17543) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add an integration test: MySQL server killed while insert for MaterializeMySQL Engine. [#17614](https://github.com/ClickHouse/ClickHouse/pull/17614) ([TCeason](https://github.com/TCeason)).
* Add an integration test: ClickHouse killed while insert for MaterializeMySQL ENGINE. [#17622](https://github.com/ClickHouse/ClickHouse/pull/17622) ([TCeason](https://github.com/TCeason)).
* - RBAC testflows tests for SHOW, TRUNCATE, KILL, and OPTIMIZE. - Updates to old tests. - Resolved comments from #https://github.com/ClickHouse/ClickHouse/pull/16977. [#17657](https://github.com/ClickHouse/ClickHouse/pull/17657) ([MyroTk](https://github.com/MyroTk)).
* Now we use the fresh docker daemon version in integration tests. [#17671](https://github.com/ClickHouse/ClickHouse/pull/17671) ([alesapin](https://github.com/alesapin)).
* - Testflows tests for RBAC [ACCESS MANAGEMENT](https://clickhouse.tech/docs/en/sql-reference/statements/grant/#grant-access-management) privileges. [#17804](https://github.com/ClickHouse/ClickHouse/pull/17804) ([MyroTk](https://github.com/MyroTk)).
* Updating TestFlows README.md to include "How To Debug Why Test Failed" section. [#17808](https://github.com/ClickHouse/ClickHouse/pull/17808) ([vzakaznikov](https://github.com/vzakaznikov)).
* Add our own CMakeList for dragonbox which was added in [#17831](https://github.com/ClickHouse/ClickHouse/issues/17831). [#17869](https://github.com/ClickHouse/ClickHouse/pull/17869) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Enable Pytest framework for stateless tests. [#17902](https://github.com/ClickHouse/ClickHouse/pull/17902) ([Ivan](https://github.com/abyss7)).
* Adjusting timeouts a bit, in the good hope that it will prevent flakiness of the test. [#18000](https://github.com/ClickHouse/ClickHouse/pull/18000) ([filimonov](https://github.com/filimonov)).
* Now, `clickhouse-test` DROP/CREATE databases with a timeout. [#18098](https://github.com/ClickHouse/ClickHouse/pull/18098) ([alesapin](https://github.com/alesapin)).
* Change OpenSSL to BoringSSL. It allows to avoid issues with sanitizers. This fixes [#12490](https://github.com/ClickHouse/ClickHouse/issues/12490). This fixes [#17502](https://github.com/ClickHouse/ClickHouse/issues/17502). This fixes [#12952](https://github.com/ClickHouse/ClickHouse/issues/12952). [#18129](https://github.com/ClickHouse/ClickHouse/pull/18129) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix usage of uninitialized value in function toModifiedJulianDayOrNull, reported by MSan. Was discovered [here](https://github.com/ClickHouse/ClickHouse/pull/17726#issuecomment-744050500). [#18172](https://github.com/ClickHouse/ClickHouse/pull/18172) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Update `anchore/scan-action@main` workflow action (was moved from master). [#18192](https://github.com/ClickHouse/ClickHouse/pull/18192) ([Stig Bakken](https://github.com/stigsb)).
* Do not use non thread-safe function `strerror`. [#18204](https://github.com/ClickHouse/ClickHouse/pull/18204) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* - Updating TestFlows version to the latest 1.6.72 - Re-generating requirements.py. [#18208](https://github.com/ClickHouse/ClickHouse/pull/18208) ([vzakaznikov](https://github.com/vzakaznikov)).
* Merging requirements for AES encryption functions. Updating aes_encryption tests to use new requirements. Updating TestFlows version to 1.6.72. [#18221](https://github.com/ClickHouse/ClickHouse/pull/18221) ([vzakaznikov](https://github.com/vzakaznikov)).
* Enable Thread Fuzzer for stateless tests flaky check. [#18299](https://github.com/ClickHouse/ClickHouse/pull/18299) ([alesapin](https://github.com/alesapin)).
* Check for leftovers of conflict markers in docs. [#18332](https://github.com/ClickHouse/ClickHouse/pull/18332) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix codespell warnings. Split style checks into separate parts. Update style checks docker image. [#18463](https://github.com/ClickHouse/ClickHouse/pull/18463) ([Ilya Yatsishin](https://github.com/qoega)).
* Update timezones info to 2020e. [#18531](https://github.com/ClickHouse/ClickHouse/pull/18531) ([alesapin](https://github.com/alesapin)).
* Fix shellcheck errors in style check. [#18566](https://github.com/ClickHouse/ClickHouse/pull/18566) ([Ilya Yatsishin](https://github.com/qoega)).
* TestFlows: fixes to LDAP tests that fail due to slow test execution. [#18790](https://github.com/ClickHouse/ClickHouse/pull/18790) ([vzakaznikov](https://github.com/vzakaznikov)).
* Generate build id when ClickHouse is linked with `lld`. It's appeared that `lld` does not generate it by default on my machine. Build id is used for crash reports and introspection. [#18808](https://github.com/ClickHouse/ClickHouse/pull/18808) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add simple integrity check for ClickHouse binary. It allows to detect corruption due to faulty hardware (bit rot on storage media or bit flips in RAM). [#18811](https://github.com/ClickHouse/ClickHouse/pull/18811) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Removed the -finline-hint-functions flag not present in GCC. [#18846](https://github.com/ClickHouse/ClickHouse/pull/18846) ([Mike Kot](https://github.com/myrrc)).
* Add `SYSTEM SUSPEND` command for fault injection. It can be used to faciliate failover tests. This closes [#15979](https://github.com/ClickHouse/ClickHouse/issues/15979). [#18850](https://github.com/ClickHouse/ClickHouse/pull/18850) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### NO CL ENTRY

* NO CL ENTRY:  'Bump mkdocs-macros-plugin from 0.4.20 to 0.5.0 in /docs/tools'. [#17351](https://github.com/ClickHouse/ClickHouse/pull/17351) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview)).
* NO CL ENTRY:  'Revert "Attempt to fix Stress test (MSan)"'. [#17372](https://github.com/ClickHouse/ClickHouse/pull/17372) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'Revert "Bump mkdocs-macros-plugin from 0.4.20 to 0.5.0 in /docs/tools"'. [#17405](https://github.com/ClickHouse/ClickHouse/pull/17405) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Update README.md'. [#17596](https://github.com/ClickHouse/ClickHouse/pull/17596) ([Robert Hodges](https://github.com/hodgesrm)).
* NO CL ENTRY:  'Revert "Fix index granularity calculation on block borders"'. [#17918](https://github.com/ClickHouse/ClickHouse/pull/17918) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Revert "Date vs DateTime64 comparison"'. [#17985](https://github.com/ClickHouse/ClickHouse/pull/17985) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Исправил опечатку в названии ОС RedHad->RedHat'. [#18028](https://github.com/ClickHouse/ClickHouse/pull/18028) ([Ed Rakhmankulov](https://github.com/Erixonich)).
* NO CL ENTRY:  'Revert "Fix access rights required for the merge() table function."'. [#18103](https://github.com/ClickHouse/ClickHouse/pull/18103) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Add some extra tests to copier"'. [#18636](https://github.com/ClickHouse/ClickHouse/pull/18636) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'Fix typo in array functions' documentation'. [#18792](https://github.com/ClickHouse/ClickHouse/pull/18792) ([Bertrand Junqua](https://github.com/Bertrand31)).
* NO CL ENTRY:  'Revert "Add metrics for part number in MergeTree in ClickHouse"'. [#18834](https://github.com/ClickHouse/ClickHouse/pull/18834) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Fixed typo in metrics.md'. [#18920](https://github.com/ClickHouse/ClickHouse/pull/18920) ([Mark Frost](https://github.com/frostmark)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Minor change in query profiler [#16899](https://github.com/ClickHouse/ClickHouse/pull/16899) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove escaping from toString(std::string) [#17206](https://github.com/ClickHouse/ClickHouse/pull/17206) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix libunwind build for cmake 3.19+ [#17271](https://github.com/ClickHouse/ClickHouse/pull/17271) ([Azat Khuzhin](https://github.com/azat)).
* Fix AST formatting in log messages [#17274](https://github.com/ClickHouse/ClickHouse/pull/17274) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Tiny cleanup [#17275](https://github.com/ClickHouse/ClickHouse/pull/17275) ([Azat Khuzhin](https://github.com/azat)).
* Add a test for [#13990](https://github.com/ClickHouse/ClickHouse/issues/13990) [#17298](https://github.com/ClickHouse/ClickHouse/pull/17298) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed flaky test_storage_s3::test_custom_auth_headers [#17299](https://github.com/ClickHouse/ClickHouse/pull/17299) ([Pavel Kovalenko](https://github.com/Jokser)).
* Minor changes for ODBC storage [#17301](https://github.com/ClickHouse/ClickHouse/pull/17301) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Merging [#16309](https://github.com/ClickHouse/ClickHouse/issues/16309) [#17309](https://github.com/ClickHouse/ClickHouse/pull/17309) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix some flaky tests [#17311](https://github.com/ClickHouse/ClickHouse/pull/17311) ([alesapin](https://github.com/alesapin)).
* Remove outdated test [#17361](https://github.com/ClickHouse/ClickHouse/pull/17361) ([Anton Popov](https://github.com/CurtizJ)).
* Added a test for what was always working [#17375](https://github.com/ClickHouse/ClickHouse/pull/17375) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for mutation with empty partition [#17410](https://github.com/ClickHouse/ClickHouse/pull/17410) ([alesapin](https://github.com/alesapin)).
* Implement GRPC protocol (corrections) [#17435](https://github.com/ClickHouse/ClickHouse/pull/17435) ([Vitaly Baranov](https://github.com/vitlibar)).
* Drop include of the removed libbtrie in cmake rules [#17454](https://github.com/ClickHouse/ClickHouse/pull/17454) ([Azat Khuzhin](https://github.com/azat)).
* Merge expressions [#17458](https://github.com/ClickHouse/ClickHouse/pull/17458) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fail queries on unknown settings in perf tests [#17460](https://github.com/ClickHouse/ClickHouse/pull/17460) ([Azat Khuzhin](https://github.com/azat)).
* Adjust perf test thresholds [#17485](https://github.com/ClickHouse/ClickHouse/pull/17485) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix more flaky integration tests [#17486](https://github.com/ClickHouse/ClickHouse/pull/17486) ([alesapin](https://github.com/alesapin)).
* Fix data race on global BlockStreamProfileInfo in PullingAsyncPipelineExecutor [#17498](https://github.com/ClickHouse/ClickHouse/pull/17498) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix CMake generation and build for native Xcode and AppleClang [#17501](https://github.com/ClickHouse/ClickHouse/pull/17501) ([Denis Glazachev](https://github.com/traceon)).
* Fix bad test 01317_no_password_in_command_line.sh [#17506](https://github.com/ClickHouse/ClickHouse/pull/17506) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* fix spelling errors [#17527](https://github.com/ClickHouse/ClickHouse/pull/17527) ([flynn](https://github.com/ucasfl)).
* Fix toUnixTimestamp(Date()) error (use type name not column type name) [#17536](https://github.com/ClickHouse/ClickHouse/pull/17536) ([Azat Khuzhin](https://github.com/azat)).
* Add a test for StorageJoin and UUID [#17541](https://github.com/ClickHouse/ClickHouse/pull/17541) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update Cassandra for BoringSSL [#17544](https://github.com/ClickHouse/ClickHouse/pull/17544) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update Kafka for BoringSSL [#17545](https://github.com/ClickHouse/ClickHouse/pull/17545) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update MariaDB for BoringSSL [#17546](https://github.com/ClickHouse/ClickHouse/pull/17546) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update OpenLDAP for BoringSSL [#17547](https://github.com/ClickHouse/ClickHouse/pull/17547) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update AMQP for BoringSSL [#17548](https://github.com/ClickHouse/ClickHouse/pull/17548) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* getMemoryAmount: make code worse [#17556](https://github.com/ClickHouse/ClickHouse/pull/17556) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#12297](https://github.com/ClickHouse/ClickHouse/issues/12297) [#17557](https://github.com/ClickHouse/ClickHouse/pull/17557) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#9490](https://github.com/ClickHouse/ClickHouse/issues/9490) [#17561](https://github.com/ClickHouse/ClickHouse/pull/17561) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#11803](https://github.com/ClickHouse/ClickHouse/issues/11803) [#17562](https://github.com/ClickHouse/ClickHouse/pull/17562) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix mixed statements in 01018_ip_dictionary.sql [#17570](https://github.com/ClickHouse/ClickHouse/pull/17570) ([Vladimir C](https://github.com/vdimir)).
* Fix GRPC tests [#17597](https://github.com/ClickHouse/ClickHouse/pull/17597) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Port ClickHouse code to BoringSSL [#17606](https://github.com/ClickHouse/ClickHouse/pull/17606) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix the OpenTelemetry test [#17621](https://github.com/ClickHouse/ClickHouse/pull/17621) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Try to fix Yandex Synchronization check [#17634](https://github.com/ClickHouse/ClickHouse/pull/17634) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Use feature testing macro to test if char8_t is supported [#17645](https://github.com/ClickHouse/ClickHouse/pull/17645) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Make LockExceptionInThread/BlockerInThread nested [#17658](https://github.com/ClickHouse/ClickHouse/pull/17658) ([Azat Khuzhin](https://github.com/azat)).
* Mark grpc protocol's tests as flaky. [#17662](https://github.com/ClickHouse/ClickHouse/pull/17662) ([Vitaly Baranov](https://github.com/vitlibar)).
* Use feature testing macro once more [#17685](https://github.com/ClickHouse/ClickHouse/pull/17685) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Fix sequential number in TestKeeper [#17700](https://github.com/ClickHouse/ClickHouse/pull/17700) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Try fix arcadia build [#17720](https://github.com/ClickHouse/ClickHouse/pull/17720) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix arcadian build [#17781](https://github.com/ClickHouse/ClickHouse/pull/17781) ([Ivan](https://github.com/abyss7)).
* Fix a typo [#17791](https://github.com/ClickHouse/ClickHouse/pull/17791) ([achimbab](https://github.com/achimbab)).
* Attempt to use IOStream in AWS SDK [#17794](https://github.com/ClickHouse/ClickHouse/pull/17794) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Update StorageReplicatedMergeTree::waitForAllReplicasToProcessLogEntry to support waiting on foreign shards / tables [#17800](https://github.com/ClickHouse/ClickHouse/pull/17800) ([nvartolomei](https://github.com/nvartolomei)).
* Fix flaky test_ttl_move [#17805](https://github.com/ClickHouse/ClickHouse/pull/17805) ([Azat Khuzhin](https://github.com/azat)).
* Merging data type Map [#15806](https://github.com/ClickHouse/ClickHouse/issues/15806) [#17829](https://github.com/ClickHouse/ClickHouse/pull/17829) ([Anton Popov](https://github.com/CurtizJ)).
* Kill network container with retries in integration tests [#17856](https://github.com/ClickHouse/ClickHouse/pull/17856) ([alesapin](https://github.com/alesapin)).
* Merging [#17750](https://github.com/ClickHouse/ClickHouse/issues/17750) [#17874](https://github.com/ClickHouse/ClickHouse/pull/17874) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix bad code [#17878](https://github.com/ClickHouse/ClickHouse/pull/17878) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Retrieve logs from grpc [#17888](https://github.com/ClickHouse/ClickHouse/pull/17888) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fixed typo in log message format [#17900](https://github.com/ClickHouse/ClickHouse/pull/17900) ([Alexander Kazakov](https://github.com/Akazz)).
* Perf tests fixes [#17907](https://github.com/ClickHouse/ClickHouse/pull/17907) ([Azat Khuzhin](https://github.com/azat)).
* Better exception message for MaterializeMySQL [#17915](https://github.com/ClickHouse/ClickHouse/pull/17915) ([Winter Zhang](https://github.com/zhang2014)).
* Add additional columns size check for MergeTree in debug mode [#17919](https://github.com/ClickHouse/ClickHouse/pull/17919) ([alesapin](https://github.com/alesapin)).
* Small simplification of MergeTreeDataWriter [#17943](https://github.com/ClickHouse/ClickHouse/pull/17943) ([alesapin](https://github.com/alesapin)).
* Use ryu instead of dragonbox in Arcadia [#17963](https://github.com/ClickHouse/ClickHouse/pull/17963) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Tiny build changes [#17982](https://github.com/ClickHouse/ClickHouse/pull/17982) ([Azat Khuzhin](https://github.com/azat)).
* Fix arcadia [#17984](https://github.com/ClickHouse/ClickHouse/pull/17984) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* More forward declaration for generic headers [#17986](https://github.com/ClickHouse/ClickHouse/pull/17986) ([Azat Khuzhin](https://github.com/azat)).
* Remove some redundant includes to speed up build [#17988](https://github.com/ClickHouse/ClickHouse/pull/17988) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix flappy test_log_family_s3 [#18027](https://github.com/ClickHouse/ClickHouse/pull/18027) ([Pavel Kovalenko](https://github.com/Jokser)).
* encodeXMLComponent: rename files after [#17659](https://github.com/ClickHouse/ClickHouse/issues/17659) [#18033](https://github.com/ClickHouse/ClickHouse/pull/18033) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* HashTable erase added tests [#18047](https://github.com/ClickHouse/ClickHouse/pull/18047) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove obsolete settings [#18054](https://github.com/ClickHouse/ClickHouse/pull/18054) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix 01600_remerge_sort_lowered_memory_bytes_ratio flap [#18057](https://github.com/ClickHouse/ClickHouse/pull/18057) ([Azat Khuzhin](https://github.com/azat)).
* Remove test_keeper_server in perf tests [#18058](https://github.com/ClickHouse/ClickHouse/pull/18058) ([Azat Khuzhin](https://github.com/azat)).
* Add changelog for 20.12 [#18062](https://github.com/ClickHouse/ClickHouse/pull/18062) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed unsafe ast rewrite in InterpreterSelectWithUnionQuery [#18064](https://github.com/ClickHouse/ClickHouse/pull/18064) ([Alexander Kazakov](https://github.com/Akazz)).
* Build utils in CI, at least in split build [#18066](https://github.com/ClickHouse/ClickHouse/pull/18066) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Do not pass -fsanitize-blacklist for gcc (it does not support it) for UBSAN [#18081](https://github.com/ClickHouse/ClickHouse/pull/18081) ([Azat Khuzhin](https://github.com/azat)).
* Try to fix Arcadia [#18084](https://github.com/ClickHouse/ClickHouse/pull/18084) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix dependencies for docker stateful_with_coverage [#18105](https://github.com/ClickHouse/ClickHouse/pull/18105) ([alesapin](https://github.com/alesapin)).
* Avoid using symlinks for top_level_domains [#18113](https://github.com/ClickHouse/ClickHouse/pull/18113) ([Azat Khuzhin](https://github.com/azat)).
* gcc10 sanitizers support [#18114](https://github.com/ClickHouse/ClickHouse/pull/18114) ([Azat Khuzhin](https://github.com/azat)).
* Port Kerberos to BoringSSL [#18128](https://github.com/ClickHouse/ClickHouse/pull/18128) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Try fix integration tests. [#18132](https://github.com/ClickHouse/ClickHouse/pull/18132) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Trying to fix 00620_optimize_on_nonleader_test [#18140](https://github.com/ClickHouse/ClickHouse/pull/18140) ([alesapin](https://github.com/alesapin)).
* Suppress error in 00993_system_parts_race_condition_drop_zookeeper [#18148](https://github.com/ClickHouse/ClickHouse/pull/18148) ([alesapin](https://github.com/alesapin)).
* Better exception message for unknown function [#18168](https://github.com/ClickHouse/ClickHouse/pull/18168) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Test watches for in-memory zookeeper [#18191](https://github.com/ClickHouse/ClickHouse/pull/18191) ([alesapin](https://github.com/alesapin)).
* Add support for LTS branches in backport automation [#18195](https://github.com/ClickHouse/ClickHouse/pull/18195) ([Ivan](https://github.com/abyss7)).
* Enable optimize_on_insert for MaterializeMySQL [#18198](https://github.com/ClickHouse/ClickHouse/pull/18198) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add one more case in zk test util [#18199](https://github.com/ClickHouse/ClickHouse/pull/18199) ([alesapin](https://github.com/alesapin)).
* More logs during quorum insert [#18200](https://github.com/ClickHouse/ClickHouse/pull/18200) ([alesapin](https://github.com/alesapin)).
* Update libc headers [#18202](https://github.com/ClickHouse/ClickHouse/pull/18202) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix watches processing in TestKeeper [#18217](https://github.com/ClickHouse/ClickHouse/pull/18217) ([alesapin](https://github.com/alesapin)).
* Add test for fixed bug with skip indices [#18219](https://github.com/ClickHouse/ClickHouse/pull/18219) ([Anton Popov](https://github.com/CurtizJ)).
* [wip] a prototype for window functions [#18222](https://github.com/ClickHouse/ClickHouse/pull/18222) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Return clickhouse-git-import [#18234](https://github.com/ClickHouse/ClickHouse/pull/18234) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* MADV_DONTNEED check in runtime for qemu (via patching jemalloc) [#18238](https://github.com/ClickHouse/ClickHouse/pull/18238) ([Azat Khuzhin](https://github.com/azat)).
* New Year preparations [#18274](https://github.com/ClickHouse/ClickHouse/pull/18274) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add powf and powl to glibc-compatibility [#18279](https://github.com/ClickHouse/ClickHouse/pull/18279) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless code [#18286](https://github.com/ClickHouse/ClickHouse/pull/18286) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky 01076_parallel_alter test [#18293](https://github.com/ClickHouse/ClickHouse/pull/18293) ([alesapin](https://github.com/alesapin)).
* Make single image for building coverage report [#18312](https://github.com/ClickHouse/ClickHouse/pull/18312) ([alesapin](https://github.com/alesapin)).
* Fixed flaky test [#18313](https://github.com/ClickHouse/ClickHouse/pull/18313) ([Vasily Nemkov](https://github.com/Enmk)).
* Perf test for ColumnMap [#18317](https://github.com/ClickHouse/ClickHouse/pull/18317) ([Vasily Nemkov](https://github.com/Enmk)).
* Add more tests to skip-list [#18318](https://github.com/ClickHouse/ClickHouse/pull/18318) ([Ivan](https://github.com/abyss7)).
* Add support for ANTLR inside clickhouse-test [#18319](https://github.com/ClickHouse/ClickHouse/pull/18319) ([Ivan](https://github.com/abyss7)).
* Fix clickhouse-test [#18330](https://github.com/ClickHouse/ClickHouse/pull/18330) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Provide extra constructor for Async metrics [#18331](https://github.com/ClickHouse/ClickHouse/pull/18331) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* tests: remove unused configs/scripts [#18334](https://github.com/ClickHouse/ClickHouse/pull/18334) ([Azat Khuzhin](https://github.com/azat)).
* Fix log message for memory tracking drift [#18335](https://github.com/ClickHouse/ClickHouse/pull/18335) ([Azat Khuzhin](https://github.com/azat)).
* try to pass ninja flags in deb package [#18348](https://github.com/ClickHouse/ClickHouse/pull/18348) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Remove useless code [#18350](https://github.com/ClickHouse/ClickHouse/pull/18350) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove unused code [#18366](https://github.com/ClickHouse/ClickHouse/pull/18366) ([Anton Popov](https://github.com/CurtizJ)).
* Return back some configs, that are used in Arcadia [#18370](https://github.com/ClickHouse/ClickHouse/pull/18370) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Return clickhouse-test-server for Arcadia needs [#18372](https://github.com/ClickHouse/ClickHouse/pull/18372) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Drop libnsl dependency (because of gRPC -> c-ares) [#18375](https://github.com/ClickHouse/ClickHouse/pull/18375) ([Azat Khuzhin](https://github.com/azat)).
* bump compatibility level to 10 for debian manifests [#18376](https://github.com/ClickHouse/ClickHouse/pull/18376) ([Azat Khuzhin](https://github.com/azat)).
* Do not override RULE_LAUNCH_COMPILE/RULE_LAUNCH_LINK in rocksdb [#18378](https://github.com/ClickHouse/ClickHouse/pull/18378) ([Azat Khuzhin](https://github.com/azat)).
* Make some perf tests faster on slower machines [#18386](https://github.com/ClickHouse/ClickHouse/pull/18386) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix exception text from Pipe.cpp [#18396](https://github.com/ClickHouse/ClickHouse/pull/18396) ([filimonov](https://github.com/filimonov)).
* Add test for already working code [#18405](https://github.com/ClickHouse/ClickHouse/pull/18405) ([alesapin](https://github.com/alesapin)).
* Try fix ya.make [#18409](https://github.com/ClickHouse/ClickHouse/pull/18409) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Use Port::Data instead of Chunk in LazyOutputFormat. [#18411](https://github.com/ClickHouse/ClickHouse/pull/18411) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Do not use watchdog when server is run from tty [#18433](https://github.com/ClickHouse/ClickHouse/pull/18433) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Raise an error if more than one key is provided to ip_dictionary [#18435](https://github.com/ClickHouse/ClickHouse/pull/18435) ([Vladimir C](https://github.com/vdimir)).
* Remove unused code [#18436](https://github.com/ClickHouse/ClickHouse/pull/18436) ([Anton Popov](https://github.com/CurtizJ)).
* Ignore SOURCE_DATE_EPOCH for newer ccache (4+) [#18441](https://github.com/ClickHouse/ClickHouse/pull/18441) ([Azat Khuzhin](https://github.com/azat)).
* Poco build fixes [#18443](https://github.com/ClickHouse/ClickHouse/pull/18443) ([Azat Khuzhin](https://github.com/azat)).
* [wip] some window function fixes [#18455](https://github.com/ClickHouse/ClickHouse/pull/18455) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Merging [#17858](https://github.com/ClickHouse/ClickHouse/issues/17858) [#18475](https://github.com/ClickHouse/ClickHouse/pull/18475) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Allow AppleClang builds [#18488](https://github.com/ClickHouse/ClickHouse/pull/18488) ([Denis Glazachev](https://github.com/traceon)).
* Build job pool tiny fixes [#18489](https://github.com/ClickHouse/ClickHouse/pull/18489) ([Azat Khuzhin](https://github.com/azat)).
* Add NuRaft to contrib [#18491](https://github.com/ClickHouse/ClickHouse/pull/18491) ([alesapin](https://github.com/alesapin)).
* Fix flaky test 01584_distributed_buffer_cannot_find_column [#18493](https://github.com/ClickHouse/ClickHouse/pull/18493) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* More correct error code on incorrect interserver protocol [#18515](https://github.com/ClickHouse/ClickHouse/pull/18515) ([alesapin](https://github.com/alesapin)).
* Merging  [#18188](https://github.com/ClickHouse/ClickHouse/issues/18188) [#18516](https://github.com/ClickHouse/ClickHouse/pull/18516) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix usage of concurrent bounded queue in test keeper storage [#18522](https://github.com/ClickHouse/ClickHouse/pull/18522) ([alesapin](https://github.com/alesapin)).
* Fix cast to map from tuple of arrays with unequal sizes [#18523](https://github.com/ClickHouse/ClickHouse/pull/18523) ([Anton Popov](https://github.com/CurtizJ)).
* Sim/Min Hash fixes [#18524](https://github.com/ClickHouse/ClickHouse/pull/18524) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Use RLIMIT_DATA/RLIMIT_AS over RLIMIT_RSS for ENABLE_CHECK_HEAVY_BUILDS [#18537](https://github.com/ClickHouse/ClickHouse/pull/18537) ([Azat Khuzhin](https://github.com/azat)).
* Do not throw logical error from IPAddressDictionary ctor [#18548](https://github.com/ClickHouse/ClickHouse/pull/18548) ([Vladimir C](https://github.com/vdimir)).
* Check for CLICKHOUSE_CLIENT_OPT env before setting it [#18574](https://github.com/ClickHouse/ClickHouse/pull/18574) ([Ivan](https://github.com/abyss7)).
* Minor fixes for min/sim hash [#18595](https://github.com/ClickHouse/ClickHouse/pull/18595) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Change union_default_mode to throw exception [#18615](https://github.com/ClickHouse/ClickHouse/pull/18615) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed exit code of watchdog [#18616](https://github.com/ClickHouse/ClickHouse/pull/18616) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Small utils improvements (check-marks and compressor) [#18619](https://github.com/ClickHouse/ClickHouse/pull/18619) ([Azat Khuzhin](https://github.com/azat)).
* Fix too long perf test [#18634](https://github.com/ClickHouse/ClickHouse/pull/18634) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* More correct words about parser [#18646](https://github.com/ClickHouse/ClickHouse/pull/18646) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless support for symbolic port names [#18647](https://github.com/ClickHouse/ClickHouse/pull/18647) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Send fatal logs in all tests [#18648](https://github.com/ClickHouse/ClickHouse/pull/18648) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix AppleClang compilation - Remove auto in function parameters [#18674](https://github.com/ClickHouse/ClickHouse/pull/18674) ([Denis Glazachev](https://github.com/traceon)).
* compressor: remove extra check for seeking of input [#18675](https://github.com/ClickHouse/ClickHouse/pull/18675) ([Azat Khuzhin](https://github.com/azat)).
* Better linker name matcher [#18678](https://github.com/ClickHouse/ClickHouse/pull/18678) ([Amos Bird](https://github.com/amosbird)).
* Remove "harmful" function from mariadbclient [#18682](https://github.com/ClickHouse/ClickHouse/pull/18682) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix performance comparison [#18686](https://github.com/ClickHouse/ClickHouse/pull/18686) ([Azat Khuzhin](https://github.com/azat)).
* Simplify code of function "bar" [#18687](https://github.com/ClickHouse/ClickHouse/pull/18687) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Merge byteSize function [#18688](https://github.com/ClickHouse/ClickHouse/pull/18688) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow Replicated tables in Arcadia [#18697](https://github.com/ClickHouse/ClickHouse/pull/18697) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Bump replxx to fix loading of multi-line entries from the history [#18700](https://github.com/ClickHouse/ClickHouse/pull/18700) ([Azat Khuzhin](https://github.com/azat)).
* Add a test for already fixed issue [#18702](https://github.com/ClickHouse/ClickHouse/pull/18702) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report: applying non-zero offset to nullptr [#18703](https://github.com/ClickHouse/ClickHouse/pull/18703) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable more tests and see what will happen [#18704](https://github.com/ClickHouse/ClickHouse/pull/18704) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added a test for [#13477](https://github.com/ClickHouse/ClickHouse/issues/13477) [#18708](https://github.com/ClickHouse/ClickHouse/pull/18708) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix fuzz errors in sumMap [#18710](https://github.com/ClickHouse/ClickHouse/pull/18710) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Use relaxed for flag in RemoteQueryExecutorReadContext. [#18715](https://github.com/ClickHouse/ClickHouse/pull/18715) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Do not throw from Parser [#18745](https://github.com/ClickHouse/ClickHouse/pull/18745) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove pink screen with confusing questions about Kerberos [#18748](https://github.com/ClickHouse/ClickHouse/pull/18748) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Don't allow conversion between UUID and numeric types [#18749](https://github.com/ClickHouse/ClickHouse/pull/18749) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove bad code in HashJoin [#18750](https://github.com/ClickHouse/ClickHouse/pull/18750) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* More robust stateful test [#18751](https://github.com/ClickHouse/ClickHouse/pull/18751) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test from [#15641](https://github.com/ClickHouse/ClickHouse/issues/15641) [#18753](https://github.com/ClickHouse/ClickHouse/pull/18753) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Mark some TestFlows as flaky [#18757](https://github.com/ClickHouse/ClickHouse/pull/18757) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove some headers [#18758](https://github.com/ClickHouse/ClickHouse/pull/18758) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a regression test for marks corruption [#18763](https://github.com/ClickHouse/ClickHouse/pull/18763) ([Azat Khuzhin](https://github.com/azat)).
* Use sigdescr_np() over sys_siglist (fixes glibc 2.32+ unbundled build) [#18764](https://github.com/ClickHouse/ClickHouse/pull/18764) ([Azat Khuzhin](https://github.com/azat)).
* Do not materialize block for FetchColumns header. [#18768](https://github.com/ClickHouse/ClickHouse/pull/18768) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Query Fuzzer: fix some cultural issues [#18770](https://github.com/ClickHouse/ClickHouse/pull/18770) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* more tests for simple aggregate functions in summingMT aggregatingMT try2 [#18771](https://github.com/ClickHouse/ClickHouse/pull/18771) ([Denny Crane](https://github.com/den-crane)).
* Check if XCODE_IDE is true and avoid enforcing ninja in that case [#18773](https://github.com/ClickHouse/ClickHouse/pull/18773) ([Denis Glazachev](https://github.com/traceon)).
* Respect memory tracker blocker level during deallocations [#18774](https://github.com/ClickHouse/ClickHouse/pull/18774) ([Azat Khuzhin](https://github.com/azat)).
* Do not allow Fuzzer to enable LLVM [#18777](https://github.com/ClickHouse/ClickHouse/pull/18777) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add sanity checks for Sim/Min hash arguments [#18803](https://github.com/ClickHouse/ClickHouse/pull/18803) ([Azat Khuzhin](https://github.com/azat)).
* Respect MINSIGSTKSZ for alternative stack to fix under aarch64 [#18832](https://github.com/ClickHouse/ClickHouse/pull/18832) ([Azat Khuzhin](https://github.com/azat)).
* Do not check bit flips for big buffers (since the size can be corrupted) [#18852](https://github.com/ClickHouse/ClickHouse/pull/18852) ([Azat Khuzhin](https://github.com/azat)).
* Correctly override default settings remotely [#18857](https://github.com/ClickHouse/ClickHouse/pull/18857) ([Amos Bird](https://github.com/amosbird)).
* Import strsignal from Musl [#18858](https://github.com/ClickHouse/ClickHouse/pull/18858) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Storage features improvements [#18870](https://github.com/ClickHouse/ClickHouse/pull/18870) ([Azat Khuzhin](https://github.com/azat)).
* Fix integrity check [#18871](https://github.com/ClickHouse/ClickHouse/pull/18871) ([Azat Khuzhin](https://github.com/azat)).
* Minor fix in backport script [#18873](https://github.com/ClickHouse/ClickHouse/pull/18873) ([Ivan](https://github.com/abyss7)).
* Query Fuzzer: return fail fast semantics [#18880](https://github.com/ClickHouse/ClickHouse/pull/18880) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless headers [#18881](https://github.com/ClickHouse/ClickHouse/pull/18881) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Use time_macros over unset SOURCE_DATE_EPOCH in ccache 4.2 (unreleased) [#18885](https://github.com/ClickHouse/ClickHouse/pull/18885) ([Azat Khuzhin](https://github.com/azat)).
* Remove useless code [#18886](https://github.com/ClickHouse/ClickHouse/pull/18886) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove TestFlows due to timeouts [#18888](https://github.com/ClickHouse/ClickHouse/pull/18888) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless headers [#18892](https://github.com/ClickHouse/ClickHouse/pull/18892) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Drop RESTART REPLICAS from stateless tests to avoid locking lots of mutexes [#18897](https://github.com/ClickHouse/ClickHouse/pull/18897) ([Azat Khuzhin](https://github.com/azat)).
