macro(add_glob cur_list)
    file(GLOB __tmp CONFIGURE_DEPENDS RELATIVE ${CMAKE_CURRENT_SOURCE_DIR} ${ARGN})
    list(APPEND ${cur_list} ${__tmp})
endmacro()

macro(add_headers_and_sources prefix common_path)
    add_glob(${prefix}_headers ${common_path}/*.h)
    add_glob(${prefix}_sources ${common_path}/*.cpp ${common_path}/*.c)
endmacro()

macro(add_headers_only prefix common_path)
    add_glob(${prefix}_headers ${common_path}/*.h)
endmacro()

# Assumes the path is under src and that src/ needs to be removed (valid for any subdirectory under src/)
macro(extract_into_parent_list src_list dest_list)
    list(REMOVE_ITEM ${src_list} ${ARGN})
    file(RELATIVE_PATH relative ${CMAKE_SOURCE_DIR} ${CMAKE_CURRENT_SOURCE_DIR})
    string(REPLACE "src/" "" relative ${relative})
    foreach(file IN ITEMS ${ARGN})
        list(APPEND ${dest_list} ${relative}/${file})
    endforeach()
    set(${dest_list} "${${dest_list}}" PARENT_SCOPE)
endmacro()
