/*! For license information please see renderer.js.LICENSE.txt */

const VERSION = "0.20.39 Opt-3";
function language(v, en, cn) {
    return v === 0 ? cn : v === 1 ? en : en;
}
class Language {
    constructor(language) {
        this.language = language === null ? 0 : language
    }
    locale() { return language(this.language, 'en-us', 'zh-cn') }
    languageString() { return language(this.language, "Language", "语言") }
    loading() { return language(this.language, "Loading...", "加载中...") }
    error() { return language(this.language, "Error", "错误") }
    yes() { return language(this.language, "Yes", "是") }
    no() { return language(this.language, "No", "否") }
    failedConnectCore() { return language(this.language, "Could not connect to Clash core, logs are not available.", "无法连接到 Clash core 核心，日志不可用") }
    homeDirectory() { return language(this.language, "Home Directory", "主目录") }
    openFolder() { return language(this.language, "Open Folder", "打开文件夹") }
    logsFolder() { return language(this.language, "Logs Folder", "日志文件夹") }
    tryRepair() { return language(this.language, "Try to repair", "尝试修复") }
    ok() { return language(this.language, "OK", "确定") }
    text() { return language(this.language, "Text", "文本") }
    install() { return language(this.language, "Install", "安装") }
    uninstall() { return language(this.language, "Uninstall", "卸载") }
    name() { return language(this.language, "Name", "名字") }
    save() { return language(this.language, "Save", "保存") }
    cancel() { return language(this.language, "Cancel", "取消") }
    add() { return language(this.language, "Add", "添加") }
    quit() { return language(this.language, "Quit", "退出") }
    restartingCore() { return language(this.language, "Restarting core...", "重新启动核心...") }
    noProxyGroupInProfile() { return language(this.language, "No proxy group in this profile", "此配置文件中没有代理组") }
    connectInfo() { return language(this.language, "Connection Info", "连接信息") }
    cfwRunInBg() { return language(this.language, "Clash is running in the background", "Clash 正在后台运行") }
    enjoyFreedom() { return language(this.language, "Enjoy your free time", "享受您的自由时间") }
    failUpdateUrlProfile() { return language(this.language, "fail to update profile with url", "无法使用 url 更新配置资料") }
    profileUpdateFail() { return language(this.language, "Profile update failed", "配置资料更新失败") }
    profileDownloaded() { return language(this.language, "Profile had been downloaded successfully", "配置资料已成功下载") }
    appExiting() { return language(this.language, "app exiting, turn off system proxy", "应用退出, 关闭系统代理") }
    httpFailStart() { return language(this.language, "http server failed to start with error", "http 服务器因错误而无法启动") }
    httpStartAt() { return language(this.language, "http server started at", "http 服务器开始于") }
    firstLunach() { return language(this.language, "first luanch, creating config.yaml...", "首次发布, 创建 config.yaml 中...") }
    appStartWithMode() { return language(this.language, "app start with mode", "应用程序以模式开始") }
    failLoadGeneralCfg() { return language(this.language, "fail to load general config.yaml with error", "无法加载常规 config.yaml 并出现错误") }
    loadDataFromGeneral() { return language(this.language, "load data from general config.yaml", "从一般加载 config.yaml 数据") }
    general() { return language(this.language, "General", "主页") }
    proxies() { return language(this.language, "Proxies", "代理") }
    profiles() { return language(this.language, "Profiles", "配置") }
    logs() { return language(this.language, "Logs", "日志") }
    connections() { return language(this.language, "Connections", "连接") }
    feedback() { return language(this.language, "Feedback", "关于") }
    providers() { return language(this.language, "Providers", "提供") }
    stopSorting() { return language(this.language, "Stop Sorting", "停止排序") }
    connected() { return language(this.language, "Connected", "已连接") }
    disconnected() { return language(this.language, "Disconnected", "未连接") }
    nowVersionUpToDate() { return language(this.language, "You are awesome", "当前版本是最新的") }
    nowVersionUpToDateDescribe() { return language(this.language, "The current version is up to date.", "当前汉化版本也是最新的") }
    updatedThenRestartAsk() { return language(this.language, "Update installed successfully, do you want to restart the APP?", "更新安装成功，要重启APP吗?") }
    downloadDoneRunAsk() { return language(this.language, "Package downloaded successfully, do you want to execute it?", "包下载成功，要执行吗?") }
    port() { return language(this.language, "Port", "端口") }
    changeMixedPort() { return language(this.language, "Change Mixed Port", "更改混合端口") }
    newPort() { return language(this.language, "New Port", "新端口") }
    allowLAN() { return language(this.language, "Allow LAN", "允许局域网") }
    infoAllowLAN() { return language(this.language, "Turn on to listen on all interfaces by default, or else only listen\n          on 127.0.0.1. You can change the Bind Address on the right side to\n          specify a particular interface.", "默认开启监听所有接口，否则只监听127.0.0.1。 您可以更改右侧的绑定地址以指定特定接口") }
    logLevel() { return language(this.language, "Log Level", "日志级别") }
    clashCore() { return language(this.language, "Clash Core", "Clash 内核") }
    loopbackUWP() { return language(this.language, "UWP Loopback", "UWP 应用联网限制解除工具") }
    deviceTAP() { return language(this.language, "TAP Device", "虚拟网卡安装（TAP 模式）") }
    serviceMode() { return language(this.language, "Service Mode", "服务模式") }
    mixin() { return language(this.language, "Mixin", "混合配置") }
    sysProxy() { return language(this.language, "System Proxy", "系统代理") }
    askOpenURL() { return language(this.language, "Are you sure to open this URL", "您确定要打开此 URL?") }
    silent() { return language(this.language, "silent", "静默") }
    errorS() { return language(this.language, "error", "错误") }
    warn() { return language(this.language, "warn", "警告") }
    warning() { return language(this.language, "Warning", "警告") }
    info() { return language(this.language, "info", "信息") }
    debug() { return language(this.language, "debug", "调试") }
    logLevelSelection() { return language(this.language, ["silent", "error", "warn", "info", "debug"], ["静默", "错误", "警告", "信息", "调试"]) }
    silentDescribe() { return language(this.language, "silent will prevent .log file to generate on next startup", "静默将阻止 .log 文件在下次启动时生成, 而调试将收集所有运行信息至 .log 文件") }
    changeLogLevel() { return language(this.language, "Change Log Level", "更改日志收集级别") }
    global() { return language(this.language, "Global", "全局") }
    rule() { return language(this.language, "Rule", "规则") }
    direct() { return language(this.language, "Direct", "直连") }
    script() { return language(this.language, "Script", "脚本") }
    settings() { return language(this.language, "Settings", "设置") }
    resetAllSettings() { return language(this.language, "Reset All Settings", "重置所有设置") }
    forceQuit() { return language(this.language, "Force Quit", "强制退出") }
    security() { return language(this.language, "Security", "安全") }
    coreSecret() { return language(this.language, "Core Secret", "核心Secret") }
    coreSecretDscribeFirst() { return language(this.language, "Set Clash Core's", "将 Clash Core 的") }
    coreSecretDscribeSecond() { return language(this.language, "to a random RFC", "设置为随机的 RFC") }
    coreSecretDscribeThird() { return language(this.language, "4122 version 4 UUID, so that Clash REST API cannot be accessed arbitrarily.", "4122 版本 4 UUID，这样 Clash REST API 就不能被任意访问。") }
    coreSecretDscribeFourth() { return language(this.language, "The value is stored in the", "该值存储在于") }
    coreSecretDscribeFifth() { return language(this.language, "For details, see", "有关详细信息，请参阅Clash文档:") }
    allowUnsafeURLs() { return language(this.language, "Allow Unsafe URLs", "允许不安全的 URL") }
    allowUnsafeURLsDescribeFirst() { return language(this.language, "Set the URLs that do not verify the certificate when requesting", "设置请求时不验证证书的URL") }
    allowUnsafeURLsDescribeSecond() { return language(this.language, "Do not  ", "不要更改它") }
    allowUnsafeURLsDescribeThird() { return language(this.language, "change it, if you do not know what it is", ", 除非你知道它是什么") }
    settingsEditor() { return language(this.language, "Settings Editor", "配置编辑器") }
    settingsEditorFirst() { return language(this.language, "Text editor used by Settings.", "设置使用的文本编辑器") }
    settingsEditorSecond() { return language(this.language, "For", "对于") }
    settingsEditorThird() { return language(this.language, ", the command should only return control", ", 该命令只应在编辑文件关闭后返回控制权。") }
    settingsEditorFourth() { return language(this.language, "after the edited file is closed. For example:", "例如:") }
    custom() { return language(this.language, "Custom", "自定义") }
    actions() { return language(this.language, "Actions", "操作(Actions)") }
    theme() { return language(this.language, "Theme", "主题") }
    themeOption() { return language(this.language, ["Light", "Dark", "Minecraft", "Cyberpunk"], ["明亮", "深色", "我的世界", "赛博朋克"]) }
    networkInterfaces() { return language(this.language, "Network Interfaces", "网络端口") }
    mixinAllowsDescribe() { return language(this.language, "Mixin allows you to overwrite the original configuration file", "Mixin允许您覆盖原始配置文件") }
    startWithWindows() { return language(this.language, "Start with Windows", "开机自启动") }
    sortDescribe() { return language(this.language, "Drag to sort or add to the list on the right", "拖动以排序或添加到右侧列表中") }
    manage() { return language(this.language, "Manage", "管理") }
    reinstallDescribeWithTAP() { return language(this.language, "You need to reinstall the TAP device after you change these fields.", "更改这些字段后，您需要重新安装虚拟网卡") }
    TAPdeviceManagement() { return language(this.language, "TAP device management", "虚拟网卡设置管理") }
    TAPinstallDescribe() { return language(this.language, "An adapter named “cfw-tap” will route your data into clash.\n\n If the installation box pops up, keep clicking “Next”, until the installation is complete.", "名为 “cfw-tap” 的适配器会将您的数据路由到Clash中.\n\n如果弹出安装框, 请继续单击 “下一步”,  直到安装完成") }
    customize() { return language(this.language, "Customize", "定制") }
    serviceManagement() { return language(this.language, "Service management", "服务管理") }
    serviceManagementDescribe() { return language(this.language, "It might take a while.\nThe APP will be relaunched automatically.\n\nCurrent status: ", "这可能需要一段时间.\n该APP将自动重新启动.\n\n当前状态: ") }
    inactive() { return language(this.language, "Inactive", "未安装") }
    active() { return language(this.language, "Active", "已安装") }
    IPaddress() { return language(this.language, "IP Address", "IP地址") }
    subnetMask() { return language(this.language, "Subnet Mask", "子网掩码") }
    defaultGateway() { return language(this.language, "Default Gateway", "默认网关") }
    success() { return language(this.language, "Success", "成功") }
    failed() { return language(this.language, "Failed", "失败") }
    tapDeviceInstalled() { return language(this.language, "cfw-tap device had been installed", "cfw-tap 已安装") }
    notInstallTapDevice() { return language(this.language, "counld not install cfw-tap device", "无法安装 cfw-tap") }
    tapDeviceRemoved() { return language(this.language, "cfw-tap device had been removed", "cfw-tap 已被移除") }
    notRemoveTapDevice() { return language(this.language, "counld not remove cfw-tap device", "无法移除 cfw-tap") }
    TUNmode() { return language(this.language, "TUN Mode", "TUN 模式") }
    TUNmodeDescribe() { return language(this.language, "To enable this mode, please install Service Mode first. After enabling, all applications can be proxied.", "类似于虚拟网卡，启用后可代理所有应用。要启用此模式，请先安装服务模式") }
    recommended() { return language(this.language, "recommended", "推荐") }
    installMethod() { return language(this.language, "Install method:", "安装方法:") }
    cmmandsInCopied() { return language(this.language, "Commands have been copied to Clipboad", "命令已复制到剪贴板") }
    openTerminalSetProxy() { return language(this.language, "Open terminal with proxy set up", "打开终端并设置代理") }
    runAsAdmin() { return language(this.language, "run as admin", "以管理员身份运行") }
    selectTterminal() { return language(this.language, "Select a terminal", "选择一个终端") }
    copyCommandsOnly() { return language(this.language, "Copy Commands Only", "仅复制命令") }
    copyCommand() { return language(this.language, "Copy Command", "复制命令") }
    copyProxySettingCommands() { return language(this.language, "Copy proxy setting commands", "复制代理设置命令") }
    terminal() { return language(this.language, "terminal", "终端") }
    specialProxies() { return language(this.language, "Special Proxies", "特殊代理") }
    randomMixedPort() { return language(this.language, "Random Mixed Port", "随机混合端口") }
    randomMixedPortDescribeFirst() { return language(this.language, "Turn on to generate a new proxy server port number when the app starts.\n            ", "打开应用程序启动时生成新的代理服务器端口号。\n            ") }
    randomMixedPortDescribeSecond() { return language(this.language, "The value is shown as Port in General, and is \n            stored as\n            ", "该值在 General 中显示为 Port，\n            并存储为\n            ") }
    randomMixedPortDescribeThird() { return language(this.language, "\n            in the\n            ", "\n            位于: \n            ") }
    launchHelper() { return language(this.language, "Launch Helper", "启动助手") }
    bind() { return language(this.language, "Bind: ", "绑定地址: ") }
    newBindAddress() { return language(this.language, "New Bind Address", "新绑定地址") }
    changeBindAddress() { return language(this.language, "Change Bind Address", "更改绑定地址") }
    changeBindAddressDescribe() { return language(this.language, "Allow LAN will only bind to address you set, * means all interfaces", "允许LAN只会绑定到您设置的地址，* 表示所有接口") }
    serversDNS() { return language(this.language, "DNS Servers", "DNS 服务器") }
    modeSettingsTUN() { return language(this.language, "TUN Mode Settings", "TUN 模式设置") }
    fallbackDNSServers() { return language(this.language, "Fallback DNS Servers", "后备 DNS 服务器") }
    deaultNameserver() { return language(this.language, "Deault Nameserver", "默认名称服务器") }
    fakeIPFilter() { return language(this.language, "Fake IP Filter", "Fake IP 过滤器") }
    nameserverPolicy() { return language(this.language, "Nameserver Policy", "域名服务器政策") }
    domain() { return language(this.language, "domain", "域名") }
    hijacksDNS() { return language(this.language, "DNS Hijacks", "DNS 劫持") }
    stackTUN() { return language(this.language, "TUN Stack", "TUN 码(TUN Stack)") }
    autoDetectInterface() { return language(this.language, "Auto Detect Interface", "自动检测接口") }
    eg() { return language(this.language, "eg: ", "例子: ") }
    addFirewallRules() { return language(this.language, "add firewall rules (for Allow LAN and system stack)", "添加防火墙规则 (允许 LAN 和系统堆栈)") }
    previewCfgToClashCore() { return language(this.language, "Preview the final configuration file that was submitted to Clash Core", "预览提交给 Clash Core 的最终配置文件") }
    useClashCoreSeeHost() { return language(this.language, "Resolve a host using Clash core", "使用 Clash core 解析 Host") }
    testByScriptMode() { return language(this.language, "Test script using by Script mode", "使用脚本模式测试脚本") }
    authority() { return language(this.language, "Authority", "授权") }
    queryDNS() { return language(this.language, "DNS Query", "DNS 查询") }
    host() { return language(this.language, "Host", "主机（Host）") }
    lookup() { return language(this.language, "Lookup", "检索") }
    pleaseInputDomain() { return language(this.language, "Please input domain", "请输入域名") }
    scriptTest() { return language(this.language, "Script Test", "脚本测试") }
    network() { return language(this.language, "Network", "网络") }
    modeDNS() { return language(this.language, "DNS Mode", "DNS 模式") }
    sourceIP() { return language(this.language, "Source IP", "源 IP") }
    sourcePort() { return language(this.language, "Source Port", "源端口") }
    destinationIP() { return language(this.language, "Destination IP", "目的地 IP") }
    destinationPort() { return language(this.language, "Destination Port", "目的地端口") }
    processPath() { return language(this.language, "Process Path", "进程路径") }
    type() { return language(this.language, "type", "类型") }
    typeDescribe() { return language(this.language, "Windows accepts an HTTP endpoint or PAC\n            (proxy auto-configuration) script. The HTTP mode is generally\n            sufficient.", "Windows 接受 HTTP 端点或 PAC\n            （代理自动配置）脚本。\n            HTTP 模式通常就足够了。") }
    customizeTrayIconInProxy() { return language(this.language, "Proxy On Icon Path", "自定义代理启用时的状态栏图标") }
    customizeTrayIconInProxyDescribe() { return language(this.language, "Set the taskbar icon when system proxy/TUN/hybrid configuration is turned on", "设置当 系统代理/TUN/混合配置 开启时的任务栏图标") }
    customizeTrayIcon() { return language(this.language, "Default Icon Path", "自定义状态栏图标") }
    customizeTrayIconDescribe() { return language(this.language, "Set the taskbar icon in the default state", "设置默认的任务栏图标") }
    check() { return language(this.language, "Check", "测试") }
    timeout() { return language(this.language, "Timeout", "超时") }
    profileDescribeStart() { return language(this.language, "Go to", "前往") }
    profileDescribeEnd() { return language(this.language, "to import/switch a profile", "导入/切换配置文件") }
    allTrafficGoDirectly() { return language(this.language, "All traffic will go directly", "所有流量都会直连") }
    routedThroughSelectedProxy() { return language(this.language, "Routed through the selected proxy", "通过选定的代理路由") }
    routedAccordingRule() { return language(this.language, "Routed according to the rules", "按规则路由") }
    goDirectly() { return language(this.language, "Go directly", "直接连接") }
    routedAccordingScript() { return language(this.language, "Routed according to the script", "根据脚本进行路由") }
    inbound() { return language(this.language, "Inbounds", "进入") }
    edit() { return language(this.language, "Edit", "编辑") }
    editExternally() { return language(this.language, "Edit externally", "在系统中编辑") }
    update() { return language(this.language, "Update", "更新") }
    openFile() { return language(this.language, "Open File", "打开文件") }
    showInFolder() { return language(this.language, "Show in folder", "打开文件所在位置") }
    diffDescribe() { return language(this.language, "Make changes to a profile then merge them for it when refresh profile.", "对配置文件进行更改，然后在更新时合并它们。") }
    docs() { return language(this.language, "Docs", "文档") }
    initDiffFiles() { return language(this.language, "Init diff files", "初始化 diff 文件") }
    sideBySideMode() { return language(this.language, "Side by side mode", "并排模式") }
    diffControlsDescribe() { return language(this.language, "Controls whether the diff editor shows the diff side by side or inline.", "控制 diff 编辑器是并排还是内联显示 diff") }
    makeChangesAndDelete() { return language(this.language, ["Make changes", "Delete diff files"], ["修改文件", "删除 diff 文件"]) }
    askDelete() { return language(this.language, "Are you sure to delete ", "您确定要删除 ") }
    diffFiles() { return language(this.language, "diff files", "diff 文件") }
    failMergeProfile() { return language(this.language, 'Fail to merge profiles, "Make changes" to solve issues.', '无法合并配置文件, "修改文件" 以解决问题.') }
    scrollGroup() { return language(this.language, "Scroll to group", "移动至组") }
    proxyGroups() { return language(this.language, "Proxy Groups", "代理组") }
    diffChangeContainConflict() { return language(this.language, 'Changes contains conflict, "Make changes" to solve issues', '更改包含冲突, "修改(diff)文件" 以解决问题') }
    askSaveChange() { return language(this.language, "Do you want to save the changes?", "是否要保存更改?") }
    requestRefresh() { return language(this.language, "A refresh is required to apply the different changes. Do it now?", "需要刷新才能应用不同的更改。立即执行?") }
    requestRefreshOption() { return language(this.language, ["Refresh", "Not now"], ["刷新", "现在不要"]) }
    fiterByKeywords() { return language(this.language, "fiter by keywords", "按关键字过滤") }
    scrollToProxy() { return language(this.language, "scroll to selected proxy", "移动到选定的代理") }
    showHieDashboard() { return language(this.language, "Show/Hide Dashboard", "显示/隐藏仪表板") }
    showHieTimedOutProxies() { return language(this.language, "Show/Hide timed-out proxies", "显示/隐藏超时节点") }
    runTrayScript() { return language(this.language, "Run Tray Script", "运行托盘脚本") }
    showConnections() { return language(this.language, "Show connections", "显示连接") }
    testLatency() { return language(this.language, "test latency", "测试延迟") }
    runScript() { return language(this.language, "Run script", "运行脚本") }
    topMatchRule() { return language(this.language, "Top 100 matching rules", "前100个匹配规则") }
    copy() { return language(this.language, "Copy", "复制") }
    duplicateProfile() { return language(this.language, "duplicate profile", "复制配置文件") }
    inputNewFileName() { return language(this.language, "Input a new file name", "输入一个新的文件名") }
    downloadFromURL() { return language(this.language, "Download from a URL", "从URL下载") }
    downloading() { return language(this.language, "Downloading", "下载中") }
    download() { return language(this.language, "Download", "下载") }
    copyURL() { return language(this.language, "Copy URL", "复制 URL") }
    updateAll() { return language(this.language, "Update All", "更新全部") }
    import() { return language(this.language, "Import", "导入") }
    scheme() { return language(this.language, "Scheme", "跳转方案") }
    delete() { return language(this.language, "Delete", "删除") }
    editProfileInformation() { return language(this.language, "Edit profile information", "编辑配置信息") }
    updateInterval() { return language(this.language, "Update Interval (hour)", "更新间隔(小时)") }
    localFileAlreadyExist() { return language(this.language, "Local file already exist.", "本地文件已存在.") }
    closeEditingFileSave() { return language(this.language, "Close the editing file to Save", "关闭编辑文件以保存") }
    requestLogs() { return language(this.language, "Request Logs", "请求日志") }
    emptyLogList() { return language(this.language, "Empty log list", "空日志列表") }
    start() { return language(this.language, "Start", "开始") }
    pause() { return language(this.language, "Pause", "暂停") }
    refreshBrowserMakeRequest() { return language(this.language, "Refresh your browser to make requests.", "刷新浏览器以发出请求.") }
    clear() { return language(this.language, "Clear", "清除") }
    search() { return language(this.language, "Search", "搜索") }
    resume() { return language(this.language, "Resume", "恢复") }
    headers() { return language(this.language, "Headers", "标头") }
    updateCron() { return language(this.language, "Update ", "更新定时程序 ") }
    parsers() { return language(this.language, "Parsers", "配置文件预处理") }
    parsersOption() { return language(this.language, ["Edit Parsers", "OK"], ["编辑解析器", "确认"]) }
    parsersDescribeStart() { return language(this.language, "Modify and customize your profiles after download but before", "在下载后修改和自定义你的配置，在") }
    parsersDescribeEnd() { return language(this.language, ".", "开始之前.") }
    parsersStart() { return language(this.language, "Found ", "找到 ") }
    parsersEnd() { return language(this.language, " matching parsers", " 个匹配解析器") }
    qrCode() { return language(this.language, "QR Code", "二维码") }
    chains() { return language(this.language, "Chains: ", "模式: ") }
    simpleAndDetailed() { return language(this.language, ["Simple", "Detailed"], ["简略", "详细"]) }
    infoAndDebug() { return language(this.language, ["info", "debug"], ["信息", "调试"]) }
    server() { return language(this.language, "server", "服务器") }
    updateThroughBuiltInProxyDescribe() { return language(this.language, "By default, requests in CFW will follow the system proxy\n            settings. When this switch is turned on, the update requests for\n            Profiles will be directed through the built-in proxy in\n            Clash.", "默认情况下，CFW 中的请求将遵循系统代理设置。 当此开关打开时，Profiles 的更新请求将通过内置代理定向至 Clash。") }
    updateThroughBuiltInProxy() { return language(this.language, "Update Through Built-in Proxy", "通过内置代理更新") }
    checkForUpdate() { return language(this.language, "Check For Updates", "检查更新") }
    checkForUpdateDescribe() { return language(this.language, "Set whether to check for updates every 6 hours", "设置是否每6小时检查一次更新") }
    ssid() { return language(this.language, "Service Set Identifier (SSID)", "服务集标识 (SSID)") }
    closeAll() { return language(this.language, "Close All", "全部关闭") }
    startTime() { return language(this.language, "Start Time", "开始时间") }
    uploadSpeed() { return language(this.language, "Upload Speed", "上传速度") }
    downloadSpeed() { return language(this.language, "Download Speed", "下载速度") }
    total() { return language(this.language, "Total", "总共") }
    uploadTraffic() { return language(this.language, "Upload Traffic", "上传流量") }
    downloadTraffic() { return language(this.language, "Download Traffic", "下载流量") }
    destination() { return language(this.language, "Destination", "目的地") }
    reorder() { return language(this.language, "Reorder", "重新排序") }
    scrollViewMore() { return language(this.language, "scroll to view more", "滑动鼠标以查看更多") }
    askResetAllSettings() { return language(this.language, "Are you sure to reset all settings?", "您确定要重设所有设置吗?") }
    askQuit() { return language(this.language, "Are you sure to quit?", "你确定要退出吗?") }
    path() { return language(this.language, "path", "路径") }
    appearance() { return language(this.language, "Appearance", "外观") }
    notifications() { return language(this.language, "Send Relevant Information", "向系统通知栏发送相关信息") }
    notificationsDescribe() { return language(this.language, "Set whether to allow pop-up system-level notifications which is related to Clash For Windows", "向系统通知栏发送相关信息") }
    silentStart() { return language(this.language, "Silent Start", "开启Clash时默认缩小到任务栏") }
    silentStartDescribe() { return language(this.language, "Set whether to display dashboard at startup", "设置是否在程序启动时显示仪表板窗口") }
    randomControllerPort() { return language(this.language, "Random Controller Port", "随机占用端口") }
    randomControllerPortDescribe() { return language(this.language, "Set whether to use a random port as the core controller port (the\n            port section of external-controller in Home\n            Directory/config.ymal)", "设置是否使用随机端口作为核心控制器端口 (\n            Home Directory/config.yaml 中 external-controller\n            的端口部分)") }
    lightweightMode() { return language(this.language, "Lightweight Mode", "轻量模式") }
    lightweightModeDescribeStart() { return language(this.language, "Turn on to terminate app processes after closing the dashboard,\n            but keep Clash Core running in the background. Most of the。\n            features provided by CFW will be unavailable then.\n            ", "关闭仪表板后打开以终止应用程序进程,\n            但保持 Clash Core 在后台运行。\n            届时，CFW 提供的大部分功能将不可用\n            ") }
    lightweightModeDescribeEnd() { return language(this.language, "Relies on the ", "依赖: ") }
    runTimeFormat() { return language(this.language, "Run Time Format", "运行时间格式") }
    guiLogFolder() { return language(this.language, "GUI Log Folder", "GUI日志文件夹") }
    guiDataFolder() { return language(this.language, "GUI Data Folder", "GUI数据文件夹") }
    open() { return language(this.language, "Open", "打开") }
    followSystemTheme() { return language(this.language, "Follow System Theme", "遵循系统主题") }
    fontFamily() { return language(this.language, "Font Family", "字体系列") }
    useSystemEmoji() { return language(this.language, "Use System Emoji", "使用系统表情符号") }
    assetpath() { return language(this.language, "asset path", "路径") }
    enhancedTray() { return language(this.language, "Enhanced Tray", "悬浮窗") }
    enhancedTrayDescribeFirst() { return language(this.language, "Set whether to enable custom taskbar (macOS) / hover window\n            (Windows)", "设置是否启用自定义任务栏 (macOS) / 悬停窗口\n            (Windows)") }
    enhancedTrayDescribeSecond() { return language(this.language, "Drag icons between ”show” and ”hide“ to control", "在“显示”和“隐藏”之间拖动图标来控制") }
    textdisplayTray() { return language(this.language, "Text to display in tray", "要显示在悬浮窗中的文本") }
    select() { return language(this.language, "Select", "选择") }
    transparent() { return language(this.language, "Transparent", "透明") }
    foregroundColor() { return language(this.language, "foreground color", "前景色") }
    scriptToRun() { return language(this.language, "Script to run", "要运行的脚本") }
    showNewVersionIcon() { return language(this.language, "Show New Version Icon", "有新版本时提醒") }
    bypassDomain() { return language(this.language, "Bypass Domain", "绕过域/网络") }
    bypassDomainDescribeStart() { return language(this.language, "Bypass (don't use) the proxy server when visiting certain\n            addresses.", "访问某些地址时绕过（不使用）代理服务器。") }
    bypassDomainDescribeEnd() { return language(this.language, "\n            The interpretation of this list is OS-dependent and app-dependent.\n            In other words, your operating systems and applications may\n            evaluate the rules differently.", "\n            此列表的解释取决于操作系统和应用程序. 换句话说，您的操作系统和应用程序可能会以不同的方式评估规则") }
    specifyProtocol() { return language(this.language, "Specify Protocol", "指定协议") }
    specifyProtocolDescribeStart() { return language(this.language, "Turn on to forcibly add scheme to the system proxy settings.", "打开以强制将方案添加到系统代理设置") }
    specifyProtocolDescribeEnd() { return language(this.language, "\n            This is not for general-purpose use, and indeed violates the\n            current spec of Windows. Consider it only when an old Python\n            program has trouble.", "\n            这不是通用用途,\n            并且确实违反了当前的 Windows 规范.\n            仅在使用旧的 Python 时才考虑它.") }
    staticHost() { return language(this.language, "Static Host", "静态主机") }
    staticHostDescribe() { return language(this.language, "Set the system proxy Host part to static content, if not set, the\n            host defaults to 127.0.0.1", "将系统代理主机部分设置为静态内容, 如果没有设置,\n            主机默认为 127.0.0.1") }
    proxyItemWidth() { return language(this.language, "Proxy Item Width", "代理项目宽度") }
    proxyItemWidthDescribe() { return language(this.language, "Set the display width of each proxy in the Proxies module", "在代理界面中设置每个节点的显示宽度") }
    breakWhenProxyChange() { return language(this.language, "Break When Proxy Change", "代理更改时中断连接") }
    breakWhenProxyChangeOption() { return language(this.language, ["None", "Chain", "All"], ["不中断", "旧链接", "所有"]) }
    breakWhenProxyChangeDescribeFirst() { return language(this.language, "Set the strategy for closing connections when switching proxies in the Proxies module.", "在代理模块中设置切换代理时关闭连接的策略:") }
    breakWhenProxyChangeDescribeSecond() { return language(this.language, "None", "不中断") }
    breakWhenProxyChangeDescribeThird() { return language(this.language, "Do not close", "不关闭任何链接") }
    breakWhenProxyChangeDescribeFourth() { return language(this.language, "Chain", "旧链接") }
    breakWhenProxyChangeDescribeFifth() { return language(this.language, "Close connections with proxy name in chain", "中断通过该代理组的连接") }
    all() { return language(this.language, "All", "全部") }
    breakWhenProxyChangeDescribeSeventh() { return language(this.language, "Close all connections", "关闭所有连接") }
    miniListWidth() { return language(this.language, "Mini List Width", "策略组导航器宽度") }
    miniListWidthDescribe() { return language(this.language, "Set the width of the minilist in the Proxies module", "设置代理界面导航栏宽度") }
    orderBy() { return language(this.language, "Order By", "自定义节点排序") }
    orderByOption() { return language(this.language, ["Default", "Latency", "Alphabet"], ["默认", "延迟", "字母"]) }
    latencyTestURL() { return language(this.language, "Latency Test URL", "延迟测试网址") }
    latencyTestURLDescribe() { return language(this.language, "Set the URL used when clicking the Delay Test button in the Proxies module", "设置在代理模块中单击延迟测试按钮时使用的 URL") }
    latencyTestTimeout() { return language(this.language, "Latency Test Timeout", "延迟测试超时") }
    showFilter() { return language(this.language, "Show Filter", "显示筛选过滤器") }
    showFilterDescribe() { return language(this.language, "Set the Proxies module to display the keyword filter icon or not", "设置代理模块是否显示关键字过滤器图标") }
    hideUnselectableGroup() { return language(this.language, "Hide Unselectable Group", "隐藏无法选择的代理组") }
    hideUnselectableGroupDescribe() { return language(this.language, "Set whether to hide unselectable proxy groups in the Proxies", "设置是否隐藏代理模块中不可选择的代理组") }
    forDetails() { return language(this.language, "For details, see", "有关详细信息，请参阅:") }
    docs() { return language(this.language, "docs", "帮助文档") }
    titleBarText() { return language(this.language, "Title Bar Text", "标题栏文本") }
    titleBarTextDescribe() { return language(this.language, "Text to display in title bar", "要在标题栏中显示的文本") }
    titleBarTextDescribeFirst() { return language(this.language, "Set the text in title bar, some placeholders for replacement:", "设置标题栏的文字，一些替换的占位符:") }
    titleBarTextDescribeSecond() { return language(this.language, "Current proxy mode", "当前代理模式") }
    titleBarTextDescribeThird() { return language(this.language, "System Proxy status, On or Off", "系统代理状态，打开或关闭") }
    titleBarTextDescribeFourth() { return language(this.language, "TUN Mode status, On or Off", "TUN 模式状态，开或关") }
    titleBarTextDescribeFifth() { return language(this.language, "Mixin status, On or Off", "Mixin 状态，开或关") }
    breakWhenProfileChange() { return language(this.language, "Break When Profile Change", "配置文件更改时中断连接") }
    breakWhenProfileChangeDescribe() { return language(this.language, "Set whether to close all connections when switching", "设置配置文件改变时是否关闭所有连接") }
    breakWhenModeChange() { return language(this.language, "Break When Mode Change", "模式更改时中断连接") }
    breakWhenModeChangeDescribe() { return language(this.language, "Set whether to close all connections when switching modes", "设置切换模式时是否关闭所有连接") }
    displayChainType() { return language(this.language, "Display Chain Type", "显示链接类型") }
    displayChainTypeDescribe() { return language(this.language, "Set the type of chain displayed in the Connections module", "设置连接模块中显示的链类型") }
    displayChainTypeOption() { return language(this.language, ["Proxy", "Group", "Both"], ["节点名", "分组名", "全部"]) }
    outbound() { return language(this.language, "Outbound", "选择流量出接口") }
    interfaceName() { return language(this.language, "Interface Name", "接口名称") }
    interfaceNameDescribe() { return language(this.language, "Set interface name to overwrite like Mixin, will be removed in the future", "像 Mixin 一样设置接口名覆盖，以后会移除") }
    detected() { return language(this.language, "Detected", "侦测到") }
    childProcesses() { return language(this.language, "Child Processes", "子进程") }
    processes() { return language(this.language, "Processes", "启动其他应用") }
    processesDescribe() { return language(this.language, "Set child processes to be spawned with dashboard", "设置要使用仪表板生成的子进程") }
    consoleOutput() { return language(this.language, "Console Output", "控制台输出") }
    folderPathDescribe() { return language(this.language, "Set the path to the profiles folder, default: Home\n            Directory/profiles", "设置配置文件文件夹的路径，如果在CFW软件根目录下创建名为 data 的文件夹则会开启便携模式，默认路径: Home\n            Directory/profiles") }
    folderPath() { return language(this.language, "Folder Path", "资料夹路径") }
    requestHeaders() { return language(this.language, "Request Headers", "自定义请求头") }
    requestHeadersDescribeFirst() { return language(this.language, "Set the request header content when updating a profile", "更新配置文件时设置请求标头内容") }
    requestHeadersDescribeSecond() { return language(this.language, "the individual profile request header content in the Profiles", "在 Profiles 模块中设置单独的配置文件请求头内容") }
    scriptActionDescribe() { return language(this.language, "Set the code to be called when the Action is executed", "设置执行Action时要调用的代码") }
    selectAfterUpdated() { return language(this.language, "Select After Updated", "更新后选择") }
    selectAfterUpdatedDescribe() { return language(this.language, "Set whether the profile is selected after updating", "设置是否在更新后选择已更新的配置文件") }
    profilesFolderPath() { return language(this.language, "Profiles folder path", "配置文件文件夹路径") }
    healthCheckAll() { return language(this.language, "Health Check All", "检查全部连接") }
    proxyProviders() { return language(this.language, "Proxy Providers", "代理提供者") }
    chooseOutboundInterface() { return language(this.language, "Choose outbound interface", "选择出接口") }
    chooseOutboundInterfaceDescribe() { return language(this.language, "only works when TAP mode enabled", "仅在启用TAP模式时有效") }
    reset() { return language(this.language, "Reset", "重置") }
    onlineDocs() { return language(this.language, "Docs", "在线文档") }
    shortcut() { return language(this.language, "Shortcuts", "快捷键") }
    globalMode() { return language(this.language, "Global Mode", "全局模式") }
    ruleMode() { return language(this.language, "Rule Mode", "规则模式") }
    directMode() { return language(this.language, "Direct Mode", "直连模式") }
    scriptMode() { return language(this.language, "Script Mode", "脚本模式") }
    pressEnterStop() { return language(this.language, "Press Enter to stop", "按 Enter 停止") }
    record() { return language(this.language, "Record", "点击以录制热键") }
    recording() { return language(this.language, "Recording...", "记录中...") }
    developer() { return language(this.language, "Developer", "作者") }
    relevance() { return language(this.language, "Relevance", "关于") }
    credits() { return language(this.language, "Credits", "鸣谢") }
    advertisementOriginal() { return language(this.language, "Original Advertisement", "原版广告") }
    imageIsOnWay() { return language(this.language, "Image is on the way", "图片正在加载") }
    updateIntervalMustBeInteger() { return language(this.language, "Update Interval must be an integer", "更新间隔必须是整数") }
    downloadProfile() { return language(this.language, "Download profile", "下载资料") }
    failedErrorHTTP() { return language(this.language, "failed with error: HTTP Response Status Code", "失败，错误：HTTP 响应状态代码") }
    serviceModeCtrlSysProxy() { return language(this.language, "Service Mode to control system proxy", "用于控制系统代理的服务模式") }
    makeSureYouHave() { return language(this.language, "Make sure you have ", "确定你 ") }
    unknowErr() { return language(this.language, "unknow error", "未知错误") }
    updateFailedNetErr() { return language(this.language, "update failed(Network Error)", "更新失败(网络错误)!") }
    couldNotSwitchProfile() { return language(this.language, "Could not switch to this profile!", "无法切换到此配置文件!") }
    downloadDbErrGeoIP() { return language(this.language, "Download GeoIP database failed with error", "下载 GeoIP 数据库失败并出现错误") }
    inputFieldAlternative() { return language(this.language, "Input fields are alternative", "输入字段是替代的") }
    updateDbGeoIP() { return language(this.language, "Update GeoIP database", "更新 GeoIP 数据库") }
    updatingDbNotAllowedCFW() { return language(this.language, "Updating GeoIP database is not allowed in CFW, please do it manually", "CFW 不允许更新 GeoIP 数据库，请手动进行") }
    imageFailedLoad() { return language(this.language, "The image failed to load, click to redirect to the website.", "图片加载失败，点击重定向至网站") }
    updating() { return language(this.language, "Updating", "更新中") }
    hide() { return language(this.language, "hide", "隐藏") }
    couldNotUpdateProvider() { return language(this.language, "could not update provider", "无法更新提供者") }
    dhcpServer() { return language(this.language, "DHCP Server", "DHCP 服务器") }
    localIpAddress() { return language(this.language, "Local IP Address", "本地 IP 地址") }
    cfg() { return language(this.language, "Configuration", "配置") }
    include() { return language(this.language, "Include", "包括") }
    updated() { return language(this.language, "updated", "已更新") }
    installed() { return language(this.language, "installed", "已安装") }
    now() { return language(this.language, "Now", "现在") }
    askRestartAPP() { return language(this.language, "Do you want to restart the APP?", "是否要重启 APP?") }
    restart() { return language(this.language, "Restart", "重新启动") }
    clashCoreFailedStartup() { return language(this.language, "clash core startup failed!!!", "clash 核心启动失败!!!") }
    restoreProxyGroup() { return language(this.language, "restore proxy group", "恢复代理组") }
    tunModeEnableButIssue() { return language(this.language, "TUN mode enable but no interface-name in this YAML", "启用 TUN 模式但此 YAML 中没有接口名称") }
    couldNotEditProxyGroupType() { return language(this.language, "Could not edit proxy gorup type", "无法编辑代理组类型") }
    contentPAC() { return language(this.language, "PAC Content", "PAC 内容") }
    scriptInterval() { return language(this.language, "Script Interval", "脚本间隔") }
    automaticUpgrade() { return language(this.language, "Automatic Upgrade", "自动升级") }
    automaticUpgradeDescribe() { return language(this.language, "Set whether to update automatically, after turning on the new，\n            version will be updated in the background, the next launch will be\n            the latest version\n          ", "设置是否自动更新，\n            开启新版本后后台更新，\n            下次启动为最新版本\n          ") }
    automaticUpgradeCompleted() { return language(this.language, "Automatic Upgrade completed", "自动升级完成") }
    updateProvider() { return language(this.language, "Update provider", "更新提供者") }
    hideTrayIcon() { return language(this.language, "Hide Tray Icon", "隐藏托盘图标") }
    hideTrayIconDescribe() { return language(this.language, "Set whether to hide the taskbar icon or not", "设置是否隐藏任务栏图标") }
    proxyPolicy() { return language(this.language, "Proxy or Policy", "代理或策略") }
    content() { return language(this.language, "Content", "内容") }
    createNewRule() { return language(this.language, "Create a new rule", "创建新规则") }
    skipCertVerify() { return language(this.language, "Skip Cert Verify", "跳过证书验证") }
    customEditorCommand() { return language(this.language, "Custom Editor Command", "自定义编辑器命令") }
    editMixinContent() { return language(this.language, "Edit Mixin content", "编辑 Mixin 内容") }
    fakeIPCache() { return language(this.language, "Fake IP Cache", "Fake IP 缓存") }
    cache() { return language(this.language, "Cache", "缓存") }
    cannotEditReadOnlyEditor() { return language(this.language, "Cannot edit in read-only editor", "无法在只读编辑器中编辑(请在右边进行编辑)") }
    startWithLinux() { return language(this.language, "Start with Linux", "开机自启动") }
    startWithMacOS() { return language(this.language, "Start with macOS", "开机自启动") }
    geoIPDatabase() { return language(this.language, "GeoIP Database", "GeoIP 数据库更新") }
    preload() { return language(this.language, "Preload", "预载") }
    preloadDescribe() { return language(this.language, "Set the number of log lines to be preloaded in the Logs module,\n            set to 0 to not preload", "在 Logs 模块中设置要预加载的日志行数,\n            设置为 0 不预加载") }
    lines() { return language(this.language, "lines", "线程") }
    experimentalFeatures() { return language(this.language, "Experimental Features", "实验功能") }
    selectInterface() { return language(this.language, "Select a interface", "选择一个接口") }
    hadBeenReleased() { return language(this.language, " had been released", " 已发布") }
    pleaseConfirm() { return language(this.language, "Please confirm", "请确认") }
    cfgWillBeRemoved() { return language(this.language, "config.yaml and country.mmdb will be removed.", "config.yaml 和 country.mmdb 将被删除.") }
    router() { return language(this.language, "Router", "路由器") }
    editInTextMode() { return language(this.language, ["OK", "Edit in Text Mode"], ["好的", "在文本模式下编辑"]) }
    upgradeFailedWithErr() { return language(this.language, "upgrade app failed with error: ", "升级应用程序失败并出现错误: ") }
    dontSave() { return language(this.language, "Don't Save", "不保存") }
    failRestoreLastProfileErr() { return language(this.language, "fail to restore last profile with error: ", "无法恢复最后一个配置文件并出现错误: ") }
    askSetConfig() { return language(this.language, "Do you want to set a new uuidv4 secret in Home Directory/config.yaml and restart the APP?", "是否要在 Home Directory/config.yaml 中设置新的 uuidv4 secret 并重启 APP?") }
    recommendGenerateSecret() { return language(this.language, "secret is currently empty, we strongly recommend to generate one", "secret 当前为空，我们强烈建议生成一个") }
    generate() { return language(this.language, "Generate", "生成更新") }
    overallColorSettings() { return language(this.language, "Overall foreground color. This color is only used if not overridden by a component", "整体前景色。这个颜色只在没有被组件覆盖的情况下使用") }
    overallColorSettingsErr() { return language(this.language, "Overall foreground color for error messages. This color is only used if not overridden by a component", "错误信息的整体前景色。这个颜色只在没有被组件覆盖的情况下使用") }
    colorNeedValue() { return language(this.language, "Color needs a value", "颜色需要一个值") }
    invalidColorArgument() { return language(this.language, "Invalid color ctor argument", "无效颜色参数") }
    proxyName() { return language(this.language, "Proxy Name", "代理名称") }
    cannotEditProxyType() { return language(this.language, "Could not edit proxy type", "无法编辑代理类型") }
    trayProxyGroupsStyle() { return language(this.language, "Tray Proxy Groups Style", "托盘代理组样式") }
    trayProxyGroupsStyleDescribeFirst() { return language(this.language, "Set the proxy group style in the taskbar menu", "在任务栏菜单中设置代理组样式") }
    trayProxyGroupsStyleDescribeSecond() { return language(this.language, "Flat all proxy groups", "扁平化所有代理组") }
    trayProxyGroupsStyleDescribeThird() { return language(this.language, "Show proxy groups in submenu", "在折叠中显示代理组") }
    trayProxyGroupsStyleDescribeFourth() { return language(this.language, "Hide proxy groups", "隐藏代理组") }
    submenu() { return language(this.language, "Submenu", "折叠") }
    expand() { return language(this.language, "Expand", "展开") }
    hidden() { return language(this.language, "Hidden", "隐蔽") }
    showProcessIfPresent() { return language(this.language, "Show Process If Present", "显示进程（如果存在）") }
    showProcessIfPresentDescribe() { return language(this.language, "Set whether to show Process Name (if present) in Connections", "设置是否显示连接中的进程名称（如果存在）") }
    showTrayProxyDelayIndicator() { return language(this.language, "Show Tray Proxy Delay Indicator", "在托盘代理中显示节点可用性") }
    showTrayProxyDelayIndicatorDescribe() { return language(this.language, "Set whether the delay indicator is displayed in the proxy of the\n            taskbar menu", "设置是否在任务栏菜单的代理中\n            显示延迟指示器") }
    reloadAPP() { return language(this.language, "Reload APP", "重新加载 APP") }
    failTo() { return language(this.language, "Fail to ", "未能") }
    delayType() { return language(this.language, "Delay Type", "延迟类型") }
    delayTypeDescribeStart() { return language(this.language, "Delay of a latency test", "延迟测试的延迟") }
    delayTypeDescribeEnd() { return language(this.language, "Average delay of two latency tests", "两次延迟测试的平均延迟") }
    default() { return language(this.language, "Default", "默认") }
    meanDelay() { return language(this.language, "Mean Delay", "平均延迟") }
    fetch() { return language(this.language, "Fetch", "获取") }
    currentSSID() { return language(this.language, "Current SSID", "当前的 SSID") }
    currentSSIDDescribe() { return language(this.language, "Copy the SSID to the clipboard", "将 SSID 复制到剪贴板") }
    getCurrentSSID() { return language(this.language, "Get Current SSID", "获取当前的 SSID") }
    getCurrentSSIDDescribe() { return language(this.language, "Multiple SSIDs are joined by", "多个 SSID 的连接方式为") }
    strategy() { return language(this.language, "Strategy", "策略") }
    failedWithError() { return language(this.language, "failed with error: ", "失败，错误: ") }
    preserveCase() { return language(this.language, "Preserve Case", "保留大写") }
    previousMatch() { return language(this.language, "Previous Match", "上一个匹配") }
    nextMatch() { return language(this.language, "Next Match", "下一个匹配") }
    find() { return language(this.language, "Find", "查找") }
    findinSelection() { return language(this.language, "Find in Selection", "在选择中查找") }
    toggleReplace() { return language(this.language, "Toggle Replace", "切换到替换模式") }
    close() { return language(this.language, "Close", "关闭") }
    replace() { return language(this.language, "Replace", "替换") }
    replaceAll() { return language(this.language, "Replace All", "替换全部") }
    resultHighlighted() { return language(this.language, "Only the first {0} results are highlighted, but all find operations work on the entire text.", "仅突出显示前 {0} 个结果，但所有查找操作均作用于整个文本。") }
    numberOf() { return language(this.language, "{0} of {1}", "{0} / {1}") }
    noResults() { return language(this.language, "No results", "无结果") }
    useProxyServerWindows() { return language(this.language, "Use a proxy server in Windows", "在 Windows 中使用代理服务器") }
    enterProxyServerSettingsMac() { return language(this.language, "Enter proxy server settings on Mac", "在 Mac 上输入代理服务器设置") }
    followLink() { return language(this.language, "Follow link", "进入链接") }
    proxyName() { return language(this.language, " - Proxy Name", "") }
    proxy() { return language(this.language, "Proxy", "节点名") }
    groupName() { return language(this.language, " - Group name", "") }
    group() { return language(this.language, "Group", "分组名") }
    bothName() { return language(this.language, " - Proxy name and group name", " - 节点名和分组名") }
    both() { return language(this.language, "Both", "全部") }
    color() { return language(this.language, "colors:", "颜色:") }
    available() { return language(this.language, "available", "可用的") }
    unknown() { return language(this.language, "unknown", "未知") }
    alive() { return language(this.language, "Alive", "活动") }
    useModeIcons() { return language(this.language, "Use Mode Icons", "使用连接模式图标") }
    useModeIconsDescribe() { return language(this.language, "Use first letter of current mode as tray icon", "使用当前选择的模式作为托盘图标") }
    showActualFile() { return language(this.language, "Show actual file", "显示实际文件") }
    fontSize() { return language(this.language, "Font Size", "字体大小") }
    copyURLAndMD5() { return language(this.language, "Copy URL MD5", "复制 URL MD5") }
    executeCommand() { return language(this.language, "Execute command", "执行命令") }
    openWebPage() { return language(this.language, "Open web page", "打开配置网站") }
    cut() { return language(this.language, "Cut", "剪切") }
    paste() { return language(this.language, "Paste", "粘贴") }
    status() { return language(this.language, "Status", "状态") }
    flags() { return language(this.language, "Flags", "标签") }
    disclaimerStatement() { return language(this.language, "Disclaimer Statement", "免责声明") }
    disclaimerStatementDescribe() { 
        return language(this.language, 
            "1. This software is only intended for the purpose of learning and researching network technology. Users must comply with the laws and regulations in their respective regions and must not use it for illegal purposes. The software will not be held responsible for any actions of the user. \n\n2. Users must strictly abide by the laws, regulations, and policies of their own countries/regions when using this software. Any consequences or liabilities resulting from violations of relevant laws, regulations, and policies shall be borne by the user.\n\n3. The software is not responsible for the transmission of content. Therefore, if any problems or consequences arise from the use of this software, the user shall bear all responsibility.\n\n4. If the software violates any laws and regulations of the user's country/region, the user must immediately stop using it and bear the corresponding legal responsibility.\n\n5. While using this software, the user acknowledges and agrees that the software cannot guarantee network stability, accuracy, timeliness, and security. The software will not be held responsible for any connection problems or inability to connect caused by network congestion, firewall restrictions, DNS pollution, operator interference, and other reasons.\n\n6. The software does not provide technical support and is not responsible for any direct or indirect losses caused by the user's use of this software, including but not limited to property damage, data loss, and other forms of loss.\n\n7. The software has made every effort to ensure the stability and safety of the software, but will not be held responsible for any direct or indirect losses suffered by the user due to the use of this software.\n\n8. The software reserves the right to change the terms and conditions at any time. Once the terms and conditions change, an announcement will be posted on the software page. Users need to pay attention and abide by the latest version of the terms and conditions.\n\n9. The software may display advertisements from third-party entities. The software does not endorse, guarantee, or assume responsibility for the accuracy, relevancy, or quality of the information presented in these advertisements. Users acknowledge and agree that the software is not liable for any loss or damage arising from the display of advertisements or any transactions or interactions users may have with the advertisers. The user is solely responsible for any interactions with advertisers and is advised to exercise caution and conduct due diligence before engaging in any transactions or interactions with advertisers.\n    ", 
            "1. 本软件仅供学习和研究网络技术之用，用户必须遵守所在地区的法律法规，不得用于非法用途，本软件不对任何人的行为负责。 \n\n2. 用户在使用本软件时必须严格遵守所在国家/地区的法律、法规和政策。 因违反有关法律、法规和政策而导致的任何后果或责任由用户自行承担。\n\n3. 本软件不负责传输内容。 因此，如因使用本软件而产生任何问题或后果，由用户自行承担全部责任。\n\n4. 如本软件违反用户所在国家/地区的任何法律法规，用户必须立即停止使用并承担相应的法律责任。\n\n5. 用户在使用本软件时，即承认并同意本软件不能保证网络的稳定性、准确性、及时性和安全性。 因网络拥塞、防火墙限制、DNS污染、运营商干扰等原因造成的连接问题或无法连接，本软件不承担任何责任。\n\n6. 本软件不提供技术支持，对因用户使用本软件而造成的任何直接或间接损失，包括但不限于财产损失、数据丢失及其他形式的损失不承担任何责任。\n\n7. 本软件已尽力确保软件的稳定性和安全性，但对用户因使用本软件而遭受的任何直接或间接损失不承担任何责任。\n\n8. 软件保留随时更改条款和条件的权利。 一旦条款和条件发生变化，将在软件页面上发布公告。 用户需关注并遵守最新版本的条款和条件。\n\n9. 本软件可能会显示来自第三方实体的广告。本软件不认可、保证或承担这些广告中所呈现信息的准确性、相关性或质量的责任。用户确认并同意，本软件对因显示广告或用户与广告商进行的任何交易或互动而产生的任何损失或损害概不负责。用户应对与广告商的任何互动承担全部责任，并建议用户在与广告商进行任何交易或互动之前谨慎行事并进行尽职调查。\n    "
        )
    }
    matchCase() { return language(this.language, "Match Case", "匹配大小写") }
    matchWholeWord() { return language(this.language, "Match Whole Word", "匹配全词") }
    useRegularExpression() { return language(this.language, "Use Regular Expression", "使用正则表达式") }
    failWithError() { return language(this.language, "Fail, error: ", "失败, 错误: ") }
    resetDNSSettings() { return language(this.language, "Reset DNS Settings", "重置 DNS 设置") }
    enable() { return language(this.language, "Enable", "启用") }
    enabled() { return language(this.language, "Enabled", "已启用") }
    customServers() { return language(this.language, "Custom Servers", "自定义服务器") }
    forHistory() { return language(this.language, "for history", "查看历史记录") }
    textWillDescribe() { return language(this.language, "Text will be prefixed with ⇅ plus a single space, then used as a hint where input field keeps history", "文本将以 ⇅ 加上一个空格作为前缀，然后用作输入字段保留历史记录的提示") }
    timeoutInTimeDiff() { return language(this.language, "Timeout in milliseconds after which diff computation is cancelled. Use 0 for no timeout.", "以毫秒为单位的超时，之后差异计算被取消。 使用 0 表示没有超时") }
    fileSizeInMBForDiff() { return language(this.language, "Maximum file size in MB for which to compute diffs. Use 0 for no limit.", "计算差异的最大文件大小（以 MB 为单位）。 使用 0 表示没有限制") }
    ssidStrategy() { return language(this.language, "SSID Strategy", "SSID策略") }
    strategyDescribe() { return language(this.language, "\n              Set the strategy for SSID matching, the first matched strategy\n              will be used,\n              ", "\n              设置SSID匹配策略，第一个匹配的策略\n              将被使用,\n              ") }
    useCFWEditor() { return language(this.language, "Use CFW Editor", "使用 CFW 编辑器") }
    other() { return language(this.language, "Other", "其它") }
    show() { return language(this.language, "show", "显示") }
    disableLoadingAdsLink() { return language(this.language, "Disable Loading Ads Link", "禁用加载广告链接") }
}
const LANGUAGE = "language";
var modifyState = {
    languageInProfile: -1,
    language: -1,
    isTun: false,
    isMixin: false,
    adImages: ""
};
(() => {
    var e, t, i = {
            67228: e => {
                e.exports = function(e, t) {
                    (null == t || t > e.length) && (t = e.length);
                    for (var i = 0, n = new Array(t); i < t; i++) n[i] = e[i];
                    return n
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            22858: e => {
                e.exports = function(e) {
                    if (Array.isArray(e)) return e
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            23646: (e, t, i) => {
                var n = i(67228);
                e.exports = function(e) {
                    if (Array.isArray(e)) return n(e)
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            48926: e => {
                function t(e, t, i, n, o, s, r) {
                    try {
                        var a = e[s](r),
                            l = a.value
                    } catch (e) {
                        return void i(e)
                    }
                    a.done ? t(l) : Promise.resolve(l).then(n, o)
                }
                e.exports = function(e) {
                    return function() {
                        var i = this,
                            n = arguments;
                        return new Promise((function(o, s) {
                            var r = e.apply(i, n);

                            function a(e) {
                                t(r, o, s, a, l, "next", e)
                            }

                            function l(e) {
                                t(r, o, s, a, l, "throw", e)
                            }
                            a(void 0)
                        }))
                    }
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            59713: e => {
                e.exports = function(e, t, i) {
                    return t in e ? Object.defineProperty(e, t, {
                        value: i,
                        enumerable: !0,
                        configurable: !0,
                        writable: !0
                    }) : e[t] = i, e
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            46860: e => {
                e.exports = function(e) {
                    if ("undefined" != typeof Symbol && null != e[Symbol.iterator] || null != e["@@iterator"]) return Array.from(e)
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            13884: e => {
                e.exports = function(e, t) {
                    var i = e && ("undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"]);
                    if (null != i) {
                        var n, o, s = [],
                            r = !0,
                            a = !1;
                        try {
                            for (i = i.call(e); !(r = (n = i.next()).done) && (s.push(n.value), !t || s.length !== t); r = !0);
                        } catch (e) {
                            a = !0, o = e
                        } finally {
                            try {
                                r || null == i.return || i.return()
                            } finally {
                                if (a) throw o
                            }
                        }
                        return s
                    }
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            80521: e => {
                e.exports = function() {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            98206: e => {
                e.exports = function() {
                    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            6479: (e, t, i) => {
                var n = i(37316);
                e.exports = function(e, t) {
                    if (null == e) return {};
                    var i, o, s = n(e, t);
                    if (Object.getOwnPropertySymbols) {
                        var r = Object.getOwnPropertySymbols(e);
                        for (o = 0; o < r.length; o++) i = r[o], t.indexOf(i) >= 0 || Object.prototype.propertyIsEnumerable.call(e, i) && (s[i] = e[i])
                    }
                    return s
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            37316: e => {
                e.exports = function(e, t) {
                    if (null == e) return {};
                    var i, n, o = {},
                        s = Object.keys(e);
                    for (n = 0; n < s.length; n++) i = s[n], t.indexOf(i) >= 0 || (o[i] = e[i]);
                    return o
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            63038: (e, t, i) => {
                var n = i(22858),
                    o = i(13884),
                    s = i(60379),
                    r = i(80521);
                e.exports = function(e, t) {
                    return n(e) || o(e, t) || s(e, t) || r()
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            319: (e, t, i) => {
                var n = i(23646),
                    o = i(46860),
                    s = i(60379),
                    r = i(98206);
                e.exports = function(e) {
                    return n(e) || o(e) || s(e) || r()
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            50008: e => {
                function t(i) {
                    return "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? (e.exports = t = function(e) {
                        return typeof e
                    }, e.exports.default = e.exports, e.exports.__esModule = !0) : (e.exports = t = function(e) {
                        return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
                    }, e.exports.default = e.exports, e.exports.__esModule = !0), t(i)
                }
                e.exports = t, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            60379: (e, t, i) => {
                var n = i(67228);
                e.exports = function(e, t) {
                    if (e) {
                        if ("string" == typeof e) return n(e, t);
                        var i = Object.prototype.toString.call(e).slice(8, -1);
                        return "Object" === i && e.constructor && (i = e.constructor.name), "Map" === i || "Set" === i ? Array.from(e) : "Arguments" === i || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i) ? n(e, t) : void 0
                    }
                }, e.exports.default = e.exports, e.exports.__esModule = !0
            },
            87757: (e, t, i) => {
                e.exports = i(35666)
            },
            24883: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => n
                });
                const n = {
                    put: function(e, t) {
                        window.localStorage.setItem(e, JSON.stringify(t))
                    },
                    get: function(e) {
                        var t = window.localStorage.getItem(e);
                        if ("" !== t) try {
                            return JSON.parse(t)
                        } catch (t) {
                            console.error("get [".concat(e, "] from cache failed with error:"), t)
                        }
                    }
                }
            },
            51792: (e, t, i) => {
                "use strict";
                i.d(t, {
                    F: () => C,
                    b: () => x
                });
                var n, o, s = i(319),
                    r = i.n(s),
                    a = i(63038),
                    l = i.n(a),
                    c = i(48926),
                    d = i.n(c),
                    h = i(87757),
                    u = i.n(h),
                    g = i(58583),
                    p = i(54387),
                    f = i.n(p),
                    m = i(8369),
                    v = i(57147),
                    _ = i(71017),
                    b = i(59273),
                    w = (i(72298), i(24793)),
                    y = {},
                    C = function(e, t) {
                        y[e] = t
                    },
                    x = function(e) {
                        return y[e] || 0
                    },
                    S = function(e) {
                        return e.map((function(e) {
                            return {
                                label: e,
                                kind: g.languages.CompletionItemKind.Keyword,
                                insertText: e,
                                insertTextRules: g.languages.CompletionItemInsertTextRule.InsertAsSnippet
                            }
                        }))
                    },
                    k = (n = d()(u().mark((function e(t, i, n) {
                        var o, s, a, c, h, p, m, v, _, b;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.prev = 1, o = t.split(/\r?\n/).reduce((function(e, t) {
                                        var i = t.match(/name:\s"?(.+?)"?$/) || [],
                                            n = l()(i, 2),
                                            o = (n[0], n[1]);
                                        return o && e.push(o), e
                                    }), ["DIRECT", "REJECT", "GLOBAL"]), s = function() {
                                        var e = d()(u().mark((function e(t) {
                                            return u().wrap((function(e) {
                                                for (;;) switch (e.prev = e.next) {
                                                    case 0:
                                                        return e.next = 2, f().get("https://raw.githubusercontent.com/Fndroid/clash-vscode/master/snippets/".concat(t, ".code-snippets"), {
                                                            validateStatus: function(e) {
                                                                return !0
                                                            }
                                                        });
                                                    case 2:
                                                        return e.abrupt("return", e.sent);
                                                    case 3:
                                                    case "end":
                                                        return e.stop()
                                                }
                                            }), e)
                                        })));
                                        return function(t) {
                                            return e.apply(this, arguments)
                                        }
                                    }(), a = {}, e.next = 7, s(n);
                                case 7:
                                    if (c = e.sent, h = c.status, p = c.data, 200 === h) {
                                        e.next = 19;
                                        break
                                    }
                                    return e.next = 13, s("top");
                                case 13:
                                    m = e.sent, v = m.status, _ = m.data, 200 === v && (a = _), e.next = 20;
                                    break;
                                case 19:
                                    a = p;
                                case 20:
                                    b = Object.entries(a).map((function(e) {
                                        var t = l()(e, 2),
                                            s = (t[0], t[1]),
                                            r = s.prefix,
                                            a = s.body,
                                            c = "string" == typeof a ? a : null == a ? void 0 : a.join("\n");
                                        return {
                                            label: r,
                                            kind: g.languages.CompletionItemKind.Snippet,
                                            insertText: "rules" === n && o.length > 0 ? c.replace(/\:policy/g, "|".concat(o.join(",").replace(/\|/g, "\\\\"), "|")) : c,
                                            insertTextRules: g.languages.CompletionItemInsertTextRule.InsertAsSnippet,
                                            range: i
                                        }
                                    })), e.t0 = n, e.next = "rules" === e.t0 ? 24 : "proxy-groups" === e.t0 ? 25 : 26;
                                    break;
                                case 24:
                                case 25:
                                    return e.abrupt("return", [].concat(r()(b), r()(S(o))));
                                case 26:
                                    return e.abrupt("return", b);
                                case 27:
                                    return e.abrupt("return", [].concat(r()(b), r()(["proxy-groups", "rules"].includes(n) ? groupNameItems : [])));
                                case 30:
                                    return e.prev = 30, e.t1 = e.catch(1), e.abrupt("return", []);
                                case 33:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [1, 30]
                        ])
                    }))), function(e, t, i) {
                        return n.apply(this, arguments)
                    });
                g.languages.registerCompletionItemProvider("yaml", {
                    provideCompletionItems: (o = d()(u().mark((function e(t, i) {
                        var n, o, s, a, l;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (n = t.getValueInRange({
                                            startLineNumber: 1,
                                            startColumn: 1,
                                            endLineNumber: i.lineNumber,
                                            endColumn: i.column
                                        }), o = t.getWordUntilPosition(i), s = {
                                            startLineNumber: i.lineNumber,
                                            endLineNumber: i.lineNumber,
                                            startColumn: o.startColumn,
                                            endColumn: o.endColumn
                                        }, 1 !== o.startColumn) {
                                        e.next = 8;
                                        break
                                    }
                                    return e.next = 6, k(t.getValue(), s, "top");
                                case 6:
                                    return e.t0 = e.sent, e.abrupt("return", {
                                        suggestions: e.t0
                                    });
                                case 8:
                                    if (!((a = r()("\n".concat(n).matchAll(/\n(\S+?)\s*:/g))).length > 0)) {
                                        e.next = 15;
                                        break
                                    }
                                    return l = a[a.length - 1][1], e.next = 13, k(t.getValue(), s, l);
                                case 13:
                                    return e.t1 = e.sent, e.abrupt("return", {
                                        suggestions: e.t1
                                    });
                                case 15:
                                    return e.next = 17, k(t.getValue(), s, "top");
                                case 17:
                                    return e.t2 = e.sent, e.abrupt("return", {
                                        suggestions: e.t2
                                    });
                                case 19:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e, t) {
                        return o.apply(this, arguments)
                    })
                });
                var L, N, D, I = function(e, t) {
                    var i = b.Z.state.app.clashPath;
                    return (0, _.join)(i, "providers", e, t + ".yaml")
                };
                const Lg = new Language(modifyState.language);
                g.languages.registerCodeLensProvider("yaml", {
                    provideCodeLenses: (L = d()(u().mark((function e(t) {
                        var i, n, o, s, r, a, l, c, d;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    i = [], n = 1;
                                case 2:
                                    if (!(n <= t.getLineCount())) {
                                        e.next = 17;
                                        break
                                    }
                                    if (o = t.getLineContent(n), s = {
                                            startLineNumber: n,
                                            endLineNumber: n,
                                            startColumn: 1,
                                            endColumn: 1
                                        }, !/url:\s(.+?)$/.test(o)) {
                                        e.next = 14;
                                        break
                                    }
                                    return r = w.trim(RegExp.$1, "\" '"), e.next = 9, (0, m.Ll)(r);
                                case 9:
                                    a = e.sent, l = I("proxy", a), c = I("rule", a), (d = (0, v.existsSync)(l) ? l : (0, v.existsSync)(c) ? c : "") ? i.push({
                                        range: s,
                                        id: n,
                                        command: {
                                            id: "openFile",
                                            title: Lg.showActualFile(),
                                            arguments: [d]
                                        }
                                    }) : i.push({
                                        range: s,
                                        id: n,
                                        command: {
                                            id: "copyURLMD5",
                                            title: Lg.copyURLAndMD5(),
                                            arguments: [a]
                                        }
                                    });
                                case 14:
                                    n++, e.next = 2;
                                    break;
                                case 17:
                                    return e.abrupt("return", {
                                        lenses: i,
                                        dispose: function() {}
                                    });
                                case 18:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e) {
                        return L.apply(this, arguments)
                    })
                }), g.editor.registerCommand("openFile", (N = d()(u().mark((function e(t, n) {
                    return u().wrap((function(e) {
                        for (;;) switch (e.prev = e.next) {
                            case 0:
                                i(72298).shell.showItemInFolder(n);
                            case 1:
                            case "end":
                                return e.stop()
                        }
                    }), e)
                }))), function(e, t) {
                    return N.apply(this, arguments)
                })), g.editor.registerCommand("copyURLMD5", (D = d()(u().mark((function e(t, n) {
                    return u().wrap((function(e) {
                        for (;;) switch (e.prev = e.next) {
                            case 0:
                                i(72298).clipboard.writeText("".concat(n, ".yaml")), (0, m.vC)({
                                    title: "MD5 Copied",
                                    message: "MD5: ".concat(n)
                                });
                            case 2:
                            case "end":
                                return e.stop()
                        }
                    }), e)
                }))), function(e, t) {
                    return D.apply(this, arguments)
                }))
            },
            27458: (e, t, i) => {
                "use strict";
                i.d(t, {
                    A7: () => w,
                    Kz: () => b,
                    Qz: () => _
                });
                var n, o, s, r, a = i(48926),
                    l = i.n(a),
                    c = i(87757),
                    d = i.n(c),
                    h = i(72378),
                    u = i(32081),
                    g = (i(72298), i(57147)),
                    p = (i(71017), i(83566)),
                    f = i(59273),
                    m = (n = l()(d().mark((function e() {
                        var t, i, n = arguments;
                        return d().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return t = n.length > 0 && void 0 !== n[0] && n[0], i = n.length > 1 ? n[1] : void 0, e.abrupt("return", new Promise((function(e, n) {
                                        var o = i.replace(/"/g, '\\"').replace(/\n/g, " "),
                                            s = 'powershell.exe -ExecutionPolicy Bypass -Command "'.concat(o, '"'),
                                            r = function(t, i, o) {
                                                t && n(t), e({
                                                    stderr: o.toString(),
                                                    stdout: i.toString()
                                                })
                                            };
                                        t ? (0, h.exec)(s, {}, r) : (0, u.exec)(s, r)
                                    })));
                                case 3:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return n.apply(this, arguments)
                    }),
                    v = "Work with Clash for Windows.",
                    _ = (o = l()(d().mark((function e() {
                        var t, i, n, o, s, r;
                        return d().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if ((0, p.Kr)()) {
                                        e.next = 2;
                                        break
                                    }
                                    return e.abrupt("return");
                                case 2:
                                    return t = 'Get-NetFirewallRule -Description "'.concat(v, '" | ? {$_.Enabled -eq "True"} | Get-NetFirewallApplicationFilter'), e.prev = 3, e.next = 6, m(!1, t);
                                case 6:
                                    return i = e.sent, n = i.stderr, o = i.stdout, s = f.Z.getters.clashBinaryPath, r = (0, g.realpathSync)(s), e.abrupt("return", "" === n && (o.includes(s) || o.includes(r)));
                                case 14:
                                    e.prev = 14, e.t0 = e.catch(3), console.error("get firewall rule status failed with error:", e.t0);
                                case 17:
                                    return e.abrupt("return", !1);
                                case 18:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [3, 14]
                        ])
                    }))), function() {
                        return o.apply(this, arguments)
                    }),
                    b = (s = l()(d().mark((function e() {
                        var t;
                        return d().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if ((0, p.Kr)()) {
                                        e.next = 2;
                                        break
                                    }
                                    return e.abrupt("return");
                                case 2:
                                    return t = '\nRemove-NetFirewallRule -Description "'.concat(v, '" -ErrorAction SilentlyContinue \n; \'TCP\', \'UDP\' | ForEach-Object {\n    New-NetFirewallRule\n        -DisplayName "Clash Core"\n        -Profile "Private, Public"\n        -Description "').concat(v, '"\n        -Direction Inbound\n        -Protocol $_\n        -Action Allow\n        -Program "').concat((0, g.realpathSync)(f.Z.getters.clashBinaryPath), '"\n        | Out-Null\n}'), e.prev = 3, e.next = 6, m(!0, t);
                                case 6:
                                    e.next = 11;
                                    break;
                                case 8:
                                    e.prev = 8, e.t0 = e.catch(3), console.error("add firewall rule failed with error:", e.t0);
                                case 11:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [3, 8]
                        ])
                    }))), function() {
                        return s.apply(this, arguments)
                    }),
                    w = (r = l()(d().mark((function e() {
                        var t;
                        return d().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if ((0, p.Kr)()) {
                                        e.next = 2;
                                        break
                                    }
                                    return e.abrupt("return");
                                case 2:
                                    return t = 'Remove-NetFirewallRule -Description "'.concat(v, '" -ErrorAction SilentlyContinue'), e.prev = 3, e.next = 6, m(!0, t);
                                case 6:
                                    e.next = 11;
                                    break;
                                case 8:
                                    e.prev = 8, e.t0 = e.catch(3), console.error("remove firewall rule failed with error:", e.t0);
                                case 11:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [3, 8]
                        ])
                    }))), function() {
                        return r.apply(this, arguments)
                    })
            },
            8369: (e, t, i) => {
                "use strict";
                i.d(t, {
                    uR: () => P,
                    uQ: () => U,
                    wi: () => q,
                    Ll: () => O,
                    EP: () => W,
                    fl: () => V,
                    Mf: () => K,
                    Sr: () => $,
                    e8: () => Z,
                    XW: () => z,
                    vC: () => B,
                    c0: () => F,
                    nM: () => H,
                    F0: () => R,
                    Dc: () => A
                });
                var n = i(50008),
                    o = i.n(n),
                    s = i(319),
                    r = i.n(s),
                    a = i(59713),
                    l = i.n(a),
                    c = i(48926),
                    d = i.n(c),
                    h = i(87757),
                    u = i.n(h);
                const g = require("crypto");
                var p = i(57147),
                    f = i(71017);
                require("http");
                var m = i(11442),
                    v = i.n(m),
                    _ = i(59273),
                    b = i(72298),
                    w = (i(10605), i(24883)),
                    y = i(81518),
                    C = i(83566);
                const x = require("bignumber.js");
                var S = i.n(x);

                function k(e, t) {
                    var i = Object.keys(e);
                    if (Object.getOwnPropertySymbols) {
                        var n = Object.getOwnPropertySymbols(e);
                        t && (n = n.filter((function(t) {
                            return Object.getOwnPropertyDescriptor(e, t).enumerable
                        }))), i.push.apply(i, n)
                    }
                    return i
                }

                function L(e) {
                    for (var t = 1; t < arguments.length; t++) {
                        var i = null != arguments[t] ? arguments[t] : {};
                        t % 2 ? k(Object(i), !0).forEach((function(t) {
                            l()(e, t, i[t])
                        })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(i)) : k(Object(i)).forEach((function(t) {
                            Object.defineProperty(e, t, Object.getOwnPropertyDescriptor(i, t))
                        }))
                    }
                    return e
                }
                var N, D, I, E, T, M, A = function(e) {
                        return new Promise((function(t) {
                            return setTimeout(t, e)
                        }))
                    },
                    O = function(e) {
                        return (0, g.createHash)("md5").update(e).digest("hex")
                    },
                    P = function e(t) {
                        p.existsSync(t) && (p.readdirSync(t).forEach((function(i, n) {
                            var o = f.join(t, i);
                            p.lstatSync(o).isDirectory() ? e(o) : p.unlinkSync(o)
                        })), p.rmdirSync(t))
                    },
                    R = (N = d()(u().mark((function e(t, i, n) {
                        var o, s;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    o = p.readFileSync(t).toString(), (s = v().parseDocument(o)).set(i, n), p.writeFileSync(t, s.toString());
                                case 4:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e, t, i) {
                        return N.apply(this, arguments)
                    }),
                    F = function(e) {
                        var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : "",
                            i = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : null,
                            n = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : function() {},
                            o = _.Z.state.app.settings.showNotifications;
                        void 0 !== o && o && (new Notification(e, L({
                            body: t,
                            silent: !0
                        }, i)).onclick = function() {
                            !0 !== (null == i ? void 0 : i.hideWindowOnClick) && b.ipcRenderer.invoke("window-control", "show"), n()
                        })
                    },
                    B = (D = d()(u().mark((function e(t) {
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2, b.ipcRenderer.invoke("dialog", "showMessageBox", L({
                                        title: "Clash for Windows"
                                    }, t));
                                case 2:
                                    return e.abrupt("return", e.sent);
                                case 3:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e) {
                        return D.apply(this, arguments)
                    }),
                    V = (I = d()(u().mark((function e(t) {
                        const Lg = new Language(modifyState.language);
                        return u().wrap((function (e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2, B({
                                        type: "question",
                                        buttons: [Lg.no(), Lg.yes()],
                                        message: Lg.askOpenURL(),
                                        detail: t
                                    });
                                case 2:
                                    1 === e.sent.response && b.shell.openExternal(t);
                                case 5:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e) {
                        return I.apply(this, arguments)
                    }),
                    W = function(e) {
                        return JSON.parse(JSON.stringify(e))
                    },
                    H = function(e) {
                        for (var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 2, i = !(arguments.length > 2 && void 0 !== arguments[2]) || arguments[2], n = ["B", "KB", "MB", "GB", "TB", "PB", "EB"], o = 0; S()(e).dividedBy(1024).isGreaterThan(1) && o < n.length;) e = S()(e).dividedBy(1024), o++;
                        return "".concat(e.toFixed(t)).concat(i ? " " : "").concat(n[o])
                    },
                    z = (E = d()(u().mark((function e(t) {
                        var i, n, o, s, a, l, c;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    i = t.method, n = t.target, o = t.checkTimes, s = void 0 === o ? 10 : o, a = t.ags, l = void 0 === a ? [] : a, c = 0;
                                case 2:
                                    return e.next = 5, i.apply(void 0, r()(l));
                                case 5:
                                    if (e.t0 = e.sent, e.t1 = n, e.t0 !== e.t1) {
                                        e.next = 9;
                                        break
                                    }
                                    return e.abrupt("return");
                                case 9:
                                    return e.next = 11, A(1e3);
                                case 11:
                                    if (!((c += 1) >= s)) {
                                        e.next = 14;
                                        break
                                    }
                                    return e.abrupt("return");
                                case 14:
                                    e.next = 2;
                                    break;
                                case 16:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e, t) {
                        if (e.length <= t) return e;
                        var i = parseInt(t / 2),
                            n = t - i;
                        return e.slice(0, i) + "..." + e.slice(-n)
                    }),
                    j = null,
                    U = (T = d()(u().mark((function e() {
                        var t;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2, b.ipcRenderer.invoke("app", "getVersion");
                                case 2:
                                    return t = e.sent, null === j && (j = w.Z.get(y.Z.LAST_VERSION_CODE) || "", w.Z.put(y.Z.LAST_VERSION_CODE, t)), e.abrupt("return", j !== t);
                                case 5:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return T.apply(this, arguments)
                    }),
                    $ = function(e) {
                        var t = e || {},
                            i = t.ipv6,
                            n = void 0 !== i && i,
                            o = t.nameServers,
                            s = void 0 === o ? ["8.8.8.8", "1.1.1.1", "94.140.14.14"] : o,
                            a = t.fallbackServers,
                            l = void 0 === a ? [] : a,
                            c = t.defaultNameservers,
                            d = void 0 === c ? [] : c,
                            h = t.fakeIPFilters,
                            u = t.nameserverPolicy,
                            g = void 0 === u ? {} : u,
                            p = t.stackType,
                            f = void 0 === p ? 0 : p,
                            m = t.interfaceName,
                            v = void 0 === m ? "" : m,
                            _ = t.isAutoDetectInterface,
                            b = void 0 === _ || _,
                            w = t.dnsHijacks,
                            y = void 0 === w ? [] : w,
                            x = t.isAutoRedir,
                            S = t.isAutoRedirAutoRoute,
                            k = {
                                dns: {
                                    enable: !0,
                                    ipv6: n,
                                    "enhanced-mode": "fake-ip",
                                    "default-nameserver": d,
                                    nameserver: s,
                                    fallback: l,
                                    "nameserver-policy": g
                                },
                                tun: {
                                    enable: !0,
                                    stack: ["gvisor", "system"][f],
                                    "auto-route": !0
                                }
                            };
                        return k.dns["fake-ip-filter"] = void 0 === h ? ["+.stun.*.*", "+.stun.*.*.*", "+.stun.*.*.*.*", "+.stun.*.*.*.*.*", "*.n.n.srv.nintendo.net", "+.stun.playstation.net", "xbox.*.*.microsoft.com", "*.*.xboxlive.com"].concat(r()((0, C.Kr)() ? ["*.msftncsi.com", "*.msftconnecttest.com", "WORKGROUP"] : (0, C.V5)() ? ["apps.apple.com"] : [])) : h, b ? k.tun["auto-detect-interface"] = !0 : k["interface-name"] = v, k.tun["dns-hijack"] = y, (0, C.IJ)() && (k["auto-redir"] = {
                            enable: x,
                            "auto-route": S
                        }), 0 === d.length && delete k.dns["default-nameserver"], k
                    },
                    K = function e(t) {
                        return Object.values(t).map((function(t) {
                            return "object" === o()(t) ? e(t) : t
                        })).join("\n")
                    },
                    q = function(e) {
                        return e > 0 && e < 65536
                    },
                    Z = (M = d()(u().mark((function e(t, i) {
                        var n, o, s;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (s = null === _.Z || void 0 === _.Z || null === (n = _.Z.getters) || void 0 === n ? void 0 : n.clashAxiosClient) {
                                        e.next = 3;
                                        break
                                    }
                                    throw new Error("Clash Core is not ready");
                                case 3:
                                    return e.next = 5, s.get("/dns/query", {
                                        params: {
                                            name: t,
                                            type: i
                                        }
                                    });
                                case 5:
                                    if (e.t1 = o = e.sent, e.t0 = null === e.t1, e.t0) {
                                        e.next = 9;
                                        break
                                    }
                                    e.t0 = void 0 === o;
                                case 9:
                                    if (!e.t0) {
                                        e.next = 13;
                                        break
                                    }
                                    e.t2 = void 0, e.next = 14;
                                    break;
                                case 13:
                                    e.t2 = o.data;
                                case 14:
                                    return e.abrupt("return", e.t2);
                                case 15:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e, t) {
                        return M.apply(this, arguments)
                    })
            },
            97520: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => u,
                    r: () => h
                });
                var n = i(50008),
                    o = i.n(n),
                    s = i(32081),
                    r = i(22037),
                    a = i(41808),
                    l = i(83566);

                function c(e, t) {
                    var i = "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];
                    if (!i) {
                        if (Array.isArray(e) || (i = function(e, t) {
                                if (!e) return;
                                if ("string" == typeof e) return d(e, t);
                                var i = Object.prototype.toString.call(e).slice(8, -1);
                                "Object" === i && e.constructor && (i = e.constructor.name);
                                if ("Map" === i || "Set" === i) return Array.from(e);
                                if ("Arguments" === i || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)) return d(e, t)
                            }(e)) || t && e && "number" == typeof e.length) {
                            i && (e = i);
                            var n = 0,
                                o = function() {};
                            return {
                                s: o,
                                n: function() {
                                    return n >= e.length ? {
                                        done: !0
                                    } : {
                                        done: !1,
                                        value: e[n++]
                                    }
                                },
                                e: function(e) {
                                    throw e
                                },
                                f: o
                            }
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }
                    var s, r = !0,
                        a = !1;
                    return {
                        s: function() {
                            i = i.call(e)
                        },
                        n: function() {
                            var e = i.next();
                            return r = e.done, e
                        },
                        e: function(e) {
                            a = !0, s = e
                        },
                        f: function() {
                            try {
                                r || null == i.return || i.return()
                            } finally {
                                if (a) throw s
                            }
                        }
                    }
                }

                function d(e, t) {
                    (null == t || t > e.length) && (t = e.length);
                    for (var i = 0, n = new Array(t); i < t; i++) n[i] = e[i];
                    return n
                }
                var h = function() {
                    var e = [],
                        t = (0, r.networkInterfaces)();
                    return Object.keys(t).forEach((function(i) {
                        t[i].forEach((function(t) {
                            !0 !== t.internal && "IPv6" !== t.family && e.push({
                                name: i,
                                address: t.address
                            })
                        }))
                    })), e
                };
                const u = function() {
                    if ((0, l.V5)()) {
                        var e = (0, s.execSync)("netstat -nr | grep default ").toString().split("\n").map((function(e) {
                                return e.split(/\s+/).filter((function(e) {
                                    return e
                                }))
                            })).filter((function(e) {
                                return 4 === e.length && (0, a.isIPv4)(e[1])
                            })),
                            t = (0, r.networkInterfaces)();
                        if (e.length > 0) {
                            var i, n = c(e);
                            try {
                                for (n.s(); !(i = n.n()).done;) {
                                    var d = i.value[3];
                                    if (Object.keys(t).includes(d)) return d
                                }
                            } catch (e) {
                                n.e(e)
                            } finally {
                                n.f()
                            }
                        }
                        if (Object.keys(t).includes("en0")) return "en0"
                    } else if ((0, l.Kr)()) {
                        var h = (0, s.execSync)("route print 0.0.0.0 mask 0.0.0.0", {
                                windowsHide: !0
                            }).toString().split("\n").map((function(e) {
                                return e.split(/\s+/).filter((function(e) {
                                    return e
                                }))
                            })).filter((function(e) {
                                return 5 === e.length && e.slice(0, 4).every((function(e) {
                                    return (0, a.isIP)(e)
                                })) && NaN !== parseInt(e[4])
                            })),
                            u = (0, r.networkInterfaces)();
                        if (delete u["cfw-tap"], h.length > 0) {
                            var g, p = c(h.sort((function(e, t) {
                                return parseInt(e[4]) - parseInt(t[4])
                            })));
                            try {
                                var f = function() {
                                    for (var e = g.value[3], t = 0, i = Object.keys(u); t < i.length; t++) {
                                        var n = i[t];
                                        if (u[n].find((function(t) {
                                                return t.address === e
                                            }))) return {
                                            v: n
                                        }
                                    }
                                };
                                for (p.s(); !(g = p.n()).done;) {
                                    var m = f();
                                    if ("object" === o()(m)) return m.v
                                }
                            } catch (e) {
                                p.e(e)
                            } finally {
                                p.f()
                            }
                        }
                        if (Object.keys(u).includes("以太网")) return "以太网";
                        if (Object.keys(u).includes("WLAN")) return "WLAN"
                    }
                    return null
                }
            },
            71289: (e, t, i) => {
                "use strict";
                i.d(t, {
                    ZP: () => c
                });
                var n = i(24793),
                    o = i(59273),
                    s = [],
                    r = function(e) {
                        var t = s.find((function(t) {
                            return t.id === e
                        }));
                        t && -1 !== t.intervalId && (clearInterval(t.intervalId), s = s.filter((function(t) {
                            return t.id !== e
                        })))
                    },
                    a = function(e) {
                        var t = s.find((function(t) {
                            return t.id === e
                        }));
                        t && (clearInterval(t.intervalId), t.intervalId = -1)
                    },
                    l = function(e) {
                        var t = s.find((function(t) {
                            return t.id === e
                        }));
                        t && -1 === t.intervalId && (t.intervalId = setInterval(t.callback, t.interval))
                    };
                const c = {
                    add: function(e, t) {
                        var i = (0, n.uniqueId)(),
                            r = o.Z.state.app.isWindowShow ? setInterval(e, t) : -1;
                        return s.push({
                            id: i,
                            intervalId: r,
                            callback: e,
                            interval: t
                        }), i
                    },
                    stop: r,
                    stopAll: function() {
                        s.forEach((function(e) {
                            return r(e.id)
                        }))
                    },
                    pause: a,
                    pauseAll: function() {
                        s.forEach((function(e) {
                            return a(e.id)
                        }))
                    },
                    resume: l,
                    resumeAll: function() {
                        s.forEach((function(e) {
                            return l(e.id)
                        }))
                    },
                    getAll: function() {
                        return s
                    }
                }
            },
            419: (e, t, i) => {
                "use strict";
                i.d(t, {
                    rF: () => G
                });
                var n = i(48926),
                    o = i.n(n),
                    s = i(63038),
                    r = i.n(s),
                    a = i(59713),
                    l = i.n(a),
                    c = i(87757),
                    d = i.n(c),
                    h = i(59273),
                    u = i(54387),
                    g = i.n(u),
                    p = i(57147),
                    f = i.n(p),
                    m = i(71017),
                    v = i.n(m),
                    _ = i(96206),
                    b = i(11442),
                    w = i.n(b),
                    y = i(24793),
                    C = i.n(y),
                    x = i(319),
                    S = i.n(x),
                    k = i(50008),
                    L = i.n(k),
                    N = i(24793),
                    D = Symbol(),
                    I = Symbol(),
                    E = Symbol(),
                    T = function(e, t) {
                        var i = function(e) {
                            var t = [],
                                i = D,
                                n = "",
                                o = !1,
                                s = "";
                            e: for (var r = 0; r < e.length; r++) {
                                var a = e[r];
                                if ("-" === a && r === e.length - 1) {
                                    i = E, t.push(s);
                                    break e
                                }
                                if ("(" !== a)
                                    if (")" !== a)
                                        if (o) s += a;
                                        else switch (a) {
                                            case ".":
                                                t.push(s), s = "";
                                                break;
                                            case "+":
                                                i = I;
                                            case "=":
                                                t.push(s), n = e.slice(r + 1);
                                                break e;
                                            default:
                                                s += a
                                        } else o = !1;
                                else o = !0
                            }
                            return {
                                path: t,
                                opertation: i,
                                value: n
                            }
                        }(t);
                        ! function(e, t, i) {
                            var n = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : D,
                                o = e.proxies,
                                s = void 0 === o ? [] : o,
                                r = e["proxy-groups"],
                                a = void 0 === r ? [] : r,
                                l = t.slice(0, -1),
                                c = t[t.length - 1],
                                d = i;
                            try {
                                d = JSON.parse(i)
                            } catch (e) {}
                            var h = N.reduce(l, (function(e, i, n) {
                                    var o = e[i];
                                    if (void 0 !== o) return o;
                                    if (Array.isArray(e)) {
                                        var s = e.find((function(e) {
                                            return e.name === i
                                        }));
                                        if (s) return s
                                    }
                                    if (t.length > n + 1) {
                                        var r = t[n + 1];
                                        parseInt(r) >= 0 ? e[i] = [] : e[i] = {}
                                    } else e[i] = {};
                                    return e[i]
                                }), e),
                                u = Array.isArray(h),
                                g = function(e) {
                                    if (/^\[\](shuffledProxyNames|proxyNames|groupNames)\|?(.+)?$/.test(e)) {
                                        var t = RegExp.$1,
                                            i = RegExp.$2 || "",
                                            n = [];
                                        return "proxyNames" === t && (n = s), "groupNames" === t && (n = a), "shuffledProxyNames" === t && (n = N.shuffle(s)), n.map((function(e) {
                                            return e.name
                                        })).filter((function(e) {
                                            return new RegExp(i).test(e)
                                        }))
                                    }
                                    return null
                                }(d);
                            switch (n) {
                                case D:
                                    if (g) h[c] = g;
                                    else {
                                        var p = L()(h[c]);
                                        h[c] = "number" === p ? 1 * d : "boolean" === p ? "boolean" == typeof d ? d : "true" === d : d
                                    }
                                    break;
                                case I:
                                    u ? h.splice.apply(h, [c, 0].concat(S()(g || [d]))) : h[c] = g || d;
                                    break;
                                case E:
                                    u ? parseInt(c) > -1 ? h.splice(c, 1) : h.splice(h.findIndex((function(e) {
                                        return e.name === c
                                    })), 1) : delete h[c]
                            }
                        }(e, i.path, i.value, i.opertation)
                    },
                    M = i(8369);
                const A = require("node-diff3"),
                    O = require("content-disposition");
                var P = i(71893),
                    R = i.n(P);
                const F = require("hpagent");

                function B(e, t) {
                    var i = "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];
                    if (!i) {
                        if (Array.isArray(e) || (i = function(e, t) {
                                if (!e) return;
                                if ("string" == typeof e) return V(e, t);
                                var i = Object.prototype.toString.call(e).slice(8, -1);
                                "Object" === i && e.constructor && (i = e.constructor.name);
                                if ("Map" === i || "Set" === i) return Array.from(e);
                                if ("Arguments" === i || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)) return V(e, t)
                            }(e)) || t && e && "number" == typeof e.length) {
                            i && (e = i);
                            var n = 0,
                                o = function() {};
                            return {
                                s: o,
                                n: function() {
                                    return n >= e.length ? {
                                        done: !0
                                    } : {
                                        done: !1,
                                        value: e[n++]
                                    }
                                },
                                e: function(e) {
                                    throw e
                                },
                                f: o
                            }
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }
                    var s, r = !0,
                        a = !1;
                    return {
                        s: function() {
                            i = i.call(e)
                        },
                        n: function() {
                            var e = i.next();
                            return r = e.done, e
                        },
                        e: function(e) {
                            a = !0, s = e
                        },
                        f: function() {
                            try {
                                r || null == i.return || i.return()
                            } finally {
                                if (a) throw s
                            }
                        }
                    }
                }

                function V(e, t) {
                    (null == t || t > e.length) && (t = e.length);
                    for (var i = 0, n = new Array(t); i < t; i++) n[i] = e[i];
                    return n
                }

                function W(e, t) {
                    var i = Object.keys(e);
                    if (Object.getOwnPropertySymbols) {
                        var n = Object.getOwnPropertySymbols(e);
                        t && (n = n.filter((function(t) {
                            return Object.getOwnPropertyDescriptor(e, t).enumerable
                        }))), i.push.apply(i, n)
                    }
                    return i
                }

                function H(e) {
                    for (var t = 1; t < arguments.length; t++) {
                        var i = null != arguments[t] ? arguments[t] : {};
                        t % 2 ? W(Object(i), !0).forEach((function(t) {
                            l()(e, t, i[t])
                        })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(i)) : W(Object(i)).forEach((function(t) {
                            Object.defineProperty(e, t, Object.getOwnPropertyDescriptor(i, t))
                        }))
                    }
                    return e
                }
                var z, j, U = i(75110),
                    $ = function(e) {
                        var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                            i = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                            n = h.Z.state.app.settings.headersText,
                            o = {};
                        if (n) try {
                            var s = w().parse(n).headers;
                            o = void 0 === s ? {} : s
                        } catch (e) {}
                        return (0, u.get)(e, H(H({
                            validateStatus: function() {
                                return !0
                            }
                        }, t), {}, {
                            headers: H(H({
                                pragma: "no-cache"
                            }, i), o),
                            responseType: "text",
                            transformResponse: [function(e) {
                                return e
                            }]
                        }))
                    },
                    K = function(e) {
                        var t, i = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                            n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                            o = h.Z.state.app.settings.headersText,
                            s = {};
                        if (o) try {
                            var r = w().parse(o).headers;
                            s = void 0 === r ? {} : r
                        } catch (e) {}
                        var a = h.Z.state.app.confData,
                            l = a["mixed-port"],
                            c = a.authentication,
                            d = void 0 === c ? [] : c,
                            u = R()(e, {
                                agent: new F.HttpsProxyAgent({
                                    proxy: "http://".concat(d.length > 0 ? d[0] + "@" : "", "127.0.0.1:").concat(l)
                                }),
                                headers: H(H({
                                    pragma: "no-cache"
                                }, n), s)
                            });
                        return null === (t = i.cancelToken) || void 0 === t || t.promise.then((function(e) {
                            u.cancel(e)
                        })), u
                    },
                    q = function(e) {
                        var t = {};
                        return /upload=(.+?)(;|$)/.test(e) && (t.upload = parseInt(RegExp.$1.trim())), /download=(.+?)(;|$)/.test(e) && (t.download = parseInt(RegExp.$1.trim())), /total=(.+?)(;|$)/.test(e) && (t.total = parseInt(RegExp.$1.trim())), /expire=(.+?)(;|$)/.test(e) && (t.expire = parseInt(RegExp.$1.trim())), t
                    },
                    Z = function(e) {
                        try {
                            return e.split("\n").reduce((function(e, t) {
                                var i = t.split(":"),
                                    n = r()(i, 2),
                                    o = n[0],
                                    s = n[1];
                                return e[o.trim()] = s.trim(), e
                            }), {})
                        } catch (e) {
                            return {}
                        }
                    },
                    G = (z = o()(d().mark((function e(t) {
                        const Lg = new Language(modifyState.language);
                        var i, n, o, s, r, a, l, c, u, g, p, m, _, b, w, y, C, x, S, k, L, N, D, I, E, T, M, P, R, F, B, V, W, z, j, U, G, Q, X, J, ee, te, ie, ne, oe, se, re, ae, le, ce;
                        return d().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (i = t.url, n = t.cancelToken, o = void 0 === n ? null : n, s = t.headersString, r = void 0 === s ? "" : s, e.prev = 1, a = h.Z.state.app.settings.updateProfileThroughClashProxy, l = void 0, c = void 0, u = {}, void 0 === a || !a) {
                                        e.next = 18;
                                        break
                                    }
                                    return e.next = 9, K(i, {
                                        cancelToken: o
                                    }, Z(r));
                                case 9:
                                    g = e.sent, p = g.body, m = g.statusCode, _ = g.headers, l = p, c = m, u = _, e.next = 27;
                                    break;
                                case 18:
                                    return e.next = 20, $(i, {
                                        cancelToken: o
                                    }, Z(r));
                                case 20:
                                    b = e.sent, w = b.data, y = b.status, C = b.headers, l = w, c = y, u = C;
                                case 27:
                                    x = "config.yaml", S = (new Date).getTime() + ".yml";
                                    try {
                                        x = v().basename(i)
                                    } catch (e) {
                                        console.error(e.stack)
                                    }
                                    /([^\/]*?)(?:$|\?)/.test(i) && (x = decodeURIComponent(RegExp.$1.trim())), L = (k = u)["profile-update-interval"], N = void 0 === L ? 0 : L, D = k["profile-web-page-url"], I = void 0 === D ? "" : D, E = k["content-disposition"], T = k["subscription-userinfo"], M = void 0 === T ? "" : T;
                                    try {
                                        (F = null === (P = (0, O.parse)(E)) || void 0 === P || null === (R = P.parameters) || void 0 === R ? void 0 : R.filename) && (x = F)
                                    } catch (e) {}
                                    if (B = parseInt(N) || 0, V = h.Z.state.app.profilesPath, W = v().join(V, S), z = -1, 200 !== c) {
                                        e.next = 63;
                                        break
                                    }
                                    return e.next = 40, Y(i, l, !0);
                                case 40:
                                    if (j = e.sent, U = h.Z.state.app.profiles.files, (Q = (G = void 0 === U ? [] : U).findIndex((function(e) {
                                            return e.url === i
                                        }))) > -1 ? (X = G[Q], J = H({}, X), ee = J.time, W = v().join(V, ee), h.Z.commit("CHANGE_PROFILE", {
                                            index: Q,
                                            profile: H(H({}, X), {}, {
                                                subInfo: q(M || j),
                                                homeWeb: I
                                            })
                                        }), z = Q) : (te = {
                                            time: S,
                                            name: x,
                                            url: i,
                                            selected: [],
                                            interval: B,
                                            subInfo: q(M || j),
                                            homeWeb: I
                                        }, h.Z.commit("APPEND_PROFILE", {
                                            profile: te
                                        }), z = G.length), ne = W.slice(0, -4) + ".base.yml", oe = W.slice(0, -4) + ".change.yml", !f().existsSync(ne) || !f().existsSync(oe)) {
                                        e.next = 59;
                                        break
                                    }
                                    if (se = f().readFileSync(ne).toString(), re = f().readFileSync(oe).toString(), !/<{7}[\S\s]+?={7}[\S\s]+?>{7}/.test(re)) {
                                        e.next = 51;
                                        break
                                    }
                                    return e.abrupt("return", {
                                        success: !1,
                                        message: Lg.diffChangeContainConflict()
                                    });
                                case 51:
                                    if (ae = (0, A.merge)(re, se, j, {
                                            stringSeparator: /\n|\r\n/
                                        }), le = ae.conflict, ce = ae.result, f().writeFileSync(ne, j), f().writeFileSync(oe, ce.join("\n")), !le) {
                                        e.next = 58;
                                        break
                                    }
                                    return e.abrupt("return", {
                                        success: !1,
                                        message: Lg.failMergeProfile()
                                    });
                                case 58:
                                    ie = ce.join("\n");
                                case 59:
                                    return f().writeFileSync(W, ie || j), e.abrupt("return", {
                                        success: !0,
                                        targetIndex: z
                                    });
                                case 63:
                                    return e.abrupt("return", {
                                        success: !1,
                                        message: Lg.downloadProfile() + "(".concat(i, ") " + Lg.failedErrorHTTP() + "(").concat(c, ")")
                                    });
                                case 64:
                                    e.next = 72;
                                    break;
                                case 66:
                                    if (e.prev = 66, e.t0 = e.catch(1), console.error(e.t0), !e.t0.message) {
                                        e.next = 72;
                                        break
                                    }
                                    return e.abrupt("return", {
                                        success: !1,
                                        message: Lg.downloadProfile() + "(".concat(i, ") " + Lg.failedWithError()).concat(e.t0.message)
                                    });
                                case 72:
                                    return e.abrupt("return", {
                                        success: !1,
                                        message: Lg.unknowErr()
                                    });
                                case 73:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [1, 66]
                        ])
                    }))), function(e) {
                        return z.apply(this, arguments)
                    }),
                    Y = (j = o()(d().mark((function e(t, n) {
                        var o, s, r, a, l, c, u, p, m, v, b, y, C, x, S, k, L, N, D, I, E, T, A, O, P, R, F, V, W, z, j = arguments;
                        return d().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return o = j.length > 2 && void 0 !== j[2] && j[2], e.prev = 1, r = h.Z.state.app.profiles.files, a = null !== (s = (void 0 === r ? [] : r).find((function(e) {
                                        return e.url === t
                                    }))) && void 0 !== s ? s : {
                                        url: t
                                    }, e.t0 = _.Console, e.t1 = f(), e.next = 8, h.Z.dispatch("getParserLogPath");
                                case 8:
                                    if (e.t2 = e.sent, e.t3 = e.t1.createWriteStream.call(e.t1, e.t2), l = new e.t0(e.t3), c = {
                                            axios: i(54387),
                                            yaml: i(11442),
                                            homeDir: h.Z.state.app.clashPath,
                                            console: o ? l : console,
                                            notify: function(e) {
                                                var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : "",
                                                    i = !(arguments.length > 2 && void 0 !== arguments[2]) || arguments[2];
                                                (0, M.c0)(e, t, i)
                                            }
                                        }, u = h.Z.state.app.settings.profileParsersText, p = [], u) try {
                                        m = w().parse(u), v = m.parsers, p = (void 0 === v ? [] : v) || []
                                    } catch (e) {}
                                    b = p.filter((function(e) {
                                        var i = e.url,
                                            n = e.reg;
                                        return i ? i === t : n ? new RegExp(n).test(t) : void 0
                                    })), y = n, C = B(b), e.prev = 18, C.s();
                                case 20:
                                    if ((x = C.n()).done) {
                                        e.next = 58;
                                        break
                                    }
                                    if (S = x.value, k = S.code, L = S.file, N = S.yaml, D = S.remote, !k) {
                                        e.next = 28;
                                        break
                                    }
                                    return I = U("'use strict';\n".concat(k)), e.next = 27, I.parse(y, c, a);
                                case 27:
                                    y = e.sent;
                                case 28:
                                    if (!L) {
                                        e.next = 40;
                                        break
                                    }
                                    if (E = f().readFileSync(L, "utf-8"), !/\.ya?ml$/.test(L)) {
                                        e.next = 35;
                                        break
                                    }
                                    T = w().parse(E), y = Q(y, T), e.next = 40;
                                    break;
                                case 35:
                                    if (!/\.js$/.test(L)) {
                                        e.next = 40;
                                        break
                                    }
                                    return A = U("'use strict';\n".concat(E), L), e.next = 39, A.parse(y, c, a);
                                case 39:
                                    y = e.sent;
                                case 40:
                                    if (N && (y = Q(y, N)), !D) {
                                        e.next = 56;
                                        break
                                    }
                                    if (O = D.url, P = D.cache, R = void 0 !== P && P, O) {
                                        e.next = 45;
                                        break
                                    }
                                    throw new Error("Remote parser url is required");
                                case 45:
                                    return e.next = 47, g().get(O, {
                                        headers: {
                                            "cache-control": R ? "max-age=3600" : "no-cache"
                                        }
                                    });
                                case 47:
                                    if (F = e.sent, V = F.data, 200 === (W = F.status)) {
                                        e.next = 52;
                                        break
                                    }
                                    throw new Error("Remote parser download failed with status: ".concat(W));
                                case 52:
                                    return z = U("'use strict';\n".concat(V)), e.next = 55, z.parse(y, c, a);
                                case 55:
                                    y = e.sent;
                                case 56:
                                    e.next = 20;
                                    break;
                                case 58:
                                    e.next = 63;
                                    break;
                                case 60:
                                    e.prev = 60, e.t4 = e.catch(18), C.e(e.t4);
                                case 63:
                                    return e.prev = 63, C.f(), e.finish(63);
                                case 66:
                                    return e.abrupt("return", y);
                                case 69:
                                    throw e.prev = 69, e.t5 = e.catch(1), H(H({}, e.t5), {}, {
                                        message: "[Parser Error] " + e.t5.message
                                    });
                                case 72:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [1, 69],
                            [18, 60, 63, 66]
                        ])
                    }))), function(e, t) {
                        return j.apply(this, arguments)
                    }),
                    Q = function(e, t) {
                        var i = {},
                            n = t["append-rules"],
                            o = void 0 === n ? [] : n,
                            s = t["prepend-rules"],
                            r = void 0 === s ? [] : s,
                            a = t["append-proxies"],
                            l = void 0 === a ? [] : a,
                            c = t["prepend-proxies"],
                            d = void 0 === c ? [] : c,
                            h = t["append-proxy-groups"],
                            u = void 0 === h ? [] : h,
                            g = t["prepend-proxy-groups"],
                            p = void 0 === g ? [] : g,
                            f = t["mix-proxy-providers"],
                            m = void 0 === f ? {} : f,
                            v = t["mix-rule-providers"],
                            _ = void 0 === v ? {} : v,
                            b = t["mix-object"],
                            y = void 0 === b ? {} : b,
                            x = t.commands,
                            S = void 0 === x ? [] : x,
                            k = t["key-orders"],
                            L = void 0 === k ? [] : k,
                            N = w().parse(e),
                            D = C().cloneDeep(N),
                            I = N.rules,
                            E = void 0 === I ? [] : I,
                            M = N.proxies,
                            A = void 0 === M ? [] : M,
                            O = N["proxy-groups"],
                            P = void 0 === O ? [] : O,
                            R = N["proxy-providers"],
                            F = void 0 === R ? {} : R,
                            V = N["rule-providers"],
                            W = void 0 === V ? {} : V;
                        (r || o) && (D.rules = r.concat(null != E ? E : []).concat(o)), (d || l) && (D.proxies = d.concat(null != A ? A : []).concat(l)), (p || u) && (D["proxy-groups"] = p.concat(null != P ? P : []).concat(u)), m && (D["proxy-providers"] = H(H({}, F), m)), _ && (D["rule-providers"] = H(H({}, W), _));
                        var z, j = B(S);
                        try {
                            for (j.s(); !(z = j.n()).done;) {
                                var U = z.value;
                                T(D, U)
                            }
                        } catch (e) {
                            j.e(e)
                        } finally {
                            j.f()
                        }
                        return L.length > 0 && (i.sortMapEntries = function(e, t) {
                            var i = e.key,
                                n = t.key,
                                o = L.findIndex((function(e) {
                                    return e === i.value
                                })),
                                s = L.findIndex((function(e) {
                                    return e === n.value
                                }));
                            return (-1 === o ? 1 / 0 : o) - (-1 === s ? 1 / 0 : s)
                        }), w().stringify(H(H({}, D), y), i)
                    }
            },
            1581: (e, t, i) => {
                "use strict";
                i.d(t, {
                    lJ: () => m,
                    ay: () => f,
                    TX: () => v
                });
                var n = i(48926),
                    o = i.n(n),
                    s = i(87757),
                    r = i.n(s),
                    a = i(8369),
                    l = i(59273);
                const c = require("original-fs");
                var d, h = i(11442),
                    u = i(75110),
                    g = i.n(u),
                    p = i(96206),
                    f = Symbol(),
                    m = Symbol(),
                    v = (d = o()(r().mark((function e(t, n) {
                        var o, s, d, u, v, _, b, w;
                        return r().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.t0 = i(54387), e.t1 = i(11442), e.t2 = l.Z.state.app.clashPath, e.t3 = p.Console, e.t4 = c.createWriteStream, e.next = 7, l.Z.dispatch("getScriptLogPath");
                                case 7:
                                    if (e.t5 = e.sent, e.t6 = (0, e.t4)(e.t5), e.t7 = new e.t3(e.t6), e.t8 = a.c0, e.t9 = a.vC, e.t10 = a.e8, o = {
                                            axios: e.t0,
                                            yaml: e.t1,
                                            homeDir: e.t2,
                                            console: e.t7,
                                            notify: e.t8,
                                            dialog: e.t9,
                                            resolveHost: e.t10
                                        }, s = l.Z.state.app.settings.scriptsText, d = {}, s) try {
                                        u = (0, h.parse)(s), v = u.scripts, d = v || {}
                                    } catch (e) {}
                                    _ = function() {
                                        var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
                                            t = (null == e ? void 0 : e.code) || "",
                                            i = (null == e ? void 0 : e.file) || "";
                                        if (t) return g()("'use strict';\n".concat(t)).run;
                                        if (i) {
                                            var n = (0, c.readFileSync)(i, "utf8");
                                            return g()("'use strict';\n".concat(n), i).run
                                        }
                                        return function() {
                                            return ""
                                        }
                                    }, e.t11 = n, e.next = e.t11 === f ? 21 : e.t11 === m ? 24 : 27;
                                    break;
                                case 21:
                                    return b = d.proxy, _(b)(t, o), e.abrupt("break", 27);
                                case 24:
                                    return w = d.profile, _(w)(t, o), e.abrupt("break", 27);
                                case 27:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e, t) {
                        return d.apply(this, arguments)
                    })
            },
            44224: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    installService: () => k,
                    needUpdate: () => N,
                    status: () => y,
                    statusService: () => S,
                    uninstallService: () => L,
                    updateService: () => D
                });
                var n, o, s, r, a = i(48926),
                    l = i.n(a),
                    c = i(59713),
                    d = i.n(c),
                    h = i(87757),
                    u = i.n(h),
                    g = i(83566),
                    p = i(59273),
                    f = i(72378),
                    m = i(71017),
                    v = i(57147),
                    _ = i(8369),
                    b = (i(11442), i(54387)),
                    w = '<?xml version="1.0" encoding="UTF-8"?>\n<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "https://www.apple.com/DTDs/PropertyList-1.0.dtd">\n<plist version="1.0">\n    <dict>\n        <key>Label</key>\n        <string>com.lbyczf.cfw.helper</string>\n        <key>Program</key>\n        <string>helperPath</string>\n        <key>RunAtLoad</key>\n        <true/>\n        <key>KeepAlive</key>\n        <true/>\n        <key>HardResourceLimits</key>\n        <dict>\n            <key>NumberOfFiles</key>\n            <integer>10240</integer>\n        </dict>\n        <key>SoftResourceLimits</key>\n        <dict>\n            <key>NumberOfFiles</key>\n            <integer>10240</integer>\n        </dict>\n    </dict>\n</plist>',
                    y = {
                        Active: Symbol(),
                        Inactive: Symbol(),
                        NonExistent: Symbol(),
                        Unknown: Symbol()
                    },
                    C = function(e) {
                        return new Promise((function(t, i) {
                            (0, f.exec)(e, {
                                name: "Clash for Windows"
                            }, (function(e, n, o) {
                                e && i(e), o && i(o), n && t(n.toString()), t("")
                            }))
                        }))
                    },
                    x = function() {
                        var e, t = p.Z.getters.filesPath,
                            i = (e = {}, d()(e, g.Ml, "darwin/x64/service"), d()(e, g.UD, "darwin/arm64/service"), e)[(0, g.$Q)()];
                        return (0, m.join)(t, i)
                    },
                    S = (n = l()(u().mark((function e() {
                        var t, i, n, o;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (e.prev = 0, t = p.Z.state.app.clashPath, "" === (i = void 0 === t ? "" : t) || (0, v.existsSync)((0, m.join)(i, "service"))) {
                                        e.next = 4;
                                        break
                                    }
                                    return e.abrupt("return", y.Inactive);
                                case 4:
                                    return e.next = 6, b.get("http://127.0.0.1:53000/ping", {
                                        timeout: 5e3
                                    });
                                case 6:
                                    return n = e.sent, o = n.status, e.abrupt("return", 200 === o ? y.Active : y.Inactive);
                                case 11:
                                    e.prev = 11, e.t0 = e.catch(0);
                                case 13:
                                    return e.abrupt("return", y.Unknown);
                                case 14:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [0, 11]
                        ])
                    }))), function() {
                        return n.apply(this, arguments)
                    }),
                    k = (o = l()(u().mark((function e() {
                        var t, i, n, o;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return t = p.Z.state.app.clashPath, i = (0, m.join)(t, "service"), (0, v.existsSync)(i) || (0, v.mkdirSync)(i), n = (0, m.join)(t, "service", "clash-core-service"), o = "/Library/LaunchDaemons/com.lbyczf.cfw.helper.plist", e.next = 7, C('cp "'.concat((0, m.join)(x(), "clash-core-service"), '" "').concat((0, m.join)(n), '" ; chmod 655 "').concat(n, '" ; chown root:wheel "').concat(n, '" ;  echo "').concat(w.replace("helperPath", n), '" > ').concat(o, " ; launchctl load -w ").concat(o));
                                case 7:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return o.apply(this, arguments)
                    }),
                    L = (s = l()(u().mark((function e() {
                        var t, i;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return t = "/Library/LaunchDaemons/com.lbyczf.cfw.helper.plist", i = (0, m.join)(p.Z.state.app.clashPath, "service"), e.next = 4, C("launchctl unload ".concat(t, " ; rm ").concat(t) + ((0, v.existsSync)(i) ? " ; rm -rf ".concat(i) : ""));
                                case 4:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return s.apply(this, arguments)
                    }),
                    N = function() {
                        var e = p.Z.state.app.clashPath,
                            t = (0, m.join)(e, "service");
                        if (!(0, v.existsSync)(t)) return !1;
                        var i = (0, m.join)(e, "service", "clash-core-service");
                        if (!(0, v.existsSync)(i)) return !1;
                        var n = (0, m.join)(x(), "clash-core-service"),
                            o = function(e) {
                                return (0, _.Ll)((0, v.readFileSync)(e))
                            };
                        return o(i) !== o(n)
                    },
                    D = (r = l()(u().mark((function e() {
                        var t, i, n, o;
                        return u().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return t = p.Z.state.app.clashPath, i = (0, m.join)(t, "service"), (0, v.existsSync)(i) || (0, v.mkdirSync)(i), n = (0, m.join)(t, "service", "clash-core-service"), o = "/Library/LaunchDaemons/com.lbyczf.cfw.helper.plist", e.next = 7, C('cp "'.concat((0, m.join)(x(), "clash-core-service"), '" "').concat((0, m.join)(n), '" ; chmod 611 "').concat(n, '" ; chown root:wheel "').concat(n, '" ; launchctl unload ').concat(o, ' ; echo "').concat(w.replace("helperPath", n), '" > ').concat(o, " ; launchctl load -w ").concat(o));
                                case 7:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return r.apply(this, arguments)
                    })
            },
            33130: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    installService: () => N,
                    needUpdate: () => I,
                    status: () => C,
                    statusService: () => L,
                    uninstallService: () => D,
                    updateService: () => E
                });
                var n = i(48926),
                    o = i.n(n),
                    s = i(59713),
                    r = i.n(s),
                    a = i(87757),
                    l = i.n(a),
                    c = i(83566),
                    d = i(59273),
                    h = i(72378),
                    u = i(71017),
                    g = i(57147),
                    p = i(8369),
                    f = (i(11442), i(54387)),
                    m = i(72298);
                require("fs-extra");
                var v, _, b, w, y, C = {
                        Active: Symbol(),
                        Inactive: Symbol(),
                        NonExistent: Symbol(),
                        Unknown: Symbol()
                    },
                    x = function(e) {
                        return new Promise((function(t, i) {
                            (0, h.exec)(e, {
                                name: "Clash for Windows"
                            }, (function(e, n, o) {
                                e && i(e), o && i(o), n && t(n.toString()), t("")
                            }))
                        }))
                    },
                    S = function() {
                        var e, t = d.Z.getters.filesPath,
                            i = (e = {}, r()(e, c.bV, "linux/x64/service"), r()(e, c.tU, "linux/arm64/service"), e)[(0, c.$Q)()];
                        return (0, u.join)(t, i)
                    },
                    k = (v = o()(l().mark((function e() {
                        return l().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2, m.ipcRenderer.invoke("app", "getPath", "temp");
                                case 2:
                                    return e.abrupt("return", e.sent);
                                case 3:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return v.apply(this, arguments)
                    }),
                    L = (_ = o()(l().mark((function e() {
                        var t, i, n, o;
                        return l().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (e.prev = 0, t = d.Z.state.app.clashPath, "" === (i = void 0 === t ? "" : t) || (0, g.existsSync)((0, u.join)(i, "service"))) {
                                        e.next = 4;
                                        break
                                    }
                                    return e.abrupt("return", C.Inactive);
                                case 4:
                                    return e.next = 6, f.get("http://127.0.0.1:53000/ping", {
                                        timeout: 5e3
                                    });
                                case 6:
                                    return n = e.sent, o = n.status, e.abrupt("return", 200 === o ? C.Active : C.Inactive);
                                case 11:
                                    e.prev = 11, e.t0 = e.catch(0);
                                case 13:
                                    return e.abrupt("return", C.Unknown);
                                case 14:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [0, 11]
                        ])
                    }))), function() {
                        return _.apply(this, arguments)
                    }),
                    N = (b = o()(l().mark((function e() {
                        var t, i, n, o;
                        return l().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return t = d.Z.state.app.clashPath, i = (0, u.join)(t, "service"), (0, g.existsSync)(i) || (0, g.mkdirSync)(i), n = (0, u.join)(t, "service", "clash-core-service"), o = (0, u.join)("/usr/lib/systemd/system", "clash-core-service.service"), e.next = 7, x('cp "'.concat((0, u.join)(S(), "clash-core-service"), '" "').concat((0, u.join)(n), '" ; chmod 655 "').concat((0, u.join)(n), '" ; chown root "').concat((0, u.join)(n), '" ; echo "').concat("[Unit]\nDescription=Clash core service created by Clash for Windows\nAfter=network-online.target nftables.service iptables.service\n\n[Service]\nType=simple\nExecStart=helperPath\nRestart=always\nRestartSec=5\n\n[Install]\nWantedBy=multi-user.target".replace("helperPath", n), '" > ').concat(o, " ; systemctl enable clash-core-service; systemctl start clash-core-service"));
                                case 7:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return b.apply(this, arguments)
                    }),
                    D = (w = o()(l().mark((function e() {
                        var t, i, n, o;
                        return l().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.prev = 0, e.t0 = u.join, e.next = 4, k();
                                case 4:
                                    if (e.t1 = e.sent, t = (0, e.t0)(e.t1, "cfw-clash-service-installer"), !(0, g.existsSync)(t)) {
                                        e.next = 10;
                                        break
                                    }
                                    return e.next = 9, x("".concat(t, "/installer.sh uninstall"));
                                case 9:
                                    (0, g.existsSync)(t) && (0, p.uR)(t);
                                case 10:
                                    e.next = 14;
                                    break;
                                case 12:
                                    e.prev = 12, e.t2 = e.catch(0);
                                case 14:
                                    return i = (0, u.join)("/usr/lib/systemd/system", "clash-core-service.service"), n = d.Z.state.app.clashPath, o = (0, u.join)(n, "service"), e.next = 19, x("systemctl stop clash-core-service; systemctl disable clash-core-service; rm -rf ".concat(i) + ((0, g.existsSync)(o) ? " ; rm -rf ".concat(o) : ""));
                                case 19:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [0, 12]
                        ])
                    }))), function() {
                        return w.apply(this, arguments)
                    }),
                    I = function() {
                        var e = d.Z.state.app.clashPath,
                            t = (0, u.join)(e, "service");
                        if (!(0, g.existsSync)(t)) return !1;
                        var i = (0, u.join)(e, "service", "clash-core-service");
                        if (!(0, g.existsSync)(i)) return !1;
                        var n = (0, u.join)(S(), "clash-core-service"),
                            o = function(e) {
                                return (0, p.Ll)((0, g.readFileSync)(e))
                            };
                        return o(i) !== o(n)
                    },
                    E = (y = o()(l().mark((function e() {
                        return l().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2, D();
                                case 2:
                                    return e.next = 4, N();
                                case 4:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return y.apply(this, arguments)
                    })
            },
            34668: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    installService: () => A,
                    needUpdate: () => R,
                    status: () => S,
                    statusService: () => M,
                    uninstallService: () => O,
                    updateService: () => F
                });
                var n, o, s, r, a, l, c, d = i(48926),
                    h = i.n(d),
                    u = i(59713),
                    g = i.n(u),
                    p = i(87757),
                    f = i.n(p),
                    m = i(83566),
                    v = i(59273),
                    _ = i(54387),
                    b = i.n(_),
                    w = i(72378),
                    y = i(71017),
                    C = i(57147),
                    x = i(8369),
                    S = (i(11442), {
                        Active: Symbol(),
                        Inactive: Symbol(),
                        NonExistent: Symbol(),
                        Unknown: Symbol()
                    }),
                    k = process.env.ProgramW6432 || process.env.ProgramFiles || "C:\\Program Files",
                    L = (0, y.join)(k, "Clash for Windows Service"),
                    N = function(e) {
                        return new Promise((function(t, i) {
                            (0, w.exec)(e, {
                                name: "ClashforWindows"
                            }, (function(e, n, o) {
                                e && i(e), o && i(o), n && t(n.toString()), t("")
                            }))
                        }))
                    },
                    D = function() {
                        var e, t = v.Z.getters.filesPath,
                            i = (e = {}, g()(e, m.Ap, "win/ia32/service"), g()(e, m.J4, "win/x64/service"), g()(e, m.Vm, "win/arm64/service"), e)[(0, m.$Q)()];
                        return (0, y.join)(t, i)
                    },
                    I = (n = h()(f().mark((function e() {
                        var t, i, n, o, s, r, a, l, c, d = arguments;
                        return f().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (t = d.length > 0 && void 0 !== d[0] ? d[0] : [], n = (i = d.length > 1 && void 0 !== d[1] ? d[1] : {}).runAfter, o = void 0 === n ? "" : n, s = i.runBefore, r = void 0 === s ? "" : s, !(0, m.Kr)()) {
                                        e.next = 9;
                                        break
                                    }
                                    return a = (0, y.join)(v.Z.state.app.clashPath, "service"), l = t.map((function(e) {
                                        var t = e.cmd,
                                            i = e.options,
                                            n = void 0 === i ? [] : i;
                                        return '"'.concat((0, y.join)(a, "service.exe"), '" ').concat(t, " ").concat(n.join(" "))
                                    })).join(" & "), e.next = 7, N([r, l, o].filter((function(e) {
                                        return e
                                    })).join(" & "));
                                case 7:
                                    return c = e.sent, e.abrupt("return", c);
                                case 9:
                                    return e.abrupt("return", "");
                                case 10:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return n.apply(this, arguments)
                    }),
                    E = (o = h()(f().mark((function e() {
                        var t, i, n, o, s, r, a, l, c, d = arguments;
                        return f().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (t = d.length > 0 && void 0 !== d[0] ? d[0] : [], n = (i = d.length > 1 && void 0 !== d[1] ? d[1] : {}).runAfter, o = void 0 === n ? "" : n, s = i.runBefore, r = void 0 === s ? "" : s, !(0, m.Kr)()) {
                                        e.next = 9;
                                        break
                                    }
                                    return a = L, l = t.map((function(e) {
                                        var t = e.cmd,
                                            i = e.options,
                                            n = void 0 === i ? [] : i;
                                        return '"'.concat((0, y.join)(a, "service.exe"), '" ').concat(t, " ").concat(n.join(" "))
                                    })).join(" & "), e.next = 7, N([r, l].filter((function(e) {
                                        return e
                                    })).join(" & ") + (o ? " && ".concat(o) : ""));
                                case 7:
                                    return c = e.sent, e.abrupt("return", c);
                                case 9:
                                    return e.abrupt("return", "");
                                case 10:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return o.apply(this, arguments)
                    }),
                    T = (s = h()(f().mark((function e() {
                        var t, i, n, o, s, r, a, l, c = arguments;
                        return f().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (t = c.length > 0 && void 0 !== c[0] ? c[0] : [], n = (i = c.length > 1 && void 0 !== c[1] ? c[1] : {}).runAfter, o = void 0 === n ? "" : n, s = i.runBefore, r = void 0 === s ? "" : s, !(0, m.Kr)()) {
                                        e.next = 8;
                                        break
                                    }
                                    return a = t.map((function(e) {
                                        var t = e.cmd,
                                            i = e.options,
                                            n = void 0 === i ? [] : i;
                                        return "schtasks /".concat(t, ' /tn "Clash Core Service" ').concat(n.join(" "))
                                    })).join(" & "), e.next = 6, N([r, a].filter((function(e) {
                                        return e
                                    })).join(" & ") + (o ? " && ".concat(o) : ""));
                                case 6:
                                    return l = e.sent, e.abrupt("return", l);
                                case 8:
                                    return e.abrupt("return", "");
                                case 9:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return s.apply(this, arguments)
                    }),
                    M = (r = h()(f().mark((function e() {
                        var t, i;
                        return f().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.prev = 0, e.next = 3, b().get("http://127.0.0.1:53000/ping", {
                                        timeout: 5e3
                                    });
                                case 3:
                                    return t = e.sent, i = t.status, e.abrupt("return", 200 === i ? S.Active : S.Inactive);
                                case 8:
                                    e.prev = 8, e.t0 = e.catch(0);
                                case 10:
                                    return e.abrupt("return", S.Unknown);
                                case 11:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [0, 8]
                        ])
                    }))), function() {
                        return r.apply(this, arguments)
                    }),
                    A = (a = h()(f().mark((function e() {
                        var t, i, n = arguments;
                        return f().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (t = n.length > 0 && void 0 !== n[0] ? n[0] : 0, i = {
                                            serviceExePath: (0, y.join)(D(), "clash-core-service.exe"),
                                            winswExePath: (0, y.join)(D(), "service.exe"),
                                            configPath: (0, y.join)(D(), "../../common/service.yml"),
                                            schtaskConfigPath: (0, y.join)(D(), "../../common/schtasks.xml")
                                        }, 0 !== t) {
                                        e.next = 5;
                                        break
                                    }
                                    return e.next = 5, T([{
                                        cmd: "create",
                                        options: ['/ru "SYSTEM"', '/xml "'.concat((0, y.join)(L, "schtasks.xml"), '"')]
                                    }, {
                                        cmd: "change",
                                        options: ['/tr "\\"'.concat((0, y.join)(L, "clash-core-service.exe"), '\\""')]
                                    }, {
                                        cmd: "run"
                                    }], {
                                        runBefore: 'mkdir "'.concat(L, '" & copy "').concat(i.serviceExePath, '" "').concat(L, '" /Y & copy "').concat(i.schtaskConfigPath, '" "').concat(L, '" /Y ')
                                    });
                                case 5:
                                    if (1 !== t) {
                                        e.next = 8;
                                        break
                                    }
                                    return e.next = 8, E([{
                                        cmd: "install"
                                    }, {
                                        cmd: "start"
                                    }], {
                                        runBefore: 'mkdir "'.concat(L, '" & copy "').concat(i.serviceExePath, '" "').concat(L, '" /Y & copy "').concat(i.winswExePath, '" "').concat(L, '" /Y & copy "').concat(i.configPath, '" "').concat(L, '" /Y ')
                                    });
                                case 8:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return a.apply(this, arguments)
                    }),
                    O = (l = h()(f().mark((function e() {
                        var t, i;
                        return f().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (t = {
                                            serviceExePath: (0, y.join)(D(), "clash-core-service.exe"),
                                            winswExePath: (0, y.join)(D(), "service.exe"),
                                            configPath: (0, y.join)(D(), "../../common/service.yml")
                                        }, i = (0, y.join)(v.Z.state.app.clashPath, "service"), !P()) {
                                        e.next = 7;
                                        break
                                    }
                                    return e.next = 5, I([{
                                        cmd: "stop"
                                    }, {
                                        cmd: "uninstall"
                                    }], {
                                        runAfter: 'icacls.exe "'.concat(i, '" /remove:d Everyone & rmdir /s /q "').concat(i, '"')
                                    });
                                case 5:
                                case 10:
                                    e.next = 14;
                                    break;
                                case 7:
                                    if (!(0, C.existsSync)((0, y.join)(L, "schtasks.xml"))) {
                                        e.next = 12;
                                        break
                                    }
                                    return e.next = 10, T([{
                                        cmd: "end"
                                    }, {
                                        cmd: "delete",
                                        options: ["/F"]
                                    }], {
                                        runAfter: 'timeout /t 2 & rmdir "'.concat(L, '" /s /q')
                                    });
                                case 12:
                                    return e.next = 14, E([{
                                        cmd: "stop"
                                    }, {
                                        cmd: "uninstall"
                                    }], {
                                        runBefore: 'copy "'.concat(t.configPath, '" "').concat(L, '" /Y '),
                                        runAfter: 'timeout /t 2 & rmdir "'.concat(L, '" /s /q')
                                    });
                                case 14:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return l.apply(this, arguments)
                    }),
                    P = function() {
                        var e = (0, y.join)(v.Z.state.app.clashPath, "service"),
                            t = (0, y.join)(e, "service.yml"),
                            i = (0, y.join)(e, "service.exe");
                        return (0, C.existsSync)(e) && (0, C.existsSync)(t) && (0, C.existsSync)(i)
                    },
                    R = function() {
                        if (P()) return !0;
                        if (!(0, C.existsSync)(L)) return !1;
                        var e = (0, y.join)(L, "clash-core-service.exe");
                        if (!(0, C.existsSync)(e)) return !1;
                        var t = (0, y.join)(D(), "clash-core-service.exe"),
                            i = function(e) {
                                return (0, x.Ll)((0, C.readFileSync)(e))
                            };
                        return i(e) !== i(t)
                    },
                    F = (c = h()(f().mark((function e() {
                        var t;
                        return f().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return t = (0, C.existsSync)((0, y.join)(L, "schtasks.xml")) ? 0 : 1, e.next = 3, O();
                                case 3:
                                    return e.next = 5, A(t);
                                case 5:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function() {
                        return c.apply(this, arguments)
                    })
            },
            58511: (e, t, i) => {
                "use strict";
                i.d(t, {
                    S: () => c
                });
                var n = i(63038),
                    o = i.n(n),
                    s = i(32081),
                    r = i(83566);

                function a(e, t) {
                    var i = "undefined" != typeof Symbol && e[Symbol.iterator] || e["@@iterator"];
                    if (!i) {
                        if (Array.isArray(e) || (i = function(e, t) {
                                if (!e) return;
                                if ("string" == typeof e) return l(e, t);
                                var i = Object.prototype.toString.call(e).slice(8, -1);
                                "Object" === i && e.constructor && (i = e.constructor.name);
                                if ("Map" === i || "Set" === i) return Array.from(e);
                                if ("Arguments" === i || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)) return l(e, t)
                            }(e)) || t && e && "number" == typeof e.length) {
                            i && (e = i);
                            var n = 0,
                                o = function() {};
                            return {
                                s: o,
                                n: function() {
                                    return n >= e.length ? {
                                        done: !0
                                    } : {
                                        done: !1,
                                        value: e[n++]
                                    }
                                },
                                e: function(e) {
                                    throw e
                                },
                                f: o
                            }
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }
                    var s, r = !0,
                        a = !1;
                    return {
                        s: function() {
                            i = i.call(e)
                        },
                        n: function() {
                            var e = i.next();
                            return r = e.done, e
                        },
                        e: function(e) {
                            a = !0, s = e
                        },
                        f: function() {
                            try {
                                r || null == i.return || i.return()
                            } finally {
                                if (a) throw s
                            }
                        }
                    }
                }

                function l(e, t) {
                    (null == t || t > e.length) && (t = e.length);
                    for (var i = 0, n = new Array(t); i < t; i++) n[i] = e[i];
                    return n
                }
                var c = function() {
                    if ((0, r.Kr)() || (0, r.V5)()) {
                        var e, t = (0, r.Kr)() ? "chcp 65001 && netsh wlan show interfaces" : "/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport --getinfo",
                            i = (0, s.execSync)(t).toString().split("\n"),
                            n = [],
                            l = {},
                            c = a(i.entries());
                        try {
                            for (c.s(); !(e = c.n()).done;) {
                                var d = o()(e.value, 2),
                                    h = d[0],
                                    u = d[1].split(": "),
                                    g = o()(u, 2),
                                    p = g[0],
                                    f = g[1];
                                if (p && f) {
                                    var m = p.trim(),
                                        v = f.trim();
                                    if (!m || !v) continue;
                                    m in l && (n.push(l), l = {}), l[m] = v
                                }
                                h === i.length - 1 && (n.push(l), l = {})
                            }
                        } catch (e) {
                            c.e(e)
                        } finally {
                            c.f()
                        }
                        return n
                    }
                    return []
                }
            },
            19102: (e, t, i) => {
                "use strict";
                i.d(t, {
                    p: () => f
                });
                var n, o = i(59713),
                    s = i.n(o),
                    r = i(48926),
                    a = i.n(r),
                    l = i(87757),
                    c = i.n(l),
                    d = i(59273),
                    h = i(83566),
                    u = i(54387),
                    g = i.n(u),
                    p = i(71017),
                    f = (n = a()(c().mark((function e() {
                        var t, i, n, o, r, a, l, u, f = arguments;
                        return c().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    if (i = f.length > 0 && void 0 !== f[0] ? f[0] : [], (0, h.V5)()) {
                                        e.next = 3;
                                        break
                                    }
                                    return e.abrupt("return", !1);
                                case 3:
                                    return n = d.Z.state.app.isDevMode ? (0, p.join)((0, p.resolve)("./"), "/static/files") : d.Z.getters.filesPath, o = (t = {}, s()(t, h.UD, "arm64"), s()(t, h.Ml, "x64"), t)[(0, h.Vk)()], r = (0, p.join)(n, "darwin", o), e.prev = 6, e.next = 9, g().post("http://127.0.0.1:53000/command", {
                                        path: (0, p.join)(r, "sysproxy"),
                                        args: i
                                    });
                                case 9:
                                    return a = e.sent, l = a.status, u = a.data, e.abrupt("return", {
                                        success: 200 === l,
                                        output: u
                                    });
                                case 15:
                                    e.prev = 15, e.t0 = e.catch(6);
                                case 17:
                                    return e.abrupt("return", {
                                        success: !1,
                                        data: ""
                                    });
                                case 18:
                                case "end":
                                    return e.stop()
                            }
                        }), e, null, [
                            [6, 15]
                        ])
                    }))), function() {
                        return n.apply(this, arguments)
                    })
            },
            84695: (e, t, i) => {
                "use strict";
                i.d(t, {
                    _: () => m
                });
                var n, o, s = i(48926),
                    r = i.n(s),
                    a = i(87757),
                    l = i.n(a),
                    c = i(83566),
                    d = i(32081),
                    h = i(71017),
                    u = i(59273),
                    g = i(72298),
                    p = (i(54387), "cfw-update".concat((0, c.V5)() ? ".dmg" : ".exe")),
                    f = (n = r()(l().mark((function e(t) {
                        var i, n;
                        return l().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2, g.ipcRenderer.invoke("app", "getPath", "temp");
                                case 2:
                                    return i = e.sent, n = (0, h.join)(i, p), e.next = 6, g.ipcRenderer.invoke("start-download", t, n);
                                case 6:
                                    return u.Z.commit("SET_UPDATE_DOWNLOAD_PROGRESS", {
                                        progress: .01
                                    }), e.next = 9, new Promise((function(e, t) {
                                        g.ipcRenderer.on("download", (function(i, o, s) {
                                            "downloading" === o && u.Z.commit("SET_UPDATE_DOWNLOAD_PROGRESS", {
                                                progress: s
                                            }), "completed" === o && (u.Z.commit("SET_UPDATE_DOWNLOAD_PROGRESS", {
                                                progress: null
                                            }), e(n)), "failed" === o && (u.Z.commit("SET_UPDATE_DOWNLOAD_PROGRESS", {
                                                progress: null
                                            }), t(s))
                                        }))
                                    }));
                                case 9:
                                    return e.abrupt("return", e.sent);
                                case 10:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e) {
                        return n.apply(this, arguments)
                    }),
                    m = (o = r()(l().mark((function e(t, i) {
                        var n, o, s, r;
                        return l().wrap((function(e) {
                            for (;;) switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2, f(t);
                                case 2:
                                    if (n = e.sent) {
                                        e.next = 5;
                                        break
                                    }
                                    return e.abrupt("return");
                                case 5:
                                    return e.next = 7, g.ipcRenderer.invoke("app", "getName");
                                case 7:
                                    return o = e.sent, (0, c.V5)() && (s = (0, d.execSync)("hdiutil attach '".concat(n, "' -nobrowse")), /\/Volumes\/(Clash for Windows.+?)\n/.test(s) && (r = RegExp.$1, (0, d.execSync)("rm -rf '/Applications/".concat(o, ".app' && cp -R '/Volumes/").concat(r, "/").concat(o, ".app' '/Applications/").concat(o, ".app'")), (0, d.execSync)("hdiutil eject '/Volumes/".concat(r, "'"), {
                                        stdio: ["ignore", "ignore", "ignore"]
                                    }))), e.abrupt("return", n);
                                case 10:
                                case "end":
                                    return e.stop()
                            }
                        }), e)
                    }))), function(e, t) {
                        return o.apply(this, arguments)
                    })
            },
            8359: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => n
                });
                const n = (0, i(83566).V5)() ? ["127.0.0.1", "192.168.0.0/16", "10.0.0.0/8", "172.16.0.0/12", "100.64.0.0/10", "17.0.0.0/8", "localhost", "*.local", "169.254.0.0/16", "224.0.0.0/4", "240.0.0.0/4"] : ["localhost", "127.*", "10.*", "172.16.*", "172.17.*", "172.18.*", "172.19.*", "172.20.*", "172.21.*", "172.22.*", "172.23.*", "172.24.*", "172.25.*", "172.26.*", "172.27.*", "172.28.*", "172.29.*", "172.30.*", "172.31.*", "192.168.*", "<local>"]
            },
            10870: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => n
                });
                const n = 'function FindProxyForURL(url, host) {\n  return "PROXY 127.0.0.1:%mixed-port%; SOCKS5 127.0.0.1:%mixed-port%; DIRECT;"\n}'
            },
            83566: (e, t, i) => {
                "use strict";
                i.d(t, {
                    $Q: () => g,
                    Ap: () => o,
                    IJ: () => m,
                    J4: () => n,
                    Kr: () => p,
                    Ml: () => a,
                    UD: () => l,
                    V5: () => f,
                    Vk: () => u,
                    Vm: () => r,
                    bV: () => c,
                    tU: () => d
                });
                var n = Symbol(),
                    o = Symbol(),
                    s = Symbol(),
                    r = Symbol(),
                    a = Symbol(),
                    l = Symbol(),
                    c = Symbol(),
                    d = Symbol(),
                    h = Symbol(),
                    u = function() {
                        if ("win32" === process.platform) {
                            if ("x64" === process.arch) return n;
                            if ("ia32" === process.arch) return o;
                            if ("arm" === process.arch) return s;
                            if ("arm64" === process.arch) return r
                        }
                        if ("darwin" === process.platform) {
                            if ("x64" === process.arch) return a;
                            if ("arm64" === process.arch) return l
                        }
                        if ("linux" === process.platform) {
                            if ("x64" === process.arch) return c;
                            if ("arm64" === process.arch) return d
                        }
                        return h
                    },
                    g = function() {
                        var e = u();
                        return [o, s].includes(e) ? o : e
                    },
                    p = function() {
                        return [s, r, o, n].includes(u())
                    },
                    f = function() {
                        return [a, l].includes(u())
                    },
                    m = function() {
                        return [c, d].includes(u())
                    }
            },
            33182: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => o,
                    r: () => n
                });
                var n = {
                        INIT: Symbol(),
                        DEFAULT: Symbol(),
                        SYSTEM_PROXY: Symbol()
                    },
                    o = {
                        CONNECTED: Symbol(),
                        DISCONNECTED: Symbol()
                    }
            },
            81518: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => n
                });
                const n = {
                    SYSTEM_PROXY: "systemProxy",
                    LAST_CLASH_PID: "lastClashPID",
                    LAST_USER_EXE_PIDS: "lastUserExePids",
                    LAST_LOG_FILE_PATH: "lastLogFilePath",
                    AD_IMAGES: "adImages",
                    CONNECTION_ORDER_INDEX: "connectionOrderIndex",
                    CONNECTION_ORDER_REVERSE_TAGS: "connectionOrderReverseTags",
                    AUTO_LAUNCH: "autoLaunch",
                    GEOIP_URL: "geoipDownloadRawURL",
                    GEOIP_TOKEN: "geoipDownloadToken",
                    TAP_INFO: "tapInfo",
                    PROXY_SHOW_SEC_IDXS: "proxyShowSecIdxs",
                    PROXY_HIDE_TIMEOUT_SEC_NAMES: "proxyHideTimeoutSecNames",
                    PROXY_FILTER_KEYWORD: "proxyFilterKeyword",
                    IS_PIN_ENABLED: "isPinEnabled",
                    MENU_ITEM_ORDER: "menuItemOrder",
                    CURRENT_ROUTE_PATH: "currentRoutePath",
                    DETECTED_INTERFACE_NAME: "detectedInterfaceName",
                    SYSTEM_PROXY_COMMAND: "systemProxyCommand",
                    IS_DIFF_EIDTOR_SEPARATED: "isDiffEditorSeparated",
                    IS_LIGHTWEIGHT_MODE_CLOSE: "isLightweightModeClose",
                    IS_MIXIN: "isProfileMixin",
                    LAST_VERSION_CODE: "lastVersionCode",
                    ROUTER_HIJACK_MAC_ADDRESSES: "routerHijackMacAddresses",
                    DHCP_MAC_ALIAS: "dhcpMacAlias",
                    TUN_SETTINGS: "tunSettings",
                    IS_TUN: "isTunEnabled",
                    LOG_MOUDLE_LEVEL: "logModuleLevel",
                    LOG_MODULE_STYLE: "logModuleStyle",
                    LOG_MODULE_SEARCH_TEXT: "logModuleSearchText",
                    CONNECTION_MODULE_SEARCH_TEXT: "connectionModuleSearchText",
                    TEST_SCRIPT_CONTENT: "testScriptContent"
                }
            },
            59273: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => a
                });
                var n = i(70538),
                    o = i(23321),
                    s = i.n(o),
                    r = i(11068);
                n.ZP.use(s());
                const a = new(s().Store)({
                    modules: r.default,
                    strict: !1,
                    plugins: [function(e) {
                        e.subscribe((function(t) {
                            ["CHANGE_PROFILES", "CHANGE_PROFILES_INDEX", "CHANGE_PROFILE", "APPEND_PROFILE", "DELETE_PROFILE"].includes(t.type) && e.commit("SAVE_PROFILES")
                        }))
                    }]
                })
            },
            23726: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => F
                });
                var n = i(48926),
                    o = i.n(n),
                    s = i(319),
                    r = i.n(s),
                    a = i(59713),
                    l = i.n(a),
                    c = i(63038),
                    d = i.n(c),
                    h = i(87757),
                    u = i.n(h),
                    g = i(57147),
                    p = i.n(g),
                    f = i(11442),
                    m = i.n(f),
                    v = i(71017),
                    _ = i.n(v),
                    b = i(54387),
                    w = i.n(b),
                    y = i(71893),
                    C = i.n(y),
                    x = i(24793),
                    S = i.n(x),
                    k = i(56796),
                    L = i(33182),
                    N = i(24883),
                    D = i(81518),
                    I = i(83566),
                    E = function(e, t) {
                        var i, n = null !== (i = N.Z.get(D.Z.MENU_ITEM_ORDER)) && void 0 !== i ? i : [],
                            o = n.findIndex((function(t) {
                                return t === e.title
                            }));
                        return -1 === o ? 1 : o - n.findIndex((function(e) {
                            return e === t.title
                        }))
                    },
                    T = i(72298);

                function M(e, t) {
                    var i = Object.keys(e);
                    if (Object.getOwnPropertySymbols) {
                        var n = Object.getOwnPropertySymbols(e);
                        t && (n = n.filter((function(t) {
                            return Object.getOwnPropertyDescriptor(e, t).enumerable
                        }))), i.push.apply(i, n)
                    }
                    return i
                }

                function A(e) {
                    for (var t = 1; t < arguments.length; t++) {
                        var i = null != arguments[t] ? arguments[t] : {};
                        t % 2 ? M(Object(i), !0).forEach((function(t) {
                            l()(e, t, i[t])
                        })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(i)) : M(Object(i)).forEach((function(t) {
                            Object.defineProperty(e, t, Object.getOwnPropertyDescriptor(i, t))
                        }))
                    }
                    return e
                }
                var O = {
                        mixedPort: function(e) {
                            return e.confData["mixed-port"] || 0
                        },
                        controllerPort: function(e) {
                            var t = e.confData["external-controller"];
                            if (t) {
                                var i = t.split(":"),
                                    n = d()(i, 2),
                                    o = (n[0], n[1]);
                                return parseInt(o.trim()) || 0
                            }
                            return 0
                        },
                        secret: function(e) {
                            var t = e.confData.secret,
                                i = void 0 === t ? "" : t;
                            return i
                        },
                        clashAxiosClient: function(e, t) {
                            var i = t.controllerPort,
                                n = t.secret;
                            return i > 0 ? w().create({
                                baseURL: "http://127.0.0.1:".concat(i, "/"),
                                timeout: 5e3,
                                headers: {
                                    Authorization: "Bearer ".concat(n)
                                }
                            }) : null
                        },
                        clashGotClient: function(e, t) {
                            var i = t.controllerPort,
                                n = t.secret;
                            return i > 0 ? C().extend({
                                baseUrl: "http://127.0.0.1:".concat(i),
                                headers: {
                                    Authorization: "Bearer ".concat(n)
                                }
                            }) : null
                        },
                        clashWSClient: function(e, t) {
                            return function(e) {
                                var i = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : [],
                                    n = t.controllerPort,
                                    o = t.secret;
                                if (n > 0) {
                                    /^\//.test(e) || (e = "/" + e);
                                    var s = "ws://127.0.0.1:".concat(n).concat(e, "?token=").concat(o).concat(i.length > 0 ? "&".concat(i.join("&")) : "");
                                    return new k(s)
                                }
                                return null
                            }
                        },
                        resourcesPath: function(e) {
                            return e.isDevMode ? "" : "" !== e.exePath ? _().join(_().dirname(e.exePath), (0, I.V5)() ? "../Resources" : "./resources") : ""
                        },
                        filesPath: function(e, t) {
                            return "" !== t.resourcesPath ? _().join(t.resourcesPath, "static/files") : "static/files"
                        },
                        clashBinaryPath: function(e, t) {
                            var i, n, o = (i = {}, l()(i, I.Ap, _().join(t.filesPath, "win", "ia32")), l()(i, I.J4, _().join(t.filesPath, "win", "x64")), l()(i, I.Vm, _().join(t.filesPath, "win", "arm64")), l()(i, I.Ml, _().join(t.filesPath, "darwin", "x64")), l()(i, I.UD, _().join(t.filesPath, "darwin", "arm64")), l()(i, I.bV, _().join(t.filesPath, "linux", "x64")), l()(i, I.tU, _().join(t.filesPath, "linux", "arm64")), i)[(0, I.$Q)()],
                                s = (n = {}, l()(n, I.Ap, "clash-win32.exe"), l()(n, I.J4, "clash-win64.exe"), l()(n, I.Vm, "clash-win-arm64.exe"), l()(n, I.Ml, "./clash-darwin"), l()(n, I.UD, "./clash-darwin"), l()(n, I.bV, "./clash-linux"), l()(n, I.tU, "./clash-linux"), n)[(0, I.$Q)()];
                            return _().join(o, s)
                        },
                        theme: function(e) {
                            if (0 === Object.keys(e.settings).length) return "unknown";
                            if (e.settings) {
                                var t = e.settings,
                                    i = t.theme,
                                    n = void 0 === i ? 0 : i,
                                    o = t.systemTheme;
                                return void 0 !== o && o ? e.shouldUseDarkTheme ? "dark" : "light" : ["light", "dark", "mc", "2077"][n]
                            }
                            return "light"
                        },
                        menuItemsWithOrder: function(e) {
                            return r()(e.menuItems).sort(E)
                        },
                        fontFamily: function(e) {
                            var t = e.settings,
                                i = t.fontFamily,
                                n = void 0 === i ? "" : i,
                                o = t.useSystemEmoji,
                                s = void 0 !== o && o,
                                r = n.split(",").map((function(e) {
                                    return '"'.concat(S().trim(e, ' "'), '"')
                                })),
                                a = "".concat(r.join(","), ', "Microsoft Yahei", "PingFang SC", "system-ui", 微软雅黑');
                            return s ? a : "".concat(a, ', "TwemojiMozilla"')
                        }
                    },
                    P = {
                        SET_IS_DEV_MODE: function(e, t) {
                            var i = t.isDevMode;
                            e.isDevMode = i, i && (e.isWindowShow = !0)
                        },
                        CHANGE_IS_MIXIN_ENABLE: function(e, t) {
                            var i = t.isMixin;
                            modifyState.isMixin = i, "" === e.matchedSSID && N.Z.put(D.Z.IS_MIXIN, i);
                            e.isMixinEnable = i, "" === e.matchedSSID && N.Z.put(D.Z.IS_MIXIN, i)
                        },
                        SET_CLASH_PATH: function(e, t) {
                            var i = t.path;
                            e.clashPath = _().normalize(i)
                        },
                        SET_CLASH_STATUS: function(e, t) {
                            var i = t.status;
                            i !== L.Z.CONNECTED && i !== L.Z.DISCONNECTED || (e.clashStatus = i)
                        },
                        SET_PROFILES_PATH: function(e, t) {
                            var i = t.path;
                            e.profilesPath = _().normalize(i)
                        },
                        SET_CONF_DATA: function(e, t) {
                            var i = t.data;
                            e.confData = i
                        },
                        LOAD_PROFILES: function(e) {
                            var t = p().readFileSync(_().join(e.profilesPath, "list.yml"), "utf8"),
                                i = m().parse(t, {
                                    merge: !0,
                                    schema: "yaml-1.1"
                                }),
                                n = i.files,
                                o = i.index;
                            e.profiles = {
                                files: n,
                                index: o
                            }
                        },
                        SAVE_PROFILES: function(e) {
                            p().writeFileSync(_().join(e.profilesPath, "list.yml"), m().stringify(e.profiles))
                        },
                        CHANGE_PROFILES: function(e, t) {
                            var i = t.profiles;
                            e.profiles = A(A({}, e.profiles), {}, {
                                files: i
                            })
                        },
                        CHANGE_PROFILES_INDEX: function(e, t) {
                            var i = t.index;
                            e.profiles = A(A({}, e.profiles), {}, {
                                index: i
                            })
                        },
                        CHANGE_PROFILE: function(e, t) {
                            var i = t.index,
                                n = t.profile;
                            if (n) {
                                var o = e.profiles.files.slice();
                                o[i] = n, e.profiles = A(A({}, e.profiles), {}, {
                                    files: o
                                })
                            }
                        },
                        DELETE_PROFILE: function(e, t) {
                            var i = t.index,
                                n = e.profiles.files.slice();
                            n.splice(i, 1), e.profiles = A(A({}, e.profiles), {}, {
                                files: n
                            })
                        },
                        APPEND_PROFILE: function(e, t) {
                            var i = t.profile,
                                n = e.profiles.files,
                                o = void 0 === n ? [] : n;
                            i && (e.profiles = A(A({}, e.profiles), {}, {
                                files: [].concat(r()(o), [i])
                            }))
                        },
                        SET_LOG_FILE_PATH: function(e, t) {
                            var i = t.path,
                                n = _().normalize(i);
                            e.logFilePath = n, N.Z.put(D.Z.LAST_LOG_FILE_PATH, n)
                        },
                        SET_EXE_PATH: function(e, t) {
                            var i = t.path;
                            e.exePath = _().normalize(i)
                        },
                        APPEND_ERROR: function(e, t) {
                            var i = t.error;
                            e.errors = [].concat(r()(e.errors), [i])
                        },
                        CHANGE_STATUS: function(e, t) {
                            var i = t.status;
                            e.status = i
                        },
                        ADD_AXIOS_FLYING_REQUEST_COUNT: function(e, t) {
                            var i = t.count;
                            e.clashAxiosFlyingRequestCount += i
                        },
                        SET_SETTINGS_OBJECT: function(e, t) {
                            var i = t.obj;
                            e.settings = i
                        },
                        SAVE_SETTINGS_OBJECT: function(e, t) {
                            var i = t.obj;
                            e.settings = i, p().writeFileSync(_().join(e.clashPath, "cfw-settings.yaml"), m().stringify(i))
                        },
                        SET_SHOULD_USE_DARK_THEME: function(e, t) {
                            var i = t.shouldUseDarkTheme;
                            e.shouldUseDarkTheme = i
                        },
                        SET_DETECTED_INTERFACE_NAME: function(e, t) {
                            var i = t.interfaceName;
                            e.detectedInterfaceName = i, N.Z.put(D.Z.DETECTED_INTERFACE_NAME, i)
                        },
                        SET_IS_WINDOW_SHOW: function(e, t) {
                            var i = t.isShow;
                            e.isWindowShow = i
                        },
                        SET_IS_APP_SUSPEND: function(e, t) {
                            var i = t.isSuspend;
                            e.isAppSuspend = i
                        },
                        SET_INNER_SERVER_PORT: function(e, t) {
                            var i = t.port;
                            e.innerServerPort = i
                        },
                        SET_IS_LOCAL_MODE: function(e, t) {
                            var i = t.isLocal;
                            e.isLocalMode = i
                        },
                        SET_IS_LAUNCHING: function(e, t) {
                            var i = t.isLaunching;
                            e.isLaunching = i
                        },
                        SET_MENU_ITEMS: function(e, t) {
                            var i = t.items;
                            e.menuItems = i
                        },
                        SET_UPDATE_DOWNLOAD_PROGRESS: function(e, t) {
                            var i = t.progress;
                            e.updateDownloadProgress = i
                        },
                        SET_IS_SYSTEM_PROXY_ON: function(e, t) {
                            var i = t.isOn;
                            e.isSystemProxyOn = i, "" === e.matchedSSID && N.Z.put(D.Z.SYSTEM_PROXY, i)
                        },
                        SET_IS_SUB_VIEW_SHOW: function(e, t) {
                            t.isShow ? e.isSubViewShow = !0 : setTimeout((function() {
                                e.isSubViewShow = !1
                            }), 50)
                        },
                        SET_CURRENT_ROUTE_PATH: function(e, t) {
                            var i = t.path;
                            e.currentRoutePath = i, N.Z.put(D.Z.CURRENT_ROUTE_PATH, i)
                        },
                        ADD_PROFILE_REFRESH_TIMES: function(e, t) {
                            var i = t.times,
                                n = void 0 === i ? 1 : i;
                            e.profileRefreshTimes += n
                        },
                        CHANGE_MODE: function(e, t) {
                            var i = t.mode;
                            ["direct", "rule", "global", "script"].includes(i) && (e.mode = i)
                        },
                        SET_ROUTER_HIJACK_MAC_ADDRESSES: function(e, t) {
                            var i = t.addresses;
                            e.routerHijackMacAddresses = i, N.Z.put(D.Z.ROUTER_HIJACK_MAC_ADDRESSES, i)
                        },
                        SET_CURRENT_PROFILE_PAYLOAD: function(e, t) {
                            var i = t.payload;
                            e.currentProfilePayload = i
                        },
                        SET_IS_SILENT_UPGRADED: function(e, t) {
                            var i = t.isUpgraded;
                            e.isSilentUpgraded = i
                        },
                        SET_TUN_SETTINGS: function(e, t) {
                            var i = t.settings;
                            e.tunSettings = i, N.Z.put(D.Z.TUN_SETTINGS, i)
                        },
                        CHANGE_IS_TUN_ENABLE: function(e, t) {
                            var i = t.isTun;
                            modifyState.isTun = i, "" === e.matchedSSID && N.Z.put(D.Z.IS_TUN, i);
                            e.isTunEnable = i, "" === e.matchedSSID && N.Z.put(D.Z.IS_TUN, i)
                        },
                        SET_IS_FIREWALL_RULE_EXIST: function(e, t) {
                            var i = t.isExist;
                            e.isFirewallRuleExist = i
                        },
                        SET_USER_DNS: function(e, t) {
                            var i = t.dns;
                            e.userDNS = i
                        },
                        SET_MATCHED_SSID: function(e, t) {
                            var i = t.ssid;
                            e.matchedSSID = i
                        }
                    },
                    R = {
                        getMode: function(e) {
                            return o()(u().mark((function t() {
                                var i, n, o, s, r, a, l;
                                return u().wrap((function(t) {
                                    for (;;) switch (t.prev = t.next) {
                                        case 0:
                                            if (i = e.commit, n = e.getters, !(o = n.clashAxiosClient)) {
                                                t.next = 9;
                                                break
                                            }
                                            return t.next = 5, o.get("/configs").catch((function(e) {}));
                                        case 5:
                                            s = t.sent, r = s.status, a = s.data, 200 === r && (l = a.mode, i("CHANGE_MODE", {
                                                mode: l
                                            }));
                                        case 9:
                                        case "end":
                                            return t.stop()
                                    }
                                }), t)
                            })))()
                        },
                        setMode: function(e, t) {
                            return o()(u().mark((function i() {
                                var n, o, s, r, a;
                                return u().wrap((function(i) {
                                    for (;;) switch (i.prev = i.next) {
                                        case 0:
                                            if (n = e.commit, o = e.getters, s = t.mode, !(r = o.clashAxiosClient)) {
                                                i.next = 9;
                                                break
                                            }
                                            return i.next = 6, r.patch("/configs", {
                                                mode: s
                                            }).catch((function(e) {}));
                                        case 6:
                                            a = i.sent, 204 === a.status && n("CHANGE_MODE", {
                                                mode: s
                                            });
                                        case 9:
                                        case "end":
                                            return i.stop()
                                    }
                                }), i)
                            })))()
                        },
                        getParserLogPath: function() {
                            return o()(u().mark((function e() {
                                var t;
                                return u().wrap((function(e) {
                                    for (;;) switch (e.prev = e.next) {
                                        case 0:
                                            return e.next = 2, T.ipcRenderer.invoke("app", "getPath", "temp");
                                        case 2:
                                            return t = e.sent, e.abrupt("return", _().join(t, "cfw-parser.log"));
                                        case 4:
                                        case "end":
                                            return e.stop()
                                    }
                                }), e)
                            })))()
                        },
                        getScriptLogPath: function() {
                            return o()(u().mark((function e() {
                                var t;
                                return u().wrap((function(e) {
                                    for (;;) switch (e.prev = e.next) {
                                        case 0:
                                            return e.next = 2, T.ipcRenderer.invoke("app", "getPath", "temp");
                                        case 2:
                                            return t = e.sent, e.abrupt("return", _().join(t, "cfw-script.log"));
                                        case 4:
                                        case "end":
                                            return e.stop()
                                    }
                                }), e)
                            })))()
                        }
                    };
                const Lg = new Language(i(24883).Z.get(LANGUAGE));
                if (modifyState.language === -1) {
                    modifyState.language = i(24883).Z.get(LANGUAGE) === null ? 0 : i(24883).Z.get(LANGUAGE)
                    require("electron").ipcRenderer.invoke("cfw-language", modifyState.language)
                    modifyState.isTun = N.Z.get(D.Z.IS_TUN)
                    modifyState.isMixin = N.Z.get(D.Z.IS_MIXIN)
                }
                const F = {
                    state: {
                        isDevMode: !1,
                        clashPath: "",
                        clashStatus: L.Z.DISCONNECTED,
                        profilesPath: "",
                        profiles: {},
                        confData: {},
                        logFilePath: N.Z.get(D.Z.LAST_LOG_FILE_PATH) || "",
                        isMixinEnable: N.Z.get(D.Z.IS_MIXIN) || !1,
                        exePath: "",
                        errors: [],
                        status: L.r.INIT,
                        clashAxiosFlyingRequestCount: 0,
                        settings: {},
                        shouldUseDarkTheme: !1,
                        detectedInterfaceName: N.Z.get(D.Z.DETECTED_INTERFACE_NAME) || "",
                        isWindowShow: !1,
                        isAppSuspend: !1,
                        innerServerPort: 0,
                        isLocalMode: !0,
                        isLaunching: !0,
                        menuItems: [{
                            title: Lg.general(),
                            path: "/home/general"
                        }, {
                            title: Lg.proxies(),
                            path: "/home/proxy"
                        }, {
                            title: Lg.profiles(),
                            path: "/home/server"
                        }, {
                            title: Lg.logs(),
                            path: "/home/log"
                        }, {
                            title: Lg.connections(),
                            path: "/home/connection"
                        }, {
                            title: Lg.settings(),
                            path: "/home/setting"
                        }, {
                            title: Lg.feedback(),
                            path: "/home/about"
                        }],
                        updateDownloadProgress: null,
                        isSystemProxyOn: N.Z.get(D.Z.SYSTEM_PROXY) || !1,
                        isSubViewShow: !1,
                        currentRoutePath: N.Z.get(D.Z.CURRENT_ROUTE_PATH) || "/home/general",
                        profileRefreshTimes: 0,
                        mode: "rule",
                        routerHijackMacAddresses: N.Z.get(D.Z.ROUTER_HIJACK_MAC_ADDRESSES) || [],
                        currentProfilePayload: {},
                        isSilentUpgraded: !1,
                        tunSettings: N.Z.get(D.Z.TUN_SETTINGS),
                        isTunEnable: N.Z.get(D.Z.IS_TUN) || !1,
                        isFirewallRuleExist: !1,
                        userDNS: null,
                        matchedSSID: ""
                    },
                    getters: O,
                    mutations: P,
                    actions: R
                }
            },
            11068: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => s
                });
                var n = i(54265),
                    o = {};
                n.keys().forEach((function(e) {
                    "./index.js" !== e && (o[e.replace(/(\.\/|\.js)/g, "")] = n(e).default)
                }));
                const s = o
            },
            546: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar {\n\twhite-space: nowrap;\n\theight: 100%;\n}\n\n.monaco-action-bar .actions-container {\n\tdisplay: flex;\n\tmargin: 0 auto;\n\tpadding: 0;\n\theight: 100%;\n\twidth: 100%;\n\talign-items: center;\n}\n\n.monaco-action-bar.vertical .actions-container {\n\tdisplay: inline-block;\n}\n\n.monaco-action-bar .action-item {\n\tdisplay: block;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: pointer;\n\tposition: relative;  /* DO NOT REMOVE - this is the key to preventing the ghosting icon bug in Chrome 42 */\n}\n\n.monaco-action-bar .action-item.disabled {\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item .icon,\n.monaco-action-bar .action-item .codicon {\n\tdisplay: block;\n}\n\n.monaco-action-bar .action-item .codicon {\n\tdisplay: flex;\n\talign-items: center;\n\twidth: 16px;\n\theight: 16px;\n}\n\n.monaco-action-bar .action-label {\n\tfont-size: 11px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n}\n\n.monaco-action-bar .action-item.disabled .action-label,\n.monaco-action-bar .action-item.disabled .action-label::before,\n.monaco-action-bar .action-item.disabled .action-label:hover {\n\topacity: 0.4;\n}\n\n/* Vertical actions */\n\n.monaco-action-bar.vertical {\n\ttext-align: left;\n}\n\n.monaco-action-bar.vertical .action-item {\n\tdisplay: block;\n}\n\n.monaco-action-bar.vertical .action-label.separator {\n\tdisplay: block;\n\tborder-bottom: 1px solid #bbb;\n\tpadding-top: 1px;\n\tmargin-left: .8em;\n\tmargin-right: .8em;\n}\n\n.monaco-action-bar .action-item .action-label.separator {\n\twidth: 1px;\n\theight: 16px;\n\tmargin: 5px 4px !important;\n\tcursor: default;\n\tmin-width: 1px;\n\tpadding: 0;\n\tbackground-color: #bbb;\n}\n\n.secondary-actions .monaco-action-bar .action-label {\n\tmargin-left: 6px;\n}\n\n/* Action Items */\n.monaco-action-bar .action-item.select-container {\n\toverflow: hidden; /* somehow the dropdown overflows its container, we prevent it here to not push */\n\tflex: 1;\n\tmax-width: 170px;\n\tmin-width: 60px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tmargin-right: 10px;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item {\n\tdisplay: flex;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item > .action-label {\n\tmargin-right: 1px;\n}\n", ""]);
                const a = r
            },
            96513: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-aria-container {\n\tposition: absolute; /* try to hide from window but not from screen readers */\n\tleft:-999em;\n}", ""]);
                const a = r
            },
            71470: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-text-button {\n\tbox-sizing: border-box;\n\tdisplay: flex;\n\twidth: 100%;\n\tpadding: 4px;\n\ttext-align: center;\n\tcursor: pointer;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n.monaco-text-button:focus {\n\toutline-offset: 2px !important;\n}\n\n.monaco-text-button:hover {\n\ttext-decoration: none !important;\n}\n\n.monaco-button.disabled:focus,\n.monaco-button.disabled {\n\topacity: 0.4 !important;\n\tcursor: default;\n}\n\n.monaco-text-button > .codicon {\n\tmargin: 0 0.2em;\n\tcolor: inherit !important;\n}\n\n.monaco-button-dropdown {\n\tdisplay: flex;\n\tcursor: pointer;\n}\n\n.monaco-button-dropdown > .monaco-dropdown-button {\n\tmargin-left: 1px;\n}\n\n.monaco-description-button {\n\tflex-direction: column;\n}\n\n.monaco-description-button .monaco-button-label {\n\tfont-weight: 500;\n}\n\n.monaco-description-button .monaco-button-description {\n\tfont-style: italic;\n}\n", ""]);
                const a = r
            },
            98093: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-custom-checkbox {\n\tmargin-left: 2px;\n\tfloat: left;\n\tcursor: pointer;\n\toverflow: hidden;\n\topacity: 0.7;\n\twidth: 20px;\n\theight: 20px;\n\tborder: 1px solid transparent;\n\tpadding: 1px;\n\tbox-sizing:\tborder-box;\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-custom-checkbox:hover,\n.monaco-custom-checkbox.checked {\n\topacity: 1;\n}\n\n.hc-black .monaco-custom-checkbox {\n\tbackground: none;\n}\n\n.hc-black .monaco-custom-checkbox:hover {\n\tbackground: none;\n}\n\n.monaco-custom-checkbox.monaco-simple-checkbox {\n\theight: 18px;\n\twidth: 18px;\n\tborder: 1px solid transparent;\n\tborder-radius: 3px;\n\tmargin-right: 9px;\n\tmargin-left: 0px;\n\tpadding: 0px;\n\topacity: 1;\n\tbackground-size: 16px !important;\n}\n\n/* hide check when unchecked */\n.monaco-custom-checkbox.monaco-simple-checkbox:not(.checked)::before {\n\tvisibility: hidden;\n}\n", ""]);
                const a = r
            },
            7543: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.codicon-wrench-subaction {\n\topacity: 0.5;\n}\n\n@keyframes codicon-spin {\n\t100% {\n\t\ttransform:rotate(360deg);\n\t}\n}\n\n.codicon-sync.codicon-modifier-spin,\n.codicon-loading.codicon-modifier-spin,\n.codicon-gear.codicon-modifier-spin,\n.codicon-notebook-state-executing.codicon-modifier-spin {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.5s steps(30) infinite;\n}\n\n.codicon-modifier-disabled {\n\topacity: 0.4;\n}\n\n/* custom speed & easing for loading icon */\n.codicon-loading,\n.codicon-tree-item-loading::before {\n\tanimation-duration: 1s !important;\n\tanimation-timing-function: cubic-bezier(0.53, 0.21, 0.29, 0.67) !important;\n}\n", ""]);
                const a = r
            },
            6921: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => u
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s),
                    a = i(61667),
                    l = i.n(a),
                    c = new URL(i(73251), i.b),
                    d = r()(o()),
                    h = l()(c);
                d.push([e.id, `/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n@font-face {\n\tfont-family: "codicon";\n\tfont-display: block;\n\tsrc: url(${h}) format("truetype");\n}\n\n.codicon[class*='codicon-'] {\n\tfont: normal normal normal 16px/1 codicon;\n\tdisplay: inline-block;\n\ttext-decoration: none;\n\ttext-rendering: auto;\n\ttext-align: center;\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n/* icon rules are dynamically created in codiconStyles */\n`, ""]);
                const u = d
            },
            75730: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.context-view {\n\tposition: absolute;\n\tz-index: 2500;\n}\n\n.context-view.fixed {\n\tall: initial;\n\tfont-family: inherit;\n\tfont-size: 13px;\n\tposition: fixed;\n\tz-index: 2500;\n\tcolor: inherit;\n}\n", ""]);
                const a = r
            },
            55448: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-count-badge {\n\tpadding: 3px 6px;\n\tborder-radius: 11px;\n\tfont-size: 11px;\n\tmin-width: 18px;\n\tmin-height: 18px;\n\tline-height: 11px;\n\tfont-weight: normal;\n\ttext-align: center;\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n}\n\n.monaco-count-badge.long {\n\tpadding: 2px 3px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n", ""]);
                const a = r
            },
            15159: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-dropdown {\n\theight: 100%;\n\tpadding: 0;\n}\n\n.monaco-dropdown > .dropdown-label {\n\tcursor: pointer;\n\theight: 100%;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.monaco-dropdown > .dropdown-label > .action-label.disabled {\n\tcursor: default;\n}\n\n.monaco-dropdown-with-primary {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-primary > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n", ""]);
                const a = r
            },
            90071: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n/* ---------- Find input ---------- */\n\n.monaco-findInput {\n\tposition: relative;\n}\n\n.monaco-findInput .monaco-inputbox {\n\tfont-size: 13px;\n\twidth: 100%;\n}\n\n.monaco-findInput > .controls {\n\tposition: absolute;\n\ttop: 3px;\n\tright: 2px;\n}\n\n.vs .monaco-findInput.disabled {\n\tbackground-color: #E1E1E1;\n}\n\n/* Theming */\n.vs-dark .monaco-findInput.disabled {\n\tbackground-color: #333;\n}\n\n/* Highlighting */\n.monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-0 100ms linear 0s;\n}\n.monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-1 100ms linear 0s;\n}\n.hc-black .monaco-findInput.highlight-0 .controls,\n.vs-dark  .monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-dark-0 100ms linear 0s;\n}\n.hc-black .monaco-findInput.highlight-1 .controls,\n.vs-dark  .monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-dark-1 100ms linear 0s;\n}\n\n@keyframes monaco-findInput-highlight-0 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-1 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}\n\n@keyframes monaco-findInput-highlight-dark-0 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-dark-1 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}", ""]);
                const a = r
            },
            70223: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-hover {\n\tcursor: default;\n\tposition: absolute;\n\toverflow: hidden;\n\tz-index: 50;\n\t-moz-user-select: text;\n\t     user-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n\tbox-sizing: initial;\n\tanimation: fadein 100ms linear;\n\tline-height: 1.5em;\n}\n\n.monaco-hover.hidden {\n\tdisplay: none;\n}\n\n.monaco-hover .hover-contents:not(.html-hover-contents) {\n\tpadding: 4px 8px;\n}\n\n.monaco-hover .markdown-hover > .hover-contents:not(.code-hover-contents) {\n\tmax-width: 500px;\n\tword-wrap: break-word;\n}\n\n.monaco-hover .markdown-hover > .hover-contents:not(.code-hover-contents) hr {\n\tmin-width: 100%;\n}\n\n.monaco-hover p,\n.monaco-hover .code,\n.monaco-hover ul {\n\tmargin: 8px 0;\n}\n\n.monaco-hover code {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-hover hr {\n\tbox-sizing: border-box;\n\tborder-left: 0px;\n\tborder-right: 0px;\n\tmargin-top: 4px;\n\tmargin-bottom: -4px;\n\tmargin-left: -8px;\n\tmargin-right: -8px;\n\theight: 1px;\n}\n\n.monaco-hover p:first-child,\n.monaco-hover .code:first-child,\n.monaco-hover ul:first-child {\n\tmargin-top: 0;\n}\n\n.monaco-hover p:last-child,\n.monaco-hover .code:last-child,\n.monaco-hover ul:last-child {\n\tmargin-bottom: 0;\n}\n\n/* MarkupContent Layout */\n.monaco-hover ul {\n\tpadding-left: 20px;\n}\n.monaco-hover ol {\n\tpadding-left: 20px;\n}\n\n.monaco-hover li > p {\n\tmargin-bottom: 0;\n}\n\n.monaco-hover li > ul {\n\tmargin-top: 0;\n}\n\n.monaco-hover code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-hover .monaco-tokenized-source {\n\twhite-space: pre-wrap;\n}\n\n.monaco-hover .hover-row.status-bar {\n\tfont-size: 12px;\n\tline-height: 22px;\n}\n\n.monaco-hover .hover-row.status-bar .actions {\n\tdisplay: flex;\n\tpadding: 0px 8px;\n}\n\n.monaco-hover .hover-row.status-bar .actions .action-container {\n\tmargin-right: 16px;\n\tcursor: pointer;\n}\n\n.monaco-hover .hover-row.status-bar .actions .action-container .action .icon {\n\tpadding-right: 4px;\n}\n\n.monaco-hover .markdown-hover .hover-contents .codicon {\n\tcolor: inherit;\n\tfont-size: inherit;\n\tvertical-align: middle;\n}\n\n.monaco-hover .hover-contents a.code-link:hover,\n.monaco-hover .hover-contents a.code-link {\n\tcolor: inherit;\n}\n\n.monaco-hover .hover-contents a.code-link:before {\n\tcontent: '(';\n}\n\n.monaco-hover .hover-contents a.code-link:after {\n\tcontent: ')';\n}\n\n.monaco-hover .hover-contents a.code-link > span {\n\ttext-decoration: underline;\n\t/** Hack to force underline to show **/\n\tborder-bottom: 1px solid transparent;\n\ttext-underline-position: under;\n}\n\n/** Spans in markdown hovers need a margin-bottom to avoid looking cramped: https://github.com/microsoft/vscode/issues/101496 **/\n.monaco-hover .markdown-hover .hover-contents:not(.code-hover-contents):not(.html-hover-contents) span {\n\tmargin-bottom: 4px;\n\tdisplay: inline-block;\n}\n\n.monaco-hover-content .action-container a {\n\t-webkit-user-select: none;\n\t-moz-user-select: none;\n\t -ms-user-select: none;\n\t     user-select: none;\n}\n\n.monaco-hover-content .action-container.disabled {\n\tpointer-events: none;\n\topacity: 0.4;\n\tcursor: default;\n}\n", ""]);
                const a = r
            },
            56388: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* ---------- Icon label ---------- */\n\n.monaco-icon-label {\n\tdisplay: flex; /* required for icons support :before rule */\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-icon-label::before {\n\n\t/* svg icons rendered as background image */\n\tbackground-size: 16px;\n\tbackground-position: left center;\n\tbackground-repeat: no-repeat;\n\tpadding-right: 6px;\n\twidth: 16px;\n\theight: 22px;\n\tline-height: inherit !important;\n\tdisplay: inline-block;\n\n\t/* fonts icons */\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tvertical-align: top;\n\n\tflex-shrink: 0; /* fix for https://github.com/microsoft/vscode/issues/13787 */\n}\n\n.monaco-icon-label > .monaco-icon-label-container {\n\tmin-width: 0;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tflex: 1;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name {\n\tcolor: inherit;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name > .label-separator {\n\tmargin: 0 2px;\n\topacity: 0.5;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .7;\n\tmargin-left: 0.5em;\n\tfont-size: 0.9em;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label.nowrap > .monaco-icon-label-container > .monaco-icon-description-container > .label-description{\n\twhite-space: nowrap\n}\n\n.vs .monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .95;\n}\n\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.deprecated {\n\ttext-decoration: line-through;\n\topacity: 0.66;\n}\n\n/* make sure apply italic font style to decorations as well */\n.monaco-icon-label.italic::after {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\ttext-decoration: line-through;\n}\n\n.monaco-icon-label::after {\n\topacity: 0.75;\n\tfont-size: 90%;\n\tfont-weight: 600;\n\tmargin: auto 16px 0 5px; /* https://github.com/microsoft/vscode/issues/113223 */\n\ttext-align: center;\n}\n\n/* make sure selection color wins when a label is being selected */\n.monaco-list:focus .selected .monaco-icon-label, /* list */\n.monaco-list:focus .selected .monaco-icon-label::after\n{\n\tcolor: inherit !important;\n}\n\n.monaco-list-row.focused.selected .label-description,\n.monaco-list-row.selected .label-description {\n\topacity: .8;\n}\n", ""]);
                const a = r
            },
            76153: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-inputbox {\n\tposition: relative;\n\tdisplay: block;\n\tpadding: 0;\n\tbox-sizing:\tborder-box;\n\n\t/* Customizable */\n\tfont-size: inherit;\n}\n\n.monaco-inputbox.idle {\n\tborder: 1px solid transparent;\n}\n\n.monaco-inputbox > .ibwrapper > .input,\n.monaco-inputbox > .ibwrapper > .mirror {\n\n\t/* Customizable */\n\tpadding: 4px;\n}\n\n.monaco-inputbox > .ibwrapper {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-inputbox > .ibwrapper > .input {\n\tdisplay: inline-block;\n\tbox-sizing:\tborder-box;\n\twidth: 100%;\n\theight: 100%;\n\tline-height: inherit;\n\tborder: none;\n\tfont-family: inherit;\n\tfont-size: inherit;\n\tresize: none;\n\tcolor: inherit;\n}\n\n.monaco-inputbox > .ibwrapper > input {\n\ttext-overflow: ellipsis;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input {\n\tdisplay: block;\n\t-ms-overflow-style: none; /* IE 10+: hide scrollbars */\n\tscrollbar-width: none; /* Firefox: hide scrollbars */\n\toutline: none;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input::-webkit-scrollbar {\n\tdisplay: none; /* Chrome + Safari: hide scrollbar */\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input.empty {\n\twhite-space: nowrap;\n}\n\n.monaco-inputbox > .ibwrapper > .mirror {\n\tposition: absolute;\n\tdisplay: inline-block;\n\twidth: 100%;\n\ttop: 0;\n\tleft: 0;\n\tbox-sizing: border-box;\n\twhite-space: pre-wrap;\n\tvisibility: hidden;\n\tword-wrap: break-word;\n}\n\n/* Context view */\n\n.monaco-inputbox-container {\n\ttext-align: right;\n}\n\n.monaco-inputbox-container .monaco-inputbox-message {\n\tdisplay: inline-block;\n\toverflow: hidden;\n\ttext-align: left;\n\twidth: 100%;\n\tbox-sizing:\tborder-box;\n\tpadding: 0.4em;\n\tfont-size: 12px;\n\tline-height: 17px;\n\tmargin-top: -1px;\n\tword-wrap: break-word;\n}\n\n/* Action bar support */\n.monaco-inputbox .monaco-action-bar {\n\tposition: absolute;\n\tright: 2px;\n\ttop: 4px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item {\n\tmargin-left: 2px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item .codicon {\n\tbackground-repeat: no-repeat;\n\twidth: 16px;\n\theight: 16px;\n}\n", ""]);
                const a = r
            },
            80407: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-keybinding {\n\tdisplay: flex;\n\talign-items: center;\n\tline-height: 10px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tdisplay: inline-block;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-radius: 3px;\n\tvertical-align: middle;\n\tfont-size: 11px;\n\tpadding: 3px 5px;\n\tmargin: 0 2px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:first-child {\n\tmargin-left: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:last-child {\n\tmargin-right: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-separator {\n\tdisplay: inline-block;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-chord-separator {\n\twidth: 6px;\n}\n", ""]);
                const a = r
            },
            33967: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-list {\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n}\n\n.monaco-list.mouse-support {\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-list > .monaco-scrollable-element {\n\theight: 100%;\n}\n\n.monaco-list-rows {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-list.horizontal-scrolling .monaco-list-rows {\n\twidth: auto;\n\tmin-width: 100%;\n}\n\n.monaco-list-row {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\twidth: 100%;\n}\n\n.monaco-list.mouse-support .monaco-list-row {\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n/* for OS X ballistic scrolling */\n.monaco-list-row.scrolling {\n\tdisplay: none !important;\n}\n\n/* Focus */\n.monaco-list.element-focused,\n.monaco-list.selection-single,\n.monaco-list.selection-multiple {\n\toutline: 0 !important;\n}\n\n/* Dnd */\n.monaco-drag-image {\n\tdisplay: inline-block;\n\tpadding: 1px 7px;\n\tborder-radius: 10px;\n\tfont-size: 12px;\n\tposition: absolute;\n\tz-index: 1000;\n}\n\n/* Type filter */\n\n.monaco-list-type-filter {\n\tdisplay: flex;\n\talign-items: center;\n\tposition: absolute;\n\tborder-radius: 2px;\n\tpadding: 0px 3px;\n\tmax-width: calc(100% - 10px);\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\ttext-align: right;\n\tbox-sizing: border-box;\n\tcursor: all-scroll;\n\tfont-size: 13px;\n\tline-height: 18px;\n\theight: 20px;\n\tz-index: 1;\n\ttop: 4px;\n}\n\n.monaco-list-type-filter.dragging {\n\ttransition: top 0.2s, left 0.2s;\n}\n\n.monaco-list-type-filter.ne {\n\tright: 4px;\n}\n\n.monaco-list-type-filter.nw {\n\tleft: 4px;\n}\n\n.monaco-list-type-filter > .controls {\n\tdisplay: flex;\n\talign-items: center;\n\tbox-sizing: border-box;\n\ttransition: width 0.2s;\n\twidth: 0;\n}\n\n.monaco-list-type-filter.dragging > .controls,\n.monaco-list-type-filter:hover > .controls {\n\twidth: 36px;\n}\n\n.monaco-list-type-filter > .controls > * {\n\tborder: none;\n\tbox-sizing: border-box;\n\t-webkit-appearance: none;\n\t-moz-appearance: none;\n\tbackground: none;\n\twidth: 16px;\n\theight: 16px;\n\tflex-shrink: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: pointer;\n}\n\n.monaco-list-type-filter > .controls > .filter {\n\tmargin-left: 4px;\n}\n\n.monaco-list-type-filter-message {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\twidth: 100%;\n\theight: 100%;\n\ttop: 0;\n\tleft: 0;\n\tpadding: 40px 1em 1em 1em;\n\ttext-align: center;\n\twhite-space: normal;\n\topacity: 0.7;\n\tpointer-events: none;\n}\n\n.monaco-list-type-filter-message:empty {\n\tdisplay: none;\n}\n\n/* Electron */\n\n.monaco-list-type-filter {\n\tcursor: grab;\n}\n\n.monaco-list-type-filter.dragging {\n\tcursor: grabbing;\n}\n", ""]);
                const a = r
            },
            64147: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => p
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s),
                    a = i(61667),
                    l = i.n(a),
                    c = new URL(i(4768), i.b),
                    d = new URL(i(35555), i.b),
                    h = r()(o()),
                    u = l()(c),
                    g = l()(d);
                h.push([e.id, `/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-mouse-cursor-text {\n\tcursor: text;\n}\n\n/* The following selector looks a bit funny, but that is needed to cover all the workbench and the editor!! */\n.vs-dark .mac .monaco-mouse-cursor-text, .hc-black .mac .monaco-mouse-cursor-text,\n.vs-dark.mac .monaco-mouse-cursor-text, .hc-black.mac .monaco-mouse-cursor-text {\n\tcursor: -webkit-image-set(url(${u}) 1x, url(${g}) 2x) 5 8, text;\n}\n`, ""]);
                const p = h
            },
            56127: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-progress-container {\n\twidth: 100%;\n\theight: 5px;\n\toverflow: hidden; /* keep progress bit in bounds */\n}\n\n.monaco-progress-container .progress-bit {\n\twidth: 2%;\n\theight: 5px;\n\tposition: absolute;\n\tleft: 0;\n\tdisplay: none;\n}\n\n.monaco-progress-container.active .progress-bit {\n\tdisplay: inherit;\n}\n\n.monaco-progress-container.discrete .progress-bit {\n\tleft: 0;\n\ttransition: width 100ms linear;\n}\n\n.monaco-progress-container.discrete.done .progress-bit {\n\twidth: 100%;\n}\n\n.monaco-progress-container.infinite .progress-bit {\n\tanimation-name: progress;\n\tanimation-duration: 4s;\n\tanimation-iteration-count: infinite;\n\tanimation-timing-function: linear;\n\ttransform: translate3d(0px, 0px, 0px);\n}\n\n/**\n * The progress bit has a width: 2% (1/50) of the parent container. The animation moves it from 0% to 100% of\n * that container. Since translateX is relative to the progress bit size, we have to multiple it with\n * its relative size to the parent container:\n * parent width: 5000%\n *    bit width: 100%\n * translateX should be as follow:\n *  50%: 5000% * 50% - 50% (set to center) = 2450%\n * 100%: 5000% * 100% - 100% (do not overflow) = 4900%\n */\n@keyframes progress { from { transform: translateX(0%) scaleX(1) } 50% { transform: translateX(2500%) scaleX(3) } to { transform: translateX(4900%) scaleX(1) } }\n", ""]);
                const a = r
            },
            19667: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n:root {\n\t--sash-size: 4px;\n}\n\n.monaco-sash {\n\tposition: absolute;\n\tz-index: 35;\n\ttouch-action: none;\n}\n\n.monaco-sash.disabled {\n\tpointer-events: none;\n}\n\n.monaco-sash.mac.vertical {\n\tcursor: col-resize;\n}\n\n.monaco-sash.vertical.minimum {\n\tcursor: e-resize;\n}\n\n.monaco-sash.vertical.maximum {\n\tcursor: w-resize;\n}\n\n.monaco-sash.mac.horizontal {\n\tcursor: row-resize;\n}\n\n.monaco-sash.horizontal.minimum {\n\tcursor: s-resize;\n}\n\n.monaco-sash.horizontal.maximum {\n\tcursor: n-resize;\n}\n\n.monaco-sash.disabled {\n\tcursor: default !important;\n\tpointer-events: none !important;\n}\n\n.monaco-sash.vertical {\n\tcursor: ew-resize;\n\ttop: 0;\n\twidth: var(--sash-size);\n\theight: 100%;\n}\n\n.monaco-sash.horizontal {\n\tcursor: ns-resize;\n\tleft: 0;\n\twidth: 100%;\n\theight: var(--sash-size);\n}\n\n.monaco-sash:not(.disabled) > .orthogonal-drag-handle {\n\tcontent: \" \";\n\theight: calc(var(--sash-size) * 2);\n\twidth: calc(var(--sash-size) * 2);\n\tz-index: 100;\n\tdisplay: block;\n\tcursor: all-scroll;\n\tposition: absolute;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.start,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.end {\n\tcursor: nwse-resize;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.end,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.start {\n\tcursor: nesw-resize;\n}\n\n.monaco-sash.vertical > .orthogonal-drag-handle.start {\n\tleft: calc(var(--sash-size) * -0.5);\n\ttop: calc(var(--sash-size) * -1);\n}\n.monaco-sash.vertical > .orthogonal-drag-handle.end {\n\tleft: calc(var(--sash-size) * -0.5);\n\tbottom: calc(var(--sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.start {\n\ttop: calc(var(--sash-size) * -0.5);\n\tleft: calc(var(--sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.end {\n\ttop: calc(var(--sash-size) * -0.5);\n\tright: calc(var(--sash-size) * -1);\n}\n\n.monaco-sash:before {\n\tcontent: '';\n\tpointer-events: none;\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\ttransition: background-color 0.1s ease-out;\n\tbackground: transparent;\n}\n\n.monaco-sash.vertical:before {\n\twidth: var(--sash-hover-size);\n\tleft: calc(50% - (var(--sash-hover-size) / 2));\n}\n\n.monaco-sash.horizontal:before {\n\theight: var(--sash-hover-size);\n\ttop: calc(50% - (var(--sash-hover-size) / 2));\n}\n\n/** Debug **/\n\n.monaco-sash.debug {\n\tbackground: cyan;\n}\n\n.monaco-sash.debug.disabled {\n\tbackground: rgba(0, 255, 255, 0.2);\n}\n\n.monaco-sash.debug:not(.disabled) > .orthogonal-drag-handle {\n\tbackground: red;\n}\n", ""]);
                const a = r
            },
            51022: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Arrows */\n.monaco-scrollable-element > .scrollbar > .scra {\n\tcursor: pointer;\n\tfont-size: 11px !important;\n}\n\n.monaco-scrollable-element > .visible {\n\topacity: 1;\n\n\t/* Background rule added for IE9 - to allow clicks on dom node */\n\tbackground:rgba(0,0,0,0);\n\n\ttransition: opacity 100ms linear;\n}\n.monaco-scrollable-element > .invisible {\n\topacity: 0;\n\tpointer-events: none;\n}\n.monaco-scrollable-element > .invisible.fade {\n\ttransition: opacity 800ms linear;\n}\n\n/* Scrollable Content Inset Shadow */\n.monaco-scrollable-element > .shadow {\n\tposition: absolute;\n\tdisplay: none;\n}\n.monaco-scrollable-element > .shadow.top {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 3px;\n\theight: 3px;\n\twidth: 100%;\n}\n.monaco-scrollable-element > .shadow.left {\n\tdisplay: block;\n\ttop: 3px;\n\tleft: 0;\n\theight: 100%;\n\twidth: 3px;\n}\n.monaco-scrollable-element > .shadow.top-left-corner {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 0;\n\theight: 3px;\n\twidth: 3px;\n}\n", ""]);
                const a = r
            },
            5785: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-split-view2 {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .sash-container {\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\tpointer-events: none;\n}\n\n.monaco-split-view2 > .sash-container > .monaco-sash {\n\tpointer-events: initial;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element {\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container {\n\twidth: 100%;\n\theight: 100%;\n\twhite-space: nowrap;\n\tposition: relative;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twhite-space: initial;\n\tposition: absolute;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view:not(.visible) {\n\tdisplay: none;\n}\n\n.monaco-split-view2.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twidth: 100%;\n}\n\n.monaco-split-view2.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\theight: 100%;\n}\n\n.monaco-split-view2.separator-border > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\tcontent: ' ';\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\tz-index: 5;\n\tpointer-events: none;\n\tbackground-color: var(--separator-border);\n}\n\n.monaco-split-view2.separator-border.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 100%;\n\twidth: 1px;\n}\n\n.monaco-split-view2.separator-border.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 1px;\n\twidth: 100%;\n}\n", ""]);
                const a = r
            },
            39771: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, '/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-table {\n\tdisplay: flex;\n\tflex-direction: column;\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n}\n\n.monaco-table > .monaco-split-view2 {\n\tborder-bottom: 1px solid transparent;\n}\n\n.monaco-table > .monaco-list {\n\tflex: 1;\n}\n\n.monaco-table-tr {\n\tdisplay: flex;\n\theight: 100%;\n}\n\n.monaco-table-th {\n\twidth: 100%;\n\theight: 100%;\n\tfont-weight: bold;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table-th,\n.monaco-table-td {\n\tbox-sizing: border-box;\n\tflex-shrink: 0;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\tcontent: "";\n\tposition: absolute;\n\tleft: calc(var(--sash-size) / 2);\n\twidth: 0;\n\tborder-left: 1px solid transparent;\n}\n\n.monaco-table > .monaco-split-view2,\n.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\ttransition: border-color 0.2s ease-out;\n}\n/*\n.monaco-table:hover > .monaco-split-view2,\n.monaco-table:hover > .monaco-split-view2 .monaco-sash.vertical::before {\n\tborder-color: rgba(204, 204, 204, 0.2);\n} */\n', ""]);
                const a = r
            },
            90078: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-tl-row {\n\tdisplay: flex;\n\theight: 100%;\n\talign-items: center;\n\tposition: relative;\n}\n\n.monaco-tl-indent {\n\theight: 100%;\n\tposition: absolute;\n\ttop: 0;\n\tleft: 16px;\n\tpointer-events: none;\n}\n\n.hide-arrows .monaco-tl-indent {\n\tleft: 12px;\n}\n\n.monaco-tl-indent > .indent-guide {\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n\theight: 100%;\n\tborder-left: 1px solid transparent;\n\ttransition: border-color 0.1s linear;\n}\n\n.monaco-tl-twistie,\n.monaco-tl-contents {\n\theight: 100%;\n}\n\n.monaco-tl-twistie {\n\tfont-size: 10px;\n\ttext-align: right;\n\tpadding-right: 6px;\n\tflex-shrink: 0;\n\twidth: 16px;\n\tdisplay: flex !important;\n\talign-items: center;\n\tjustify-content: center;\n\ttransform: translateX(3px);\n}\n\n.monaco-tl-contents {\n\tflex: 1;\n\toverflow: hidden;\n}\n\n.monaco-tl-twistie::before {\n\tborder-radius: 20px;\n}\n\n.monaco-tl-twistie.collapsed::before {\n\ttransform: rotate(-90deg);\n}\n\n.monaco-tl-twistie.codicon-tree-item-loading::before {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.25s steps(30) infinite;\n}\n", ""]);
                const a = r
            },
            82749: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tposition: absolute;\n\twidth: 600px;\n\tz-index: 2000;\n\tpadding: 0 1px 1px 1px;\n\tleft: 50%;\n\tmargin-left: -300px;\n}\n\n.quick-input-titlebar {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-left-action-bar {\n\tdisplay: flex;\n\tmargin-left: 4px;\n\tflex: 1;\n}\n\n.quick-input-title {\n\tpadding: 3px 0px;\n\ttext-align: center;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-right-action-bar {\n\tdisplay: flex;\n\tmargin-right: 4px;\n\tflex: 1;\n}\n\n.quick-input-right-action-bar > .actions-container {\n\tjustify-content: flex-end;\n}\n\n.quick-input-titlebar .monaco-action-bar .action-label.codicon {\n\tbackground-position: center;\n\tbackground-repeat: no-repeat;\n\tpadding: 2px;\n}\n\n.quick-input-description {\n\tmargin: 6px;\n}\n\n.quick-input-header .quick-input-description {\n\tmargin: 4px 2px;\n}\n\n.quick-input-header {\n\tdisplay: flex;\n\tpadding: 6px 6px 0px 6px;\n\tmargin-bottom: -2px;\n}\n\n.quick-input-widget.hidden-input .quick-input-header {\n\t/* reduce margins and paddings when input box hidden */\n\tpadding: 0;\n\tmargin-bottom: 0;\n}\n\n.quick-input-and-message {\n\tdisplay: flex;\n\tflex-direction: column;\n\tflex-grow: 1;\n\tmin-width: 0;\n\tposition: relative;\n}\n\n.quick-input-check-all {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-filter {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tposition: relative;\n}\n\n.quick-input-box {\n\tflex-grow: 1;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-box,\n.quick-input-widget.show-checkboxes .quick-input-message {\n\tmargin-left: 5px;\n}\n\n.quick-input-visible-count {\n\tposition: absolute;\n\tleft: -10000px;\n}\n\n.quick-input-count {\n\talign-self: center;\n\tposition: absolute;\n\tright: 4px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-count .monaco-count-badge {\n\tvertical-align: middle;\n\tpadding: 2px 4px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n\n.quick-input-action {\n\tmargin-left: 6px;\n}\n\n.quick-input-action .monaco-text-button {\n\tfont-size: 11px;\n\tpadding: 0 6px;\n\tdisplay: flex;\n\theight: 27.5px;\n\talign-items: center;\n}\n\n.quick-input-message {\n\tmargin-top: -1px;\n\tpadding: 5px 5px 2px 5px;\n\toverflow-wrap: break-word;\n}\n\n.quick-input-message > .codicon {\n\tmargin: 0 0.2em;\n\tvertical-align: text-bottom;\n}\n\n.quick-input-progress.monaco-progress-container {\n\tposition: relative;\n}\n\n.quick-input-progress.monaco-progress-container,\n.quick-input-progress.monaco-progress-container .progress-bit {\n\theight: 2px;\n}\n\n.quick-input-list {\n\tline-height: 22px;\n\tmargin-top: 6px;\n}\n\n.quick-input-widget.hidden-input .quick-input-list {\n\tmargin-top: 0; /* reduce margins when input box hidden */\n}\n\n.quick-input-list .monaco-list {\n\toverflow: hidden;\n\tmax-height: calc(20 * 22px);\n}\n\n.quick-input-list .quick-input-list-entry {\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tpadding: 0 6px;\n}\n\n.quick-input-list .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-width: 1px;\n\tborder-top-style: solid;\n}\n\n.quick-input-list .monaco-list-row[data-index=\"0\"] .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-style: none;\n}\n\n.quick-input-list .quick-input-list-label {\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tflex: 1;\n}\n\n.quick-input-list .quick-input-list-checkbox {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-list .quick-input-list-rows {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tdisplay: flex;\n\tflex-direction: column;\n\theight: 100%;\n\tflex: 1;\n\tmargin-left: 5px;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-rows {\n\tmargin-left: 10px;\n}\n\n.quick-input-widget .quick-input-list .quick-input-list-checkbox {\n\tdisplay: none;\n}\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-checkbox {\n\tdisplay: inline;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label,\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label .monaco-icon-label-container > .monaco-icon-name-container {\n\tflex: 1; /* make sure the icon label grows within the row */\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .codicon[class*='codicon-'] {\n\tvertical-align: text-bottom;\n}\n\n.quick-input-list .quick-input-list-rows .monaco-highlighted-label span {\n\topacity: 1;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-keybinding {\n\tmargin-right: 8px; /* separate from the separator label or scrollbar if any */\n}\n\n.quick-input-list .quick-input-list-label-meta {\n\topacity: 0.7;\n\tline-height: normal;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-list .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-separator {\n\tmargin-right: 8px; /* separate from keybindings or actions */\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tdisplay: flex;\n\tflex: 0;\n\toverflow: visible;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label {\n\t/*\n\t * By default, actions in the quick input action bar are hidden\n\t * until hovered over them or selected.\n\t */\n\tdisplay: none;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label.codicon {\n\tmargin-right: 4px;\n\tpadding: 0px 2px 2px 2px;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tmargin-top: 1px;\n\tmargin-right: 4px; /* separate from scrollbar */\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-action-bar .action-label.always-visible,\n.quick-input-list .quick-input-list-entry:hover .quick-input-list-entry-action-bar .action-label,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry-action-bar .action-label {\n\tdisplay: flex;\n}\n\n/* focused items in quick pick */\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry .quick-input-list-separator {\n\tcolor: inherit\n}\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key {\n\tbackground: none;\n}\n", ""]);
                const a = r
            },
            22729: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .inputarea {\n\tmin-width: 0;\n\tmin-height: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tposition: absolute;\n\toutline: none !important;\n\tresize: none;\n\tborder: none;\n\toverflow: hidden;\n\tcolor: transparent;\n\tbackground-color: transparent;\n}\n/*.monaco-editor .inputarea {\n\tposition: fixed !important;\n\twidth: 800px !important;\n\theight: 500px !important;\n\ttop: initial !important;\n\tleft: initial !important;\n\tbottom: 0 !important;\n\tright: 0 !important;\n\tcolor: black !important;\n\tbackground: white !important;\n\tline-height: 15px !important;\n\tfont-size: 14px !important;\n}*/\n.monaco-editor .inputarea.ime-input {\n\tz-index: 10;\n}\n", ""]);
                const a = r
            },
            67615: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line.current-line-margin.current-line-margin-both {\n\tborder-right: 0;\n}\n", ""]);
                const a = r
            },
            32429: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcdr = core decorations rendering (div)\n*/\n.monaco-editor .lines-content .cdr {\n\tposition: absolute;\n}", ""]);
                const a = r
            },
            84891: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .glyph-margin {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcgmr = core glyph margin rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cgmr {\n\tposition: absolute;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n", ""]);
                const a = r
            },
            52073: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .lines-content .core-guide {\n\tposition: absolute;\n\tbox-sizing: border-box;\n}\n", ""]);
                const a = r
            },
            1715: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .margin-view-overlays .line-numbers {\n\tfont-variant-numeric: tabular-nums;\n\tposition: absolute;\n\ttext-align: right;\n\tdisplay: inline-block;\n\tvertical-align: middle;\n\tbox-sizing: border-box;\n\tcursor: default;\n\theight: 100%;\n}\n\n.monaco-editor .relative-current-line-number {\n\ttext-align: left;\n\tdisplay: inline-block;\n\twidth: 100%;\n}\n\n.monaco-editor .margin-view-overlays .line-numbers.lh-odd {\n\tmargin-top: 1px;\n}\n", ""]);
                const a = r
            },
            19523: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Uncomment to see lines flashing when they're painted */\n/*.monaco-editor .view-lines > .view-line {\n\tbackground-color: none;\n\tanimation-name: flash-background;\n\tanimation-duration: 800ms;\n}\n@keyframes flash-background {\n\t0%   { background-color: lightgreen; }\n\t100% { background-color: none }\n}*/\n\n.mtkcontrol {\n\tcolor: rgb(255, 255, 255) !important;\n\tbackground: rgb(150, 0, 0) !important;\n}\n\n.monaco-editor.no-user-select .lines-content,\n.monaco-editor.no-user-select .view-line,\n.monaco-editor.no-user-select .view-lines {\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-editor .view-lines {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .view-line {\n\tposition: absolute;\n\twidth: 100%;\n}\n\n.monaco-editor .mtkz {\n\tdisplay: inline-block;\n}\n\n/* TODO@tokenization bootstrap fix */\n/*.monaco-editor .view-line > span > span {\n\tfloat: none;\n\tmin-height: inherit;\n\tmargin-left: inherit;\n}*/\n", ""]);
                const a = r
            },
            55228: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .lines-decorations {\n\tposition: absolute;\n\ttop: 0;\n\tbackground: white;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcldr = core lines decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cldr {\n\tposition: absolute;\n\theight: 100%;\n}", ""]);
                const a = r
            },
            63490: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcmdr = core margin decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cmdr {\n\tposition: absolute;\n\tleft: 0;\n\twidth: 100%;\n\theight: 100%;\n}", ""]);
                const a = r
            },
            27751: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* START cover the case that slider is visible on mouseover */\n.monaco-editor .minimap.slider-mouseover .minimap-slider {\n\topacity: 0;\n\ttransition: opacity 100ms linear;\n}\n.monaco-editor .minimap.slider-mouseover:hover .minimap-slider {\n\topacity: 1;\n}\n.monaco-editor .minimap.slider-mouseover .minimap-slider.active {\n\topacity: 1;\n}\n/* END cover the case that slider is visible on mouseover */\n\n.monaco-editor .minimap-shadow-hidden {\n\tposition: absolute;\n\twidth: 0;\n}\n.monaco-editor .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -6px;\n\twidth: 6px;\n}\n.monaco-editor.no-minimap-shadow .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -1px;\n\twidth: 1px;\n}\n", ""]);
                const a = r
            },
            57789: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .overlayWidgets {\n\tposition: absolute;\n\ttop: 0;\n\tleft:0;\n}", ""]);
                const a = r
            },
            97073: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-ruler {\n\tposition: absolute;\n\ttop: 0;\n}", ""]);
                const a = r
            },
            30458: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .scroll-decoration {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\theight: 6px;\n}", ""]);
                const a = r
            },
            43147: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcslr = core selections layer rendering (div)\n*/\n.monaco-editor .lines-content .cslr {\n\tposition: absolute;\n}\n\n.monaco-editor\t\t\t.top-left-radius\t\t{ border-top-left-radius: 3px; }\n.monaco-editor\t\t\t.bottom-left-radius\t\t{ border-bottom-left-radius: 3px; }\n.monaco-editor\t\t\t.top-right-radius\t\t{ border-top-right-radius: 3px; }\n.monaco-editor\t\t\t.bottom-right-radius\t{ border-bottom-right-radius: 3px; }\n\n.monaco-editor.hc-black .top-left-radius\t\t{ border-top-left-radius: 0; }\n.monaco-editor.hc-black .bottom-left-radius\t\t{ border-bottom-left-radius: 0; }\n.monaco-editor.hc-black .top-right-radius\t\t{ border-top-right-radius: 0; }\n.monaco-editor.hc-black .bottom-right-radius\t{ border-bottom-right-radius: 0; }\n", ""]);
                const a = r
            },
            26649: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .cursors-layer {\n\tposition: absolute;\n\ttop: 0;\n}\n\n.monaco-editor .cursors-layer > .cursor {\n\tposition: absolute;\n\toverflow: hidden;\n}\n\n/* -- smooth-caret-animation -- */\n.monaco-editor .cursors-layer.cursor-smooth-caret-animation > .cursor {\n\ttransition: all 80ms;\n}\n\n/* -- block-outline-style -- */\n.monaco-editor .cursors-layer.cursor-block-outline-style > .cursor {\n\tbox-sizing: border-box;\n\tbackground: transparent !important;\n\tborder-style: solid;\n\tborder-width: 1px;\n}\n\n/* -- underline-style -- */\n.monaco-editor .cursors-layer.cursor-underline-style > .cursor {\n\tborder-bottom-width: 2px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n\tbox-sizing: border-box;\n}\n\n/* -- underline-thin-style -- */\n.monaco-editor .cursors-layer.cursor-underline-thin-style > .cursor {\n\tborder-bottom-width: 1px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n\tbox-sizing: border-box;\n}\n\n@keyframes monaco-cursor-smooth {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t60%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-phase {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t90%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-expand {\n\t0%,\n\t20% {\n\t\ttransform: scaleY(1);\n\t}\n\t80%,\n\t100% {\n\t\ttransform: scaleY(0);\n\t}\n}\n\n.cursor-smooth {\n\tanimation: monaco-cursor-smooth 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-phase {\n\tanimation: monaco-cursor-phase 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-expand > .cursor {\n\tanimation: monaco-cursor-expand 0.5s ease-in-out 0s 20 alternate;\n}\n", ""]);
                const a = r
            },
            61927: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n/* ---------- DiffEditor ---------- */\n\n.monaco-diff-editor .diffOverview {\n\tz-index: 9;\n}\n\n.monaco-diff-editor .diffOverview .diffViewport {\n\tz-index: 10;\n}\n\n/* colors not externalized: using transparancy on background */\n.monaco-diff-editor.vs\t\t\t.diffOverview { background: rgba(0, 0, 0, 0.03); }\n.monaco-diff-editor.vs-dark\t\t.diffOverview { background: rgba(255, 255, 255, 0.01); }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs\t\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs-dark\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.hc-black\t.scrollbar { background: none; }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor .slider {\n\tz-index: 10;\n}\n.modified-in-monaco-diff-editor\t\t\t\t.slider.active { background: rgba(171, 171, 171, .4); }\n.modified-in-monaco-diff-editor.hc-black\t.slider.active { background: none; }\n\n/* ---------- Diff ---------- */\n\n.monaco-editor .insert-sign,\n.monaco-diff-editor .insert-sign,\n.monaco-editor .delete-sign,\n.monaco-diff-editor .delete-sign {\n\tfont-size: 11px !important;\n\topacity: 0.7 !important;\n\tdisplay: flex !important;\n\talign-items: center;\n}\n.monaco-editor.hc-black .insert-sign,\n.monaco-diff-editor.hc-black .insert-sign,\n.monaco-editor.hc-black .delete-sign,\n.monaco-diff-editor.hc-black .delete-sign {\n\topacity: 1;\n}\n\n.monaco-editor .inline-deleted-margin-view-zone {\n\ttext-align: right;\n}\n.monaco-editor .inline-added-margin-view-zone {\n\ttext-align: right;\n}\n\n/* ---------- Inline Diff ---------- */\n\n.monaco-editor .view-zones .view-lines .view-line span {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .margin-view-zones .lightbulb-glyph:hover {\n\tcursor: pointer;\n}\n", ""]);
                const a = r
            },
            44914: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-diff-editor .diff-review-line-number {\n\ttext-align: right;\n\tdisplay: inline-block;\n}\n\n.monaco-diff-editor .diff-review {\n\tposition: absolute;\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-diff-editor .diff-review-summary {\n\tpadding-left: 10px;\n}\n\n.monaco-diff-editor .diff-review-shadow {\n\tposition: absolute;\n}\n\n.monaco-diff-editor .diff-review-row {\n\twhite-space: pre;\n}\n\n.monaco-diff-editor .diff-review-table {\n\tdisplay: table;\n\tmin-width: 100%;\n}\n\n.monaco-diff-editor .diff-review-row {\n\tdisplay: table-row;\n\twidth: 100%;\n}\n\n.monaco-diff-editor .diff-review-spacer {\n\tdisplay: inline-block;\n\twidth: 10px;\n\tvertical-align: middle;\n}\n\n.monaco-diff-editor .diff-review-spacer > .codicon {\n\tfont-size: 9px !important;\n}\n\n.monaco-diff-editor .diff-review-actions {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\ttop: 2px;\n}\n\n.monaco-diff-editor .diff-review-actions .action-label {\n\twidth: 16px;\n\theight: 16px;\n\tmargin: 2px 0;\n}\n", ""]);
                const a = r
            },
            89783: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* -------------------- IE10 remove auto clear button -------------------- */\n\n::-ms-clear {\n\tdisplay: none;\n}\n\n/* All widgets */\n/* I am not a big fan of this rule */\n.monaco-editor .editor-widget input {\n\tcolor: inherit;\n}\n\n/* -------------------- Editor -------------------- */\n\n.monaco-editor {\n\tposition: relative;\n\toverflow: visible;\n\t-webkit-text-size-adjust: 100%;\n}\n\n/* -------------------- Misc -------------------- */\n\n.monaco-editor .overflow-guard {\n\tposition: relative;\n\toverflow: hidden;\n}\n\n.monaco-editor .view-overlays {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n.monaco-editor .auto-closed-character {\n\topacity: 0.3;\n}\n*/\n", ""]);
                const a = r
            },
            5952: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .selection-anchor {\n\tbackground-color: #007ACC;\n\twidth: 2px !important;\n}\n", ""]);
                const a = r
            },
            20300: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .bracket-match {\n\tbox-sizing: border-box;\n}\n", ""]);
                const a = r
            },
            33856: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .contentWidgets .codicon-light-bulb,\n.monaco-editor .contentWidgets .codicon-lightbulb-autofix {\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.monaco-editor .contentWidgets .codicon-light-bulb:hover,\n.monaco-editor .contentWidgets .codicon-lightbulb-autofix:hover {\n\tcursor: pointer;\n}\n", ""]);
                const a = r
            },
            98616: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .codelens-decoration {\n\toverflow: hidden;\n\tdisplay: inline-block;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .codelens-decoration > span,\n.monaco-editor .codelens-decoration > a {\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n\twhite-space: nowrap;\n\tvertical-align: sub;\n}\n\n.monaco-editor .codelens-decoration > a {\n\ttext-decoration: none;\n}\n\n.monaco-editor .codelens-decoration > a:hover {\n\tcursor: pointer;\n}\n\n.monaco-editor .codelens-decoration .codicon {\n\tvertical-align: middle;\n\tcolor: currentColor !important;\n}\n\n.monaco-editor .codelens-decoration > a:hover .codicon::before {\n\tcursor: pointer;\n}\n\n@keyframes fadein {\n\t0% { opacity: 0; visibility: visible;}\n\t100% { opacity: 1; }\n}\n\n.monaco-editor .codelens-decoration.fadein {\n\tanimation: fadein 0.1s linear;\n}\n", ""]);
                const a = r
            },
            64176: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => u
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s),
                    a = i(61667),
                    l = i.n(a),
                    c = new URL(i(94748), i.b),
                    d = r()(o()),
                    h = l()(c);
                d.push([e.id, `/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.colorpicker-widget {\n\theight: 190px;\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-editor .colorpicker-hover:focus {\n\toutline: none;\n}\n\n\n/* Header */\n\n.colorpicker-header {\n\tdisplay: flex;\n\theight: 24px;\n\tposition: relative;\n\tbackground: url(${h});\n\tbackground-size: 9px 9px;\n\t-ms-interpolation-mode: nearest-neighbor;\n\t    image-rendering: pixelated;\n}\n\n.colorpicker-header .picked-color {\n\twidth: 216px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tline-height: 24px;\n\tcursor: pointer;\n\tcolor: white;\n\tflex: 1;\n}\n\n.colorpicker-header .picked-color .codicon {\n\tcolor: inherit;\n\tfont-size: 14px;\n\tposition: absolute;\n\tleft: 8px;\n}\n\n.colorpicker-header .picked-color.light {\n\tcolor: black;\n}\n\n.colorpicker-header .original-color {\n\twidth: 74px;\n\tz-index: inherit;\n\tcursor: pointer;\n}\n\n\n/* Body */\n\n.colorpicker-body {\n\tdisplay: flex;\n\tpadding: 8px;\n\tposition: relative;\n}\n\n.colorpicker-body .saturation-wrap {\n\toverflow: hidden;\n\theight: 150px;\n\tposition: relative;\n\tmin-width: 220px;\n\tflex: 1;\n}\n\n.colorpicker-body .saturation-box {\n\theight: 150px;\n\tposition: absolute;\n}\n\n.colorpicker-body .saturation-selection {\n\twidth: 9px;\n\theight: 9px;\n\tmargin: -5px 0 0 -5px;\n\tborder: 1px solid rgb(255, 255, 255);\n\tborder-radius: 100%;\n\tbox-shadow: 0px 0px 2px rgba(0, 0, 0, 0.8);\n\tposition: absolute;\n}\n\n.colorpicker-body .strip {\n\twidth: 25px;\n\theight: 150px;\n}\n\n.colorpicker-body .hue-strip {\n\tposition: relative;\n\tmargin-left: 8px;\n\tcursor: grab;\n\tbackground: linear-gradient(to bottom, #ff0000 0%, #ffff00 17%, #00ff00 33%, #00ffff 50%, #0000ff 67%, #ff00ff 83%, #ff0000 100%);\n}\n\n.colorpicker-body .opacity-strip {\n\tposition: relative;\n\tmargin-left: 8px;\n\tcursor: grab;\n\tbackground: url(${h});\n\tbackground-size: 9px 9px;\n\t-ms-interpolation-mode: nearest-neighbor;\n\t    image-rendering: pixelated;\n}\n\n.colorpicker-body .strip.grabbing {\n\tcursor: grabbing;\n}\n\n.colorpicker-body .slider {\n\tposition: absolute;\n\ttop: 0;\n\tleft: -2px;\n\twidth: calc(100% + 4px);\n\theight: 4px;\n\tbox-sizing: border-box;\n\tborder: 1px solid rgba(255, 255, 255, 0.71);\n\tbox-shadow: 0px 0px 1px rgba(0, 0, 0, 0.85);\n}\n\n.colorpicker-body .strip .overlay {\n\theight: 150px;\n\tpointer-events: none;\n}\n`, ""]);
                const u = d
            },
            41221: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor.vs .dnd-target {\n\tborder-right: 2px dotted black;\n\tcolor: white; /* opposite of black */\n}\n.monaco-editor.vs-dark .dnd-target {\n\tborder-right: 2px dotted #AEAFAD;\n\tcolor: #51504f; /* opposite of #AEAFAD */\n}\n.monaco-editor.hc-black .dnd-target {\n\tborder-right: 2px dotted #fff;\n\tcolor: #000; /* opposite of #fff */\n}\n\n.monaco-editor.mouse-default .view-lines,\n.monaco-editor.vs-dark.mac.mouse-default .view-lines,\n.monaco-editor.hc-black.mac.mouse-default .view-lines {\n\tcursor: default;\n}\n.monaco-editor.mouse-copy .view-lines,\n.monaco-editor.vs-dark.mac.mouse-copy .view-lines,\n.monaco-editor.hc-black.mac.mouse-copy .view-lines {\n\tcursor: copy;\n}", ""]);
                const a = r
            },
            11897: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Find widget */\n.monaco-editor .find-widget {\n\tposition: absolute;\n\tz-index: 35;\n\theight: 33px;\n\toverflow: hidden;\n\tline-height: 19px;\n\ttransition: transform 200ms linear;\n\tpadding: 0 4px;\n\tbox-sizing: border-box;\n\ttransform: translateY(calc(-100% - 10px)); /* shadow (10px) */\n}\n\n.monaco-editor .find-widget textarea {\n\tmargin: 0px;\n}\n\n.monaco-editor .find-widget.hiddenEditor {\n\tdisplay: none;\n}\n\n/* Find widget when replace is toggled on */\n.monaco-editor .find-widget.replaceToggled > .replace-part {\n\tdisplay: flex;\n}\n\n.monaco-editor .find-widget.visible  {\n\ttransform: translateY(0);\n}\n\n.monaco-editor .find-widget .monaco-inputbox.synthetic-focus {\n\toutline: 1px solid -webkit-focus-ring-color;\n\toutline-offset: -1px;\n}\n\n.monaco-editor .find-widget .monaco-inputbox .input {\n\tbackground-color: transparent;\n\tmin-height: 0;\n}\n\n.monaco-editor .find-widget .monaco-findInput .input {\n\tfont-size: 13px;\n}\n\n.monaco-editor .find-widget > .find-part,\n.monaco-editor .find-widget > .replace-part {\n\tmargin: 4px 0 0 17px;\n\tfont-size: 12px;\n\tdisplay: flex;\n}\n\n.monaco-editor .find-widget > .find-part .monaco-inputbox,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox {\n\tmin-height: 25px;\n}\n\n\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding-right: 22px;\n}\n\n.monaco-editor .find-widget > .find-part .monaco-inputbox > .ibwrapper > .input,\n.monaco-editor .find-widget > .find-part .monaco-inputbox > .ibwrapper > .mirror,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .input,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding-top: 2px;\n\tpadding-bottom: 2px;\n}\n\n.monaco-editor .find-widget > .find-part .find-actions {\n\theight: 25px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-editor .find-widget > .replace-part .replace-actions {\n\theight: 25px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-editor .find-widget .monaco-findInput {\n\tvertical-align: middle;\n\tdisplay: flex;\n\tflex:1;\n}\n\n.monaco-editor .find-widget .monaco-findInput .monaco-scrollable-element {\n\t/* Make sure textarea inherits the width correctly */\n\twidth: 100%;\n}\n\n.monaco-editor .find-widget .monaco-findInput .monaco-scrollable-element .scrollbar.vertical {\n\t/* Hide vertical scrollbar */\n\topacity: 0;\n}\n\n.monaco-editor .find-widget .matchesCount {\n\tdisplay: flex;\n\tflex: initial;\n\tmargin: 0 0 0 3px;\n\tpadding: 2px 0 0 2px;\n\theight: 25px;\n\tvertical-align: middle;\n\tbox-sizing: border-box;\n\ttext-align: center;\n\tline-height: 23px;\n}\n\n.monaco-editor .find-widget .button {\n\twidth: 16px;\n\theight: 16px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n\tflex: initial;\n\tmargin-left: 3px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n\tcursor: pointer;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n/* find in selection button */\n.monaco-editor .find-widget .codicon-find-selection {\n\twidth: 22px;\n\theight: 22px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n}\n\n.monaco-editor .find-widget .button.left {\n\tmargin-left: 0;\n\tmargin-right: 3px;\n}\n\n.monaco-editor .find-widget .button.wide {\n\twidth: auto;\n\tpadding: 1px 6px;\n\ttop: -1px;\n}\n\n.monaco-editor .find-widget .button.toggle {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 3px;\n\twidth: 18px;\n\theight: 100%;\n\tborder-radius: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .find-widget .button.toggle.disabled {\n\tdisplay: none;\n}\n\n.monaco-editor .find-widget .disabled {\n\topacity: 0.3;\n\tcursor: default;\n}\n\n.monaco-editor .find-widget > .replace-part {\n\tdisplay: none;\n}\n\n.monaco-editor .find-widget > .replace-part > .monaco-findInput {\n\tposition: relative;\n\tdisplay: flex;\n\tvertical-align: middle;\n\tflex: auto;\n\tflex-grow: 0;\n\tflex-shrink: 0;\n}\n\n.monaco-editor .find-widget > .replace-part > .monaco-findInput > .controls {\n\tposition: absolute;\n\ttop: 3px;\n\tright: 2px;\n}\n\n/* REDUCED */\n.monaco-editor .find-widget.reduced-find-widget .matchesCount {\n\tdisplay:none;\n}\n\n/* NARROW (SMALLER THAN REDUCED) */\n.monaco-editor .find-widget.narrow-find-widget {\n\tmax-width: 257px !important;\n}\n\n/* COLLAPSED (SMALLER THAN NARROW) */\n.monaco-editor .find-widget.collapsed-find-widget {\n\tmax-width: 170px !important;\n}\n\n.monaco-editor .find-widget.collapsed-find-widget .button.previous,\n.monaco-editor .find-widget.collapsed-find-widget .button.next,\n.monaco-editor .find-widget.collapsed-find-widget .button.replace,\n.monaco-editor .find-widget.collapsed-find-widget .button.replace-all,\n.monaco-editor .find-widget.collapsed-find-widget > .find-part .monaco-findInput .controls {\n\tdisplay:none;\n}\n\n.monaco-editor .findMatch {\n\tanimation-duration: 0;\n\tanimation-name: inherit !important;\n}\n\n.monaco-editor .find-widget .monaco-sash {\n\tleft: 0 !important;\n}\n\n.monaco-editor.hc-black .find-widget .button:before {\n\tposition: relative;\n\ttop: 1px;\n\tleft: 2px;\n}\n", ""]);
                const a = r
            },
            88830: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, '/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .margin-view-overlays .codicon-folding-expanded,\n.monaco-editor .margin-view-overlays .codicon-folding-collapsed {\n\tcursor: pointer;\n\topacity: 0;\n\ttransition: opacity 0.5s;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tfont-size: 140%;\n\tmargin-left: 2px;\n}\n\n.monaco-editor .margin-view-overlays:hover .codicon,\n.monaco-editor .margin-view-overlays .codicon.codicon-folding-collapsed,\n.monaco-editor .margin-view-overlays .codicon.alwaysShowFoldIcons {\n\topacity: 1;\n}\n\n.monaco-editor .inline-folded:after {\n\tcolor: grey;\n\tmargin: 0.1em 0.2em 0 0.2em;\n\tcontent: "⋯";\n\tdisplay: inline;\n\tline-height: 1em;\n\tcursor: pointer;\n}\n', ""]);
                const a = r
            },
            36310: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* marker zone */\n\n.monaco-editor .peekview-widget .head .peekview-title .severity-icon {\n\tdisplay: inline-block;\n\tvertical-align: text-top;\n\tmargin-right: 4px;\n}\n\n.monaco-editor .marker-widget {\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .marker-widget > .stale {\n\topacity: 0.6;\n\tfont-style: italic;\n}\n\n.monaco-editor .marker-widget .title {\n\tdisplay: inline-block;\n\tpadding-right: 5px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer {\n\tposition: absolute;\n\twhite-space: pre;\n\t-moz-user-select: text;\n\t     user-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n\tpadding: 8px 12px 0 20px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message {\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message .details {\n\tpadding-left: 6px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message .source,\n.monaco-editor .marker-widget .descriptioncontainer .message span.code {\n\topacity: 0.6;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link {\n\topacity: 0.6;\n\tcolor: inherit;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link:before {\n\tcontent: '(';\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link:after {\n\tcontent: ')';\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link > span {\n\ttext-decoration: underline;\n\t/** Hack to force underline to show **/\n\tborder-bottom: 1px solid transparent;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .filename {\n\tcursor: pointer;\n}\n", ""]);
                const a = r
            },
            45291: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .goto-definition-link {\n\ttext-decoration: underline;\n\tcursor: pointer;\n}", ""]);
                const a = r
            },
            70835: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* -- zone widget */\n.monaco-editor .zone-widget .zone-widget-container.reference-zone-widget {\n\tborder-top-width: 1px;\n\tborder-bottom-width: 1px;\n}\n\n.monaco-editor .reference-zone-widget .inline {\n\tdisplay: inline-block;\n\tvertical-align: top;\n}\n\n.monaco-editor .reference-zone-widget .messages {\n\theight: 100%;\n\twidth: 100%;\n\ttext-align: center;\n\tpadding: 3em 0;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree {\n\tline-height: 23px;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference-file {\n\tdisplay: inline-flex;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .monaco-list:focus .selected .reference-file {\n\tcolor: inherit !important;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference-file .count {\n\tmargin-right: 12px;\n\tmargin-left: auto;\n}\n\n/* High Contrast Theming */\n\n.monaco-editor.hc-black .reference-zone-widget .ref-tree .reference-file {\n\tfont-weight: bold;\n}\n", ""]);
                const a = r
            },
            20074: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .suggest-preview-additional-widget {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .suggest-preview-additional-widget .content-spacer {\n\tcolor: transparent;\n\twhite-space: pre;\n}\n\n.monaco-editor .suggest-preview-additional-widget .button {\n\tdisplay: inline-block;\n\tcursor: pointer;\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .ghost-text-hidden {\n\topacity: 0;\n\tfont-size: 0;\n}\n\n.monaco-editor .ghost-text-decoration {\n\tfont-style: italic;\n}\n\n.monaco-editor .suggest-preview-text {\n\tfont-style: italic;\n}\n", ""]);
                const a = r
            },
            7547: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .detected-link,\n.monaco-editor .detected-link-active {\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .detected-link-active {\n\tcursor: pointer;\n}\n", ""]);
                const a = r
            },
            23565: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .monaco-editor-overlaymessage {\n\tpadding-bottom: 8px;\n\tz-index: 10000;\n}\n\n.monaco-editor .monaco-editor-overlaymessage.below {\n\tpadding-bottom: 0;\n\tpadding-top: 8px;\n\tz-index: 10000;\n}\n\n@keyframes fadeIn {\n\tfrom { opacity: 0; }\n\tto { opacity: 1; }\n}\n.monaco-editor .monaco-editor-overlaymessage.fadeIn {\n\tanimation: fadeIn 150ms ease-out;\n}\n\n@keyframes fadeOut {\n\tfrom { opacity: 1; }\n\tto { opacity: 0; }\n}\n.monaco-editor .monaco-editor-overlaymessage.fadeOut {\n\tanimation: fadeOut 100ms ease-out;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .message {\n\tpadding: 1px 4px;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .anchor {\n\twidth: 0 !important;\n\theight: 0 !important;\n\tborder-color: transparent;\n\tborder-style: solid;\n\tz-index: 1000;\n\tborder-width: 8px;\n\tposition: absolute;\n}\n\n.monaco-editor .monaco-editor-overlaymessage:not(.below) .anchor.top,\n.monaco-editor .monaco-editor-overlaymessage.below .anchor.below {\n\tdisplay: none;\n}\n\n.monaco-editor .monaco-editor-overlaymessage.below .anchor.top {\n\tdisplay: inherit;\n\ttop: -8px;\n}\n", ""]);
                const a = r
            },
            8955: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .parameter-hints-widget {\n\tz-index: 10;\n\tdisplay: flex;\n\tflex-direction: column;\n\tline-height: 1.5em;\n}\n\n.monaco-editor .parameter-hints-widget > .phwrapper {\n\tmax-width: 440px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n\n.monaco-editor .parameter-hints-widget.multiple {\n\tmin-height: 3.3em;\n\tpadding: 0;\n}\n\n.monaco-editor .parameter-hints-widget.visible {\n\ttransition: left .05s ease-in-out;\n}\n\n.monaco-editor .parameter-hints-widget p,\n.monaco-editor .parameter-hints-widget ul {\n\tmargin: 8px 0;\n}\n\n.monaco-editor .parameter-hints-widget .monaco-scrollable-element,\n.monaco-editor .parameter-hints-widget .body {\n\tdisplay: flex;\n\tflex: 1;\n\tflex-direction: column;\n\tmin-height: 100%;\n}\n\n.monaco-editor .parameter-hints-widget .signature {\n\tpadding: 4px 5px;\n}\n\n.monaco-editor .parameter-hints-widget .docs {\n\tpadding: 0 10px 0 5px;\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .parameter-hints-widget .docs.empty {\n\tdisplay: none;\n}\n\n.monaco-editor .parameter-hints-widget .docs .markdown-docs {\n\twhite-space: initial;\n}\n\n.monaco-editor .parameter-hints-widget .docs .markdown-docs code {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .parameter-hints-widget .docs .code {\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .parameter-hints-widget .docs code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-editor .parameter-hints-widget .controls {\n\tdisplay: none;\n\tflex-direction: column;\n\talign-items: center;\n\tmin-width: 22px;\n\tjustify-content: flex-end;\n}\n\n.monaco-editor .parameter-hints-widget.multiple .controls {\n\tdisplay: flex;\n\tpadding: 0 2px;\n}\n\n.monaco-editor .parameter-hints-widget.multiple .button {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tcursor: pointer;\n}\n\n.monaco-editor .parameter-hints-widget .button.previous {\n\tbottom: 24px;\n}\n\n.monaco-editor .parameter-hints-widget .overloads {\n\ttext-align: center;\n\theight: 12px;\n\tline-height: 12px;\n\topacity: 0.5;\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .parameter-hints-widget .signature .parameter.active {\n\tfont-weight: bold;\n}\n\n.monaco-editor .parameter-hints-widget .documentation-parameter > .parameter {\n\tfont-weight: bold;\n\tmargin-right: 0.5em;\n}\n", ""]);
                const a = r
            },
            62384: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .peekview-widget .head {\n\tbox-sizing: border-box;\n\tdisplay: flex;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title {\n\tdisplay: flex;\n\talign-items: center;\n\tfont-size: 13px;\n\tmargin-left: 20px;\n\tmin-width: 0;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title.clickable {\n\tcursor: pointer;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .dirname:not(:empty) {\n\tfont-size: 0.9em;\n\tmargin-left: 0.5em;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .meta {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .dirname {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .filename {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .meta:not(:empty)::before {\n\tcontent: '-';\n\tpadding: 0 0.3em;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions {\n\tflex: 1;\n\ttext-align: right;\n\tpadding-right: 2px;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar,\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar > .actions-container {\n\theight: 100%;\n}\n\n.monaco-editor .peekview-widget > .body {\n\tborder-top: 1px solid;\n\tposition: relative;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .codicon {\n\tmargin-right: 4px;\n}\n\n.monaco-editor .peekview-widget .monaco-list .monaco-list-row.focused .codicon {\n\tcolor: inherit !important;\n}\n", ""]);
                const a = r
            },
            57255: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .rename-box {\n\tz-index: 100;\n\tcolor: inherit;\n}\n\n.monaco-editor .rename-box.preview {\n\tpadding: 3px 3px 0 3px;\n}\n\n.monaco-editor .rename-box .rename-input {\n\tpadding: 3px;\n\twidth: calc(100% - 6px);\n}\n\n.monaco-editor .rename-box .rename-label {\n\tdisplay: none;\n\topacity: .8;\n}\n\n.monaco-editor .rename-box.preview .rename-label {\n\tdisplay: inherit;\n}\n", ""]);
                const a = r
            },
            50695: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .snippet-placeholder {\n\tmin-width: 2px;\n\toutline-style: solid;\n\toutline-width: 1px;\n}\n\n.monaco-editor .finish-snippet-placeholder {\n\toutline-style: solid;\n\toutline-width: 1px;\n}\n", ""]);
                const a = r
            },
            41948: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Suggest widget*/\n\n.monaco-editor .suggest-widget {\n\twidth: 430px;\n\tz-index: 40;\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.monaco-editor .suggest-widget.message {\n\tflex-direction: row;\n\talign-items: center;\n}\n\n.monaco-editor .suggest-widget,\n.monaco-editor .suggest-details {\n\tflex: 0 1 auto;\n\twidth: 100%;\n\tborder-style: solid;\n\tborder-width: 1px;\n}\n\n.monaco-editor.hc-black .suggest-widget,\n.monaco-editor.hc-black .suggest-details {\n\tborder-width: 2px;\n}\n\n/* Styles for status bar part */\n\n\n.monaco-editor .suggest-widget .suggest-status-bar {\n\tbox-sizing: border-box;\n\tdisplay: none;\n\tflex-flow: row nowrap;\n\tjustify-content: space-between;\n\twidth: 100%;\n\tfont-size: 80%;\n\tpadding: 0 4px 0 4px;\n\tborder-top: 1px solid transparent;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget .suggest-status-bar .left {\n\tpadding-right: 8px;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-label {\n\topacity: 0.5;\n\tcolor: inherit;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label::after {\n\tcontent: ', ';\n\tmargin-right: 0.3em;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row>.contents>.main>.right>.readMore,\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget.with-status-bar:not(.docs-side) .monaco-list .monaco-list-row:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: 100%;\n}\n\n/* Styles for Message element for when widget is loading or is empty */\n\n.monaco-editor .suggest-widget>.message {\n\tpadding-left: 22px;\n}\n\n/** Styles for the list element **/\n\n.monaco-editor .suggest-widget>.tree {\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list {\n\t-moz-user-select: none;\n\t     user-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n/** Styles for each row in the list element **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row {\n\tdisplay: flex;\n\t-mox-box-sizing: border-box;\n\tbox-sizing: border-box;\n\tpadding-right: 10px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 2px 2px;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents {\n\tflex: 1;\n\theight: 100%;\n\toverflow: hidden;\n\tpadding-left: 2px;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main {\n\tdisplay: flex;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: pre;\n\tjustify-content: space-between;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left, .monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget:not(.frozen) .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n/** ReadMore Icon styles **/\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore::before {\n\tcolor: inherit;\n\topacity: 1;\n\tfont-size: 14px;\n\tcursor: pointer;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close {\n\tposition: absolute;\n\ttop: 6px;\n\tright: 2px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close:hover,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore:hover {\n\topacity: 1;\n}\n\n/** signature, qualifier, type/details opacity **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\topacity: 0.7;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.signature-label {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.6;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.qualifier-label {\n\tmargin-left: 12px;\n\topacity: 0.4;\n\tfont-size: 85%;\n\tline-height: initial;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\talign-self: center;\n}\n\n/** Type Info and icon next to the label in the focused completion item **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tfont-size: 85%;\n\tmargin-left: 1.1em;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label>.monaco-tokenized-source {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItem#details, show on focus **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget:not(.shows-details) .monaco-list .monaco-list-row.focused>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItemLabel#details, always show **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.right>.details-label,\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row.focused:not(.string-label)>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Ellipsis on hover **/\n\n.monaco-editor .suggest-widget:not(.docs-side) .monaco-list .monaco-list-row:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: calc(100% - 26px);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left {\n\tflex-shrink: 1;\n\tflex-grow: 1;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 0;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.left>.monaco-icon-label {\n\tmax-width: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 1;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\toverflow: hidden;\n\tflex-shrink: 4;\n\tmax-width: 70%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\twidth: 18px;\n\theight: 18px;\n\tvisibility: hidden;\n}\n\n/** Do NOT display ReadMore when docs is side/below **/\n\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row>.contents>.main>.right>.readMore, .monaco-editor .suggest-widget.docs-below .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: none !important;\n}\n\n/** Do NOT display ReadMore when using plain CompletionItemLabel (details/documentation might not be resolved) **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n/** Focused item can show ReadMore, but can't when docs is side/below **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row>.contents>.main>.right>.readMore,\n.monaco-editor .suggest-widget.docs-below .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:hover>.contents>.main>.right>.readMore {\n\tvisibility: visible;\n}\n\n/** Styles for each row in the list **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated {\n\topacity: 0.66;\n\ttext-decoration: unset;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated>.monaco-icon-label-container>.monaco-icon-name-container {\n\ttext-decoration: line-through;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label::before {\n\theight: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon {\n\tdisplay: block;\n\theight: 16px;\n\twidth: 16px;\n\tmargin-left: 2px;\n\tbackground-repeat: no-repeat;\n\tbackground-size: 80%;\n\tbackground-position: center;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.hide {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .suggest-icon {\n\tdisplay: flex;\n\talign-items: center;\n\tmargin-right: 4px;\n}\n\n.monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .icon, .monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .suggest-icon::before {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.customcolor .colorspan {\n\tmargin: 0 0 0 0.3em;\n\tborder: 0.1em solid #000;\n\twidth: 0.7em;\n\theight: 0.7em;\n\tdisplay: inline-block;\n}\n\n/** Styles for the docs of the completion item in focus **/\n\n.monaco-editor .suggest-details-container {\n\tz-index: 41;\n}\n\n.monaco-editor .suggest-details {\n\tdisplay: flex;\n\tflex-direction: column;\n\tcursor: default;\n}\n\n.monaco-editor .suggest-details.no-docs {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element {\n\tflex: 1;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body {\n\tbox-sizing: border-box;\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type {\n\tflex: 2;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.7;\n\twhite-space: pre;\n\tmargin: 0 24px 0 0;\n\tpadding: 4px 0 12px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type.auto-wrap {\n\twhite-space: normal;\n\tword-break: break-all;\n}\n\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs {\n\tmargin: 0;\n\tpadding: 4px 5px;\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .suggest-details.no-type>.monaco-scrollable-element>.body>.docs {\n\tmargin-right: 24px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs {\n\tpadding: 0;\n\twhite-space: initial;\n\tmin-height: calc(1rem + 8px);\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div,\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>span:not(:empty) {\n\tpadding: 4px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:first-child {\n\tmargin-top: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:last-child {\n\tmargin-bottom: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .monaco-tokenized-source {\n\twhite-space: pre;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs .code {\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .codicon {\n\tvertical-align: sub;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>p:empty {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-editor .suggest-details ul {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details ol {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details p code {\n\tfont-family: var(--monaco-monospace-font);\n}\n", ""]);
                const a = r
            },
            26993: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .zone-widget {\n\tposition: absolute;\n\tz-index: 10;\n}\n\n\n.monaco-editor .zone-widget .zone-widget-container {\n\tborder-top-style: solid;\n\tborder-bottom-style: solid;\n\tborder-top-width: 0;\n\tborder-bottom-width: 0;\n\tposition: relative;\n}\n", ""]);
                const a = r
            },
            6916: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .accessibilityHelpWidget {\n\tpadding: 10px;\n\tvertical-align: middle;\n\toverflow: scroll;\n}", ""]);
                const a = r
            },
            44825: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => p
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s),
                    a = i(61667),
                    l = i.n(a),
                    c = new URL(i(6161), i.b),
                    d = new URL(i(51096), i.b),
                    h = r()(o()),
                    u = l()(c),
                    g = l()(d);
                h.push([e.id, `/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .iPadShowKeyboard {\n\twidth: 58px;\n\tmin-width: 0;\n\theight: 36px;\n\tmin-height: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tposition: absolute;\n\tresize: none;\n\toverflow: hidden;\n\tbackground: url(${u}) center center no-repeat;\n\tborder: 4px solid #F6F6F6;\n\tborder-radius: 4px;\n}\n\n.monaco-editor.vs-dark .iPadShowKeyboard {\n\tbackground: url(${g}) center center no-repeat;\n\tborder: 4px solid #252526;\n}`, ""]);
                const p = h
            },
            63523: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .tokens-inspect-widget {\n\tz-index: 50;\n\t-moz-user-select: text;\n\t     user-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n\tpadding: 10px;\n}\n\n.tokens-inspect-separator {\n\theight: 1px;\n\tborder: 0;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token-length {\n\tfont-weight: normal;\n\tfont-size: 60%;\n\tfloat: right;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-metadata-table {\n\twidth: 100%;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-metadata-value {\n\tfont-family: var(--monaco-monospace-font);\n\ttext-align: right;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token-type {\n\tfont-family: var(--monaco-monospace-font);\n}\n", ""]);
                const a = r
            },
            52674: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tfont-size: 13px;\n}\n\n.quick-input-widget .monaco-highlighted-label .highlight,\n.quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0066BF;\n}\n\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight,\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight {\n\tcolor: #9DDDFF;\n}\n\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight,\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0097fb;\n}\n\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight,\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #F38518;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(221, 221, 221, 0.4);\n\tborder: solid 1px rgba(204, 204, 204, 0.4);\n\tborder-bottom-color: rgba(187, 187, 187, 0.4);\n\tbox-shadow: inset 0 -1px 0 rgba(187, 187, 187, 0.4);\n\tcolor: #555;\n}\n\n.hc-black .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: transparent;\n\tborder: solid 1px rgb(111, 195, 223);\n\tbox-shadow: none;\n\tcolor: #fff;\n}\n\n.vs-dark .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(128, 128, 128, 0.17);\n\tborder: solid 1px rgba(51, 51, 51, 0.6);\n\tborder-bottom-color: rgba(68, 68, 68, 0.6);\n\tbox-shadow: inset 0 -1px 0 rgba(68, 68, 68, 0.6);\n\tcolor: #ccc;\n}\n", ""]);
                const a = r
            },
            12450: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, '/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n\n/* Default standalone editor fonts */\n.monaco-editor {\n\tfont-family: -apple-system, BlinkMacSystemFont, "Segoe WPC", "Segoe UI", "HelveticaNeue-Light", system-ui, "Ubuntu", "Droid Sans", sans-serif;\n\t--monaco-monospace-font: "SF Mono", Monaco, Menlo, Consolas, "Ubuntu Mono", "Liberation Mono", "DejaVu Sans Mono", "Courier New", monospace;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n.monaco-editor.hc-black .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-hover p {\n\tmargin: 0;\n}\n\n/* See https://github.com/microsoft/monaco-editor/issues/2168#issuecomment-780078600 */\n.monaco-aria-container {\n\tposition: absolute !important;\n\ttop: 0; /* avoid being placed underneath a sibling element */\n\theight: 1px;\n\twidth: 1px;\n\tmargin: -1px;\n\toverflow: hidden;\n\tpadding: 0;\n\tclip: rect(1px, 1px, 1px, 1px);\n\t-webkit-clip-path: inset(50%);\n\t        clip-path: inset(50%);\n}\n\n/* The hc-black theme is already high contrast optimized */\n.monaco-editor.hc-black {\n\t-ms-high-contrast-adjust: none;\n}\n/* In case the browser goes into high contrast mode and the editor is not configured with the hc-black theme */\n@media screen and (-ms-high-contrast:active) {\n\n\t/* current line highlight */\n\t.monaco-editor.vs .view-overlays .current-line,\n\t.monaco-editor.vs-dark .view-overlays .current-line {\n\t\tborder-color: windowtext !important;\n\t\tborder-left: 0;\n\t\tborder-right: 0;\n\t}\n\n\t/* view cursors */\n\t.monaco-editor.vs .cursor,\n\t.monaco-editor.vs-dark .cursor {\n\t\tbackground-color: windowtext !important;\n\t}\n\t/* dnd target */\n\t.monaco-editor.vs .dnd-target,\n\t.monaco-editor.vs-dark .dnd-target {\n\t\tborder-color: windowtext !important;\n\t}\n\n\t/* selected text background */\n\t.monaco-editor.vs .selected-text,\n\t.monaco-editor.vs-dark .selected-text {\n\t\tbackground-color: highlight !important;\n\t}\n\n\t/* allow the text to have a transparent background. */\n\t.monaco-editor.vs .view-line,\n\t.monaco-editor.vs-dark .view-line {\n\t\t-ms-high-contrast-adjust: none;\n\t}\n\n\t/* text color */\n\t.monaco-editor.vs .view-line span,\n\t.monaco-editor.vs-dark .view-line span {\n\t\tcolor: windowtext !important;\n\t}\n\t/* selected text color */\n\t.monaco-editor.vs .view-line span.inline-selected-text,\n\t.monaco-editor.vs-dark .view-line span.inline-selected-text {\n\t\tcolor: highlighttext !important;\n\t}\n\n\t/* allow decorations */\n\t.monaco-editor.vs .view-overlays,\n\t.monaco-editor.vs-dark .view-overlays {\n\t\t-ms-high-contrast-adjust: none;\n\t}\n\n\t/* various decorations */\n\t.monaco-editor.vs .selectionHighlight,\n\t.monaco-editor.vs-dark .selectionHighlight,\n\t.monaco-editor.vs .wordHighlight,\n\t.monaco-editor.vs-dark .wordHighlight,\n\t.monaco-editor.vs .wordHighlightStrong,\n\t.monaco-editor.vs-dark .wordHighlightStrong,\n\t.monaco-editor.vs .reference-decoration,\n\t.monaco-editor.vs-dark .reference-decoration {\n\t\tborder: 2px dotted highlight !important;\n\t\tbackground: transparent !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .rangeHighlight,\n\t.monaco-editor.vs-dark .rangeHighlight {\n\t\tbackground: transparent !important;\n\t\tborder: 1px dotted activeborder !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .bracket-match,\n\t.monaco-editor.vs-dark .bracket-match {\n\t\tborder-color: windowtext !important;\n\t\tbackground: transparent !important;\n\t}\n\n\t/* find widget */\n\t.monaco-editor.vs .findMatch,\n\t.monaco-editor.vs-dark .findMatch,\n\t.monaco-editor.vs .currentFindMatch,\n\t.monaco-editor.vs-dark .currentFindMatch {\n\t\tborder: 2px dotted activeborder !important;\n\t\tbackground: transparent !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .find-widget,\n\t.monaco-editor.vs-dark .find-widget {\n\t\tborder: 1px solid windowtext;\n\t}\n\n\t/* list - used by suggest widget */\n\t.monaco-editor.vs .monaco-list .monaco-list-row,\n\t.monaco-editor.vs-dark .monaco-list .monaco-list-row {\n\t\t-ms-high-contrast-adjust: none;\n\t\tcolor: windowtext !important;\n\t}\n\t.monaco-editor.vs .monaco-list .monaco-list-row.focused,\n\t.monaco-editor.vs-dark .monaco-list .monaco-list-row.focused {\n\t\tcolor: highlighttext !important;\n\t\tbackground-color: highlight !important;\n\t}\n\t.monaco-editor.vs .monaco-list .monaco-list-row:hover,\n\t.monaco-editor.vs-dark .monaco-list .monaco-list-row:hover {\n\t\tbackground: transparent !important;\n\t\tborder: 1px solid highlight;\n\t\tbox-sizing: border-box;\n\t}\n\n\t/* scrollbars */\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar {\n\t\t-ms-high-contrast-adjust: none;\n\t\tbackground: background !important;\n\t\tborder: 1px solid windowtext;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar > .slider,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar > .slider {\n\t\tbackground: windowtext !important;\n\t}\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar > .slider:hover,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar > .slider:hover {\n\t\tbackground: highlight !important;\n\t}\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar > .slider.active,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar > .slider.active {\n\t\tbackground: highlight !important;\n\t}\n\n\t/* overview ruler */\n\t.monaco-editor.vs .decorationsOverviewRuler,\n\t.monaco-editor.vs-dark .decorationsOverviewRuler {\n\t\topacity: 0;\n\t}\n\n\t/* minimap */\n\t.monaco-editor.vs .minimap,\n\t.monaco-editor.vs-dark .minimap {\n\t\tdisplay: none;\n\t}\n\n\t/* squiggles */\n\t.monaco-editor.vs .squiggly-d-error,\n\t.monaco-editor.vs-dark .squiggly-d-error {\n\t\tbackground: transparent !important;\n\t\tborder-bottom: 4px double #E47777;\n\t}\n\t.monaco-editor.vs .squiggly-c-warning,\n\t.monaco-editor.vs-dark .squiggly-c-warning {\n\t\tborder-bottom: 4px double #71B771;\n\t}\n\t.monaco-editor.vs .squiggly-b-info,\n\t.monaco-editor.vs-dark .squiggly-b-info {\n\t\tborder-bottom: 4px double #71B771;\n\t}\n\t.monaco-editor.vs .squiggly-a-hint,\n\t.monaco-editor.vs-dark .squiggly-a-hint {\n\t\tborder-bottom: 4px double #6c6c6c;\n\t}\n\n\t/* contextmenu */\n\t.monaco-editor.vs .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n\t.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label {\n\t\t-ms-high-contrast-adjust: none;\n\t\tcolor: highlighttext !important;\n\t\tbackground-color: highlight !important;\n\t}\n\t.monaco-editor.vs .monaco-menu .monaco-action-bar.vertical .action-menu-item:hover .action-label,\n\t.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:hover .action-label {\n\t\t-ms-high-contrast-adjust: none;\n\t\tbackground: transparent !important;\n\t\tborder: 1px solid highlight;\n\t\tbox-sizing: border-box;\n\t}\n\n\t/* diff editor */\n\t.monaco-diff-editor.vs .diffOverviewRuler,\n\t.monaco-diff-editor.vs-dark .diffOverviewRuler {\n\t\tdisplay: none;\n\t}\n\t.monaco-editor.vs .line-insert,\n\t.monaco-editor.vs-dark .line-insert,\n\t.monaco-editor.vs .line-delete,\n\t.monaco-editor.vs-dark .line-delete {\n\t\tbackground: transparent !important;\n\t\tborder: 1px solid highlight !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .char-insert,\n\t.monaco-editor.vs-dark .char-insert,\n\t.monaco-editor.vs .char-delete,\n\t.monaco-editor.vs-dark .char-delete {\n\t\tbackground: transparent !important;\n\t}\n}\n\n/*.monaco-editor.vs [tabindex="0"]:focus {\n\toutline: 1px solid rgba(0, 122, 204, 0.4);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}\n\n.monaco-editor.vs-dark [tabindex="0"]:focus {\n\toutline: 1px solid rgba(14, 99, 156, 0.6);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}*/\n', ""]);
                const a = r
            },
            29593: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar .action-item.menu-entry .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n.monaco-action-bar .action-item.menu-entry .action-label {\n\tbackground-image: var(--menu-entry-icon-light);\n}\n\n.vs-dark .monaco-action-bar .action-item.menu-entry .action-label,\n.hc-black .monaco-action-bar .action-item.menu-entry .action-label {\n\tbackground-image: var(--menu-entry-icon-dark);\n}\n\n\n.monaco-dropdown-with-default {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-default > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-default > .action-container.menu-entry > .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n.monaco-dropdown-with-default > .action-container.menu-entry > .action-label {\n\tbackground-image: var(--menu-entry-icon-light);\n}\n\n.vs-dark .monaco-dropdown-with-default > .action-container.menu-entry > .action-label,\n.hc-black .monaco-dropdown-with-default > .action-container.menu-entry > .action-label {\n\tbackground-image: var(--menu-entry-icon-dark);\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n", ""]);
                const a = r
            },
            52021: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.context-view .monaco-menu {\n\tmin-width: 130px;\n}\n\n", ""]);
                const a = r
            },
            66853: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => u
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s),
                    a = i(61667),
                    l = i.n(a),
                    c = new URL(i(49944), i.b),
                    d = r()(o()),
                    h = l()(c);
                d.push([e.id, `/*\n! tailwindcss v3.0.23 | MIT License | https://tailwindcss.com\n*//*\n1. Prevent padding and border from affecting element width. (https://github.com/mozdevs/cssremedy/issues/4)\n2. Allow adding a border to an element by just adding a border-width. (https://github.com/tailwindcss/tailwindcss/pull/116)\n*/\n\n*,\n::before,\n::after {\n  box-sizing: border-box; /* 1 */\n  border-width: 0; /* 2 */\n  border-style: solid; /* 2 */\n  border-color: #e5e7eb; /* 2 */\n}\n\n::before,\n::after {\n  --tw-content: '';\n}\n\n/*\n1. Use a consistent sensible line-height in all browsers.\n2. Prevent adjustments of font size after orientation changes in iOS.\n3. Use a more readable tab size.\n4. Use the user's configured \`sans\` font-family by default.\n*/\n\nhtml {\n  line-height: 1.5; /* 1 */\n  -webkit-text-size-adjust: 100%; /* 2 */\n  -moz-tab-size: 4; /* 3 */\n  -o-tab-size: 4;\n     tab-size: 4; /* 3 */\n  font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; /* 4 */\n}\n\n/*\n1. Remove the margin in all browsers.\n2. Inherit line-height from \`html\` so users can set them as a class directly on the \`html\` element.\n*/\n\nbody {\n  margin: 0; /* 1 */\n  line-height: inherit; /* 2 */\n}\n\n/*\n1. Add the correct height in Firefox.\n2. Correct the inheritance of border color in Firefox. (https://bugzilla.mozilla.org/show_bug.cgi?id=190655)\n3. Ensure horizontal rules are visible by default.\n*/\n\nhr {\n  height: 0; /* 1 */\n  color: inherit; /* 2 */\n  border-top-width: 1px; /* 3 */\n}\n\n/*\nAdd the correct text decoration in Chrome, Edge, and Safari.\n*/\n\nabbr:where([title]) {\n  -webkit-text-decoration: underline dotted;\n          text-decoration: underline dotted;\n}\n\n/*\nRemove the default font size and weight for headings.\n*/\n\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  font-size: inherit;\n  font-weight: inherit;\n}\n\n/*\nReset links to optimize for opt-in styling instead of opt-out.\n*/\n\na {\n  color: inherit;\n  text-decoration: inherit;\n}\n\n/*\nAdd the correct font weight in Edge and Safari.\n*/\n\nb,\nstrong {\n  font-weight: bolder;\n}\n\n/*\n1. Use the user's configured \`mono\` font family by default.\n2. Correct the odd \`em\` font sizing in all browsers.\n*/\n\ncode,\nkbd,\nsamp,\npre {\n  font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; /* 1 */\n  font-size: 1em; /* 2 */\n}\n\n/*\nAdd the correct font size in all browsers.\n*/\n\nsmall {\n  font-size: 80%;\n}\n\n/*\nPrevent \`sub\` and \`sup\` elements from affecting the line height in all browsers.\n*/\n\nsub,\nsup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\n\nsub {\n  bottom: -0.25em;\n}\n\nsup {\n  top: -0.5em;\n}\n\n/*\n1. Remove text indentation from table contents in Chrome and Safari. (https://bugs.chromium.org/p/chromium/issues/detail?id=999088, https://bugs.webkit.org/show_bug.cgi?id=201297)\n2. Correct table border color inheritance in all Chrome and Safari. (https://bugs.chromium.org/p/chromium/issues/detail?id=935729, https://bugs.webkit.org/show_bug.cgi?id=195016)\n3. Remove gaps between table borders by default.\n*/\n\ntable {\n  text-indent: 0; /* 1 */\n  border-color: inherit; /* 2 */\n  border-collapse: collapse; /* 3 */\n}\n\n/*\n1. Change the font styles in all browsers.\n2. Remove the margin in Firefox and Safari.\n3. Remove default padding in all browsers.\n*/\n\nbutton,\ninput,\noptgroup,\nselect,\ntextarea {\n  font-family: inherit; /* 1 */\n  font-size: 100%; /* 1 */\n  line-height: inherit; /* 1 */\n  color: inherit; /* 1 */\n  margin: 0; /* 2 */\n  padding: 0; /* 3 */\n}\n\n/*\nRemove the inheritance of text transform in Edge and Firefox.\n*/\n\nbutton,\nselect {\n  text-transform: none;\n}\n\n/*\n1. Correct the inability to style clickable types in iOS and Safari.\n2. Remove default button styles.\n*/\n\nbutton,\n[type='button'],\n[type='reset'],\n[type='submit'] {\n  -webkit-appearance: button; /* 1 */\n  background-color: transparent; /* 2 */\n  background-image: none; /* 2 */\n}\n\n/*\nUse the modern Firefox focus style for all focusable elements.\n*/\n\n:-moz-focusring {\n  outline: auto;\n}\n\n/*\nRemove the additional \`:invalid\` styles in Firefox. (https://github.com/mozilla/gecko-dev/blob/2f9eacd9d3d995c937b4251a5557d95d494c9be1/layout/style/res/forms.css#L728-L737)\n*/\n\n:-moz-ui-invalid {\n  box-shadow: none;\n}\n\n/*\nAdd the correct vertical alignment in Chrome and Firefox.\n*/\n\nprogress {\n  vertical-align: baseline;\n}\n\n/*\nCorrect the cursor style of increment and decrement buttons in Safari.\n*/\n\n::-webkit-inner-spin-button,\n::-webkit-outer-spin-button {\n  height: auto;\n}\n\n/*\n1. Correct the odd appearance in Chrome and Safari.\n2. Correct the outline style in Safari.\n*/\n\n[type='search'] {\n  -webkit-appearance: textfield; /* 1 */\n  outline-offset: -2px; /* 2 */\n}\n\n/*\nRemove the inner padding in Chrome and Safari on macOS.\n*/\n\n::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\n\n/*\n1. Correct the inability to style clickable types in iOS and Safari.\n2. Change font properties to \`inherit\` in Safari.\n*/\n\n::-webkit-file-upload-button {\n  -webkit-appearance: button; /* 1 */\n  font: inherit; /* 2 */\n}\n\n/*\nAdd the correct display in Chrome and Safari.\n*/\n\nsummary {\n  display: list-item;\n}\n\n/*\nRemoves the default spacing and border for appropriate elements.\n*/\n\nblockquote,\ndl,\ndd,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\nhr,\nfigure,\np,\npre {\n  margin: 0;\n}\n\nfieldset {\n  margin: 0;\n  padding: 0;\n}\n\nlegend {\n  padding: 0;\n}\n\nol,\nul,\nmenu {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n}\n\n/*\nPrevent resizing textareas horizontally by default.\n*/\n\ntextarea {\n  resize: vertical;\n}\n\n/*\n1. 重启 the default placeholder opacity in Firefox. (https://github.com/tailwindlabs/tailwindcss/issues/3300)\n2. Set the default placeholder color to the user's configured gray 400 color.\n*/\n\ninput::-moz-placeholder, textarea::-moz-placeholder {\n  opacity: 1; /* 1 */\n  color: #9ca3af; /* 2 */\n}\n\ninput:-ms-input-placeholder, textarea:-ms-input-placeholder {\n  opacity: 1; /* 1 */\n  color: #9ca3af; /* 2 */\n}\n\ninput::placeholder,\ntextarea::placeholder {\n  opacity: 1; /* 1 */\n  color: #9ca3af; /* 2 */\n}\n\n/*\nSet the default cursor for buttons.\n*/\n\nbutton,\n[role="button"] {\n  cursor: pointer;\n}\n\n/*\nMake sure disabled buttons don't get the pointer cursor.\n*/\n:disabled {\n  cursor: default;\n}\n\n/*\n1. Make replaced elements \`display: block\` by default. (https://github.com/mozdevs/cssremedy/issues/14)\n2. Add \`vertical-align: middle\` to align replaced elements more sensibly by default. (https://github.com/jensimmons/cssremedy/issues/14#issuecomment-634934210)\n   This can trigger a poorly considered lint error in some tools but is included by design.\n*/\n\nimg,\nsvg,\nvideo,\ncanvas,\naudio,\niframe,\nembed,\nobject {\n  display: block; /* 1 */\n  vertical-align: middle; /* 2 */\n}\n\n/*\nConstrain images and videos to the parent width and preserve their intrinsic aspect ratio. (https://github.com/mozdevs/cssremedy/issues/14)\n*/\n\nimg,\nvideo {\n  max-width: 100%;\n  height: auto;\n}\n\n/*\nEnsure the default browser behavior of the \`hidden\` attribute.\n*/\n\n[hidden] {\n  display: none;\n}\n  @font-face {\n    font-family: 'Material Icons';\n    src: url(${h}) format('woff2');\n  }\n\n*, ::before, ::after {\n  --tw-translate-x: 0;\n  --tw-translate-y: 0;\n  --tw-rotate: 0;\n  --tw-skew-x: 0;\n  --tw-skew-y: 0;\n  --tw-scale-x: 1;\n  --tw-scale-y: 1;\n  --tw-pan-x:  ;\n  --tw-pan-y:  ;\n  --tw-pinch-zoom:  ;\n  --tw-scroll-snap-strictness: proximity;\n  --tw-ordinal:  ;\n  --tw-slashed-zero:  ;\n  --tw-numeric-figure:  ;\n  --tw-numeric-spacing:  ;\n  --tw-numeric-fraction:  ;\n  --tw-ring-inset:  ;\n  --tw-ring-offset-width: 0px;\n  --tw-ring-offset-color: #fff;\n  --tw-ring-color: rgb(59 130 246 / 0.5);\n  --tw-ring-offset-shadow: 0 0 #0000;\n  --tw-ring-shadow: 0 0 #0000;\n  --tw-shadow: 0 0 #0000;\n  --tw-shadow-colored: 0 0 #0000;\n  --tw-blur:  ;\n  --tw-brightness:  ;\n  --tw-contrast:  ;\n  --tw-grayscale:  ;\n  --tw-hue-rotate:  ;\n  --tw-invert:  ;\n  --tw-saturate:  ;\n  --tw-sepia:  ;\n  --tw-drop-shadow:  ;\n  --tw-backdrop-blur:  ;\n  --tw-backdrop-brightness:  ;\n  --tw-backdrop-contrast:  ;\n  --tw-backdrop-grayscale:  ;\n  --tw-backdrop-hue-rotate:  ;\n  --tw-backdrop-invert:  ;\n  --tw-backdrop-opacity:  ;\n  --tw-backdrop-saturate:  ;\n  --tw-backdrop-sepia:  ;\n}\n.icon {\n    font-family: 'Material Icons';\n    font-weight: normal;\n    font-style: normal;\n    font-size: 18px; /* Preferred icon size */\n    display: inline-block;\n    line-height: 1;\n    text-transform: none;\n    letter-spacing: normal;\n    word-wrap: normal;\n    white-space: nowrap;\n    direction: ltr;\n    text-rendering: optimizeLegibility;\n    font-feature-settings: 'liga';\n    -webkit-font-smoothing: antialiased;\n  }\n.visible {\n  visibility: visible;\n}\n.static {\n  position: static;\n}\n.fixed {\n  position: fixed;\n}\n.absolute {\n  position: absolute;\n}\n.relative {\n  position: relative;\n}\n.top-0 {\n  top: 0px;\n}\n.left-0 {\n  left: 0px;\n}\n.left-1\\/2 {\n  left: 50%;\n}\n.top-1\\/2 {\n  top: 50%;\n}\n.top-\\[32px\\] {\n  top: 32px;\n}\n.right-2 {\n  right: 0.5rem;\n}\n.bottom-3 {\n  bottom: 0.75rem;\n}\n.left-\\[calc\\(50\\%\\+85px\\)\\] {\n  left: calc(50% + 85px);\n}\n.left-3 {\n  left: 0.75rem;\n}\n.top-8 {\n  top: 2rem;\n}\n.bottom-6 {\n  bottom: 1.5rem;\n}\n.top-\\[25px\\] {\n  top: 25px;\n}\n.left-\\[170px\\] {\n  left: 170px;\n}\n.z-10 {\n  z-index: 10;\n}\n.z-\\[120\\] {\n  z-index: 120;\n}\n.z-50 {\n  z-index: 50;\n}\n.mx-4 {\n  margin-left: 1rem;\n  margin-right: 1rem;\n}\n.mt-\\[1000px\\] {\n  margin-top: 1000px;\n}\n.mr-\\[20px\\] {\n  margin-right: 20px;\n}\n.mr-2 {\n  margin-right: 0.5rem;\n}\n.mt-\\[2px\\] {\n  margin-top: 2px;\n}\n.ml-\\[5px\\] {\n  margin-left: 5px;\n}\n.mr-4 {\n  margin-right: 1rem;\n}\n.ml-1 {\n  margin-left: 0.25rem;\n}\n.mr-\\[15px\\] {\n  margin-right: 15px;\n}\n.mb-\\[10px\\] {\n  margin-bottom: 10px;\n}\n.mb-1 {\n  margin-bottom: 0.25rem;\n}\n.block {\n  display: block;\n}\n.inline-block {\n  display: inline-block;\n}\n.flex {\n  display: flex;\n}\n.grid {\n  display: grid;\n}\n.list-item {\n  display: list-item;\n}\n.hidden {\n  display: none;\n}\n.h-full {\n  height: 100%;\n}\n.h-4\\/5 {\n  height: 80%;\n}\n.h-\\[calc\\(100\\%-300px\\)\\] {\n  height: calc(100% - 300px);\n}\n.h-\\[40px\\] {\n  height: 40px;\n}\n.h-fit {\n  height: -moz-fit-content;\n  height: fit-content;\n}\n.h-\\[90px\\] {\n  height: 90px;\n}\n.h-\\[35px\\] {\n  height: 35px;\n}\n.h-3\\/5 {\n  height: 60%;\n}\n.h-2 {\n  height: 0.5rem;\n}\n.h-\\[1px\\] {\n  height: 1px;\n}\n.h-\\[calc\\(100\\%_-_25px\\)\\] {\n  height: calc(100% - 25px);\n}\n.h-\\[18px\\] {\n  height: 18px;\n}\n.max-h-\\[500px\\] {\n  max-height: 500px;\n}\n.min-h-\\[400px\\] {\n  min-height: 400px;\n}\n.w-full {\n  width: 100%;\n}\n.w-3\\/5 {\n  width: 60%;\n}\n.w-\\[calc\\(100\\%-200px\\)\\] {\n  width: calc(100% - 200px);\n}\n.w-fit {\n  width: -moz-fit-content;\n  width: fit-content;\n}\n.w-\\[90px\\] {\n  width: 90px;\n}\n.w-2 {\n  width: 0.5rem;\n}\n.w-\\[80px\\] {\n  width: 80px;\n}\n.w-\\[calc\\(100\\%_-_170px\\)\\] {\n  width: calc(100% - 170px);\n}\n.w-\\[500px\\] {\n  width: 500px;\n}\n.w-\\[18px\\] {\n  width: 18px;\n}\n.w-\\[200px\\] {\n  width: 200px;\n}\n.min-w-\\[500px\\] {\n  min-width: 500px;\n}\n.max-w-full {\n  max-width: 100%;\n}\n.max-w-\\[350px\\] {\n  max-width: 350px;\n}\n.max-w-\\[120px\\] {\n  max-width: 120px;\n}\n.flex-1 {\n  flex: 1 1 0%;\n}\n.flex-shrink-0 {\n  flex-shrink: 0;\n}\n.flex-shrink {\n  flex-shrink: 1;\n}\n.flex-grow {\n  flex-grow: 1;\n}\n.flex-grow-0 {\n  flex-grow: 0;\n}\n.-translate-x-1\\/2 {\n  --tw-translate-x: -50%;\n  transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));\n}\n.-translate-y-1\\/2 {\n  --tw-translate-y: -50%;\n  transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));\n}\n.translate-y-\\[2px\\] {\n  --tw-translate-y: 2px;\n  transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));\n}\n.-translate-y-1 {\n  --tw-translate-y: -0.25rem;\n  transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));\n}\n.rotate-90 {\n  --tw-rotate: 90deg;\n  transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));\n}\n.transform {\n  transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));\n}\n@keyframes bounce {\n\n  0%, 100% {\n    transform: translateY(-25%);\n    animation-timing-function: cubic-bezier(0.8,0,1,1);\n  }\n\n  50% {\n    transform: none;\n    animation-timing-function: cubic-bezier(0,0,0.2,1);\n  }\n}\n.animate-bounce {\n  animation: bounce 1s infinite;\n}\n.cursor-pointer {\n  cursor: pointer;\n}\n.cursor-move {\n  cursor: move;\n}\n.select-text {\n  -webkit-user-select: text;\n     -moz-user-select: text;\n      -ms-user-select: text;\n          user-select: text;\n}\n.resize {\n  resize: both;\n}\n.grid-cols-2 {\n  grid-template-columns: repeat(2, minmax(0, 1fr));\n}\n.grid-cols-4 {\n  grid-template-columns: repeat(4, minmax(0, 1fr));\n}\n.flex-col {\n  flex-direction: column;\n}\n.flex-wrap {\n  flex-wrap: wrap;\n}\n.items-center {\n  align-items: center;\n}\n.items-baseline {\n  align-items: baseline;\n}\n.justify-center {\n  justify-content: center;\n}\n.justify-between {\n  justify-content: space-between;\n}\n.gap-\\[20px\\] {\n  gap: 20px;\n}\n.gap-1 {\n  gap: 0.25rem;\n}\n.gap-2 {\n  gap: 0.5rem;\n}\n.gap-3 {\n  gap: 0.75rem;\n}\n.gap-x-\\[20px\\] {\n  -moz-column-gap: 20px;\n       column-gap: 20px;\n}\n.gap-x-1 {\n  -moz-column-gap: 0.25rem;\n       column-gap: 0.25rem;\n}\n.gap-y-1 {\n  row-gap: 0.25rem;\n}\n.gap-x-3 {\n  -moz-column-gap: 0.75rem;\n       column-gap: 0.75rem;\n}\n.gap-x-\\[2px\\] {\n  -moz-column-gap: 2px;\n       column-gap: 2px;\n}\n.gap-x-4 {\n  -moz-column-gap: 1rem;\n       column-gap: 1rem;\n}\n.gap-x-5 {\n  -moz-column-gap: 1.25rem;\n       column-gap: 1.25rem;\n}\n.gap-x-2 {\n  -moz-column-gap: 0.5rem;\n       column-gap: 0.5rem;\n}\n.overflow-auto {\n  overflow: auto;\n}\n.overflow-hidden {\n  overflow: hidden;\n}\n.overflow-clip {\n  overflow: clip;\n}\n.overflow-y-auto {\n  overflow-y: auto;\n}\n.text-ellipsis {\n  text-overflow: ellipsis;\n}\n.whitespace-normal {\n  white-space: normal;\n}\n.whitespace-pre {\n  white-space: pre;\n}\n.whitespace-pre-wrap {\n  white-space: pre-wrap;\n}\n.break-words {\n  overflow-wrap: break-word;\n}\n.break-all {\n  word-break: break-all;\n}\n.rounded-md {\n  border-radius: 0.375rem;\n}\n.rounded {\n  border-radius: 0.25rem;\n}\n.rounded-\\[10px\\] {\n  border-radius: 10px;\n}\n.rounded-full {\n  border-radius: 9999px;\n}\n.rounded-lg {\n  border-radius: 0.5rem;\n}\n.rounded-2xl {\n  border-radius: 1rem;\n}\n.rounded-br-none {\n  border-bottom-right-radius: 0px;\n}\n.rounded-tr-none {\n  border-top-right-radius: 0px;\n}\n.border {\n  border-width: 1px;\n}\n.border-\\[1px\\] {\n  border-width: 1px;\n}\n.border-b {\n  border-bottom-width: 1px;\n}\n.\\!border-b-0 {\n  border-bottom-width: 0px !important;\n}\n.border-solid {\n  border-style: solid;\n}\n.border-\\[color\\:var\\(--bc\\)\\] {\n  border-color: var(--bc);\n}\n.border-\\[color\\:rgb\\(85\\2c 79\\2c 79\\)\\] {\n  --tw-border-opacity: 1;\n  border-color: rgb(85 79 79 / var(--tw-border-opacity));\n}\n.border-b-\\[color\\:var\\(--bc\\)\\] {\n  border-bottom-color: var(--bc);\n}\n.border-opacity-50 {\n  --tw-border-opacity: 0.5;\n}\n.bg-\\[color\\:var\\(--bgc\\)\\] {\n  background-color: var(--bgc);\n}\n.bg-\\[color\\:var\\(--mask-c\\)\\] {\n  background-color: var(--mask-c);\n}\n.bg-\\[color\\:var\\(--mbgc\\)\\] {\n  background-color: var(--mbgc);\n}\n.bg-\\[color\\:var\\(--proxy-item-bgc\\)\\] {\n  background-color: var(--proxy-item-bgc);\n}\n.bg-black {\n  --tw-bg-opacity: 1;\n  background-color: rgb(0 0 0 / var(--tw-bg-opacity));\n}\n.bg-\\[color\\:var\\(--proxy-item-selected-border-c\\)\\] {\n  background-color: var(--proxy-item-selected-border-c);\n}\n.bg-green-400 {\n  --tw-bg-opacity: 1;\n  background-color: rgb(74 222 128 / var(--tw-bg-opacity));\n}\n.bg-red-400 {\n  --tw-bg-opacity: 1;\n  background-color: rgb(248 113 113 / var(--tw-bg-opacity));\n}\n.bg-gray-400 {\n  --tw-bg-opacity: 1;\n  background-color: rgb(156 163 175 / var(--tw-bg-opacity));\n}\n.bg-\\[\\#1E1E1E\\] {\n  --tw-bg-opacity: 1;\n  background-color: rgb(30 30 30 / var(--tw-bg-opacity));\n}\n.bg-\\[color\\:\\#14A53A\\] {\n  --tw-bg-opacity: 1;\n  background-color: rgb(20 165 58 / var(--tw-bg-opacity));\n}\n.bg-\\[\\#6f6f6f\\] {\n  --tw-bg-opacity: 1;\n  background-color: rgb(111 111 111 / var(--tw-bg-opacity));\n}\n.bg-\\[color\\:\\#1C1C1C\\] {\n  --tw-bg-opacity: 1;\n  background-color: rgb(28 28 28 / var(--tw-bg-opacity));\n}\n.bg-cyan-500 {\n  --tw-bg-opacity: 1;\n  background-color: rgb(6 182 212 / var(--tw-bg-opacity));\n}\n.bg-gray-500 {\n  --tw-bg-opacity: 1;\n  background-color: rgb(107 114 128 / var(--tw-bg-opacity));\n}\n.bg-\\[color\\:\\#2c2a38\\] {\n  --tw-bg-opacity: 1;\n  background-color: rgb(44 42 56 / var(--tw-bg-opacity));\n}\n.bg-gray-300 {\n  --tw-bg-opacity: 1;\n  background-color: rgb(209 213 219 / var(--tw-bg-opacity));\n}\n.bg-\\[color\\:\\#64646480\\] {\n  background-color: #64646480;\n}\n.bg-opacity-80 {\n  --tw-bg-opacity: 0.8;\n}\n.p-4 {\n  padding: 1rem;\n}\n.p-2 {\n  padding: 0.5rem;\n}\n.px-4 {\n  padding-left: 1rem;\n  padding-right: 1rem;\n}\n.py-3 {\n  padding-top: 0.75rem;\n  padding-bottom: 0.75rem;\n}\n.px-3 {\n  padding-left: 0.75rem;\n  padding-right: 0.75rem;\n}\n.py-1 {\n  padding-top: 0.25rem;\n  padding-bottom: 0.25rem;\n}\n.px-2 {\n  padding-left: 0.5rem;\n  padding-right: 0.5rem;\n}\n.py-2 {\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n}\n.px-6 {\n  padding-left: 1.5rem;\n  padding-right: 1.5rem;\n}\n.py-\\[2px\\] {\n  padding-top: 2px;\n  padding-bottom: 2px;\n}\n.px-5 {\n  padding-left: 1.25rem;\n  padding-right: 1.25rem;\n}\n.py-4 {\n  padding-top: 1rem;\n  padding-bottom: 1rem;\n}\n.pl-3 {\n  padding-left: 0.75rem;\n}\n.pr-6 {\n  padding-right: 1.5rem;\n}\n.pt-3 {\n  padding-top: 0.75rem;\n}\n.pb-3 {\n  padding-bottom: 0.75rem;\n}\n.pt-2 {\n  padding-top: 0.5rem;\n}\n.pl-4 {\n  padding-left: 1rem;\n}\n.pr-4 {\n  padding-right: 1rem;\n}\n.pb-2 {\n  padding-bottom: 0.5rem;\n}\n.pr-1 {\n  padding-right: 0.25rem;\n}\n.text-center {\n  text-align: center;\n}\n.font-sans {\n  font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";\n}\n.text-sm {\n  font-size: 0.875rem;\n  line-height: 1.25rem;\n}\n.text-xs {\n  font-size: 0.75rem;\n  line-height: 1rem;\n}\n.text-base {\n  font-size: 1rem;\n  line-height: 1.5rem;\n}\n.text-\\[14px\\] {\n  font-size: 14px;\n}\n.text-\\[10px\\] {\n  font-size: 10px;\n}\n.text-lg {\n  font-size: 1.125rem;\n  line-height: 1.75rem;\n}\n.text-\\[20px\\] {\n  font-size: 20px;\n}\n.font-normal {\n  font-weight: 400;\n}\n.capitalize {\n  text-transform: capitalize;\n}\n.text-\\[color\\:var\\(--fgc\\)\\] {\n  color: var(--fgc);\n}\n.text-\\[color\\:var\\(--feedback-link-c\\)\\] {\n  color: var(--feedback-link-c);\n}\n.text-\\[color\\:var\\(--general-settings-icon-c\\)\\] {\n  color: var(--general-settings-icon-c);\n}\n.text-\\[color\\:var\\(--log-item-payload-c\\)\\] {\n  color: var(--log-item-payload-c);\n}\n.text-\\[color\\:var\\(--proxy-item-latency-offline-c\\)\\] {\n  color: var(--proxy-item-latency-offline-c);\n}\n.text-white {\n  --tw-text-opacity: 1;\n  color: rgb(255 255 255 / var(--tw-text-opacity));\n}\n.text-red-500 {\n  --tw-text-opacity: 1;\n  color: rgb(239 68 68 / var(--tw-text-opacity));\n}\n.text-\\[\\#FFAD00\\] {\n  --tw-text-opacity: 1;\n  color: rgb(255 173 0 / var(--tw-text-opacity));\n}\n.text-\\[\\#D44545\\] {\n  --tw-text-opacity: 1;\n  color: rgb(212 69 69 / var(--tw-text-opacity));\n}\n.text-\\[\\#13AF42\\] {\n  --tw-text-opacity: 1;\n  color: rgb(19 175 66 / var(--tw-text-opacity));\n}\n.text-\\[\\#41b883\\] {\n  --tw-text-opacity: 1;\n  color: rgb(65 184 131 / var(--tw-text-opacity));\n}\n.opacity-60 {\n  opacity: 0.6;\n}\n.opacity-40 {\n  opacity: 0.4;\n}\n.opacity-80 {\n  opacity: 0.8;\n}\n.opacity-50 {\n  opacity: 0.5;\n}\n.opacity-70 {\n  opacity: 0.7;\n}\n.shadow-2xl {\n  --tw-shadow: 0 25px 50px -12px rgb(0 0 0 / 0.25);\n  --tw-shadow-colored: 0 25px 50px -12px var(--tw-shadow-color);\n  box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);\n}\n.shadow-lg {\n  --tw-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);\n  --tw-shadow-colored: 0 10px 15px -3px var(--tw-shadow-color), 0 4px 6px -4px var(--tw-shadow-color);\n  box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);\n}\n.shadow-xl {\n  --tw-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);\n  --tw-shadow-colored: 0 20px 25px -5px var(--tw-shadow-color), 0 8px 10px -6px var(--tw-shadow-color);\n  box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);\n}\n.outline-none {\n  outline: 2px solid transparent;\n  outline-offset: 2px;\n}\n.outline {\n  outline-style: solid;\n}\n.blur {\n  --tw-blur: blur(8px);\n  filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);\n}\n.filter {\n  filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);\n}\n.transition {\n  transition-property: color, background-color, border-color, fill, stroke, opacity, box-shadow, transform, filter, -webkit-text-decoration-color, -webkit-backdrop-filter;\n  transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter;\n  transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter, -webkit-text-decoration-color, -webkit-backdrop-filter;\n  transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);\n  transition-duration: 150ms;\n}\n.transition-all {\n  transition-property: all;\n  transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);\n  transition-duration: 150ms;\n}\n.duration-200 {\n  transition-duration: 200ms;\n}\n.ease-in-out {\n  transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);\n}\n.ease-in {\n  transition-timing-function: cubic-bezier(0.4, 0, 1, 1);\n}\n.ease-out {\n  transition-timing-function: cubic-bezier(0, 0, 0.2, 1);\n}\n\ninput {\n  border-radius: 0.25rem;\n  border-width: 1px;\n  border-style: solid;\n  border-color: var(--bc);\n  background-color: var(--bgc);\n}\n\ninput::-moz-placeholder {\n  color: var(--input-phc);\n}\n\ninput:-ms-input-placeholder {\n  color: var(--input-phc);\n}\n\ninput::placeholder {\n  color: var(--input-phc);\n}\n\ntextarea {\n  border-radius: 0.25rem;\n  border-width: 1px;\n  border-style: solid;\n  border-color: var(--bc);\n  background-color: var(--bgc);\n}\n\ntextarea::-moz-placeholder {\n  color: var(--input-phc);\n}\n\ntextarea:-ms-input-placeholder {\n  color: var(--input-phc);\n}\n\ntextarea::placeholder {\n  color: var(--input-phc);\n}\n\n.theme-light {\n  animation: fade 0.2s ease-in-out;\n}\n\n:root {\n  --bgc: #fff;\n  --fgc: #000;\n  --bc: #dcdcdc;\n  --mbgc: #f5f5f5;\n  --shadow: rgba(50, 50, 50, 0.1);\n  --general-item-bgc: #f1f1f1;\n  --general-title-c: #2c3e50;\n  --general-clickable-border-c: rgba(50, 50, 50, 0.2);\n  --general-interface-card-bgc: #fff;\n  --general-interface-card-fgc: #17224f;\n  --general-interface-card-quote-bgc: rgb(213, 213, 213);\n  --general-settings-icon-c: #2c3e50;\n  --proxy-fake-item-bgc: #e3e3e3;\n  --proxy-item-now-fgc: #ffffff;\n  --proxy-item-now-bgc: rgb(146, 146, 146);\n  --proxy-item-type-bgc: rgb(146, 146, 146);\n  --proxy-item-type-fgc: #fff;\n  --proxy-item-border-c: rgba(75, 75, 75, 0.185);\n  --proxy-item-selected-border-c: #41b883;\n  --proxy-item-bgc: rgba(41, 41, 41, 0.05);\n  --proxy-item-hint-c: rgb(128, 128, 128);\n  --proxy-item-subs-fgc: #fff;\n  --proxy-item-subs-bgc: rgb(226, 226, 226);\n  --proxy-item-subs-used-bgc: #f57983;\n  --proxy-item-latency-online-c: #41b883;\n  --proxy-item-latency-offline-c: rgb(236, 5, 5);\n  --mode-switcher-selected-bgc: #4c4b4b;\n  --mode-switcher-selected-fgc: #fff;\n  --mode-switcher-normal-bgc: #fff;\n  --mode-switcher-normal-fgc: #747474;\n  --log-item-border-c: rgba(50, 50, 50, 0.1);\n  --log-item-rule-c: rgba(50, 50, 50, 0.7);\n  --log-item-payload-c: rgb(4, 92, 133);\n  --log-list-border-c: rgba(202, 202, 202, 0.342);\n  --profile-card-bgc: #f5f5f5;\n  --profile-card-hint-c: #1d2b63;\n  --profile-list-item-bgc: #7e7b7b;\n  --profile-list-item-cur-bgc: #464646;\n  --feedback-link-c: rgb(1, 159, 245);\n  --status-bgc: #ebebeb;\n  --status-close-hover: rgba(50, 50, 50, 0.2);\n  --switch-bgc: #c7bfbf;\n  --switch-bgc-second: #bdb3b3;\n  --menu-fgc: rgb(116, 125, 136);\n  --scroll-bar-bgc: rgb(202, 200, 198);\n  --input-bgc: #f1f1f1;\n  --input-phc: rgb(163, 163, 163);\n  --error-text: rgb(250, 19, 19);\n  --mask-c: rgba(50, 50, 50, 0.6);\n  --setting-input-bgc: #fff;\n  --setting-item-hover-bgc: rgba(50, 50, 50, 0.2);\n}\n\n.theme-dark {\n  animation: fade 0.2s ease-in-out;\n  --bgc: #2c2a38;\n  --fgc: rgb(255, 255, 255);\n  --bc: rgb(85, 79, 79);\n  --mbgc: #42424e;\n  --shadow: rgba(214, 214, 214, 0.1);\n  --general-item-bgc: #606068;\n  --general-title-c: rgb(233, 233, 233);\n  --general-clickable-border-c: rgb(149, 149, 149);\n  --general-interface-card-bgc: #686675;\n  --general-interface-card-fgc: #fff;\n  --general-interface-card-quote-bgc: #494757;\n  --general-settings-icon-c: #c2c8ce;\n  --proxy-fake-item-bgc: #32323f;\n  --proxy-item-now-fgc: rgb(206, 206, 206);\n  --proxy-item-now-bgc: rgb(92, 92, 92);\n  --proxy-item-type-bgc: rgb(92, 92, 92);\n  --proxy-item-type-fgc: rgb(206, 206, 206);\n  --proxy-item-border-c: rgba(199, 199, 199, 0.185);\n  --proxy-item-selected-border-c: rgb(0, 170, 0);\n  --proxy-item-bgc: rgba(255, 255, 255, 0.05);\n  --proxy-item-hint-c: rgb(167, 167, 167);\n  --proxy-item-subs-fgc: rgb(180, 180, 180);\n  --proxy-item-subs-bgc: rgb(90, 90, 90);\n  --proxy-item-subs-used-bgc: #92484e;\n  --proxy-item-latency-online-c: rgb(20, 160, 20);\n  --proxy-item-latency-offline-c: rgb(219, 75, 75);\n  --mode-switcher-selected-bgc: #3aa1cc;\n  --mode-switcher-selected-fgc: #fff;\n  --mode-switcher-normal-bgc: #42424e;\n  --mode-switcher-normal-fgc: #adadad;\n  --log-item-border-c: rgb(73, 66, 66);\n  --log-item-rule-c: rgba(224, 224, 224, 0.712);\n  --log-item-payload-c: rgb(95, 190, 202);\n  --log-list-border-c: rgb(98, 98, 98);\n  --profile-card-bgc: #42424e;\n  --profile-card-hint-c: #3aa1cc;\n  --profile-list-item-bgc: #3f3f49;\n  --profile-list-item-cur-bgc: #5f5f5f;\n  --feedback-link-c: rgb(23, 136, 197);\n  --status-bgc: #343442;\n  --status-close-hover: rgba(250, 250, 250, 0.2);\n  --switch-bgc: #413c3c;\n  --switch-bgc-second: #332f2f;\n  --menu-fgc: rgb(212, 212, 212);\n  --scroll-bar-bgc: #4d4d5a;\n  --input-bgc: rgba(105, 105, 105, 0.822);\n  --input-phc: rgb(163, 163, 163);\n  --error-text: rgb(255, 95, 95);\n  --mask-c: rgba(77, 77, 77, 0.8);\n  --setting-input-bgc: rgba(46, 46, 46, 0.8);\n  --setting-item-hover-bgc: rgba(255, 255, 255, 0.3);\n}\n\n.theme-mc {\n  animation: fade 0.2s ease-in-out;\n  --bgc: #303030;\n  --fgc: #ffffff;\n  --bc: #7e7b7bd4;\n  --mbgc: #1e1e1e;\n  --shadow: rgba(214, 214, 214, 0.1);\n  --general-item-bgc: #91a383cc;\n  --general-title-c: #e5ffe3;\n  --general-clickable-border-c: #7e7b7bd4;\n  --general-interface-card-bgc: #8f9592;\n  --general-interface-card-fgc: #fff;\n  --general-interface-card-quote-bgc: #52a535;\n  --general-settings-icon-c: #525b5ae8;\n  --proxy-fake-item-bgc: #696969;\n  --proxy-item-now-fgc: rgb(226, 226, 226);\n  --proxy-item-now-bgc: rgb(184, 112, 4);\n  --proxy-item-type-bgc: rgb(184, 112, 4);\n  --proxy-item-type-fgc: rgb(226, 226, 226);\n  --proxy-item-border-c: #bebdbd;\n  --proxy-item-selected-border-c: #1bb406c9;\n  --proxy-item-bgc: #0e0e0e;\n  --proxy-item-hint-c: #d6d6d6c7;\n  --proxy-item-subs-fgc: rgb(209, 209, 209);\n  --proxy-item-subs-bgc: rgba(151, 151, 151, 0.295);\n  --proxy-item-subs-used-bgc: #81b3f7;\n  --proxy-item-latency-online-c: rgb(22, 167, 22);\n  --proxy-item-latency-offline-c: rgb(223, 9, 9);\n  --mode-switcher-selected-bgc: #228208d6;\n  --mode-switcher-selected-fgc: #fff;\n  --mode-switcher-normal-bgc: #696969;\n  --mode-switcher-normal-fgc: #d6d6d6c7;\n  --log-item-border-c: #7e7b7bd4;\n  --log-item-rule-c: rgb(63, 63, 63);\n  --log-item-payload-c: rgb(13, 80, 143);\n  --log-list-border-c: #7e7b7bd4;\n  --profile-card-bgc: #10105a;\n  --profile-card-hint-c: #3aa1cc;\n  --profile-list-item-bgc: #a77018;\n  --profile-list-item-cur-bgc: #da141e99;\n  --feedback-link-c: #e5ffe3;\n  --status-bgc: #517843;\n  --status-close-hover: rgba(250, 250, 250, 0.2);\n  --switch-bgc: #d6d6d6c7;\n  --switch-bgc-second: #d6d6d6c7;\n  --menu-fgc: #b7d4b5;\n  --scroll-bar-bgc: #515151;\n  --input-bgc: #d6d6d6c7;\n  --input-phc: #dfffc8d4;\n  --error-text: rgb(255, 0, 0);\n  --mask-c: rgba(50, 50, 50, 0.6);\n  --setting-input-bgc: #ddf6ff69;\n  --setting-item-hover-bgc: #218306ab;\n}\n\n.theme-2077 {\n  animation: fade 0.2s ease-in-out;\n  --bgc: #136377;\n  --fgc: #fcec0c;\n  --bc: #0691b485;\n  --mbgc: #084a5a;\n  --shadow: rgba(214, 214, 214, 0.1);\n  --general-item-bgc: #084a5a;\n  --general-title-c: #f8ed53;\n  --general-clickable-border-c: #dde9373f;\n  --general-interface-card-bgc: #0e5668;\n  --general-interface-card-fgc: #fff;\n  --general-interface-card-quote-bgc: #09303a;\n  --general-settings-icon-c: #c0e732ef;\n  --proxy-fake-item-bgc: #043441;\n  --proxy-item-now-fgc: rgb(207, 245, 146);\n  --proxy-item-now-bgc: #064453;\n  --proxy-item-type-bgc: #064453;\n  --proxy-item-type-fgc: rgb(207, 245, 146);\n  --proxy-item-border-c: rgba(6, 49, 70, 0.411);\n  --proxy-item-selected-border-c: #f8ed53;\n  --proxy-item-bgc: #09738dea;\n  --proxy-item-hint-c: #bbb33f;\n  --proxy-item-subs-fgc: #fff;\n  --proxy-item-subs-bgc: rgb(78, 138, 111);\n  --proxy-item-subs-used-bgc: #b4555d;\n  --proxy-item-latency-online-c: rgb(68, 196, 68);\n  --proxy-item-latency-offline-c: rgb(255, 101, 101);\n  --mode-switcher-selected-bgc: #dfd43f;\n  --mode-switcher-selected-fgc: #000;\n  --mode-switcher-normal-bgc: #58482c;\n  --mode-switcher-normal-fgc: #c5c5c5;\n  --log-item-border-c: rgb(73, 66, 66);\n  --log-item-rule-c: rgba(224, 224, 224, 0.712);\n  --log-item-payload-c: rgb(95, 190, 202);\n  --log-list-border-c: rgb(98, 98, 98);\n  --profile-card-bgc: #58482c;\n  --profile-card-hint-c: #3aa1cc;\n  --profile-list-item-bgc: #043441;\n  --profile-list-item-cur-bgc: #b4aa39;\n  --feedback-link-c: #a5dbe9;\n  --status-bgc: #fcec0c;\n  --status-close-hover: rgba(250, 250, 250, 0.2);\n  --switch-bgc: #837a00;\n  --switch-bgc-second: #968c03;\n  --menu-fgc: #c79707;\n  --scroll-bar-bgc: #eede00cb;\n  --input-bgc: rgba(2, 45, 53, 0.822);\n  --input-phc: rgb(163, 163, 163);\n  --error-text: rgb(255, 95, 95);\n  --mask-c: rgba(50, 50, 50, 0.6);\n  --setting-input-bgc: rgba(2, 45, 53, 0.822);\n  --setting-item-hover-bgc: rgba(255, 255, 255, 0.2);\n}\n\n.theme-unknown {\n  display: none;\n}\n\n@keyframes fade {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n\n.fade {\n  animation: fade 0.2s ease-in-out;\n}\n\n.placeholder\\:text-\\[color\\:rgb\\(163\\2c 163\\2c 163\\)\\]::-moz-placeholder {\n  --tw-text-opacity: 1;\n  color: rgb(163 163 163 / var(--tw-text-opacity));\n}\n\n.placeholder\\:text-\\[color\\:rgb\\(163\\2c 163\\2c 163\\)\\]:-ms-input-placeholder {\n  --tw-text-opacity: 1;\n  color: rgb(163 163 163 / var(--tw-text-opacity));\n}\n\n.placeholder\\:text-\\[color\\:rgb\\(163\\2c 163\\2c 163\\)\\]::placeholder {\n  --tw-text-opacity: 1;\n  color: rgb(163 163 163 / var(--tw-text-opacity));\n}\n\n.hover\\:bg-\\[color\\:var\\(--proxy-item-bgc\\)\\]:hover {\n  background-color: var(--proxy-item-bgc);\n}\n\n.hover\\:bg-\\[color\\:var\\(--status-close-hover\\)\\]:hover {\n  background-color: var(--status-close-hover);\n}\n\n.hover\\:bg-\\[\\#ff5050d7\\]:hover {\n  background-color: #ff5050d7;\n}`, ""]);
                const u = d
            },
            45777: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n*,\n*::after,\n*::before {\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  -webkit-user-drag: none;\n  cursor: default;\n}\n* {\n  box-sizing: border-box;\n  margin: 0;\n  padding: 0;\n  cursor: default;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n}\nbody {\n  font-family: 'Noto Sans CJK', sans-serif;\n  font-weight: 500;\n  overflow: hidden;\n  background-color: var(--bgc);\n}\ninput {\n  font-family: inherit;\n}\n", ""]);
                const a = r
            },
            81283: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\nmain[data-v-68cbbc92] {\n  display: flex;\n  justify-content: space-between;\n}\nmain > div[data-v-68cbbc92] {\n}\n.left-side[data-v-68cbbc92] {\n  display: flex;\n  flex-direction: column;\n  /* flex: 0 0 20%; */\n  width: 170px;\n  height: calc(100vh - 25px);\n}\n.right-side[data-v-68cbbc92] {\n  z-index: 2;\n  flex-grow: 1;\n  width: calc(100vw - 170px);\n  height: calc(100vh - 25px);\n}\n.welcome[data-v-68cbbc92] {\n  color: #555;\n  font-size: 23px;\n  margin-bottom: 10px;\n}\n.title[data-v-68cbbc92] {\n  color: #2c3e50;\n  font-size: 20px;\n  font-weight: bold;\n  margin-bottom: 6px;\n}\n.title.alt[data-v-68cbbc92] {\n  font-size: 18px;\n  margin-bottom: 10px;\n}\n.doc p[data-v-68cbbc92] {\n  color: black;\n  margin-bottom: 10px;\n}\n.doc button[data-v-68cbbc92] {\n  font-size: 0.8em;\n  cursor: pointer;\n  outline: none;\n  padding: 0.75em 2em;\n  border-radius: 2em;\n  display: inline-block;\n  color: #fff;\n  background-color: #4fc08d;\n  transition: all 0.15s ease;\n  box-sizing: border-box;\n  border: 1px solid #4fc08d;\n}\n.doc button.alt[data-v-68cbbc92] {\n  color: #42b983;\n  background-color: transparent;\n}\n.clash-status-main[data-v-68cbbc92] {\n  display: flex;\n  align-items: center;\n  position: absolute;\n  height: 40px;\n  bottom: 0px;\n  width: 170px;\n  left: 0px;\n  justify-content: center;\n  z-index: 2;\n}\n.clash-status-hint[data-v-68cbbc92] {\n  margin-left: 6px;\n  font-size: 0.75em;\n  letter-spacing: 0px;\n  cursor: pointer;\n}\n.clash-status-icon[data-v-68cbbc92] {\n  width: 12px;\n  height: 12px;\n  border-radius: 10px;\n  /* box-shadow: 0px 0px 3px 2px rgba(0, 0, 0, 0.4); */\n}\n.clash-running[data-v-68cbbc92] {\n  background-color: #41b883;\n}\n.clash-set-dns[data-v-68cbbc92] {\n  background-color: rgb(231, 217, 26);\n}\n.clash-stopped[data-v-68cbbc92] {\n  background-color: red;\n}\n.cloud[data-v-68cbbc92] {\n  position: fixed;\n  /* opacity: 0.2; */\n  bottom: 110px;\n  left: calc(50% + 80px);\n  transform: translateX(-50%);\n  width: 40%;\n  /* height: 150vh; */\n  pointer-events: none;\n}\n.opacicy[data-v-68cbbc92] {\n  opacity: 0.2;\n}\n.latern[data-v-68cbbc92] {\n  position: fixed;\n  opacity: 0.7;\n  top: 30px;\n  left: 125px;\n  width: 50px;\n  pointer-events: none;\n}\n", ""]);
                const a = r
            },
            37919: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n#main-about-view[data-v-4a737543] {\n  display: flex;\n  flex-direction: column;\n  padding: 10px 30px;\n  gap: 3px;\n}\n.title[data-v-4a737543] {\n  margin-bottom: 0px;\n  /* font-weight: normal; */\n  font-size: 1.1em;\n}\n.ad-img-list[data-v-4a737543] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  margin-top: 10px;\n  gap: 10px;\n}\n", ""]);
                const a = r
            },
            51232: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n.header[data-v-357ec510] {\n  margin-top: 10px;\n  display: flex;\n  height: 100px;\n  width: calc(100vw - 170px);\n  justify-content: center;\n  align-items: center;\n}\n.title[data-v-357ec510] {\n  /* margin: 20px auto; */\n}\n.title-name[data-v-357ec510] {\n  display: inline-block;\n  cursor: pointer;\n}\n.new-version-tag[data-v-357ec510] {\n  display: inline-block;\n  color: #fff;\n  padding: 2px 4px;\n  background-color: rgba(170, 38, 38, 0.8);\n  border-radius: 3px;\n  font-size: 0.65em;\n  position: relative;\n  top: -8px;\n  left: 2px;\n}\n.item-left[data-v-357ec510] {\n  display: flex;\n  font-weight: 500;\n  font-size: 1em;\n  align-items: center;\n}\n.item-right[data-v-357ec510] {\n  font-size: 15px;\n  font-weight: normal;\n  display: flex;\n  align-items: center;\n}\n.control-icon[data-v-357ec510] {\n  width: 20px;\n  height: 20px;\n  margin-right: 20px;\n  margin-top: 2px;\n  cursor: pointer;\n}\n.systemCheckbox[data-v-357ec510] {\n  width: 20px;\n  height: 20px;\n}\n.systemCheckbox[data-v-357ec510]:checked {\n  background-color: #233376;\n  border: none;\n}\n.hiddenInput[data-v-357ec510] {\n  width: 1px;\n  height: 1px;\n  opacity: 0;\n}\n.version[data-v-357ec510] {\n  font-size: 0.5em;\n  /* display: inline; */\n  margin-left: 10px;\n  font-weight: normal;\n  cursor: pointer;\n  margin-top: 15px;\n}\n.checkmark-container[data-v-357ec510] {\n  display: block;\n  position: relative;\n  padding-left: 22px;\n  margin-bottom: 22px;\n  cursor: pointer;\n  font-size: 22px;\n}\n.checkmark-container input[data-v-357ec510] {\n  position: absolute;\n  opacity: 0;\n  cursor: pointer;\n  height: 0;\n  width: 0;\n}\n.system-checkmark[data-v-357ec510] {\n  cursor: pointer;\n  position: absolute;\n  top: 0;\n  border-radius: 20px;\n  left: 0;\n  height: 25px;\n  width: 25px;\n  background-color: #fff;\n  box-shadow: 0px 0px 5px 1px rgba(50, 50, 50, 0.5);\n}\n.checkmark-container:hover input ~ .system-checkmark[data-v-357ec510] {\n  background-color: #fff;\n}\n.checkmark-container input:checked ~ .system-checkmark[data-v-357ec510] {\n  background-color: #464646;\n}\n.system-checkmark-unknown[data-v-357ec510] {\n  background-color: #beb9b9;\n}\n\n/* Create the checkmark/indicator (hidden when not checked) */\n.system-checkmark[data-v-357ec510]:after {\n  content: '';\n  position: absolute;\n  display: none;\n}\n\n/* Show the checkmark when checked */\n.checkmark-container input:checked ~ .system-checkmark[data-v-357ec510]:after {\n  display: block;\n}\n\n/* Style the checkmark/indicator */\n.checkmark-container .system-checkmark[data-v-357ec510]:after {\n  left: 8px;\n  top: 5px;\n  width: 6px;\n  height: 9px;\n  border: solid white;\n  border-width: 0 3px 3px 0;\n  transform: rotate(45deg);\n}\n.interface-address[data-v-357ec510] {\n  font-size: 1em;\n}\n.interface-name[data-v-357ec510] {\n  font-size: 0.8em;\n  margin-left: 15px;\n}\n.edit-btn[data-v-357ec510] {\n  width: 25px;\n  height: 25px;\n  border-radius: 4px;\n  cursor: pointer;\n  background-color: #464646;\n  box-shadow: 0px 0px 5px 1px rgba(50, 50, 50, 0.3);\n}\n.edit-btn > img[data-v-357ec510] {\n  width: 17px;\n  height: 17px;\n  margin: 5px;\n  cursor: pointer;\n}\n.empty-div[data-v-357ec510] {\n  height: 50px;\n}\n", ""]);
                const a = r
            },
            75169: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n#error-title[data-v-9ba71ad8] {\n  /* color: rgb(231, 73, 73); */\n  font-size: 1.1em;\n}\n.error-hint[data-v-9ba71ad8] {\n}\n", ""]);
                const a = r
            },
            64608: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n.warning[data-v-6acd51f2] {\n  color: red;\n}\n.btns[data-v-6acd51f2] {\n  display: flex;\n  width: 280px;\n  justify-content: space-between;\n  align-items: center;\n}\n.button[data-v-6acd51f2] {\n  font-size: 0.8em;\n  height: 30px;\n  line-height: 30px;\n  color: #fff;\n  width: 70px;\n  text-align: center;\n  border-radius: 3px;\n  cursor: pointer;\n}\n.button-on[data-v-6acd51f2] {\n  background-color: rgba(14, 151, 185, 0.959);\n}\n.button-off[data-v-6acd51f2] {\n  background-color: rgba(243, 61, 61, 0.801);\n}\n.button-clear[data-v-6acd51f2] {\n  background-color: rgba(23, 156, 6, 0.904);\n}\n.debugdark[data-v-6acd51f2] {\n  color: rgb(155, 155, 2);\n}\n.debug[data-v-6acd51f2] {\n  color: rgb(238, 238, 57);\n}\n.info[data-v-6acd51f2] {\n  color: #13af42;\n}\n.warn[data-v-6acd51f2] {\n  color: #d44545;\n}\n.error[data-v-6acd51f2] {\n  color: #d44545;\n}\n", ""]);
                const a = r
            },
            23601: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n.hint[data-v-4f5120b9] {\n  font-size: 0.8em;\n  color: #000;\n  letter-spacing: 1px;\n  text-align: left;\n}\n.bold-icon[data-v-4f5120b9] {\n  font-size: 0.75em;\n  letter-spacing: 1px;\n  padding: 0 1px;\n  /* font-weight: bolder; */\n}\n", ""]);
                const a = r
            },
            69791: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n#main-run-time-view[data-v-05e7144a] {\n  /* color: #000; */\n  display: flex;\n  align-items: flex-end;\n  padding-bottom: 40px;\n}\n.timer-text[data-v-05e7144a] {\n  text-align: center;\n  width: 100%;\n}\n", ""]);
                const a = r
            },
            38489: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\ninput[data-v-820f0efe] {\n  cursor: text;\n  width: calc(100vw - 230px);\n  height: 45px;\n  font-size: 1em;\n  padding: 0 10px 0 10px;\n}\ninput[data-v-820f0efe]:focus {\n  outline: none;\n}\n.remote-view[data-v-820f0efe] {\n  display: flex;\n  align-items: center;\n  justify-content: space-around;\n}\n.local-view[data-v-820f0efe] {\n  right: 0;\n  margin: 0 2vw 20px 1vw;\n}\n.list-view[data-v-820f0efe] > :last-child {\n  margin-bottom: 25px;\n}\n.item-local[data-v-820f0efe] {\n  /* background: radial-gradient(\n    ellipse at top left,\n    rgb(112, 143, 158) 30%,\n    rgba(97, 147, 172, 0.9) 100%\n  ); */\n}\n.item-name-top[data-v-820f0efe] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  cursor: pointer;\n  font-size: 15px;\n}\n.item-name-top > div[data-v-820f0efe] {\n  max-width: calc((80vw - 80px) / 2 - 65px);\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  overflow: hidden;\n}\n.item-time[data-v-820f0efe] {\n  cursor: pointer;\n}\n.item-expired[data-v-820f0efe] {\n  color: rgb(250, 73, 73);\n}\n.item-parser[data-v-820f0efe] {\n  font-size: 0.8em;\n}\n.item-time-now[data-v-820f0efe] {\n  color: rgb(158, 255, 113);\n}\n.btns-container[data-v-820f0efe] {\n  display: flex;\n  align-items: center;\n  width: -moz-fit-content;\n  width: fit-content;\n  justify-content: space-between;\n}\n.update-all-btn[data-v-820f0efe] {\n}\n.confirm[data-v-820f0efe] {\n  height: 45px;\n  color: white;\n  cursor: pointer;\n  line-height: 45px;\n  text-align: center;\n  background-color: #7e7b7b;\n  border-radius: 3px;\n  padding-left: 10px;\n  padding-right: 10px;\n  font-size: 0.85em;\n  box-shadow: 0px 2px 20px 2px rgba(50, 50, 50, 0.1);\n  width: -moz-fit-content;\n  width: fit-content;\n  white-space: nowrap;\n}\n.confirm-left[data-v-820f0efe] {\n  padding: auto 30px;\n}\n.confirm-right[data-v-820f0efe] {\n  margin-left: 10px;\n}\n.confirm-copy[data-v-820f0efe] {\n  border-radius: 5px;\n}\n.btn-error[data-v-820f0efe] {\n  background-color: #ec2658;\n}\n.btn-success[data-v-820f0efe] {\n  background-color: #8ade4e;\n}\n.btn-loading[data-v-820f0efe] {\n  box-shadow: 2px 2px 5px 1px rgba(50, 50, 50, 0.1);\n}\n.hint-normal[data-v-820f0efe] {\n  text-align: center;\n  font-size: 1em;\n  font-weight: 500;\n}\n.hint-error[data-v-820f0efe] {\n  color: #ec2658;\n}\n.copy-icon[data-v-820f0efe] {\n  flex-shrink: 0;\n  height: 45px;\n  width: 45px;\n  padding: 10px;\n  cursor: pointer;\n}\n.clear-icon[data-v-820f0efe] {\n  height: 45px;\n  width: 45px;\n  padding: 13px;\n  position: absolute;\n  right: 5px;\n}\n.rotating[data-v-820f0efe] {\n  animation: downloading-820f0efe 1s infinite;\n  animation-timing-function: linear;\n}\n@keyframes downloading-820f0efe {\nfrom {\n    transform: rotate(0deg);\n}\nto {\n    transform: rotate(360deg);\n}\n}\n.animate-cycle[data-v-820f0efe] {\n  animation: cycle-820f0efe 2s infinite;\n  animation-timing-function: ease-in-out;\n}\n@keyframes cycle-820f0efe {\n0% {\n    top: 0px;\n}\n50% {\n    top: 40%;\n}\n100% {\n    top: 0px;\n}\n}\n.expand-enter-active[data-v-820f0efe] {\n  animation: expand-820f0efe 0.5s;\n  animation-timing-function: ease-in-out;\n}\n@keyframes expand-820f0efe {\n0% {\n    height: 20%;\n    top: 40%;\n}\n100% {\n    height: 100%;\n    top: 0;\n}\n}\n", ""]);
                const a = r
            },
            72132: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n.floating[data-v-9e0b3cf4] {\n  /* background-color: #fff; */\n  position: fixed;\n  left: 170px;\n  height: 60px;\n  width: calc(100vw - 170px);\n  display: flex;\n  justify-content: space-between;\n  padding: 0 50px 0 40px;\n  align-items: center;\n  box-shadow: 2px 2px 4px 1px rgba(50, 50, 50, 0.2);\n}\n.floating-right[data-v-9e0b3cf4] {\n  display: flex;\n  justify-content: flex-end;\n}\n.hint[data-v-9e0b3cf4] {\n  font-size: 1.1em;\n}\n.main-btn[data-v-9e0b3cf4] {\n  cursor: pointer;\n  margin-left: 20px;\n  box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.2);\n  text-align: center;\n  padding: 5px 0;\n  width: 80px;\n  border-radius: 5px;\n  color: #fff;\n}\n.reload[data-v-9e0b3cf4] {\n  background-color: rgb(199, 202, 16);\n}\n.save[data-v-9e0b3cf4] {\n  background-color: rgba(49, 167, 227, 1);\n}\n.drag[data-v-9e0b3cf4] {\n  /* background-color: #fff; */\n  display: flex;\n  padding: 0px 0px 20px 0px;\n  margin-top: 60px;\n  left: 20vw;\n  height: calc(100% - 70px);\n  width: calc(100vw - 170px);\n  max-width: 900px;\n}\n.proxy > div[data-v-9e0b3cf4] {\n  direction: ltr;\n}\n.proxy > draggable[data-v-9e0b3cf4] {\n  direction: ltr;\n}\n.section-title[data-v-9e0b3cf4] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin: 20px 0px 0px 0px;\n  font-size: 0.8em;\n}\nh2[data-v-9e0b3cf4] {\n}\nimg[data-v-9e0b3cf4] {\n  width: 20px;\n  height: 20px;\n  margin-left: 10px;\n  cursor: pointer;\n}\n.add-icon[data-v-9e0b3cf4] {\n  background-color: #677a94;\n  border-radius: 5px;\n  color: white;\n  font-size: 0.9em;\n  letter-spacing: 1px;\n  padding: 3px 10px;\n  cursor: pointer;\n  box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.2);\n}\n.type-icon[data-v-9e0b3cf4] {\n}\n.left-item[data-v-9e0b3cf4] {\n  background-color: #373948;\n}\n.right-item[data-v-9e0b3cf4] {\n  background-color: #65517a;\n}\n.group-type[data-v-9e0b3cf4] {\n  font-size: 0.7em;\n}\n.proxy-item[data-v-9e0b3cf4] {\n  opacity: 0.8;\n  cursor: pointer;\n  font-size: 1em;\n  padding: 5px 10px;\n  margin: 10px 0px;\n  display: flex;\n  color: #fff;\n  border-radius: 5px;\n  justify-content: space-between;\n  align-items: center;\n  box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.2);\n}\n", ""]);
                const a = r
            },
            44332: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\ninput[data-v-f638b328] {\n  margin: 5px 0;\n  font-size: 1.1em;\n  padding: 0 5px;\n}\ninput[type='radio'][data-v-f638b328] {\n  height: 20px;\n  width: 20px;\n  vertical-align: middle;\n  margin-right: 5px;\n}\ninput[type='checkbox'][data-v-f638b328] {\n  width: 20px;\n  height: 20px;\n  vertical-align: middle;\n  margin-right: 5px;\n}\nlabel[data-v-f638b328] {\n  font-size: 1.1em;\n  vertical-align: middle;\n}\ninput[data-v-f638b328]:focus {\n  outline: none;\n}\n.input-view[data-v-f638b328] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n}\n.cipher-list[data-v-f638b328] {\n  display: grid;\n  grid-template-columns: repeat(2, 1fr);\n  /* grid-column-gap: 30px; */\n  /* grid-auto-rows: minmax(40px, auto); */\n}\n.ss-list[data-v-f638b328] {\n  display: flex;\n  flex-direction: column;\n}\n.vmess-list[data-v-f638b328] {\n  display: flex;\n  flex-direction: column;\n}\n.proxy-type-list[data-v-f638b328] {\n  display: flex;\n  justify-content: flex-start;\n}\n.group-type-list[data-v-f638b328] {\n  display: flex;\n  justify-content: flex-start;\n}\n.group-type-list > div[data-v-f638b328] {\n  margin-right: 30px;\n}\n.proxy-type-list > div[data-v-f638b328] {\n  margin-right: 30px;\n}\n.btns[data-v-f638b328] {\n  margin-top: 20px;\n  display: flex;\n  justify-content: space-around;\n}\n.btn[data-v-f638b328] {\n  padding: 5px 10px;\n  font-size: 1.1em;\n  text-align: center;\n  width: 100px;\n  border-radius: 4px;\n  /* box-shadow: 1px 1px 5px 1px rgba(50, 50, 50, 0.5); */\n}\n.cancel[data-v-f638b328] {\n  background-color: #c0c0c0c0;\n}\n.confirm[data-v-f638b328] {\n  background-color: #375df3;\n  color: #fff;\n}\n", ""]);
                const a = r
            },
            82611: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n#main-log-view[data-v-459dde1e] {\n  height: 100%;\n  overflow: hidden;\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n}\n.ctl-icon[data-v-459dde1e] {\n  width: 22px;\n  height: 22px;\n  cursor: pointer;\n  margin-left: 10px;\n}\n.emoji-name[data-v-459dde1e] {\n  display: flex;\n  align-items: center;\n}\n.header[data-v-459dde1e] {\n  display: flex;\n  justify-content: space-between;\n  padding: 0 50px 0 40px;\n  align-items: center;\n  height: 60px;\n}\n.header-btns[data-v-459dde1e] {\n  display: flex;\n  justify-content: flex-end;\n}\n.filter-view[data-v-459dde1e] {\n  width: calc(100vw - 170px);\n  height: 50px;\n}\n.filter-view input[data-v-459dde1e] {\n  margin: 0px 40px 10px 40px;\n  cursor: text;\n  width: calc(100vw - 250px);\n  height: 40px;\n  padding: 0px 10px;\n  border-radius: 5px;\n  font-size: 1.1em;\n}\n.filter-view input[data-v-459dde1e]:focus {\n  outline: none;\n  /* box-shadow: 0px 4px 10px 2px rgba(50, 50, 50, 0.4); */\n}\n.btn[data-v-459dde1e] {\n  cursor: pointer;\n  box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.2);\n  margin-left: 20px;\n  width: 80px;\n  text-align: center;\n  padding: 5px 10px;\n  border-radius: 5px;\n  color: #fff;\n}\n.btn-add[data-v-459dde1e] {\n  background-color: rgba(49, 167, 227, 1);\n}\n.btn-save[data-v-459dde1e] {\n  background-color: rgba(65, 184, 131, 1);\n}\n.btn-back[data-v-459dde1e] {\n  background-color: rgb(224, 221, 34);\n}\n.title[data-v-459dde1e] {\n  font-size: 1.1em;\n  margin-bottom: 0px;\n}\n.log-item[data-v-459dde1e] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  padding: 5px 20px;\n  width: 100%;\n  border-bottom: 1px solid rgba(50, 50, 50, 0.1);\n}\n.left[data-v-459dde1e] {\n  flex-grow: 1;\n  padding-right: 40px;\n  overflow: hidden;\n}\n.right-main[data-v-459dde1e] {\n  display: flex;\n  align-items: center;\n}\nimg[data-v-459dde1e] {\n  margin-left: 10px;\n  width: 25px;\n  height: 25px;\n}\n.url[data-v-459dde1e] {\n  font-size: 18px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n}\n.rule-set[data-v-459dde1e] {\n  color: rgb(255, 94, 0);\n}\n.right[data-v-459dde1e] {\n  font-size: 1em;\n  padding: 5px 10px;\n  border-radius: 4px;\n  color: #fff;\n  opacity: 0.8;\n  box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.2);\n}\n", ""]);
                const a = r
            },
            54280: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, '\n.modal-mask[data-v-eea841c4] {\n  position: fixed;\n  z-index: 9998;\n  top: 0;\n  left: 170px;\n  width: calc(100vw - 170px);\n  height: 100vh;\n  background-color: rgba(0, 0, 0, 0.5);\n  display: table;\n  transition: opacity 0.3s ease;\n}\n.modal-wrapper[data-v-eea841c4] {\n  display: table-cell;\n  vertical-align: middle;\n}\n.modal-header h3[data-v-eea841c4] {\n  margin-top: 0;\n  color: #42b983;\n}\n.modal-body[data-v-eea841c4] {\n  margin: 20px 0;\n}\n.modal-default-button[data-v-eea841c4] {\n  float: right;\n}\n\n/*\n * The following styles are auto-applied to elements with\n * transition="modal" when their visibility is toggled\n * by Vue.js.\n *\n * You can easily play with the modal transition by editing\n * these styles.\n */\n.modal-enter[data-v-eea841c4] {\n  opacity: 0;\n}\n.modal-leave-active[data-v-eea841c4] {\n  opacity: 0;\n}\n.modal-enter .modal-container[data-v-eea841c4],\n.modal-leave-active .modal-container[data-v-eea841c4] {\n  transform: scale(1.1);\n}\ninput[data-v-eea841c4]:focus {\n  outline: none;\n}\ninput[data-v-eea841c4] {\n  height: 40px;\n  width: 100%;\n  font-size: 18px;\n  padding: 0 10px;\n}\n.rule-type-group[data-v-eea841c4] {\n  display: grid;\n  grid-template-columns: repeat(2, 1fr);\n  grid-row-gap: 10px;\n  grid-column-gap: 10px;\n  grid-auto-rows: minmax(30px, auto);\n}\n.rule-type-item[data-v-eea841c4] {\n  text-align: center;\n  line-height: 30px;\n  border-radius: 5px;\n  color: #fff;\n  padding: 5px 10px;\n  background-color: rgba(101, 81, 122, 0.6);\n}\n.rule-type-selected[data-v-eea841c4] {\n  background-color: rgba(101, 81, 122, 1);\n}\n.rule-proxy-group[data-v-eea841c4] {\n  margin-bottom: 60px;\n  display: grid;\n  grid-template-columns: repeat(1, 1fr);\n  grid-row-gap: 10px;\n  grid-column-gap: 10px;\n  grid-auto-rows: minmax(30px, auto);\n}\n.rule-proxy-item[data-v-eea841c4] {\n  text-align: center;\n  line-height: 30px;\n  border-radius: 5px;\n  color: #fff;\n  padding: 5px 10px;\n  background-color: rgba(55, 57, 72, 0.6);\n}\n.rule-proxy-selected[data-v-eea841c4] {\n  background-color: rgba(55, 57, 72, 1);\n}\n.rule-section-title[data-v-eea841c4] {\n  font-size: 1em;\n  color: rgba(166, 165, 164, 1);\n  margin-top: 10px;\n  margin-bottom: 5px;\n}\n.rule-floating-btns[data-v-eea841c4] {\n  right: calc(80vw - 585px);\n  bottom: calc(100vh - 450px);\n  display: flex;\n}\n.rule-floating-btns > div[data-v-eea841c4] {\n  font-size: 0.8em;\n  width: 80px;\n  height: 35px;\n  margin-left: 10px;\n  line-height: 50px;\n  text-align: center;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  cursor: pointer;\n  border-radius: 3px;\n  color: #fff;\n}\n.rule-floating-cancel[data-v-eea841c4] {\n  background-color: rgba(65, 184, 131, 1);\n}\n.rule-floating-ok[data-v-eea841c4] {\n  background-color: rgba(58, 86, 197, 1);\n}\n', ""]);
                const a = r
            },
            73316: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n.secret-hint[data-v-fc0cd1de] {\n    position: absolute;\n    top: 0px;\n    right: -1.5rem\n}\n", ""]);
                const a = r
            },
            88525: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\n.navigator[data-v-35f836ea] {\n\n    top: 0px;\n\n    z-index: 120;\n\n    height: 100%;\n\n    --tw-border-opacity: 1;\n\n    border-color: rgb(133 133 133 / var(--tw-border-opacity));\n\n    --tw-bg-opacity: 1;\n\n    background-color: rgb(30 30 30 / var(--tw-bg-opacity))\n}\n.navigator[data-v-35f836ea] .item {\n\n    --tw-text-opacity: 1;\n\n    color: rgb(223 223 223 / var(--tw-text-opacity))\n}\n", ""]);
                const a = r
            },
            30020: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "\ninput[data-v-05227e49] {\n    border-radius: 0.25rem;\n    border-width: 1px;\n    border-style: solid;\n    --tw-border-opacity: 1;\n    border-color: rgb(85 79 79 / var(--tw-border-opacity));\n    --tw-bg-opacity: 1;\n    background-color: rgb(44 42 56 / var(--tw-bg-opacity))\n}\ninput[data-v-05227e49]::-moz-placeholder {\n    --tw-text-opacity: 1;\n    color: rgb(163 163 163 / var(--tw-text-opacity))\n}\ninput[data-v-05227e49]:-ms-input-placeholder {\n    --tw-text-opacity: 1;\n    color: rgb(163 163 163 / var(--tw-text-opacity))\n}\ninput[data-v-05227e49]::placeholder {\n    --tw-text-opacity: 1;\n    color: rgb(163 163 163 / var(--tw-text-opacity))\n}\n", ""]);
                const a = r
            },
            46485: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => u
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s),
                    a = i(61667),
                    l = i.n(a),
                    c = new URL(i(9665), i.b),
                    d = r()(o()),
                    h = l()(c);
                d.push([e.id, `@font-face{font-family:"TwemojiMozilla";src:url(${h}) format("truetype")}.clickable{cursor:pointer}.clickable *{cursor:pointer}input::-webkit-outer-spin-button,input::-webkit-inner-spin-button{-webkit-appearance:none}.no-esc{outline:none}`, ""]);
                const u = d
            },
            69674: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".wrapper[data-v-68cbbc92]{height:100vh;width:100vw;overflow:hidden}", ""]);
                const a = r
            },
            40771: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".chat-list[data-v-4a737543]{display:flex;justify-content:left;flex-wrap:wrap}", ""]);
                const a = r
            },
            16466: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".scrolly[data-v-4a737543]{overflow-y:auto}.scrolly[data-v-4a737543]::-webkit-scrollbar{width:16px}.scrolly[data-v-4a737543]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.scrolly[data-v-4a737543]::-webkit-scrollbar-corner{background-color:var(--bgc)}", ""]);
                const a = r
            },
            46073: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".ad-img[data-v-34599eb0]{width:100%;width:620px;height:150px;border-radius:3px}.placeholder[data-v-34599eb0]{line-height:150px;color:#fff;background-color:#e2e2e2;display:flex;align-items:center;justify-content:center}.placeholder div[data-v-34599eb0]{margin-right:10px;color:#fff}.placeholder img[data-v-34599eb0]{width:30px}.error-img[data-v-34599eb0]{display:flex;width:620px;height:150px;background-color:#e2e2e2;align-items:center;justify-content:center}.error-img div[data-v-34599eb0]{margin-right:10px;color:#858585}.error-img img[data-v-34599eb0]{width:30px}.twinkling[data-v-34599eb0]{animation:twinkling-34599eb0 2s infinite;animation-timing-function:ease-in-out}@keyframes twinkling-34599eb0{0%{background-color:#e9e9e9}50%{background-color:#d4d4d4}100%{background-color:#e9e9e9}}", ""]);
                const a = r
            },
            87133: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-connection-view[data-v-39b270f2]{overflow:hidden;display:flex;justify-content:space-between;flex-direction:column;height:100%;position:relative}.main-connection-view .header[data-v-39b270f2]{height:40px;display:flex;justify-content:space-between;align-items:center;margin:auto 20px;flex-shrink:0}.main-connection-view .header .search-area[data-v-39b270f2]{position:relative;flex-grow:1;margin:0 10px 0 5px}.main-connection-view .header .search-area .search-box[data-v-39b270f2]{padding:0 22px 0 4px;outline:none;height:25px;border-radius:4px;line-height:25px;font-size:14px;width:100%}.main-connection-view .control-view[data-v-39b270f2]{display:flex;padding:0 20px 10px 16px;justify-content:space-between;height:40px;flex-shrink:0}.main-connection-view .control-view .labels[data-v-39b270f2]{display:flex;align-items:center;color:#fff;flex-shrink:1}.main-connection-view .control-view .labels .label[data-v-39b270f2]{width:65px;height:28px;font-size:14px;font-weight:normal;margin:0 5px 0 0;padding:0 8px;line-height:25px;cursor:pointer;background-color:rgba(100,100,100,.5);border-radius:3px}.main-connection-view .control-view .labels .label-selected[data-v-39b270f2]{background-color:rgba(14,184,65,.932)}.main-connection-view .control-view .labels .label-selected-reverse[data-v-39b270f2]{background-color:#0f6bb1}.title[data-v-39b270f2]{height:40px;display:flex;align-items:center}.title div[data-v-39b270f2]:first-child{font-size:20px;display:flex;align-items:baseline}.title div:first-child span[data-v-39b270f2]{font-size:12px;margin-left:6px}.header-right[data-v-39b270f2]{display:flex;align-items:center}.total-hint[data-v-39b270f2]{font-size:15px;white-space:nowrap}.scroll-view[data-v-39b270f2]{height:calc(100% - 60px);width:calc(100% - 0px);overflow-y:auto}.scroll-view[data-v-39b270f2]::-webkit-scrollbar{width:16px}.scroll-view[data-v-39b270f2]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.scroll-view[data-v-39b270f2]::-webkit-scrollbar-corner{background-color:var(--bgc)}.conn-item[data-v-39b270f2]{padding:1px 20px;display:flex;justify-content:space-between;align-items:center;border-bottom:1px solid var(--log-list-border-c)}.conn-item-closed[data-v-39b270f2]{opacity:.7}.conn-item-top[data-v-39b270f2]{display:flex;justify-content:space-between}.conn-host[data-v-39b270f2]{font-size:14px;font-weight:500}.close-btn[data-v-39b270f2]{width:23px;height:23px;border-radius:15px;cursor:pointer;opacity:.8}.close-btn *[data-v-39b270f2]{cursor:pointer}.close-btn[data-v-39b270f2]:hover{opacity:1}.item-icon[data-v-39b270f2]{width:19px;margin:2px;height:19px}.close-all-btn[data-v-39b270f2]{padding:0 10px;margin-left:10px;text-align:center;height:30px;line-height:28px;cursor:pointer;background-color:rgba(243,61,61,.801);border-radius:3px;color:#fff;flex-shrink:0;height:28px;font-size:14px;font-weight:normal}.conn-labels[data-v-39b270f2]{font-size:11px;display:flex;margin-bottom:3px;flex-wrap:wrap}.conn-labels>div[data-v-39b270f2]{margin-right:5px;margin-top:1px;padding:2px 4px;color:#fff;font-weight:normal;border-radius:3px}.conn1[data-v-39b270f2]{background-color:rgba(194,104,25,.8)}.conn2[data-v-39b270f2]{background-color:rgba(193,131,16,0.7725490196)}.conn4[data-v-39b270f2]{background-color:rgba(85,152,52,0.8078431373)}.conn3[data-v-39b270f2]{background-color:rgba(0,134,76,0.7882352941)}.conn5[data-v-39b270f2]{background-color:#428ee4}.conn6[data-v-39b270f2]{background-color:#4c10ae}.conn7[data-v-39b270f2]{background-color:#8b8b00}.button-control[data-v-39b270f2]{padding:0 10px;text-align:center;height:25px;font-weight:normal;line-height:25px;cursor:pointer;border-radius:3px;color:#fff}.button-resume[data-v-39b270f2]{background-color:rgba(14,151,185,.959)}.button-pause[data-v-39b270f2]{background-color:rgba(243,61,61,.801)}.selected-top[data-v-39b270f2]{border-bottom-right-radius:10px}.selected-bottom[data-v-39b270f2]{border-top-right-radius:10px}.item-none[data-v-39b270f2]{background-color:var(--mbgc);color:var(--menu-fgc)}.scrolly[data-v-39b270f2]{overflow-y:auto}.scrolly[data-v-39b270f2]::-webkit-scrollbar{width:16px}.scrolly[data-v-39b270f2]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.scrolly[data-v-39b270f2]::-webkit-scrollbar-corner{background-color:var(--bgc)}", ""]);
                const a = r
            },
            68361: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main[data-v-947c6bac]{width:100%;height:100%;position:absolute;display:flex;flex-direction:column;align-items:center;justify-content:center;color:#000;z-index:10}.main *[data-v-947c6bac]{user-select:text}.main[data-v-947c6bac] *{user-select:text}.card-main[data-v-947c6bac]{border-radius:2px;max-width:60%;max-height:90%;min-width:420px;height:fit-content;display:flex;flex-direction:column;justify-content:space-around;box-shadow:0px 0px 10px 3px rgba(14,14,14,.164)}.card-content[data-v-947c6bac]{width:100%;height:100%;display:flex;flex-direction:column}.content-title[data-v-947c6bac]{font-size:20px;line-height:60px;height:60px}.content-list[data-v-947c6bac]{overflow-y:auto;overflow-x:hidden;flex-grow:1}.content-list[data-v-947c6bac]::-webkit-scrollbar{width:4px;background-color:rgba(151,151,151,0.4117647059)}.content-list[data-v-947c6bac]::-webkit-scrollbar-thumb{background-color:#3e3c4d}.content-item[data-v-947c6bac]{border-bottom:1px solid rgba(50,50,50,.1);display:flex;align-items:baseline;flex-direction:column;justify-content:center;word-break:break-word}.item-key[data-v-947c6bac]{font-size:16px}.item-value[data-v-947c6bac]{font-size:14px}", ""]);
                const a = r
            },
            5464: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-general-view[data-v-357ec510]{display:flex;flex-direction:column;justify-content:space-between;height:calc(100vh - 25px)}.content[data-v-357ec510]{padding:5px;flex-grow:1;overflow:hidden;display:flex;justify-content:space-between;flex-direction:column;margin:0 auto;width:70vw;height:80vh;max-height:600px;max-width:650px}.item[data-v-357ec510]{position:relative;padding:0px 20px;font-size:1.1em;display:flex;align-items:center;justify-content:space-between;border-radius:3px;height:100%;transition:background-color .3s}.item[data-v-357ec510]:hover{background-color:var(--general-item-bgc)}.title[data-v-357ec510]{color:var(--general-title-c);font-size:2em;font-weight:500;cursor:pointer;display:flex;align-items:center}.clickable[data-v-357ec510]{cursor:pointer;border-bottom-style:dashed;border-bottom-width:1px;border-bottom-color:var(--general-clickable-border-c)}.interfaces-card[data-v-357ec510]{position:fixed;left:calc(170px + (100vw - 170px)/2);transform:translate(-50%);bottom:20px;background-color:var(--general-interface-card-bgc);padding:10px 30px;border-radius:5px;max-height:50vh;overflow-y:auto;box-shadow:1px 1px 10px 2px rgba(50,50,50,.3);z-index:2000}.interfaces-card[data-v-357ec510]::-webkit-scrollbar{width:16px}.interfaces-card[data-v-357ec510]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.interfaces-card[data-v-357ec510]::-webkit-scrollbar-corner{background-color:var(--bgc)}.interfaces-content[data-v-357ec510]{color:var(--general-interface-card-fgc);display:flex;align-items:flex-end;margin:10px 0px;align-items:center}.copy-icon[data-v-357ec510]{margin-right:10px;margin-top:2px;cursor:pointer}.copy-icon *[data-v-357ec510]{cursor:pointer}.tun-settings-icon[data-v-357ec510]{width:24px;height:24px;padding:2px;margin-left:10px;border-radius:5px;cursor:pointer}.tun-settings-icon *[data-v-357ec510]{cursor:pointer}.tun-settings-icon[data-v-357ec510]:hover{background-color:rgba(54,54,54,.26)}", ""]);
                const a = r
            },
            57726: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".error-hint[data-v-9ba71ad8]{font-size:14px;cursor:pointer;background-color:var(--bgc);color:var(--fgc);border:1px solid var(--bc);border-radius:3px;box-shadow:0px 0px 2px 1px var(--shadow);padding:6px 15px}#error-view-main[data-v-9ba71ad8]{display:flex;flex-direction:column;align-items:center;justify-content:center;flex-grow:1;padding-bottom:60px}#error-view-main .error-content[data-v-9ba71ad8]{font-size:15px;border:1px solid rgba(175,175,175,.178);padding:10px;max-height:100px;overflow-y:auto;margin-top:10px;margin-left:40px;margin-right:40px;color:#e74949}#error-view-main .error-content[data-v-9ba71ad8]::-webkit-scrollbar{width:16px}#error-view-main .error-content[data-v-9ba71ad8]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}#error-view-main .error-content[data-v-9ba71ad8]::-webkit-scrollbar-corner{background-color:var(--bgc)}.error-hints[data-v-9ba71ad8]{display:flex;flex-direction:column;align-items:center}.loading-hint[data-v-9ba71ad8]{font-size:22px;margin-bottom:40px}.error-btns[data-v-9ba71ad8]{display:flex;margin-top:30px}.error-btns div[data-v-9ba71ad8]{width:150px;text-align:center;margin:0 20px}", ""]);
                const a = r
            },
            57059: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".list[data-v-d9b850ea]{overflow-y:auto}.list[data-v-d9b850ea]::-webkit-scrollbar{width:16px}.list[data-v-d9b850ea]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.list[data-v-d9b850ea]::-webkit-scrollbar-corner{background-color:var(--bgc)}.if-list *[data-v-d9b850ea]{user-select:text}.if-list[data-v-d9b850ea] *{user-select:text}", ""]);
                const a = r
            },
            46907: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-tun-settings-view[data-v-47896be6]{width:calc(100% - 170px);height:calc(100% - 25px);position:absolute;top:25px;left:170px;color:#000}.main-tun-settings-view .content[data-v-47896be6]{border-radius:3px;width:600px;position:absolute;top:50%;left:50%;transform:translateX(-50%) translateY(-50%);padding:10px 20px;font-size:14px;font-weight:bold}.main-tun-settings-view .content .title[data-v-47896be6]{font-size:16px;margin-bottom:5px}.main-tun-settings-view .content .hint[data-v-47896be6]{opacity:.8}.main-tun-settings-view .content .hint span[data-v-47896be6]{opacity:1;font-weight:bold}.main-tun-settings-view .content .pannel[data-v-47896be6]{display:flex;height:100%;gap:10px}.main-tun-settings-view .content .pannel .left[data-v-47896be6]{width:300px;border-radius:5px;padding:5px 10px;max-height:430px;overflow:auto;overflow-y:auto}.main-tun-settings-view .content .pannel .left[data-v-47896be6]::-webkit-scrollbar{width:16px}.main-tun-settings-view .content .pannel .left[data-v-47896be6]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-tun-settings-view .content .pannel .left[data-v-47896be6]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-tun-settings-view .content .pannel .left>div[data-v-47896be6]{margin-bottom:5px}.main-tun-settings-view .content .pannel .left .flex[data-v-47896be6]{height:30px;align-items:center;justify-content:space-between;display:flex}.main-tun-settings-view .content .pannel .left .flex input[data-v-47896be6]{width:120px;text-align:center;outline:none;border-radius:3px;height:25px}.main-tun-settings-view .content .pannel .right[data-v-47896be6]{width:300px;padding:5px 10px;border-radius:4px;max-height:430px;overflow:auto;overflow-y:auto}.main-tun-settings-view .content .pannel .right[data-v-47896be6]::-webkit-scrollbar{width:16px}.main-tun-settings-view .content .pannel .right[data-v-47896be6]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-tun-settings-view .content .pannel .right[data-v-47896be6]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-tun-settings-view .content .pannel .right *[data-v-47896be6]{user-select:text}.main-tun-settings-view .content .pannel .right[data-v-47896be6] *{user-select:text}.main-tun-settings-view .content .btns[data-v-47896be6]{display:flex}.main-tun-settings-view .content .btns div[data-v-47896be6]:nth-child(2){width:10px}.main-tun-settings-view .content .btns .btn[data-v-47896be6]{flex-grow:2;background-color:#41b883;color:#fff;height:30px;margin-top:10px;line-height:30px;text-align:center;border-radius:3px}", ""]);
                const a = r
            },
            37911: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-tun-settings-view[data-v-b6dface2]{width:calc(100% - 170px);height:calc(100% - 25px);position:absolute;top:25px;left:170px;color:#000}.main-tun-settings-view .content[data-v-b6dface2]{border-radius:3px;width:600px;position:absolute;top:50%;left:50%;transform:translateX(-50%) translateY(-50%);padding:10px 20px;font-size:14px;font-weight:bold}.main-tun-settings-view .content .title[data-v-b6dface2]{font-size:16px;margin-bottom:5px}.main-tun-settings-view .content .pannel[data-v-b6dface2]{display:flex;height:100%}.main-tun-settings-view .content .pannel .left[data-v-b6dface2]{width:300px;border-radius:5px;padding:5px 10px;max-height:430px;overflow:auto;overflow-y:auto}.main-tun-settings-view .content .pannel .left[data-v-b6dface2]::-webkit-scrollbar{width:16px}.main-tun-settings-view .content .pannel .left[data-v-b6dface2]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-tun-settings-view .content .pannel .left[data-v-b6dface2]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-tun-settings-view .content .pannel .left>div[data-v-b6dface2]{margin-bottom:5px}.main-tun-settings-view .content .pannel .left .flex[data-v-b6dface2]{height:30px;align-items:center;justify-content:space-between;display:flex}.main-tun-settings-view .content .pannel .left .flex input[data-v-b6dface2]{width:120px;text-align:center;outline:none;border-radius:3px;height:25px}.main-tun-settings-view .content .pannel .right[data-v-b6dface2]{width:300px;margin-left:10px;border-radius:4px;max-height:430px;overflow:auto;overflow-y:auto}.main-tun-settings-view .content .pannel .right[data-v-b6dface2]::-webkit-scrollbar{width:16px}.main-tun-settings-view .content .pannel .right[data-v-b6dface2]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-tun-settings-view .content .pannel .right[data-v-b6dface2]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-tun-settings-view .content .pannel .right *[data-v-b6dface2]{user-select:text}.main-tun-settings-view .content .pannel .right[data-v-b6dface2] *{user-select:text}.main-tun-settings-view .content .pannel .right pre[data-v-b6dface2]{width:100%;height:100%;padding:5px;font-weight:normal;font-family:Consolas,Monaco,Lucida Console,Liberation Mono,DejaVu Sans Mono,Bitstream Vera Sans Mono,Courier New,monospace}.main-tun-settings-view .content .btns[data-v-b6dface2]{display:flex;gap:4px}.main-tun-settings-view .content .btns div[data-v-b6dface2]:nth-child(1){background-color:rgba(0,0,0,0);color:#d44545;border:1px solid #d44545;flex-grow:1}.main-tun-settings-view .content .btns div[data-v-b6dface2]:nth-child(2){background-color:rgba(0,0,0,0);color:var(--fgc);opacity:.7;border:1px solid var(--fgc);flex-grow:1}.main-tun-settings-view .content .btns .btn[data-v-b6dface2]{flex-grow:3;background-color:#41b883;color:#fff;height:30px;margin-top:10px;line-height:30px;text-align:center;border-radius:3px}", ""]);
                const a = r
            },
            11892: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-log-view[data-v-6acd51f2]{height:100%;overflow:hidden;display:flex;flex-direction:column;justify-content:space-between}.main-log-view .title[data-v-6acd51f2]{padding:0 20px;font-size:20px;height:80px;display:flex;align-items:center;justify-content:space-between;border-bottom:1px solid var(--bc)}.main-log-view .title .text .hint[data-v-6acd51f2]{font-size:16px;font-weight:normal}.log-item[data-v-6acd51f2]{display:flex;justify-content:space-between;flex-direction:column;padding:5px 10px 5px 20px;border-bottom:1px solid var(--log-item-border-c)}.rule[data-v-6acd51f2]{font-size:14px;color:var(--log-item-rule-c);display:flex;align-items:center;flex-wrap:wrap}.rule div[data-v-6acd51f2]{margin-right:5px}.rule .payload[data-v-6acd51f2]{color:var(--log-item-payload-c)}.log-list[data-v-6acd51f2]{height:calc(100% - 80px);overflow-y:auto}.log-list[data-v-6acd51f2]::-webkit-scrollbar{width:16px}.log-list[data-v-6acd51f2]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.log-list[data-v-6acd51f2]::-webkit-scrollbar-corner{background-color:var(--bgc)}.log-list .empty-list[data-v-6acd51f2]{font-size:18px;color:gray;width:100%;height:100%;display:flex;align-items:center;flex-direction:column;justify-content:center}.log-list .empty-list div[data-v-6acd51f2]:last-child{font-size:14px}.url[data-v-6acd51f2]{word-break:break-all;white-space:normal;display:flex;flex-direction:column;flex-grow:1}.url .name[data-v-6acd51f2]{font-size:16px}.url div[data-v-6acd51f2]{margin-right:5px}.proxy-name[data-v-6acd51f2]{font-size:14px;margin:auto 0px auto 20px;min-width:50%;display:flex;justify-content:flex-end;word-break:break-all}.left[data-v-6acd51f2]{display:flex}", ""]);
                const a = r
            },
            79928: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".menu[data-v-149ea1bd]{background-color:var(--bgc);color:var(--fgc);list-style-type:none;border-bottom:1px solid var(--bc);position:relative;display:flex;flex-direction:column;height:400px;justify-content:space-between}.item[data-v-149ea1bd]{flex-grow:1;font-size:1em;cursor:pointer;display:flex;align-items:center}.item-draggable .item[data-v-149ea1bd]{-webkit-user-drag:element}.item-none[data-v-149ea1bd]{background-color:var(--mbgc);color:var(--menu-fgc)}.running-time[data-v-149ea1bd]{flex-grow:1;color:var(--fgc)}.traffic[data-v-149ea1bd]{margin-top:0px;color:var(--fgc)}.main-main-menu[data-v-149ea1bd]{z-index:2;height:100%;display:flex;flex-direction:column}.main-main-menu .stop-btn[data-v-149ea1bd]{cursor:pointer;position:absolute;top:515px;left:20px;border-radius:20px;color:#fff;height:30px;width:130px;line-height:30px;text-align:center;font-size:14px;font-weight:normal;background-color:#d14444;box-shadow:0px 0px 15px 1px rgba(49,49,49,.3);transform:all .3s}.drag-item[data-v-149ea1bd]{background-color:#41b883;color:#fff}.ghost-item[data-v-149ea1bd]{opacity:0}.shaking1[data-v-149ea1bd]{margin:2px 0;transform-origin:center;animation:shake-rotate-149ea1bd 400ms infinite}.shaking2[data-v-149ea1bd]{margin:2px 0;transform-origin:center;animation:shake-rotate-149ea1bd 400ms infinite;animation-delay:100ms}.shaking3[data-v-149ea1bd]{margin:2px 0;transform-origin:center;animation:shake-rotate-149ea1bd 400ms infinite;animation-delay:200ms}.clickable[data-v-149ea1bd]{cursor:pointer;text-align:center;width:100%}.selected-top[data-v-149ea1bd]{border-bottom-right-radius:10px}.selected-bottom[data-v-149ea1bd]{border-top-right-radius:10px}@keyframes shake-rotate-149ea1bd{0%{transform:rotate(0deg)}12.5%{transform:rotate(0.5deg)}25%{-webkit-transform:rotate(1.2deg)}37.5%{transform:rotate(0.5deg)}50%{transform:rotate(0deg)}62.5%{transform:rotate(-0.5deg)}75%{transform:rotate(-1.2deg)}87.5%{transform:rotate(-0.5deg)}100%{transform:rotate(0deg)}}", ""]);
                const a = r
            },
            73816: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".grid[data-v-4f5120b9]{background-color:var(--mbgc);padding:0;width:100%;text-align:center;flex:1;display:flex;align-items:center;font-size:.8em;letter-spacing:.5px}.grid div[data-v-4f5120b9]{width:100%;display:flex;align-items:baseline;padding:0 40px;justify-content:space-between}.main-clash-traffic-view[data-v-4f5120b9]{height:80px;display:flex;flex-direction:column;border-bottom:1px solid var(--bc)}", ""]);
                const a = r
            },
            26534: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-provider-view[data-v-3e34584d]{width:calc(100% - 170px);height:calc(100% - 25px);position:absolute;top:25px;right:0;display:flex;justify-content:center;align-items:center;z-index:10;font-size:16px}.main-provider-view .card[data-v-3e34584d]{display:flex;flex-direction:column;height:100%;width:100%}.main-provider-view .card .header[data-v-3e34584d]{min-height:80px;height:80px;border-bottom:1px solid var(--bc);background-color:var(--bgc);width:100%}.main-provider-view .card .header .buttons[data-v-3e34584d]{height:100%;width:100%;display:flex;align-items:center;justify-content:center}.main-provider-view .card .header .buttons .btn[data-v-3e34584d]{font-size:16px;color:var(--mode-switcher-selected-fgc);background-color:var(--mode-switcher-selected-bgc);border-radius:3px;height:35px;padding:0 20px;width:fit-content}.main-provider-view .card .header .buttons .btn[data-v-3e34584d]:first-child{margin-right:30px}.main-provider-view .content[data-v-3e34584d]{padding:5px 0 40px 0;flex-grow:1;display:flex;flex-direction:column;height:100%;width:100%;overflow-y:auto}.main-provider-view .content[data-v-3e34584d]::-webkit-scrollbar{width:16px}.main-provider-view .content[data-v-3e34584d]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-provider-view .content[data-v-3e34584d]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-provider-view .content .title[data-v-3e34584d]{margin-top:10px;font-size:16px;text-align:center;padding-bottom:10px;border-bottom:1px solid var(--bc)}.main-provider-view .content .items .provider-item[data-v-3e34584d]{padding:7px 35px 7px 45px;border-bottom:1px solid var(--bc)}.main-provider-view .content .items .provider-item .provider-item-main[data-v-3e34584d]{display:flex;align-items:center}.main-provider-view .content .items .provider-item .provider-item-main .name-type[data-v-3e34584d]{display:flex;align-items:center}.main-provider-view .content .items .provider-item .provider-item-main .name-type .name[data-v-3e34584d]{font-size:16px;max-width:180px;overflow:clip;white-space:nowrap;text-overflow:ellipsis}.main-provider-view .content .items .provider-item .provider-item-main .update-hint[data-v-3e34584d]{font-size:14px;color:var(--proxy-item-hint-c)}.main-provider-view .content .items .provider-item .provider-item-main .error-hint[data-v-3e34584d]{color:var(--proxy-item-latency-offline-c);font-size:12px;max-width:500px;text-overflow:ellipsis;white-space:normal;overflow:hidden}.main-provider-view .content .items .provider-item .provider-item-main .empty[data-v-3e34584d]{flex-grow:1}.main-provider-view .content .items .provider-item .provider-item-main .icon-btn[data-v-3e34584d]{width:30px;height:30px;display:flex;align-items:center;justify-content:center;border-radius:3px}.main-provider-view .content .items .provider-item .provider-item-main .icon-btn[data-v-3e34584d]:hover{background-color:rgba(0,0,0,.123)}.main-provider-view .content .items .provider-item .provider-item-main .icon-btn:hover *[data-v-3e34584d]{cursor:pointer}.main-provider-view .content .items .provider-item .provider-item-main .icon-btn .rotating[data-v-3e34584d]{animation:downloading-3e34584d 1s infinite;animation-timing-function:linear}@keyframes downloading-3e34584d{from{transform:rotate(0deg)}to{transform:rotate(360deg)}}.main-provider-view .content .items .provider-item .provider-item-main .icon-btn svg[data-v-3e34584d]{width:20px;height:20px;fill:var(--fgc)}.main-provider-view .content .items .provider-item .time[data-v-3e34584d]{font-size:14px}.main-provider-view .content .items .provider-item .proxies[data-v-3e34584d]{display:grid;grid-template-columns:repeat(auto-fill, 130px);font-size:14px}.main-provider-view .content .items .provider-item .proxies .proxy-item[data-v-3e34584d]{height:80px}", ""]);
                const a = r
            },
            8137: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".fake-item[data-v-0729f95b]{height:45px;background-color:var(--proxy-fake-item-bgc);box-shadow:none}.fake-section[data-v-0729f95b]{background-color:var(--proxy-fake-item-bgc);height:50px;width:300px;margin-top:20px;margin-left:40px}#main-proxy-view[data-v-0729f95b]{height:100%;display:flex;flex-direction:column;overflow:hidden}.scroll-view[data-v-0729f95b]{margin-top:88px;padding-bottom:70px;flex-grow:1;height:calc(100% - 80px);overflow-y:auto}.scroll-view[data-v-0729f95b]::-webkit-scrollbar{width:16px}.scroll-view[data-v-0729f95b]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.scroll-view[data-v-0729f95b]::-webkit-scrollbar-corner{background-color:var(--bgc)}.scroll-view .proxy-item[data-v-0729f95b]{margin:4px 6px;display:flex;align-items:center;flex-grow:1;transition:all .3s}.scroll-view .proxy-item .indicator[data-v-0729f95b]{width:4px;min-width:4px;background-color:var(--proxy-item-border-c);height:calc(100% - 2px);border-radius:10px;margin-right:4px}.scroll-view .proxy-item .info[data-v-0729f95b]{height:100%;padding:7px 0;background:var(--proxy-item-bgc);flex-grow:1;display:flex;border-radius:3px;justify-content:space-between;align-items:center}.scroll-view .proxy-item .info .left[data-v-0729f95b]{flex-grow:1;margin-left:10px;word-break:break-all}.scroll-view .proxy-item .info .left .item-bottom[data-v-0729f95b]{display:flex;font-size:12px;align-items:center;margin-top:2px;color:var(--proxy-item-hint-c)}.scroll-view .proxy-item .info .left .item-bottom .item-hint[data-v-0729f95b]{margin-right:5px}.scroll-view .proxy-item .info .left .item-bottom .item-udp[data-v-0729f95b]{font-size:9px;padding:0 3px;border:1px solid var(--proxy-item-border-c);border-radius:3px;word-break:keep-all}.scroll-view .proxy-item .info .time[data-v-0729f95b]{min-width:70px;text-align:right;font-size:12px;padding:12px 14px 12px 12px;cursor:pointer}.scroll-view .proxy-item .info .offline[data-v-0729f95b]{color:var(--proxy-item-latency-offline-c);font-weight:normal}.scroll-view .proxy-item .info .online[data-v-0729f95b]{color:var(--proxy-item-latency-online-c)}.scroll-view .selected .indicator[data-v-0729f95b]{background-color:var(--proxy-item-selected-border-c)}.proxy-section[data-v-0729f95b]{font-size:1.2em;font-weight:normal;padding:7px 10px;display:flex;align-items:center;justify-content:space-between;cursor:pointer;position:sticky;top:-1px;background-color:var(--bgc);transition:all .3s}.proxy-section[data-v-0729f95b]:hover{border-radius:5px;background-color:var(--general-item-bgc);cursor:pointer}.proxy-section .proxy-section-right[data-v-0729f95b]{display:flex;align-items:flex-end;height:100%;fill:var(--fgc)}.proxy-section .proxy-hint[data-v-0729f95b]{font-size:13px;display:inline;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.proxy-section .proxy-hint-type[data-v-0729f95b]{font-size:10px;margin-left:10px;color:var(--proxy-item-type-fgc);background:var(--proxy-item-type-bgc);padding:0 4px;border-radius:3px}.proxy-section .proxy-hint-type-selector[data-v-0729f95b]{background:#41b883}.proxy-section .proxy-hint-line[data-v-0729f95b]{width:10px;height:1px}.empty-hint[data-v-0729f95b]{display:flex;flex-direction:column;align-items:center;justify-content:center;width:100%;height:100%;color:rgba(143,143,143,.795)}.empty-hint div[data-v-0729f95b]:first-child{font-size:22px}.empty-hint div[data-v-0729f95b]:last-child{font-size:14px;margin-top:10px}.empty-hint div:last-child span[data-v-0729f95b]{color:#008cff}", ""]);
                const a = r
            },
            71717: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".flick[data-v-0729f95b]{opacity:.1}.proxy-list[data-v-0729f95b]{margin:0px 20px 0 30px}.proxy-items[data-v-0729f95b]{display:flex;flex-wrap:wrap;justify-content:space-around}.proxy-items>i[data-v-0729f95b]{margin:0px 6px;flex-grow:1;height:0}.item-name[data-v-0729f95b]{font-size:14px;display:flex;align-items:center;overflow:hidden;word-break:break-all}.proxy-hint-loadbalance[data-v-0729f95b]{font-size:.7em;margin-left:5px;overflow:hidden;padding-bottom:2px}.proxy-item[data-v-0729f95b] div,span[data-v-0729f95b]{cursor:pointer}.proxy-section-name[data-v-0729f95b]{font-size:1.05em;display:flex;align-items:center;max-width:500px}.proxy-section-name-left[data-v-0729f95b]{display:flex;align-items:flex-end;flex-shrink:0;font-size:17px}.proxy-section-test-btn[data-v-0729f95b]{cursor:pointer;height:40px;width:30px}.sec-icon[data-v-0729f95b]{height:30px;width:30px;padding:5px;display:flex;align-items:center;justify-content:center}.sec-icon[data-v-0729f95b]:hover{border-radius:5px;background-color:rgba(187,187,187,.5);cursor:pointer}.filter-keyword[data-v-0729f95b]{position:fixed;bottom:10px;right:45px;width:150px;height:30px}.filter-keyword input[data-v-0729f95b]{width:150px;padding:0 10px;border:none;background-color:#494949;border-radius:5px;height:30px;color:#fff;top:0;right:5px;position:absolute}.filter-keyword input[data-v-0729f95b]:focus{outline:none}.filter-keyword div[data-v-0729f95b]{width:30px;height:30px;position:absolute;right:0px;top:0px;display:flex;align-items:center;justify-content:center;background-color:#494949;border-radius:5px}.filter-keyword div img[data-v-0729f95b]{height:20px;width:20px}.fall-fade-enter-active[data-v-0729f95b]{transition:all .2s ease-in-out}.fall-fade-enter[data-v-0729f95b],.fall-fade-leave-to[data-v-0729f95b]{transform:translateY(-10px);opacity:0}.move-right-enter-active[data-v-0729f95b]{transition:all .2s ease}.move-right-leave-to[data-v-0729f95b],.move-right-enter[data-v-0729f95b]{transform:scaleX(0.1);transform-origin:right}", ""]);
                const a = r
            },
            52062: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".selected[data-v-357c3e79]{color:var(--mode-switcher-selected-fgc);background-color:var(--mode-switcher-selected-bgc)}.normal[data-v-357c3e79]{color:var(--mode-switcher-normal-fgc);background-color:var(--mode-switcher-normal-bgc)}.main[data-v-357c3e79]{border-bottom:1px solid var(--bc)}#main-mode-switcher[data-v-357c3e79]{padding:auto 20px;width:calc(100vw - 170px);height:80px;position:fixed}#main-mode-switcher .btns[data-v-357c3e79]{height:100%;align-items:center;margin:0 auto;display:flex;max-width:600px;justify-content:space-between}#main-mode-switcher .btns .btn[data-v-357c3e79]{margin:0 0;font-weight:500;font-size:1.2em;width:120px;height:40px;text-align:center;line-height:40px;border-radius:6px;box-shadow:1px 1px 5px 2px rgba(70,70,70,.1);cursor:pointer}", ""]);
                const a = r
            },
            63329: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-router-view[data-v-74ff0369]{height:100%;width:100%;position:relative}.main-router-view .header[data-v-74ff0369]{height:80px;border-bottom:1px solid var(--bc);font-size:20px;display:flex;justify-content:space-between;align-items:center;padding:0 20px}.main-router-view .header .btn[data-v-74ff0369]{font-size:16px;padding:5px 15px;margin-right:10px;text-align:center;font-weight:normal;cursor:pointer;border-radius:3px;color:#fff}.main-router-view .header .btn-start[data-v-74ff0369]{background-color:#535353}.main-router-view .header .btn-stop[data-v-74ff0369]{background-color:#41b883}.main-router-view .list[data-v-74ff0369]{font-size:16px;padding:20px 20px 20px 30px;height:calc(100% - 80px);overflow-y:auto}.main-router-view .list[data-v-74ff0369]::-webkit-scrollbar{width:16px}.main-router-view .list[data-v-74ff0369]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-router-view .list[data-v-74ff0369]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-router-view .list .item[data-v-74ff0369]{margin:10px 0px;display:flex;align-items:center;justify-content:space-between}.main-router-view .list .item .left .name Input[data-v-74ff0369]{font-size:16px;border:none;outline:none;background-color:rgba(255,255,255,0);color:var(--fgc)}.main-router-view .list .item .left .ip[data-v-74ff0369]{font-size:12px;color:var(--proxy-item-hint-c)}.main-router-view .list .item .right[data-v-74ff0369]{font-size:14px;display:flex;align-items:center}.main-router-view .list .item .right .btn[data-v-74ff0369]{padding:5px 10px;text-align:center;font-weight:normal;cursor:pointer;border-radius:3px;background-color:rgba(216,216,216,.452);margin-left:10px}", ""]);
                const a = r
            },
            22736: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, '.main-router-config-view[data-v-0ffa25f2]{background-color:rgba(50,50,50,.6);width:100%;height:100%;position:absolute;top:0px;left:0px;color:#000}.main-router-config-view .content[data-v-0ffa25f2]{border-radius:3px;width:500px;position:absolute;top:50%;left:50%;transform:translateX(-50%) translateY(-50%);padding:20px;font-size:14px;font-weight:bold}.main-router-config-view .content .title[data-v-0ffa25f2]{font-size:16px;margin-bottom:5px}.main-router-config-view .content .sec[data-v-0ffa25f2]{margin:10px 0;border-radius:3px;padding:5px 0px}.main-router-config-view .content .sec .flex[data-v-0ffa25f2]{display:flex}.main-router-config-view .content .sec span[data-v-0ffa25f2]{margin-right:3px}.main-router-config-view .content .sec span[data-v-0ffa25f2]::after{content:" :"}.main-router-config-view .content .sec input[data-v-0ffa25f2]{text-align:center;width:120px;margin-right:20px;border-radius:3px;outline:none;font-weight:normal;background-color:rgba(0,0,0,0)}.main-router-config-view .content .btn[data-v-0ffa25f2]{background-color:#41b883;color:#fff;height:30px;line-height:30px;text-align:center;border-radius:3px}', ""]);
                const a = r
            },
            98319: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".card[data-v-820f0efe]{position:fixed;padding:0 35px;height:80px;width:calc(100vw - 170px);display:flex;justify-content:space-between;background-color:var(--bgc);border-bottom:1px solid var(--bc)}.list-item[data-v-820f0efe]{background-color:var(--bgc);margin:4px 6px;display:flex;justify-content:space-between;position:relative;width:295px;flex-grow:1}.list-item .item-subinfo[data-v-820f0efe]{width:fit-content}.list-item .item-subinfo .item-subinfo-texts[data-v-820f0efe]{display:flex;font-size:11px;color:var(--proxy-item-hint-c)}.list-item .item-subinfo .item-subinfo-texts div[data-v-820f0efe]{margin-right:10px}.list-item .item-subinfo .item-subinfo-texts div[data-v-820f0efe]:last-child{margin-right:0}.list-item .item-subinfo .progress[data-v-820f0efe]{background-color:var(--proxy-item-subs-bgc);text-align:center;height:3px;width:100%;color:var(--proxy-item-subs-fgc);position:relative;border-radius:3px;margin-bottom:2px}.list-item .item-subinfo .progress .percent[data-v-820f0efe]{border-radius:3px;width:100%;top:0;left:0;position:absolute;height:100%;background-color:var(--proxy-item-subs-used-bgc)}.list-item .indicator[data-v-820f0efe]{margin-right:4px;margin-top:2px;width:4px;height:calc(100% - 4px);border-radius:10px;background-color:var(--proxy-item-border-c)}.list-item .item-info[data-v-820f0efe]{padding:4px 5px;background-color:var(--proxy-item-bgc);display:flex;align-items:center;justify-content:flex-start;flex-grow:1;max-width:calc(100% - 8px);border-radius:3px;height:100%;position:relative}.list-item .item-info .refresh-icon[data-v-820f0efe]{width:18px;height:18px;position:absolute;right:3px;top:3px}.list-item .item-info .item-name[data-v-820f0efe]{cursor:pointer;margin-left:5px;flex-grow:1;width:calc(100% - 50px);font-size:15px}.list-item .item-info .item-name .item-name-bottom[data-v-820f0efe]{font-size:13px;cursor:pointer;max-width:calc(100% - 10px);text-overflow:ellipsis;white-space:nowrap;overflow:hidden;font-weight:normal;color:var(--proxy-item-hint-c)}.list-item .item-info .item-edit-zone[data-v-820f0efe]{background-color:var(--bgc);box-shadow:0px 0px 4px 0px rgba(0,0,0,.3);border-radius:5px;position:absolute;width:175px;display:flex;flex-wrap:wrap;justify-content:space-between;right:30px;z-index:1}.list-item .item-icon[data-v-820f0efe]{width:30px;height:30px;cursor:pointer;border-radius:5px;display:flex;align-items:center;justify-content:center;transition:background-color .3s;cursor:pointer}.list-item .item-icon *[data-v-820f0efe]{cursor:pointer}.list-item .item-icon[data-v-820f0efe]:hover{background-color:rgba(189,189,189,.534)}.list-item .item-icon>svg[data-v-820f0efe]{width:18px;height:18px;fill:var(--fgc)}.list-item .item-disabled[data-v-820f0efe]{cursor:not-allowed}.list-item .item-disabled>svg[data-v-820f0efe]{fill:gray}.list-item .more[data-v-820f0efe]{position:absolute;right:0;width:30px;height:100%;display:flex;align-items:center;justify-content:center;border-top-right-radius:3px;border-bottom-right-radius:3px}.list-item .more[data-v-820f0efe]:hover{background-color:rgba(128,128,128,.1)}.list-item .more>svg[data-v-820f0efe]{height:18px;fill:var(--fgc)}.main[data-v-820f0efe]{display:flex;flex-direction:column;height:100%}#main-server-view[data-v-820f0efe]{height:100%}.list-view[data-v-820f0efe]{margin-top:80px;height:calc(100% - 80px);width:100%;overflow-y:auto;display:flex;flex-wrap:wrap;padding:10px 20px 20px 30px;align-content:flex-start}.list-view[data-v-820f0efe]::-webkit-scrollbar{width:16px}.list-view[data-v-820f0efe]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.list-view[data-v-820f0efe]::-webkit-scrollbar-corner{background-color:var(--bgc)}.list-view>*[data-v-820f0efe]{-webkit-user-drag:element}.list-view i[data-v-820f0efe]{width:295px;margin:0px 6px;flex-grow:1;height:0}.input-container[data-v-820f0efe]{display:flex;flex-grow:1;overflow:hidden;padding-right:5px;justify-content:space-between;position:relative;z-index:1}.input-container input[data-v-820f0efe]{padding-right:40px}", ""]);
                const a = r
            },
            69953: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-config-view[data-v-9e0b3cf4]{height:100%;position:fixed}.main-config-view .proxy-group[data-v-9e0b3cf4]{flex:1;overflow-y:auto;padding:0px 20px 20px 15px}.main-config-view .proxy-group[data-v-9e0b3cf4]::-webkit-scrollbar{width:16px}.main-config-view .proxy-group[data-v-9e0b3cf4]::-webkit-scrollbar-thumb{background-color:rgba(101,81,122,.7);border-radius:100px;border:3px solid var(--bgc)}.main-config-view .proxy-group[data-v-9e0b3cf4]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-config-view .proxy[data-v-9e0b3cf4]{flex:1;overflow-y:auto;direction:rtl;padding:0px 15px 20px 20px}.main-config-view .proxy[data-v-9e0b3cf4]::-webkit-scrollbar{width:16px}.main-config-view .proxy[data-v-9e0b3cf4]::-webkit-scrollbar-thumb{background-color:rgba(55,57,72,.7);border-radius:100px;border:3px solid var(--bgc)}.main-config-view .proxy[data-v-9e0b3cf4]::-webkit-scrollbar-corner{background-color:var(--bgc)}.dragArea[data-v-9e0b3cf4]{min-height:1px}.dragArea>*[data-v-9e0b3cf4]{-webkit-user-drag:element}", ""]);
                const a = r
            },
            5504: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main[data-v-f638b328]{position:fixed;left:170px;top:30px;width:calc(100vw - 170px);height:100%;background-color:var(--bgc);padding:10px 30px;overflow-y:auto}.main[data-v-f638b328]::-webkit-scrollbar{width:16px}.main[data-v-f638b328]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main[data-v-f638b328]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main input[data-v-f638b328]{color:var(--fgc);background-color:var(--bgc)}", ""]);
                const a = r
            },
            52845: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".qrcode-view-main[data-v-2c37fa0d]{position:fixed;left:170px;top:25px;height:100%;width:calc(100vw - 170px);display:flex;justify-content:center;align-items:center;background-color:rgba(50,50,50,.6);z-index:100}.qrcode-view-main .content[data-v-2c37fa0d]{width:250px;background-color:#fff;box-shadow:0px 0px 10px 3px rgba(14,14,14,.164);border-radius:2px;padding:10px 10px 20px 10px;display:flex;flex-direction:column;justify-content:space-between;align-items:center}.qrcode-view-main .content img[data-v-2c37fa0d]{width:230px;height:230px}.qrcode-view-main .content .url[data-v-2c37fa0d]{font-size:12px;width:200px;overflow-wrap:anywhere;text-decoration:underline;cursor:pointer;color:#0f7bd3}.qrcode-view-main .content .btn[data-v-2c37fa0d]{margin-top:10px;height:45px;color:#fff;cursor:pointer;line-height:45px;text-align:center;background-color:#7e7b7b;border-radius:3px;padding-left:10px;padding-right:10px;font-size:.85em;box-shadow:0px 2px 20px 2px rgba(50,50,50,.1);width:200px}", ""]);
                const a = r
            },
            53640: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".rule[data-v-459dde1e]{font-size:13px;color:var(--log-item-rule-c)}.log-item[data-v-459dde1e]{display:flex;justify-content:space-between;align-items:center;padding:5px 20px;border-bottom:1px solid var(--log-item-border-c)}.log-list[data-v-459dde1e]{width:calc(100% - 0px);border:0px solid rgba(50,50,50,.2);height:calc(100% - 100px);border-style:dashed;padding:10px 20px;overflow-y:auto}.log-list[data-v-459dde1e]::-webkit-scrollbar{width:16px}.log-list[data-v-459dde1e]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.log-list[data-v-459dde1e]::-webkit-scrollbar-corner{background-color:var(--bgc)}", ""]);
                const a = r
            },
            21732: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".model-title[data-v-eea841c4]{display:flex;font-size:1.2em;justify-content:space-between}.modal-container[data-v-eea841c4]{width:500px;margin:0px auto;padding:20px 30px;background-color:var(--bgc);border-radius:2px;box-shadow:0 2px 8px rgba(0,0,0,.33);transition:all .3s ease}.modal-container input[data-v-eea841c4]{color:var(--fgc);background-color:var(--bgc)}.scroll-view[data-v-eea841c4]{margin-top:20px;max-height:400px;padding:0 10px;overflow-y:auto}.scroll-view[data-v-eea841c4]::-webkit-scrollbar{width:16px}.scroll-view[data-v-eea841c4]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.scroll-view[data-v-eea841c4]::-webkit-scrollbar-corner{background-color:var(--bgc)}", ""]);
                const a = r
            },
            90596: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-setting-view[data-v-fc0cd1de]{height:100%}.main-setting-view .blur[data-v-fc0cd1de]{filter:blur(15px)}.main-setting-view .title[data-v-fc0cd1de]{height:80px;border-bottom:1px solid var(--bc);font-size:20px;background-color:var(--bgc);display:flex;justify-content:space-between;align-items:center;padding:0 20px}.main-setting-view .title .btns[data-v-fc0cd1de]{height:100%;display:flex;align-items:center;gap:10px}.main-setting-view .title .btns .btn[data-v-fc0cd1de]{cursor:pointer;font-size:14px;color:var(--error-text);font-weight:normal;padding:5px 15px;border-radius:3px;background-color:var(--general-item-bgc)}.main-setting-view .content[data-v-fc0cd1de]{overflow-y:auto;padding:10px 10px 20px 10px;height:calc(100% - 80px)}.main-setting-view .content[data-v-fc0cd1de]::-webkit-scrollbar{width:16px}.main-setting-view .content[data-v-fc0cd1de]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-setting-view .content[data-v-fc0cd1de]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-setting-view .quit-btns[data-v-fc0cd1de]{display:flex;align-items:center;justify-content:center;margin-top:30px}.main-setting-view .quit-btns .btn[data-v-fc0cd1de]{background-color:rgba(255,30,0,.8);margin:0 7px;padding:5px 20px;color:#fff;border-radius:3px;font-size:14px;text-align:center}.main-setting-view .item[data-v-fc0cd1de]{font-weight:normal;display:flex;justify-content:space-between;align-items:center;height:35px;padding:0 10px;transition:all .3s}.main-setting-view .item .short-input[data-v-fc0cd1de]{width:190px}.main-setting-view .item .shorter-input[data-v-fc0cd1de]{width:156px}.main-setting-view .item .hint[data-v-fc0cd1de]{margin-left:10px}.main-setting-view .item .interface-hint[data-v-fc0cd1de]{margin-right:10px}.main-setting-view .item[data-v-fc0cd1de]:hover{background:var(--setting-item-hover-bgc);border-radius:3px}.main-setting-view .edit-hint[data-v-fc0cd1de]{background-color:rgba(0,0,0,.4);position:fixed;top:25px;width:calc(100% - 170px);height:calc(100vh - 25px);color:#fff;display:flex;flex-direction:column;align-items:center;justify-content:center}.main-setting-view .edit-hint div[data-v-fc0cd1de]:first-child{font-size:20px}.main-setting-view .edit-hint div[data-v-fc0cd1de]:nth-child(2){font-size:16px;margin-top:20px}.main-setting-view .edit-hint .btn[data-v-fc0cd1de]{font-size:18px;margin-top:40px;background-color:rgba(26,26,26,.7);padding:4px 12px;border-radius:3px;cursor:pointer}", ""]);
                const a = r
            },
            6357: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, "input[data-v-2ddf36e7]::-webkit-outer-spin-button,input[data-v-2ddf36e7]::-webkit-inner-spin-button{-webkit-appearance:none}.main-key-capture[data-v-2ddf36e7]{position:relative;width:200px}.main-key-capture input[data-v-2ddf36e7]{width:100%;text-align:center;border:none;outline-style:none;background-color:var(--setting-input-bgc);color:var(--fgc);height:26px;box-shadow:1px 1px 4px 1px rgba(50,50,50,.04);border-radius:2px}.main-key-capture input[data-v-2ddf36e7]::placeholder{color:var(--input-phc)}.main-key-capture .suffix[data-v-2ddf36e7]{position:absolute;right:10px;top:0;height:25px;line-height:25px;color:var(--menu-fgc);font-size:13px}.main-key-capture .hint[data-v-2ddf36e7]{position:absolute;font-size:12px;top:0;padding:0 10px;border-radius:13px;height:26px;line-height:26px;text-align:center;color:#fff;background-color:#535353;opacity:1;transform:translateX(calc(-100% - 10px));transition:all 300ms}.main-key-capture .hint-hide[data-v-2ddf36e7]{opacity:0}", ""]);
                const a = r
            },
            69083: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-more-hint[data-v-6a8f4af4]{display:flex;align-items:center}.main-more-hint .text[data-v-6a8f4af4]{color:var(--menu-fgc);font-size:13px}.main-more-hint .tirangle[data-v-6a8f4af4]{width:0;height:0;margin-left:5px;margin-top:2px;border-top:4px solid rgba(0,0,0,0);border-bottom:4px solid rgba(0,0,0,0);border-left:6px solid var(--menu-fgc)}", ""]);
                const a = r
            },
            44804: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-setting-section[data-v-18adce47]{margin:0px 2% 10px 2%;font-size:15px;width:96%}.main-setting-section .title[data-v-18adce47]{font-size:16px;height:34px;line-height:34px}.main-setting-section .content[data-v-18adce47]{background-color:var(--general-item-bgc);padding:5px 5px;border-radius:3px}", ""]);
                const a = r
            },
            91778: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-settings-separator[data-v-26bdfd95]{height:1px;width:100%;opacity:.5;background-color:var(--scroll-bar-bgc);margin:5px auto}", ""]);
                const a = r
            },
            19572: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-simple-input[data-v-0f00486f]{position:relative;width:250px}.main-simple-input input[data-v-0f00486f]{width:100%;text-align:center;border:none;outline-style:none;background-color:var(--setting-input-bgc);color:var(--fgc);height:25px;box-shadow:1px 1px 4px 1px rgba(50,50,50,.04);border-radius:2px}.main-simple-input .suffix[data-v-0f00486f]{position:absolute;right:10px;top:0;height:25px;line-height:25px;color:var(--menu-fgc);font-size:13px}", ""]);
                const a = r
            },
            28698: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main[data-v-65878d23]{height:25px;width:100vw;background-color:var(--status-bgc);color:var(--fgc);display:flex;justify-content:space-between;align-items:center}.main .empty[data-v-65878d23]{flex-grow:1;height:100%;display:flex;flex-direction:column}.main .empty .top[data-v-65878d23]{height:5px}.main .empty .top .left[data-v-65878d23]{height:100%;background-color:var(--proxy-item-latency-online-c)}.main .empty .bottom[data-v-65878d23]{flex-grow:1;-webkit-app-region:drag}.title[data-v-65878d23]{font-size:.75em;font-weight:100;letter-spacing:1px}.close[data-v-65878d23]{-webkit-app-region:no-drag;cursor:pointer;display:flex;align-items:center;justify-content:center;width:45px;height:100%;display:flex;align-items:center}.close span[data-v-65878d23]{text-align:center;cursor:pointer;height:20px;width:20px}", ""]);
                const a = r
            },
            59374: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-button-view[data-v-f3b3ccf8]{height:26px;width:90px;text-align:center;line-height:26px;background-color:#6777ef;border-radius:1500px;color:#fff;font-size:.78em;display:flex;align-items:center;justify-content:center;cursor:pointer}.main-button-view *[data-v-f3b3ccf8]{cursor:pointer}.main-button-view .line[data-v-f3b3ccf8]{display:flex;height:100%;width:100%;justify-content:center;align-items:center}.main-button-view .line .box[data-v-f3b3ccf8]{border-radius:20px;transform:scale(0.5, 0.5);background-color:#b3b3b3}.main-button-view .line .large[data-v-f3b3ccf8]{height:8px;width:8px;margin-left:2px;margin-right:2px}.main-button-view .line .small[data-v-f3b3ccf8]{height:5px;width:5px;margin-left:1px;margin-right:1px}.animation-delay1[data-v-f3b3ccf8]{animation:wave-f3b3ccf8 1s linear 0s infinite}.animation-delay2[data-v-f3b3ccf8]{animation:wave-f3b3ccf8 1s linear .2s infinite}.animation-delay3[data-v-f3b3ccf8]{animation:wave-f3b3ccf8 1s linear .4s infinite}.animation-delay4[data-v-f3b3ccf8]{animation:wave-f3b3ccf8 1s linear .6s infinite}.animation-delay5[data-v-f3b3ccf8]{animation:wave-f3b3ccf8 1s linear .8s infinite}@keyframes wave-f3b3ccf8{from{background-color:#f8f8f8;transform:scale(1.1, 1.1)}to{background-color:#adadad;transform:scale(0.5, 0.5)}}", ""]);
                const a = r
            },
            33509: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-check-box[data-v-1c767bad]{display:flex;justify-content:flex-start;align-items:center}.main-check-box svg[data-v-1c767bad]{margin-top:1px}.main-check-box .slot[data-v-1c767bad]{margin-left:5px}", ""]);
                const a = r
            },
            70406: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-edit-list-view .item[data-v-3ea6d831]{display:flex;margin-bottom:5px;height:25px}.main-edit-list-view .item input[data-v-3ea6d831]{width:calc(100% - 30px);outline:none;border-top-left-radius:3px;border-bottom-left-radius:3px;padding:0 10px;flex-grow:1}.main-edit-list-view .btn-add[data-v-3ea6d831]{width:100%;height:25px;border-radius:3px;border:1px solid #41b883;display:flex;justify-content:center;align-items:center}.main-edit-list-view .btn-remove[data-v-3ea6d831]{height:100%;width:30px;border-top-right-radius:3px;border-bottom-right-radius:3px;display:flex;justify-content:center;align-items:center;background-color:#d44545;border-left-color:rgba(0,0,0,0)}", ""]);
                const a = r
            },
            84234: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-edit-object-view input[data-v-352b843a]{width:calc(100% - 30px);outline:none;border-top-left-radius:3px;border-bottom-left-radius:3px;padding:0 10px;flex-grow:1}.main-edit-object-view .item[data-v-352b843a]{display:flex;margin-bottom:5px;height:25px}.main-edit-object-view .btn-add[data-v-352b843a]{width:100%;height:25px;border-radius:3px;border:1px solid #41b883;display:flex;justify-content:center;align-items:center}.main-edit-object-view .btn-remove[data-v-352b843a]{height:100%;width:30px;border-radius:3px;display:flex;justify-content:center;align-items:center;background-color:#d44545;border-left-color:rgba(0,0,0,0)}", ""]);
                const a = r
            },
            82681: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-hint-view[data-v-6e240a95]{position:relative}.main-hint-view .hint[data-v-6e240a95]{font-size:12px;background-color:#242424;padding:3px 5px;border-radius:3px;color:#fff;position:fixed;z-index:1000;white-space:nowrap;line-height:13px;font-weight:normal}", ""]);
                const a = r
            },
            11061: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".content[data-v-d4bbbea2]{position:fixed;background-color:var(--general-interface-card-bgc);color:var(--general-interface-card-fgc);padding:8px 10px;border-radius:6px;font-size:14px;z-index:1000;box-shadow:0px 0px 8px 2px rgba(0,0,0,.2);width:300px;overflow:hidden}.content a[data-v-d4bbbea2]{color:#8abdf8;text-decoration:none;cursor:pointer}.content .quote[data-v-d4bbbea2]{background-color:var(--general-interface-card-quote-bgc);padding:0 4px;border-radius:4px}.content li[data-v-d4bbbea2]{list-style:inside}.info-icon-main[data-v-d4bbbea2]{position:relative;display:flex;align-items:center;margin-left:4px}", ""]);
                const a = r
            },
            41044: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, '.main-proxy-navigator[data-v-298f5540]{position:absolute;height:calc(100% - 105px);display:flex;flex-direction:column;top:105px;right:20px;overflow-y:scroll;overflow-x:clip;transition:transform .2s;background-color:var(--bgc);border-color:var(--bc);border-width:0;border-style:solid}.main-proxy-navigator[data-v-298f5540]::before,.main-proxy-navigator[data-v-298f5540]::after{content:"";margin:auto}.main-proxy-navigator[data-v-298f5540]::-webkit-scrollbar{display:none}.main-proxy-navigator .item[data-v-298f5540]{font-size:12px;font-weight:normal;transition:all .1s;white-space:nowrap;padding-left:5px;z-index:2;color:var(--fgc)}.main-proxy-navigator .item-selected[data-v-298f5540]{color:var(--proxy-item-selected-border-c)}.main-proxy-navigator .item-hover[data-v-298f5540]{font-weight:bold}.main-proxy-navigator .item-error[data-v-298f5540]{color:var(--proxy-item-latency-offline-c)}', ""]);
                const a = r
            },
            65939: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-select-view[data-v-e458e7bc]{display:flex;align-items:center;justify-content:space-between}.item[data-v-e458e7bc]{color:#fff;height:26px;font-size:.8em;line-height:25px;padding:0 6px;text-align:center;cursor:pointer;min-width:50px;transition:all .3s}.item-single[data-v-e458e7bc]{background-color:var(--switch-bgc)}.item-double[data-v-e458e7bc]{background-color:var(--switch-bgc-second)}.item-first[data-v-e458e7bc]{border-top-left-radius:6px;border-bottom-left-radius:6px}.item-last[data-v-e458e7bc]{border-top-right-radius:6px;border-bottom-right-radius:6px}.item-selected[data-v-e458e7bc]{background-color:#179bbb;flex-grow:1}", ""]);
                const a = r
            },
            18228: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main[data-v-37d0be30]{border:2px solid var(--switch-bgc);background-color:var(--switch-bgc);border-radius:40px;width:34px;height:20px;box-shadow:0px 0px 5px 1px rgba(50,50,50,0);display:flex;padding:0 2px;align-items:center}.main *[data-v-37d0be30]{cursor:pointer}.text[data-v-37d0be30]{display:flex;justify-content:space-between;align-items:center;width:calc(100% - 0px);height:calc(100% - 4px)}.base[data-v-37d0be30]{width:calc(100% - 17px);height:100%}.text-font[data-v-37d0be30]{letter-spacing:0px;text-align:center;font-size:12px;margin-bottom:8px;color:#fff}.tint-right[data-v-37d0be30]{background-color:#d44545;border-radius:20px;width:12px}.tint-left[data-v-37d0be30]{background-color:#13af42;border-radius:20px;width:12px}.move-left-enter-active[data-v-37d0be30]{transition:all .2s ease}.move-left-leave-active[data-v-37d0be30]{transition:all .1s ease-out}.move-left-enter[data-v-37d0be30],.move-left-leave-to[data-v-37d0be30]{transform:translateX(-10px);opacity:0}.move-right-enter-active[data-v-37d0be30]{transition:all .2s ease}.move-right-leave-active[data-v-37d0be30]{transition:all .1s ease-out}.move-right-enter[data-v-37d0be30],.move-right-leave-to[data-v-37d0be30]{transform:translateX(10px);opacity:0}", ""]);
                const a = r
            },
            56932: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".tray-order-main[data-v-40749f51]{display:flex;align-items:center;font-size:13px}.tray-order-main .title[data-v-40749f51]{margin-right:5px}.tray-order-main .list[data-v-40749f51]{height:28px;display:flex;justify-content:center;align-items:center;min-width:40px;border-radius:3px;background-color:#e2e2e2;padding:3px 5px}.tray-order-main .list img[data-v-40749f51]{-webkit-user-drag:element;display:flex;align-items:center;justify-content:center;height:16px;margin:0 2px}.tray-order-main .left-list[data-v-40749f51]{margin-right:10px}", ""]);
                const a = r
            },
            59480: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-alert-view-plugin[data-v-12619986]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;display:flex;flex-direction:column;align-items:center;justify-content:center;color:#000;z-index:10}.main-alert-view-plugin *[data-v-12619986]{user-select:text}.main-alert-view-plugin[data-v-12619986] *{user-select:text}.main-alert-view-plugin .card-main[data-v-12619986]{border-radius:2px;display:flex;flex-direction:column;justify-content:space-around;width:50%}.main-alert-view-plugin .card-main .card-content[data-v-12619986]{padding:15px 20px}.main-alert-view-plugin .card-main .card-content .content-title[data-v-12619986]{font-size:1.2em;margin-bottom:15px}.main-alert-view-plugin .card-main .card-content .content-content[data-v-12619986]{font-size:15px;text-overflow:inherit;word-wrap:break-word;max-height:200px;overflow-y:auto}.main-alert-view-plugin .card-main .card-content .content-content[data-v-12619986]::-webkit-scrollbar{width:16px}.main-alert-view-plugin .card-main .card-content .content-content[data-v-12619986]::-webkit-scrollbar-thumb{background-color:var(--scroll-bar-bgc);border-radius:100px;border:3px solid var(--bgc)}.main-alert-view-plugin .card-main .card-content .content-content[data-v-12619986]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-alert-view-plugin .card-main .card-content .card-btns[data-v-12619986]{margin-top:20px;display:flex;justify-content:space-around}.main-alert-view-plugin .card-main .card-content .card-btns .btn[data-v-12619986]{cursor:pointer;color:#fff;width:100px;height:40px;text-align:center;line-height:40px;border-radius:3px}.main-alert-view-plugin .card-main .card-content .card-btns .btn-cancel[data-v-12619986]{background-color:#676475}.main-alert-view-plugin .card-main .card-content .card-btns .btn-ok[data-v-12619986]{background-color:#3e3c4d}", ""]);
                const a = r
            },
            21417: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-code-view[data-v-35f836ea]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;left:0px;display:flex;flex-direction:column;justify-content:space-between;z-index:100}.main-code-view .card[data-v-35f836ea]{width:calc(100% - 200px);height:calc(100% - 100px);border-radius:5px;position:absolute;top:50px;left:100px;overflow:hidden;box-shadow:0px 0px 10px rgba(0,0,0,.5)}.main-code-view .card .editor[data-v-35f836ea]{width:100%;height:calc(100% + 1px)}.main-code-view .card .error[data-v-35f836ea]{position:absolute;bottom:20px;left:50%;transform:translateX(-50%);box-shadow:0px 0px 10px rgba(0,0,0,.3);padding:10px 12px;border-radius:10px;background-color:#3d3d3d;display:flex;align-items:center}.main-code-view .card .error div[data-v-35f836ea]:first-child{color:#ff5252;font-weight:normal;font-size:14px;flex-shrink:1;white-space:pre-wrap}.main-code-view .card .error div[data-v-35f836ea]:last-child{height:26px;width:26px;padding:3px;flex-shrink:0}.main-code-view .card .error div[data-v-35f836ea]:last-child:hover{background-color:rgba(160,160,160,.534);border-radius:3px}.main-code-view .card .btns[data-v-35f836ea]{position:absolute;bottom:0px;right:0px;display:flex;z-index:100;color:#fff;margin-right:35px;margin-bottom:10px;font-size:14px}.main-code-view .card .btns div[data-v-35f836ea]{margin-left:10px;width:30px;height:30px;text-align:center;border-radius:3px;box-shadow:0px 0px 10px rgba(0,0,0,.2)}.main-code-view .card .btns div svg[data-v-35f836ea]{width:24px;height:24px;margin:3px;fill:#fff}.main-code-view .card .btns .abort-btn[data-v-35f836ea]{margin-bottom:10px;background-color:#ea4079}.main-code-view .card .btns .save-btn[data-v-35f836ea]{background-color:#41b883}", ""]);
                const a = r
            },
            57565: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-diff-view[data-v-c878e8f6]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;left:0px;display:flex;flex-direction:column;justify-content:space-between;z-index:100}.main-diff-view .card[data-v-c878e8f6]{width:calc(100% - 100px);height:calc(100% - 100px);border-radius:5px;position:absolute;top:50px;left:50px;overflow:hidden;box-shadow:0px 0px 10px rgba(0,0,0,.5)}.main-diff-view .card .editor[data-v-c878e8f6]{width:100%;height:calc(100% + 1px)}.main-diff-view .card .btns[data-v-c878e8f6]{position:absolute;bottom:0px;right:0px;display:flex;z-index:100;color:#fff;margin-right:50px;margin-bottom:10px;font-size:14px}.main-diff-view .card .btns div[data-v-c878e8f6]{margin-left:10px;width:30px;height:30px;text-align:center;border-radius:3px;box-shadow:0px 0px 10px rgba(0,0,0,.2)}.main-diff-view .card .btns div svg[data-v-c878e8f6]{width:24px;height:24px;margin:3px;fill:#fff}.main-diff-view .card .btns .abort-btn[data-v-c878e8f6]{margin-bottom:10px;background-color:#ea4079}.main-diff-view .card .btns .save-btn[data-v-c878e8f6]{background-color:#41b883}.main-diff-view .card .btns .change-btn-off[data-v-c878e8f6]{background-color:#797979}.main-diff-view .card .btns .change-btn-on[data-v-c878e8f6]{background-color:#41b883}", ""]);
                const a = r
            },
            14333: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-dns-view[data-v-6e0989c7]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;display:flex;flex-direction:column;align-items:center;justify-content:center;color:#000;z-index:1000;font-weight:normal}.main-dns-view *[data-v-6e0989c7]{user-select:text}.main-dns-view[data-v-6e0989c7] *{user-select:text}.card-main[data-v-6e0989c7]{border-radius:2px;min-width:450px;max-width:650px;width:fit-content;max-height:calc(100% - 40px)}.card-content[data-v-6e0989c7]{position:relative;display:flex;flex-direction:column;justify-content:space-around;transition:all .3s ease}.content-items[data-v-6e0989c7]{overflow-y:auto;overflow-x:hidden;max-height:360px}.content-items[data-v-6e0989c7]::-webkit-scrollbar{width:4px;background-color:rgba(151,151,151,0.4117647059)}.content-items[data-v-6e0989c7]::-webkit-scrollbar-thumb{background-color:#3e3c4d}.error-hint[data-v-6e0989c7]{font-size:.9em;color:red;margin:10px 20px 0 20px}.p[data-v-6e0989c7]{position:relative;margin-top:18px}.p span[data-v-6e0989c7]{position:absolute;top:-17px;left:4px;padding:0 6px;background-color:var(--bgc);margin-top:5px;color:var(--fgc);opacity:.8;font-size:14px}.p .c[data-v-6e0989c7]{border:1px solid var(--bc);padding:8px 8px 4px 8px;border-radius:3px;font-size:13px}", ""]);
                const a = r
            },
            4216: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-input-view-plugin[data-v-15034054]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;display:flex;flex-direction:column;align-items:center;justify-content:center;color:#000;z-index:1000}.card-main[data-v-15034054]{border-radius:2px;max-width:390px;max-height:calc(100% - 40px)}.card-content[data-v-15034054]{position:relative;display:flex;flex-direction:column;justify-content:space-around}.content-title[data-v-15034054]{margin:15px 20px 0 20px;font-size:1.2em;margin-bottom:15px}.content-hint[data-v-15034054]{font-size:.9em;margin:-5px 20px 5px 20px;color:#179bbb}.content-items[data-v-15034054]{border-top:1px solid rgba(128,128,128,.178);border-bottom:1px solid rgba(128,128,128,.178);overflow-y:auto;overflow-x:hidden;max-height:360px;padding:0 20px}.content-items[data-v-15034054]::-webkit-scrollbar{width:4px;background-color:rgba(151,151,151,0.4117647059)}.content-items[data-v-15034054]::-webkit-scrollbar-thumb{background-color:#3e3c4d}.content-item[data-v-15034054]{display:flex;margin:5px 0px 10px 0px;align-items:baseline;flex-direction:column;justify-content:space-between;height:fit-content}.item-key[data-v-15034054]{margin-bottom:5px;font-size:16px}.error-hint[data-v-15034054]{font-size:.9em;color:red;margin:10px 20px 0 20px}.card-btns[data-v-15034054]{margin-top:10px;margin-bottom:20px;display:flex;justify-content:space-around}.btn[data-v-15034054]{cursor:pointer;color:#fff;width:100px;height:40px;text-align:center;line-height:40px;border-radius:3px}.btn-cancel[data-v-15034054]{background-color:#676475}.btn-ok[data-v-15034054]{background-color:#3e3c4d}span[data-v-15034054]{color:red}textarea[data-v-15034054]{cursor:pointer;font-size:14px;outline:none;padding:10px 5px;width:350px;resize:none;font-family:inherit;max-height:200px;overflow-y:auto}", ""]);
                const a = r
            },
            80574: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-menu-view-plugin[data-v-00ec68dc]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;display:flex;flex-direction:column;align-items:center;justify-content:center;background-color:rgba(255,255,255,0);color:#000;z-index:100}.main-menu-view-plugin .card-main[data-v-00ec68dc]{border-radius:2px;background-color:#414141;display:flex;flex-direction:column;justify-content:space-around;width:fit-content}.main-menu-view-plugin .card-main .card-content[data-v-00ec68dc]{position:fixed;background-color:#4e4e4e;overflow-y:scroll;font-weight:normal;box-shadow:2px 2px 8px 2px rgba(0,0,0,.2);padding:5px 0;font-size:13px;border-radius:5px}.main-menu-view-plugin .card-main .card-content[data-v-00ec68dc]::-webkit-scrollbar{display:none}.main-menu-view-plugin .card-main .card-content .item[data-v-00ec68dc]{margin:2px 5px;padding:5px 10px;border-radius:3px;color:#fff;display:flex;align-items:center;justify-content:flex-start;min-width:150px}.main-menu-view-plugin .card-main .card-content .item[data-v-00ec68dc]:hover{background-color:#302a2a}.main-menu-view-plugin .card-main .card-content .item div[data-v-00ec68dc]{flex:1;white-space:nowrap}.main-menu-view-plugin .card-main .card-content .item-disabled[data-v-00ec68dc]{margin:2px 10px 5px 10px;padding:5px 5px;color:#d1d1d1;display:flex;align-items:center;justify-content:flex-start;min-width:150px;border-bottom:1px solid rgba(128,128,128,.514)}.main-menu-view-plugin .card-main .card-content .indicator[data-v-00ec68dc]{position:sticky;bottom:-5px;left:0;width:100%;height:30px;display:flex;align-items:center;justify-content:center}", ""]);
                const a = r
            },
            5424: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-script-view[data-v-05227e49]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;left:0px;display:flex;flex-direction:column;justify-content:space-between;z-index:100}.main-script-view .card[data-v-05227e49]{width:calc(100% - 200px);height:calc(100% - 100px);border-radius:5px;position:absolute;top:50px;left:100px;overflow:hidden;box-shadow:0px 0px 10px rgba(0,0,0,.5)}.main-script-view .card .metadata[data-v-05227e49]{width:100%;flex-grow:0}.main-script-view .card .metadata div[data-v-05227e49]{display:flex;align-items:center}.main-script-view .card .metadata div span[data-v-05227e49]{margin-right:10px}.main-script-view .card .metadata div input[data-v-05227e49]{flex-grow:1;outline:none;padding:2px 8px}.main-script-view .card .editor-code[data-v-05227e49]{width:100%;flex-grow:1}.main-script-view .card .error[data-v-05227e49]{position:absolute;bottom:20px;left:50%;transform:translateX(-50%);box-shadow:0px 0px 10px rgba(0,0,0,.3);padding:10px 12px;border-radius:10px;background-color:#3d3d3d;display:flex;align-items:center}.main-script-view .card .error div[data-v-05227e49]:first-child{color:#ff5252;font-weight:normal;font-size:14px;flex-shrink:1;white-space:pre-wrap}.main-script-view .card .error div[data-v-05227e49]:last-child{height:26px;width:26px;padding:3px;flex-shrink:0}.main-script-view .card .error div[data-v-05227e49]:last-child:hover{background-color:rgba(160,160,160,.534);border-radius:3px}.main-script-view .card .btns[data-v-05227e49]{position:absolute;bottom:0px;right:0px;display:flex;z-index:100;color:#fff;margin-right:35px;margin-bottom:10px;font-size:14px}.main-script-view .card .btns div[data-v-05227e49]{margin-left:10px;width:30px;height:30px;text-align:center;border-radius:3px;box-shadow:0px 0px 10px rgba(0,0,0,.2)}.main-script-view .card .btns div svg[data-v-05227e49]{width:24px;height:24px;margin:3px;fill:#fff}.main-script-view .card .btns .abort-btn[data-v-05227e49]{margin-bottom:10px;background-color:#ea4079}.main-script-view .card .btns .save-btn[data-v-05227e49]{background-color:#41b883}", ""]);
                const a = r
            },
            62608: (e, t, i) => {
                "use strict";
                i.r(t), i.d(t, {
                    default: () => a
                });
                var n = i(8081),
                    o = i.n(n),
                    s = i(23645),
                    r = i.n(s)()(o());
                r.push([e.id, ".main-select-view-plugin[data-v-0826c2c0]{width:100%;height:calc(100% - 25px);position:fixed;top:25px;display:flex;flex-direction:column;align-items:center;justify-content:center;color:#000;z-index:10}.main-select-view-plugin .card-main[data-v-0826c2c0]{border-radius:2px;display:flex;flex-direction:column;justify-content:space-around;width:50%}.main-select-view-plugin .card-main .card-content[data-v-0826c2c0]{padding:15px 20px}.main-select-view-plugin .card-main .card-content .content-title[data-v-0826c2c0]{font-size:1.2em;margin-bottom:10px}.main-select-view-plugin .card-main .card-content .content-message[data-v-0826c2c0]{margin:5px 0 10px 0;max-height:60vh;overflow-x:hidden;word-break:break-word;overflow-y:auto}.main-select-view-plugin .card-main .card-content .content-message[data-v-0826c2c0]::-webkit-scrollbar{width:16px}.main-select-view-plugin .card-main .card-content .content-message[data-v-0826c2c0]::-webkit-scrollbar-thumb{background-color:#cac8c6;border-radius:100px;border:3px solid var(--bgc)}.main-select-view-plugin .card-main .card-content .content-message[data-v-0826c2c0]::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-select-view-plugin .card-main .card-content .check-list[data-v-0826c2c0]{display:flex;flex-direction:column;margin:5px 0 10px 0}.main-select-view-plugin .card-main .card-content .check-list .check-item[data-v-0826c2c0]{display:flex;align-items:center}.main-select-view-plugin .card-main .card-content .check-list .check-item .check-text[data-v-0826c2c0]{margin-left:5px}.main-select-view-plugin .card-main .card-content .btns[data-v-0826c2c0]{display:flex;justify-content:flex-start;flex-wrap:wrap}.main-select-view-plugin .card-main .card-content .btns .btn[data-v-0826c2c0]{border-radius:3px;text-align:center;height:35px;line-height:35px;flex-shrink:1;color:#fff;background-color:#3e3c4d;border-radius:5px;cursor:pointer;margin:5px 5px 5px 5px}.main-select-view-plugin .card-main .card-content .btns .btn *[data-v-0826c2c0]:hover{cursor:pointer}.main-select-view-plugin .card-main .card-content .btns .btn span[data-v-0826c2c0]{padding:0 10px}.main-select-view-plugin .card-main .card-content .btns .last-btn[data-v-0826c2c0]{background-color:#727070}.main-select-view-plugin .html-list[data-v-0826c2c0]{margin-bottom:12px}.main-select-view-plugin .html-list[data-v-0826c2c0] ul{max-height:60vh;overflow-y:auto;list-style-position:inside;list-style-type:disc}.main-select-view-plugin .html-list[data-v-0826c2c0] ul::-webkit-scrollbar{width:16px}.main-select-view-plugin .html-list[data-v-0826c2c0] ul::-webkit-scrollbar-thumb{background-color:#cac8c6;border-radius:100px;border:3px solid var(--bgc)}.main-select-view-plugin .html-list[data-v-0826c2c0] ul::-webkit-scrollbar-corner{background-color:var(--bgc)}.main-select-view-plugin .html-list[data-v-0826c2c0] ul code{background-color:var(--general-item-bgc);border-radius:3px;padding:0 4px;font-family:inherit}.main-select-view-plugin .html-list[data-v-0826c2c0] a{cursor:pointer;color:var(--feedback-link-c)}", ""]);
                const a = r
            },
            23645: e => {
                "use strict";
                e.exports = function(e) {
                    var t = [];
                    return t.toString = function() {
                        return this.map((function(t) {
                            var i = "",
                                n = void 0 !== t[5];
                            return t[4] && (i += "@supports (".concat(t[4], ") {")), t[2] && (i += "@media ".concat(t[2], " {")), n && (i += "@layer".concat(t[5].length > 0 ? " ".concat(t[5]) : "", " {")), i += e(t), n && (i += "}"), t[2] && (i += "}"), t[4] && (i += "}"), i
                        })).join("")
                    }, t.i = function(e, i, n, o, s) {
                        "string" == typeof e && (e = [
                            [null, e, void 0]
                        ]);
                        var r = {};
                        if (n)
                            for (var a = 0; a < this.length; a++) {
                                var l = this[a][0];
                                null != l && (r[l] = !0)
                            }
                        for (var c = 0; c < e.length; c++) {
                            var d = [].concat(e[c]);
                            n && r[d[0]] || (void 0 !== s && (void 0 === d[5] || (d[1] = "@layer".concat(d[5].length > 0 ? " ".concat(d[5]) : "", " {").concat(d[1], "}")), d[5] = s), i && (d[2] ? (d[1] = "@media ".concat(d[2], " {").concat(d[1], "}"), d[2] = i) : d[2] = i), o && (d[4] ? (d[1] = "@supports (".concat(d[4], ") {").concat(d[1], "}"), d[4] = o) : d[4] = "".concat(o)), t.push(d))
                        }
                    }, t
                }
            },
            61667: e => {
                "use strict";
                e.exports = function(e, t) {
                    return t || (t = {}), e ? (e = String(e.__esModule ? e.default : e), /^['"].*['"]$/.test(e) && (e = e.slice(1, -1)), t.hash && (e += t.hash), /["'() \t\n]|(%20)/.test(e) || t.needQuotes ? '"'.concat(e.replace(/"/g, '\\"').replace(/\n/g, "\\n"), '"') : e) : e
                }
            },
            8081: e => {
                "use strict";
                e.exports = function(e) {
                    return e[1]
                }
            },
            58583: (e, t, i) => {
                var n;
                self.MonacoEnvironment = (n = {
                    editorWorkerService: "editor.worker.js"
                }, {
                    globalAPI: !1,
                    getWorkerUrl: function(e, t) {
                        var o = i.p,
                            s = (o ? o.replace(/\/$/, "") + "/" : "") + n[t];
                        if (/^((http:)|(https:)|(file:)|(\/\/))/.test(s)) {
                            var r = String(window.location),
                                a = r.substr(0, r.length - window.location.hash.length - window.location.search.length - window.location.pathname.length);
                            if (s.substring(0, a.length) !== a) {
                                /^(\/\/)/.test(s) && (s = window.location.protocol + s);
                                var l = new Blob(["/*" + t + '*/importScripts("' + s + '");'], {
                                    type: "application/javascript"
                                });
                                return URL.createObjectURL(l)
                            }
                        }
                        return s
                    }
                }), i(29477), i(17355), i(17084), i(84594), i(62015), i(9093), i(53832), i(77956), i(89098), i(76522), i(18728), i(42834), i(7441), i(81372), i(92142), i(62943), i(23111), i(44818), i(42698), i(62097), i(92729), i(10365), i(67247), i(19646), i(83554), i(80638), i(87586), i(43818), i(97830), i(42408), i(80674), i(34800), i(38486), i(40517), i(97720), i(78944), i(98936), i(45048), i(4454), i(81955), i(93379), i(88250), i(15662), i(19720), i(77847), i(31725), i(70185), i(43497), i(99453), i(60661), e.exports = i(86211), i(94199), i(43763), i(83187)
            },
            16268: (e, t, i) => {
                "use strict";
                i.d(t, {
                    $W: () => v,
                    Dt: () => m,
                    G6: () => p,
                    MG: () => f,
                    Pf: () => u,
                    WP: () => r,
                    fX: () => a,
                    i7: () => g,
                    ie: () => l,
                    mX: () => c,
                    px: () => s,
                    vU: () => h
                });
                var n = i(4669);
                class o {
                    constructor() {
                        this._zoomLevel = 0, this._lastZoomLevelChangeTime = 0, this._onDidChangeZoomLevel = new n.Q5, this.onDidChangeZoomLevel = this._onDidChangeZoomLevel.event, this._zoomFactor = 1
                    }
                    getZoomLevel() {
                        return this._zoomLevel
                    }
                    getTimeSinceLastZoomLevelChanged() {
                        return Date.now() - this._lastZoomLevelChangeTime
                    }
                    getZoomFactor() {
                        return this._zoomFactor
                    }
                    getPixelRatio() {
                        let e = document.createElement("canvas").getContext("2d");
                        return (window.devicePixelRatio || 1) / (e.webkitBackingStorePixelRatio || e.mozBackingStorePixelRatio || e.msBackingStorePixelRatio || e.oBackingStorePixelRatio || e.backingStorePixelRatio || 1)
                    }
                }

                function s() {
                    return o.INSTANCE.getZoomLevel()
                }

                function r() {
                    return o.INSTANCE.getTimeSinceLastZoomLevelChanged()
                }

                function a(e) {
                    return o.INSTANCE.onDidChangeZoomLevel(e)
                }

                function l() {
                    return o.INSTANCE.getZoomFactor()
                }

                function c() {
                    return o.INSTANCE.getPixelRatio()
                }
                o.INSTANCE = new o;
                const d = navigator.userAgent,
                    h = d.indexOf("Firefox") >= 0,
                    u = d.indexOf("AppleWebKit") >= 0,
                    g = d.indexOf("Chrome") >= 0,
                    p = !g && d.indexOf("Safari") >= 0,
                    f = !g && !p && u,
                    m = d.indexOf("Android") >= 0,
                    v = window.matchMedia && window.matchMedia("(display-mode: standalone)").matches
            },
            10161: (e, t, i) => {
                "use strict";
                i.d(t, {
                    D: () => s
                });
                var n = i(16268),
                    o = i(1432);
                const s = {
                    clipboard: {
                        writeText: o.tY || document.queryCommandSupported && document.queryCommandSupported("copy") || !!(navigator && navigator.clipboard && navigator.clipboard.writeText),
                        readText: o.tY || !!(navigator && navigator.clipboard && navigator.clipboard.readText)
                    },
                    keyboard: o.tY || n.$W ? 0 : navigator.keyboard || n.G6 ? 1 : 2,
                    touch: "ontouchstart" in window || navigator.maxTouchPoints > 0,
                    pointerEvents: window.PointerEvent && ("ontouchstart" in window || window.navigator.maxTouchPoints > 0 || navigator.maxTouchPoints > 0)
                }
            },
            23547: (e, t, i) => {
                "use strict";
                i.d(t, {
                    P$: () => s,
                    TN: () => o,
                    go: () => n
                });
                const n = {
                    RESOURCES: "ResourceURLs",
                    DOWNLOAD_URL: "DownloadURL",
                    FILES: "Files",
                    TEXT: i(81170).vW.text,
                    TERMINALS: "Terminals"
                };
                class o {
                    constructor(e) {
                        this.data = e
                    }
                    update() {}
                    getData() {
                        return this.data
                    }
                }
                const s = {
                    CurrentDragAndDropData: void 0
                }
            },
            65321: (e, t, i) => {
                "use strict";
                i.d(t, {
                    $: () => pe,
                    $Z: () => fe,
                    Ay: () => Z,
                    Ce: () => ce,
                    Cp: () => me,
                    D6: () => M,
                    DI: () => B,
                    Dx: () => T,
                    FK: () => W,
                    Fx: () => U,
                    Gw: () => b,
                    H$: () => ve,
                    If: () => H,
                    Lo: () => w,
                    OO: () => q,
                    PO: () => g,
                    R3: () => le,
                    RE: () => x,
                    Re: () => te,
                    Ro: () => O,
                    Uh: () => _e,
                    Uw: () => p,
                    V3: () => be,
                    Y_: () => E,
                    _0: () => se,
                    _h: () => Ce,
                    _q: () => xe,
                    dS: () => Y,
                    dp: () => R,
                    fk: () => J,
                    go: () => ae,
                    i: () => F,
                    jL: () => k,
                    j_: () => C,
                    jg: () => j,
                    jt: () => we,
                    lI: () => S,
                    mc: () => de,
                    mu: () => _,
                    nm: () => m,
                    qV: () => y,
                    tw: () => ie,
                    uB: () => Se,
                    uN: () => ee,
                    uU: () => $,
                    vL: () => oe,
                    vY: () => G,
                    w: () => V,
                    wY: () => ye,
                    wn: () => z,
                    xQ: () => P,
                    zB: () => ne
                });
                var n = i(16268),
                    o = i(10161),
                    s = i(59069),
                    r = i(23938),
                    a = i(15393),
                    l = i(17301),
                    c = i(4669),
                    d = i(5976),
                    h = i(66663),
                    u = i(1432);

                function g(e) {
                    for (; e.firstChild;) e.firstChild.remove()
                }

                function p(e) {
                    var t;
                    return null !== (t = null == e ? void 0 : e.isConnected) && void 0 !== t && t
                }
                class f {
                    constructor(e, t, i, n) {
                        this._node = e, this._type = t, this._handler = i, this._options = n || !1, this._node.addEventListener(this._type, this._handler, this._options)
                    }
                    dispose() {
                        this._handler && (this._node.removeEventListener(this._type, this._handler, this._options), this._node = null, this._handler = null)
                    }
                }

                function m(e, t, i, n) {
                    return new f(e, t, i, n)
                }

                function v(e) {
                    return function(t) {
                        return e(new r.n(t))
                    }
                }
                let _ = function(e, t, i, n) {
                        let o = i;
                        return "click" === t || "mousedown" === t ? o = v(i) : "keydown" !== t && "keypress" !== t && "keyup" !== t || (o = function(e) {
                            return function(t) {
                                return e(new s.y(t))
                            }
                        }(i)), m(e, t, o, n)
                    },
                    b = function(e, t, i) {
                        return w(e, v(t), i)
                    };

                function w(e, t, i) {
                    return m(e, u.gn && o.D.pointerEvents ? ie.POINTER_DOWN : ie.MOUSE_DOWN, t, i)
                }

                function y(e, t, i) {
                    return m(e, u.gn && o.D.pointerEvents ? ie.POINTER_UP : ie.MOUSE_UP, t, i)
                }

                function C(e, t) {
                    return m(e, "mouseout", (i => {
                        let n = i.relatedTarget;
                        for (; n && n !== e;) n = n.parentNode;
                        n !== e && t(i)
                    }))
                }

                function x(e, t) {
                    return m(e, "pointerout", (i => {
                        let n = i.relatedTarget;
                        for (; n && n !== e;) n = n.parentNode;
                        n !== e && t(i)
                    }))
                }
                let S, k, L = null;
                class N {
                    constructor(e, t = 0) {
                        this._runner = e, this.priority = t, this._canceled = !1
                    }
                    dispose() {
                        this._canceled = !0
                    }
                    execute() {
                        if (!this._canceled) try {
                            this._runner()
                        } catch (e) {
                            (0, l.dL)(e)
                        }
                    }
                    static sort(e, t) {
                        return t.priority - e.priority
                    }
                }! function() {
                    let e = [],
                        t = null,
                        i = !1,
                        n = !1,
                        o = () => {
                            for (i = !1, t = e, e = [], n = !0; t.length > 0;) {
                                t.sort(N.sort), t.shift().execute()
                            }
                            n = !1
                        };
                    k = (t, n = 0) => {
                        let s = new N(t, n);
                        return e.push(s), i || (i = !0, function(e) {
                            if (!L) {
                                const e = e => setTimeout((() => e((new Date).getTime())), 0);
                                L = self.requestAnimationFrame || self.msRequestAnimationFrame || self.webkitRequestAnimationFrame || self.mozRequestAnimationFrame || self.oRequestAnimationFrame || e
                            }
                            L.call(self, e)
                        }(o)), s
                    }, S = (e, i) => {
                        if (n) {
                            let n = new N(e, i);
                            return t.push(n), n
                        }
                        return k(e, i)
                    }
                }();
                const D = function(e, t) {
                    return t
                };
                class I extends d.JT {
                    constructor(e, t, i, n = D, o = 8) {
                        super();
                        let s = null,
                            r = 0,
                            l = this._register(new a._F),
                            c = () => {
                                r = (new Date).getTime(), i(s), s = null
                            };
                        this._register(m(e, t, (e => {
                            s = n(s, e);
                            let t = (new Date).getTime() - r;
                            t >= o ? (l.cancel(), c()) : l.setIfNotSet(c, o - t)
                        })))
                    }
                }

                function E(e, t, i, n, o) {
                    return new I(e, t, i, n, o)
                }

                function T(e) {
                    return document.defaultView.getComputedStyle(e, null)
                }

                function M(e) {
                    if (e !== document.body) return new O(e.clientWidth, e.clientHeight);
                    if (u.gn && window.visualViewport) return new O(window.visualViewport.width, window.visualViewport.height);
                    if (window.innerWidth && window.innerHeight) return new O(window.innerWidth, window.innerHeight);
                    if (document.body && document.body.clientWidth && document.body.clientHeight) return new O(document.body.clientWidth, document.body.clientHeight);
                    if (document.documentElement && document.documentElement.clientWidth && document.documentElement.clientHeight) return new O(document.documentElement.clientWidth, document.documentElement.clientHeight);
                    throw new Error("Unable to figure out browser width and height")
                }
                class A {
                    static convertToPixels(e, t) {
                        return parseFloat(t) || 0
                    }
                    static getDimension(e, t, i) {
                        let n = T(e),
                            o = "0";
                        return n && (o = n.getPropertyValue ? n.getPropertyValue(t) : n.getAttribute(i)), A.convertToPixels(e, o)
                    }
                    static getBorderLeftWidth(e) {
                        return A.getDimension(e, "border-left-width", "borderLeftWidth")
                    }
                    static getBorderRightWidth(e) {
                        return A.getDimension(e, "border-right-width", "borderRightWidth")
                    }
                    static getBorderTopWidth(e) {
                        return A.getDimension(e, "border-top-width", "borderTopWidth")
                    }
                    static getBorderBottomWidth(e) {
                        return A.getDimension(e, "border-bottom-width", "borderBottomWidth")
                    }
                    static getPaddingLeft(e) {
                        return A.getDimension(e, "padding-left", "paddingLeft")
                    }
                    static getPaddingRight(e) {
                        return A.getDimension(e, "padding-right", "paddingRight")
                    }
                    static getPaddingTop(e) {
                        return A.getDimension(e, "padding-top", "paddingTop")
                    }
                    static getPaddingBottom(e) {
                        return A.getDimension(e, "padding-bottom", "paddingBottom")
                    }
                    static getMarginLeft(e) {
                        return A.getDimension(e, "margin-left", "marginLeft")
                    }
                    static getMarginTop(e) {
                        return A.getDimension(e, "margin-top", "marginTop")
                    }
                    static getMarginRight(e) {
                        return A.getDimension(e, "margin-right", "marginRight")
                    }
                    static getMarginBottom(e) {
                        return A.getDimension(e, "margin-bottom", "marginBottom")
                    }
                }
                class O {
                    constructor(e, t) {
                        this.width = e, this.height = t
                    }
                    with(e = this.width, t = this.height) {
                        return e !== this.width || t !== this.height ? new O(e, t) : this
                    }
                    static is(e) {
                        return "object" == typeof e && "number" == typeof e.height && "number" == typeof e.width
                    }
                    static lift(e) {
                        return e instanceof O ? e : new O(e.width, e.height)
                    }
                    static equals(e, t) {
                        return e === t || !(!e || !t) && (e.width === t.width && e.height === t.height)
                    }
                }

                function P(e) {
                    let t = e.offsetParent,
                        i = e.offsetTop,
                        n = e.offsetLeft;
                    for (; null !== (e = e.parentNode) && e !== document.body && e !== document.documentElement;) {
                        i -= e.scrollTop;
                        const o = K(e) ? null : T(e);
                        o && (n -= "rtl" !== o.direction ? e.scrollLeft : -e.scrollLeft), e === t && (n += A.getBorderLeftWidth(e), i += A.getBorderTopWidth(e), i += e.offsetTop, n += e.offsetLeft, t = e.offsetParent)
                    }
                    return {
                        left: n,
                        top: i
                    }
                }

                function R(e, t, i) {
                    "number" == typeof t && (e.style.width = `${t}px`), "number" == typeof i && (e.style.height = `${i}px`)
                }

                function F(e) {
                    let t = e.getBoundingClientRect();
                    return {
                        left: t.left + B.scrollX,
                        top: t.top + B.scrollY,
                        width: t.width,
                        height: t.height
                    }
                }
                const B = new class {
                    get scrollX() {
                        return "number" == typeof window.scrollX ? window.scrollX : document.body.scrollLeft + document.documentElement.scrollLeft
                    }
                    get scrollY() {
                        return "number" == typeof window.scrollY ? window.scrollY : document.body.scrollTop + document.documentElement.scrollTop
                    }
                };

                function V(e) {
                    let t = A.getMarginLeft(e) + A.getMarginRight(e);
                    return e.offsetWidth + t
                }

                function W(e) {
                    let t = A.getBorderLeftWidth(e) + A.getBorderRightWidth(e),
                        i = A.getPaddingLeft(e) + A.getPaddingRight(e);
                    return e.offsetWidth - t - i
                }

                function H(e) {
                    let t = A.getBorderTopWidth(e) + A.getBorderBottomWidth(e),
                        i = A.getPaddingTop(e) + A.getPaddingBottom(e);
                    return e.offsetHeight - t - i
                }

                function z(e) {
                    let t = A.getMarginTop(e) + A.getMarginBottom(e);
                    return e.offsetHeight + t
                }

                function j(e, t) {
                    for (; e;) {
                        if (e === t) return !0;
                        e = e.parentNode
                    }
                    return !1
                }

                function U(e, t, i) {
                    for (; e && e.nodeType === e.ELEMENT_NODE;) {
                        if (e.classList.contains(t)) return e;
                        if (i)
                            if ("string" == typeof i) {
                                if (e.classList.contains(i)) return null
                            } else if (e === i) return null;
                        e = e.parentNode
                    }
                    return null
                }

                function $(e, t, i) {
                    return !!U(e, t, i)
                }

                function K(e) {
                    return e && !!e.host && !!e.mode
                }

                function q(e) {
                    return !!Z(e)
                }

                function Z(e) {
                    for (; e.parentNode;) {
                        if (e === document.body) return null;
                        e = e.parentNode
                    }
                    return K(e) ? e : null
                }

                function G() {
                    let e = document.activeElement;
                    for (; null == e ? void 0 : e.shadowRoot;) e = e.shadowRoot.activeElement;
                    return e
                }

                function Y(e = document.getElementsByTagName("head")[0]) {
                    let t = document.createElement("style");
                    return t.type = "text/css", t.media = "screen", e.appendChild(t), t
                }
                let Q = null;

                function X() {
                    return Q || (Q = Y()), Q
                }

                function J(e, t, i = X()) {
                    i && t && i.sheet.insertRule(e + "{" + t + "}", 0)
                }

                function ee(e, t = X()) {
                    if (!t) return;
                    let i = function(e) {
                            var t, i;
                            return (null === (t = null == e ? void 0 : e.sheet) || void 0 === t ? void 0 : t.rules) ? e.sheet.rules : (null === (i = null == e ? void 0 : e.sheet) || void 0 === i ? void 0 : i.cssRules) ? e.sheet.cssRules : []
                        }(t),
                        n = [];
                    for (let t = 0; t < i.length; t++) {
                        -1 !== i[t].selectorText.indexOf(e) && n.push(t)
                    }
                    for (let e = n.length - 1; e >= 0; e--) t.sheet.deleteRule(n[e])
                }

                function te(e) {
                    return "object" == typeof HTMLElement ? e instanceof HTMLElement : e && "object" == typeof e && 1 === e.nodeType && "string" == typeof e.nodeName
                }
                const ie = {
                        CLICK: "click",
                        AUXCLICK: "auxclick",
                        DBLCLICK: "dblclick",
                        MOUSE_UP: "mouseup",
                        MOUSE_DOWN: "mousedown",
                        MOUSE_OVER: "mouseover",
                        MOUSE_MOVE: "mousemove",
                        MOUSE_OUT: "mouseout",
                        MOUSE_ENTER: "mouseenter",
                        MOUSE_LEAVE: "mouseleave",
                        MOUSE_WHEEL: "wheel",
                        POINTER_UP: "pointerup",
                        POINTER_DOWN: "pointerdown",
                        POINTER_MOVE: "pointermove",
                        CONTEXT_MENU: "contextmenu",
                        WHEEL: "wheel",
                        KEY_DOWN: "keydown",
                        KEY_PRESS: "keypress",
                        KEY_UP: "keyup",
                        LOAD: "load",
                        BEFORE_UNLOAD: "beforeunload",
                        UNLOAD: "unload",
                        ABORT: "abort",
                        ERROR: "error",
                        RESIZE: "resize",
                        SCROLL: "scroll",
                        FULLSCREEN_CHANGE: "fullscreenchange",
                        WK_FULLSCREEN_CHANGE: "webkitfullscreenchange",
                        SELECT: "select",
                        CHANGE: "change",
                        SUBMIT: "submit",
                        RESET: "reset",
                        FOCUS: "focus",
                        FOCUS_IN: "focusin",
                        FOCUS_OUT: "focusout",
                        BLUR: "blur",
                        INPUT: "input",
                        STORAGE: "storage",
                        DRAG_START: "dragstart",
                        DRAG: "drag",
                        DRAG_ENTER: "dragenter",
                        DRAG_LEAVE: "dragleave",
                        DRAG_OVER: "dragover",
                        DROP: "drop",
                        DRAG_END: "dragend",
                        ANIMATION_START: n.Pf ? "webkitAnimationStart" : "animationstart",
                        ANIMATION_END: n.Pf ? "webkitAnimationEnd" : "animationend",
                        ANIMATION_ITERATION: n.Pf ? "webkitAnimationIteration" : "animationiteration"
                    },
                    ne = {
                        stop: function(e, t) {
                            e.preventDefault ? e.preventDefault() : e.returnValue = !1, t && (e.stopPropagation ? e.stopPropagation() : e.cancelBubble = !0)
                        }
                    };

                function oe(e) {
                    let t = [];
                    for (let i = 0; e && e.nodeType === e.ELEMENT_NODE; i++) t[i] = e.scrollTop, e = e.parentNode;
                    return t
                }

                function se(e, t) {
                    for (let i = 0; e && e.nodeType === e.ELEMENT_NODE; i++) e.scrollTop !== t[i] && (e.scrollTop = t[i]), e = e.parentNode
                }
                class re extends d.JT {
                    constructor(e) {
                        super(), this._onDidFocus = this._register(new c.Q5), this.onDidFocus = this._onDidFocus.event, this._onDidBlur = this._register(new c.Q5), this.onDidBlur = this._onDidBlur.event;
                        let t = j(document.activeElement, e),
                            i = !1;
                        const n = () => {
                                i = !1, t || (t = !0, this._onDidFocus.fire())
                            },
                            o = () => {
                                t && (i = !0, window.setTimeout((() => {
                                    i && (i = !1, t = !1, this._onDidBlur.fire())
                                }), 0))
                            };
                        this._refreshStateHandler = () => {
                            j(document.activeElement, e) !== t && (t ? o() : n())
                        }, this._register(m(e, ie.FOCUS, n, !0)), this._register(m(e, ie.BLUR, o, !0))
                    }
                }

                function ae(e) {
                    return new re(e)
                }

                function le(e, ...t) {
                    if (e.append(...t), 1 === t.length && "string" != typeof t[0]) return t[0]
                }

                function ce(e, t) {
                    return e.insertBefore(t, e.firstChild), t
                }

                function de(e, ...t) {
                    e.innerText = "", le(e, ...t)
                }
                const he = /([\w\-]+)?(#([\w\-]+))?((\.([\w\-]+))*)/;
                var ue;

                function ge(e, t, i, ...n) {
                    let o = he.exec(t);
                    if (!o) throw new Error("Bad use of emmet");
                    i = Object.assign({}, i || {});
                    let s, r = o[1] || "div";
                    return s = e !== ue.HTML ? document.createElementNS(e, r) : document.createElement(r), o[3] && (s.id = o[3]), o[4] && (s.className = o[4].replace(/\./g, " ").trim()), Object.keys(i).forEach((e => {
                        const t = i[e];
                        void 0 !== t && (/^on\w+$/.test(e) ? s[e] = t : "selected" === e ? t && s.setAttribute(e, "true") : s.setAttribute(e, t))
                    })), s.append(...n), s
                }

                function pe(e, t, ...i) {
                    return ge(ue.HTML, e, t, ...i)
                }

                function fe(...e) {
                    for (let t of e) t.style.display = "", t.removeAttribute("aria-hidden")
                }

                function me(...e) {
                    for (let t of e) t.style.display = "none", t.setAttribute("aria-hidden", "true")
                }

                function ve(e) {
                    return Array.prototype.slice.call(document.getElementsByTagName(e), 0)
                }

                function _e(e) {
                    const t = window.devicePixelRatio * e;
                    return Math.max(1, Math.floor(t)) / window.devicePixelRatio
                }

                function be(e) {
                    window.open(e, "_blank", "noopener")
                }

                function we(e) {
                    const t = () => {
                        e(), i = k(t)
                    };
                    let i = k(t);
                    return (0, d.OF)((() => i.dispose()))
                }

                function ye(e) {
                    return e ? `url('${h.Gi.asBrowserUri(e).toString(!0).replace(/'/g,"%27")}')` : "url('')"
                }

                function Ce(e) {
                    return `'${e.replace(/'/g,"%27")}'`
                }! function(e) {
                    e.HTML = "https://www.w3.org/1999/xhtml", e.SVG = "https://www.w3.org/2000/svg"
                }(ue || (ue = {})), pe.SVG = function(e, t, ...i) {
                    return ge(ue.SVG, e, t, ...i)
                }, h.WX.setPreferredWebSchema(/^https:/.test(window.location.href) ? "https" : "http");
                class xe extends c.Q5 {
                    constructor() {
                        super(), this._subscriptions = new d.SL, this._keyStatus = {
                            altKey: !1,
                            shiftKey: !1,
                            ctrlKey: !1,
                            metaKey: !1
                        }, this._subscriptions.add(m(window, "keydown", (e => {
                            if (e.defaultPrevented) return;
                            const t = new s.y(e);
                            if (6 !== t.keyCode || !e.repeat) {
                                if (e.altKey && !this._keyStatus.altKey) this._keyStatus.lastKeyPressed = "alt";
                                else if (e.ctrlKey && !this._keyStatus.ctrlKey) this._keyStatus.lastKeyPressed = "ctrl";
                                else if (e.metaKey && !this._keyStatus.metaKey) this._keyStatus.lastKeyPressed = "meta";
                                else if (e.shiftKey && !this._keyStatus.shiftKey) this._keyStatus.lastKeyPressed = "shift";
                                else {
                                    if (6 === t.keyCode) return;
                                    this._keyStatus.lastKeyPressed = void 0
                                }
                                this._keyStatus.altKey = e.altKey, this._keyStatus.ctrlKey = e.ctrlKey, this._keyStatus.metaKey = e.metaKey, this._keyStatus.shiftKey = e.shiftKey, this._keyStatus.lastKeyPressed && (this._keyStatus.event = e, this.fire(this._keyStatus))
                            }
                        }), !0)), this._subscriptions.add(m(window, "keyup", (e => {
                            e.defaultPrevented || (!e.altKey && this._keyStatus.altKey ? this._keyStatus.lastKeyReleased = "alt" : !e.ctrlKey && this._keyStatus.ctrlKey ? this._keyStatus.lastKeyReleased = "ctrl" : !e.metaKey && this._keyStatus.metaKey ? this._keyStatus.lastKeyReleased = "meta" : !e.shiftKey && this._keyStatus.shiftKey ? this._keyStatus.lastKeyReleased = "shift" : this._keyStatus.lastKeyReleased = void 0, this._keyStatus.lastKeyPressed !== this._keyStatus.lastKeyReleased && (this._keyStatus.lastKeyPressed = void 0), this._keyStatus.altKey = e.altKey, this._keyStatus.ctrlKey = e.ctrlKey, this._keyStatus.metaKey = e.metaKey, this._keyStatus.shiftKey = e.shiftKey, this._keyStatus.lastKeyReleased && (this._keyStatus.event = e, this.fire(this._keyStatus)))
                        }), !0)), this._subscriptions.add(m(document.body, "mousedown", (() => {
                            this._keyStatus.lastKeyPressed = void 0
                        }), !0)), this._subscriptions.add(m(document.body, "mouseup", (() => {
                            this._keyStatus.lastKeyPressed = void 0
                        }), !0)), this._subscriptions.add(m(document.body, "mousemove", (e => {
                            e.buttons && (this._keyStatus.lastKeyPressed = void 0)
                        }), !0)), this._subscriptions.add(m(window, "blur", (() => {
                            this.resetKeyStatus()
                        })))
                    }
                    get keyStatus() {
                        return this._keyStatus
                    }
                    resetKeyStatus() {
                        this.doResetKeyStatus(), this.fire(this._keyStatus)
                    }
                    doResetKeyStatus() {
                        this._keyStatus = {
                            altKey: !1,
                            shiftKey: !1,
                            ctrlKey: !1,
                            metaKey: !1
                        }
                    }
                    static getInstance() {
                        return xe.instance || (xe.instance = new xe), xe.instance
                    }
                    dispose() {
                        super.dispose(), this._subscriptions.dispose()
                    }
                }

                function Se(e, t) {
                    const i = window.matchMedia(e);
                    "function" == typeof i.addEventListener ? i.addEventListener("change", t) : i.addListener(t)
                }
            },
            4850: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Y: () => o,
                    p: () => s
                });
                var n = i(4669);
                class o {
                    constructor(e, t, i) {
                        const o = e => this.emitter.fire(e);
                        this.emitter = new n.Q5({
                            onFirstListenerAdd: () => e.addEventListener(t, o, i),
                            onLastListenerRemove: () => e.removeEventListener(t, o, i)
                        })
                    }
                    get event() {
                        return this.emitter.event
                    }
                    dispose() {
                        this.emitter.dispose()
                    }
                }

                function s(e) {
                    return e.preventDefault(), e.stopPropagation(), e
                }
            },
            38626: (e, t, i) => {
                "use strict";
                i.d(t, {
                    X: () => o,
                    Z: () => n
                });
                class n {
                    constructor(e) {
                        this.domNode = e, this._maxWidth = -1, this._width = -1, this._height = -1, this._top = -1, this._left = -1, this._bottom = -1, this._right = -1, this._fontFamily = "", this._fontWeight = "", this._fontSize = -1, this._fontFeatureSettings = "", this._lineHeight = -1, this._letterSpacing = -100, this._className = "", this._display = "", this._position = "", this._visibility = "", this._backgroundColor = "", this._layerHint = !1, this._contain = "none", this._boxShadow = ""
                    }
                    setMaxWidth(e) {
                        this._maxWidth !== e && (this._maxWidth = e, this.domNode.style.maxWidth = this._maxWidth + "px")
                    }
                    setWidth(e) {
                        this._width !== e && (this._width = e, this.domNode.style.width = this._width + "px")
                    }
                    setHeight(e) {
                        this._height !== e && (this._height = e, this.domNode.style.height = this._height + "px")
                    }
                    setTop(e) {
                        this._top !== e && (this._top = e, this.domNode.style.top = this._top + "px")
                    }
                    unsetTop() {
                        -1 !== this._top && (this._top = -1, this.domNode.style.top = "")
                    }
                    setLeft(e) {
                        this._left !== e && (this._left = e, this.domNode.style.left = this._left + "px")
                    }
                    setBottom(e) {
                        this._bottom !== e && (this._bottom = e, this.domNode.style.bottom = this._bottom + "px")
                    }
                    setRight(e) {
                        this._right !== e && (this._right = e, this.domNode.style.right = this._right + "px")
                    }
                    setFontFamily(e) {
                        this._fontFamily !== e && (this._fontFamily = e, this.domNode.style.fontFamily = this._fontFamily)
                    }
                    setFontWeight(e) {
                        this._fontWeight !== e && (this._fontWeight = e, this.domNode.style.fontWeight = this._fontWeight)
                    }
                    setFontSize(e) {
                        this._fontSize !== e && (this._fontSize = e, this.domNode.style.fontSize = this._fontSize + "px")
                    }
                    setFontFeatureSettings(e) {
                        this._fontFeatureSettings !== e && (this._fontFeatureSettings = e, this.domNode.style.fontFeatureSettings = this._fontFeatureSettings)
                    }
                    setLineHeight(e) {
                        this._lineHeight !== e && (this._lineHeight = e, this.domNode.style.lineHeight = this._lineHeight + "px")
                    }
                    setLetterSpacing(e) {
                        this._letterSpacing !== e && (this._letterSpacing = e, this.domNode.style.letterSpacing = this._letterSpacing + "px")
                    }
                    setClassName(e) {
                        this._className !== e && (this._className = e, this.domNode.className = this._className)
                    }
                    toggleClassName(e, t) {
                        this.domNode.classList.toggle(e, t), this._className = this.domNode.className
                    }
                    setDisplay(e) {
                        this._display !== e && (this._display = e, this.domNode.style.display = this._display)
                    }
                    setPosition(e) {
                        this._position !== e && (this._position = e, this.domNode.style.position = this._position)
                    }
                    setVisibility(e) {
                        this._visibility !== e && (this._visibility = e, this.domNode.style.visibility = this._visibility)
                    }
                    setBackgroundColor(e) {
                        this._backgroundColor !== e && (this._backgroundColor = e, this.domNode.style.backgroundColor = this._backgroundColor)
                    }
                    setLayerHinting(e) {
                        this._layerHint !== e && (this._layerHint = e, this.domNode.style.transform = this._layerHint ? "translate3d(0px, 0px, 0px)" : "")
                    }
                    setBoxShadow(e) {
                        this._boxShadow !== e && (this._boxShadow = e, this.domNode.style.boxShadow = e)
                    }
                    setContain(e) {
                        this._contain !== e && (this._contain = e, this.domNode.style.contain = this._contain)
                    }
                    setAttribute(e, t) {
                        this.domNode.setAttribute(e, t)
                    }
                    removeAttribute(e) {
                        this.domNode.removeAttribute(e)
                    }
                    appendChild(e) {
                        this.domNode.appendChild(e.domNode)
                    }
                    removeChild(e) {
                        this.domNode.removeChild(e.domNode)
                    }
                }

                function o(e) {
                    return new n(e)
                }
            },
            48764: (e, t, i) => {
                "use strict";
                i.d(t, {
                    BO: () => s,
                    IY: () => o,
                    az: () => r
                });
                var n = i(65321);

                function o(e, t = {}) {
                    const i = r(t);
                    return i.textContent = e, i
                }

                function s(e, t = {}) {
                    const i = r(t);
                    return l(i, function(e, t) {
                        const i = {
                            type: 1,
                            children: []
                        };
                        let n = 0,
                            o = i;
                        const s = [],
                            r = new a(e);
                        for (; !r.eos();) {
                            let e = r.next();
                            const i = "\\" === e && 0 !== d(r.peek(), t);
                            if (i && (e = r.next()), !i && c(e, t) && e === r.peek()) {
                                r.advance(), 2 === o.type && (o = s.pop());
                                const i = d(e, t);
                                if (o.type === i || 5 === o.type && 6 === i) o = s.pop();
                                else {
                                    const e = {
                                        type: i,
                                        children: []
                                    };
                                    5 === i && (e.index = n, n++), o.children.push(e), s.push(o), o = e
                                }
                            } else if ("\n" === e) 2 === o.type && (o = s.pop()), o.children.push({
                                type: 8
                            });
                            else if (2 !== o.type) {
                                const t = {
                                    type: 2,
                                    content: e
                                };
                                o.children.push(t), s.push(o), o = t
                            } else o.content += e
                        }
                        2 === o.type && (o = s.pop());
                        s.length;
                        return i
                    }(e, !!t.renderCodeSegments), t.actionHandler, t.renderCodeSegments), i
                }

                function r(e) {
                    const t = e.inline ? "span" : "div",
                        i = document.createElement(t);
                    return e.className && (i.className = e.className), i
                }
                class a {
                    constructor(e) {
                        this.source = e, this.index = 0
                    }
                    eos() {
                        return this.index >= this.source.length
                    }
                    next() {
                        const e = this.peek();
                        return this.advance(), e
                    }
                    peek() {
                        return this.source[this.index]
                    }
                    advance() {
                        this.index++
                    }
                }

                function l(e, t, i, o) {
                    let s;
                    if (2 === t.type) s = document.createTextNode(t.content || "");
                    else if (3 === t.type) s = document.createElement("b");
                    else if (4 === t.type) s = document.createElement("i");
                    else if (7 === t.type && o) s = document.createElement("code");
                    else if (5 === t.type && i) {
                        const e = document.createElement("a");
                        e.href = "#", i.disposables.add(n.mu(e, "click", (e => {
                            i.callback(String(t.index), e)
                        }))), s = e
                    } else 8 === t.type ? s = document.createElement("br") : 1 === t.type && (s = e);
                    s && e !== s && e.appendChild(s), s && Array.isArray(t.children) && t.children.forEach((e => {
                        l(s, e, i, o)
                    }))
                }

                function c(e, t) {
                    return 0 !== d(e, t)
                }

                function d(e, t) {
                    switch (e) {
                        case "*":
                            return 3;
                        case "_":
                            return 4;
                        case "[":
                            return 5;
                        case "]":
                            return 6;
                        case "`":
                            return t ? 7 : 0;
                        default:
                            return 0
                    }
                }
            },
            57974: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => c,
                    e: () => l
                });
                var n = i(65321),
                    o = i(70262),
                    s = i(23938),
                    r = i(5976),
                    a = i(1432);

                function l(e, t) {
                    let i = new s.n(t);
                    return i.preventDefault(), {
                        leftButton: i.leftButton,
                        buttons: i.buttons,
                        posx: i.posx,
                        posy: i.posy
                    }
                }
                class c {
                    constructor() {
                        this._hooks = new r.SL, this._mouseMoveEventMerger = null, this._mouseMoveCallback = null, this._onStopCallback = null
                    }
                    dispose() {
                        this.stopMonitoring(!1), this._hooks.dispose()
                    }
                    stopMonitoring(e, t) {
                        if (!this.isMonitoring()) return;
                        this._hooks.clear(), this._mouseMoveEventMerger = null, this._mouseMoveCallback = null;
                        const i = this._onStopCallback;
                        this._onStopCallback = null, e && i && i(t)
                    }
                    isMonitoring() {
                        return !!this._mouseMoveEventMerger
                    }
                    startMonitoring(e, t, i, r, l) {
                        if (this.isMonitoring()) return;
                        this._mouseMoveEventMerger = i, this._mouseMoveCallback = r, this._onStopCallback = l;
                        const c = o.E.getSameOriginWindowChain(),
                            d = a.gn ? "pointermove" : "mousemove",
                            h = c.map((e => e.window.document)),
                            u = n.Ay(e);
                        u && h.unshift(u);
                        for (const e of h) this._hooks.add(n.Y_(e, d, (e => {
                            e.buttons === t ? this._mouseMoveCallback(e) : this.stopMonitoring(!0)
                        }), ((e, t) => this._mouseMoveEventMerger(e, t)))), this._hooks.add(n.nm(e, "mouseup", (e => this.stopMonitoring(!0))));
                        if (o.E.hasDifferentOriginAncestor()) {
                            let e = c[c.length - 1];
                            this._hooks.add(n.nm(e.window.document, "mouseout", (e => {
                                "html" === new s.n(e).target.tagName.toLowerCase() && this.stopMonitoring(!0)
                            }))), this._hooks.add(n.nm(e.window.document, "mouseover", (e => {
                                "html" === new s.n(e).target.tagName.toLowerCase() && this.stopMonitoring(!0)
                            }))), this._hooks.add(n.nm(e.window.document.body, "mouseleave", (e => {
                                this.stopMonitoring(!0)
                            })))
                        }
                    }
                }
            },
            70262: (e, t, i) => {
                "use strict";
                i.d(t, {
                    E: () => r
                });
                let n = !1,
                    o = null;

                function s(e) {
                    if (!e.parent || e.parent === e) return null;
                    try {
                        let t = e.location,
                            i = e.parent.location;
                        if ("null" !== t.origin && "null" !== i.origin && t.origin !== i.origin) return n = !0, null
                    } catch (e) {
                        return n = !0, null
                    }
                    return e.parent
                }
                class r {
                    static getSameOriginWindowChain() {
                        if (!o) {
                            o = [];
                            let e, t = window;
                            do {
                                e = s(t), e ? o.push({
                                    window: t,
                                    iframeElement: t.frameElement || null
                                }) : o.push({
                                    window: t,
                                    iframeElement: null
                                }), t = e
                            } while (t)
                        }
                        return o.slice(0)
                    }
                    static hasDifferentOriginAncestor() {
                        return o || this.getSameOriginWindowChain(), n
                    }
                    static getPositionOfChildWindowRelativeToAncestorWindow(e, t) {
                        if (!t || e === t) return {
                            top: 0,
                            left: 0
                        };
                        let i = 0,
                            n = 0,
                            o = this.getSameOriginWindowChain();
                        for (const e of o) {
                            if (i += e.window.scrollY, n += e.window.scrollX, e.window === t) break;
                            if (!e.iframeElement) break;
                            let o = e.iframeElement.getBoundingClientRect();
                            i += o.top, n += o.left
                        }
                        return {
                            top: i,
                            left: n
                        }
                    }
                }
            },
            59069: (e, t, i) => {
                "use strict";
                i.d(t, {
                    y: () => c
                });
                var n = i(16268),
                    o = i(22258),
                    s = i(8313),
                    r = i(1432);
                const a = r.dz ? 256 : 2048,
                    l = r.dz ? 2048 : 256;
                class c {
                    constructor(e) {
                        this._standardKeyboardEventBrand = !0;
                        let t = e;
                        this.browserEvent = t, this.target = t.target, this.ctrlKey = t.ctrlKey, this.shiftKey = t.shiftKey, this.altKey = t.altKey, this.metaKey = t.metaKey, this.keyCode = function(e) {
                            if (e.charCode) {
                                let t = String.fromCharCode(e.charCode).toUpperCase();
                                return o.kL.fromString(t)
                            }
                            const t = e.keyCode;
                            if (3 === t) return 7;
                            if (n.vU) {
                                if (59 === t) return 80;
                                if (107 === t) return 81;
                                if (109 === t) return 83;
                                if (r.dz && 224 === t) return 57
                            } else if (n.Pf) {
                                if (91 === t) return 57;
                                if (r.dz && 93 === t) return 57;
                                if (!r.dz && 92 === t) return 57
                            }
                            return o.H_[t] || 0
                        }(t), this.code = t.code, this.ctrlKey = this.ctrlKey || 5 === this.keyCode, this.altKey = this.altKey || 6 === this.keyCode, this.shiftKey = this.shiftKey || 4 === this.keyCode, this.metaKey = this.metaKey || 57 === this.keyCode, this._asKeybinding = this._computeKeybinding(), this._asRuntimeKeybinding = this._computeRuntimeKeybinding()
                    }
                    preventDefault() {
                        this.browserEvent && this.browserEvent.preventDefault && this.browserEvent.preventDefault()
                    }
                    stopPropagation() {
                        this.browserEvent && this.browserEvent.stopPropagation && this.browserEvent.stopPropagation()
                    }
                    toKeybinding() {
                        return this._asRuntimeKeybinding
                    }
                    equals(e) {
                        return this._asKeybinding === e
                    }
                    _computeKeybinding() {
                        let e = 0;
                        5 !== this.keyCode && 4 !== this.keyCode && 6 !== this.keyCode && 57 !== this.keyCode && (e = this.keyCode);
                        let t = 0;
                        return this.ctrlKey && (t |= a), this.altKey && (t |= 512), this.shiftKey && (t |= 1024), this.metaKey && (t |= l), t |= e, t
                    }
                    _computeRuntimeKeybinding() {
                        let e = 0;
                        return 5 !== this.keyCode && 4 !== this.keyCode && 6 !== this.keyCode && 57 !== this.keyCode && (e = this.keyCode), new s.QC(this.ctrlKey, this.shiftKey, this.altKey, this.metaKey, e)
                    }
                }
            },
            23938: (e, t, i) => {
                "use strict";
                i.d(t, {
                    n: () => r,
                    q: () => a
                });
                var n = i(16268),
                    o = i(70262),
                    s = i(1432);
                class r {
                    constructor(e) {
                        this.timestamp = Date.now(), this.browserEvent = e, this.leftButton = 0 === e.button, this.middleButton = 1 === e.button, this.rightButton = 2 === e.button, this.buttons = e.buttons, this.target = e.target, this.detail = e.detail || 1, "dblclick" === e.type && (this.detail = 2), this.ctrlKey = e.ctrlKey, this.shiftKey = e.shiftKey, this.altKey = e.altKey, this.metaKey = e.metaKey, "number" == typeof e.pageX ? (this.posx = e.pageX, this.posy = e.pageY) : (this.posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft, this.posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop);
                        let t = o.E.getPositionOfChildWindowRelativeToAncestorWindow(self, e.view);
                        this.posx -= t.left, this.posy -= t.top
                    }
                    preventDefault() {
                        this.browserEvent.preventDefault()
                    }
                    stopPropagation() {
                        this.browserEvent.stopPropagation()
                    }
                }
                class a {
                    constructor(e, t = 0, i = 0) {
                        if (this.browserEvent = e || null, this.target = e ? e.target || e.targetNode || e.srcElement : null, this.deltaY = i, this.deltaX = t, e) {
                            let t = e,
                                i = e;
                            if (void 0 !== t.wheelDeltaY) this.deltaY = t.wheelDeltaY / 120;
                            else if (void 0 !== i.VERTICAL_AXIS && i.axis === i.VERTICAL_AXIS) this.deltaY = -i.detail / 3;
                            else if ("wheel" === e.type) {
                                const t = e;
                                t.deltaMode === t.DOM_DELTA_LINE ? n.vU && !s.dz ? this.deltaY = -e.deltaY / 3 : this.deltaY = -e.deltaY : this.deltaY = -e.deltaY / 40
                            }
                            if (void 0 !== t.wheelDeltaX) n.G6 && s.ED ? this.deltaX = -t.wheelDeltaX / 120 : this.deltaX = t.wheelDeltaX / 120;
                            else if (void 0 !== i.HORIZONTAL_AXIS && i.axis === i.HORIZONTAL_AXIS) this.deltaX = -e.detail / 3;
                            else if ("wheel" === e.type) {
                                const t = e;
                                t.deltaMode === t.DOM_DELTA_LINE ? n.vU && !s.dz ? this.deltaX = -e.deltaX / 3 : this.deltaX = -e.deltaX : this.deltaX = -e.deltaX / 40
                            }
                            0 === this.deltaY && 0 === this.deltaX && e.wheelDelta && (this.deltaY = e.wheelDelta / 120)
                        }
                    }
                    preventDefault() {
                        this.browserEvent && this.browserEvent.preventDefault()
                    }
                    stopPropagation() {
                        this.browserEvent && this.browserEvent.stopPropagation()
                    }
                }
            },
            10553: (e, t, i) => {
                "use strict";
                i.d(t, {
                    o: () => c,
                    t: () => n
                });
                var n, o = i(65321),
                    s = i(9488),
                    r = i(49898),
                    a = i(5976),
                    l = function(e, t, i, n) {
                        var o, s = arguments.length,
                            r = s < 3 ? t : null === n ? n = Object.getOwnPropertyDescriptor(t, i) : n;
                        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(e, t, i, n);
                        else
                            for (var a = e.length - 1; a >= 0; a--)(o = e[a]) && (r = (s < 3 ? o(r) : s > 3 ? o(t, i, r) : o(t, i)) || r);
                        return s > 3 && r && Object.defineProperty(t, i, r), r
                    };
                ! function(e) {
                    e.Tap = "-monaco-gesturetap", e.Change = "-monaco-gesturechange", e.Start = "-monaco-gesturestart", e.End = "-monaco-gesturesend", e.Contextmenu = "-monaco-gesturecontextmenu"
                }(n || (n = {}));
                class c extends a.JT {
                    constructor() {
                        super(), this.dispatched = !1, this.activeTouches = {}, this.handle = null, this.targets = [], this.ignoreTargets = [], this._lastSetTapCountTime = 0, this._register(o.nm(document, "touchstart", (e => this.onTouchStart(e)), {
                            passive: !1
                        })), this._register(o.nm(document, "touchend", (e => this.onTouchEnd(e)))), this._register(o.nm(document, "touchmove", (e => this.onTouchMove(e)), {
                            passive: !1
                        }))
                    }
                    static addTarget(e) {
                        return c.isTouchDevice() ? (c.INSTANCE || (c.INSTANCE = new c), c.INSTANCE.targets.push(e), {
                            dispose: () => {
                                c.INSTANCE.targets = c.INSTANCE.targets.filter((t => t !== e))
                            }
                        }) : a.JT.None
                    }
                    static ignoreTarget(e) {
                        return c.isTouchDevice() ? (c.INSTANCE || (c.INSTANCE = new c), c.INSTANCE.ignoreTargets.push(e), {
                            dispose: () => {
                                c.INSTANCE.ignoreTargets = c.INSTANCE.ignoreTargets.filter((t => t !== e))
                            }
                        }) : a.JT.None
                    }
                    static isTouchDevice() {
                        return "ontouchstart" in window || navigator.maxTouchPoints > 0
                    }
                    dispose() {
                        this.handle && (this.handle.dispose(), this.handle = null), super.dispose()
                    }
                    onTouchStart(e) {
                        let t = Date.now();
                        this.handle && (this.handle.dispose(), this.handle = null);
                        for (let i = 0, o = e.targetTouches.length; i < o; i++) {
                            let o = e.targetTouches.item(i);
                            this.activeTouches[o.identifier] = {
                                id: o.identifier,
                                initialTarget: o.target,
                                initialTimeStamp: t,
                                initialPageX: o.pageX,
                                initialPageY: o.pageY,
                                rollingTimestamps: [t],
                                rollingPageX: [o.pageX],
                                rollingPageY: [o.pageY]
                            };
                            let s = this.newGestureEvent(n.Start, o.target);
                            s.pageX = o.pageX, s.pageY = o.pageY, this.dispatchEvent(s)
                        }
                        this.dispatched && (e.preventDefault(), e.stopPropagation(), this.dispatched = !1)
                    }
                    onTouchEnd(e) {
                        let t = Date.now(),
                            i = Object.keys(this.activeTouches).length;
                        for (let o = 0, r = e.changedTouches.length; o < r; o++) {
                            let r = e.changedTouches.item(o);
                            if (!this.activeTouches.hasOwnProperty(String(r.identifier))) {
                                console.warn("move of an UNKNOWN touch", r);
                                continue
                            }
                            let a = this.activeTouches[r.identifier],
                                l = Date.now() - a.initialTimeStamp;
                            if (l < c.HOLD_DELAY && Math.abs(a.initialPageX - s.Gb(a.rollingPageX)) < 30 && Math.abs(a.initialPageY - s.Gb(a.rollingPageY)) < 30) {
                                let e = this.newGestureEvent(n.Tap, a.initialTarget);
                                e.pageX = s.Gb(a.rollingPageX), e.pageY = s.Gb(a.rollingPageY), this.dispatchEvent(e)
                            } else if (l >= c.HOLD_DELAY && Math.abs(a.initialPageX - s.Gb(a.rollingPageX)) < 30 && Math.abs(a.initialPageY - s.Gb(a.rollingPageY)) < 30) {
                                let e = this.newGestureEvent(n.Contextmenu, a.initialTarget);
                                e.pageX = s.Gb(a.rollingPageX), e.pageY = s.Gb(a.rollingPageY), this.dispatchEvent(e)
                            } else if (1 === i) {
                                let e = s.Gb(a.rollingPageX),
                                    i = s.Gb(a.rollingPageY),
                                    n = s.Gb(a.rollingTimestamps) - a.rollingTimestamps[0],
                                    o = e - a.rollingPageX[0],
                                    r = i - a.rollingPageY[0];
                                const l = this.targets.filter((e => a.initialTarget instanceof Node && e.contains(a.initialTarget)));
                                this.inertia(l, t, Math.abs(o) / n, o > 0 ? 1 : -1, e, Math.abs(r) / n, r > 0 ? 1 : -1, i)
                            }
                            this.dispatchEvent(this.newGestureEvent(n.End, a.initialTarget)), delete this.activeTouches[r.identifier]
                        }
                        this.dispatched && (e.preventDefault(), e.stopPropagation(), this.dispatched = !1)
                    }
                    newGestureEvent(e, t) {
                        let i = document.createEvent("CustomEvent");
                        return i.initEvent(e, !1, !0), i.initialTarget = t, i.tapCount = 0, i
                    }
                    dispatchEvent(e) {
                        if (e.type === n.Tap) {
                            const t = (new Date).getTime();
                            let i = 0;
                            i = t - this._lastSetTapCountTime > c.CLEAR_TAP_COUNT_TIME ? 1 : 2, this._lastSetTapCountTime = t, e.tapCount = i
                        } else e.type !== n.Change && e.type !== n.Contextmenu || (this._lastSetTapCountTime = 0);
                        for (let t = 0; t < this.ignoreTargets.length; t++)
                            if (e.initialTarget instanceof Node && this.ignoreTargets[t].contains(e.initialTarget)) return;
                        this.targets.forEach((t => {
                            e.initialTarget instanceof Node && t.contains(e.initialTarget) && (t.dispatchEvent(e), this.dispatched = !0)
                        }))
                    }
                    inertia(e, t, i, s, r, a, l, d) {
                        this.handle = o.jL((() => {
                            let o = Date.now(),
                                h = o - t,
                                u = 0,
                                g = 0,
                                p = !0;
                            i += c.SCROLL_FRICTION * h, a += c.SCROLL_FRICTION * h, i > 0 && (p = !1, u = s * i * h), a > 0 && (p = !1, g = l * a * h);
                            let f = this.newGestureEvent(n.Change);
                            f.translationX = u, f.translationY = g, e.forEach((e => e.dispatchEvent(f))), p || this.inertia(e, o, i, s, r + u, a, l, d + g)
                        }))
                    }
                    onTouchMove(e) {
                        let t = Date.now();
                        for (let i = 0, o = e.changedTouches.length; i < o; i++) {
                            let o = e.changedTouches.item(i);
                            if (!this.activeTouches.hasOwnProperty(String(o.identifier))) {
                                console.warn("end of an UNKNOWN touch", o);
                                continue
                            }
                            let r = this.activeTouches[o.identifier],
                                a = this.newGestureEvent(n.Change, r.initialTarget);
                            a.translationX = o.pageX - s.Gb(r.rollingPageX), a.translationY = o.pageY - s.Gb(r.rollingPageY), a.pageX = o.pageX, a.pageY = o.pageY, this.dispatchEvent(a), r.rollingPageX.length > 3 && (r.rollingPageX.shift(), r.rollingPageY.shift(), r.rollingTimestamps.shift()), r.rollingPageX.push(o.pageX), r.rollingPageY.push(o.pageY), r.rollingTimestamps.push(t)
                        }
                        this.dispatched && (e.preventDefault(), e.stopPropagation(), this.dispatched = !1)
                    }
                }
                c.SCROLL_FRICTION = -.005, c.HOLD_DELAY = 700, c.CLEAR_TAP_COUNT_TIME = 400, l([r.H], c, "isTouchDevice", null)
            },
            76033: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Y: () => u,
                    g: () => g
                });
                var n = i(16268),
                    o = i(23547),
                    s = i(65321),
                    r = i(10553),
                    a = i(74741),
                    l = i(5976),
                    c = i(1432),
                    d = i(98401),
                    h = (i(82016), i(63580));
                class u extends l.JT {
                    constructor(e, t, i = {}) {
                        super(), this.options = i, this._context = e || this, this._action = t, t instanceof a.aU && this._register(t.onDidChange((e => {
                            this.element && this.handleActionChangeEvent(e)
                        })))
                    }
                    handleActionChangeEvent(e) {
                        void 0 !== e.enabled && this.updateEnabled(), void 0 !== e.checked && this.updateChecked(), void 0 !== e.class && this.updateClass(), void 0 !== e.label && (this.updateLabel(), this.updateTooltip()), void 0 !== e.tooltip && this.updateTooltip()
                    }
                    get actionRunner() {
                        return this._actionRunner || (this._actionRunner = this._register(new a.Wi)), this._actionRunner
                    }
                    set actionRunner(e) {
                        this._actionRunner = e
                    }
                    getAction() {
                        return this._action
                    }
                    isEnabled() {
                        return this._action.enabled
                    }
                    setActionContext(e) {
                        this._context = e
                    }
                    render(e) {
                        const t = this.element = e;
                        this._register(r.o.addTarget(e));
                        const i = this.options && this.options.draggable;
                        i && (e.draggable = !0, n.vU && this._register((0, s.nm)(e, s.tw.DRAG_START, (e => {
                            var t;
                            return null === (t = e.dataTransfer) || void 0 === t ? void 0 : t.setData(o.go.TEXT, this._action.label)
                        })))), this._register((0, s.nm)(t, r.t.Tap, (e => this.onClick(e, !0)))), this._register((0, s.nm)(t, s.tw.MOUSE_DOWN, (e => {
                            i || s.zB.stop(e, !0), this._action.enabled && 0 === e.button && t.classList.add("active")
                        }))), c.dz && this._register((0, s.nm)(t, s.tw.CONTEXT_MENU, (e => {
                            0 === e.button && !0 === e.ctrlKey && this.onClick(e)
                        }))), this._register((0, s.nm)(t, s.tw.CLICK, (e => {
                            s.zB.stop(e, !0), this.options && this.options.isMenu || this.onClick(e)
                        }))), this._register((0, s.nm)(t, s.tw.DBLCLICK, (e => {
                            s.zB.stop(e, !0)
                        }))), [s.tw.MOUSE_UP, s.tw.MOUSE_OUT].forEach((e => {
                            this._register((0, s.nm)(t, e, (e => {
                                s.zB.stop(e), t.classList.remove("active")
                            })))
                        }))
                    }
                    onClick(e, t = !1) {
                        var i;
                        s.zB.stop(e, !0);
                        const n = d.Jp(this._context) ? (null === (i = this.options) || void 0 === i ? void 0 : i.useEventAsContext) ? e : {
                            preserveFocus: t
                        } : this._context;
                        this.actionRunner.run(this._action, n)
                    }
                    focus() {
                        this.element && (this.element.tabIndex = 0, this.element.focus(), this.element.classList.add("focused"))
                    }
                    blur() {
                        this.element && (this.element.blur(), this.element.tabIndex = -1, this.element.classList.remove("focused"))
                    }
                    setFocusable(e) {
                        this.element && (this.element.tabIndex = e ? 0 : -1)
                    }
                    get trapsArrowNavigation() {
                        return !1
                    }
                    updateEnabled() {}
                    updateLabel() {}
                    updateTooltip() {}
                    updateClass() {}
                    updateChecked() {}
                    dispose() {
                        this.element && (this.element.remove(), this.element = void 0), super.dispose()
                    }
                }
                class g extends u {
                    constructor(e, t, i = {}) {
                        super(e, t, i), this.options = i, this.options.icon = void 0 !== i.icon && i.icon, this.options.label = void 0 === i.label || i.label, this.cssClass = ""
                    }
                    render(e) {
                        super.render(e), this.element && (this.label = (0, s.R3)(this.element, (0, s.$)("a.action-label"))), this.label && (this._action.id === a.Z0.ID ? this.label.setAttribute("role", "presentation") : this.options.isMenu ? this.label.setAttribute("role", "menuitem") : this.label.setAttribute("role", "button")), this.options.label && this.options.keybinding && this.element && ((0, s.R3)(this.element, (0, s.$)("span.keybinding")).textContent = this.options.keybinding), this.updateClass(), this.updateLabel(), this.updateTooltip(), this.updateEnabled(), this.updateChecked()
                    }
                    focus() {
                        this.label && (this.label.tabIndex = 0, this.label.focus())
                    }
                    blur() {
                        this.label && (this.label.tabIndex = -1)
                    }
                    setFocusable(e) {
                        this.label && (this.label.tabIndex = e ? 0 : -1)
                    }
                    updateLabel() {
                        this.options.label && this.label && (this.label.textContent = this.getAction().label)
                    }
                    updateTooltip() {
                        let e = null;
                        this.getAction().tooltip ? e = this.getAction().tooltip : !this.options.label && this.getAction().label && this.options.icon && (e = this.getAction().label, this.options.keybinding && (e = h.N({
                            key: "titleLabel",
                            comment: ["action title", "action keybinding"]
                        }, "{0} ({1})", e, this.options.keybinding))), e && this.label && (this.label.title = e)
                    }
                    updateClass() {
                        this.cssClass && this.label && this.label.classList.remove(...this.cssClass.split(" ")), this.options.icon ? (this.cssClass = this.getAction().class, this.label && (this.label.classList.add("codicon"), this.cssClass && this.label.classList.add(...this.cssClass.split(" "))), this.updateEnabled()) : this.label && this.label.classList.remove("codicon")
                    }
                    updateEnabled() {
                        this.getAction().enabled ? (this.label && (this.label.removeAttribute("aria-disabled"), this.label.classList.remove("disabled")), this.element && this.element.classList.remove("disabled")) : (this.label && (this.label.setAttribute("aria-disabled", "true"), this.label.classList.add("disabled")), this.element && this.element.classList.add("disabled"))
                    }
                    updateChecked() {
                        this.label && (this.getAction().checked ? this.label.classList.add("checked") : this.label.classList.remove("checked"))
                    }
                }
            },
            90317: (e, t, i) => {
                "use strict";
                i.d(t, {
                    o: () => h
                });
                var n = i(65321),
                    o = i(59069),
                    s = i(76033),
                    r = i(74741),
                    a = i(4669),
                    l = i(5976),
                    c = i(98401),
                    d = (i(82016), function(e, t, i, n) {
                        return new(i || (i = Promise))((function(o, s) {
                            function r(e) {
                                try {
                                    l(n.next(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function a(e) {
                                try {
                                    l(n.throw(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function l(e) {
                                var t;
                                e.done ? o(e.value) : (t = e.value, t instanceof i ? t : new i((function(e) {
                                    e(t)
                                }))).then(r, a)
                            }
                            l((n = n.apply(e, t || [])).next())
                        }))
                    });
                class h extends l.JT {
                    constructor(e, t = {}) {
                        var i, l, c, d, h, u;
                        let g, p;
                        switch (super(), this.triggerKeyDown = !1, this.focusable = !0, this._onDidBlur = this._register(new a.Q5), this.onDidBlur = this._onDidBlur.event, this._onDidCancel = this._register(new a.Q5({
                            onFirstListenerAdd: () => this.cancelHasListener = !0
                        })), this.onDidCancel = this._onDidCancel.event, this.cancelHasListener = !1, this._onDidRun = this._register(new a.Q5), this.onDidRun = this._onDidRun.event, this._onBeforeRun = this._register(new a.Q5), this.onBeforeRun = this._onBeforeRun.event, this.options = t, this._context = null !== (i = t.context) && void 0 !== i ? i : null, this._orientation = null !== (l = this.options.orientation) && void 0 !== l ? l : 0, this._triggerKeys = {
                            keyDown: null !== (d = null === (c = this.options.triggerKeys) || void 0 === c ? void 0 : c.keyDown) && void 0 !== d && d,
                            keys: null !== (u = null === (h = this.options.triggerKeys) || void 0 === h ? void 0 : h.keys) && void 0 !== u ? u : [3, 10]
                        }, this.options.actionRunner ? this._actionRunner = this.options.actionRunner : (this._actionRunner = new r.Wi, this._register(this._actionRunner)), this._register(this._actionRunner.onDidRun((e => this._onDidRun.fire(e)))), this._register(this._actionRunner.onBeforeRun((e => this._onBeforeRun.fire(e)))), this._actionIds = [], this.viewItems = [], this.focusedItem = void 0, this.domNode = document.createElement("div"), this.domNode.className = "monaco-action-bar", !1 !== t.animated && this.domNode.classList.add("animated"), this._orientation) {
                            case 0:
                                g = [15], p = [17];
                                break;
                            case 1:
                                g = [16], p = [18], this.domNode.className += " vertical"
                        }
                        this._register(n.nm(this.domNode, n.tw.KEY_DOWN, (e => {
                            const t = new o.y(e);
                            let i = !0;
                            const n = "number" == typeof this.focusedItem ? this.viewItems[this.focusedItem] : void 0;
                            g && (t.equals(g[0]) || t.equals(g[1])) ? i = this.focusPrevious() : p && (t.equals(p[0]) || t.equals(p[1])) ? i = this.focusNext() : t.equals(9) && this.cancelHasListener ? this._onDidCancel.fire() : t.equals(14) ? i = this.focusFirst() : t.equals(13) ? i = this.focusLast() : t.equals(2) && n instanceof s.Y && n.trapsArrowNavigation ? i = this.focusNext() : this.isTriggerKeyEvent(t) ? this._triggerKeys.keyDown ? this.doTrigger(t) : this.triggerKeyDown = !0 : i = !1, i && (t.preventDefault(), t.stopPropagation())
                        }))), this._register(n.nm(this.domNode, n.tw.KEY_UP, (e => {
                            const t = new o.y(e);
                            this.isTriggerKeyEvent(t) ? (!this._triggerKeys.keyDown && this.triggerKeyDown && (this.triggerKeyDown = !1, this.doTrigger(t)), t.preventDefault(), t.stopPropagation()) : (t.equals(2) || t.equals(1026)) && this.updateFocusedItem()
                        }))), this.focusTracker = this._register(n.go(this.domNode)), this._register(this.focusTracker.onDidBlur((() => {
                            n.vY() !== this.domNode && n.jg(n.vY(), this.domNode) || (this._onDidBlur.fire(), this.focusedItem = void 0, this.triggerKeyDown = !1)
                        }))), this._register(this.focusTracker.onDidFocus((() => this.updateFocusedItem()))), this.actionsList = document.createElement("ul"), this.actionsList.className = "actions-container", this.actionsList.setAttribute("role", "toolbar"), this.options.ariaLabel && this.actionsList.setAttribute("aria-label", this.options.ariaLabel), this.domNode.appendChild(this.actionsList), e.appendChild(this.domNode)
                    }
                    isTriggerKeyEvent(e) {
                        let t = !1;
                        return this._triggerKeys.keys.forEach((i => {
                            t = t || e.equals(i)
                        })), t
                    }
                    updateFocusedItem() {
                        for (let e = 0; e < this.actionsList.children.length; e++) {
                            const t = this.actionsList.children[e];
                            if (n.jg(n.vY(), t)) {
                                this.focusedItem = e;
                                break
                            }
                        }
                    }
                    get context() {
                        return this._context
                    }
                    set context(e) {
                        this._context = e, this.viewItems.forEach((t => t.setActionContext(e)))
                    }
                    get actionRunner() {
                        return this._actionRunner
                    }
                    set actionRunner(e) {
                        e && (this._actionRunner = e, this.viewItems.forEach((t => t.actionRunner = e)))
                    }
                    getContainer() {
                        return this.domNode
                    }
                    push(e, t = {}) {
                        const i = Array.isArray(e) ? e : [e];
                        let o = c.hj(t.index) ? t.index : null;
                        i.forEach((e => {
                            const i = document.createElement("li");
                            let r;
                            i.className = "action-item", i.setAttribute("role", "presentation"), this.options.allowContextMenu || this._register(n.nm(i, n.tw.CONTEXT_MENU, (e => {
                                n.zB.stop(e, !0)
                            }))), this.options.actionViewItemProvider && (r = this.options.actionViewItemProvider(e)), r || (r = new s.g(this.context, e, t)), r.actionRunner = this._actionRunner, r.setActionContext(this.context), r.render(i), this.focusable && r instanceof s.Y && 0 === this.viewItems.length && r.setFocusable(!0), null === o || o < 0 || o >= this.actionsList.children.length ? (this.actionsList.appendChild(i), this.viewItems.push(r), this._actionIds.push(e.id)) : (this.actionsList.insertBefore(i, this.actionsList.children[o]), this.viewItems.splice(o, 0, r), this._actionIds.splice(o, 0, e.id), o++)
                        })), "number" == typeof this.focusedItem && this.focus(this.focusedItem)
                    }
                    clear() {
                        (0, l.B9)(this.viewItems), this.viewItems = [], this._actionIds = [], n.PO(this.actionsList)
                    }
                    length() {
                        return this.viewItems.length
                    }
                    focus(e) {
                        let t, i = !1;
                        if (void 0 === e ? i = !0 : "number" == typeof e ? t = e : "boolean" == typeof e && (i = e), i && void 0 === this.focusedItem) {
                            const e = this.viewItems.findIndex((e => e.isEnabled()));
                            this.focusedItem = -1 === e ? void 0 : e, this.updateFocus()
                        } else void 0 !== t && (this.focusedItem = t), this.updateFocus()
                    }
                    focusFirst() {
                        return this.focusedItem = this.length() > 1 ? 1 : 0, this.focusPrevious()
                    }
                    focusLast() {
                        return this.focusedItem = this.length() < 2 ? 0 : this.length() - 2, this.focusNext()
                    }
                    focusNext() {
                        if (void 0 === this.focusedItem) this.focusedItem = this.viewItems.length - 1;
                        else if (this.viewItems.length <= 1) return !1;
                        const e = this.focusedItem;
                        let t;
                        do {
                            if (this.options.preventLoopNavigation && this.focusedItem + 1 >= this.viewItems.length) return this.focusedItem = e, !1;
                            this.focusedItem = (this.focusedItem + 1) % this.viewItems.length, t = this.viewItems[this.focusedItem]
                        } while (this.focusedItem !== e && this.options.focusOnlyEnabledItems && !t.isEnabled());
                        return this.updateFocus(), !0
                    }
                    focusPrevious() {
                        if (void 0 === this.focusedItem) this.focusedItem = 0;
                        else if (this.viewItems.length <= 1) return !1;
                        const e = this.focusedItem;
                        let t;
                        do {
                            if (this.focusedItem = this.focusedItem - 1, this.focusedItem < 0) {
                                if (this.options.preventLoopNavigation) return this.focusedItem = e, !1;
                                this.focusedItem = this.viewItems.length - 1
                            }
                            t = this.viewItems[this.focusedItem]
                        } while (this.focusedItem !== e && this.options.focusOnlyEnabledItems && !t.isEnabled());
                        return this.updateFocus(!0), !0
                    }
                    updateFocus(e, t) {
                        void 0 === this.focusedItem && this.actionsList.focus({
                            preventScroll: t
                        });
                        for (let i = 0; i < this.viewItems.length; i++) {
                            const n = this.viewItems[i],
                                o = n;
                            if (i === this.focusedItem) {
                                let i = !0;
                                c.mf(o.focus) || (i = !1), this.options.focusOnlyEnabledItems && c.mf(n.isEnabled) && !n.isEnabled() && (i = !1), i ? o.focus(e) : this.actionsList.focus({
                                    preventScroll: t
                                })
                            } else c.mf(o.blur) && o.blur()
                        }
                    }
                    doTrigger(e) {
                        if (void 0 === this.focusedItem) return;
                        const t = this.viewItems[this.focusedItem];
                        if (t instanceof s.Y) {
                            const i = null === t._context || void 0 === t._context ? e : t._context;
                            this.run(t._action, i)
                        }
                    }
                    run(e, t) {
                        return d(this, void 0, void 0, (function*() {
                            yield this._actionRunner.run(e, t)
                        }))
                    }
                    dispose() {
                        (0, l.B9)(this.viewItems), this.viewItems = [], this._actionIds = [], this.getContainer().remove(), super.dispose()
                    }
                }
            },
            85152: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z9: () => u,
                    i7: () => g,
                    wW: () => h
                });
                var n = i(65321),
                    o = i(1432);
                i(56130);
                const s = 2e4;
                let r, a, l, c, d;

                function h(e) {
                    r = document.createElement("div"), r.className = "monaco-aria-container";
                    const t = () => {
                        const e = document.createElement("div");
                        return e.className = "monaco-alert", e.setAttribute("role", "alert"), e.setAttribute("aria-atomic", "true"), r.appendChild(e), e
                    };
                    a = t(), l = t();
                    const i = () => {
                        const e = document.createElement("div");
                        return e.className = "monaco-status", e.setAttribute("role", "complementary"), e.setAttribute("aria-live", "polite"), e.setAttribute("aria-atomic", "true"), r.appendChild(e), e
                    };
                    c = i(), d = i(), e.appendChild(r)
                }

                function u(e) {
                    r && (a.textContent !== e ? (n.PO(l), p(a, e)) : (n.PO(a), p(l, e)))
                }

                function g(e) {
                    r && (o.dz ? u(e) : c.textContent !== e ? (n.PO(d), p(c, e)) : (n.PO(c), p(d, e)))
                }

                function p(e, t) {
                    n.PO(e), t.length > s && (t = t.substr(0, s)), e.textContent = t, e.style.visibility = "hidden", e.style.visibility = "visible"
                }
            },
            28609: (e, t, i) => {
                "use strict";
                i.d(t, {
                    a: () => o
                });
                var n = i(73046);
                i(93998), i(36709);

                function o(e) {
                    let t = e.definition;
                    for (; t instanceof n.lA;) t = t.definition;
                    return `.codicon-${e.id}:before { content: '${t.fontCharacter}'; }`
                }
            },
            67488: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Z: () => l
                });
                var n = i(65321),
                    o = i(41264),
                    s = i(36248),
                    r = i(97295);
                i(74965);
                const a = {
                    badgeBackground: o.Il.fromHex("#4D4D4D"),
                    badgeForeground: o.Il.fromHex("#FFFFFF")
                };
                class l {
                    constructor(e, t) {
                        this.count = 0, this.options = t || Object.create(null), (0, s.jB)(this.options, a, !1), this.badgeBackground = this.options.badgeBackground, this.badgeForeground = this.options.badgeForeground, this.badgeBorder = this.options.badgeBorder, this.element = (0, n.R3)(e, (0, n.$)(".monaco-count-badge")), this.countFormat = this.options.countFormat || "{0}", this.titleFormat = this.options.titleFormat || "", this.setCount(this.options.count || 0)
                    }
                    setCount(e) {
                        this.count = e, this.render()
                    }
                    setTitleFormat(e) {
                        this.titleFormat = e, this.render()
                    }
                    render() {
                        this.element.textContent = (0, r.WU)(this.countFormat, this.count), this.element.title = (0, r.WU)(this.titleFormat, this.count), this.applyStyles()
                    }
                    style(e) {
                        this.badgeBackground = e.badgeBackground, this.badgeForeground = e.badgeForeground, this.badgeBorder = e.badgeBorder, this.applyStyles()
                    }
                    applyStyles() {
                        if (this.element) {
                            const e = this.badgeBackground ? this.badgeBackground.toString() : "",
                                t = this.badgeForeground ? this.badgeForeground.toString() : "",
                                i = this.badgeBorder ? this.badgeBorder.toString() : "";
                            this.element.style.backgroundColor = e, this.element.style.color = t, this.element.style.borderWidth = i ? "1px" : "", this.element.style.borderStyle = i ? "solid" : "", this.element.style.borderColor = i
                        }
                    }
                }
            },
            34650: (e, t, i) => {
                "use strict";
                i.d(t, {
                    q: () => r
                });
                var n = i(65321),
                    o = i(56811),
                    s = i(36248);
                class r {
                    constructor(e, t) {
                        this.supportIcons = t, this.text = "", this.title = "", this.highlights = [], this.didEverRender = !1, this.domNode = document.createElement("span"), this.domNode.className = "monaco-highlighted-label", e.appendChild(this.domNode)
                    }
                    get element() {
                        return this.domNode
                    }
                    set(e, t = [], i = "", n) {
                        e || (e = ""), n && (e = r.escapeNewLines(e, t)), this.didEverRender && this.text === e && this.title === i && s.fS(this.highlights, t) || (this.text = e, this.title = i, this.highlights = t, this.render())
                    }
                    render() {
                        const e = [];
                        let t = 0;
                        for (const i of this.highlights) {
                            if (i.end === i.start) continue;
                            if (t < i.start) {
                                const s = this.text.substring(t, i.start);
                                e.push(n.$("span", void 0, ...this.supportIcons ? (0, o.T)(s) : [s])), t = i.end
                            }
                            const s = this.text.substring(i.start, i.end),
                                r = n.$("span.highlight", void 0, ...this.supportIcons ? (0, o.T)(s) : [s]);
                            i.extraClasses && r.classList.add(i.extraClasses), e.push(r), t = i.end
                        }
                        if (t < this.text.length) {
                            const i = this.text.substring(t);
                            e.push(n.$("span", void 0, ...this.supportIcons ? (0, o.T)(i) : [i]))
                        }
                        n.mc(this.domNode, ...e), this.title ? this.domNode.title = this.title : this.domNode.removeAttribute("title"), this.didEverRender = !0
                    }
                    static escapeNewLines(e, t) {
                        let i = 0,
                            n = 0;
                        return e.replace(/\r\n|\r|\n/g, ((e, o) => {
                            n = "\r\n" === e ? -1 : 0, o += i;
                            for (const e of t) e.end <= o || (e.start >= o && (e.start += n), e.end >= o && (e.end += n));
                            return i += n, "⏎"
                        }))
                    }
                }
            },
            48801: (e, t, i) => {
                "use strict";
                i.d(t, {
                    g: () => m
                });
                var n = i(65321),
                    o = i(34650),
                    s = i(15393),
                    r = i(71050),
                    a = i(59365),
                    l = i(5976),
                    c = i(98401),
                    d = i(63580),
                    h = function(e, t, i, n) {
                        return new(i || (i = Promise))((function(o, s) {
                            function r(e) {
                                try {
                                    l(n.next(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function a(e) {
                                try {
                                    l(n.throw(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function l(e) {
                                var t;
                                e.done ? o(e.value) : (t = e.value, t instanceof i ? t : new i((function(e) {
                                    e(t)
                                }))).then(r, a)
                            }
                            l((n = n.apply(e, t || [])).next())
                        }))
                    };
                class u {
                    constructor(e, t, i) {
                        this.hoverDelegate = e, this.target = t, this.fadeInAnimation = i
                    }
                    update(e, t) {
                        var i;
                        return h(this, void 0, void 0, (function*() {
                            if (this._cancellationTokenSource && (this._cancellationTokenSource.dispose(!0), this._cancellationTokenSource = void 0), this.isDisposed) return;
                            let n;
                            if (void 0 === e || (0, c.HD)(e) || e instanceof HTMLElement) n = e;
                            else if ((0, c.mf)(e.markdown)) {
                                this._hoverWidget || this.show((0, d.N)("iconLabel.loading", "正在加载..."), t), this._cancellationTokenSource = new r.A;
                                const i = this._cancellationTokenSource.token;
                                if (n = yield e.markdown(i), this.isDisposed || i.isCancellationRequested) return
                            } else n = null !== (i = e.markdown) && void 0 !== i ? i : e.markdownNotSupportedFallback;
                            this.show(n, t)
                        }))
                    }
                    show(e, t) {
                        const i = this._hoverWidget;
                        if (this.hasContent(e)) {
                            const n = {
                                content: e,
                                target: this.target,
                                showPointer: "element" === this.hoverDelegate.placement,
                                hoverPosition: 2,
                                skipFadeInAnimation: !this.fadeInAnimation || !!i
                            };
                            this._hoverWidget = this.hoverDelegate.showHover(n, t)
                        }
                        null == i || i.dispose()
                    }
                    hasContent(e) {
                        return !!e && (!(0, a.Fr)(e) || !!e.value)
                    }
                    get isDisposed() {
                        var e;
                        return null === (e = this._hoverWidget) || void 0 === e ? void 0 : e.isDisposed
                    }
                    dispose() {
                        var e, t;
                        null === (e = this._hoverWidget) || void 0 === e || e.dispose(), null === (t = this._cancellationTokenSource) || void 0 === t || t.dispose(!0), this._cancellationTokenSource = void 0
                    }
                }
                var g = i(36248),
                    p = i(61134);
                i(24997);
                class f {
                    constructor(e) {
                        this._element = e
                    }
                    get element() {
                        return this._element
                    }
                    set textContent(e) {
                        this.disposed || e === this._textContent || (this._textContent = e, this._element.textContent = e)
                    }
                    set className(e) {
                        this.disposed || e === this._className || (this._className = e, this._element.className = e)
                    }
                    set empty(e) {
                        this.disposed || e === this._empty || (this._empty = e, this._element.style.marginLeft = e ? "0" : "")
                    }
                    dispose() {
                        this.disposed = !0
                    }
                }
                class m extends l.JT {
                    constructor(e, t) {
                        super(), this.customHovers = new Map, this.domNode = this._register(new f(n.R3(e, n.$(".monaco-icon-label")))), this.labelContainer = n.R3(this.domNode.element, n.$(".monaco-icon-label-container"));
                        const i = n.R3(this.labelContainer, n.$("span.monaco-icon-name-container"));
                        this.descriptionContainer = this._register(new f(n.R3(this.labelContainer, n.$("span.monaco-icon-description-container")))), (null == t ? void 0 : t.supportHighlights) || (null == t ? void 0 : t.supportIcons) ? this.nameNode = new _(i, !!t.supportIcons) : this.nameNode = new v(i), (null == t ? void 0 : t.supportDescriptionHighlights) ? this.descriptionNodeFactory = () => new o.q(n.R3(this.descriptionContainer.element, n.$("span.label-description")), !!t.supportIcons) : this.descriptionNodeFactory = () => this._register(new f(n.R3(this.descriptionContainer.element, n.$("span.label-description")))), this.hoverDelegate = null == t ? void 0 : t.hoverDelegate
                    }
                    get element() {
                        return this.domNode.element
                    }
                    setLabel(e, t, i) {
                        const n = ["monaco-icon-label"];
                        i && (i.extraClasses && n.push(...i.extraClasses), i.italic && n.push("italic"), i.strikethrough && n.push("strikethrough")), this.domNode.className = n.join(" "), this.setupHover((null == i ? void 0 : i.descriptionTitle) ? this.labelContainer : this.element, null == i ? void 0 : i.title), this.nameNode.setLabel(e, i), (t || this.descriptionNode) && (this.descriptionNode || (this.descriptionNode = this.descriptionNodeFactory()), this.descriptionNode instanceof o.q ? (this.descriptionNode.set(t || "", i ? i.descriptionMatches : void 0), this.setupHover(this.descriptionNode.element, null == i ? void 0 : i.descriptionTitle)) : (this.descriptionNode.textContent = t || "", this.setupHover(this.descriptionNode.element, (null == i ? void 0 : i.descriptionTitle) || ""), this.descriptionNode.empty = !t))
                    }
                    setupHover(e, t) {
                        const i = this.customHovers.get(e);
                        if (i && (i.dispose(), this.customHovers.delete(e)), t)
                            if (this.hoverDelegate) {
                                const i = function(e, t, i) {
                                    let o, r;
                                    const a = (t, i) => {
                                            var n;
                                            t && (null == r || r.dispose(), r = void 0), i && (null == o || o.dispose(), o = void 0), null === (n = e.onDidHideHover) || void 0 === n || n.call(e)
                                        },
                                        c = (n, o, a) => new s._F((() => h(this, void 0, void 0, (function*() {
                                            r && !r.isDisposed || (r = new u(e, a || t, n > 0), yield r.update(i, o))
                                        }))), n),
                                        d = n.nm(t, n.tw.MOUSE_OVER, (() => {
                                            if (o) return;
                                            const i = new l.SL;
                                            i.add(n.nm(t, n.tw.MOUSE_LEAVE, (e => a(!1, e.fromElement === t)), !0)), i.add(n.nm(t, n.tw.MOUSE_DOWN, (() => a(!0, !0)), !0));
                                            const s = {
                                                targetElements: [t],
                                                dispose: () => {}
                                            };
                                            if (void 0 === e.placement || "mouse" === e.placement) {
                                                const e = e => s.x = e.x + 10;
                                                i.add(n.nm(t, n.tw.MOUSE_MOVE, e, !0))
                                            }
                                            i.add(c(e.delay, !1, s)), o = i
                                        }), !0);
                                    return {
                                        show: e => {
                                            a(!1, !0), c(0, e)
                                        },
                                        hide: () => {
                                            a(!0, !0)
                                        },
                                        update: e => h(this, void 0, void 0, (function*() {
                                            i = e, yield null == r ? void 0 : r.update(i)
                                        })),
                                        dispose: () => {
                                            d.dispose(), a(!0, !0)
                                        }
                                    }
                                }(this.hoverDelegate, e, t);
                                i && this.customHovers.set(e, i)
                            } else ! function(e, t) {
                                (0, c.HD)(t) ? e.title = t: (null == t ? void 0 : t.markdownNotSupportedFallback) ? e.title = t.markdownNotSupportedFallback : e.removeAttribute("title")
                            }(e, t);
                        else e.removeAttribute("title")
                    }
                    dispose() {
                        super.dispose();
                        for (const e of this.customHovers.values()) e.dispose();
                        this.customHovers.clear()
                    }
                }
                class v {
                    constructor(e) {
                        this.container = e, this.label = void 0, this.singleLabel = void 0
                    }
                    setLabel(e, t) {
                        if (this.label !== e || !(0, g.fS)(this.options, t))
                            if (this.label = e, this.options = t, "string" == typeof e) this.singleLabel || (this.container.innerText = "", this.container.classList.remove("multiple"), this.singleLabel = n.R3(this.container, n.$("a.label-name", {
                                id: null == t ? void 0 : t.domId
                            }))), this.singleLabel.textContent = e;
                            else {
                                this.container.innerText = "", this.container.classList.add("multiple"), this.singleLabel = void 0;
                                for (let i = 0; i < e.length; i++) {
                                    const o = e[i],
                                        s = (null == t ? void 0 : t.domId) && `${null==t?void 0:t.domId}_${i}`;
                                    n.R3(this.container, n.$("a.label-name", {
                                        id: s,
                                        "data-icon-label-count": e.length,
                                        "data-icon-label-index": i,
                                        role: "treeitem"
                                    }, o)), i < e.length - 1 && n.R3(this.container, n.$("span.label-separator", void 0, (null == t ? void 0 : t.separator) || "/"))
                                }
                            }
                    }
                }
                class _ {
                    constructor(e, t) {
                        this.container = e, this.supportIcons = t, this.label = void 0, this.singleLabel = void 0
                    }
                    setLabel(e, t) {
                        if (this.label !== e || !(0, g.fS)(this.options, t))
                            if (this.label = e, this.options = t, "string" == typeof e) this.singleLabel || (this.container.innerText = "", this.container.classList.remove("multiple"), this.singleLabel = new o.q(n.R3(this.container, n.$("a.label-name", {
                                id: null == t ? void 0 : t.domId
                            })), this.supportIcons)), this.singleLabel.set(e, null == t ? void 0 : t.matches, void 0, null == t ? void 0 : t.labelEscapeNewLines);
                            else {
                                this.container.innerText = "", this.container.classList.add("multiple"), this.singleLabel = void 0;
                                const i = (null == t ? void 0 : t.separator) || "/",
                                    s = function(e, t, i) {
                                        if (!i) return;
                                        let n = 0;
                                        return e.map((e => {
                                            const o = {
                                                    start: n,
                                                    end: n + e.length
                                                },
                                                s = i.map((e => p.e.intersect(o, e))).filter((e => !p.e.isEmpty(e))).map((({
                                                    start: e,
                                                    end: t
                                                }) => ({
                                                    start: e - n,
                                                    end: t - n
                                                })));
                                            return n = o.end + t.length, s
                                        }))
                                    }(e, i, null == t ? void 0 : t.matches);
                                for (let r = 0; r < e.length; r++) {
                                    const a = e[r],
                                        l = s ? s[r] : void 0,
                                        c = (null == t ? void 0 : t.domId) && `${null==t?void 0:t.domId}_${r}`,
                                        d = n.$("a.label-name", {
                                            id: c,
                                            "data-icon-label-count": e.length,
                                            "data-icon-label-index": r,
                                            role: "treeitem"
                                        });
                                    new o.q(n.R3(this.container, d), this.supportIcons).set(a, l, void 0, null == t ? void 0 : t.labelEscapeNewLines), r < e.length - 1 && n.R3(d, n.$("span.label-separator", void 0, i))
                                }
                            }
                    }
                }
            },
            56811: (e, t, i) => {
                "use strict";
                i.d(t, {
                    T: () => r
                });
                var n = i(65321),
                    o = i(73046);
                const s = new RegExp(`(\\\\)?\\$\\((${o.dT.iconNameExpression}(?:${o.dT.iconModifierExpression})?)\\)`, "g");

                function r(e) {
                    const t = new Array;
                    let i, n = 0,
                        o = 0;
                    for (; null !== (i = s.exec(e));) {
                        o = i.index || 0, t.push(e.substring(n, o)), n = (i.index || 0) + i[0].length;
                        const [, s, r] = i;
                        t.push(s ? `$(${r})` : a({
                            id: r
                        }))
                    }
                    return n < e.length && t.push(e.substring(n)), t
                }

                function a(e) {
                    const t = n.$("span");
                    return t.classList.add(...o.dT.asClassNameArray(e)), t
                }
            },
            77927: (e, t, i) => {
                "use strict";
                i.d(t, {
                    p: () => b,
                    W: () => _
                });
                var n = i(65321),
                    o = i(4850),
                    s = i(48764),
                    r = i(90317),
                    a = i(85152),
                    l = i(9802),
                    c = i(93794),
                    d = i(41264),
                    h = i(4669);
                class u {
                    constructor(e, t = 0, i = e.length, n = t - 1) {
                        this.items = e, this.start = t, this.end = i, this.index = n
                    }
                    current() {
                        return this.index === this.start - 1 || this.index === this.end ? null : this.items[this.index]
                    }
                    next() {
                        return this.index = Math.min(this.index + 1, this.end), this.current()
                    }
                    previous() {
                        return this.index = Math.max(this.index - 1, this.start - 1), this.current()
                    }
                    first() {
                        return this.index = this.start, this.current()
                    }
                    last() {
                        return this.index = this.end - 1, this.current()
                    }
                }
                class g {
                    constructor(e = [], t = 10) {
                        this._initialize(e), this._limit = t, this._onChange()
                    }
                    getHistory() {
                        return this._elements
                    }
                    add(e) {
                        this._history.delete(e), this._history.add(e), this._onChange()
                    }
                    next() {
                        return this._currentPosition() !== this._elements.length - 1 ? this._navigator.next() : null
                    }
                    previous() {
                        return 0 !== this._currentPosition() ? this._navigator.previous() : null
                    }
                    current() {
                        return this._navigator.current()
                    }
                    first() {
                        return this._navigator.first()
                    }
                    last() {
                        return this._navigator.last()
                    }
                    has(e) {
                        return this._history.has(e)
                    }
                    _onChange() {
                        this._reduceToLimit();
                        const e = this._elements;
                        this._navigator = new u(e, 0, e.length, e.length)
                    }
                    _reduceToLimit() {
                        const e = this._elements;
                        e.length > this._limit && this._initialize(e.slice(e.length - this._limit))
                    }
                    _currentPosition() {
                        const e = this._navigator.current();
                        return e ? this._elements.indexOf(e) : -1
                    }
                    _initialize(e) {
                        this._history = new Set;
                        for (const t of e) this._history.add(t)
                    }
                    get _elements() {
                        const e = [];
                        return this._history.forEach((t => e.push(t))), e
                    }
                }
                var p = i(36248),
                    f = (i(58946), i(63580));
                const m = n.$,
                    v = {
                        inputBackground: d.Il.fromHex("#3C3C3C"),
                        inputForeground: d.Il.fromHex("#CCCCCC"),
                        inputValidationInfoBorder: d.Il.fromHex("#55AAFF"),
                        inputValidationInfoBackground: d.Il.fromHex("#063B49"),
                        inputValidationWarningBorder: d.Il.fromHex("#B89500"),
                        inputValidationWarningBackground: d.Il.fromHex("#352A05"),
                        inputValidationErrorBorder: d.Il.fromHex("#BE1100"),
                        inputValidationErrorBackground: d.Il.fromHex("#5A1D1D")
                    };
                class _ extends c.$ {
                    constructor(e, t, i) {
                        var s;
                        super(), this.state = "idle", this.maxHeight = Number.POSITIVE_INFINITY, this._onDidChange = this._register(new h.Q5), this.onDidChange = this._onDidChange.event, this._onDidHeightChange = this._register(new h.Q5), this.onDidHeightChange = this._onDidHeightChange.event, this.contextViewProvider = t, this.options = i || Object.create(null), (0, p.jB)(this.options, v, !1), this.message = null, this.placeholder = this.options.placeholder || "", this.tooltip = null !== (s = this.options.tooltip) && void 0 !== s ? s : this.placeholder || "", this.ariaLabel = this.options.ariaLabel || "", this.inputBackground = this.options.inputBackground, this.inputForeground = this.options.inputForeground, this.inputBorder = this.options.inputBorder, this.inputValidationInfoBorder = this.options.inputValidationInfoBorder, this.inputValidationInfoBackground = this.options.inputValidationInfoBackground, this.inputValidationInfoForeground = this.options.inputValidationInfoForeground, this.inputValidationWarningBorder = this.options.inputValidationWarningBorder, this.inputValidationWarningBackground = this.options.inputValidationWarningBackground, this.inputValidationWarningForeground = this.options.inputValidationWarningForeground, this.inputValidationErrorBorder = this.options.inputValidationErrorBorder, this.inputValidationErrorBackground = this.options.inputValidationErrorBackground, this.inputValidationErrorForeground = this.options.inputValidationErrorForeground, this.options.validationOptions && (this.validation = this.options.validationOptions.validation), this.element = n.R3(e, m(".monaco-inputbox.idle"));
                        let a = this.options.flexibleHeight ? "textarea" : "input",
                            c = n.R3(this.element, m(".ibwrapper"));
                        if (this.input = n.R3(c, m(a + ".input.empty")), this.input.setAttribute("autocorrect", "off"), this.input.setAttribute("autocapitalize", "off"), this.input.setAttribute("spellcheck", "false"), this.onfocus(this.input, (() => this.element.classList.add("synthetic-focus"))), this.onblur(this.input, (() => this.element.classList.remove("synthetic-focus"))), this.options.flexibleHeight) {
                            this.maxHeight = "number" == typeof this.options.flexibleMaxHeight ? this.options.flexibleMaxHeight : Number.POSITIVE_INFINITY, this.mirror = n.R3(c, m("div.mirror")), this.mirror.innerText = " ", this.scrollableElement = new l.NB(this.element, {
                                vertical: 1
                            }), this.options.flexibleWidth && (this.input.setAttribute("wrap", "off"), this.mirror.style.whiteSpace = "pre", this.mirror.style.wordWrap = "initial"), n.R3(e, this.scrollableElement.getDomNode()), this._register(this.scrollableElement), this._register(this.scrollableElement.onScroll((e => this.input.scrollTop = e.scrollTop)));
                            const t = this._register(new o.Y(document, "selectionchange")),
                                i = h.ju.filter(t.event, (() => {
                                    const e = document.getSelection();
                                    return (null == e ? void 0 : e.anchorNode) === c
                                }));
                            this._register(i(this.updateScrollDimensions, this)), this._register(this.onDidHeightChange(this.updateScrollDimensions, this))
                        } else this.input.type = this.options.type || "text", this.input.setAttribute("wrap", "off");
                        this.ariaLabel && this.input.setAttribute("aria-label", this.ariaLabel), this.placeholder && !this.options.showPlaceholderOnFocus && this.setPlaceHolder(this.placeholder), this.tooltip && this.setTooltip(this.tooltip), this.oninput(this.input, (() => this.onValueChange())), this.onblur(this.input, (() => this.onBlur())), this.onfocus(this.input, (() => this.onFocus())), this.ignoreGesture(this.input), setTimeout((() => this.updateMirror()), 0), this.options.actions && (this.actionbar = this._register(new r.o(this.element)), this.actionbar.push(this.options.actions, {
                            icon: !0,
                            label: !1
                        })), this.applyStyles()
                    }
                    onBlur() {
                        this._hideMessage(), this.options.showPlaceholderOnFocus && this.input.setAttribute("placeholder", "")
                    }
                    onFocus() {
                        this._showMessage(), this.options.showPlaceholderOnFocus && this.input.setAttribute("placeholder", this.placeholder || "")
                    }
                    setPlaceHolder(e) {
                        this.placeholder = e, this.input.setAttribute("placeholder", e)
                    }
                    setTooltip(e) {
                        this.tooltip = e, this.input.title = e
                    }
                    setAriaLabel(e) {
                        this.ariaLabel = e, e ? this.input.setAttribute("aria-label", this.ariaLabel) : this.input.removeAttribute("aria-label")
                    }
                    getAriaLabel() {
                        return this.ariaLabel
                    }
                    get inputElement() {
                        return this.input
                    }
                    get value() {
                        return this.input.value
                    }
                    set value(e) {
                        this.input.value !== e && (this.input.value = e, this.onValueChange())
                    }
                    get height() {
                        return "number" == typeof this.cachedHeight ? this.cachedHeight : n.wn(this.element)
                    }
                    focus() {
                        this.input.focus()
                    }
                    blur() {
                        this.input.blur()
                    }
                    hasFocus() {
                        return document.activeElement === this.input
                    }
                    select(e = null) {
                        this.input.select(), e && (this.input.setSelectionRange(e.start, e.end), e.end === this.input.value.length && (this.input.scrollLeft = this.input.scrollWidth))
                    }
                    isSelectionAtEnd() {
                        return this.input.selectionEnd === this.input.value.length && this.input.selectionStart === this.input.selectionEnd
                    }
                    enable() {
                        this.input.removeAttribute("disabled")
                    }
                    disable() {
                        this.blur(), this.input.disabled = !0, this._hideMessage()
                    }
                    get width() {
                        return n.w(this.input)
                    }
                    set width(e) {
                        if (this.options.flexibleHeight && this.options.flexibleWidth) {
                            let t = 0;
                            if (this.mirror) {
                                t = (parseFloat(this.mirror.style.paddingLeft || "") || 0) + (parseFloat(this.mirror.style.paddingRight || "") || 0)
                            }
                            this.input.style.width = e - t + "px"
                        } else this.input.style.width = e + "px";
                        this.mirror && (this.mirror.style.width = e + "px")
                    }
                    set paddingRight(e) {
                        this.options.flexibleHeight && this.options.flexibleWidth ? this.input.style.width = `calc(100% - ${e}px)` : this.input.style.paddingRight = e + "px", this.mirror && (this.mirror.style.paddingRight = e + "px")
                    }
                    updateScrollDimensions() {
                        if ("number" != typeof this.cachedContentHeight || "number" != typeof this.cachedHeight || !this.scrollableElement) return;
                        const e = this.cachedContentHeight,
                            t = this.cachedHeight,
                            i = this.input.scrollTop;
                        this.scrollableElement.setScrollDimensions({
                            scrollHeight: e,
                            height: t
                        }), this.scrollableElement.setScrollPosition({
                            scrollTop: i
                        })
                    }
                    showMessage(e, t) {
                        this.message = e, this.element.classList.remove("idle"), this.element.classList.remove("info"), this.element.classList.remove("warning"), this.element.classList.remove("error"), this.element.classList.add(this.classForType(e.type));
                        const i = this.stylesForType(this.message.type);
                        this.element.style.border = i.border ? `1px solid ${i.border}` : "", (this.hasFocus() || t) && this._showMessage()
                    }
                    hideMessage() {
                        this.message = null, this.element.classList.remove("info"), this.element.classList.remove("warning"), this.element.classList.remove("error"), this.element.classList.add("idle"), this._hideMessage(), this.applyStyles()
                    }
                    validate() {
                        let e = null;
                        return this.validation && (e = this.validation(this.value), e ? (this.inputElement.setAttribute("aria-invalid", "true"), this.showMessage(e)) : this.inputElement.hasAttribute("aria-invalid") && (this.inputElement.removeAttribute("aria-invalid"), this.hideMessage())), null == e ? void 0 : e.type
                    }
                    stylesForType(e) {
                        switch (e) {
                            case 1:
                                return {
                                    border: this.inputValidationInfoBorder, background: this.inputValidationInfoBackground, foreground: this.inputValidationInfoForeground
                                };
                            case 2:
                                return {
                                    border: this.inputValidationWarningBorder, background: this.inputValidationWarningBackground, foreground: this.inputValidationWarningForeground
                                };
                            default:
                                return {
                                    border: this.inputValidationErrorBorder, background: this.inputValidationErrorBackground, foreground: this.inputValidationErrorForeground
                                }
                        }
                    }
                    classForType(e) {
                        switch (e) {
                            case 1:
                                return "info";
                            case 2:
                                return "warning";
                            default:
                                return "error"
                        }
                    }
                    _showMessage() {
                        if (!this.contextViewProvider || !this.message) return;
                        let e, t, i = () => e.style.width = n.w(this.element) + "px";
                        this.contextViewProvider.showContextView({
                            getAnchor: () => this.element,
                            anchorAlignment: 1,
                            render: t => {
                                if (!this.message) return null;
                                e = n.R3(t, m(".monaco-inputbox-container")), i();
                                const o = {
                                        inline: !0,
                                        className: "monaco-inputbox-message"
                                    },
                                    r = this.message.formatContent ? (0, s.BO)(this.message.content, o) : (0, s.IY)(this.message.content, o);
                                r.classList.add(this.classForType(this.message.type));
                                const a = this.stylesForType(this.message.type);
                                return r.style.backgroundColor = a.background ? a.background.toString() : "", r.style.color = a.foreground ? a.foreground.toString() : "", r.style.border = a.border ? `1px solid ${a.border}` : "", n.R3(e, r), null
                            },
                            onHide: () => {
                                this.state = "closed"
                            },
                            layout: i
                        }), t = 3 === this.message.type ? f.N("alertErrorMessage", "Error: {0}", this.message.content) : 2 === this.message.type ? f.N("alertWarningMessage", "Warning: {0}", this.message.content) : f.N("alertInfoMessage", "Info: {0}", this.message.content), a.Z9(t), this.state = "open"
                    }
                    _hideMessage() {
                        this.contextViewProvider && ("open" === this.state && this.contextViewProvider.hideContextView(), this.state = "idle")
                    }
                    onValueChange() {
                        this._onDidChange.fire(this.value), this.validate(), this.updateMirror(), this.input.classList.toggle("empty", !this.value), "open" === this.state && this.contextViewProvider && this.contextViewProvider.layout()
                    }
                    updateMirror() {
                        if (!this.mirror) return;
                        const e = this.value,
                            t = 10 === e.charCodeAt(e.length - 1) ? " " : "";
                        (e + t).replace(/\u000c/g, "") ? this.mirror.textContent = e + t : this.mirror.innerText = " ", this.layout()
                    }
                    style(e) {
                        this.inputBackground = e.inputBackground, this.inputForeground = e.inputForeground, this.inputBorder = e.inputBorder, this.inputValidationInfoBackground = e.inputValidationInfoBackground, this.inputValidationInfoForeground = e.inputValidationInfoForeground, this.inputValidationInfoBorder = e.inputValidationInfoBorder, this.inputValidationWarningBackground = e.inputValidationWarningBackground, this.inputValidationWarningForeground = e.inputValidationWarningForeground, this.inputValidationWarningBorder = e.inputValidationWarningBorder, this.inputValidationErrorBackground = e.inputValidationErrorBackground, this.inputValidationErrorForeground = e.inputValidationErrorForeground, this.inputValidationErrorBorder = e.inputValidationErrorBorder, this.applyStyles()
                    }
                    applyStyles() {
                        const e = this.inputBackground ? this.inputBackground.toString() : "",
                            t = this.inputForeground ? this.inputForeground.toString() : "",
                            i = this.inputBorder ? this.inputBorder.toString() : "";
                        this.element.style.backgroundColor = e, this.element.style.color = t, this.input.style.backgroundColor = "inherit", this.input.style.color = t, this.element.style.borderWidth = i ? "1px" : "", this.element.style.borderStyle = i ? "solid" : "", this.element.style.borderColor = i
                    }
                    layout() {
                        if (!this.mirror) return;
                        const e = this.cachedContentHeight;
                        this.cachedContentHeight = n.wn(this.mirror), e !== this.cachedContentHeight && (this.cachedHeight = Math.min(this.cachedContentHeight, this.maxHeight), this.input.style.height = this.cachedHeight + "px", this._onDidHeightChange.fire(this.cachedContentHeight))
                    }
                    insertAtCursor(e) {
                        const t = this.inputElement,
                            i = t.selectionStart,
                            n = t.selectionEnd,
                            o = t.value;
                        null !== i && null !== n && (this.value = o.substr(0, i) + e + o.substr(n), t.setSelectionRange(i + 1, i + 1), this.layout())
                    }
                    dispose() {
                        this._hideMessage(), this.message = null, this.actionbar && this.actionbar.dispose(), super.dispose()
                    }
                }
                const Lg = new Language(modifyState.language);
                class b extends _ {
                    constructor(e, t, i) {
                        const n = f.N({
                                key: "history.inputbox.hint",
                            comment: [Lg.textWillDescribe()]
                        }, Lg.forHistory()),
                            o = ` or ⇅ ${n}`,
                            s = ` (⇅ ${n})`;
                        super(e, t, i), this.history = new g(i.history, 100);
                        const r = () => {
                            if (i.showHistoryHint && i.showHistoryHint() && !this.placeholder.endsWith(o) && !this.placeholder.endsWith(s) && this.history.getHistory().length) {
                                const e = this.placeholder.endsWith(")") ? o : s,
                                    t = this.placeholder + e;
                                i.showPlaceholderOnFocus && document.activeElement !== this.input ? this.placeholder = t : this.setPlaceHolder(t)
                            }
                        };
                        this.observer = new MutationObserver(((e, t) => {
                            e.forEach((e => {
                                e.target.textContent || r()
                            }))
                        })), this.observer.observe(this.input, {
                            attributeFilter: ["class"]
                        }), this.onfocus(this.input, (() => r())), this.onblur(this.input, (() => {
                            const e = e => {
                                if (this.placeholder.endsWith(e)) {
                                    const t = this.placeholder.slice(0, this.placeholder.length - e.length);
                                    return i.showPlaceholderOnFocus ? this.placeholder = t : this.setPlaceHolder(t), !0
                                }
                                return !1
                            };
                            e(s) || e(o)
                        }))
                    }
                    dispose() {
                        super.dispose(), this.observer && (this.observer.disconnect(), this.observer = void 0)
                    }
                    addToHistory() {
                        this.value && this.value !== this.getCurrentValue() && this.history.add(this.value)
                    }
                    showNextValue() {
                        this.history.has(this.value) || this.addToHistory();
                        let e = this.getNextValue();
                        e && (e = e === this.value ? this.getNextValue() : e), e && (this.value = e, a.i7(this.value))
                    }
                    showPreviousValue() {
                        this.history.has(this.value) || this.addToHistory();
                        let e = this.getPreviousValue();
                        e && (e = e === this.value ? this.getPreviousValue() : e), e && (this.value = e, a.i7(this.value))
                    }
                    getCurrentValue() {
                        let e = this.history.current();
                        return e || (e = this.history.last(), this.history.next()), e
                    }
                    getPreviousValue() {
                        return this.history.previous() || this.history.first()
                    }
                    getNextValue() {
                        return this.history.next() || this.history.last()
                    }
                }
            },
            25707: (e, t, i) => {
                "use strict";
                i.d(t, {
                    kX: () => x,
                    Bv: () => N
                });
                var n = i(16268),
                    o = i(23547),
                    s = i(65321),
                    r = i(4850),
                    a = i(10553),
                    l = i(9802),
                    c = i(9488),
                    d = i(15393),
                    h = i(49898),
                    u = i(4669),
                    g = i(5976),
                    p = i(36248),
                    f = i(61134),
                    m = i(76633);

                function v(e, t) {
                    const i = [];
                    for (let n of t) {
                        if (e.start >= n.range.end) continue;
                        if (e.end < n.range.start) break;
                        const t = f.e.intersect(e, n.range);
                        f.e.isEmpty(t) || i.push({
                            range: t,
                            size: n.size
                        })
                    }
                    return i
                }

                function _({
                    start: e,
                    end: t
                }, i) {
                    return {
                        start: e + i,
                        end: t + i
                    }
                }
                class b {
                    constructor() {
                        this.groups = [], this._size = 0
                    }
                    splice(e, t, i = []) {
                        const n = i.length - t,
                            o = v({
                                start: 0,
                                end: e
                            }, this.groups),
                            s = v({
                                start: e + t,
                                end: Number.POSITIVE_INFINITY
                            }, this.groups).map((e => ({
                                range: _(e.range, n),
                                size: e.size
                            }))),
                            r = i.map(((t, i) => ({
                                range: {
                                    start: e + i,
                                    end: e + i + 1
                                },
                                size: t.size
                            })));
                        this.groups = function(...e) {
                            return function(e) {
                                const t = [];
                                let i = null;
                                for (let n of e) {
                                    const e = n.range.start,
                                        o = n.range.end,
                                        s = n.size;
                                    i && s === i.size ? i.range.end = o : (i = {
                                        range: {
                                            start: e,
                                            end: o
                                        },
                                        size: s
                                    }, t.push(i))
                                }
                                return t
                            }(e.reduce(((e, t) => e.concat(t)), []))
                        }(o, r, s), this._size = this.groups.reduce(((e, t) => e + t.size * (t.range.end - t.range.start)), 0)
                    }
                    get count() {
                        const e = this.groups.length;
                        return e ? this.groups[e - 1].range.end : 0
                    }
                    get size() {
                        return this._size
                    }
                    indexAt(e) {
                        if (e < 0) return -1;
                        let t = 0,
                            i = 0;
                        for (let n of this.groups) {
                            const o = n.range.end - n.range.start,
                                s = i + o * n.size;
                            if (e < s) return t + Math.floor((e - i) / n.size);
                            t += o, i = s
                        }
                        return t
                    }
                    indexAfter(e) {
                        return Math.min(this.indexAt(e) + 1, this.count)
                    }
                    positionAt(e) {
                        if (e < 0) return -1;
                        let t = 0,
                            i = 0;
                        for (let n of this.groups) {
                            const o = n.range.end - n.range.start,
                                s = i + o;
                            if (e < s) return t + (e - i) * n.size;
                            t += o * n.size, i = s
                        }
                        return -1
                    }
                }
                class w {
                    constructor(e) {
                        this.renderers = e, this.cache = new Map
                    }
                    alloc(e) {
                        let t = this.getTemplateCache(e).pop();
                        if (!t) {
                            const i = (0, s.$)(".monaco-list-row");
                            t = {
                                domNode: i,
                                templateId: e,
                                templateData: this.getRenderer(e).renderTemplate(i)
                            }
                        }
                        return t
                    }
                    release(e) {
                        e && this.releaseRow(e)
                    }
                    releaseRow(e) {
                        const {
                            domNode: t,
                            templateId: i
                        } = e;
                        t && (t.classList.remove("scrolling"), function(e) {
                            try {
                                e.parentElement && e.parentElement.removeChild(e)
                            } catch (e) {}
                        }(t));
                        this.getTemplateCache(i).push(e)
                    }
                    getTemplateCache(e) {
                        let t = this.cache.get(e);
                        return t || (t = [], this.cache.set(e, t)), t
                    }
                    dispose() {
                        this.cache.forEach(((e, t) => {
                            for (const i of e) {
                                this.getRenderer(t).disposeTemplate(i.templateData), i.templateData = null
                            }
                        })), this.cache.clear()
                    }
                    getRenderer(e) {
                        const t = this.renderers.get(e);
                        if (!t) throw new Error(`No renderer found for ${e}`);
                        return t
                    }
                }
                var y = function(e, t, i, n) {
                    var o, s = arguments.length,
                        r = s < 3 ? t : null === n ? n = Object.getOwnPropertyDescriptor(t, i) : n;
                    if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(e, t, i, n);
                    else
                        for (var a = e.length - 1; a >= 0; a--)(o = e[a]) && (r = (s < 3 ? o(r) : s > 3 ? o(t, i, r) : o(t, i)) || r);
                    return s > 3 && r && Object.defineProperty(t, i, r), r
                };
                const C = {
                    useShadows: !0,
                    verticalScrollMode: 1,
                    setRowLineHeight: !0,
                    setRowHeight: !0,
                    supportDynamicHeights: !1,
                    dnd: {
                        getDragElements: e => [e],
                        getDragURI: () => null,
                        onDragStart() {},
                        onDragOver: () => !1,
                        drop() {}
                    },
                    horizontalScrolling: !1,
                    transformOptimization: !0,
                    alwaysConsumeMouseWheel: !0
                };
                class x {
                    constructor(e) {
                        this.elements = e
                    }
                    update() {}
                    getData() {
                        return this.elements
                    }
                }
                class S {
                    constructor(e) {
                        this.elements = e
                    }
                    update() {}
                    getData() {
                        return this.elements
                    }
                }
                class k {
                    constructor() {
                        this.types = [], this.files = []
                    }
                    update(e) {
                        if (e.types && this.types.splice(0, this.types.length, ...e.types), e.files) {
                            this.files.splice(0, this.files.length);
                            for (let t = 0; t < e.files.length; t++) {
                                const i = e.files.item(t);
                                i && (i.size || i.type) && this.files.push(i)
                            }
                        }
                    }
                    getData() {
                        return {
                            types: this.types,
                            files: this.files
                        }
                    }
                }
                class L {
                    constructor(e) {
                        (null == e ? void 0 : e.getSetSize) ? this.getSetSize = e.getSetSize.bind(e): this.getSetSize = (e, t, i) => i, (null == e ? void 0 : e.getPosInSet) ? this.getPosInSet = e.getPosInSet.bind(e) : this.getPosInSet = (e, t) => t + 1, (null == e ? void 0 : e.getRole) ? this.getRole = e.getRole.bind(e) : this.getRole = e => "listitem", (null == e ? void 0 : e.isChecked) ? this.isChecked = e.isChecked.bind(e) : this.isChecked = e => {}
                    }
                }
                class N {
                    constructor(e, t, i, n = C) {
                        if (this.virtualDelegate = t, this.domId = "list_id_" + ++N.InstanceCount, this.renderers = new Map, this.renderWidth = 0, this._scrollHeight = 0, this.scrollableElementUpdateDisposable = null, this.scrollableElementWidthDelayer = new d.vp(50), this.splicing = !1, this.dragOverAnimationStopDisposable = g.JT.None, this.dragOverMouseY = 0, this.canDrop = !1, this.currentDragFeedbackDisposable = g.JT.None, this.onDragLeaveTimeout = g.JT.None, this.disposables = new g.SL, this._onDidChangeContentHeight = new u.Q5, this._horizontalScrolling = !1, n.horizontalScrolling && n.supportDynamicHeights) throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");
                        this.items = [], this.itemId = 0, this.rangeMap = new b;
                        for (const e of i) this.renderers.set(e.templateId, e);
                        this.cache = this.disposables.add(new w(this.renderers)), this.lastRenderTop = 0, this.lastRenderHeight = 0, this.domNode = document.createElement("div"), this.domNode.className = "monaco-list", this.domNode.classList.add(this.domId), this.domNode.tabIndex = 0, this.domNode.classList.toggle("mouse-support", "boolean" != typeof n.mouseSupport || n.mouseSupport), this._horizontalScrolling = (0, p.CJ)(n, (e => e.horizontalScrolling), C.horizontalScrolling), this.domNode.classList.toggle("horizontal-scrolling", this._horizontalScrolling), this.additionalScrollHeight = void 0 === n.additionalScrollHeight ? 0 : n.additionalScrollHeight, this.accessibilityProvider = new L(n.accessibilityProvider), this.rowsContainer = document.createElement("div"), this.rowsContainer.className = "monaco-list-rows";
                        (0, p.CJ)(n, (e => e.transformOptimization), C.transformOptimization) && (this.rowsContainer.style.transform = "translate3d(0px, 0px, 0px)"), this.disposables.add(a.o.addTarget(this.rowsContainer)), this.scrollable = new m.Rm((0, p.CJ)(n, (e => e.smoothScrolling), !1) ? 125 : 0, (e => (0, s.jL)(e))), this.scrollableElement = this.disposables.add(new l.$Z(this.rowsContainer, {
                            alwaysConsumeMouseWheel: (0, p.CJ)(n, (e => e.alwaysConsumeMouseWheel), C.alwaysConsumeMouseWheel),
                            horizontal: 1,
                            vertical: (0, p.CJ)(n, (e => e.verticalScrollMode), C.verticalScrollMode),
                            useShadows: (0, p.CJ)(n, (e => e.useShadows), C.useShadows),
                            mouseWheelScrollSensitivity: n.mouseWheelScrollSensitivity,
                            fastScrollSensitivity: n.fastScrollSensitivity
                        }, this.scrollable)), this.domNode.appendChild(this.scrollableElement.getDomNode()), e.appendChild(this.domNode), this.scrollableElement.onScroll(this.onScroll, this, this.disposables), this.disposables.add((0, s.nm)(this.rowsContainer, a.t.Change, (e => this.onTouchChange(e)))), this.disposables.add((0, s.nm)(this.scrollableElement.getDomNode(), "scroll", (e => e.target.scrollTop = 0))), this.disposables.add((0, s.nm)(this.domNode, "dragover", (e => this.onDragOver(this.toDragEvent(e))))), this.disposables.add((0, s.nm)(this.domNode, "drop", (e => this.onDrop(this.toDragEvent(e))))), this.disposables.add((0, s.nm)(this.domNode, "dragleave", (e => this.onDragLeave(this.toDragEvent(e))))), this.disposables.add((0, s.nm)(this.domNode, "dragend", (e => this.onDragEnd(e)))), this.setRowLineHeight = (0, p.CJ)(n, (e => e.setRowLineHeight), C.setRowLineHeight), this.setRowHeight = (0, p.CJ)(n, (e => e.setRowHeight), C.setRowHeight), this.supportDynamicHeights = (0, p.CJ)(n, (e => e.supportDynamicHeights), C.supportDynamicHeights), this.dnd = (0, p.CJ)(n, (e => e.dnd), C.dnd), this.layout()
                    }
                    get contentHeight() {
                        return this.rangeMap.size
                    }
                    get horizontalScrolling() {
                        return this._horizontalScrolling
                    }
                    set horizontalScrolling(e) {
                        if (e !== this._horizontalScrolling) {
                            if (e && this.supportDynamicHeights) throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");
                            if (this._horizontalScrolling = e, this.domNode.classList.toggle("horizontal-scrolling", this._horizontalScrolling), this._horizontalScrolling) {
                                for (const e of this.items) this.measureItemWidth(e);
                                this.updateScrollWidth(), this.scrollableElement.setScrollDimensions({
                                    width: (0, s.FK)(this.domNode)
                                }), this.rowsContainer.style.width = `${Math.max(this.scrollWidth||0,this.renderWidth)}px`
                            } else this.scrollableElementWidthDelayer.cancel(), this.scrollableElement.setScrollDimensions({
                                width: this.renderWidth,
                                scrollWidth: this.renderWidth
                            }), this.rowsContainer.style.width = ""
                        }
                    }
                    updateOptions(e) {
                        void 0 !== e.additionalScrollHeight && (this.additionalScrollHeight = e.additionalScrollHeight, this.scrollableElement.setScrollDimensions({
                            scrollHeight: this.scrollHeight
                        })), void 0 !== e.smoothScrolling && this.scrollable.setSmoothScrollDuration(e.smoothScrolling ? 125 : 0), void 0 !== e.horizontalScrolling && (this.horizontalScrolling = e.horizontalScrolling), void 0 !== e.mouseWheelScrollSensitivity && this.scrollableElement.updateOptions({
                            mouseWheelScrollSensitivity: e.mouseWheelScrollSensitivity
                        }), void 0 !== e.fastScrollSensitivity && this.scrollableElement.updateOptions({
                            fastScrollSensitivity: e.fastScrollSensitivity
                        })
                    }
                    splice(e, t, i = []) {
                        if (this.splicing) throw new Error("Can't run recursive splices.");
                        this.splicing = !0;
                        try {
                            return this._splice(e, t, i)
                        } finally {
                            this.splicing = !1, this._onDidChangeContentHeight.fire(this.contentHeight)
                        }
                    }
                    _splice(e, t, i = []) {
                        const n = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight),
                            o = {
                                start: e,
                                end: e + t
                            },
                            s = f.e.intersect(n, o),
                            r = new Map;
                        for (let e = s.start; e < s.end; e++) {
                            const t = this.items[e];
                            if (t.dragStartDisposable.dispose(), t.row) {
                                let i = r.get(t.templateId);
                                i || (i = [], r.set(t.templateId, i));
                                const n = this.renderers.get(t.templateId);
                                n && n.disposeElement && n.disposeElement(t.element, e, t.row.templateData, t.size), i.push(t.row)
                            }
                            t.row = null
                        }
                        const a = {
                                start: e + t,
                                end: this.items.length
                            },
                            l = f.e.intersect(a, n),
                            c = f.e.relativeComplement(a, n),
                            d = i.map((e => ({
                                id: String(this.itemId++),
                                element: e,
                                templateId: this.virtualDelegate.getTemplateId(e),
                                size: this.virtualDelegate.getHeight(e),
                                width: void 0,
                                hasDynamicHeight: !!this.virtualDelegate.hasDynamicHeight && this.virtualDelegate.hasDynamicHeight(e),
                                lastDynamicHeightWidth: void 0,
                                row: null,
                                uri: void 0,
                                dropTarget: !1,
                                dragStartDisposable: g.JT.None
                            })));
                        let h;
                        0 === e && t >= this.items.length ? (this.rangeMap = new b, this.rangeMap.splice(0, 0, d), h = this.items, this.items = d) : (this.rangeMap.splice(e, t, d), h = this.items.splice(e, t, ...d));
                        const u = i.length - t,
                            p = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight),
                            m = _(l, u),
                            v = f.e.intersect(p, m);
                        for (let e = v.start; e < v.end; e++) this.updateItemInDOM(this.items[e], e);
                        const w = f.e.relativeComplement(m, p);
                        for (const e of w)
                            for (let t = e.start; t < e.end; t++) this.removeItemFromDOM(t);
                        const y = c.map((e => _(e, u))),
                            C = [{
                                start: e,
                                end: e + i.length
                            }, ...y].map((e => f.e.intersect(p, e))),
                            x = this.getNextToLastElement(C);
                        for (const e of C)
                            for (let t = e.start; t < e.end; t++) {
                                const e = this.items[t],
                                    i = r.get(e.templateId),
                                    n = null == i ? void 0 : i.pop();
                                this.insertItemInDOM(t, x, n)
                            }
                        for (const e of r.values())
                            for (const t of e) this.cache.release(t);
                        return this.eventuallyUpdateScrollDimensions(), this.supportDynamicHeights && this._rerender(this.scrollTop, this.renderHeight), h.map((e => e.element))
                    }
                    eventuallyUpdateScrollDimensions() {
                        this._scrollHeight = this.contentHeight, this.rowsContainer.style.height = `${this._scrollHeight}px`, this.scrollableElementUpdateDisposable || (this.scrollableElementUpdateDisposable = (0, s.jL)((() => {
                            this.scrollableElement.setScrollDimensions({
                                scrollHeight: this.scrollHeight
                            }), this.updateScrollWidth(), this.scrollableElementUpdateDisposable = null
                        })))
                    }
                    eventuallyUpdateScrollWidth() {
                        this.horizontalScrolling ? this.scrollableElementWidthDelayer.trigger((() => this.updateScrollWidth())) : this.scrollableElementWidthDelayer.cancel()
                    }
                    updateScrollWidth() {
                        if (!this.horizontalScrolling) return;
                        let e = 0;
                        for (const t of this.items) void 0 !== t.width && (e = Math.max(e, t.width));
                        this.scrollWidth = e, this.scrollableElement.setScrollDimensions({
                            scrollWidth: 0 === e ? 0 : e + 10
                        })
                    }
                    rerender() {
                        if (this.supportDynamicHeights) {
                            for (const e of this.items) e.lastDynamicHeightWidth = void 0;
                            this._rerender(this.lastRenderTop, this.lastRenderHeight)
                        }
                    }
                    get length() {
                        return this.items.length
                    }
                    get renderHeight() {
                        return this.scrollableElement.getScrollDimensions().height
                    }
                    element(e) {
                        return this.items[e].element
                    }
                    domElement(e) {
                        const t = this.items[e].row;
                        return t && t.domNode
                    }
                    elementHeight(e) {
                        return this.items[e].size
                    }
                    elementTop(e) {
                        return this.rangeMap.positionAt(e)
                    }
                    indexAt(e) {
                        return this.rangeMap.indexAt(e)
                    }
                    indexAfter(e) {
                        return this.rangeMap.indexAfter(e)
                    }
                    layout(e, t) {
                        let i = {
                            height: "number" == typeof e ? e : (0, s.If)(this.domNode)
                        };
                        this.scrollableElementUpdateDisposable && (this.scrollableElementUpdateDisposable.dispose(), this.scrollableElementUpdateDisposable = null, i.scrollHeight = this.scrollHeight), this.scrollableElement.setScrollDimensions(i), void 0 !== t && (this.renderWidth = t, this.supportDynamicHeights && this._rerender(this.scrollTop, this.renderHeight)), this.horizontalScrolling && this.scrollableElement.setScrollDimensions({
                            width: "number" == typeof t ? t : (0, s.FK)(this.domNode)
                        })
                    }
                    render(e, t, i, n, o, s = !1) {
                        const r = this.getRenderRange(t, i),
                            a = f.e.relativeComplement(r, e),
                            l = f.e.relativeComplement(e, r),
                            c = this.getNextToLastElement(a);
                        if (s) {
                            const t = f.e.intersect(e, r);
                            for (let e = t.start; e < t.end; e++) this.updateItemInDOM(this.items[e], e)
                        }
                        for (const e of a)
                            for (let t = e.start; t < e.end; t++) this.insertItemInDOM(t, c);
                        for (const e of l)
                            for (let t = e.start; t < e.end; t++) this.removeItemFromDOM(t);
                        void 0 !== n && (this.rowsContainer.style.left = `-${n}px`), this.rowsContainer.style.top = `-${t}px`, this.horizontalScrolling && void 0 !== o && (this.rowsContainer.style.width = `${Math.max(o,this.renderWidth)}px`), this.lastRenderTop = t, this.lastRenderHeight = i
                    }
                    insertItemInDOM(e, t, i) {
                        const n = this.items[e];
                        n.row || (n.row = null != i ? i : this.cache.alloc(n.templateId));
                        const o = this.accessibilityProvider.getRole(n.element) || "listitem";
                        n.row.domNode.setAttribute("role", o);
                        const r = this.accessibilityProvider.isChecked(n.element);
                        void 0 !== r && n.row.domNode.setAttribute("aria-checked", String(!!r)), n.row.domNode.parentElement || (t ? this.rowsContainer.insertBefore(n.row.domNode, t) : this.rowsContainer.appendChild(n.row.domNode)), this.updateItemInDOM(n, e);
                        const a = this.renderers.get(n.templateId);
                        if (!a) throw new Error(`No renderer found for template id ${n.templateId}`);
                        a && a.renderElement(n.element, e, n.row.templateData, n.size);
                        const l = this.dnd.getDragURI(n.element);
                        n.dragStartDisposable.dispose(), n.row.domNode.draggable = !!l, l && (n.dragStartDisposable = (0, s.nm)(n.row.domNode, "dragstart", (e => this.onDragStart(n.element, l, e)))), this.horizontalScrolling && (this.measureItemWidth(n), this.eventuallyUpdateScrollWidth())
                    }
                    measureItemWidth(e) {
                        if (!e.row || !e.row.domNode) return;
                        e.row.domNode.style.width = n.vU ? "-moz-fit-content" : "fit-content", e.width = (0, s.FK)(e.row.domNode);
                        const t = window.getComputedStyle(e.row.domNode);
                        t.paddingLeft && (e.width += parseFloat(t.paddingLeft)), t.paddingRight && (e.width += parseFloat(t.paddingRight)), e.row.domNode.style.width = ""
                    }
                    updateItemInDOM(e, t) {
                        e.row.domNode.style.top = `${this.elementTop(t)}px`, this.setRowHeight && (e.row.domNode.style.height = `${e.size}px`), this.setRowLineHeight && (e.row.domNode.style.lineHeight = `${e.size}px`), e.row.domNode.setAttribute("data-index", `${t}`), e.row.domNode.setAttribute("data-last-element", t === this.length - 1 ? "true" : "false"), e.row.domNode.setAttribute("data-parity", t % 2 == 0 ? "even" : "odd"), e.row.domNode.setAttribute("aria-setsize", String(this.accessibilityProvider.getSetSize(e.element, t, this.length))), e.row.domNode.setAttribute("aria-posinset", String(this.accessibilityProvider.getPosInSet(e.element, t))), e.row.domNode.setAttribute("id", this.getElementDomId(t)), e.row.domNode.classList.toggle("drop-target", e.dropTarget)
                    }
                    removeItemFromDOM(e) {
                        const t = this.items[e];
                        if (t.dragStartDisposable.dispose(), t.row) {
                            const i = this.renderers.get(t.templateId);
                            i && i.disposeElement && i.disposeElement(t.element, e, t.row.templateData, t.size), this.cache.release(t.row), t.row = null
                        }
                        this.horizontalScrolling && this.eventuallyUpdateScrollWidth()
                    }
                    getScrollTop() {
                        return this.scrollableElement.getScrollPosition().scrollTop
                    }
                    setScrollTop(e, t) {
                        this.scrollableElementUpdateDisposable && (this.scrollableElementUpdateDisposable.dispose(), this.scrollableElementUpdateDisposable = null, this.scrollableElement.setScrollDimensions({
                            scrollHeight: this.scrollHeight
                        })), this.scrollableElement.setScrollPosition({
                            scrollTop: e,
                            reuseAnimation: t
                        })
                    }
                    get scrollTop() {
                        return this.getScrollTop()
                    }
                    set scrollTop(e) {
                        this.setScrollTop(e)
                    }
                    get scrollHeight() {
                        return this._scrollHeight + (this.horizontalScrolling ? 10 : 0) + this.additionalScrollHeight
                    }
                    get onMouseClick() {
                        return u.ju.map(this.disposables.add(new r.Y(this.domNode, "click")).event, (e => this.toMouseEvent(e)))
                    }
                    get onMouseDblClick() {
                        return u.ju.map(this.disposables.add(new r.Y(this.domNode, "dblclick")).event, (e => this.toMouseEvent(e)))
                    }
                    get onMouseMiddleClick() {
                        return u.ju.filter(u.ju.map(this.disposables.add(new r.Y(this.domNode, "auxclick")).event, (e => this.toMouseEvent(e))), (e => 1 === e.browserEvent.button))
                    }
                    get onMouseDown() {
                        return u.ju.map(this.disposables.add(new r.Y(this.domNode, "mousedown")).event, (e => this.toMouseEvent(e)))
                    }
                    get onContextMenu() {
                        return u.ju.any(u.ju.map(this.disposables.add(new r.Y(this.domNode, "contextmenu")).event, (e => this.toMouseEvent(e))), u.ju.map(this.disposables.add(new r.Y(this.domNode, a.t.Contextmenu)).event, (e => this.toGestureEvent(e))))
                    }
                    get onTouchStart() {
                        return u.ju.map(this.disposables.add(new r.Y(this.domNode, "touchstart")).event, (e => this.toTouchEvent(e)))
                    }
                    get onTap() {
                        return u.ju.map(this.disposables.add(new r.Y(this.rowsContainer, a.t.Tap)).event, (e => this.toGestureEvent(e)))
                    }
                    toMouseEvent(e) {
                        const t = this.getItemIndexFromEventTarget(e.target || null),
                            i = void 0 === t ? void 0 : this.items[t];
                        return {
                            browserEvent: e,
                            index: t,
                            element: i && i.element
                        }
                    }
                    toTouchEvent(e) {
                        const t = this.getItemIndexFromEventTarget(e.target || null),
                            i = void 0 === t ? void 0 : this.items[t];
                        return {
                            browserEvent: e,
                            index: t,
                            element: i && i.element
                        }
                    }
                    toGestureEvent(e) {
                        const t = this.getItemIndexFromEventTarget(e.initialTarget || null),
                            i = void 0 === t ? void 0 : this.items[t];
                        return {
                            browserEvent: e,
                            index: t,
                            element: i && i.element
                        }
                    }
                    toDragEvent(e) {
                        const t = this.getItemIndexFromEventTarget(e.target || null),
                            i = void 0 === t ? void 0 : this.items[t];
                        return {
                            browserEvent: e,
                            index: t,
                            element: i && i.element
                        }
                    }
                    onScroll(e) {
                        try {
                            const t = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
                            this.render(t, e.scrollTop, e.height, e.scrollLeft, e.scrollWidth), this.supportDynamicHeights && this._rerender(e.scrollTop, e.height, e.inSmoothScrolling)
                        } catch (t) {
                            throw console.error("Got bad scroll event:", e), t
                        }
                    }
                    onTouchChange(e) {
                        e.preventDefault(), e.stopPropagation(), this.scrollTop -= e.translationY
                    }
                    onDragStart(e, t, i) {
                        if (!i.dataTransfer) return;
                        const n = this.dnd.getDragElements(e);
                        if (i.dataTransfer.effectAllowed = "copyMove", i.dataTransfer.setData(o.go.TEXT, t), i.dataTransfer.setDragImage) {
                            let e;
                            this.dnd.getDragLabel && (e = this.dnd.getDragLabel(n, i)), void 0 === e && (e = String(n.length));
                            const t = (0, s.$)(".monaco-drag-image");
                            t.textContent = e, document.body.appendChild(t), i.dataTransfer.setDragImage(t, -10, -10), setTimeout((() => document.body.removeChild(t)), 0)
                        }
                        this.currentDragData = new x(n), o.P$.CurrentDragAndDropData = new S(n), this.dnd.onDragStart && this.dnd.onDragStart(this.currentDragData, i)
                    }
                    onDragOver(e) {
                        if (e.browserEvent.preventDefault(), this.onDragLeaveTimeout.dispose(), o.P$.CurrentDragAndDropData && "vscode-ui" === o.P$.CurrentDragAndDropData.getData()) return !1;
                        if (this.setupDragAndDropScrollTopAnimation(e.browserEvent), !e.browserEvent.dataTransfer) return !1;
                        if (!this.currentDragData)
                            if (o.P$.CurrentDragAndDropData) this.currentDragData = o.P$.CurrentDragAndDropData;
                            else {
                                if (!e.browserEvent.dataTransfer.types) return !1;
                                this.currentDragData = new k
                            } const t = this.dnd.onDragOver(this.currentDragData, e.element, e.index, e.browserEvent);
                        if (this.canDrop = "boolean" == typeof t ? t : t.accept, !this.canDrop) return this.currentDragFeedback = void 0, this.currentDragFeedbackDisposable.dispose(), !1;
                        let i;
                        if (e.browserEvent.dataTransfer.dropEffect = "boolean" != typeof t && 0 === t.effect ? "copy" : "move", i = "boolean" != typeof t && t.feedback ? t.feedback : void 0 === e.index ? [-1] : [e.index], i = (0, c.EB)(i).filter((e => e >= -1 && e < this.length)).sort(((e, t) => e - t)), i = -1 === i[0] ? [-1] : i, n = this.currentDragFeedback, s = i, Array.isArray(n) && Array.isArray(s) ? (0, c.fS)(n, s) : n === s) return !0;
                        var n, s;
                        if (this.currentDragFeedback = i, this.currentDragFeedbackDisposable.dispose(), -1 === i[0]) this.domNode.classList.add("drop-target"), this.rowsContainer.classList.add("drop-target"), this.currentDragFeedbackDisposable = (0, g.OF)((() => {
                            this.domNode.classList.remove("drop-target"), this.rowsContainer.classList.remove("drop-target")
                        }));
                        else {
                            for (const e of i) {
                                const t = this.items[e];
                                t.dropTarget = !0, t.row && t.row.domNode.classList.add("drop-target")
                            }
                            this.currentDragFeedbackDisposable = (0, g.OF)((() => {
                                for (const e of i) {
                                    const t = this.items[e];
                                    t.dropTarget = !1, t.row && t.row.domNode.classList.remove("drop-target")
                                }
                            }))
                        }
                        return !0
                    }
                    onDragLeave(e) {
                        var t, i;
                        this.onDragLeaveTimeout.dispose(), this.onDragLeaveTimeout = (0, d.Vg)((() => this.clearDragOverFeedback()), 100), this.currentDragData && (null === (i = (t = this.dnd).onDragLeave) || void 0 === i || i.call(t, this.currentDragData, e.element, e.index, e.browserEvent))
                    }
                    onDrop(e) {
                        if (!this.canDrop) return;
                        const t = this.currentDragData;
                        this.teardownDragAndDropScrollTopAnimation(), this.clearDragOverFeedback(), this.currentDragData = void 0, o.P$.CurrentDragAndDropData = void 0, t && e.browserEvent.dataTransfer && (e.browserEvent.preventDefault(), t.update(e.browserEvent.dataTransfer), this.dnd.drop(t, e.element, e.index, e.browserEvent))
                    }
                    onDragEnd(e) {
                        this.canDrop = !1, this.teardownDragAndDropScrollTopAnimation(), this.clearDragOverFeedback(), this.currentDragData = void 0, o.P$.CurrentDragAndDropData = void 0, this.dnd.onDragEnd && this.dnd.onDragEnd(e)
                    }
                    clearDragOverFeedback() {
                        this.currentDragFeedback = void 0, this.currentDragFeedbackDisposable.dispose(), this.currentDragFeedbackDisposable = g.JT.None
                    }
                    setupDragAndDropScrollTopAnimation(e) {
                        if (!this.dragOverAnimationDisposable) {
                            const e = (0, s.xQ)(this.domNode).top;
                            this.dragOverAnimationDisposable = (0, s.jt)(this.animateDragAndDropScrollTop.bind(this, e))
                        }
                        this.dragOverAnimationStopDisposable.dispose(), this.dragOverAnimationStopDisposable = (0, d.Vg)((() => {
                            this.dragOverAnimationDisposable && (this.dragOverAnimationDisposable.dispose(), this.dragOverAnimationDisposable = void 0)
                        }), 1e3), this.dragOverMouseY = e.pageY
                    }
                    animateDragAndDropScrollTop(e) {
                        if (void 0 === this.dragOverMouseY) return;
                        const t = this.dragOverMouseY - e,
                            i = this.renderHeight - 35;
                        t < 35 ? this.scrollTop += Math.max(-14, Math.floor(.3 * (t - 35))) : t > i && (this.scrollTop += Math.min(14, Math.floor(.3 * (t - i))))
                    }
                    teardownDragAndDropScrollTopAnimation() {
                        this.dragOverAnimationStopDisposable.dispose(), this.dragOverAnimationDisposable && (this.dragOverAnimationDisposable.dispose(), this.dragOverAnimationDisposable = void 0)
                    }
                    getItemIndexFromEventTarget(e) {
                        const t = this.scrollableElement.getDomNode();
                        let i = e;
                        for (; i instanceof HTMLElement && i !== this.rowsContainer && t.contains(i);) {
                            const e = i.getAttribute("data-index");
                            if (e) {
                                const t = Number(e);
                                if (!isNaN(t)) return t
                            }
                            i = i.parentElement
                        }
                    }
                    getRenderRange(e, t) {
                        return {
                            start: this.rangeMap.indexAt(e),
                            end: this.rangeMap.indexAfter(e + t - 1)
                        }
                    }
                    _rerender(e, t, i) {
                        const n = this.getRenderRange(e, t);
                        let o, s;
                        e === this.elementTop(n.start) ? (o = n.start, s = 0) : n.end - n.start > 1 && (o = n.start + 1, s = this.elementTop(o) - e);
                        let r = 0;
                        for (;;) {
                            const a = this.getRenderRange(e, t);
                            let l = !1;
                            for (let e = a.start; e < a.end; e++) {
                                const t = this.probeDynamicHeight(e);
                                0 !== t && this.rangeMap.splice(e, 1, [this.items[e]]), r += t, l = l || 0 !== t
                            }
                            if (!l) {
                                0 !== r && this.eventuallyUpdateScrollDimensions();
                                const t = f.e.relativeComplement(n, a);
                                for (const e of t)
                                    for (let t = e.start; t < e.end; t++) this.items[t].row && this.removeItemFromDOM(t);
                                const l = f.e.relativeComplement(a, n);
                                for (const e of l)
                                    for (let t = e.start; t < e.end; t++) {
                                        const e = t + 1,
                                            i = e < this.items.length ? this.items[e].row : null,
                                            n = i ? i.domNode : null;
                                        this.insertItemInDOM(t, n)
                                    }
                                for (let e = a.start; e < a.end; e++) this.items[e].row && this.updateItemInDOM(this.items[e], e);
                                if ("number" == typeof o) {
                                    const t = this.scrollable.getFutureScrollPosition().scrollTop - e,
                                        n = this.elementTop(o) - s + t;
                                    this.setScrollTop(n, i)
                                }
                                return void this._onDidChangeContentHeight.fire(this.contentHeight)
                            }
                        }
                    }
                    probeDynamicHeight(e) {
                        const t = this.items[e];
                        if (this.virtualDelegate.getDynamicHeight) {
                            const e = this.virtualDelegate.getDynamicHeight(t.element);
                            if (null !== e) {
                                const i = t.size;
                                return t.size = e, t.lastDynamicHeightWidth = this.renderWidth, e - i
                            }
                        }
                        if (!t.hasDynamicHeight || t.lastDynamicHeightWidth === this.renderWidth) return 0;
                        if (this.virtualDelegate.hasDynamicHeight && !this.virtualDelegate.hasDynamicHeight(t.element)) return 0;
                        const i = t.size;
                        if (!this.setRowHeight && t.row) {
                            let e = t.row.domNode.offsetHeight;
                            return t.size = e, t.lastDynamicHeightWidth = this.renderWidth, e - i
                        }
                        const n = this.cache.alloc(t.templateId);
                        n.domNode.style.height = "", this.rowsContainer.appendChild(n.domNode);
                        const o = this.renderers.get(t.templateId);
                        return o && (o.renderElement(t.element, e, n.templateData, void 0), o.disposeElement && o.disposeElement(t.element, e, n.templateData, void 0)), t.size = n.domNode.offsetHeight, this.virtualDelegate.setDynamicHeight && this.virtualDelegate.setDynamicHeight(t.element, t.size), t.lastDynamicHeightWidth = this.renderWidth, this.rowsContainer.removeChild(n.domNode), this.cache.release(n), t.size - i
                    }
                    getNextToLastElement(e) {
                        const t = e[e.length - 1];
                        if (!t) return null;
                        const i = this.items[t.end];
                        return i && i.row ? i.row.domNode : null
                    }
                    getElementDomId(e) {
                        return `${this.domId}_${e}`
                    }
                    dispose() {
                        if (this.items) {
                            for (const e of this.items)
                                if (e.row) {
                                    const t = this.renderers.get(e.row.templateId);
                                    t && (t.disposeElement && t.disposeElement(e.element, -1, e.row.templateData, void 0), t.disposeTemplate(e.row.templateData))
                                } this.items = []
                        }
                        this.domNode && this.domNode.parentNode && this.domNode.parentNode.removeChild(this.domNode), (0, g.B9)(this.disposables)
                    }
                }
                N.InstanceCount = 0, y([h.H], N.prototype, "onMouseClick", null), y([h.H], N.prototype, "onMouseDblClick", null), y([h.H], N.prototype, "onMouseMiddleClick", null), y([h.H], N.prototype, "onMouseDown", null), y([h.H], N.prototype, "onContextMenu", null), y([h.H], N.prototype, "onTouchStart", null), y([h.H], N.prototype, "onTap", null)
            },
            43799: (e, t, i) => {
                "use strict";
                i.d(t, {
                    WK: () => M,
                    wD: () => V,
                    aV: () => q,
                    sx: () => B,
                    cK: () => I,
                    hD: () => E,
                    wn: () => R,
                    Zo: () => P
                });
                var n = i(65321),
                    o = i(4850),
                    s = i(59069),
                    r = i(10553),
                    a = i(85152);
                class l {
                    constructor(e) {
                        this.spliceables = e
                    }
                    splice(e, t, i) {
                        this.spliceables.forEach((n => n.splice(e, t, i)))
                    }
                }
                var c = i(9488),
                    d = i(15393),
                    h = i(41264),
                    u = i(49898),
                    g = i(4669),
                    p = i(75392),
                    f = i(5976),
                    m = i(59870),
                    v = i(36248),
                    _ = i(1432),
                    b = i(98401);
                i(60408);
                class w extends Error {
                    constructor(e, t) {
                        super(`ListError [${e}] ${t}`)
                    }
                }
                var y, C = i(25707),
                    x = function(e, t, i, n) {
                        var o, s = arguments.length,
                            r = s < 3 ? t : null === n ? n = Object.getOwnPropertyDescriptor(t, i) : n;
                        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(e, t, i, n);
                        else
                            for (var a = e.length - 1; a >= 0; a--)(o = e[a]) && (r = (s < 3 ? o(r) : s > 3 ? o(t, i, r) : o(t, i)) || r);
                        return s > 3 && r && Object.defineProperty(t, i, r), r
                    },
                    S = function(e, t, i, n) {
                        return new(i || (i = Promise))((function(o, s) {
                            function r(e) {
                                try {
                                    l(n.next(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function a(e) {
                                try {
                                    l(n.throw(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function l(e) {
                                var t;
                                e.done ? o(e.value) : (t = e.value, t instanceof i ? t : new i((function(e) {
                                    e(t)
                                }))).then(r, a)
                            }
                            l((n = n.apply(e, t || [])).next())
                        }))
                    };
                class k {
                    constructor(e) {
                        this.trait = e, this.renderedElements = []
                    }
                    get templateId() {
                        return `template:${this.trait.trait}`
                    }
                    renderTemplate(e) {
                        return e
                    }
                    renderElement(e, t, i) {
                        const n = this.renderedElements.findIndex((e => e.templateData === i));
                        if (n >= 0) {
                            const e = this.renderedElements[n];
                            this.trait.unrender(i), e.index = t
                        } else {
                            const e = {
                                index: t,
                                templateData: i
                            };
                            this.renderedElements.push(e)
                        }
                        this.trait.renderIndex(t, i)
                    }
                    splice(e, t, i) {
                        const n = [];
                        for (const o of this.renderedElements) o.index < e ? n.push(o) : o.index >= e + t && n.push({
                            index: o.index + i - t,
                            templateData: o.templateData
                        });
                        this.renderedElements = n
                    }
                    renderIndexes(e) {
                        for (const {
                                index: t,
                                templateData: i
                            } of this.renderedElements) e.indexOf(t) > -1 && this.trait.renderIndex(t, i)
                    }
                    disposeTemplate(e) {
                        const t = this.renderedElements.findIndex((t => t.templateData === e));
                        t < 0 || this.renderedElements.splice(t, 1)
                    }
                }
                class L {
                    constructor(e) {
                        this._trait = e, this.length = 0, this.indexes = [], this.sortedIndexes = [], this._onChange = new g.Q5, this.onChange = this._onChange.event
                    }
                    get trait() {
                        return this._trait
                    }
                    get renderer() {
                        return new k(this)
                    }
                    splice(e, t, i) {
                        var n;
                        t = Math.max(0, Math.min(t, this.length - e));
                        const o = i.length - t,
                            s = e + t,
                            r = [...this.sortedIndexes.filter((t => t < e)), ...i.map(((t, i) => t ? i + e : -1)).filter((e => -1 !== e)), ...this.sortedIndexes.filter((e => e >= s)).map((e => e + o))],
                            a = this.length + o;
                        if (this.sortedIndexes.length > 0 && 0 === r.length && a > 0) {
                            const t = null !== (n = this.sortedIndexes.find((t => t >= e))) && void 0 !== n ? n : a - 1;
                            r.push(Math.min(t, a - 1))
                        }
                        this.renderer.splice(e, t, i.length), this._set(r, r), this.length = a
                    }
                    renderIndex(e, t) {
                        t.classList.toggle(this._trait, this.contains(e))
                    }
                    unrender(e) {
                        e.classList.remove(this._trait)
                    }
                    set(e, t) {
                        return this._set(e, [...e].sort(j), t)
                    }
                    _set(e, t, i) {
                        const n = this.indexes,
                            o = this.sortedIndexes;
                        this.indexes = e, this.sortedIndexes = t;
                        const s = z(o, e);
                        return this.renderer.renderIndexes(s), this._onChange.fire({
                            indexes: e,
                            browserEvent: i
                        }), n
                    }
                    get() {
                        return this.indexes
                    }
                    contains(e) {
                        return (0, c.ry)(this.sortedIndexes, e, j) >= 0
                    }
                    dispose() {
                        (0, f.B9)(this._onChange)
                    }
                }
                x([u.H], L.prototype, "renderer", null);
                class N extends L {
                    constructor(e) {
                        super("selected"), this.setAriaSelected = e
                    }
                    renderIndex(e, t) {
                        super.renderIndex(e, t), this.setAriaSelected && (this.contains(e) ? t.setAttribute("aria-selected", "true") : t.setAttribute("aria-selected", "false"))
                    }
                }
                class D {
                    constructor(e, t, i) {
                        this.trait = e, this.view = t, this.identityProvider = i
                    }
                    splice(e, t, i) {
                        if (!this.identityProvider) return this.trait.splice(e, t, i.map((() => !1)));
                        const n = this.trait.get().map((e => this.identityProvider.getId(this.view.element(e)).toString())),
                            o = i.map((e => n.indexOf(this.identityProvider.getId(e).toString()) > -1));
                        this.trait.splice(e, t, o)
                    }
                }

                function I(e) {
                    return "INPUT" === e.tagName || "TEXTAREA" === e.tagName
                }

                function E(e) {
                    return !!e.classList.contains("monaco-editor") || !e.classList.contains("monaco-list") && (!!e.parentElement && E(e.parentElement))
                }
                class T {
                    constructor(e, t, i) {
                        this.list = e, this.view = t, this.disposables = new f.SL, this.multipleSelectionDisposables = new f.SL, this.onKeyDown.filter((e => 3 === e.keyCode)).on(this.onEnter, this, this.disposables), this.onKeyDown.filter((e => 16 === e.keyCode)).on(this.onUpArrow, this, this.disposables), this.onKeyDown.filter((e => 18 === e.keyCode)).on(this.onDownArrow, this, this.disposables), this.onKeyDown.filter((e => 11 === e.keyCode)).on(this.onPageUpArrow, this, this.disposables), this.onKeyDown.filter((e => 12 === e.keyCode)).on(this.onPageDownArrow, this, this.disposables), this.onKeyDown.filter((e => 9 === e.keyCode)).on(this.onEscape, this, this.disposables), !1 !== i.multipleSelectionSupport && this.onKeyDown.filter((e => (_.dz ? e.metaKey : e.ctrlKey) && 31 === e.keyCode)).on(this.onCtrlA, this, this.multipleSelectionDisposables)
                    }
                    get onKeyDown() {
                        return g.ju.chain(this.disposables.add(new o.Y(this.view.domNode, "keydown")).event).filter((e => !I(e.target))).map((e => new s.y(e)))
                    }
                    updateOptions(e) {
                        void 0 !== e.multipleSelectionSupport && (this.multipleSelectionDisposables.clear(), e.multipleSelectionSupport && this.onKeyDown.filter((e => (_.dz ? e.metaKey : e.ctrlKey) && 31 === e.keyCode)).on(this.onCtrlA, this, this.multipleSelectionDisposables))
                    }
                    onEnter(e) {
                        e.preventDefault(), e.stopPropagation(), this.list.setSelection(this.list.getFocus(), e.browserEvent)
                    }
                    onUpArrow(e) {
                        e.preventDefault(), e.stopPropagation(), this.list.focusPrevious(1, !1, e.browserEvent);
                        const t = this.list.getFocus()[0];
                        this.list.setAnchor(t), this.list.reveal(t), this.view.domNode.focus()
                    }
                    onDownArrow(e) {
                        e.preventDefault(), e.stopPropagation(), this.list.focusNext(1, !1, e.browserEvent);
                        const t = this.list.getFocus()[0];
                        this.list.setAnchor(t), this.list.reveal(t), this.view.domNode.focus()
                    }
                    onPageUpArrow(e) {
                        e.preventDefault(), e.stopPropagation(), this.list.focusPreviousPage(e.browserEvent);
                        const t = this.list.getFocus()[0];
                        this.list.setAnchor(t), this.list.reveal(t), this.view.domNode.focus()
                    }
                    onPageDownArrow(e) {
                        e.preventDefault(), e.stopPropagation(), this.list.focusNextPage(e.browserEvent);
                        const t = this.list.getFocus()[0];
                        this.list.setAnchor(t), this.list.reveal(t), this.view.domNode.focus()
                    }
                    onCtrlA(e) {
                        e.preventDefault(), e.stopPropagation(), this.list.setSelection((0, c.w6)(this.list.length), e.browserEvent), this.list.setAnchor(void 0), this.view.domNode.focus()
                    }
                    onEscape(e) {
                        this.list.getSelection().length && (e.preventDefault(), e.stopPropagation(), this.list.setSelection([], e.browserEvent), this.list.setAnchor(void 0), this.view.domNode.focus())
                    }
                    dispose() {
                        this.disposables.dispose(), this.multipleSelectionDisposables.dispose()
                    }
                }
                x([u.H], T.prototype, "onKeyDown", null),
                    function(e) {
                        e[e.Idle = 0] = "Idle", e[e.Typing = 1] = "Typing"
                    }(y || (y = {}));
                const M = new class {
                    mightProducePrintableCharacter(e) {
                        return !(e.ctrlKey || e.metaKey || e.altKey) && (e.keyCode >= 31 && e.keyCode <= 56 || e.keyCode >= 21 && e.keyCode <= 30 || e.keyCode >= 93 && e.keyCode <= 102 || e.keyCode >= 80 && e.keyCode <= 90)
                    }
                };
                class A {
                    constructor(e, t, i, n) {
                        this.list = e, this.view = t, this.keyboardNavigationLabelProvider = i, this.delegate = n, this.enabled = !1, this.state = y.Idle, this.automaticKeyboardNavigation = !0, this.triggered = !1, this.previouslyFocused = -1, this.enabledDisposables = new f.SL, this.disposables = new f.SL, this.updateOptions(e.options)
                    }
                    updateOptions(e) {
                        void 0 === e.enableKeyboardNavigation || !!e.enableKeyboardNavigation ? this.enable() : this.disable(), void 0 !== e.automaticKeyboardNavigation && (this.automaticKeyboardNavigation = e.automaticKeyboardNavigation)
                    }
                    enable() {
                        if (this.enabled) return;
                        const e = g.ju.chain(this.enabledDisposables.add(new o.Y(this.view.domNode, "keydown")).event).filter((e => !I(e.target))).filter((() => this.automaticKeyboardNavigation || this.triggered)).map((e => new s.y(e))).filter((e => this.delegate.mightProducePrintableCharacter(e))).forEach((e => {
                                e.stopPropagation(), e.preventDefault()
                            })).map((e => e.browserEvent.key)).event,
                            t = g.ju.debounce(e, (() => null), 800);
                        g.ju.reduce(g.ju.any(e, t), ((e, t) => null === t ? null : (e || "") + t))(this.onInput, this, this.enabledDisposables), t(this.onClear, this, this.enabledDisposables), this.enabled = !0, this.triggered = !1
                    }
                    disable() {
                        this.enabled && (this.enabledDisposables.clear(), this.enabled = !1, this.triggered = !1)
                    }
                    onClear() {
                        var e;
                        const t = this.list.getFocus();
                        if (t.length > 0 && t[0] === this.previouslyFocused) {
                            const i = null === (e = this.list.options.accessibilityProvider) || void 0 === e ? void 0 : e.getAriaLabel(this.list.element(t[0]));
                            i && (0, a.Z9)(i)
                        }
                        this.previouslyFocused = -1
                    }
                    onInput(e) {
                        if (!e) return this.state = y.Idle, void(this.triggered = !1);
                        const t = this.list.getFocus(),
                            i = t.length > 0 ? t[0] : 0,
                            n = this.state === y.Idle ? 1 : 0;
                        this.state = y.Typing;
                        for (let t = 0; t < this.list.length; t++) {
                            const o = (i + t + n) % this.list.length,
                                s = this.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(this.view.element(o)),
                                r = s && s.toString();
                            if (void 0 === r || (0, p.Ji)(e, r)) return this.previouslyFocused = i, this.list.setFocus([o]), void this.list.reveal(o)
                        }
                    }
                    dispose() {
                        this.disable(), this.enabledDisposables.dispose(), this.disposables.dispose()
                    }
                }
                class O {
                    constructor(e, t) {
                        this.list = e, this.view = t, this.disposables = new f.SL;
                        g.ju.chain(this.disposables.add(new o.Y(t.domNode, "keydown")).event).filter((e => !I(e.target))).map((e => new s.y(e))).filter((e => !(2 !== e.keyCode || e.ctrlKey || e.metaKey || e.shiftKey || e.altKey))).on(this.onTab, this, this.disposables)
                    }
                    onTab(e) {
                        if (e.target !== this.view.domNode) return;
                        const t = this.list.getFocus();
                        if (0 === t.length) return;
                        const i = this.view.domElement(t[0]);
                        if (!i) return;
                        const n = i.querySelector("[tabIndex]");
                        if (!(n && n instanceof HTMLElement && -1 !== n.tabIndex)) return;
                        const o = window.getComputedStyle(n);
                        "hidden" !== o.visibility && "none" !== o.display && (e.preventDefault(), e.stopPropagation(), n.focus())
                    }
                    dispose() {
                        this.disposables.dispose()
                    }
                }

                function P(e) {
                    return _.dz ? e.browserEvent.metaKey : e.browserEvent.ctrlKey
                }

                function R(e) {
                    return e.browserEvent.shiftKey
                }
                const F = {
                    isSelectionSingleChangeEvent: P,
                    isSelectionRangeChangeEvent: R
                };
                class B {
                    constructor(e) {
                        this.list = e, this.disposables = new f.SL, this._onPointer = new g.Q5, this.onPointer = this._onPointer.event, !1 !== e.options.multipleSelectionSupport && (this.multipleSelectionController = this.list.options.multipleSelectionController || F), this.mouseSupport = void 0 === e.options.mouseSupport || !!e.options.mouseSupport, this.mouseSupport && (e.onMouseDown(this.onMouseDown, this, this.disposables), e.onContextMenu(this.onContextMenu, this, this.disposables), e.onMouseDblClick(this.onDoubleClick, this, this.disposables), e.onTouchStart(this.onMouseDown, this, this.disposables), this.disposables.add(r.o.addTarget(e.getHTMLElement()))), g.ju.any(e.onMouseClick, e.onMouseMiddleClick, e.onTap)(this.onViewPointer, this, this.disposables)
                    }
                    updateOptions(e) {
                        void 0 !== e.multipleSelectionSupport && (this.multipleSelectionController = void 0, e.multipleSelectionSupport && (this.multipleSelectionController = this.list.options.multipleSelectionController || F))
                    }
                    isSelectionSingleChangeEvent(e) {
                        return !!this.multipleSelectionController && this.multipleSelectionController.isSelectionSingleChangeEvent(e)
                    }
                    isSelectionRangeChangeEvent(e) {
                        return !!this.multipleSelectionController && this.multipleSelectionController.isSelectionRangeChangeEvent(e)
                    }
                    isSelectionChangeEvent(e) {
                        return this.isSelectionSingleChangeEvent(e) || this.isSelectionRangeChangeEvent(e)
                    }
                    onMouseDown(e) {
                        E(e.browserEvent.target) || document.activeElement !== e.browserEvent.target && this.list.domFocus()
                    }
                    onContextMenu(e) {
                        if (E(e.browserEvent.target)) return;
                        const t = void 0 === e.index ? [] : [e.index];
                        this.list.setFocus(t, e.browserEvent)
                    }
                    onViewPointer(e) {
                        if (!this.mouseSupport) return;
                        if (I(e.browserEvent.target) || E(e.browserEvent.target)) return;
                        const t = e.index;
                        return void 0 === t ? (this.list.setFocus([], e.browserEvent), this.list.setSelection([], e.browserEvent), void this.list.setAnchor(void 0)) : this.isSelectionRangeChangeEvent(e) || this.isSelectionChangeEvent(e) ? this.changeSelection(e) : (this.list.setFocus([t], e.browserEvent), this.list.setAnchor(t), (i = e.browserEvent) instanceof MouseEvent && 2 === i.button || this.list.setSelection([t], e.browserEvent), void this._onPointer.fire(e));
                        var i
                    }
                    onDoubleClick(e) {
                        if (I(e.browserEvent.target) || E(e.browserEvent.target)) return;
                        if (this.isSelectionChangeEvent(e)) return;
                        const t = this.list.getFocus();
                        this.list.setSelection(t, e.browserEvent)
                    }
                    changeSelection(e) {
                        const t = e.index;
                        let i = this.list.getAnchor();
                        if (this.isSelectionRangeChangeEvent(e)) {
                            if (void 0 === i) {
                                const e = this.list.getFocus()[0];
                                i = null != e ? e : t, this.list.setAnchor(i)
                            }
                            const n = Math.min(i, t),
                                o = Math.max(i, t),
                                s = (0, c.w6)(n, o + 1),
                                r = this.list.getSelection(),
                                a = function(e, t) {
                                    const i = e.indexOf(t);
                                    if (-1 === i) return [];
                                    const n = [];
                                    let o = i - 1;
                                    for (; o >= 0 && e[o] === t - (i - o);) n.push(e[o--]);
                                    n.reverse(), o = i;
                                    for (; o < e.length && e[o] === t + (o - i);) n.push(e[o++]);
                                    return n
                                }(z(r, [i]), i);
                            if (0 === a.length) return;
                            const l = z(s, function(e, t) {
                                const i = [];
                                let n = 0,
                                    o = 0;
                                for (; n < e.length || o < t.length;)
                                    if (n >= e.length) i.push(t[o++]);
                                    else if (o >= t.length) i.push(e[n++]);
                                else {
                                    if (e[n] === t[o]) {
                                        n++, o++;
                                        continue
                                    }
                                    e[n] < t[o] ? i.push(e[n++]) : o++
                                }
                                return i
                            }(r, a));
                            this.list.setSelection(l, e.browserEvent), this.list.setFocus([t], e.browserEvent)
                        } else if (this.isSelectionSingleChangeEvent(e)) {
                            const i = this.list.getSelection(),
                                n = i.filter((e => e !== t));
                            this.list.setFocus([t]), this.list.setAnchor(t), i.length === n.length ? this.list.setSelection([...n, t], e.browserEvent) : this.list.setSelection(n, e.browserEvent)
                        }
                    }
                    dispose() {
                        this.disposables.dispose()
                    }
                }
                class V {
                    constructor(e, t) {
                        this.styleElement = e, this.selectorSuffix = t
                    }
                    style(e) {
                        const t = this.selectorSuffix && `.${this.selectorSuffix}`,
                            i = [];
                        e.listBackground && (e.listBackground.isOpaque() ? i.push(`.monaco-list${t} .monaco-list-rows { background: ${e.listBackground}; }`) : _.dz || console.warn(`List with id '${this.selectorSuffix}' was styled with a non-opaque background color. This will break sub-pixel antialiasing.`)), e.listFocusBackground && (i.push(`.monaco-list${t}:focus .monaco-list-row.focused { background-color: ${e.listFocusBackground}; }`), i.push(`.monaco-list${t}:focus .monaco-list-row.focused:hover { background-color: ${e.listFocusBackground}; }`)), e.listFocusForeground && i.push(`.monaco-list${t}:focus .monaco-list-row.focused { color: ${e.listFocusForeground}; }`), e.listActiveSelectionBackground && (i.push(`.monaco-list${t}:focus .monaco-list-row.selected { background-color: ${e.listActiveSelectionBackground}; }`), i.push(`.monaco-list${t}:focus .monaco-list-row.selected:hover { background-color: ${e.listActiveSelectionBackground}; }`)), e.listActiveSelectionForeground && i.push(`.monaco-list${t}:focus .monaco-list-row.selected { color: ${e.listActiveSelectionForeground}; }`), e.listActiveSelectionIconForeground && i.push(`.monaco-list${t}:focus .monaco-list-row.selected .codicon { color: ${e.listActiveSelectionIconForeground}; }`), e.listFocusAndSelectionBackground && i.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${t}:focus .monaco-list-row.selected.focused { background-color: ${e.listFocusAndSelectionBackground}; }\n\t\t\t`), e.listFocusAndSelectionForeground && i.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${t}:focus .monaco-list-row.selected.focused { color: ${e.listFocusAndSelectionForeground}; }\n\t\t\t`), e.listInactiveFocusForeground && (i.push(`.monaco-list${t} .monaco-list-row.focused { color:  ${e.listInactiveFocusForeground}; }`), i.push(`.monaco-list${t} .monaco-list-row.focused:hover { color:  ${e.listInactiveFocusForeground}; }`)), e.listInactiveSelectionIconForeground && i.push(`.monaco-list${t} .monaco-list-row.focused .codicon { color:  ${e.listInactiveSelectionIconForeground}; }`), e.listInactiveFocusBackground && (i.push(`.monaco-list${t} .monaco-list-row.focused { background-color:  ${e.listInactiveFocusBackground}; }`), i.push(`.monaco-list${t} .monaco-list-row.focused:hover { background-color:  ${e.listInactiveFocusBackground}; }`)), e.listInactiveSelectionBackground && (i.push(`.monaco-list${t} .monaco-list-row.selected { background-color:  ${e.listInactiveSelectionBackground}; }`), i.push(`.monaco-list${t} .monaco-list-row.selected:hover { background-color:  ${e.listInactiveSelectionBackground}; }`)), e.listInactiveSelectionForeground && i.push(`.monaco-list${t} .monaco-list-row.selected { color: ${e.listInactiveSelectionForeground}; }`), e.listHoverBackground && i.push(`.monaco-list${t}:not(.drop-target) .monaco-list-row:hover:not(.selected):not(.focused) { background-color: ${e.listHoverBackground}; }`), e.listHoverForeground && i.push(`.monaco-list${t} .monaco-list-row:hover:not(.selected):not(.focused) { color:  ${e.listHoverForeground}; }`), e.listSelectionOutline && i.push(`.monaco-list${t} .monaco-list-row.selected { outline: 1px dotted ${e.listSelectionOutline}; outline-offset: -1px; }`), e.listFocusOutline && i.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${t}:focus .monaco-list-row.focused { outline: 1px solid ${e.listFocusOutline}; outline-offset: -1px; }\n\t\t\t`), e.listInactiveFocusOutline && i.push(`.monaco-list${t} .monaco-list-row.focused { outline: 1px dotted ${e.listInactiveFocusOutline}; outline-offset: -1px; }`), e.listHoverOutline && i.push(`.monaco-list${t} .monaco-list-row:hover { outline: 1px dashed ${e.listHoverOutline}; outline-offset: -1px; }`), e.listDropBackground && i.push(`\n\t\t\t\t.monaco-list${t}.drop-target,\n\t\t\t\t.monaco-list${t} .monaco-list-rows.drop-target,\n\t\t\t\t.monaco-list${t} .monaco-list-row.drop-target { background-color: ${e.listDropBackground} !important; color: inherit !important; }\n\t\t\t`), e.listFilterWidgetBackground && i.push(`.monaco-list-type-filter { background-color: ${e.listFilterWidgetBackground} }`), e.listFilterWidgetOutline && i.push(`.monaco-list-type-filter { border: 1px solid ${e.listFilterWidgetOutline}; }`), e.listFilterWidgetNoMatchesOutline && i.push(`.monaco-list-type-filter.no-matches { border: 1px solid ${e.listFilterWidgetNoMatchesOutline}; }`), e.listMatchesShadow && i.push(`.monaco-list-type-filter { box-shadow: 1px 1px 1px ${e.listMatchesShadow}; }`), e.tableColumnsBorder && i.push(`\n\t\t\t\t.monaco-table:hover > .monaco-split-view2,\n\t\t\t\t.monaco-table:hover > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\t\t\tborder-color: ${e.tableColumnsBorder};\n\t\t\t}`), this.styleElement.textContent = i.join("\n")
                    }
                }
                const W = {
                        listFocusBackground: h.Il.fromHex("#7FB0D0"),
                        listActiveSelectionBackground: h.Il.fromHex("#0E639C"),
                        listActiveSelectionForeground: h.Il.fromHex("#FFFFFF"),
                        listActiveSelectionIconForeground: h.Il.fromHex("#FFFFFF"),
                        listFocusAndSelectionBackground: h.Il.fromHex("#094771"),
                        listFocusAndSelectionForeground: h.Il.fromHex("#FFFFFF"),
                        listInactiveSelectionBackground: h.Il.fromHex("#3F3F46"),
                        listInactiveSelectionIconForeground: h.Il.fromHex("#FFFFFF"),
                        listHoverBackground: h.Il.fromHex("#2A2D2E"),
                        listDropBackground: h.Il.fromHex("#383B3D"),
                        treeIndentGuidesStroke: h.Il.fromHex("#a9a9a9"),
                        tableColumnsBorder: h.Il.fromHex("#cccccc").transparent(.2)
                    },
                    H = {
                        keyboardSupport: !0,
                        mouseSupport: !0,
                        multipleSelectionSupport: !0,
                        dnd: {
                            getDragURI: () => null,
                            onDragStart() {},
                            onDragOver: () => !1,
                            drop() {}
                        }
                    };

                function z(e, t) {
                    const i = [];
                    let n = 0,
                        o = 0;
                    for (; n < e.length || o < t.length;)
                        if (n >= e.length) i.push(t[o++]);
                        else if (o >= t.length) i.push(e[n++]);
                    else {
                        if (e[n] === t[o]) {
                            i.push(e[n]), n++, o++;
                            continue
                        }
                        e[n] < t[o] ? i.push(e[n++]) : i.push(t[o++])
                    }
                    return i
                }
                const j = (e, t) => e - t;
                class U {
                    constructor(e, t) {
                        this._templateId = e, this.renderers = t
                    }
                    get templateId() {
                        return this._templateId
                    }
                    renderTemplate(e) {
                        return this.renderers.map((t => t.renderTemplate(e)))
                    }
                    renderElement(e, t, i, n) {
                        let o = 0;
                        for (const s of this.renderers) s.renderElement(e, t, i[o++], n)
                    }
                    disposeElement(e, t, i, n) {
                        let o = 0;
                        for (const s of this.renderers) s.disposeElement && s.disposeElement(e, t, i[o], n), o += 1
                    }
                    disposeTemplate(e) {
                        let t = 0;
                        for (const i of this.renderers) i.disposeTemplate(e[t++])
                    }
                }
                class $ {
                    constructor(e) {
                        this.accessibilityProvider = e, this.templateId = "a18n"
                    }
                    renderTemplate(e) {
                        return e
                    }
                    renderElement(e, t, i) {
                        const n = this.accessibilityProvider.getAriaLabel(e);
                        n ? i.setAttribute("aria-label", n) : i.removeAttribute("aria-label");
                        const o = this.accessibilityProvider.getAriaLevel && this.accessibilityProvider.getAriaLevel(e);
                        "number" == typeof o ? i.setAttribute("aria-level", `${o}`) : i.removeAttribute("aria-level")
                    }
                    disposeTemplate(e) {}
                }
                class K {
                    constructor(e, t) {
                        this.list = e, this.dnd = t
                    }
                    getDragElements(e) {
                        const t = this.list.getSelectedElements();
                        return t.indexOf(e) > -1 ? t : [e]
                    }
                    getDragURI(e) {
                        return this.dnd.getDragURI(e)
                    }
                    getDragLabel(e, t) {
                        if (this.dnd.getDragLabel) return this.dnd.getDragLabel(e, t)
                    }
                    onDragStart(e, t) {
                        this.dnd.onDragStart && this.dnd.onDragStart(e, t)
                    }
                    onDragOver(e, t, i, n) {
                        return this.dnd.onDragOver(e, t, i, n)
                    }
                    onDragLeave(e, t, i, n) {
                        var o, s;
                        null === (s = (o = this.dnd).onDragLeave) || void 0 === s || s.call(o, e, t, i, n)
                    }
                    onDragEnd(e) {
                        this.dnd.onDragEnd && this.dnd.onDragEnd(e)
                    }
                    drop(e, t, i, n) {
                        this.dnd.drop(e, t, i, n)
                    }
                }
                class q {
                    constructor(e, t, i, o, s = H) {
                        var r;
                        this.user = e, this._options = s, this.focus = new L("focused"), this.anchor = new L("anchor"), this.eventBufferer = new g.E7, this._ariaLabel = "", this.disposables = new f.SL, this._onDidDispose = new g.Q5, this.onDidDispose = this._onDidDispose.event;
                        const a = this._options.accessibilityProvider && this._options.accessibilityProvider.getWidgetRole ? null === (r = this._options.accessibilityProvider) || void 0 === r ? void 0 : r.getWidgetRole() : "list";
                        this.selection = new N("listbox" !== a), (0, v.jB)(s, W, !1);
                        const c = [this.focus.renderer, this.selection.renderer];
                        this.accessibilityProvider = s.accessibilityProvider, this.accessibilityProvider && (c.push(new $(this.accessibilityProvider)), this.accessibilityProvider.onDidChangeActiveDescendant && this.accessibilityProvider.onDidChangeActiveDescendant(this.onDidChangeActiveDescendant, this, this.disposables)), o = o.map((e => new U(e.templateId, [...c, e])));
                        const d = Object.assign(Object.assign({}, s), {
                            dnd: s.dnd && new K(this, s.dnd)
                        });
                        if (this.view = new C.Bv(t, i, o, d), this.view.domNode.setAttribute("role", a), s.styleController) this.styleController = s.styleController(this.view.domId);
                        else {
                            const e = (0, n.dS)(this.view.domNode);
                            this.styleController = new V(e, this.view.domId)
                        }
                        if (this.spliceable = new l([new D(this.focus, this.view, s.identityProvider), new D(this.selection, this.view, s.identityProvider), new D(this.anchor, this.view, s.identityProvider), this.view]), this.disposables.add(this.focus), this.disposables.add(this.selection), this.disposables.add(this.anchor), this.disposables.add(this.view), this.disposables.add(this._onDidDispose), this.disposables.add(new O(this, this.view)), ("boolean" != typeof s.keyboardSupport || s.keyboardSupport) && (this.keyboardController = new T(this, this.view, s), this.disposables.add(this.keyboardController)), s.keyboardNavigationLabelProvider) {
                            const e = s.keyboardNavigationDelegate || M;
                            this.typeLabelController = new A(this, this.view, s.keyboardNavigationLabelProvider, e), this.disposables.add(this.typeLabelController)
                        }
                        this.mouseController = this.createMouseController(s), this.disposables.add(this.mouseController), this.onDidChangeFocus(this._onFocusChange, this, this.disposables), this.onDidChangeSelection(this._onSelectionChange, this, this.disposables), this.accessibilityProvider && (this.ariaLabel = this.accessibilityProvider.getWidgetAriaLabel()), !1 !== this._options.multipleSelectionSupport && this.view.domNode.setAttribute("aria-multiselectable", "true")
                    }
                    get onDidChangeFocus() {
                        return g.ju.map(this.eventBufferer.wrapEvent(this.focus.onChange), (e => this.toListEvent(e)))
                    }
                    get onDidChangeSelection() {
                        return g.ju.map(this.eventBufferer.wrapEvent(this.selection.onChange), (e => this.toListEvent(e)))
                    }
                    get domId() {
                        return this.view.domId
                    }
                    get onMouseClick() {
                        return this.view.onMouseClick
                    }
                    get onMouseDblClick() {
                        return this.view.onMouseDblClick
                    }
                    get onMouseMiddleClick() {
                        return this.view.onMouseMiddleClick
                    }
                    get onPointer() {
                        return this.mouseController.onPointer
                    }
                    get onMouseDown() {
                        return this.view.onMouseDown
                    }
                    get onTouchStart() {
                        return this.view.onTouchStart
                    }
                    get onTap() {
                        return this.view.onTap
                    }
                    get onContextMenu() {
                        let e = !1;
                        const t = g.ju.chain(this.disposables.add(new o.Y(this.view.domNode, "keydown")).event).map((e => new s.y(e))).filter((t => e = 58 === t.keyCode || t.shiftKey && 68 === t.keyCode)).map(o.p).filter((() => !1)).event,
                            i = g.ju.chain(this.disposables.add(new o.Y(this.view.domNode, "keyup")).event).forEach((() => e = !1)).map((e => new s.y(e))).filter((e => 58 === e.keyCode || e.shiftKey && 68 === e.keyCode)).map(o.p).map((({
                                browserEvent: e
                            }) => {
                                const t = this.getFocus(),
                                    i = t.length ? t[0] : void 0;
                                return {
                                    index: i,
                                    element: void 0 !== i ? this.view.element(i) : void 0,
                                    anchor: void 0 !== i ? this.view.domElement(i) : this.view.domNode,
                                    browserEvent: e
                                }
                            })).event,
                            n = g.ju.chain(this.view.onContextMenu).filter((t => !e)).map((({
                                element: e,
                                index: t,
                                browserEvent: i
                            }) => ({
                                element: e,
                                index: t,
                                anchor: {
                                    x: i.pageX + 1,
                                    y: i.pageY
                                },
                                browserEvent: i
                            }))).event;
                        return g.ju.any(t, i, n)
                    }
                    get onKeyDown() {
                        return this.disposables.add(new o.Y(this.view.domNode, "keydown")).event
                    }
                    get onDidFocus() {
                        return g.ju.signal(this.disposables.add(new o.Y(this.view.domNode, "focus", !0)).event)
                    }
                    createMouseController(e) {
                        return new B(this)
                    }
                    updateOptions(e = {}) {
                        var t;
                        this._options = Object.assign(Object.assign({}, this._options), e), this.typeLabelController && this.typeLabelController.updateOptions(this._options), void 0 !== this._options.multipleSelectionController && (this._options.multipleSelectionSupport ? this.view.domNode.setAttribute("aria-multiselectable", "true") : this.view.domNode.removeAttribute("aria-multiselectable")), this.mouseController.updateOptions(e), null === (t = this.keyboardController) || void 0 === t || t.updateOptions(e), this.view.updateOptions(e)
                    }
                    get options() {
                        return this._options
                    }
                    splice(e, t, i = []) {
                        if (e < 0 || e > this.view.length) throw new w(this.user, `Invalid start index: ${e}`);
                        if (t < 0) throw new w(this.user, `Invalid delete count: ${t}`);
                        0 === t && 0 === i.length || this.eventBufferer.bufferEvents((() => this.spliceable.splice(e, t, i)))
                    }
                    rerender() {
                        this.view.rerender()
                    }
                    element(e) {
                        return this.view.element(e)
                    }
                    get length() {
                        return this.view.length
                    }
                    get contentHeight() {
                        return this.view.contentHeight
                    }
                    get scrollTop() {
                        return this.view.getScrollTop()
                    }
                    set scrollTop(e) {
                        this.view.setScrollTop(e)
                    }
                    get ariaLabel() {
                        return this._ariaLabel
                    }
                    set ariaLabel(e) {
                        this._ariaLabel = e, this.view.domNode.setAttribute("aria-label", e)
                    }
                    domFocus() {
                        this.view.domNode.focus({
                            preventScroll: !0
                        })
                    }
                    layout(e, t) {
                        this.view.layout(e, t)
                    }
                    setSelection(e, t) {
                        for (const t of e)
                            if (t < 0 || t >= this.length) throw new w(this.user, `Invalid index ${t}`);
                        this.selection.set(e, t)
                    }
                    getSelection() {
                        return this.selection.get()
                    }
                    getSelectedElements() {
                        return this.getSelection().map((e => this.view.element(e)))
                    }
                    setAnchor(e) {
                        if (void 0 !== e) {
                            if (e < 0 || e >= this.length) throw new w(this.user, `Invalid index ${e}`);
                            this.anchor.set([e])
                        } else this.anchor.set([])
                    }
                    getAnchor() {
                        return (0, c.Xh)(this.anchor.get(), void 0)
                    }
                    getAnchorElement() {
                        const e = this.getAnchor();
                        return void 0 === e ? void 0 : this.element(e)
                    }
                    setFocus(e, t) {
                        for (const t of e)
                            if (t < 0 || t >= this.length) throw new w(this.user, `Invalid index ${t}`);
                        this.focus.set(e, t)
                    }
                    focusNext(e = 1, t = !1, i, n) {
                        if (0 === this.length) return;
                        const o = this.focus.get(),
                            s = this.findNextIndex(o.length > 0 ? o[0] + e : 0, t, n);
                        s > -1 && this.setFocus([s], i)
                    }
                    focusPrevious(e = 1, t = !1, i, n) {
                        if (0 === this.length) return;
                        const o = this.focus.get(),
                            s = this.findPreviousIndex(o.length > 0 ? o[0] - e : 0, t, n);
                        s > -1 && this.setFocus([s], i)
                    }
                    focusNextPage(e, t) {
                        return S(this, void 0, void 0, (function*() {
                            let i = this.view.indexAt(this.view.getScrollTop() + this.view.renderHeight);
                            i = 0 === i ? 0 : i - 1;
                            const n = this.view.element(i),
                                o = this.getFocusedElements()[0];
                            if (o !== n) {
                                const n = this.findPreviousIndex(i, !1, t);
                                n > -1 && o !== this.view.element(n) ? this.setFocus([n], e) : this.setFocus([i], e)
                            } else {
                                const n = this.view.getScrollTop();
                                this.view.setScrollTop(n + this.view.renderHeight - this.view.elementHeight(i)), this.view.getScrollTop() !== n && (this.setFocus([]), yield(0, d.Vs)(0), yield this.focusNextPage(e, t))
                            }
                        }))
                    }
                    focusPreviousPage(e, t) {
                        return S(this, void 0, void 0, (function*() {
                            let i;
                            const n = this.view.getScrollTop();
                            i = 0 === n ? this.view.indexAt(n) : this.view.indexAfter(n - 1);
                            const o = this.view.element(i),
                                s = this.getFocusedElements()[0];
                            if (s !== o) {
                                const n = this.findNextIndex(i, !1, t);
                                n > -1 && s !== this.view.element(n) ? this.setFocus([n], e) : this.setFocus([i], e)
                            } else {
                                const i = n;
                                this.view.setScrollTop(n - this.view.renderHeight), this.view.getScrollTop() !== i && (this.setFocus([]), yield(0, d.Vs)(0), yield this.focusPreviousPage(e, t))
                            }
                        }))
                    }
                    focusLast(e, t) {
                        if (0 === this.length) return;
                        const i = this.findPreviousIndex(this.length - 1, !1, t);
                        i > -1 && this.setFocus([i], e)
                    }
                    focusFirst(e, t) {
                        this.focusNth(0, e, t)
                    }
                    focusNth(e, t, i) {
                        if (0 === this.length) return;
                        const n = this.findNextIndex(e, !1, i);
                        n > -1 && this.setFocus([n], t)
                    }
                    findNextIndex(e, t = !1, i) {
                        for (let n = 0; n < this.length; n++) {
                            if (e >= this.length && !t) return -1;
                            if (e %= this.length, !i || i(this.element(e))) return e;
                            e++
                        }
                        return -1
                    }
                    findPreviousIndex(e, t = !1, i) {
                        for (let n = 0; n < this.length; n++) {
                            if (e < 0 && !t) return -1;
                            if (e = (this.length + e % this.length) % this.length, !i || i(this.element(e))) return e;
                            e--
                        }
                        return -1
                    }
                    getFocus() {
                        return this.focus.get()
                    }
                    getFocusedElements() {
                        return this.getFocus().map((e => this.view.element(e)))
                    }
                    reveal(e, t) {
                        if (e < 0 || e >= this.length) throw new w(this.user, `Invalid index ${e}`);
                        const i = this.view.getScrollTop(),
                            n = this.view.elementTop(e),
                            o = this.view.elementHeight(e);
                        if ((0, b.hj)(t)) {
                            const e = o - this.view.renderHeight;
                            this.view.setScrollTop(e * (0, m.u)(t, 0, 1) + n)
                        } else {
                            const e = n + o,
                                t = i + this.view.renderHeight;
                            n < i && e >= t || (n < i || e >= t && o >= this.view.renderHeight ? this.view.setScrollTop(n) : e >= t && this.view.setScrollTop(e - this.view.renderHeight))
                        }
                    }
                    getRelativeTop(e) {
                        if (e < 0 || e >= this.length) throw new w(this.user, `Invalid index ${e}`);
                        const t = this.view.getScrollTop(),
                            i = this.view.elementTop(e),
                            n = this.view.elementHeight(e);
                        if (i < t || i + n > t + this.view.renderHeight) return null;
                        const o = n - this.view.renderHeight;
                        return Math.abs((t - i) / o)
                    }
                    getHTMLElement() {
                        return this.view.domNode
                    }
                    style(e) {
                        this.styleController.style(e)
                    }
                    toListEvent({
                        indexes: e,
                        browserEvent: t
                    }) {
                        return {
                            indexes: e,
                            elements: e.map((e => this.view.element(e))),
                            browserEvent: t
                        }
                    }
                    _onFocusChange() {
                        const e = this.focus.get();
                        this.view.domNode.classList.toggle("element-focused", e.length > 0), this.onDidChangeActiveDescendant()
                    }
                    onDidChangeActiveDescendant() {
                        var e;
                        const t = this.focus.get();
                        if (t.length > 0) {
                            let i;
                            (null === (e = this.accessibilityProvider) || void 0 === e ? void 0 : e.getActiveDescendantId) && (i = this.accessibilityProvider.getActiveDescendantId(this.view.element(t[0]))), this.view.domNode.setAttribute("aria-activedescendant", i || this.view.getElementDomId(t[0]))
                        } else this.view.domNode.removeAttribute("aria-activedescendant")
                    }
                    _onSelectionChange() {
                        const e = this.selection.get();
                        this.view.domNode.classList.toggle("selection-none", 0 === e.length), this.view.domNode.classList.toggle("selection-single", 1 === e.length), this.view.domNode.classList.toggle("selection-multiple", e.length > 1)
                    }
                    dispose() {
                        this._onDidDispose.fire(), this.disposables.dispose(), this._onDidDispose.dispose()
                    }
                }
                x([u.H], q.prototype, "onDidChangeFocus", null), x([u.H], q.prototype, "onDidChangeSelection", null), x([u.H], q.prototype, "onContextMenu", null), x([u.H], q.prototype, "onKeyDown", null), x([u.H], q.prototype, "onDidFocus", null)
            },
            96542: (e, t, i) => {
                "use strict";
                i.d(t, {
                    S: () => n
                });
                i(44156);
                const n = "monaco-mouse-cursor-text"
            },
            73098: (e, t, i) => {
                "use strict";
                i.d(t, {
                    g: () => _,
                    l: () => u
                });
                var n = i(65321),
                    o = i(4850),
                    s = i(10553),
                    r = i(15393),
                    a = i(49898),
                    l = i(4669),
                    c = i(5976),
                    d = i(1432),
                    h = (i(44118), function(e, t, i, n) {
                        var o, s = arguments.length,
                            r = s < 3 ? t : null === n ? n = Object.getOwnPropertyDescriptor(t, i) : n;
                        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(e, t, i, n);
                        else
                            for (var a = e.length - 1; a >= 0; a--)(o = e[a]) && (r = (s < 3 ? o(r) : s > 3 ? o(t, i, r) : o(t, i)) || r);
                        return s > 3 && r && Object.defineProperty(t, i, r), r
                    });
                var u;
                ! function(e) {
                    e.North = "north", e.South = "south", e.East = "east", e.West = "west"
                }(u || (u = {}));
                const g = new l.Q5;
                const p = new l.Q5;
                class f {
                    constructor() {
                        this.disposables = new c.SL
                    }
                    get onPointerMove() {
                        return this.disposables.add(new o.Y(window, "mousemove")).event
                    }
                    get onPointerUp() {
                        return this.disposables.add(new o.Y(window, "mouseup")).event
                    }
                    dispose() {
                        this.disposables.dispose()
                    }
                }
                h([a.H], f.prototype, "onPointerMove", null), h([a.H], f.prototype, "onPointerUp", null);
                class m {
                    constructor(e) {
                        this.el = e, this.disposables = new c.SL
                    }
                    get onPointerMove() {
                        return this.disposables.add(new o.Y(this.el, s.t.Change)).event
                    }
                    get onPointerUp() {
                        return this.disposables.add(new o.Y(this.el, s.t.End)).event
                    }
                    dispose() {
                        this.disposables.dispose()
                    }
                }
                h([a.H], m.prototype, "onPointerMove", null), h([a.H], m.prototype, "onPointerUp", null);
                class v {
                    constructor(e) {
                        this.factory = e
                    }
                    get onPointerMove() {
                        return this.factory.onPointerMove
                    }
                    get onPointerUp() {
                        return this.factory.onPointerUp
                    }
                    dispose() {}
                }
                h([a.H], v.prototype, "onPointerMove", null), h([a.H], v.prototype, "onPointerUp", null);
                class _ extends c.JT {
                    constructor(e, t, i) {
                        super(), this.hoverDelay = 300, this.hoverDelayer = this._register(new r.vp(this.hoverDelay)), this._state = 3, this._onDidEnablementChange = this._register(new l.Q5), this.onDidEnablementChange = this._onDidEnablementChange.event, this._onDidStart = this._register(new l.Q5), this.onDidStart = this._onDidStart.event, this._onDidChange = this._register(new l.Q5), this.onDidChange = this._onDidChange.event, this._onDidReset = this._register(new l.Q5), this.onDidReset = this._onDidReset.event, this._onDidEnd = this._register(new l.Q5), this.onDidEnd = this._onDidEnd.event, this.linkedSash = void 0, this.orthogonalStartSashDisposables = this._register(new c.SL), this.orthogonalStartDragHandleDisposables = this._register(new c.SL), this.orthogonalEndSashDisposables = this._register(new c.SL), this.orthogonalEndDragHandleDisposables = this._register(new c.SL), this.el = (0, n.R3)(e, (0, n.$)(".monaco-sash")), i.orthogonalEdge && this.el.classList.add(`orthogonal-edge-${i.orthogonalEdge}`), d.dz && this.el.classList.add("mac");
                        const a = this._register(new o.Y(this.el, "mousedown")).event;
                        this._register(a((e => this.onPointerStart(e, new f)), this));
                        const h = this._register(new o.Y(this.el, "dblclick")).event;
                        this._register(h(this.onPointerDoublePress, this));
                        const u = this._register(new o.Y(this.el, "mouseenter")).event;
                        this._register(u((() => _.onMouseEnter(this))));
                        const v = this._register(new o.Y(this.el, "mouseleave")).event;
                        this._register(v((() => _.onMouseLeave(this)))), this._register(s.o.addTarget(this.el));
                        const b = l.ju.map(this._register(new o.Y(this.el, s.t.Start)).event, (e => {
                            var t;
                            return Object.assign(Object.assign({}, e), {
                                target: null !== (t = e.initialTarget) && void 0 !== t ? t : null
                            })
                        }));
                        this._register(b((e => this.onPointerStart(e, new m(this.el))), this));
                        const w = this._register(new o.Y(this.el, s.t.Tap)).event,
                            y = l.ju.map(l.ju.filter(l.ju.debounce(w, ((e, t) => {
                                var i;
                                return {
                                    event: t,
                                    count: (null !== (i = null == e ? void 0 : e.count) && void 0 !== i ? i : 0) + 1
                                }
                            }), 250), (({
                                count: e
                            }) => 2 === e)), (({
                                event: e
                            }) => {
                                var t;
                                return Object.assign(Object.assign({}, e), {
                                    target: null !== (t = e.initialTarget) && void 0 !== t ? t : null
                                })
                            }));
                        this._register(y(this.onPointerDoublePress, this)), "number" == typeof i.size ? (this.size = i.size, 0 === i.orientation ? this.el.style.width = `${this.size}px` : this.el.style.height = `${this.size}px`) : (this.size = 4, this._register(g.event((e => {
                            this.size = e, this.layout()
                        })))), this._register(p.event((e => this.hoverDelay = e))), this.hidden = !1, this.layoutProvider = t, this.orthogonalStartSash = i.orthogonalStartSash, this.orthogonalEndSash = i.orthogonalEndSash, this.orientation = i.orientation || 0, 1 === this.orientation ? (this.el.classList.add("horizontal"), this.el.classList.remove("vertical")) : (this.el.classList.remove("horizontal"), this.el.classList.add("vertical")), this.el.classList.toggle("debug", false), this.layout()
                    }
                    get state() {
                        return this._state
                    }
                    set state(e) {
                        this._state !== e && (this.el.classList.toggle("disabled", 0 === e), this.el.classList.toggle("minimum", 1 === e), this.el.classList.toggle("maximum", 2 === e), this._state = e, this._onDidEnablementChange.fire(e))
                    }
                    get orthogonalStartSash() {
                        return this._orthogonalStartSash
                    }
                    set orthogonalStartSash(e) {
                        if (this.orthogonalStartDragHandleDisposables.clear(), this.orthogonalStartSashDisposables.clear(), e) {
                            const t = t => {
                                this.orthogonalStartDragHandleDisposables.clear(), 0 !== t && (this._orthogonalStartDragHandle = (0, n.R3)(this.el, (0, n.$)(".orthogonal-drag-handle.start")), this.orthogonalStartDragHandleDisposables.add((0, c.OF)((() => this._orthogonalStartDragHandle.remove()))), this.orthogonalStartDragHandleDisposables.add(new o.Y(this._orthogonalStartDragHandle, "mouseenter")).event((() => _.onMouseEnter(e)), void 0, this.orthogonalStartDragHandleDisposables), this.orthogonalStartDragHandleDisposables.add(new o.Y(this._orthogonalStartDragHandle, "mouseleave")).event((() => _.onMouseLeave(e)), void 0, this.orthogonalStartDragHandleDisposables))
                            };
                            this.orthogonalStartSashDisposables.add(e.onDidEnablementChange(t, this)), t(e.state)
                        }
                        this._orthogonalStartSash = e
                    }
                    get orthogonalEndSash() {
                        return this._orthogonalEndSash
                    }
                    set orthogonalEndSash(e) {
                        if (this.orthogonalEndDragHandleDisposables.clear(), this.orthogonalEndSashDisposables.clear(), e) {
                            const t = t => {
                                this.orthogonalEndDragHandleDisposables.clear(), 0 !== t && (this._orthogonalEndDragHandle = (0, n.R3)(this.el, (0, n.$)(".orthogonal-drag-handle.end")), this.orthogonalEndDragHandleDisposables.add((0, c.OF)((() => this._orthogonalEndDragHandle.remove()))), this.orthogonalEndDragHandleDisposables.add(new o.Y(this._orthogonalEndDragHandle, "mouseenter")).event((() => _.onMouseEnter(e)), void 0, this.orthogonalEndDragHandleDisposables), this.orthogonalEndDragHandleDisposables.add(new o.Y(this._orthogonalEndDragHandle, "mouseleave")).event((() => _.onMouseLeave(e)), void 0, this.orthogonalEndDragHandleDisposables))
                            };
                            this.orthogonalEndSashDisposables.add(e.onDidEnablementChange(t, this)), t(e.state)
                        }
                        this._orthogonalEndSash = e
                    }
                    onPointerStart(e, t) {
                        n.zB.stop(e);
                        let i = !1;
                        if (!e.__orthogonalSashEvent) {
                            const n = this.getOrthogonalSash(e);
                            n && (i = !0, e.__orthogonalSashEvent = !0, n.onPointerStart(e, new v(t)))
                        }
                        if (this.linkedSash && !e.__linkedSashEvent && (e.__linkedSashEvent = !0, this.linkedSash.onPointerStart(e, new v(t))), !this.state) return;
                        const o = (0, n.H$)("iframe");
                        for (const e of o) e.style.pointerEvents = "none";
                        const s = e.pageX,
                            r = e.pageY,
                            a = e.altKey,
                            l = {
                                startX: s,
                                currentX: s,
                                startY: r,
                                currentY: r,
                                altKey: a
                            };
                        this.el.classList.add("active"), this._onDidStart.fire(l);
                        const h = (0, n.dS)(this.el),
                            u = () => {
                                let e = "";
                                e = i ? "all-scroll" : 1 === this.orientation ? 1 === this.state ? "s-resize" : 2 === this.state ? "n-resize" : d.dz ? "row-resize" : "ns-resize" : 1 === this.state ? "e-resize" : 2 === this.state ? "w-resize" : d.dz ? "col-resize" : "ew-resize", h.textContent = `* { cursor: ${e} !important; }`
                            },
                            g = new c.SL;
                        u(), i || this.onDidEnablementChange(u, null, g);
                        t.onPointerMove((e => {
                            n.zB.stop(e, !1);
                            const t = {
                                startX: s,
                                currentX: e.pageX,
                                startY: r,
                                currentY: e.pageY,
                                altKey: a
                            };
                            this._onDidChange.fire(t)
                        }), null, g), t.onPointerUp((e => {
                            n.zB.stop(e, !1), this.el.removeChild(h), this.el.classList.remove("active"), this._onDidEnd.fire(), g.dispose();
                            for (const e of o) e.style.pointerEvents = "auto"
                        }), null, g), g.add(t)
                    }
                    onPointerDoublePress(e) {
                        const t = this.getOrthogonalSash(e);
                        t && t._onDidReset.fire(), this.linkedSash && this.linkedSash._onDidReset.fire(), this._onDidReset.fire()
                    }
                    static onMouseEnter(e, t = !1) {
                        e.el.classList.contains("active") ? (e.hoverDelayer.cancel(), e.el.classList.add("hover")) : e.hoverDelayer.trigger((() => e.el.classList.add("hover")), e.hoverDelay).then(void 0, (() => {})), !t && e.linkedSash && _.onMouseEnter(e.linkedSash, !0)
                    }
                    static onMouseLeave(e, t = !1) {
                        e.hoverDelayer.cancel(), e.el.classList.remove("hover"), !t && e.linkedSash && _.onMouseLeave(e.linkedSash, !0)
                    }
                    clearSashHoverState() {
                        _.onMouseLeave(this)
                    }
                    layout() {
                        if (0 === this.orientation) {
                            const e = this.layoutProvider;
                            this.el.style.left = e.getVerticalSashLeft(this) - this.size / 2 + "px", e.getVerticalSashTop && (this.el.style.top = e.getVerticalSashTop(this) + "px"), e.getVerticalSashHeight && (this.el.style.height = e.getVerticalSashHeight(this) + "px")
                        } else {
                            const e = this.layoutProvider;
                            this.el.style.top = e.getHorizontalSashTop(this) - this.size / 2 + "px", e.getHorizontalSashLeft && (this.el.style.left = e.getHorizontalSashLeft(this) + "px"), e.getHorizontalSashWidth && (this.el.style.width = e.getHorizontalSashWidth(this) + "px")
                        }
                    }
                    hide() {
                        this.hidden = !0, this.el.style.display = "none", this.el.setAttribute("aria-hidden", "true")
                    }
                    getOrthogonalSash(e) {
                        if (e.target && e.target instanceof HTMLElement) return e.target.classList.contains("orthogonal-drag-handle") ? e.target.classList.contains("start") ? this.orthogonalStartSash : this.orthogonalEndSash : void 0
                    }
                    dispose() {
                        super.dispose(), this.el.remove()
                    }
                }
            },
            9802: (e, t, i) => {
                "use strict";
                i.d(t, {
                    s$: () => T,
                    NB: () => I,
                    $Z: () => E
                });
                var n = i(16268),
                    o = i(65321),
                    s = i(38626),
                    r = i(23938),
                    a = i(57974),
                    l = i(93794),
                    c = i(15393);
                const d = 11;
                class h extends l.$ {
                    constructor(e) {
                        super(), this._onActivate = e.onActivate, this.bgDomNode = document.createElement("div"), this.bgDomNode.className = "arrow-background", this.bgDomNode.style.position = "absolute", this.bgDomNode.style.width = e.bgWidth + "px", this.bgDomNode.style.height = e.bgHeight + "px", void 0 !== e.top && (this.bgDomNode.style.top = "0px"), void 0 !== e.left && (this.bgDomNode.style.left = "0px"), void 0 !== e.bottom && (this.bgDomNode.style.bottom = "0px"), void 0 !== e.right && (this.bgDomNode.style.right = "0px"), this.domNode = document.createElement("div"), this.domNode.className = e.className, this.domNode.classList.add(...e.icon.classNamesArray), this.domNode.style.position = "absolute", this.domNode.style.width = "11px", this.domNode.style.height = "11px", void 0 !== e.top && (this.domNode.style.top = e.top + "px"), void 0 !== e.left && (this.domNode.style.left = e.left + "px"), void 0 !== e.bottom && (this.domNode.style.bottom = e.bottom + "px"), void 0 !== e.right && (this.domNode.style.right = e.right + "px"), this._mouseMoveMonitor = this._register(new a.Z), this.onmousedown(this.bgDomNode, (e => this._arrowMouseDown(e))), this.onmousedown(this.domNode, (e => this._arrowMouseDown(e))), this._mousedownRepeatTimer = this._register(new c.zh), this._mousedownScheduleRepeatTimer = this._register(new c._F)
                    }
                    _arrowMouseDown(e) {
                        this._onActivate(), this._mousedownRepeatTimer.cancel(), this._mousedownScheduleRepeatTimer.cancelAndSet((() => {
                            this._mousedownRepeatTimer.cancelAndSet((() => this._onActivate()), 1e3 / 24)
                        }), 200), this._mouseMoveMonitor.startMonitoring(e.target, e.buttons, a.e, (e => {}), (() => {
                            this._mousedownRepeatTimer.cancel(), this._mousedownScheduleRepeatTimer.cancel()
                        })), e.preventDefault()
                    }
                }
                var u = i(5976);
                class g extends u.JT {
                    constructor(e, t, i) {
                        super(), this._visibility = e, this._visibleClassName = t, this._invisibleClassName = i, this._domNode = null, this._isVisible = !1, this._isNeeded = !1, this._rawShouldBeVisible = !1, this._shouldBeVisible = !1, this._revealTimer = this._register(new c._F)
                    }
                    setVisibility(e) {
                        this._visibility !== e && (this._visibility = e, this._updateShouldBeVisible())
                    }
                    setShouldBeVisible(e) {
                        this._rawShouldBeVisible = e, this._updateShouldBeVisible()
                    }
                    _applyVisibilitySetting() {
                        return 2 !== this._visibility && (3 === this._visibility || this._rawShouldBeVisible)
                    }
                    _updateShouldBeVisible() {
                        const e = this._applyVisibilitySetting();
                        this._shouldBeVisible !== e && (this._shouldBeVisible = e, this.ensureVisibility())
                    }
                    setIsNeeded(e) {
                        this._isNeeded !== e && (this._isNeeded = e, this.ensureVisibility())
                    }
                    setDomNode(e) {
                        this._domNode = e, this._domNode.setClassName(this._invisibleClassName), this.setShouldBeVisible(!1)
                    }
                    ensureVisibility() {
                        this._isNeeded ? this._shouldBeVisible ? this._reveal() : this._hide(!0) : this._hide(!1)
                    }
                    _reveal() {
                        this._isVisible || (this._isVisible = !0, this._revealTimer.setIfNotSet((() => {
                            this._domNode && this._domNode.setClassName(this._visibleClassName)
                        }), 0))
                    }
                    _hide(e) {
                        this._revealTimer.cancel(), this._isVisible && (this._isVisible = !1, this._domNode && this._domNode.setClassName(this._invisibleClassName + (e ? " fade" : "")))
                    }
                }
                var p = i(1432);
                class f extends l.$ {
                    constructor(e) {
                        super(), this._lazyRender = e.lazyRender, this._host = e.host, this._scrollable = e.scrollable, this._scrollByPage = e.scrollByPage, this._scrollbarState = e.scrollbarState, this._visibilityController = this._register(new g(e.visibility, "visible scrollbar " + e.extraScrollbarClassName, "invisible scrollbar " + e.extraScrollbarClassName)), this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()), this._mouseMoveMonitor = this._register(new a.Z), this._shouldRender = !0, this.domNode = (0, s.X)(document.createElement("div")), this.domNode.setAttribute("role", "presentation"), this.domNode.setAttribute("aria-hidden", "true"), this._visibilityController.setDomNode(this.domNode), this.domNode.setPosition("absolute"), this.onmousedown(this.domNode.domNode, (e => this._domNodeMouseDown(e)))
                    }
                    _createArrow(e) {
                        const t = this._register(new h(e));
                        this.domNode.domNode.appendChild(t.bgDomNode), this.domNode.domNode.appendChild(t.domNode)
                    }
                    _createSlider(e, t, i, n) {
                        this.slider = (0, s.X)(document.createElement("div")), this.slider.setClassName("slider"), this.slider.setPosition("absolute"), this.slider.setTop(e), this.slider.setLeft(t), "number" == typeof i && this.slider.setWidth(i), "number" == typeof n && this.slider.setHeight(n), this.slider.setLayerHinting(!0), this.slider.setContain("strict"), this.domNode.domNode.appendChild(this.slider.domNode), this.onmousedown(this.slider.domNode, (e => {
                            e.leftButton && (e.preventDefault(), this._sliderMouseDown(e, (() => {})))
                        })), this.onclick(this.slider.domNode, (e => {
                            e.leftButton && e.stopPropagation()
                        }))
                    }
                    _onElementSize(e) {
                        return this._scrollbarState.setVisibleSize(e) && (this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()), this._shouldRender = !0, this._lazyRender || this.render()), this._shouldRender
                    }
                    _onElementScrollSize(e) {
                        return this._scrollbarState.setScrollSize(e) && (this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()), this._shouldRender = !0, this._lazyRender || this.render()), this._shouldRender
                    }
                    _onElementScrollPosition(e) {
                        return this._scrollbarState.setScrollPosition(e) && (this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()), this._shouldRender = !0, this._lazyRender || this.render()), this._shouldRender
                    }
                    beginReveal() {
                        this._visibilityController.setShouldBeVisible(!0)
                    }
                    beginHide() {
                        this._visibilityController.setShouldBeVisible(!1)
                    }
                    render() {
                        this._shouldRender && (this._shouldRender = !1, this._renderDomNode(this._scrollbarState.getRectangleLargeSize(), this._scrollbarState.getRectangleSmallSize()), this._updateSlider(this._scrollbarState.getSliderSize(), this._scrollbarState.getArrowSize() + this._scrollbarState.getSliderPosition()))
                    }
                    _domNodeMouseDown(e) {
                        e.target === this.domNode.domNode && this._onMouseDown(e)
                    }
                    delegateMouseDown(e) {
                        const t = this.domNode.domNode.getClientRects()[0].top,
                            i = t + this._scrollbarState.getSliderPosition(),
                            n = t + this._scrollbarState.getSliderPosition() + this._scrollbarState.getSliderSize(),
                            o = this._sliderMousePosition(e);
                        i <= o && o <= n ? e.leftButton && (e.preventDefault(), this._sliderMouseDown(e, (() => {}))) : this._onMouseDown(e)
                    }
                    _onMouseDown(e) {
                        let t, i;
                        if (e.target === this.domNode.domNode && "number" == typeof e.browserEvent.offsetX && "number" == typeof e.browserEvent.offsetY) t = e.browserEvent.offsetX, i = e.browserEvent.offsetY;
                        else {
                            const n = o.i(this.domNode.domNode);
                            t = e.posx - n.left, i = e.posy - n.top
                        }
                        const n = this._mouseDownRelativePosition(t, i);
                        this._setDesiredScrollPositionNow(this._scrollByPage ? this._scrollbarState.getDesiredScrollPositionFromOffsetPaged(n) : this._scrollbarState.getDesiredScrollPositionFromOffset(n)), e.leftButton && (e.preventDefault(), this._sliderMouseDown(e, (() => {})))
                    }
                    _sliderMouseDown(e, t) {
                        const i = this._sliderMousePosition(e),
                            n = this._sliderOrthogonalMousePosition(e),
                            o = this._scrollbarState.clone();
                        this.slider.toggleClassName("active", !0), this._mouseMoveMonitor.startMonitoring(e.target, e.buttons, a.e, (e => {
                            const t = this._sliderOrthogonalMousePosition(e),
                                s = Math.abs(t - n);
                            if (p.ED && s > 140) return void this._setDesiredScrollPositionNow(o.getScrollPosition());
                            const r = this._sliderMousePosition(e) - i;
                            this._setDesiredScrollPositionNow(o.getDesiredScrollPositionFromDelta(r))
                        }), (() => {
                            this.slider.toggleClassName("active", !1), this._host.onDragEnd(), t()
                        })), this._host.onDragStart()
                    }
                    _setDesiredScrollPositionNow(e) {
                        const t = {};
                        this.writeScrollPosition(t, e), this._scrollable.setScrollPositionNow(t)
                    }
                    updateScrollbarSize(e) {
                        this._updateScrollbarSize(e), this._scrollbarState.setScrollbarSize(e), this._shouldRender = !0, this._lazyRender || this.render()
                    }
                    isNeeded() {
                        return this._scrollbarState.isNeeded()
                    }
                }
                class m {
                    constructor(e, t, i, n, o, s) {
                        this._scrollbarSize = Math.round(t), this._oppositeScrollbarSize = Math.round(i), this._arrowSize = Math.round(e), this._visibleSize = n, this._scrollSize = o, this._scrollPosition = s, this._computedAvailableSize = 0, this._computedIsNeeded = !1, this._computedSliderSize = 0, this._computedSliderRatio = 0, this._computedSliderPosition = 0, this._refreshComputedValues()
                    }
                    clone() {
                        return new m(this._arrowSize, this._scrollbarSize, this._oppositeScrollbarSize, this._visibleSize, this._scrollSize, this._scrollPosition)
                    }
                    setVisibleSize(e) {
                        const t = Math.round(e);
                        return this._visibleSize !== t && (this._visibleSize = t, this._refreshComputedValues(), !0)
                    }
                    setScrollSize(e) {
                        const t = Math.round(e);
                        return this._scrollSize !== t && (this._scrollSize = t, this._refreshComputedValues(), !0)
                    }
                    setScrollPosition(e) {
                        const t = Math.round(e);
                        return this._scrollPosition !== t && (this._scrollPosition = t, this._refreshComputedValues(), !0)
                    }
                    setScrollbarSize(e) {
                        this._scrollbarSize = Math.round(e)
                    }
                    setOppositeScrollbarSize(e) {
                        this._oppositeScrollbarSize = Math.round(e)
                    }
                    static _computeValues(e, t, i, n, o) {
                        const s = Math.max(0, i - e),
                            r = Math.max(0, s - 2 * t),
                            a = n > 0 && n > i;
                        if (!a) return {
                            computedAvailableSize: Math.round(s),
                            computedIsNeeded: a,
                            computedSliderSize: Math.round(r),
                            computedSliderRatio: 0,
                            computedSliderPosition: 0
                        };
                        const l = Math.round(Math.max(20, Math.floor(i * r / n))),
                            c = (r - l) / (n - i),
                            d = o * c;
                        return {
                            computedAvailableSize: Math.round(s),
                            computedIsNeeded: a,
                            computedSliderSize: Math.round(l),
                            computedSliderRatio: c,
                            computedSliderPosition: Math.round(d)
                        }
                    }
                    _refreshComputedValues() {
                        const e = m._computeValues(this._oppositeScrollbarSize, this._arrowSize, this._visibleSize, this._scrollSize, this._scrollPosition);
                        this._computedAvailableSize = e.computedAvailableSize, this._computedIsNeeded = e.computedIsNeeded, this._computedSliderSize = e.computedSliderSize, this._computedSliderRatio = e.computedSliderRatio, this._computedSliderPosition = e.computedSliderPosition
                    }
                    getArrowSize() {
                        return this._arrowSize
                    }
                    getScrollPosition() {
                        return this._scrollPosition
                    }
                    getRectangleLargeSize() {
                        return this._computedAvailableSize
                    }
                    getRectangleSmallSize() {
                        return this._scrollbarSize
                    }
                    isNeeded() {
                        return this._computedIsNeeded
                    }
                    getSliderSize() {
                        return this._computedSliderSize
                    }
                    getSliderPosition() {
                        return this._computedSliderPosition
                    }
                    getDesiredScrollPositionFromOffset(e) {
                        if (!this._computedIsNeeded) return 0;
                        const t = e - this._arrowSize - this._computedSliderSize / 2;
                        return Math.round(t / this._computedSliderRatio)
                    }
                    getDesiredScrollPositionFromOffsetPaged(e) {
                        if (!this._computedIsNeeded) return 0;
                        const t = e - this._arrowSize;
                        let i = this._scrollPosition;
                        return t < this._computedSliderPosition ? i -= this._visibleSize : i += this._visibleSize, i
                    }
                    getDesiredScrollPositionFromDelta(e) {
                        if (!this._computedIsNeeded) return 0;
                        const t = this._computedSliderPosition + e;
                        return Math.round(t / this._computedSliderRatio)
                    }
                }
                var v = i(73046);
                const _ = (0, v.CM)("scrollbar-button-left", v.lA.triangleLeft),
                    b = (0, v.CM)("scrollbar-button-right", v.lA.triangleRight);
                class w extends f {
                    constructor(e, t, i) {
                        const n = e.getScrollDimensions(),
                            o = e.getCurrentScrollPosition();
                        if (super({
                                lazyRender: t.lazyRender,
                                host: i,
                                scrollbarState: new m(t.horizontalHasArrows ? t.arrowSize : 0, 2 === t.horizontal ? 0 : t.horizontalScrollbarSize, 2 === t.vertical ? 0 : t.verticalScrollbarSize, n.width, n.scrollWidth, o.scrollLeft),
                                visibility: t.horizontal,
                                extraScrollbarClassName: "horizontal",
                                scrollable: e,
                                scrollByPage: t.scrollByPage
                            }), t.horizontalHasArrows) {
                            const e = (t.arrowSize - d) / 2,
                                i = (t.horizontalScrollbarSize - d) / 2;
                            this._createArrow({
                                className: "scra",
                                icon: _,
                                top: i,
                                left: e,
                                bottom: void 0,
                                right: void 0,
                                bgWidth: t.arrowSize,
                                bgHeight: t.horizontalScrollbarSize,
                                onActivate: () => this._host.onMouseWheel(new r.q(null, 1, 0))
                            }), this._createArrow({
                                className: "scra",
                                icon: b,
                                top: i,
                                left: void 0,
                                bottom: void 0,
                                right: e,
                                bgWidth: t.arrowSize,
                                bgHeight: t.horizontalScrollbarSize,
                                onActivate: () => this._host.onMouseWheel(new r.q(null, -1, 0))
                            })
                        }
                        this._createSlider(Math.floor((t.horizontalScrollbarSize - t.horizontalSliderSize) / 2), 0, void 0, t.horizontalSliderSize)
                    }
                    _updateSlider(e, t) {
                        this.slider.setWidth(e), this.slider.setLeft(t)
                    }
                    _renderDomNode(e, t) {
                        this.domNode.setWidth(e), this.domNode.setHeight(t), this.domNode.setLeft(0), this.domNode.setBottom(0)
                    }
                    onDidScroll(e) {
                        return this._shouldRender = this._onElementScrollSize(e.scrollWidth) || this._shouldRender, this._shouldRender = this._onElementScrollPosition(e.scrollLeft) || this._shouldRender, this._shouldRender = this._onElementSize(e.width) || this._shouldRender, this._shouldRender
                    }
                    _mouseDownRelativePosition(e, t) {
                        return e
                    }
                    _sliderMousePosition(e) {
                        return e.posx
                    }
                    _sliderOrthogonalMousePosition(e) {
                        return e.posy
                    }
                    _updateScrollbarSize(e) {
                        this.slider.setHeight(e)
                    }
                    writeScrollPosition(e, t) {
                        e.scrollLeft = t
                    }
                    updateOptions(e) {
                        this.updateScrollbarSize(2 === e.horizontal ? 0 : e.horizontalScrollbarSize), this._scrollbarState.setOppositeScrollbarSize(2 === e.vertical ? 0 : e.verticalScrollbarSize), this._visibilityController.setVisibility(e.horizontal), this._scrollByPage = e.scrollByPage
                    }
                }
                const y = (0, v.CM)("scrollbar-button-up", v.lA.triangleUp),
                    C = (0, v.CM)("scrollbar-button-down", v.lA.triangleDown);
                class x extends f {
                    constructor(e, t, i) {
                        const n = e.getScrollDimensions(),
                            o = e.getCurrentScrollPosition();
                        if (super({
                                lazyRender: t.lazyRender,
                                host: i,
                                scrollbarState: new m(t.verticalHasArrows ? t.arrowSize : 0, 2 === t.vertical ? 0 : t.verticalScrollbarSize, 0, n.height, n.scrollHeight, o.scrollTop),
                                visibility: t.vertical,
                                extraScrollbarClassName: "vertical",
                                scrollable: e,
                                scrollByPage: t.scrollByPage
                            }), t.verticalHasArrows) {
                            const e = (t.arrowSize - d) / 2,
                                i = (t.verticalScrollbarSize - d) / 2;
                            this._createArrow({
                                className: "scra",
                                icon: y,
                                top: e,
                                left: i,
                                bottom: void 0,
                                right: void 0,
                                bgWidth: t.verticalScrollbarSize,
                                bgHeight: t.arrowSize,
                                onActivate: () => this._host.onMouseWheel(new r.q(null, 0, 1))
                            }), this._createArrow({
                                className: "scra",
                                icon: C,
                                top: void 0,
                                left: i,
                                bottom: e,
                                right: void 0,
                                bgWidth: t.verticalScrollbarSize,
                                bgHeight: t.arrowSize,
                                onActivate: () => this._host.onMouseWheel(new r.q(null, 0, -1))
                            })
                        }
                        this._createSlider(0, Math.floor((t.verticalScrollbarSize - t.verticalSliderSize) / 2), t.verticalSliderSize, void 0)
                    }
                    _updateSlider(e, t) {
                        this.slider.setHeight(e), this.slider.setTop(t)
                    }
                    _renderDomNode(e, t) {
                        this.domNode.setWidth(t), this.domNode.setHeight(e), this.domNode.setRight(0), this.domNode.setTop(0)
                    }
                    onDidScroll(e) {
                        return this._shouldRender = this._onElementScrollSize(e.scrollHeight) || this._shouldRender, this._shouldRender = this._onElementScrollPosition(e.scrollTop) || this._shouldRender, this._shouldRender = this._onElementSize(e.height) || this._shouldRender, this._shouldRender
                    }
                    _mouseDownRelativePosition(e, t) {
                        return t
                    }
                    _sliderMousePosition(e) {
                        return e.posy
                    }
                    _sliderOrthogonalMousePosition(e) {
                        return e.posx
                    }
                    _updateScrollbarSize(e) {
                        this.slider.setWidth(e)
                    }
                    writeScrollPosition(e, t) {
                        e.scrollTop = t
                    }
                    updateOptions(e) {
                        this.updateScrollbarSize(2 === e.vertical ? 0 : e.verticalScrollbarSize), this._scrollbarState.setOppositeScrollbarSize(0), this._visibilityController.setVisibility(e.vertical), this._scrollByPage = e.scrollByPage
                    }
                }
                var S = i(4669),
                    k = i(76633);
                i(87101);
                class L {
                    constructor(e, t, i) {
                        this.timestamp = e, this.deltaX = t, this.deltaY = i, this.score = 0
                    }
                }
                class N {
                    constructor() {
                        this._capacity = 5, this._memory = [], this._front = -1, this._rear = -1
                    }
                    isPhysicalMouseWheel() {
                        if (-1 === this._front && -1 === this._rear) return !1;
                        let e = 1,
                            t = 0,
                            i = 1,
                            n = this._rear;
                        for (;;) {
                            const o = n === this._front ? e : Math.pow(2, -i);
                            if (e -= o, t += this._memory[n].score * o, n === this._front) break;
                            n = (this._capacity + n - 1) % this._capacity, i++
                        }
                        return t <= .5
                    }
                    accept(e, t, i) {
                        const n = new L(e, t, i);
                        n.score = this._computeScore(n), -1 === this._front && -1 === this._rear ? (this._memory[0] = n, this._front = 0, this._rear = 0) : (this._rear = (this._rear + 1) % this._capacity, this._rear === this._front && (this._front = (this._front + 1) % this._capacity), this._memory[this._rear] = n)
                    }
                    _computeScore(e) {
                        if (Math.abs(e.deltaX) > 0 && Math.abs(e.deltaY) > 0) return 1;
                        let t = .5; - 1 === this._front && -1 === this._rear || this._memory[this._rear];
                        return this._isAlmostInt(e.deltaX) && this._isAlmostInt(e.deltaY) || (t += .25), Math.min(Math.max(t, 0), 1)
                    }
                    _isAlmostInt(e) {
                        return Math.abs(Math.round(e) - e) < .01
                    }
                }
                N.INSTANCE = new N;
                class D extends l.$ {
                    constructor(e, t, i) {
                        super(), this._onScroll = this._register(new S.Q5), this.onScroll = this._onScroll.event, this._onWillScroll = this._register(new S.Q5), e.style.overflow = "hidden", this._options = function(e) {
                            const t = {
                                lazyRender: void 0 !== e.lazyRender && e.lazyRender,
                                className: void 0 !== e.className ? e.className : "",
                                useShadows: void 0 === e.useShadows || e.useShadows,
                                handleMouseWheel: void 0 === e.handleMouseWheel || e.handleMouseWheel,
                                flipAxes: void 0 !== e.flipAxes && e.flipAxes,
                                consumeMouseWheelIfScrollbarIsNeeded: void 0 !== e.consumeMouseWheelIfScrollbarIsNeeded && e.consumeMouseWheelIfScrollbarIsNeeded,
                                alwaysConsumeMouseWheel: void 0 !== e.alwaysConsumeMouseWheel && e.alwaysConsumeMouseWheel,
                                scrollYToX: void 0 !== e.scrollYToX && e.scrollYToX,
                                mouseWheelScrollSensitivity: void 0 !== e.mouseWheelScrollSensitivity ? e.mouseWheelScrollSensitivity : 1,
                                fastScrollSensitivity: void 0 !== e.fastScrollSensitivity ? e.fastScrollSensitivity : 5,
                                scrollPredominantAxis: void 0 === e.scrollPredominantAxis || e.scrollPredominantAxis,
                                mouseWheelSmoothScroll: void 0 === e.mouseWheelSmoothScroll || e.mouseWheelSmoothScroll,
                                arrowSize: void 0 !== e.arrowSize ? e.arrowSize : 11,
                                listenOnDomNode: void 0 !== e.listenOnDomNode ? e.listenOnDomNode : null,
                                horizontal: void 0 !== e.horizontal ? e.horizontal : 1,
                                horizontalScrollbarSize: void 0 !== e.horizontalScrollbarSize ? e.horizontalScrollbarSize : 10,
                                horizontalSliderSize: void 0 !== e.horizontalSliderSize ? e.horizontalSliderSize : 0,
                                horizontalHasArrows: void 0 !== e.horizontalHasArrows && e.horizontalHasArrows,
                                vertical: void 0 !== e.vertical ? e.vertical : 1,
                                verticalScrollbarSize: void 0 !== e.verticalScrollbarSize ? e.verticalScrollbarSize : 10,
                                verticalHasArrows: void 0 !== e.verticalHasArrows && e.verticalHasArrows,
                                verticalSliderSize: void 0 !== e.verticalSliderSize ? e.verticalSliderSize : 0,
                                scrollByPage: void 0 !== e.scrollByPage && e.scrollByPage
                            };
                            t.horizontalSliderSize = void 0 !== e.horizontalSliderSize ? e.horizontalSliderSize : t.horizontalScrollbarSize, t.verticalSliderSize = void 0 !== e.verticalSliderSize ? e.verticalSliderSize : t.verticalScrollbarSize, p.dz && (t.className += " mac");
                            return t
                        }(t), this._scrollable = i, this._register(this._scrollable.onScroll((e => {
                            this._onWillScroll.fire(e), this._onDidScroll(e), this._onScroll.fire(e)
                        })));
                        const n = {
                            onMouseWheel: e => this._onMouseWheel(e),
                            onDragStart: () => this._onDragStart(),
                            onDragEnd: () => this._onDragEnd()
                        };
                        this._verticalScrollbar = this._register(new x(this._scrollable, this._options, n)), this._horizontalScrollbar = this._register(new w(this._scrollable, this._options, n)), this._domNode = document.createElement("div"), this._domNode.className = "monaco-scrollable-element " + this._options.className, this._domNode.setAttribute("role", "presentation"), this._domNode.style.position = "relative", this._domNode.style.overflow = "hidden", this._domNode.appendChild(e), this._domNode.appendChild(this._horizontalScrollbar.domNode.domNode), this._domNode.appendChild(this._verticalScrollbar.domNode.domNode), this._options.useShadows ? (this._leftShadowDomNode = (0, s.X)(document.createElement("div")), this._leftShadowDomNode.setClassName("shadow"), this._domNode.appendChild(this._leftShadowDomNode.domNode), this._topShadowDomNode = (0, s.X)(document.createElement("div")), this._topShadowDomNode.setClassName("shadow"), this._domNode.appendChild(this._topShadowDomNode.domNode), this._topLeftShadowDomNode = (0, s.X)(document.createElement("div")), this._topLeftShadowDomNode.setClassName("shadow"), this._domNode.appendChild(this._topLeftShadowDomNode.domNode)) : (this._leftShadowDomNode = null, this._topShadowDomNode = null, this._topLeftShadowDomNode = null), this._listenOnDomNode = this._options.listenOnDomNode || this._domNode, this._mouseWheelToDispose = [], this._setListeningToMouseWheel(this._options.handleMouseWheel), this.onmouseover(this._listenOnDomNode, (e => this._onMouseOver(e))), this.onnonbubblingmouseout(this._listenOnDomNode, (e => this._onMouseOut(e))), this._hideTimeout = this._register(new c._F), this._isDragging = !1, this._mouseIsOver = !1, this._shouldRender = !0, this._revealOnScroll = !0
                    }
                    dispose() {
                        this._mouseWheelToDispose = (0, u.B9)(this._mouseWheelToDispose), super.dispose()
                    }
                    getDomNode() {
                        return this._domNode
                    }
                    getOverviewRulerLayoutInfo() {
                        return {
                            parent: this._domNode,
                            insertBefore: this._verticalScrollbar.domNode.domNode
                        }
                    }
                    delegateVerticalScrollbarMouseDown(e) {
                        this._verticalScrollbar.delegateMouseDown(e)
                    }
                    getScrollDimensions() {
                        return this._scrollable.getScrollDimensions()
                    }
                    setScrollDimensions(e) {
                        this._scrollable.setScrollDimensions(e, !1)
                    }
                    updateClassName(e) {
                        this._options.className = e, p.dz && (this._options.className += " mac"), this._domNode.className = "monaco-scrollable-element " + this._options.className
                    }
                    updateOptions(e) {
                        void 0 !== e.handleMouseWheel && (this._options.handleMouseWheel = e.handleMouseWheel, this._setListeningToMouseWheel(this._options.handleMouseWheel)), void 0 !== e.mouseWheelScrollSensitivity && (this._options.mouseWheelScrollSensitivity = e.mouseWheelScrollSensitivity), void 0 !== e.fastScrollSensitivity && (this._options.fastScrollSensitivity = e.fastScrollSensitivity), void 0 !== e.scrollPredominantAxis && (this._options.scrollPredominantAxis = e.scrollPredominantAxis), void 0 !== e.horizontal && (this._options.horizontal = e.horizontal), void 0 !== e.vertical && (this._options.vertical = e.vertical), void 0 !== e.horizontalScrollbarSize && (this._options.horizontalScrollbarSize = e.horizontalScrollbarSize), void 0 !== e.verticalScrollbarSize && (this._options.verticalScrollbarSize = e.verticalScrollbarSize), void 0 !== e.scrollByPage && (this._options.scrollByPage = e.scrollByPage), this._horizontalScrollbar.updateOptions(this._options), this._verticalScrollbar.updateOptions(this._options), this._options.lazyRender || this._render()
                    }
                    _setListeningToMouseWheel(e) {
                        if (this._mouseWheelToDispose.length > 0 !== e && (this._mouseWheelToDispose = (0, u.B9)(this._mouseWheelToDispose), e)) {
                            const e = e => {
                                this._onMouseWheel(new r.q(e))
                            };
                            this._mouseWheelToDispose.push(o.nm(this._listenOnDomNode, o.tw.MOUSE_WHEEL, e, {
                                passive: !1
                            }))
                        }
                    }
                    _onMouseWheel(e) {
                        const t = N.INSTANCE; {
                            const i = window.devicePixelRatio / (0, n.ie)();
                            p.ED || p.IJ ? t.accept(Date.now(), e.deltaX / i, e.deltaY / i) : t.accept(Date.now(), e.deltaX, e.deltaY)
                        }
                        let i = !1;
                        if (e.deltaY || e.deltaX) {
                            let n = e.deltaY * this._options.mouseWheelScrollSensitivity,
                                o = e.deltaX * this._options.mouseWheelScrollSensitivity;
                            this._options.scrollPredominantAxis && (Math.abs(n) >= Math.abs(o) ? o = 0 : n = 0), this._options.flipAxes && ([n, o] = [o, n]);
                            const s = !p.dz && e.browserEvent && e.browserEvent.shiftKey;
                            !this._options.scrollYToX && !s || o || (o = n, n = 0), e.browserEvent && e.browserEvent.altKey && (o *= this._options.fastScrollSensitivity, n *= this._options.fastScrollSensitivity);
                            const r = this._scrollable.getFutureScrollPosition();
                            let a = {};
                            if (n) {
                                const e = 50 * n,
                                    t = r.scrollTop - (e < 0 ? Math.floor(e) : Math.ceil(e));
                                this._verticalScrollbar.writeScrollPosition(a, t)
                            }
                            if (o) {
                                const e = 50 * o,
                                    t = r.scrollLeft - (e < 0 ? Math.floor(e) : Math.ceil(e));
                                this._horizontalScrollbar.writeScrollPosition(a, t)
                            }
                            if (a = this._scrollable.validateScrollPosition(a), r.scrollLeft !== a.scrollLeft || r.scrollTop !== a.scrollTop) {
                                this._options.mouseWheelSmoothScroll && t.isPhysicalMouseWheel() ? this._scrollable.setScrollPositionSmooth(a) : this._scrollable.setScrollPositionNow(a), i = !0
                            }
                        }
                        let o = i;
                        !o && this._options.alwaysConsumeMouseWheel && (o = !0), !o && this._options.consumeMouseWheelIfScrollbarIsNeeded && (this._verticalScrollbar.isNeeded() || this._horizontalScrollbar.isNeeded()) && (o = !0), o && (e.preventDefault(), e.stopPropagation())
                    }
                    _onDidScroll(e) {
                        this._shouldRender = this._horizontalScrollbar.onDidScroll(e) || this._shouldRender, this._shouldRender = this._verticalScrollbar.onDidScroll(e) || this._shouldRender, this._options.useShadows && (this._shouldRender = !0), this._revealOnScroll && this._reveal(), this._options.lazyRender || this._render()
                    }
                    renderNow() {
                        if (!this._options.lazyRender) throw new Error("Please use `lazyRender` together with `renderNow`!");
                        this._render()
                    }
                    _render() {
                        if (this._shouldRender && (this._shouldRender = !1, this._horizontalScrollbar.render(), this._verticalScrollbar.render(), this._options.useShadows)) {
                            const e = this._scrollable.getCurrentScrollPosition(),
                                t = e.scrollTop > 0,
                                i = e.scrollLeft > 0,
                                n = i ? " left" : "",
                                o = t ? " top" : "",
                                s = i || t ? " top-left-corner" : "";
                            this._leftShadowDomNode.setClassName(`shadow${n}`), this._topShadowDomNode.setClassName(`shadow${o}`), this._topLeftShadowDomNode.setClassName(`shadow${s}${o}${n}`)
                        }
                    }
                    _onDragStart() {
                        this._isDragging = !0, this._reveal()
                    }
                    _onDragEnd() {
                        this._isDragging = !1, this._hide()
                    }
                    _onMouseOut(e) {
                        this._mouseIsOver = !1, this._hide()
                    }
                    _onMouseOver(e) {
                        this._mouseIsOver = !0, this._reveal()
                    }
                    _reveal() {
                        this._verticalScrollbar.beginReveal(), this._horizontalScrollbar.beginReveal(), this._scheduleHide()
                    }
                    _hide() {
                        this._mouseIsOver || this._isDragging || (this._verticalScrollbar.beginHide(), this._horizontalScrollbar.beginHide())
                    }
                    _scheduleHide() {
                        this._mouseIsOver || this._isDragging || this._hideTimeout.cancelAndSet((() => this._hide()), 500)
                    }
                }
                class I extends D {
                    constructor(e, t) {
                        (t = t || {}).mouseWheelSmoothScroll = !1;
                        const i = new k.Rm(0, (e => o.jL(e)));
                        super(e, t, i), this._register(i)
                    }
                    setScrollPosition(e) {
                        this._scrollable.setScrollPositionNow(e)
                    }
                    getScrollPosition() {
                        return this._scrollable.getCurrentScrollPosition()
                    }
                }
                class E extends D {
                    constructor(e, t, i) {
                        super(e, t, i)
                    }
                    setScrollPosition(e) {
                        e.reuseAnimation ? this._scrollable.setScrollPositionSmooth(e, e.reuseAnimation) : this._scrollable.setScrollPositionNow(e)
                    }
                    getScrollPosition() {
                        return this._scrollable.getCurrentScrollPosition()
                    }
                }
                class T extends I {
                    constructor(e, t) {
                        super(e, t), this._element = e, this.onScroll((e => {
                            e.scrollTopChanged && (this._element.scrollTop = e.scrollTop), e.scrollLeftChanged && (this._element.scrollLeft = e.scrollLeft)
                        })), this.scanDomNode()
                    }
                    scanDomNode() {
                        this.setScrollDimensions({
                            width: this._element.clientWidth,
                            scrollWidth: this._element.scrollWidth,
                            height: this._element.clientHeight,
                            scrollHeight: this._element.scrollHeight
                        }), this.setScrollPosition({
                            scrollLeft: this._element.scrollLeft,
                            scrollTop: this._element.scrollTop
                        })
                    }
                }
            },
            23937: (e, t, i) => {
                "use strict";
                i.d(t, {
                    M: () => _,
                    z: () => b
                });
                var n = i(65321),
                    o = i(73098),
                    s = i(9802),
                    r = i(9488),
                    a = i(41264),
                    l = i(4669),
                    c = i(5976),
                    d = i(59870),
                    h = i(76633),
                    u = i(98401);
                i(62466);
                const g = {
                    separatorBorder: a.Il.transparent
                };
                class p {
                    constructor(e, t, i, n) {
                        this.container = e, this.view = t, this.disposable = n, this._cachedVisibleSize = void 0, "number" == typeof i ? (this._size = i, this._cachedVisibleSize = void 0, e.classList.add("visible")) : (this._size = 0, this._cachedVisibleSize = i.cachedVisibleSize)
                    }
                    set size(e) {
                        this._size = e
                    }
                    get size() {
                        return this._size
                    }
                    get visible() {
                        return void 0 === this._cachedVisibleSize
                    }
                    setVisible(e, t) {
                        e !== this.visible && (e ? (this.size = (0, d.u)(this._cachedVisibleSize, this.viewMinimumSize, this.viewMaximumSize), this._cachedVisibleSize = void 0) : (this._cachedVisibleSize = "number" == typeof t ? t : this.size, this.size = 0), this.container.classList.toggle("visible", e), this.view.setVisible && this.view.setVisible(e))
                    }
                    get minimumSize() {
                        return this.visible ? this.view.minimumSize : 0
                    }
                    get viewMinimumSize() {
                        return this.view.minimumSize
                    }
                    get maximumSize() {
                        return this.visible ? this.view.maximumSize : 0
                    }
                    get viewMaximumSize() {
                        return this.view.maximumSize
                    }
                    get priority() {
                        return this.view.priority
                    }
                    get snap() {
                        return !!this.view.snap
                    }
                    set enabled(e) {
                        this.container.style.pointerEvents = e ? "" : "none"
                    }
                    layout(e, t) {
                        this.layoutContainer(e), this.view.layout(this.size, e, t)
                    }
                    dispose() {
                        return this.disposable.dispose(), this.view
                    }
                }
                class f extends p {
                    layoutContainer(e) {
                        this.container.style.top = `${e}px`, this.container.style.height = `${this.size}px`
                    }
                }
                class m extends p {
                    layoutContainer(e) {
                        this.container.style.left = `${e}px`, this.container.style.width = `${this.size}px`
                    }
                }
                var v, _;
                ! function(e) {
                    e[e.Idle = 0] = "Idle", e[e.Busy = 1] = "Busy"
                }(v || (v = {})),
                function(e) {
                    e.Distribute = {
                        type: "distribute"
                    }, e.Split = function(e) {
                        return {
                            type: "split",
                            index: e
                        }
                    }, e.Invisible = function(e) {
                        return {
                            type: "invisible",
                            cachedVisibleSize: e
                        }
                    }
                }(_ || (_ = {}));
                class b extends c.JT {
                    constructor(e, t = {}) {
                        var i, o;
                        super(), this.size = 0, this.contentSize = 0, this.proportions = void 0, this.viewItems = [], this.sashItems = [], this.state = v.Idle, this._onDidSashChange = this._register(new l.Q5), this.onDidSashChange = this._onDidSashChange.event, this._onDidSashReset = this._register(new l.Q5), this._startSnappingEnabled = !0, this._endSnappingEnabled = !0, this.orientation = u.o8(t.orientation) ? 0 : t.orientation, this.inverseAltBehavior = !!t.inverseAltBehavior, this.proportionalLayout = !!u.o8(t.proportionalLayout) || !!t.proportionalLayout, this.getSashOrthogonalSize = t.getSashOrthogonalSize, this.el = document.createElement("div"), this.el.classList.add("monaco-split-view2"), this.el.classList.add(0 === this.orientation ? "vertical" : "horizontal"), e.appendChild(this.el), this.sashContainer = (0, n.R3)(this.el, (0, n.$)(".sash-container")), this.viewContainer = (0, n.$)(".split-view-container"), this.scrollable = new h.Rm(125, n.jL), this.scrollableElement = this._register(new s.$Z(this.viewContainer, {
                            vertical: 0 === this.orientation ? null !== (i = t.scrollbarVisibility) && void 0 !== i ? i : 1 : 2,
                            horizontal: 1 === this.orientation ? null !== (o = t.scrollbarVisibility) && void 0 !== o ? o : 1 : 2
                        }, this.scrollable)), this.onDidScroll = this.scrollableElement.onScroll, this._register(this.onDidScroll((e => {
                            this.viewContainer.scrollTop = e.scrollTop, this.viewContainer.scrollLeft = e.scrollLeft
                        }))), (0, n.R3)(this.el, this.scrollableElement.getDomNode()), this.style(t.styles || g), t.descriptor && (this.size = t.descriptor.size, t.descriptor.views.forEach(((e, t) => {
                            const i = u.o8(e.visible) || e.visible ? e.size : {
                                    type: "invisible",
                                    cachedVisibleSize: e.size
                                },
                                n = e.view;
                            this.doAddView(n, i, t, !0)
                        })), this.contentSize = this.viewItems.reduce(((e, t) => e + t.size), 0), this.saveProportions())
                    }
                    get orthogonalStartSash() {
                        return this._orthogonalStartSash
                    }
                    set orthogonalStartSash(e) {
                        for (const t of this.sashItems) t.sash.orthogonalStartSash = e;
                        this._orthogonalStartSash = e
                    }
                    get orthogonalEndSash() {
                        return this._orthogonalEndSash
                    }
                    set orthogonalEndSash(e) {
                        for (const t of this.sashItems) t.sash.orthogonalEndSash = e;
                        this._orthogonalEndSash = e
                    }
                    get startSnappingEnabled() {
                        return this._startSnappingEnabled
                    }
                    set startSnappingEnabled(e) {
                        this._startSnappingEnabled !== e && (this._startSnappingEnabled = e, this.updateSashEnablement())
                    }
                    get endSnappingEnabled() {
                        return this._endSnappingEnabled
                    }
                    set endSnappingEnabled(e) {
                        this._endSnappingEnabled !== e && (this._endSnappingEnabled = e, this.updateSashEnablement())
                    }
                    style(e) {
                        e.separatorBorder.isTransparent() ? (this.el.classList.remove("separator-border"), this.el.style.removeProperty("--separator-border")) : (this.el.classList.add("separator-border"), this.el.style.setProperty("--separator-border", e.separatorBorder.toString()))
                    }
                    addView(e, t, i = this.viewItems.length, n) {
                        this.doAddView(e, t, i, n)
                    }
                    layout(e, t) {
                        const i = Math.max(this.size, this.contentSize);
                        if (this.size = e, this.layoutContext = t, this.proportions)
                            for (let t = 0; t < this.viewItems.length; t++) {
                                const i = this.viewItems[t];
                                i.size = (0, d.u)(Math.round(this.proportions[t] * e), i.minimumSize, i.maximumSize)
                            } else {
                                const t = (0, r.w6)(this.viewItems.length),
                                    n = t.filter((e => 1 === this.viewItems[e].priority)),
                                    o = t.filter((e => 2 === this.viewItems[e].priority));
                                this.resize(this.viewItems.length - 1, e - i, void 0, n, o)
                            }
                        this.distributeEmptySpace(), this.layoutViews()
                    }
                    saveProportions() {
                        this.proportionalLayout && this.contentSize > 0 && (this.proportions = this.viewItems.map((e => e.size / this.contentSize)))
                    }
                    onSashStart({
                        sash: e,
                        start: t,
                        alt: i
                    }) {
                        for (const e of this.viewItems) e.enabled = !1;
                        const o = this.sashItems.findIndex((t => t.sash === e)),
                            s = (0, c.F8)((0, n.nm)(document.body, "keydown", (e => a(this.sashDragState.current, e.altKey))), (0, n.nm)(document.body, "keyup", (() => a(this.sashDragState.current, !1)))),
                            a = (e, t) => {
                                const i = this.viewItems.map((e => e.size));
                                let n, a, l = Number.NEGATIVE_INFINITY,
                                    c = Number.POSITIVE_INFINITY;
                                if (this.inverseAltBehavior && (t = !t), t) {
                                    if (o === this.sashItems.length - 1) {
                                        const e = this.viewItems[o];
                                        l = (e.minimumSize - e.size) / 2, c = (e.maximumSize - e.size) / 2
                                    } else {
                                        const e = this.viewItems[o + 1];
                                        l = (e.size - e.maximumSize) / 2, c = (e.size - e.minimumSize) / 2
                                    }
                                }
                                if (!t) {
                                    const e = (0, r.w6)(o, -1),
                                        t = (0, r.w6)(o + 1, this.viewItems.length),
                                        s = e.reduce(((e, t) => e + (this.viewItems[t].minimumSize - i[t])), 0),
                                        l = e.reduce(((e, t) => e + (this.viewItems[t].viewMaximumSize - i[t])), 0),
                                        c = 0 === t.length ? Number.POSITIVE_INFINITY : t.reduce(((e, t) => e + (i[t] - this.viewItems[t].minimumSize)), 0),
                                        d = 0 === t.length ? Number.NEGATIVE_INFINITY : t.reduce(((e, t) => e + (i[t] - this.viewItems[t].viewMaximumSize)), 0),
                                        h = Math.max(s, d),
                                        u = Math.min(c, l),
                                        g = this.findFirstSnapIndex(e),
                                        p = this.findFirstSnapIndex(t);
                                    if ("number" == typeof g) {
                                        const e = this.viewItems[g],
                                            t = Math.floor(e.viewMinimumSize / 2);
                                        n = {
                                            index: g,
                                            limitDelta: e.visible ? h - t : h + t,
                                            size: e.size
                                        }
                                    }
                                    if ("number" == typeof p) {
                                        const e = this.viewItems[p],
                                            t = Math.floor(e.viewMinimumSize / 2);
                                        a = {
                                            index: p,
                                            limitDelta: e.visible ? u + t : u - t,
                                            size: e.size
                                        }
                                    }
                                }
                                this.sashDragState = {
                                    start: e,
                                    current: e,
                                    index: o,
                                    sizes: i,
                                    minDelta: l,
                                    maxDelta: c,
                                    alt: t,
                                    snapBefore: n,
                                    snapAfter: a,
                                    disposable: s
                                }
                            };
                        a(t, i)
                    }
                    onSashChange({
                        current: e
                    }) {
                        const {
                            index: t,
                            start: i,
                            sizes: n,
                            alt: o,
                            minDelta: s,
                            maxDelta: r,
                            snapBefore: a,
                            snapAfter: l
                        } = this.sashDragState;
                        this.sashDragState.current = e;
                        const c = e - i,
                            d = this.resize(t, c, n, void 0, void 0, s, r, a, l);
                        if (o) {
                            const e = t === this.sashItems.length - 1,
                                i = this.viewItems.map((e => e.size)),
                                n = e ? t : t + 1,
                                o = this.viewItems[n],
                                s = o.size - o.maximumSize,
                                r = o.size - o.minimumSize,
                                a = e ? t - 1 : t + 1;
                            this.resize(a, -d, i, void 0, void 0, s, r)
                        }
                        this.distributeEmptySpace(), this.layoutViews()
                    }
                    onSashEnd(e) {
                        this._onDidSashChange.fire(e), this.sashDragState.disposable.dispose(), this.saveProportions();
                        for (const e of this.viewItems) e.enabled = !0
                    }
                    onViewChange(e, t) {
                        const i = this.viewItems.indexOf(e);
                        i < 0 || i >= this.viewItems.length || (t = "number" == typeof t ? t : e.size, t = (0, d.u)(t, e.minimumSize, e.maximumSize), this.inverseAltBehavior && i > 0 ? (this.resize(i - 1, Math.floor((e.size - t) / 2)), this.distributeEmptySpace(), this.layoutViews()) : (e.size = t, this.relayout([i], void 0)))
                    }
                    resizeView(e, t) {
                        if (this.state !== v.Idle) throw new Error("Cant modify splitview");
                        if (this.state = v.Busy, e < 0 || e >= this.viewItems.length) return;
                        const i = (0, r.w6)(this.viewItems.length).filter((t => t !== e)),
                            n = [...i.filter((e => 1 === this.viewItems[e].priority)), e],
                            o = i.filter((e => 2 === this.viewItems[e].priority)),
                            s = this.viewItems[e];
                        t = Math.round(t), t = (0, d.u)(t, s.minimumSize, Math.min(s.maximumSize, this.size)), s.size = t, this.relayout(n, o), this.state = v.Idle
                    }
                    distributeViewSizes() {
                        const e = [];
                        let t = 0;
                        for (const i of this.viewItems) i.maximumSize - i.minimumSize > 0 && (e.push(i), t += i.size);
                        const i = Math.floor(t / e.length);
                        for (const t of e) t.size = (0, d.u)(i, t.minimumSize, t.maximumSize);
                        const n = (0, r.w6)(this.viewItems.length),
                            o = n.filter((e => 1 === this.viewItems[e].priority)),
                            s = n.filter((e => 2 === this.viewItems[e].priority));
                        this.relayout(o, s)
                    }
                    getViewSize(e) {
                        return e < 0 || e >= this.viewItems.length ? -1 : this.viewItems[e].size
                    }
                    doAddView(e, t, i = this.viewItems.length, s) {
                        if (this.state !== v.Idle) throw new Error("Cant modify splitview");
                        this.state = v.Busy;
                        const a = (0, n.$)(".split-view-view");
                        i === this.viewItems.length ? this.viewContainer.appendChild(a) : this.viewContainer.insertBefore(a, this.viewContainer.children.item(i));
                        const d = e.onDidChange((e => this.onViewChange(p, e))),
                            h = (0, c.OF)((() => this.viewContainer.removeChild(a))),
                            u = (0, c.F8)(d, h);
                        let g;
                        g = "number" == typeof t ? t : "split" === t.type ? this.getViewSize(t.index) / 2 : "invisible" === t.type ? {
                            cachedVisibleSize: t.cachedVisibleSize
                        } : e.minimumSize;
                        const p = 0 === this.orientation ? new f(a, e, g, u) : new m(a, e, g, u);
                        if (this.viewItems.splice(i, 0, p), this.viewItems.length > 1) {
                            let e = {
                                orthogonalStartSash: this.orthogonalStartSash,
                                orthogonalEndSash: this.orthogonalEndSash
                            };
                            const t = 0 === this.orientation ? new o.g(this.sashContainer, {
                                    getHorizontalSashTop: e => this.getSashPosition(e),
                                    getHorizontalSashWidth: this.getSashOrthogonalSize
                                }, Object.assign(Object.assign({}, e), {
                                    orientation: 1
                                })) : new o.g(this.sashContainer, {
                                    getVerticalSashLeft: e => this.getSashPosition(e),
                                    getVerticalSashHeight: this.getSashOrthogonalSize
                                }, Object.assign(Object.assign({}, e), {
                                    orientation: 0
                                })),
                                n = 0 === this.orientation ? e => ({
                                    sash: t,
                                    start: e.startY,
                                    current: e.currentY,
                                    alt: e.altKey
                                }) : e => ({
                                    sash: t,
                                    start: e.startX,
                                    current: e.currentX,
                                    alt: e.altKey
                                }),
                                s = l.ju.map(t.onDidStart, n)(this.onSashStart, this),
                                a = l.ju.map(t.onDidChange, n)(this.onSashChange, this),
                                d = l.ju.map(t.onDidEnd, (() => this.sashItems.findIndex((e => e.sash === t)))),
                                h = d(this.onSashEnd, this),
                                u = t.onDidReset((() => {
                                    const e = this.sashItems.findIndex((e => e.sash === t)),
                                        i = (0, r.w6)(e, -1),
                                        n = (0, r.w6)(e + 1, this.viewItems.length),
                                        o = this.findFirstSnapIndex(i),
                                        s = this.findFirstSnapIndex(n);
                                    ("number" != typeof o || this.viewItems[o].visible) && ("number" != typeof s || this.viewItems[s].visible) && this._onDidSashReset.fire(e)
                                })),
                                g = (0, c.F8)(s, a, h, u, t),
                                p = {
                                    sash: t,
                                    disposable: g
                                };
                            this.sashItems.splice(i - 1, 0, p)
                        }
                        let _;
                        a.appendChild(e.element), "number" != typeof t && "split" === t.type && (_ = [t.index]), s || this.relayout([i], _), this.state = v.Idle, s || "number" == typeof t || "distribute" !== t.type || this.distributeViewSizes()
                    }
                    relayout(e, t) {
                        const i = this.viewItems.reduce(((e, t) => e + t.size), 0);
                        this.resize(this.viewItems.length - 1, this.size - i, void 0, e, t), this.distributeEmptySpace(), this.layoutViews(), this.saveProportions()
                    }
                    resize(e, t, i = this.viewItems.map((e => e.size)), n, o, s = Number.NEGATIVE_INFINITY, a = Number.POSITIVE_INFINITY, l, c) {
                        if (e < 0 || e >= this.viewItems.length) return 0;
                        const h = (0, r.w6)(e, -1),
                            u = (0, r.w6)(e + 1, this.viewItems.length);
                        if (o)
                            for (const e of o)(0, r.zI)(h, e), (0, r.zI)(u, e);
                        if (n)
                            for (const e of n)(0, r.al)(h, e), (0, r.al)(u, e);
                        const g = h.map((e => this.viewItems[e])),
                            p = h.map((e => i[e])),
                            f = u.map((e => this.viewItems[e])),
                            m = u.map((e => i[e])),
                            v = h.reduce(((e, t) => e + (this.viewItems[t].minimumSize - i[t])), 0),
                            _ = h.reduce(((e, t) => e + (this.viewItems[t].maximumSize - i[t])), 0),
                            b = 0 === u.length ? Number.POSITIVE_INFINITY : u.reduce(((e, t) => e + (i[t] - this.viewItems[t].minimumSize)), 0),
                            w = 0 === u.length ? Number.NEGATIVE_INFINITY : u.reduce(((e, t) => e + (i[t] - this.viewItems[t].maximumSize)), 0),
                            y = Math.max(v, w, s),
                            C = Math.min(b, _, a);
                        let x = !1;
                        if (l) {
                            const e = this.viewItems[l.index],
                                i = t >= l.limitDelta;
                            x = i !== e.visible, e.setVisible(i, l.size)
                        }
                        if (!x && c) {
                            const e = this.viewItems[c.index],
                                i = t < c.limitDelta;
                            x = i !== e.visible, e.setVisible(i, c.size)
                        }
                        if (x) return this.resize(e, t, i, n, o, s, a);
                        for (let e = 0, i = t = (0, d.u)(t, y, C); e < g.length; e++) {
                            const t = g[e],
                                n = (0, d.u)(p[e] + i, t.minimumSize, t.maximumSize);
                            i -= n - p[e], t.size = n
                        }
                        for (let e = 0, i = t; e < f.length; e++) {
                            const t = f[e],
                                n = (0, d.u)(m[e] - i, t.minimumSize, t.maximumSize);
                            i += n - m[e], t.size = n
                        }
                        return t
                    }
                    distributeEmptySpace(e) {
                        const t = this.viewItems.reduce(((e, t) => e + t.size), 0);
                        let i = this.size - t;
                        const n = (0, r.w6)(this.viewItems.length - 1, -1),
                            o = n.filter((e => 1 === this.viewItems[e].priority)),
                            s = n.filter((e => 2 === this.viewItems[e].priority));
                        for (const e of s)(0, r.zI)(n, e);
                        for (const e of o)(0, r.al)(n, e);
                        "number" == typeof e && (0, r.al)(n, e);
                        for (let e = 0; 0 !== i && e < n.length; e++) {
                            const t = this.viewItems[n[e]],
                                o = (0, d.u)(t.size + i, t.minimumSize, t.maximumSize);
                            i -= o - t.size, t.size = o
                        }
                    }
                    layoutViews() {
                        this.contentSize = this.viewItems.reduce(((e, t) => e + t.size), 0);
                        let e = 0;
                        for (const t of this.viewItems) t.layout(e, this.layoutContext), e += t.size;
                        this.sashItems.forEach((e => e.sash.layout())), this.updateSashEnablement(), this.updateScrollableElement()
                    }
                    updateScrollableElement() {
                        0 === this.orientation ? this.scrollableElement.setScrollDimensions({
                            height: this.size,
                            scrollHeight: this.contentSize
                        }) : this.scrollableElement.setScrollDimensions({
                            width: this.size,
                            scrollWidth: this.contentSize
                        })
                    }
                    updateSashEnablement() {
                        let e = !1;
                        const t = this.viewItems.map((t => e = t.size - t.minimumSize > 0 || e));
                        e = !1;
                        const i = this.viewItems.map((t => e = t.maximumSize - t.size > 0 || e)),
                            n = [...this.viewItems].reverse();
                        e = !1;
                        const o = n.map((t => e = t.size - t.minimumSize > 0 || e)).reverse();
                        e = !1;
                        const s = n.map((t => e = t.maximumSize - t.size > 0 || e)).reverse();
                        let a = 0;
                        for (let e = 0; e < this.sashItems.length; e++) {
                            const {
                                sash: n
                            } = this.sashItems[e];
                            a += this.viewItems[e].size;
                            const l = !(t[e] && s[e + 1]),
                                c = !(i[e] && o[e + 1]);
                            if (l && c) {
                                const i = (0, r.w6)(e, -1),
                                    s = (0, r.w6)(e + 1, this.viewItems.length),
                                    l = this.findFirstSnapIndex(i),
                                    c = this.findFirstSnapIndex(s),
                                    d = "number" == typeof l && !this.viewItems[l].visible,
                                    h = "number" == typeof c && !this.viewItems[c].visible;
                                d && o[e] && (a > 0 || this.startSnappingEnabled) ? n.state = 1 : h && t[e] && (a < this.contentSize || this.endSnappingEnabled) ? n.state = 2 : n.state = 0
                            } else n.state = l && !c ? 1 : !l && c ? 2 : 3
                        }
                    }
                    getSashPosition(e) {
                        let t = 0;
                        for (let i = 0; i < this.sashItems.length; i++)
                            if (t += this.viewItems[i].size, this.sashItems[i].sash === e) return t;
                        return 0
                    }
                    findFirstSnapIndex(e) {
                        for (const t of e) {
                            const e = this.viewItems[t];
                            if (e.visible && e.snap) return t
                        }
                        for (const t of e) {
                            const e = this.viewItems[t];
                            if (e.visible && e.maximumSize - e.minimumSize > 0) return;
                            if (!e.visible && e.snap) return t
                        }
                    }
                    dispose() {
                        super.dispose(), this.viewItems.forEach((e => e.dispose())), this.viewItems = [], this.sashItems.forEach((e => e.disposable.dispose())), this.sashItems = []
                    }
                }
            },
            93794: (e, t, i) => {
                "use strict";
                i.d(t, {
                    $: () => l
                });
                var n = i(65321),
                    o = i(59069),
                    s = i(23938),
                    r = i(10553),
                    a = i(5976);
                class l extends a.JT {
                    onclick(e, t) {
                        this._register(n.nm(e, n.tw.CLICK, (e => t(new s.n(e)))))
                    }
                    onmousedown(e, t) {
                        this._register(n.nm(e, n.tw.MOUSE_DOWN, (e => t(new s.n(e)))))
                    }
                    onmouseover(e, t) {
                        this._register(n.nm(e, n.tw.MOUSE_OVER, (e => t(new s.n(e)))))
                    }
                    onnonbubblingmouseout(e, t) {
                        this._register(n.j_(e, (e => t(new s.n(e)))))
                    }
                    onkeydown(e, t) {
                        this._register(n.nm(e, n.tw.KEY_DOWN, (e => t(new o.y(e)))))
                    }
                    onkeyup(e, t) {
                        this._register(n.nm(e, n.tw.KEY_UP, (e => t(new o.y(e)))))
                    }
                    oninput(e, t) {
                        this._register(n.nm(e, n.tw.INPUT, t))
                    }
                    onblur(e, t) {
                        this._register(n.nm(e, n.tw.BLUR, t))
                    }
                    onfocus(e, t) {
                        this._register(n.nm(e, n.tw.FOCUS, t))
                    }
                    ignoreGesture(e) {
                        r.o.ignoreTarget(e)
                    }
                }
            },
            74741: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Wi: () => l,
                    Z0: () => c,
                    aU: () => a,
                    eZ: () => h,
                    wY: () => d
                });
                var n = i(4669),
                    o = i(5976),
                    s = i(63580),
                    r = function(e, t, i, n) {
                        return new(i || (i = Promise))((function(o, s) {
                            function r(e) {
                                try {
                                    l(n.next(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function a(e) {
                                try {
                                    l(n.throw(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function l(e) {
                                var t;
                                e.done ? o(e.value) : (t = e.value, t instanceof i ? t : new i((function(e) {
                                    e(t)
                                }))).then(r, a)
                            }
                            l((n = n.apply(e, t || [])).next())
                        }))
                    };
                class a extends o.JT {
                    constructor(e, t = "", i = "", o = !0, s) {
                        super(), this._onDidChange = this._register(new n.Q5), this.onDidChange = this._onDidChange.event, this._enabled = !0, this._id = e, this._label = t, this._cssClass = i, this._enabled = o, this._actionCallback = s
                    }
                    get id() {
                        return this._id
                    }
                    get label() {
                        return this._label
                    }
                    set label(e) {
                        this._setLabel(e)
                    }
                    _setLabel(e) {
                        this._label !== e && (this._label = e, this._onDidChange.fire({
                            label: e
                        }))
                    }
                    get tooltip() {
                        return this._tooltip || ""
                    }
                    set tooltip(e) {
                        this._setTooltip(e)
                    }
                    _setTooltip(e) {
                        this._tooltip !== e && (this._tooltip = e, this._onDidChange.fire({
                            tooltip: e
                        }))
                    }
                    get class() {
                        return this._cssClass
                    }
                    set class(e) {
                        this._setClass(e)
                    }
                    _setClass(e) {
                        this._cssClass !== e && (this._cssClass = e, this._onDidChange.fire({
                            class: e
                        }))
                    }
                    get enabled() {
                        return this._enabled
                    }
                    set enabled(e) {
                        this._setEnabled(e)
                    }
                    _setEnabled(e) {
                        this._enabled !== e && (this._enabled = e, this._onDidChange.fire({
                            enabled: e
                        }))
                    }
                    get checked() {
                        return this._checked
                    }
                    set checked(e) {
                        this._setChecked(e)
                    }
                    _setChecked(e) {
                        this._checked !== e && (this._checked = e, this._onDidChange.fire({
                            checked: e
                        }))
                    }
                    run(e, t) {
                        return r(this, void 0, void 0, (function*() {
                            this._actionCallback && (yield this._actionCallback(e))
                        }))
                    }
                }
                class l extends o.JT {
                    constructor() {
                        super(...arguments), this._onBeforeRun = this._register(new n.Q5), this.onBeforeRun = this._onBeforeRun.event, this._onDidRun = this._register(new n.Q5), this.onDidRun = this._onDidRun.event
                    }
                    run(e, t) {
                        return r(this, void 0, void 0, (function*() {
                            if (!e.enabled) return;
                            let i;
                            this._onBeforeRun.fire({
                                action: e
                            });
                            try {
                                yield this.runAction(e, t)
                            } catch (e) {
                                i = e
                            }
                            this._onDidRun.fire({
                                action: e,
                                error: i
                            })
                        }))
                    }
                    runAction(e, t) {
                        return r(this, void 0, void 0, (function*() {
                            yield e.run(t)
                        }))
                    }
                }
                class c extends a {
                    constructor(e) {
                        super(c.ID, e, e ? "separator text" : "separator"), this.checked = !1, this.enabled = !1
                    }
                }
                c.ID = "vs.actions.separator";
                class d {
                    constructor(e, t, i, n) {
                        this.tooltip = "", this.enabled = !0, this.checked = !1, this.id = e, this.label = t, this.class = n, this._actions = i
                    }
                    get actions() {
                        return this._actions
                    }
                    dispose() {}
                    run() {
                        return r(this, void 0, void 0, (function*() {}))
                    }
                }
                class h extends a {
                    constructor() {
                        super(h.ID, s.N("submenu.empty", "(empty)"), void 0, !1)
                    }
                }
                h.ID = "vs.actions.empty"
            },
            9488: (e, t, i) => {
                "use strict";

                function n(e, t = 0) {
                    return e[e.length - (1 + t)]
                }

                function o(e) {
                    if (0 === e.length) throw new Error("Invalid tail call");
                    return [e.slice(0, e.length - 1), e[e.length - 1]]
                }

                function s(e, t, i = ((e, t) => e === t)) {
                    if (e === t) return !0;
                    if (!e || !t) return !1;
                    if (e.length !== t.length) return !1;
                    for (let n = 0, o = e.length; n < o; n++)
                        if (!i(e[n], t[n])) return !1;
                    return !0
                }

                function r(e, t, i) {
                    let n = 0,
                        o = e.length - 1;
                    for (; n <= o;) {
                        const s = (n + o) / 2 | 0,
                            r = i(e[s], t);
                        if (r < 0) n = s + 1;
                        else {
                            if (!(r > 0)) return s;
                            o = s - 1
                        }
                    }
                    return -(n + 1)
                }

                function a(e, t) {
                    let i = 0,
                        n = e.length;
                    if (0 === n) return 0;
                    for (; i < n;) {
                        const o = Math.floor((i + n) / 2);
                        t(e[o]) ? n = o : i = o + 1
                    }
                    return i
                }

                function l(e, t, i) {
                    if ((e |= 0) >= t.length) throw new TypeError("invalid index");
                    let n = t[Math.floor(t.length * Math.random())],
                        o = [],
                        s = [],
                        r = [];
                    for (let e of t) {
                        const t = i(e, n);
                        t < 0 ? o.push(e) : t > 0 ? s.push(e) : r.push(e)
                    }
                    return e < o.length ? l(e, o, i) : e < o.length + r.length ? r[0] : l(e - (o.length + r.length), s, i)
                }

                function c(e, t) {
                    const i = [];
                    let n;
                    for (const o of e.slice(0).sort(t)) n && 0 === t(n[0], o) ? n.push(o) : (n = [o], i.push(n));
                    return i
                }

                function d(e) {
                    return e.filter((e => !!e))
                }

                function h(e) {
                    return !Array.isArray(e) || 0 === e.length
                }

                function u(e) {
                    return Array.isArray(e) && e.length > 0
                }

                function g(e, t = (e => e)) {
                    const i = new Set;
                    return e.filter((e => {
                        const n = t(e);
                        return !i.has(n) && (i.add(n), !0)
                    }))
                }

                function p(e, t) {
                    const i = function(e, t) {
                        for (let i = e.length - 1; i >= 0; i--) {
                            if (t(e[i])) return i
                        }
                        return -1
                    }(e, t);
                    if (-1 !== i) return e[i]
                }

                function f(e, t) {
                    return e.length > 0 ? e[0] : t
                }

                function m(e) {
                    return [].concat(...e)
                }

                function v(e, t) {
                    let i = "number" == typeof t ? e : 0;
                    "number" == typeof t ? i = e : (i = 0, t = e);
                    const n = [];
                    if (i <= t)
                        for (let e = i; e < t; e++) n.push(e);
                    else
                        for (let e = i; e > t; e--) n.push(e);
                    return n
                }

                function _(e, t, i) {
                    const n = e.slice(0, t),
                        o = e.slice(t);
                    return n.concat(i, o)
                }

                function b(e, t) {
                    const i = e.indexOf(t);
                    i > -1 && (e.splice(i, 1), e.unshift(t))
                }

                function w(e, t) {
                    const i = e.indexOf(t);
                    i > -1 && (e.splice(i, 1), e.push(t))
                }

                function y(e) {
                    return Array.isArray(e) ? e : [e]
                }

                function C(e, t, i, n) {
                    const o = x(e, t),
                        s = e.splice(o, i);
                    return function(e, t, i) {
                        const n = x(e, t),
                            o = e.length,
                            s = i.length;
                        e.length = o + s;
                        for (let t = o - 1; t >= n; t--) e[t + s] = e[t];
                        for (let t = 0; t < s; t++) e[t + n] = i[t]
                    }(e, o, n), s
                }

                function x(e, t) {
                    return t < 0 ? Math.max(t + e.length, 0) : Math.min(t, e.length)
                }
                i.d(t, {
                    EB: () => g,
                    Gb: () => n,
                    H9: () => S,
                    HW: () => l,
                    JH: () => o,
                    Of: () => u,
                    XY: () => h,
                    Xh: () => f,
                    Zv: () => _,
                    _2: () => y,
                    al: () => w,
                    dF: () => p,
                    db: () => C,
                    fS: () => s,
                    kX: () => d,
                    lG: () => a,
                    ry: () => r,
                    vM: () => c,
                    w6: () => v,
                    xH: () => m,
                    zI: () => b
                });
                class S {
                    constructor(e) {
                        this.items = e, this.firstIdx = 0, this.lastIdx = this.items.length - 1
                    }
                    takeWhile(e) {
                        let t = this.firstIdx;
                        for (; t < this.items.length && e(this.items[t]);) t++;
                        const i = t === this.firstIdx ? null : this.items.slice(this.firstIdx, t);
                        return this.firstIdx = t, i
                    }
                    takeFromEndWhile(e) {
                        let t = this.lastIdx;
                        for (; t >= 0 && e(this.items[t]);) t--;
                        const i = t === this.lastIdx ? null : this.items.slice(t + 1, this.lastIdx + 1);
                        return this.lastIdx = t, i
                    }
                    peek() {
                        return this.items[this.firstIdx]
                    }
                }
            },
            35146: (e, t, i) => {
                "use strict";

                function n(e, t) {
                    if (!e) throw new Error(t ? `Assertion failed (${t})` : "Assertion Failed")
                }
                i.d(t, {
                    ok: () => n
                })
            },
            15393: (e, t, i) => {
                "use strict";
                i.d(t, {
                    J8: () => a,
                    PG: () => l,
                    Ps: () => f,
                    To: () => b,
                    Ue: () => w,
                    Vg: () => p,
                    Vs: () => g,
                    _F: () => m,
                    eP: () => c,
                    jT: () => y,
                    pY: () => _,
                    rH: () => u,
                    vp: () => h,
                    zh: () => v
                });
                var n = i(71050),
                    o = i(17301),
                    s = i(5976),
                    r = function(e, t, i, n) {
                        return new(i || (i = Promise))((function(o, s) {
                            function r(e) {
                                try {
                                    l(n.next(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function a(e) {
                                try {
                                    l(n.throw(e))
                                } catch (e) {
                                    s(e)
                                }
                            }

                            function l(e) {
                                var t;
                                e.done ? o(e.value) : (t = e.value, t instanceof i ? t : new i((function(e) {
                                    e(t)
                                }))).then(r, a)
                            }
                            l((n = n.apply(e, t || [])).next())
                        }))
                    };

                function a(e) {
                    return !!e && "function" == typeof e.then
                }

                function l(e) {
                    const t = new n.A,
                        i = e(t.token),
                        s = new Promise(((e, n) => {
                            const s = t.token.onCancellationRequested((() => {
                                s.dispose(), t.dispose(), n((0, o.F0)())
                            }));
                            Promise.resolve(i).then((i => {
                                s.dispose(), t.dispose(), e(i)
                            }), (e => {
                                s.dispose(), t.dispose(), n(e)
                            }))
                        }));
                    return new class {
                        cancel() {
                            t.cancel()
                        }
                        then(e, t) {
                            return s.then(e, t)
                        } catch (e) {
                            return this.then(void 0, e)
                        } finally(e) {
                            return s.finally(e)
                        }
                    }
                }

                function c(e, t, i) {
                    return Promise.race([e, new Promise((e => t.onCancellationRequested((() => e(i)))))])
                }
                class d {
                    constructor() {
                        this.activePromise = null, this.queuedPromise = null, this.queuedPromiseFactory = null
                    }
                    queue(e) {
                        if (this.activePromise) {
                            if (this.queuedPromiseFactory = e, !this.queuedPromise) {
                                const e = () => {
                                    this.queuedPromise = null;
                                    const e = this.queue(this.queuedPromiseFactory);
                                    return this.queuedPromiseFactory = null, e
                                };
                                this.queuedPromise = new Promise((t => {
                                    this.activePromise.then(e, e).then(t)
                                }))
                            }
                            return new Promise(((e, t) => {
                                this.queuedPromise.then(e, t)
                            }))
                        }
                        return this.activePromise = e(), new Promise(((e, t) => {
                            this.activePromise.then((t => {
                                this.activePromise = null, e(t)
                            }), (e => {
                                this.activePromise = null, t(e)
                            }))
                        }))
                    }
                }
                class h {
                    constructor(e) {
                        this.defaultDelay = e, this.timeout = null, this.completionPromise = null, this.doResolve = null, this.doReject = null, this.task = null
                    }
                    trigger(e, t = this.defaultDelay) {
                        return this.task = e, this.cancelTimeout(), this.completionPromise || (this.completionPromise = new Promise(((e, t) => {
                            this.doResolve = e, this.doReject = t
                        })).then((() => {
                            if (this.completionPromise = null, this.doResolve = null, this.task) {
                                const e = this.task;
                                return this.task = null, e()
                            }
                        }))), this.timeout = setTimeout((() => {
                            this.timeout = null, this.doResolve && this.doResolve(null)
                        }), t), this.completionPromise
                    }
                    isTriggered() {
                        return null !== this.timeout
                    }
                    cancel() {
                        this.cancelTimeout(), this.completionPromise && (this.doReject && this.doReject((0, o.F0)()), this.completionPromise = null)
                    }
                    cancelTimeout() {
                        null !== this.timeout && (clearTimeout(this.timeout), this.timeout = null)
                    }
                    dispose() {
                        this.cancel()
                    }
                }
                class u {
                    constructor(e) {
                        this.delayer = new h(e), this.throttler = new d
                    }
                    trigger(e, t) {
                        return this.delayer.trigger((() => this.throttler.queue(e)), t)
                    }
                    dispose() {
                        this.delayer.dispose()
                    }
                }

                function g(e, t) {
                    return t ? new Promise(((i, n) => {
                        const s = setTimeout((() => {
                                r.dispose(), i()
                            }), e),
                            r = t.onCancellationRequested((() => {
                                clearTimeout(s), r.dispose(), n((0, o.F0)())
                            }))
                    })) : l((t => g(e, t)))
                }

                function p(e, t = 0) {
                    const i = setTimeout(e, t);
                    return (0, s.OF)((() => clearTimeout(i)))
                }

                function f(e, t = (e => !!e), i = null) {
                    let n = 0;
                    const o = e.length,
                        s = () => {
                            if (n >= o) return Promise.resolve(i);
                            const r = e[n++];
                            return Promise.resolve(r()).then((e => t(e) ? Promise.resolve(e) : s()))
                        };
                    return s()
                }
                class m {
                    constructor(e, t) {
                        this._token = -1, "function" == typeof e && "number" == typeof t && this.setIfNotSet(e, t)
                    }
                    dispose() {
                        this.cancel()
                    }
                    cancel() {
                        -1 !== this._token && (clearTimeout(this._token), this._token = -1)
                    }
                    cancelAndSet(e, t) {
                        this.cancel(), this._token = setTimeout((() => {
                            this._token = -1, e()
                        }), t)
                    }
                    setIfNotSet(e, t) {
                        -1 === this._token && (this._token = setTimeout((() => {
                            this._token = -1, e()
                        }), t))
                    }
                }
                class v {
                    constructor() {
                        this._token = -1
                    }
                    dispose() {
                        this.cancel()
                    }
                    cancel() {
                        -1 !== this._token && (clearInterval(this._token), this._token = -1)
                    }
                    cancelAndSet(e, t) {
                        this.cancel(), this._token = setInterval((() => {
                            e()
                        }), t)
                    }
                }
                class _ {
                    constructor(e, t) {
                        this.timeoutToken = -1, this.runner = e, this.timeout = t, this.timeoutHandler = this.onTimeout.bind(this)
                    }
                    dispose() {
                        this.cancel(), this.runner = null
                    }
                    cancel() {
                        this.isScheduled() && (clearTimeout(this.timeoutToken), this.timeoutToken = -1)
                    }
                    schedule(e = this.timeout) {
                        this.cancel(), this.timeoutToken = setTimeout(this.timeoutHandler, e)
                    }
                    get delay() {
                        return this.timeout
                    }
                    set delay(e) {
                        this.timeout = e
                    }
                    isScheduled() {
                        return -1 !== this.timeoutToken
                    }
                    onTimeout() {
                        this.timeoutToken = -1, this.runner && this.doRun()
                    }
                    doRun() {
                        this.runner && this.runner()
                    }
                }
                let b;
                b = "function" != typeof requestIdleCallback || "function" != typeof cancelIdleCallback ? e => {
                    const t = setTimeout((() => {
                        const t = Date.now() + 15;
                        e(Object.freeze({
                            didTimeout: !0,
                            timeRemaining: () => Math.max(0, t - Date.now())
                        }))
                    }));
                    let i = !1;
                    return {
                        dispose() {
                            i || (i = !0, clearTimeout(t))
                        }
                    }
                } : (e, t) => {
                    const i = requestIdleCallback(e, "number" == typeof t ? {
                        timeout: t
                    } : void 0);
                    let n = !1;
                    return {
                        dispose() {
                            n || (n = !0, cancelIdleCallback(i))
                        }
                    }
                };
                class w {
                    constructor(e) {
                        this._didRun = !1, this._executor = () => {
                            try {
                                this._value = e()
                            } catch (e) {
                                this._error = e
                            } finally {
                                this._didRun = !0
                            }
                        }, this._handle = b((() => this._executor()))
                    }
                    dispose() {
                        this._handle.dispose()
                    }
                    get value() {
                        if (this._didRun || (this._handle.dispose(), this._executor()), this._error) throw this._error;
                        return this._value
                    }
                    get isInitialized() {
                        return this._didRun
                    }
                }
                var y;
                ! function(e) {
                    e.settled = function(e) {
                        return r(this, void 0, void 0, (function*() {
                            let t;
                            const i = yield Promise.all(e.map((e => e.then((e => e), (e => {
                                t || (t = e)
                            })))));
                            if (void 0 !== t) throw t;
                            return i
                        }))
                    }, e.withAsyncBody = function(e) {
                        return new Promise(((t, i) => r(this, void 0, void 0, (function*() {
                            try {
                                yield e(t, i)
                            } catch (e) {
                                i(e)
                            }
                        }))))
                    }
                }(y || (y = {}))
            },
            53060: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Ag: () => l,
                    Cg: () => h,
                    KN: () => s,
                    Q$: () => d,
                    T4: () => c,
                    mP: () => r,
                    oq: () => a
                });
                const n = "undefined" != typeof Buffer;
                let o;
                class s {
                    constructor(e) {
                        this.buffer = e, this.byteLength = this.buffer.byteLength
                    }
                    static wrap(e) {
                        return n && !Buffer.isBuffer(e) && (e = Buffer.from(e.buffer, e.byteOffset, e.byteLength)), new s(e)
                    }
                    toString() {
                        return n ? this.buffer.toString() : (o || (o = new TextDecoder), o.decode(this.buffer))
                    }
                }

                function r(e, t) {
                    return e[t + 0] << 0 >>> 0 | e[t + 1] << 8 >>> 0
                }

                function a(e, t, i) {
                    e[i + 0] = 255 & t, t >>>= 8, e[i + 1] = 255 & t
                }

                function l(e, t) {
                    return e[t] * Math.pow(2, 24) + e[t + 1] * Math.pow(2, 16) + e[t + 2] * Math.pow(2, 8) + e[t + 3]
                }

                function c(e, t, i) {
                    e[i + 3] = t, t >>>= 8, e[i + 2] = t, t >>>= 8, e[i + 1] = t, t >>>= 8, e[i] = t
                }

                function d(e, t) {
                    return e[t]
                }

                function h(e, t, i) {
                    e[i] = t
                }
            },
            71050: (e, t, i) => {
                "use strict";
                i.d(t, {
                    A: () => a,
                    T: () => s
                });
                var n = i(4669);
                const o = Object.freeze((function(e, t) {
                    const i = setTimeout(e.bind(t), 0);
                    return {
                        dispose() {
                            clearTimeout(i)
                        }
                    }
                }));
                var s;
                ! function(e) {
                    e.isCancellationToken = function(t) {
                        return t === e.None || t === e.Cancelled || (t instanceof r || !(!t || "object" != typeof t) && ("boolean" == typeof t.isCancellationRequested && "function" == typeof t.onCancellationRequested))
                    }, e.None = Object.freeze({
                        isCancellationRequested: !1,
                        onCancellationRequested: n.ju.None
                    }), e.Cancelled = Object.freeze({
                        isCancellationRequested: !0,
                        onCancellationRequested: o
                    })
                }(s || (s = {}));
                class r {
                    constructor() {
                        this._isCancelled = !1, this._emitter = null
                    }
                    cancel() {
                        this._isCancelled || (this._isCancelled = !0, this._emitter && (this._emitter.fire(void 0), this.dispose()))
                    }
                    get isCancellationRequested() {
                        return this._isCancelled
                    }
                    get onCancellationRequested() {
                        return this._isCancelled ? o : (this._emitter || (this._emitter = new n.Q5), this._emitter.event)
                    }
                    dispose() {
                        this._emitter && (this._emitter.dispose(), this._emitter = null)
                    }
                }
                class a {
                    constructor(e) {
                        this._token = void 0, this._parentListener = void 0, this._parentListener = e && e.onCancellationRequested(this.cancel, this)
                    }
                    get token() {
                        return this._token || (this._token = new r), this._token
                    }
                    cancel() {
                        this._token ? this._token instanceof r && this._token.cancel() : this._token = s.Cancelled
                    }
                    dispose(e = !1) {
                        e && this.cancel(), this._parentListener && this._parentListener.dispose(), this._token ? this._token instanceof r && this._token.dispose() : this._token = s.None
                    }
                }
            },
            73046: (e, t, i) => {
                "use strict";
                i.d(t, {
                    CM: () => r,
                    JL: () => a,
                    dT: () => c,
                    fK: () => s,
                    lA: () => l
                });
                var n = i(4669);
                const o = new class {
                        constructor() {
                            this._icons = new Map, this._onDidRegister = new n.Q5
                        }
                        add(e) {
                            const t = this._icons.get(e.id);
                            t ? e.description ? t.description = e.description : console.error(`Duplicate registration of codicon ${e.id}`) : (this._icons.set(e.id, e), this._onDidRegister.fire(e))
                        }
                        get(e) {
                            return this._icons.get(e)
                        }
                        get all() {
                            return this._icons.values()
                        }
                        get onDidRegister() {
                            return this._onDidRegister.event
                        }
                    },
                    s = o;

                function r(e, t) {
                    return new l(e, t)
                }

                function a(e) {
                    return e ? e.replace(/\$\((.*?)\)/g, ((e, t) => ` ${t} `)).trim() : ""
                }
                class l {
                    constructor(e, t, i) {
                        this.id = e, this.definition = t, this.description = i, o.add(this)
                    }
                    get classNames() {
                        return "codicon codicon-" + this.id
                    }
                    get classNamesArray() {
                        return ["codicon", "codicon-" + this.id]
                    }
                    get cssSelector() {
                        return ".codicon.codicon-" + this.id
                    }
                }
                var c;
                ! function(e) {
                    e.iconNameSegment = "[A-Za-z0-9]+", e.iconNameExpression = "[A-Za-z0-9\\-]+", e.iconModifierExpression = "~[A-Za-z]+";
                    const t = new RegExp(`^(${e.iconNameExpression})(${e.iconModifierExpression})?$`);

                    function i(e) {
                        if (e instanceof l) return ["codicon", "codicon-" + e.id];
                        const n = t.exec(e.id);
                        if (!n) return i(l.error);
                        let [, o, s] = n;
                        const r = ["codicon", "codicon-" + o];
                        return s && r.push("codicon-modifier-" + s.substr(1)), r
                    }
                    e.asClassNameArray = i, e.asClassName = function(e) {
                        return i(e).join(" ")
                    }, e.asCSSSelector = function(e) {
                        return "." + i(e).join(".")
                    }
                }(c || (c = {})),
                function(e) {
                    e.add = new e("add", {
                        fontCharacter: "\\ea60"
                    }), e.plus = new e("plus", e.add.definition), e.gistNew = new e("gist-new", e.add.definition), e.repoCreate = new e("repo-create", e.add.definition), e.lightbulb = new e("lightbulb", {
                        fontCharacter: "\\ea61"
                    }), e.lightBulb = new e("light-bulb", {
                        fontCharacter: "\\ea61"
                    }), e.repo = new e("repo", {
                        fontCharacter: "\\ea62"
                    }), e.repoDelete = new e("repo-delete", {
                        fontCharacter: "\\ea62"
                    }), e.gistFork = new e("gist-fork", {
                        fontCharacter: "\\ea63"
                    }), e.repoForked = new e("repo-forked", {
                        fontCharacter: "\\ea63"
                    }), e.gitPullRequest = new e("git-pull-request", {
                        fontCharacter: "\\ea64"
                    }), e.gitPullRequestAbandoned = new e("git-pull-request-abandoned", {
                        fontCharacter: "\\ea64"
                    }), e.recordKeys = new e("record-keys", {
                        fontCharacter: "\\ea65"
                    }), e.keyboard = new e("keyboard", {
                        fontCharacter: "\\ea65"
                    }), e.tag = new e("tag", {
                        fontCharacter: "\\ea66"
                    }), e.tagAdd = new e("tag-add", {
                        fontCharacter: "\\ea66"
                    }), e.tagRemove = new e("tag-remove", {
                        fontCharacter: "\\ea66"
                    }), e.person = new e("person", {
                        fontCharacter: "\\ea67"
                    }), e.personFollow = new e("person-follow", {
                        fontCharacter: "\\ea67"
                    }), e.personOutline = new e("person-outline", {
                        fontCharacter: "\\ea67"
                    }), e.personFilled = new e("person-filled", {
                        fontCharacter: "\\ea67"
                    }), e.gitBranch = new e("git-branch", {
                        fontCharacter: "\\ea68"
                    }), e.gitBranchCreate = new e("git-branch-create", {
                        fontCharacter: "\\ea68"
                    }), e.gitBranchDelete = new e("git-branch-delete", {
                        fontCharacter: "\\ea68"
                    }), e.sourceControl = new e("source-control", {
                        fontCharacter: "\\ea68"
                    }), e.mirror = new e("mirror", {
                        fontCharacter: "\\ea69"
                    }), e.mirrorPublic = new e("mirror-public", {
                        fontCharacter: "\\ea69"
                    }), e.star = new e("star", {
                        fontCharacter: "\\ea6a"
                    }), e.starAdd = new e("star-add", {
                        fontCharacter: "\\ea6a"
                    }), e.starDelete = new e("star-delete", {
                        fontCharacter: "\\ea6a"
                    }), e.starEmpty = new e("star-empty", {
                        fontCharacter: "\\ea6a"
                    }), e.comment = new e("comment", {
                        fontCharacter: "\\ea6b"
                    }), e.commentAdd = new e("comment-add", {
                        fontCharacter: "\\ea6b"
                    }), e.alert = new e("alert", {
                        fontCharacter: "\\ea6c"
                    }), e.warning = new e("warning", {
                        fontCharacter: "\\ea6c"
                    }), e.search = new e("search", {
                        fontCharacter: "\\ea6d"
                    }), e.searchSave = new e("search-save", {
                        fontCharacter: "\\ea6d"
                    }), e.logOut = new e("log-out", {
                        fontCharacter: "\\ea6e"
                    }), e.signOut = new e("sign-out", {
                        fontCharacter: "\\ea6e"
                    }), e.logIn = new e("log-in", {
                        fontCharacter: "\\ea6f"
                    }), e.signIn = new e("sign-in", {
                        fontCharacter: "\\ea6f"
                    }), e.eye = new e("eye", {
                        fontCharacter: "\\ea70"
                    }), e.eyeUnwatch = new e("eye-unwatch", {
                        fontCharacter: "\\ea70"
                    }), e.eyeWatch = new e("eye-watch", {
                        fontCharacter: "\\ea70"
                    }), e.circleFilled = new e("circle-filled", {
                        fontCharacter: "\\ea71"
                    }), e.primitiveDot = new e("primitive-dot", {
                        fontCharacter: "\\ea71"
                    }), e.closeDirty = new e("close-dirty", {
                        fontCharacter: "\\ea71"
                    }), e.debugBreakpoint = new e("debug-breakpoint", {
                        fontCharacter: "\\ea71"
                    }), e.debugBreakpointDisabled = new e("debug-breakpoint-disabled", {
                        fontCharacter: "\\ea71"
                    }), e.debugHint = new e("debug-hint", {
                        fontCharacter: "\\ea71"
                    }), e.primitiveSquare = new e("primitive-square", {
                        fontCharacter: "\\ea72"
                    }), e.edit = new e("edit", {
                        fontCharacter: "\\ea73"
                    }), e.pencil = new e("pencil", {
                        fontCharacter: "\\ea73"
                    }), e.info = new e("info", {
                        fontCharacter: "\\ea74"
                    }), e.issueOpened = new e("issue-opened", {
                        fontCharacter: "\\ea74"
                    }), e.gistPrivate = new e("gist-private", {
                        fontCharacter: "\\ea75"
                    }), e.gitForkPrivate = new e("git-fork-private", {
                        fontCharacter: "\\ea75"
                    }), e.lock = new e("lock", {
                        fontCharacter: "\\ea75"
                    }), e.mirrorPrivate = new e("mirror-private", {
                        fontCharacter: "\\ea75"
                    }), e.close = new e("close", {
                        fontCharacter: "\\ea76"
                    }), e.removeClose = new e("remove-close", {
                        fontCharacter: "\\ea76"
                    }), e.x = new e("x", {
                        fontCharacter: "\\ea76"
                    }), e.repoSync = new e("repo-sync", {
                        fontCharacter: "\\ea77"
                    }), e.sync = new e("sync", {
                        fontCharacter: "\\ea77"
                    }), e.clone = new e("clone", {
                        fontCharacter: "\\ea78"
                    }), e.desktopDownload = new e("desktop-download", {
                        fontCharacter: "\\ea78"
                    }), e.beaker = new e("beaker", {
                        fontCharacter: "\\ea79"
                    }), e.microscope = new e("microscope", {
                        fontCharacter: "\\ea79"
                    }), e.vm = new e("vm", {
                        fontCharacter: "\\ea7a"
                    }), e.deviceDesktop = new e("device-desktop", {
                        fontCharacter: "\\ea7a"
                    }), e.file = new e("file", {
                        fontCharacter: "\\ea7b"
                    }), e.fileText = new e("file-text", {
                        fontCharacter: "\\ea7b"
                    }), e.more = new e("more", {
                        fontCharacter: "\\ea7c"
                    }), e.ellipsis = new e("ellipsis", {
                        fontCharacter: "\\ea7c"
                    }), e.kebabHorizontal = new e("kebab-horizontal", {
                        fontCharacter: "\\ea7c"
                    }), e.mailReply = new e("mail-reply", {
                        fontCharacter: "\\ea7d"
                    }), e.reply = new e("reply", {
                        fontCharacter: "\\ea7d"
                    }), e.organization = new e("organization", {
                        fontCharacter: "\\ea7e"
                    }), e.organizationFilled = new e("organization-filled", {
                        fontCharacter: "\\ea7e"
                    }), e.organizationOutline = new e("organization-outline", {
                        fontCharacter: "\\ea7e"
                    }), e.newFile = new e("new-file", {
                        fontCharacter: "\\ea7f"
                    }), e.fileAdd = new e("file-add", {
                        fontCharacter: "\\ea7f"
                    }), e.newFolder = new e("new-folder", {
                        fontCharacter: "\\ea80"
                    }), e.fileDirectoryCreate = new e("file-directory-create", {
                        fontCharacter: "\\ea80"
                    }), e.trash = new e("trash", {
                        fontCharacter: "\\ea81"
                    }), e.trashcan = new e("trashcan", {
                        fontCharacter: "\\ea81"
                    }), e.history = new e("history", {
                        fontCharacter: "\\ea82"
                    }), e.clock = new e("clock", {
                        fontCharacter: "\\ea82"
                    }), e.folder = new e("folder", {
                        fontCharacter: "\\ea83"
                    }), e.fileDirectory = new e("file-directory", {
                        fontCharacter: "\\ea83"
                    }), e.symbolFolder = new e("symbol-folder", {
                        fontCharacter: "\\ea83"
                    }), e.logoGithub = new e("logo-github", {
                        fontCharacter: "\\ea84"
                    }), e.markGithub = new e("mark-github", {
                        fontCharacter: "\\ea84"
                    }), e.github = new e("github", {
                        fontCharacter: "\\ea84"
                    }), e.terminal = new e("terminal", {
                        fontCharacter: "\\ea85"
                    }), e.console = new e("console", {
                        fontCharacter: "\\ea85"
                    }), e.repl = new e("repl", {
                        fontCharacter: "\\ea85"
                    }), e.zap = new e("zap", {
                        fontCharacter: "\\ea86"
                    }), e.symbolEvent = new e("symbol-event", {
                        fontCharacter: "\\ea86"
                    }), e.error = new e("error", {
                        fontCharacter: "\\ea87"
                    }), e.stop = new e("stop", {
                        fontCharacter: "\\ea87"
                    }), e.variable = new e("variable", {
                        fontCharacter: "\\ea88"
                    }), e.symbolVariable = new e("symbol-variable", {
                        fontCharacter: "\\ea88"
                    }), e.array = new e("array", {
                        fontCharacter: "\\ea8a"
                    }), e.symbolArray = new e("symbol-array", {
                        fontCharacter: "\\ea8a"
                    }), e.symbolModule = new e("symbol-module", {
                        fontCharacter: "\\ea8b"
                    }), e.symbolPackage = new e("symbol-package", {
                        fontCharacter: "\\ea8b"
                    }), e.symbolNamespace = new e("symbol-namespace", {
                        fontCharacter: "\\ea8b"
                    }), e.symbolObject = new e("symbol-object", {
                        fontCharacter: "\\ea8b"
                    }), e.symbolMethod = new e("symbol-method", {
                        fontCharacter: "\\ea8c"
                    }), e.symbolFunction = new e("symbol-function", {
                        fontCharacter: "\\ea8c"
                    }), e.symbolConstructor = new e("symbol-constructor", {
                        fontCharacter: "\\ea8c"
                    }), e.symbolBoolean = new e("symbol-boolean", {
                        fontCharacter: "\\ea8f"
                    }), e.symbolNull = new e("symbol-null", {
                        fontCharacter: "\\ea8f"
                    }), e.symbolNumeric = new e("symbol-numeric", {
                        fontCharacter: "\\ea90"
                    }), e.symbolNumber = new e("symbol-number", {
                        fontCharacter: "\\ea90"
                    }), e.symbolStructure = new e("symbol-structure", {
                        fontCharacter: "\\ea91"
                    }), e.symbolStruct = new e("symbol-struct", {
                        fontCharacter: "\\ea91"
                    }), e.symbolParameter = new e("symbol-parameter", {
                        fontCharacter: "\\ea92"
                    }), e.symbolTypeParameter = new e("symbol-type-parameter", {
                        fontCharacter: "\\ea92"
                    }), e.symbolKey = new e("symbol-key", {
                        fontCharacter: "\\ea93"
                    }), e.symbolText = new e("symbol-text", {
                        fontCharacter: "\\ea93"
                    }), e.symbolReference = new e("symbol-reference", {
                        fontCharacter: "\\ea94"
                    }), e.goToFile = new e("go-to-file", {
                        fontCharacter: "\\ea94"
                    }), e.symbolEnum = new e("symbol-enum", {
                        fontCharacter: "\\ea95"
                    }), e.symbolValue = new e("symbol-value", {
                        fontCharacter: "\\ea95"
                    }), e.symbolRuler = new e("symbol-ruler", {
                        fontCharacter: "\\ea96"
                    }), e.symbolUnit = new e("symbol-unit", {
                        fontCharacter: "\\ea96"
                    }), e.activateBreakpoints = new e("activate-breakpoints", {
                        fontCharacter: "\\ea97"
                    }), e.archive = new e("archive", {
                        fontCharacter: "\\ea98"
                    }), e.arrowBoth = new e("arrow-both", {
                        fontCharacter: "\\ea99"
                    }), e.arrowDown = new e("arrow-down", {
                        fontCharacter: "\\ea9a"
                    }), e.arrowLeft = new e("arrow-left", {
                        fontCharacter: "\\ea9b"
                    }), e.arrowRight = new e("arrow-right", {
                        fontCharacter: "\\ea9c"
                    }), e.arrowSmallDown = new e("arrow-small-down", {
                        fontCharacter: "\\ea9d"
                    }), e.arrowSmallLeft = new e("arrow-small-left", {
                        fontCharacter: "\\ea9e"
                    }), e.arrowSmallRight = new e("arrow-small-right", {
                        fontCharacter: "\\ea9f"
                    }), e.arrowSmallUp = new e("arrow-small-up", {
                        fontCharacter: "\\eaa0"
                    }), e.arrowUp = new e("arrow-up", {
                        fontCharacter: "\\eaa1"
                    }), e.bell = new e("bell", {
                        fontCharacter: "\\eaa2"
                    }), e.bold = new e("bold", {
                        fontCharacter: "\\eaa3"
                    }), e.book = new e("book", {
                        fontCharacter: "\\eaa4"
                    }), e.bookmark = new e("bookmark", {
                        fontCharacter: "\\eaa5"
                    }), e.debugBreakpointConditionalUnverified = new e("debug-breakpoint-conditional-unverified", {
                        fontCharacter: "\\eaa6"
                    }), e.debugBreakpointConditional = new e("debug-breakpoint-conditional", {
                        fontCharacter: "\\eaa7"
                    }), e.debugBreakpointConditionalDisabled = new e("debug-breakpoint-conditional-disabled", {
                        fontCharacter: "\\eaa7"
                    }), e.debugBreakpointDataUnverified = new e("debug-breakpoint-data-unverified", {
                        fontCharacter: "\\eaa8"
                    }), e.debugBreakpointData = new e("debug-breakpoint-data", {
                        fontCharacter: "\\eaa9"
                    }), e.debugBreakpointDataDisabled = new e("debug-breakpoint-data-disabled", {
                        fontCharacter: "\\eaa9"
                    }), e.debugBreakpointLogUnverified = new e("debug-breakpoint-log-unverified", {
                        fontCharacter: "\\eaaa"
                    }), e.debugBreakpointLog = new e("debug-breakpoint-log", {
                        fontCharacter: "\\eaab"
                    }), e.debugBreakpointLogDisabled = new e("debug-breakpoint-log-disabled", {
                        fontCharacter: "\\eaab"
                    }), e.briefcase = new e("briefcase", {
                        fontCharacter: "\\eaac"
                    }), e.broadcast = new e("broadcast", {
                        fontCharacter: "\\eaad"
                    }), e.browser = new e("browser", {
                        fontCharacter: "\\eaae"
                    }), e.bug = new e("bug", {
                        fontCharacter: "\\eaaf"
                    }), e.calendar = new e("calendar", {
                        fontCharacter: "\\eab0"
                    }), e.caseSensitive = new e("case-sensitive", {
                        fontCharacter: "\\eab1"
                    }), e.check = new e("check", {
                        fontCharacter: "\\eab2"
                    }), e.checklist = new e("checklist", {
                        fontCharacter: "\\eab3"
                    }), e.chevronDown = new e("chevron-down", {
                        fontCharacter: "\\eab4"
                    }), e.dropDownButton = new e("drop-down-button", e.chevronDown.definition), e.chevronLeft = new e("chevron-left", {
                        fontCharacter: "\\eab5"
                    }), e.chevronRight = new e("chevron-right", {
                        fontCharacter: "\\eab6"
                    }), e.chevronUp = new e("chevron-up", {
                        fontCharacter: "\\eab7"
                    }), e.chromeClose = new e("chrome-close", {
                        fontCharacter: "\\eab8"
                    }), e.chromeMaximize = new e("chrome-maximize", {
                        fontCharacter: "\\eab9"
                    }), e.chromeMinimize = new e("chrome-minimize", {
                        fontCharacter: "\\eaba"
                    }), e.chromeRestore = new e("chrome-restore", {
                        fontCharacter: "\\eabb"
                    }), e.circleOutline = new e("circle-outline", {
                        fontCharacter: "\\eabc"
                    }), e.debugBreakpointUnverified = new e("debug-breakpoint-unverified", {
                        fontCharacter: "\\eabc"
                    }), e.circleSlash = new e("circle-slash", {
                        fontCharacter: "\\eabd"
                    }), e.circuitBoard = new e("circuit-board", {
                        fontCharacter: "\\eabe"
                    }), e.clearAll = new e("clear-all", {
                        fontCharacter: "\\eabf"
                    }), e.clippy = new e("clippy", {
                        fontCharacter: "\\eac0"
                    }), e.closeAll = new e("close-all", {
                        fontCharacter: "\\eac1"
                    }), e.cloudDownload = new e("cloud-download", {
                        fontCharacter: "\\eac2"
                    }), e.cloudUpload = new e("cloud-upload", {
                        fontCharacter: "\\eac3"
                    }), e.code = new e("code", {
                        fontCharacter: "\\eac4"
                    }), e.collapseAll = new e("collapse-all", {
                        fontCharacter: "\\eac5"
                    }), e.colorMode = new e("color-mode", {
                        fontCharacter: "\\eac6"
                    }), e.commentDiscussion = new e("comment-discussion", {
                        fontCharacter: "\\eac7"
                    }), e.compareChanges = new e("compare-changes", {
                        fontCharacter: "\\eafd"
                    }), e.creditCard = new e("credit-card", {
                        fontCharacter: "\\eac9"
                    }), e.dash = new e("dash", {
                        fontCharacter: "\\eacc"
                    }), e.dashboard = new e("dashboard", {
                        fontCharacter: "\\eacd"
                    }), e.database = new e("database", {
                        fontCharacter: "\\eace"
                    }), e.debugContinue = new e("debug-continue", {
                        fontCharacter: "\\eacf"
                    }), e.debugDisconnect = new e("debug-disconnect", {
                        fontCharacter: "\\ead0"
                    }), e.debugPause = new e("debug-pause", {
                        fontCharacter: "\\ead1"
                    }), e.debugRestart = new e("debug-restart", {
                        fontCharacter: "\\ead2"
                    }), e.debugStart = new e("debug-start", {
                        fontCharacter: "\\ead3"
                    }), e.debugStepInto = new e("debug-step-into", {
                        fontCharacter: "\\ead4"
                    }), e.debugStepOut = new e("debug-step-out", {
                        fontCharacter: "\\ead5"
                    }), e.debugStepOver = new e("debug-step-over", {
                        fontCharacter: "\\ead6"
                    }), e.debugStop = new e("debug-stop", {
                        fontCharacter: "\\ead7"
                    }), e.debug = new e("debug", {
                        fontCharacter: "\\ead8"
                    }), e.deviceCameraVideo = new e("device-camera-video", {
                        fontCharacter: "\\ead9"
                    }), e.deviceCamera = new e("device-camera", {
                        fontCharacter: "\\eada"
                    }), e.deviceMobile = new e("device-mobile", {
                        fontCharacter: "\\eadb"
                    }), e.diffAdded = new e("diff-added", {
                        fontCharacter: "\\eadc"
                    }), e.diffIgnored = new e("diff-ignored", {
                        fontCharacter: "\\eadd"
                    }), e.diffModified = new e("diff-modified", {
                        fontCharacter: "\\eade"
                    }), e.diffRemoved = new e("diff-removed", {
                        fontCharacter: "\\eadf"
                    }), e.diffRenamed = new e("diff-renamed", {
                        fontCharacter: "\\eae0"
                    }), e.diff = new e("diff", {
                        fontCharacter: "\\eae1"
                    }), e.discard = new e("discard", {
                        fontCharacter: "\\eae2"
                    }), e.editorLayout = new e("editor-layout", {
                        fontCharacter: "\\eae3"
                    }), e.emptyWindow = new e("empty-window", {
                        fontCharacter: "\\eae4"
                    }), e.exclude = new e("exclude", {
                        fontCharacter: "\\eae5"
                    }), e.extensions = new e("extensions", {
                        fontCharacter: "\\eae6"
                    }), e.eyeClosed = new e("eye-closed", {
                        fontCharacter: "\\eae7"
                    }), e.fileBinary = new e("file-binary", {
                        fontCharacter: "\\eae8"
                    }), e.fileCode = new e("file-code", {
                        fontCharacter: "\\eae9"
                    }), e.fileMedia = new e("file-media", {
                        fontCharacter: "\\eaea"
                    }), e.filePdf = new e("file-pdf", {
                        fontCharacter: "\\eaeb"
                    }), e.fileSubmodule = new e("file-submodule", {
                        fontCharacter: "\\eaec"
                    }), e.fileSymlinkDirectory = new e("file-symlink-directory", {
                        fontCharacter: "\\eaed"
                    }), e.fileSymlinkFile = new e("file-symlink-file", {
                        fontCharacter: "\\eaee"
                    }), e.fileZip = new e("file-zip", {
                        fontCharacter: "\\eaef"
                    }), e.files = new e("files", {
                        fontCharacter: "\\eaf0"
                    }), e.filter = new e("filter", {
                        fontCharacter: "\\eaf1"
                    }), e.flame = new e("flame", {
                        fontCharacter: "\\eaf2"
                    }), e.foldDown = new e("fold-down", {
                        fontCharacter: "\\eaf3"
                    }), e.foldUp = new e("fold-up", {
                        fontCharacter: "\\eaf4"
                    }), e.fold = new e("fold", {
                        fontCharacter: "\\eaf5"
                    }), e.folderActive = new e("folder-active", {
                        fontCharacter: "\\eaf6"
                    }), e.folderOpened = new e("folder-opened", {
                        fontCharacter: "\\eaf7"
                    }), e.gear = new e("gear", {
                        fontCharacter: "\\eaf8"
                    }), e.gift = new e("gift", {
                        fontCharacter: "\\eaf9"
                    }), e.gistSecret = new e("gist-secret", {
                        fontCharacter: "\\eafa"
                    }), e.gist = new e("gist", {
                        fontCharacter: "\\eafb"
                    }), e.gitCommit = new e("git-commit", {
                        fontCharacter: "\\eafc"
                    }), e.gitCompare = new e("git-compare", {
                        fontCharacter: "\\eafd"
                    }), e.gitMerge = new e("git-merge", {
                        fontCharacter: "\\eafe"
                    }), e.githubAction = new e("github-action", {
                        fontCharacter: "\\eaff"
                    }), e.githubAlt = new e("github-alt", {
                        fontCharacter: "\\eb00"
                    }), e.globe = new e("globe", {
                        fontCharacter: "\\eb01"
                    }), e.grabber = new e("grabber", {
                        fontCharacter: "\\eb02"
                    }), e.graph = new e("graph", {
                        fontCharacter: "\\eb03"
                    }), e.gripper = new e("gripper", {
                        fontCharacter: "\\eb04"
                    }), e.heart = new e("heart", {
                        fontCharacter: "\\eb05"
                    }), e.home = new e("home", {
                        fontCharacter: "\\eb06"
                    }), e.horizontalRule = new e("horizontal-rule", {
                        fontCharacter: "\\eb07"
                    }), e.hubot = new e("hubot", {
                        fontCharacter: "\\eb08"
                    }), e.inbox = new e("inbox", {
                        fontCharacter: "\\eb09"
                    }), e.issueClosed = new e("issue-closed", {
                        fontCharacter: "\\eba4"
                    }), e.issueReopened = new e("issue-reopened", {
                        fontCharacter: "\\eb0b"
                    }), e.issues = new e("issues", {
                        fontCharacter: "\\eb0c"
                    }), e.italic = new e("italic", {
                        fontCharacter: "\\eb0d"
                    }), e.jersey = new e("jersey", {
                        fontCharacter: "\\eb0e"
                    }), e.json = new e("json", {
                        fontCharacter: "\\eb0f"
                    }), e.kebabVertical = new e("kebab-vertical", {
                        fontCharacter: "\\eb10"
                    }), e.key = new e("key", {
                        fontCharacter: "\\eb11"
                    }), e.law = new e("law", {
                        fontCharacter: "\\eb12"
                    }), e.lightbulbAutofix = new e("lightbulb-autofix", {
                        fontCharacter: "\\eb13"
                    }), e.linkExternal = new e("link-external", {
                        fontCharacter: "\\eb14"
                    }), e.link = new e("link", {
                        fontCharacter: "\\eb15"
                    }), e.listOrdered = new e("list-ordered", {
                        fontCharacter: "\\eb16"
                    }), e.listUnordered = new e("list-unordered", {
                        fontCharacter: "\\eb17"
                    }), e.liveShare = new e("live-share", {
                        fontCharacter: "\\eb18"
                    }), e.loading = new e("loading", {
                        fontCharacter: "\\eb19"
                    }), e.location = new e("location", {
                        fontCharacter: "\\eb1a"
                    }), e.mailRead = new e("mail-read", {
                        fontCharacter: "\\eb1b"
                    }), e.mail = new e("mail", {
                        fontCharacter: "\\eb1c"
                    }), e.markdown = new e("markdown", {
                        fontCharacter: "\\eb1d"
                    }), e.megaphone = new e("megaphone", {
                        fontCharacter: "\\eb1e"
                    }), e.mention = new e("mention", {
                        fontCharacter: "\\eb1f"
                    }), e.milestone = new e("milestone", {
                        fontCharacter: "\\eb20"
                    }), e.mortarBoard = new e("mortar-board", {
                        fontCharacter: "\\eb21"
                    }), e.move = new e("move", {
                        fontCharacter: "\\eb22"
                    }), e.multipleWindows = new e("multiple-windows", {
                        fontCharacter: "\\eb23"
                    }), e.mute = new e("mute", {
                        fontCharacter: "\\eb24"
                    }), e.noNewline = new e("no-newline", {
                        fontCharacter: "\\eb25"
                    }), e.note = new e("note", {
                        fontCharacter: "\\eb26"
                    }), e.octoface = new e("octoface", {
                        fontCharacter: "\\eb27"
                    }), e.openPreview = new e("open-preview", {
                        fontCharacter: "\\eb28"
                    }), e.package_ = new e("package", {
                        fontCharacter: "\\eb29"
                    }), e.paintcan = new e("paintcan", {
                        fontCharacter: "\\eb2a"
                    }), e.pin = new e("pin", {
                        fontCharacter: "\\eb2b"
                    }), e.play = new e("play", {
                        fontCharacter: "\\eb2c"
                    }), e.run = new e("run", {
                        fontCharacter: "\\eb2c"
                    }), e.plug = new e("plug", {
                        fontCharacter: "\\eb2d"
                    }), e.preserveCase = new e("preserve-case", {
                        fontCharacter: "\\eb2e"
                    }), e.preview = new e("preview", {
                        fontCharacter: "\\eb2f"
                    }), e.project = new e("project", {
                        fontCharacter: "\\eb30"
                    }), e.pulse = new e("pulse", {
                        fontCharacter: "\\eb31"
                    }), e.question = new e("question", {
                        fontCharacter: "\\eb32"
                    }), e.quote = new e("quote", {
                        fontCharacter: "\\eb33"
                    }), e.radioTower = new e("radio-tower", {
                        fontCharacter: "\\eb34"
                    }), e.reactions = new e("reactions", {
                        fontCharacter: "\\eb35"
                    }), e.references = new e("references", {
                        fontCharacter: "\\eb36"
                    }), e.refresh = new e("refresh", {
                        fontCharacter: "\\eb37"
                    }), e.regex = new e("regex", {
                        fontCharacter: "\\eb38"
                    }), e.remoteExplorer = new e("remote-explorer", {
                        fontCharacter: "\\eb39"
                    }), e.remote = new e("remote", {
                        fontCharacter: "\\eb3a"
                    }), e.remove = new e("remove", {
                        fontCharacter: "\\eb3b"
                    }), e.replaceAll = new e("replace-all", {
                        fontCharacter: "\\eb3c"
                    }), e.replace = new e("replace", {
                        fontCharacter: "\\eb3d"
                    }), e.repoClone = new e("repo-clone", {
                        fontCharacter: "\\eb3e"
                    }), e.repoForcePush = new e("repo-force-push", {
                        fontCharacter: "\\eb3f"
                    }), e.repoPull = new e("repo-pull", {
                        fontCharacter: "\\eb40"
                    }), e.repoPush = new e("repo-push", {
                        fontCharacter: "\\eb41"
                    }), e.report = new e("report", {
                        fontCharacter: "\\eb42"
                    }), e.requestChanges = new e("request-changes", {
                        fontCharacter: "\\eb43"
                    }), e.rocket = new e("rocket", {
                        fontCharacter: "\\eb44"
                    }), e.rootFolderOpened = new e("root-folder-opened", {
                        fontCharacter: "\\eb45"
                    }), e.rootFolder = new e("root-folder", {
                        fontCharacter: "\\eb46"
                    }), e.rss = new e("rss", {
                        fontCharacter: "\\eb47"
                    }), e.ruby = new e("ruby", {
                        fontCharacter: "\\eb48"
                    }), e.saveAll = new e("save-all", {
                        fontCharacter: "\\eb49"
                    }), e.saveAs = new e("save-as", {
                        fontCharacter: "\\eb4a"
                    }), e.save = new e("save", {
                        fontCharacter: "\\eb4b"
                    }), e.screenFull = new e("screen-full", {
                        fontCharacter: "\\eb4c"
                    }), e.screenNormal = new e("screen-normal", {
                        fontCharacter: "\\eb4d"
                    }), e.searchStop = new e("search-stop", {
                        fontCharacter: "\\eb4e"
                    }), e.server = new e("server", {
                        fontCharacter: "\\eb50"
                    }), e.settingsGear = new e("settings-gear", {
                        fontCharacter: "\\eb51"
                    }), e.settings = new e("settings", {
                        fontCharacter: "\\eb52"
                    }), e.shield = new e("shield", {
                        fontCharacter: "\\eb53"
                    }), e.smiley = new e("smiley", {
                        fontCharacter: "\\eb54"
                    }), e.sortPrecedence = new e("sort-precedence", {
                        fontCharacter: "\\eb55"
                    }), e.splitHorizontal = new e("split-horizontal", {
                        fontCharacter: "\\eb56"
                    }), e.splitVertical = new e("split-vertical", {
                        fontCharacter: "\\eb57"
                    }), e.squirrel = new e("squirrel", {
                        fontCharacter: "\\eb58"
                    }), e.starFull = new e("star-full", {
                        fontCharacter: "\\eb59"
                    }), e.starHalf = new e("star-half", {
                        fontCharacter: "\\eb5a"
                    }), e.symbolClass = new e("symbol-class", {
                        fontCharacter: "\\eb5b"
                    }), e.symbolColor = new e("symbol-color", {
                        fontCharacter: "\\eb5c"
                    }), e.symbolConstant = new e("symbol-constant", {
                        fontCharacter: "\\eb5d"
                    }), e.symbolEnumMember = new e("symbol-enum-member", {
                        fontCharacter: "\\eb5e"
                    }), e.symbolField = new e("symbol-field", {
                        fontCharacter: "\\eb5f"
                    }), e.symbolFile = new e("symbol-file", {
                        fontCharacter: "\\eb60"
                    }), e.symbolInterface = new e("symbol-interface", {
                        fontCharacter: "\\eb61"
                    }), e.symbolKeyword = new e("symbol-keyword", {
                        fontCharacter: "\\eb62"
                    }), e.symbolMisc = new e("symbol-misc", {
                        fontCharacter: "\\eb63"
                    }), e.symbolOperator = new e("symbol-operator", {
                        fontCharacter: "\\eb64"
                    }), e.symbolProperty = new e("symbol-property", {
                        fontCharacter: "\\eb65"
                    }), e.wrench = new e("wrench", {
                        fontCharacter: "\\eb65"
                    }), e.wrenchSubaction = new e("wrench-subaction", {
                        fontCharacter: "\\eb65"
                    }), e.symbolSnippet = new e("symbol-snippet", {
                        fontCharacter: "\\eb66"
                    }), e.tasklist = new e("tasklist", {
                        fontCharacter: "\\eb67"
                    }), e.telescope = new e("telescope", {
                        fontCharacter: "\\eb68"
                    }), e.textSize = new e("text-size", {
                        fontCharacter: "\\eb69"
                    }), e.threeBars = new e("three-bars", {
                        fontCharacter: "\\eb6a"
                    }), e.thumbsdown = new e("thumbsdown", {
                        fontCharacter: "\\eb6b"
                    }), e.thumbsup = new e("thumbsup", {
                        fontCharacter: "\\eb6c"
                    }), e.tools = new e("tools", {
                        fontCharacter: "\\eb6d"
                    }), e.triangleDown = new e("triangle-down", {
                        fontCharacter: "\\eb6e"
                    }), e.triangleLeft = new e("triangle-left", {
                        fontCharacter: "\\eb6f"
                    }), e.triangleRight = new e("triangle-right", {
                        fontCharacter: "\\eb70"
                    }), e.triangleUp = new e("triangle-up", {
                        fontCharacter: "\\eb71"
                    }), e.twitter = new e("twitter", {
                        fontCharacter: "\\eb72"
                    }), e.unfold = new e("unfold", {
                        fontCharacter: "\\eb73"
                    }), e.unlock = new e("unlock", {
                        fontCharacter: "\\eb74"
                    }), e.unmute = new e("unmute", {
                        fontCharacter: "\\eb75"
                    }), e.unverified = new e("unverified", {
                        fontCharacter: "\\eb76"
                    }), e.verified = new e("verified", {
                        fontCharacter: "\\eb77"
                    }), e.versions = new e("versions", {
                        fontCharacter: "\\eb78"
                    }), e.vmActive = new e("vm-active", {
                        fontCharacter: "\\eb79"
                    }), e.vmOutline = new e("vm-outline", {
                        fontCharacter: "\\eb7a"
                    }), e.vmRunning = new e("vm-running", {
                        fontCharacter: "\\eb7b"
                    }), e.watch = new e("watch", {
                        fontCharacter: "\\eb7c"
                    }), e.whitespace = new e("whitespace", {
                        fontCharacter: "\\eb7d"
                    }), e.wholeWord = new e("whole-word", {
                        fontCharacter: "\\eb7e"
                    }), e.window = new e("window", {
                        fontCharacter: "\\eb7f"
                    }), e.wordWrap = new e("word-wrap", {
                        fontCharacter: "\\eb80"
                    }), e.zoomIn = new e("zoom-in", {
                        fontCharacter: "\\eb81"
                    }), e.zoomOut = new e("zoom-out", {
                        fontCharacter: "\\eb82"
                    }), e.listFilter = new e("list-filter", {
                        fontCharacter: "\\eb83"
                    }), e.listFlat = new e("list-flat", {
                        fontCharacter: "\\eb84"
                    }), e.listSelection = new e("list-selection", {
                        fontCharacter: "\\eb85"
                    }), e.selection = new e("selection", {
                        fontCharacter: "\\eb85"
                    }), e.listTree = new e("list-tree", {
                        fontCharacter: "\\eb86"
                    }), e.debugBreakpointFunctionUnverified = new e("debug-breakpoint-function-unverified", {
                        fontCharacter: "\\eb87"
                    }), e.debugBreakpointFunction = new e("debug-breakpoint-function", {
                        fontCharacter: "\\eb88"
                    }), e.debugBreakpointFunctionDisabled = new e("debug-breakpoint-function-disabled", {
                        fontCharacter: "\\eb88"
                    }), e.debugStackframeActive = new e("debug-stackframe-active", {
                        fontCharacter: "\\eb89"
                    }), e.debugStackframeDot = new e("debug-stackframe-dot", {
                        fontCharacter: "\\eb8a"
                    }), e.debugStackframe = new e("debug-stackframe", {
                        fontCharacter: "\\eb8b"
                    }), e.debugStackframeFocused = new e("debug-stackframe-focused", {
                        fontCharacter: "\\eb8b"
                    }), e.debugBreakpointUnsupported = new e("debug-breakpoint-unsupported", {
                        fontCharacter: "\\eb8c"
                    }), e.symbolString = new e("symbol-string", {
                        fontCharacter: "\\eb8d"
                    }), e.debugReverseContinue = new e("debug-reverse-continue", {
                        fontCharacter: "\\eb8e"
                    }), e.debugStepBack = new e("debug-step-back", {
                        fontCharacter: "\\eb8f"
                    }), e.debugRestartFrame = new e("debug-restart-frame", {
                        fontCharacter: "\\eb90"
                    }), e.callIncoming = new e("call-incoming", {
                        fontCharacter: "\\eb92"
                    }), e.callOutgoing = new e("call-outgoing", {
                        fontCharacter: "\\eb93"
                    }), e.menu = new e("menu", {
                        fontCharacter: "\\eb94"
                    }), e.expandAll = new e("expand-all", {
                        fontCharacter: "\\eb95"
                    }), e.feedback = new e("feedback", {
                        fontCharacter: "\\eb96"
                    }), e.groupByRefType = new e("group-by-ref-type", {
                        fontCharacter: "\\eb97"
                    }), e.ungroupByRefType = new e("ungroup-by-ref-type", {
                        fontCharacter: "\\eb98"
                    }), e.account = new e("account", {
                        fontCharacter: "\\eb99"
                    }), e.bellDot = new e("bell-dot", {
                        fontCharacter: "\\eb9a"
                    }), e.debugConsole = new e("debug-console", {
                        fontCharacter: "\\eb9b"
                    }), e.library = new e("library", {
                        fontCharacter: "\\eb9c"
                    }), e.output = new e("output", {
                        fontCharacter: "\\eb9d"
                    }), e.runAll = new e("run-all", {
                        fontCharacter: "\\eb9e"
                    }), e.syncIgnored = new e("sync-ignored", {
                        fontCharacter: "\\eb9f"
                    }), e.pinned = new e("pinned", {
                        fontCharacter: "\\eba0"
                    }), e.githubInverted = new e("github-inverted", {
                        fontCharacter: "\\eba1"
                    }), e.debugAlt = new e("debug-alt", {
                        fontCharacter: "\\eb91"
                    }), e.serverProcess = new e("server-process", {
                        fontCharacter: "\\eba2"
                    }), e.serverEnvironment = new e("server-environment", {
                        fontCharacter: "\\eba3"
                    }), e.pass = new e("pass", {
                        fontCharacter: "\\eba4"
                    }), e.stopCircle = new e("stop-circle", {
                        fontCharacter: "\\eba5"
                    }), e.playCircle = new e("play-circle", {
                        fontCharacter: "\\eba6"
                    }), e.record = new e("record", {
                        fontCharacter: "\\eba7"
                    }), e.debugAltSmall = new e("debug-alt-small", {
                        fontCharacter: "\\eba8"
                    }), e.vmConnect = new e("vm-connect", {
                        fontCharacter: "\\eba9"
                    }), e.cloud = new e("cloud", {
                        fontCharacter: "\\ebaa"
                    }), e.merge = new e("merge", {
                        fontCharacter: "\\ebab"
                    }), e.exportIcon = new e("export", {
                        fontCharacter: "\\ebac"
                    }), e.graphLeft = new e("graph-left", {
                        fontCharacter: "\\ebad"
                    }), e.magnet = new e("magnet", {
                        fontCharacter: "\\ebae"
                    }), e.notebook = new e("notebook", {
                        fontCharacter: "\\ebaf"
                    }), e.redo = new e("redo", {
                        fontCharacter: "\\ebb0"
                    }), e.checkAll = new e("check-all", {
                        fontCharacter: "\\ebb1"
                    }), e.pinnedDirty = new e("pinned-dirty", {
                        fontCharacter: "\\ebb2"
                    }), e.passFilled = new e("pass-filled", {
                        fontCharacter: "\\ebb3"
                    }), e.circleLargeFilled = new e("circle-large-filled", {
                        fontCharacter: "\\ebb4"
                    }), e.circleLargeOutline = new e("circle-large-outline", {
                        fontCharacter: "\\ebb5"
                    }), e.combine = new e("combine", {
                        fontCharacter: "\\ebb6"
                    }), e.gather = new e("gather", {
                        fontCharacter: "\\ebb6"
                    }), e.table = new e("table", {
                        fontCharacter: "\\ebb7"
                    }), e.variableGroup = new e("variable-group", {
                        fontCharacter: "\\ebb8"
                    }), e.typeHierarchy = new e("type-hierarchy", {
                        fontCharacter: "\\ebb9"
                    }), e.typeHierarchySub = new e("type-hierarchy-sub", {
                        fontCharacter: "\\ebba"
                    }), e.typeHierarchySuper = new e("type-hierarchy-super", {
                        fontCharacter: "\\ebbb"
                    }), e.gitPullRequestCreate = new e("git-pull-request-create", {
                        fontCharacter: "\\ebbc"
                    }), e.runAbove = new e("run-above", {
                        fontCharacter: "\\ebbd"
                    }), e.runBelow = new e("run-below", {
                        fontCharacter: "\\ebbe"
                    }), e.notebookTemplate = new e("notebook-template", {
                        fontCharacter: "\\ebbf"
                    }), e.debugRerun = new e("debug-rerun", {
                        fontCharacter: "\\ebc0"
                    }), e.workspaceTrusted = new e("workspace-trusted", {
                        fontCharacter: "\\ebc1"
                    }), e.workspaceUntrusted = new e("workspace-untrusted", {
                        fontCharacter: "\\ebc2"
                    }), e.workspaceUnspecified = new e("workspace-unspecified", {
                        fontCharacter: "\\ebc3"
                    }), e.terminalCmd = new e("terminal-cmd", {
                        fontCharacter: "\\ebc4"
                    }), e.terminalDebian = new e("terminal-debian", {
                        fontCharacter: "\\ebc5"
                    }), e.terminalLinux = new e("terminal-linux", {
                        fontCharacter: "\\ebc6"
                    }), e.terminalPowershell = new e("terminal-powershell", {
                        fontCharacter: "\\ebc7"
                    }), e.terminalTmux = new e("terminal-tmux", {
                        fontCharacter: "\\ebc8"
                    }), e.terminalUbuntu = new e("terminal-ubuntu", {
                        fontCharacter: "\\ebc9"
                    }), e.terminalBash = new e("terminal-bash", {
                        fontCharacter: "\\ebca"
                    }), e.arrowSwap = new e("arrow-swap", {
                        fontCharacter: "\\ebcb"
                    }), e.copy = new e("copy", {
                        fontCharacter: "\\ebcc"
                    }), e.personAdd = new e("person-add", {
                        fontCharacter: "\\ebcd"
                    }), e.filterFilled = new e("filter-filled", {
                        fontCharacter: "\\ebce"
                    }), e.wand = new e("wand", {
                        fontCharacter: "\\ebcf"
                    }), e.debugLineByLine = new e("debug-line-by-line", {
                        fontCharacter: "\\ebd0"
                    }), e.inspect = new e("inspect", {
                        fontCharacter: "\\ebd1"
                    }), e.layers = new e("layers", {
                        fontCharacter: "\\ebd2"
                    }), e.layersDot = new e("layers-dot", {
                        fontCharacter: "\\ebd3"
                    }), e.layersActive = new e("layers-active", {
                        fontCharacter: "\\ebd4"
                    }), e.compass = new e("compass", {
                        fontCharacter: "\\ebd5"
                    }), e.compassDot = new e("compass-dot", {
                        fontCharacter: "\\ebd6"
                    }), e.compassActive = new e("compass-active", {
                        fontCharacter: "\\ebd7"
                    }), e.azure = new e("azure", {
                        fontCharacter: "\\ebd8"
                    }), e.issueDraft = new e("issue-draft", {
                        fontCharacter: "\\ebd9"
                    }), e.gitPullRequestClosed = new e("git-pull-request-closed", {
                        fontCharacter: "\\ebda"
                    }), e.gitPullRequestDraft = new e("git-pull-request-draft", {
                        fontCharacter: "\\ebdb"
                    }), e.debugAll = new e("debug-all", {
                        fontCharacter: "\\ebdc"
                    }), e.debugCoverage = new e("debug-coverage", {
                        fontCharacter: "\\ebdd"
                    }), e.runErrors = new e("run-errors", {
                        fontCharacter: "\\ebde"
                    }), e.folderLibrary = new e("folder-library", {
                        fontCharacter: "\\ebdf"
                    }), e.debugContinueSmall = new e("debug-continue-small", {
                        fontCharacter: "\\ebe0"
                    }), e.beakerStop = new e("beaker-stop", {
                        fontCharacter: "\\ebe1"
                    }), e.graphLine = new e("graph-line", {
                        fontCharacter: "\\ebe2"
                    }), e.graphScatter = new e("graph-scatter", {
                        fontCharacter: "\\ebe3"
                    }), e.pieChart = new e("pie-chart", {
                        fontCharacter: "\\ebe4"
                    }), e.bracket = new e("bracket", e.json.definition), e.bracketDot = new e("bracket-dot", {
                        fontCharacter: "\\ebe5"
                    }), e.bracketError = new e("bracket-error", {
                        fontCharacter: "\\ebe6"
                    }), e.lockSmall = new e("lock-small", {
                        fontCharacter: "\\ebe7"
                    }), e.azureDevops = new e("azure-devops", {
                        fontCharacter: "\\ebe8"
                    }), e.verifiedFilled = new e("verified-filled", {
                        fontCharacter: "\\ebe9"
                    })
                }(l || (l = {}))
            },
            6626: (e, t, i) => {
                "use strict";
                i.d(t, {
                    E: () => o,
                    r: () => s
                });
                const n = Object.prototype.hasOwnProperty;

                function o(e, t) {
                    for (let i in e)
                        if (n.call(e, i)) {
                            if (!1 === t({
                                    key: i,
                                    value: e[i]
                                }, (function() {
                                    delete e[i]
                                }))) return
                        }
                }
                class s {
                    constructor() {
                        this.map = new Map
                    }
                    add(e, t) {
                        let i = this.map.get(e);
                        i || (i = new Set, this.map.set(e, i)), i.add(t)
                    }
                    delete(e, t) {
                        const i = this.map.get(e);
                        i && (i.delete(t), 0 === i.size && this.map.delete(e))
                    }
                    forEach(e, t) {
                        const i = this.map.get(e);
                        i && i.forEach(t)
                    }
                }
            },
            41264: (e, t, i) => {
                "use strict";

                function n(e, t) {
                    const i = Math.pow(10, t);
                    return Math.round(e * i) / i
                }
                i.d(t, {
                    Il: () => a,
                    VS: () => o,
                    tx: () => r
                });
                class o {
                    constructor(e, t, i, o = 1) {
                        this._rgbaBrand = void 0, this.r = 0 | Math.min(255, Math.max(0, e)), this.g = 0 | Math.min(255, Math.max(0, t)), this.b = 0 | Math.min(255, Math.max(0, i)), this.a = n(Math.max(Math.min(1, o), 0), 3)
                    }
                    static equals(e, t) {
                        return e.r === t.r && e.g === t.g && e.b === t.b && e.a === t.a
                    }
                }
                class s {
                    constructor(e, t, i, o) {
                        this._hslaBrand = void 0, this.h = 0 | Math.max(Math.min(360, e), 0), this.s = n(Math.max(Math.min(1, t), 0), 3), this.l = n(Math.max(Math.min(1, i), 0), 3), this.a = n(Math.max(Math.min(1, o), 0), 3)
                    }
                    static equals(e, t) {
                        return e.h === t.h && e.s === t.s && e.l === t.l && e.a === t.a
                    }
                    static fromRGBA(e) {
                        const t = e.r / 255,
                            i = e.g / 255,
                            n = e.b / 255,
                            o = e.a,
                            r = Math.max(t, i, n),
                            a = Math.min(t, i, n);
                        let l = 0,
                            c = 0;
                        const d = (a + r) / 2,
                            h = r - a;
                        if (h > 0) {
                            switch (c = Math.min(d <= .5 ? h / (2 * d) : h / (2 - 2 * d), 1), r) {
                                case t:
                                    l = (i - n) / h + (i < n ? 6 : 0);
                                    break;
                                case i:
                                    l = (n - t) / h + 2;
                                    break;
                                case n:
                                    l = (t - i) / h + 4
                            }
                            l *= 60, l = Math.round(l)
                        }
                        return new s(l, c, d, o)
                    }
                    static _hue2rgb(e, t, i) {
                        return i < 0 && (i += 1), i > 1 && (i -= 1), i < 1 / 6 ? e + 6 * (t - e) * i : i < .5 ? t : i < 2 / 3 ? e + (t - e) * (2 / 3 - i) * 6 : e
                    }
                    static toRGBA(e) {
                        const t = e.h / 360,
                            {
                                s: i,
                                l: n,
                                a: r
                            } = e;
                        let a, l, c;
                        if (0 === i) a = l = c = n;
                        else {
                            const e = n < .5 ? n * (1 + i) : n + i - n * i,
                                o = 2 * n - e;
                            a = s._hue2rgb(o, e, t + 1 / 3), l = s._hue2rgb(o, e, t), c = s._hue2rgb(o, e, t - 1 / 3)
                        }
                        return new o(Math.round(255 * a), Math.round(255 * l), Math.round(255 * c), r)
                    }
                }
                class r {
                    constructor(e, t, i, o) {
                        this._hsvaBrand = void 0, this.h = 0 | Math.max(Math.min(360, e), 0), this.s = n(Math.max(Math.min(1, t), 0), 3), this.v = n(Math.max(Math.min(1, i), 0), 3), this.a = n(Math.max(Math.min(1, o), 0), 3)
                    }
                    static equals(e, t) {
                        return e.h === t.h && e.s === t.s && e.v === t.v && e.a === t.a
                    }
                    static fromRGBA(e) {
                        const t = e.r / 255,
                            i = e.g / 255,
                            n = e.b / 255,
                            o = Math.max(t, i, n),
                            s = o - Math.min(t, i, n),
                            a = 0 === o ? 0 : s / o;
                        let l;
                        return l = 0 === s ? 0 : o === t ? ((i - n) / s % 6 + 6) % 6 : o === i ? (n - t) / s + 2 : (t - i) / s + 4, new r(Math.round(60 * l), a, o, e.a)
                    }
                    static toRGBA(e) {
                        const {
                            h: t,
                            s: i,
                            v: n,
                            a: s
                        } = e, r = n * i, a = r * (1 - Math.abs(t / 60 % 2 - 1)), l = n - r;
                        let [c, d, h] = [0, 0, 0];
                        return t < 60 ? (c = r, d = a) : t < 120 ? (c = a, d = r) : t < 180 ? (d = r, h = a) : t < 240 ? (d = a, h = r) : t < 300 ? (c = a, h = r) : t <= 360 && (c = r, h = a), c = Math.round(255 * (c + l)), d = Math.round(255 * (d + l)), h = Math.round(255 * (h + l)), new o(c, d, h, s)
                    }
                }
                const Lg = new Language(modifyState.language);
                class a {
                    constructor(e) {
                        if (!e) throw new Error(Lg.colorNeedValue());
                        if (e instanceof o) this.rgba = e;
                        else if (e instanceof s) this._hsla = e, this.rgba = s.toRGBA(e);
                        else {
                            if (!(e instanceof r)) throw new Error(Lg.invalidColorArgument());
                            this._hsva = e, this.rgba = r.toRGBA(e)
                        }
                    }
                    static fromHex(e) {
                        return a.Format.CSS.parseHex(e) || a.red
                    }
                    get hsla() {
                        return this._hsla ? this._hsla : s.fromRGBA(this.rgba)
                    }
                    get hsva() {
                        return this._hsva ? this._hsva : r.fromRGBA(this.rgba)
                    }
                    equals(e) {
                        return !!e && o.equals(this.rgba, e.rgba) && s.equals(this.hsla, e.hsla) && r.equals(this.hsva, e.hsva)
                    }
                    getRelativeLuminance() {
                        return n(.2126 * a._relativeLuminanceForComponent(this.rgba.r) + .7152 * a._relativeLuminanceForComponent(this.rgba.g) + .0722 * a._relativeLuminanceForComponent(this.rgba.b), 4)
                    }
                    static _relativeLuminanceForComponent(e) {
                        const t = e / 255;
                        return t <= .03928 ? t / 12.92 : Math.pow((t + .055) / 1.055, 2.4)
                    }
                    isLighter() {
                        return (299 * this.rgba.r + 587 * this.rgba.g + 114 * this.rgba.b) / 1e3 >= 128
                    }
                    isLighterThan(e) {
                        return this.getRelativeLuminance() > e.getRelativeLuminance()
                    }
                    isDarkerThan(e) {
                        return this.getRelativeLuminance() < e.getRelativeLuminance()
                    }
                    lighten(e) {
                        return new a(new s(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * e, this.hsla.a))
                    }
                    darken(e) {
                        return new a(new s(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * e, this.hsla.a))
                    }
                    transparent(e) {
                        const {
                            r: t,
                            g: i,
                            b: n,
                            a: s
                        } = this.rgba;
                        return new a(new o(t, i, n, s * e))
                    }
                    isTransparent() {
                        return 0 === this.rgba.a
                    }
                    isOpaque() {
                        return 1 === this.rgba.a
                    }
                    opposite() {
                        return new a(new o(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a))
                    }
                    toString() {
                        return this._toString || (this._toString = a.Format.CSS.format(this)), this._toString
                    }
                    static getLighterColor(e, t, i) {
                        if (e.isLighterThan(t)) return e;
                        i = i || .5;
                        const n = e.getRelativeLuminance(),
                            o = t.getRelativeLuminance();
                        return i = i * (o - n) / o, e.lighten(i)
                    }
                    static getDarkerColor(e, t, i) {
                        if (e.isDarkerThan(t)) return e;
                        i = i || .5;
                        const n = e.getRelativeLuminance();
                        return i = i * (n - t.getRelativeLuminance()) / n, e.darken(i)
                    }
                }
                a.white = new a(new o(255, 255, 255, 1)), a.black = new a(new o(0, 0, 0, 1)), a.red = new a(new o(255, 0, 0, 1)), a.blue = new a(new o(0, 0, 255, 1)), a.cyan = new a(new o(0, 255, 255, 1)), a.lightgrey = new a(new o(211, 211, 211, 1)), a.transparent = new a(new o(0, 0, 0, 0)),
                    function(e) {
                        let t;
                        ! function(t) {
                            let i;
                            ! function(t) {
                                function i(e) {
                                    const t = e.toString(16);
                                    return 2 !== t.length ? "0" + t : t
                                }

                                function n(e) {
                                    switch (e) {
                                        case 48:
                                            return 0;
                                        case 49:
                                            return 1;
                                        case 50:
                                            return 2;
                                        case 51:
                                            return 3;
                                        case 52:
                                            return 4;
                                        case 53:
                                            return 5;
                                        case 54:
                                            return 6;
                                        case 55:
                                            return 7;
                                        case 56:
                                            return 8;
                                        case 57:
                                            return 9;
                                        case 97:
                                        case 65:
                                            return 10;
                                        case 98:
                                        case 66:
                                            return 11;
                                        case 99:
                                        case 67:
                                            return 12;
                                        case 100:
                                        case 68:
                                            return 13;
                                        case 101:
                                        case 69:
                                            return 14;
                                        case 102:
                                        case 70:
                                            return 15
                                    }
                                    return 0
                                }
                                t.formatRGB = function(t) {
                                    return 1 === t.rgba.a ? `rgb(${t.rgba.r}, ${t.rgba.g}, ${t.rgba.b})` : e.Format.CSS.formatRGBA(t)
                                }, t.formatRGBA = function(e) {
                                    return `rgba(${e.rgba.r}, ${e.rgba.g}, ${e.rgba.b}, ${+e.rgba.a.toFixed(2)})`
                                }, t.formatHSL = function(t) {
                                    return 1 === t.hsla.a ? `hsl(${t.hsla.h}, ${(100*t.hsla.s).toFixed(2)}%, ${(100*t.hsla.l).toFixed(2)}%)` : e.Format.CSS.formatHSLA(t)
                                }, t.formatHSLA = function(e) {
                                    return `hsla(${e.hsla.h}, ${(100*e.hsla.s).toFixed(2)}%, ${(100*e.hsla.l).toFixed(2)}%, ${e.hsla.a.toFixed(2)})`
                                }, t.formatHex = function(e) {
                                    return `#${i(e.rgba.r)}${i(e.rgba.g)}${i(e.rgba.b)}`
                                }, t.formatHexA = function(t, n = !1) {
                                    return n && 1 === t.rgba.a ? e.Format.CSS.formatHex(t) : `#${i(t.rgba.r)}${i(t.rgba.g)}${i(t.rgba.b)}${i(Math.round(255*t.rgba.a))}`
                                }, t.format = function(t) {
                                    return t.isOpaque() ? e.Format.CSS.formatHex(t) : e.Format.CSS.formatRGBA(t)
                                }, t.parseHex = function(t) {
                                    const i = t.length;
                                    if (0 === i) return null;
                                    if (35 !== t.charCodeAt(0)) return null;
                                    if (7 === i) {
                                        const i = 16 * n(t.charCodeAt(1)) + n(t.charCodeAt(2)),
                                            s = 16 * n(t.charCodeAt(3)) + n(t.charCodeAt(4)),
                                            r = 16 * n(t.charCodeAt(5)) + n(t.charCodeAt(6));
                                        return new e(new o(i, s, r, 1))
                                    }
                                    if (9 === i) {
                                        const i = 16 * n(t.charCodeAt(1)) + n(t.charCodeAt(2)),
                                            s = 16 * n(t.charCodeAt(3)) + n(t.charCodeAt(4)),
                                            r = 16 * n(t.charCodeAt(5)) + n(t.charCodeAt(6)),
                                            a = 16 * n(t.charCodeAt(7)) + n(t.charCodeAt(8));
                                        return new e(new o(i, s, r, a / 255))
                                    }
                                    if (4 === i) {
                                        const i = n(t.charCodeAt(1)),
                                            s = n(t.charCodeAt(2)),
                                            r = n(t.charCodeAt(3));
                                        return new e(new o(16 * i + i, 16 * s + s, 16 * r + r))
                                    }
                                    if (5 === i) {
                                        const i = n(t.charCodeAt(1)),
                                            s = n(t.charCodeAt(2)),
                                            r = n(t.charCodeAt(3)),
                                            a = n(t.charCodeAt(4));
                                        return new e(new o(16 * i + i, 16 * s + s, 16 * r + r, (16 * a + a) / 255))
                                    }
                                    return null
                                }
                            }(i = t.CSS || (t.CSS = {}))
                        }(t = e.Format || (e.Format = {}))
                    }(a || (a = {}))
            },
            49898: (e, t, i) => {
                "use strict";

                function n(e, t, i) {
                    let n = null,
                        o = null;
                    if ("function" == typeof i.value ? (n = "value", o = i.value, 0 !== o.length && console.warn("Memoize should only be used in functions with zero parameters")) : "function" == typeof i.get && (n = "get", o = i.get), !o) throw new Error("not supported");
                    const s = `$memoize$${t}`;
                    i[n] = function(...e) {
                        return this.hasOwnProperty(s) || Object.defineProperty(this, s, {
                            configurable: !1,
                            enumerable: !1,
                            writable: !1,
                            value: o.apply(this, e)
                        }), this[s]
                    }
                }
                i.d(t, {
                    H: () => n
                })
            },
            2484: (e, t, i) => {
                "use strict";
                i.d(t, {
                    Hs: () => d,
                    a$: () => r
                });
                class n {
                    constructor(e, t, i, n) {
                        this.originalStart = e, this.originalLength = t, this.modifiedStart = i, this.modifiedLength = n
                    }
                    getOriginalEnd() {
                        return this.originalStart + this.originalLength
                    }
                    getModifiedEnd() {
                        return this.modifiedStart + this.modifiedLength
                    }
                }
                var o = i(89954);
                class s {
                    constructor(e) {
                        this.source = e
                    }
                    getElements() {
                        const e = this.source,
                            t = new Int32Array(e.length);
                        for (let i = 0, n = e.length; i < n; i++) t[i] = e.charCodeAt(i);
                        return t
                    }
                }

                function r(e, t, i) {
                    return new d(new s(e), new s(t)).ComputeDiff(i).changes
                }
                class a {
                    static Assert(e, t) {
                        if (!e) throw new Error(t)
                    }
                }
                class l {
                    static Copy(e, t, i, n, o) {
                        for (let s = 0; s < o; s++) i[n + s] = e[t + s]
                    }
                    static Copy2(e, t, i, n, o) {
                        for (let s = 0; s < o; s++) i[n + s] = e[t + s]
                    }
                }
                class c {
                    constructor() {
                        this.m_changes = [], this.m_originalStart = 1073741824, this.m_modifiedStart = 1073741824, this.m_originalCount = 0, this.m_modifiedCount = 0
                    }
                    MarkNextChange() {
                        (this.m_originalCount > 0 || this.m_modifiedCount > 0) && this.m_changes.push(new n(this.m_originalStart, this.m_originalCount, this.m_modifiedStart, this.m_modifiedCount)), this.m_originalCount = 0, this.m_modifiedCount = 0, this.m_originalStart = 1073741824, this.m_modifiedStart = 1073741824
                    }
                    AddOriginalElement(e, t) {
                        this.m_originalStart = Math.min(this.m_originalStart, e), this.m_modifiedStart = Math.min(this.m_modifiedStart, t), this.m_originalCount++
                    }
                    AddModifiedElement(e, t) {
                        this.m_originalStart = Math.min(this.m_originalStart, e), this.m_modifiedStart = Math.min(this.m_modifiedStart, t), this.m_modifiedCount++
                    }
                    getChanges() {
                        return (this.m_originalCount > 0 || this.m_modifiedCount > 0) && this.MarkNextChange(), this.m_changes
                    }
                    getReverseChanges() {
                        return (this.m_originalCount > 0 || this.m_modifiedCount > 0) && this.MarkNextChange(), this.m_changes.reverse(), this.m_changes
                    }
                }
                class d {
                    constructor(e, t, i = null) {
                        this.ContinueProcessingPredicate = i, this._originalSequence = e, this._modifiedSequence = t;
                        const [n, o, s] = d._getElements(e), [r, a, l] = d._getElements(t);
                        this._hasStrings = s && l, this._originalStringElements = n, this._originalElementsOrHash = o, this._modifiedStringElements = r, this._modifiedElementsOrHash = a, this.m_forwardHistory = [], this.m_reverseHistory = []
                    }
                    static _isStringArray(e) {
                        return e.length > 0 && "string" == typeof e[0]
                    }
                    static _getElements(e) {
                        const t = e.getElements();
                        if (d._isStringArray(t)) {
                            const e = new Int32Array(t.length);
                            for (let i = 0, n = t.length; i < n; i++) e[i] = (0, o.Cv)(t[i], 0);
                            return [t, e, !0]
                        }
                        return t instanceof Int32Array ? [
                            [], t, !1
                        ] : [
                            [], new Int32Array(t), !1
                        ]
                    }
                    ElementsAreEqual(e, t) {
                        return this._originalElementsOrHash[e] === this._modifiedElementsOrHash[t] && (!this._hasStrings || this._originalStringElements[e] === this._modifiedStringElements[t])
                    }
                    ElementsAreStrictEqual(e, t) {
                        if (!this.ElementsAreEqual(e, t)) return !1;
                        return d._getStrictElement(this._originalSequence, e) === d._getStrictElement(this._modifiedSequence, t)
                    }
                    static _getStrictElement(e, t) {
                        return "function" == typeof e.getStrictElement ? e.getStrictElement(t) : null
                    }
                    OriginalElementsAreEqual(e, t) {
                        return this._originalElementsOrHash[e] === this._originalElementsOrHash[t] && (!this._hasStrings || this._originalStringElements[e] === this._originalStringElements[t])
                    }
                    ModifiedElementsAreEqual(e, t) {
                        return this._modifiedElementsOrHash[e] === this._modifiedElementsOrHash[t] && (!this._hasStrings || this._modifiedStringElements[e] === this._modifiedStringElements[t])
                    }
                    ComputeDiff(e) {
                        return this._ComputeDiff(0, this._originalElementsOrHash.length - 1, 0, this._modifiedElementsOrHash.length - 1, e)
                    }
                    _ComputeDiff(e, t, i, n, o) {
                        const s = [!1];
                        let r = this.ComputeDiffRecursive(e, t, i, n, s);
                        return o && (r = this.PrettifyChanges(r)), {
                            quitEarly: s[0],
                            changes: r
                        }
                    }
                    ComputeDiffRecursive(e, t, i, o, s) {
                        for (s[0] = !1; e <= t && i <= o && this.ElementsAreEqual(e, i);) e++, i++;
                        for (; t >= e && o >= i && this.ElementsAreEqual(t, o);) t--, o--;
                        if (e > t || i > o) {
                            let s;
                            return i <= o ? (a.Assert(e === t + 1, "originalStart should only be one more than originalEnd"), s = [new n(e, 0, i, o - i + 1)]) : e <= t ? (a.Assert(i === o + 1, "modifiedStart should only be one more than modifiedEnd"), s = [new n(e, t - e + 1, i, 0)]) : (a.Assert(e === t + 1, "originalStart should only be one more than originalEnd"), a.Assert(i === o + 1, "modifiedStart should only be one more than modifiedEnd"), s = []), s
                        }
                        const r = [0],
                            l = [0],
                            c = this.ComputeRecursionPoint(e, t, i, o, r, l, s),
                            d = r[0],
                            h = l[0];
                        if (null !== c) return c;
                        if (!s[0]) {
                            const r = this.ComputeDiffRecursive(e, d, i, h, s);
                            let a = [];
                            return a = s[0] ? [new n(d + 1, t - (d + 1) + 1, h + 1, o - (h + 1) + 1)] : this.ComputeDiffRecursive(d + 1, t, h + 1, o, s), this.ConcatenateChanges(r, a)
                        }
                        return [new n(e, t - e + 1, i, o - i + 1)]
                    }
                    WALKTRACE(e, t, i, o, s, r, a, l, d, h, u, g, p, f, m, v, _, b) {
                        let w = null,
                            y = null,
                            C = new c,
                            x = t,
                            S = i,
                            k = p[0] - v[0] - o,
                            L = -1073741824,
                            N = this.m_forwardHistory.length - 1;
                        do {
                            const t = k + e;
                            t === x || t < S && d[t - 1] < d[t + 1] ? (f = (u = d[t + 1]) - k - o, u < L && C.MarkNextChange(), L = u, C.AddModifiedElement(u + 1, f), k = t + 1 - e) : (f = (u = d[t - 1] + 1) - k - o, u < L && C.MarkNextChange(), L = u - 1, C.AddOriginalElement(u, f + 1), k = t - 1 - e), N >= 0 && (e = (d = this.m_forwardHistory[N])[0], x = 1, S = d.length - 1)
                        } while (--N >= -1);
                        if (w = C.getReverseChanges(), b[0]) {
                            let e = p[0] + 1,
                                t = v[0] + 1;
                            if (null !== w && w.length > 0) {
                                const i = w[w.length - 1];
                                e = Math.max(e, i.getOriginalEnd()), t = Math.max(t, i.getModifiedEnd())
                            }
                            y = [new n(e, g - e + 1, t, m - t + 1)]
                        } else {
                            C = new c, x = r, S = a, k = p[0] - v[0] - l, L = 1073741824, N = _ ? this.m_reverseHistory.length - 1 : this.m_reverseHistory.length - 2;
                            do {
                                const e = k + s;
                                e === x || e < S && h[e - 1] >= h[e + 1] ? (f = (u = h[e + 1] - 1) - k - l, u > L && C.MarkNextChange(), L = u + 1, C.AddOriginalElement(u + 1, f + 1), k = e + 1 - s) : (f = (u = h[e - 1]) - k - l, u > L && C.MarkNextChange(), L = u, C.AddModifiedElement(u + 1, f + 1), k = e - 1 - s), N >= 0 && (s = (h = this.m_reverseHistory[N])[0], x = 1, S = h.length - 1)
                            } while (--N >= -1);
                            y = C.getChanges()
                        }
                        return this.ConcatenateChanges(w, y)
                    }
                    ComputeRecursionPoint(e, t, i, o, s, r, a) {
                        let c = 0,
                            d = 0,
                            h = 0,
                            u = 0,
                            g = 0,
                            p = 0;
                        e--, i--, s[0] = 0, r[0] = 0, this.m_forwardHistory = [], this.m_reverseHistory = [];
                        const f = t - e + (o - i),
                            m = f + 1,
                            v = new Int32Array(m),
                            _ = new Int32Array(m),
                            b = o - i,
                            w = t - e,
                            y = e - i,
                            C = t - o,
                            x = (w - b) % 2 == 0;
                        v[b] = e, _[w] = t, a[0] = !1;
                        for (let S = 1; S <= f / 2 + 1; S++) {
                            let f = 0,
                                k = 0;
                            h = this.ClipDiagonalBound(b - S, S, b, m), u = this.ClipDiagonalBound(b + S, S, b, m);
                            for (let e = h; e <= u; e += 2) {
                                c = e === h || e < u && v[e - 1] < v[e + 1] ? v[e + 1] : v[e - 1] + 1, d = c - (e - b) - y;
                                const i = c;
                                for (; c < t && d < o && this.ElementsAreEqual(c + 1, d + 1);) c++, d++;
                                if (v[e] = c, c + d > f + k && (f = c, k = d), !x && Math.abs(e - w) <= S - 1 && c >= _[e]) return s[0] = c, r[0] = d, i <= _[e] && S <= 1448 ? this.WALKTRACE(b, h, u, y, w, g, p, C, v, _, c, t, s, d, o, r, x, a) : null
                            }
                            const L = (f - e + (k - i) - S) / 2;
                            if (null !== this.ContinueProcessingPredicate && !this.ContinueProcessingPredicate(f, L)) return a[0] = !0, s[0] = f, r[0] = k, L > 0 && S <= 1448 ? this.WALKTRACE(b, h, u, y, w, g, p, C, v, _, c, t, s, d, o, r, x, a) : (e++, i++, [new n(e, t - e + 1, i, o - i + 1)]);
                            g = this.ClipDiagonalBound(w - S, S, w, m), p = this.ClipDiagonalBound(w + S, S, w, m);
                            for (let n = g; n <= p; n += 2) {
                                c = n === g || n < p && _[n - 1] >= _[n + 1] ? _[n + 1] - 1 : _[n - 1], d = c - (n - w) - C;
                                const l = c;
                                for (; c > e && d > i && this.ElementsAreEqual(c, d);) c--, d--;
                                if (_[n] = c, x && Math.abs(n - b) <= S && c <= v[n]) return s[0] = c, r[0] = d, l >= v[n] && S <= 1448 ? this.WALKTRACE(b, h, u, y, w, g, p, C, v, _, c, t, s, d, o, r, x, a) : null
                            }
                            if (S <= 1447) {
                                let e = new Int32Array(u - h + 2);
                                e[0] = b - h + 1, l.Copy2(v, h, e, 1, u - h + 1), this.m_forwardHistory.push(e), e = new Int32Array(p - g + 2), e[0] = w - g + 1, l.Copy2(_, g, e, 1, p - g + 1), this.m_reverseHistory.push(e)
                            }
                        }
                        return this.WALKTRACE(b, h, u, y, w, g, p, C, v, _, c, t, s, d, o, r, x, a)
                    }
                    PrettifyChanges(e) {
                        for (let t = 0; t < e.length; t++) {
                            const i = e[t],
                                n = t < e.length - 1 ? e[t + 1].originalStart : this._originalElementsOrHash.length,
                                o = t < e.length - 1 ? e[t + 1].modifiedStart : this._modifiedElementsOrHash.length,
                                s = i.originalLength > 0,
                                r = i.modifiedLength > 0;
                            for (; i.originalStart + i.originalLength < n && i.modifiedStart + i.modifiedLength < o && (!s || this.OriginalElementsAreEqual(i.originalStart, i.originalStart + i.originalLength)) && (!r || this.ModifiedElementsAreEqual(i.modifiedStart, i.modifiedStart + i.modifiedLength));) {
                                const e = this.ElementsAreStrictEqual(i.originalStart, i.modifiedStart);
                                if (this.ElementsAreStrictEqual(i.originalStart + i.originalLength, i.modifiedStart + i.modifiedLength) && !e) break;
                                i.originalStart++, i.modifiedStart++
                            }
                            let a = [null];
                            t < e.length - 1 && this.ChangesOverlap(e[t], e[t + 1], a) && (e[t] = a[0], e.splice(t + 1, 1), t--)
                        }
                        for (let t = e.length - 1; t >= 0; t--) {
                            const i = e[t];
                            let n = 0,
                                o = 0;
                            if (t > 0) {
                                const i = e[t - 1];
                                n = i.originalStart + i.originalLength, o = i.modifiedStart + i.modifiedLength
                            }
                            const s = i.originalLength > 0,
                                r = i.modifiedLength > 0;
                            let a = 0,
                                l = this._boundaryScore(i.originalStart, i.originalLength, i.modifiedStart, i.modifiedLength);
                            for (let e = 1;; e++) {
                                const t = i.originalStart - e,
                                    c = i.modifiedStart - e;
                                if (t < n || c < o) break;
                                if (s && !this.OriginalElementsAreEqual(t, t + i.originalLength)) break;
                                if (r && !this.ModifiedElementsAreEqual(c, c + i.modifiedLength)) break;
                                const d = (t === n && c === o ? 5 : 0) + this._boundaryScore(t, i.originalLength, c, i.modifiedLength);
                                d > l && (l = d, a = e)
                            }
                            i.originalStart -= a, i.modifiedStart -= a;
                            const c = [null];
                            t > 0 && this.ChangesOverlap(e[t - 1], e[t], c) && (e[t - 1] = c[0], e.splice(t, 1), t++)
                        }
                        if (this._hasStrings)
                            for (let t = 1, i = e.length; t < i; t++) {
                                const i = e[t - 1],
                                    n = e[t],
                                    o = n.originalStart - i.originalStart - i.originalLength,
                                    s = i.originalStart,
                                    r = n.originalStart + n.originalLength,
                                    a = r - s,
                                    l = i.modifiedStart,
                                    c = n.modifiedStart + n.modifiedLength,
                                    d = c - l;
                                if (o < 5 && a < 20 && d < 20) {
                                    const e = this._findBetterContiguousSequence(s, a, l, d, o);
                                    if (e) {
                                        const [t, s] = e;
                                        t === i.originalStart + i.originalLength && s === i.modifiedStart + i.modifiedLength || (i.originalLength = t - i.originalStart, i.modifiedLength = s - i.modifiedStart, n.originalStart = t + o, n.modifiedStart = s + o, n.originalLength = r - n.originalStart, n.modifiedLength = c - n.modifiedStart)
                                    }
                                }
                            }
                        return e
                    }
                    _findBetterContiguousSequence(e, t, i, n, o) {
                        if (t < o || n < o) return null;
                        const s = e + t - o + 1,
                            r = i + n - o + 1;
                        let a = 0,
                            l = 0,
                            c = 0;
                        for (let t = e; t < s; t++)
                            for (let e = i; e < r; e++) {
                                const i = this._contiguousSequenceScore(t, e, o);
                                i > 0 && i > a && (a = i, l = t, c = e)
                            }
                        return a > 0 ? [l, c] : null
                    }
                    _contiguousSequenceScore(e, t, i) {
                        let n = 0;
                        for (let o = 0; o < i; o++) {
                            if (!this.ElementsAreEqual(e + o, t + o)) return 0;
                            n += this._originalStringElements[e + o].length
                        }
                        return n
                    }
                    _OriginalIsBoundary(e) {
                        return e <= 0 || e >= this._originalElementsOrHash.length - 1 || this._hasStrings && /^\s*$/.test(this._originalStringElements[e])
                    }
                    _OriginalRegionIsBoundary(e, t) {
                        if (this._OriginalIsBoundary(e) || this._OriginalIsBoundary(e - 1)) return !0;
                        if (t > 0) {
                            const i = e + t;
                            if (this._OriginalIsBoundary(i - 1) || this._OriginalIsBoundary(i)) return !0
                        }
                        return !1
                    }
                    _ModifiedIsBoundary(e) {
                        return e <= 0 || e >= this._modifiedElementsOrHash.length - 1 || this._hasStrings && /^\s*$/.test(this._modifiedStringElements[e])
                    }
                    _ModifiedRegionIsBoundary(e, t) {
                        if (this._ModifiedIsBoundary(e) || this._ModifiedIsBoundary(e - 1)) return !0;
                        if (t > 0) {
                            const i = e + t;
                            if (this._ModifiedIsBoundary(i - 1) || this._ModifiedIsBoundary(i)) return !0
                        }
                        return !1
                    }
                    _boundaryScore(e, t, i, n) {
                        return (this._OriginalRegionIsBoundary(e, t) ? 1 : 0) + (this._ModifiedRegionIsBoundary(i, n) ? 1 : 0)
                    }
                    ConcatenateChanges(e, t) {
                        let i = [];
                        if (0 === e.length || 0 === t.length) return t.length > 0 ? t : e;
                        if (this.ChangesOverlap(e[e.length - 1], t[0], i)) {
                            const n = new Array(e.length + t.length - 1);
                            return l.Copy(e, 0, n, 0, e.length - 1), n[e.length - 1] = i[0], l.Copy(t, 1, n, e.length, t.length - 1), n
                        } {
                            const i = new Array(e.length + t.length);
                            return l.Copy(e, 0, i, 0, e.length), l.Copy(t, 0, i, e.length, t.length), i
                        }
                    }
                    ChangesOverlap(e, t, i) {
                        if (a.Assert(e.originalStart <= t.originalStart, "Left change is not less than or equal to right change"), a.Assert(e.modifiedStart <= t.modifiedStart, "Left change is not less than or equal to right change"), e.originalStart + e.originalLength >= t.originalStart || e.modifiedStart + e.modifiedLength >= t.modifiedStart) {
                            const o = e.originalStart;
                            let s = e.originalLength;
                            const r = e.modifiedStart;
                            let a = e.modifiedLength;
                            return e.originalStart + e.originalLength >= t.originalStart && (s = t.originalStart + t.originalLength - e.originalStart), e.modifiedStart + e.modifiedLength >= t.modifiedStart && (a = t.modifiedStart + t.modifiedLength - e.modifiedStart), i[0] = new n(o, s, r, a), !0
                        }
                        return i[0] = null, !1
                    }
                    ClipDiagonalBound(e, t, i, n) {
                        if (e >= 0 && e < n) return e;
                        const o = t % 2 == 0;
                        if (e < 0) {
                            return o === (i % 2 == 0) ? 0 : 1
                        }
                        return o === ((n - i - 1) % 2 == 0) ? n - 1 : n - 2
                    }
                }
            },
            17301: (e, t, i) => {
                "use strict";
                i.d(t, {
                    B8: () => u,
                    Cp: () => s,
                    F0: () => c,
                    L6: () => h,
                    VV: () => l,
                    b1: () => d,
                    dL: () => o,
                    ri: () => r
                });
                const n = new class {
                    constructor() {
                        this.listeners = [], this.unexpectedErrorHandler = function(e) {
                            setTimeout((() => {
                                if (e.stack) throw new Error(e.message + "\n\n" + e.stack);
                                throw e
                            }), 0)
                        }
                    }
                    emit(e) {
                        this.listeners.forEach((t => {
                            t(e)
                        }))
                    }
                    onUnexpectedError(e) {
                        this.unexpectedErrorHandler(e), this.emit(e)
                    }
                    onUnexpectedExternalError(e) {
                        this.unexpectedErrorHandler(e)
                    }
                };

                function o(e) {
                    l(e) || n.onUnexpectedError(e)
                }

                function s(e) {
                    l(e) || n.onUnexpectedExternalError(e)
                }

                function r(e) {
                    if (e instanceof Error) {
                        let {
                            name: t,
                            message: i
                        } = e;
                        return {
                            $isError: !0,
                            name: t,
                            message: i,
                            stack: e.stacktrace || e.stack
                        }
                    }
                    return e
                }
                const a = "Canceled";

                function l(e) {
                    return e instanceof Error && e.name === a && e.message === a
                }

                function c() {
                    const e = new Error(a);
                    return e.name = e.message, e
                }

                function d(e) {
                    return e ? new Error(`Illegal argument: ${e}`) : new Error("Illegal argument")
                }

                function h(e) {
                    return e ? new Error(`Illegal state: ${e}`) : new Error("Illegal state")
                }
                class u extends Error {
                    constructor(e) {
                        super("NotSupported"), e && (this.message = e)
                    }
                }
            },
            4669: (e, t, i) => {
                "use strict";
                i.d(t, {
                    D0: () => h,
                    E7: () => u,
                    K3: () => d,
                    Q5: () => c,
                    ZD: () => g,
                    ju: () => n
                });
                var n, o = i(17301),
                    s = i(5976),
                    r = i(91741),
                    a = i(84013);
                ! function(e) {
                    function t(e) {
                        return (t, i = null, n) => {
                            let o, s = !1;
                            return o = e((e => {
                                if (!s) return o ? o.dispose() : s = !0, t.call(i, e)
                            }), null, n), s && o.dispose(), o
                        }
                    }

                    function i(e, t) {
                        return a(((i, n = null, o) => e((e => i.call(n, t(e))), null, o)))
                    }

                    function n(e, t) {
                        return a(((i, n = null, o) => e((e => {
                            t(e), i.call(n, e)
                        }), null, o)))
                    }

                    function o(e, t) {
                        return a(((i, n = null, o) => e((e => t(e) && i.call(n, e)), null, o)))
                    }

                    function r(e, t, n) {
                        let o = n;
                        return i(e, (e => (o = t(o, e), o)))
                    }

                    function a(e) {
                        let t;
                        const i = new c({
                            onFirstListenerAdd() {
                                t = e(i.fire, i)
                            },
                            onLastListenerRemove() {
                                t.dispose()
                            }
                        });
                        return i.event
                    }

                    function l(e, t, i = 100, n = !1, o) {
                        let s, r, a, l = 0;
                        const d = new c({
                            leakWarningThreshold: o,
                            onFirstListenerAdd() {
                                s = e((e => {
                                    l++, r = t(r, e), n && !a && (d.fire(r), r = void 0), clearTimeout(a), a = setTimeout((() => {
                                        const e = r;
                                        r = void 0, a = void 0, (!n || l > 1) && d.fire(e), l = 0
                                    }), i)
                                }))
                            },
                            onLastListenerRemove() {
                                s.dispose()
                            }
                        });
                        return d.event
                    }

                    function d(e, t = ((e, t) => e === t)) {
                        let i, n = !0;
                        return o(e, (e => {
                            const o = n || !t(e, i);
                            return n = !1, i = e, o
                        }))
                    }
                    e.None = () => s.JT.None, e.once = t, e.map = i, e.forEach = n, e.filter = o, e.signal = function(e) {
                        return e
                    }, e.any = function(...e) {
                        return (t, i = null, n) => (0, s.F8)(...e.map((e => e((e => t.call(i, e)), null, n))))
                    }, e.reduce = r, e.debounce = l, e.latch = d, e.split = function(t, i) {
                        return [e.filter(t, i), e.filter(t, (e => !i(e)))]
                    }, e.buffer = function(e, t = !1, i = []) {
                        let n = i.slice(),
                            o = e((e => {
                                n ? n.push(e) : r.fire(e)
                            }));
                        const s = () => {
                                n && n.forEach((e => r.fire(e))), n = null
                            },
                            r = new c({
                                onFirstListenerAdd() {
                                    o || (o = e((e => r.fire(e))))
                                },
                                onFirstListenerDidAdd() {
                                    n && (t ? setTimeout(s) : s())
                                },
                                onLastListenerRemove() {
                                    o && o.dispose(), o = null
                                }
                            });
                        return r.event
                    };
                    class h {
                        constructor(e) {
                            this.event = e
                        }
                        map(e) {
                            return new h(i(this.event, e))
                        }
                        forEach(e) {
                            return new h(n(this.event, e))
                        }
                        filter(e) {
                            return new h(o(this.event, e))
                        }
                        reduce(e, t) {
                            return new h(r(this.event, e, t))
                        }
                        latch() {
                            return new h(d(this.event))
                        }
                        debounce(e, t = 100, i = !1, n) {
                            return new h(l(this.event, e, t, i, n))
                        }
                        on(e, t, i) {
                            return this.event(e, t, i)
                        }
                        once(e, i, n) {
                            return t(this.event)(e, i, n)
                        }
                    }
                    e.chain = function(e) {
                        return new h(e)
                    }, e.fromNodeEventEmitter = function(e, t, i = (e => e)) {
                        const n = (...e) => o.fire(i(...e)),
                            o = new c({
                                onFirstListenerAdd: () => e.on(t, n),
                                onLastListenerRemove: () => e.removeListener(t, n)
                            });
                        return o.event
                    }, e.fromDOMEventEmitter = function(e, t, i = (e => e)) {
                        const n = (...e) => o.fire(i(...e)),
                            o = new c({
                                onFirstListenerAdd: () => e.addEventListener(t, n),
                                onLastListenerRemove: () => e.removeEventListener(t, n)
                            });
                        return o.event
                    }, e.toPromise = function(e) {
                        return new Promise((i => t(e)(i)))
                    }
                }(n || (n = {}));
                class l {
                    constructor(e) {
                        this._listenerCount = 0, this._invocationCount = 0, this._elapsedOverall = 0, this._name = `${e}_${l._idPool++}`
                    }
                    start(e) {
                        this._stopWatch = new a.G(!0), this._listenerCount = e
                    }
                    stop() {
                        if (this._stopWatch) {
                            const e = this._stopWatch.elapsed();
                            this._elapsedOverall += e, this._invocationCount += 1, console.info(`did FIRE ${this._name}: elapsed_ms: ${e.toFixed(5)}, listener: ${this._listenerCount} (elapsed_overall: ${this._elapsedOverall.toFixed(2)}, invocations: ${this._invocationCount})`), this._stopWatch = void 0
                        }
                    }
                }
                l._idPool = 0;
                class c {
                    constructor(e) {
                        var t;
                        this._disposed = !1, this._options = e, this._leakageMon = void 0, this._perfMon = (null === (t = this._options) || void 0 === t ? void 0 : t._profName) ? new l(this._options._profName) : void 0
                    }
                    get event() {
                        return this._event || (this._event = (e, t, i) => {
                            var n;
                            this._listeners || (this._listeners = new r.S);
                            const o = this._listeners.isEmpty();
                            o && this._options && this._options.onFirstListenerAdd && this._options.onFirstListenerAdd(this);
                            const a = this._listeners.push(t ? [e, t] : e);
                            o && this._options && this._options.onFirstListenerDidAdd && this._options.onFirstListenerDidAdd(this), this._options && this._options.onListenerDidAdd && this._options.onListenerDidAdd(this, e, t);
                            const l = null === (n = this._leakageMon) || void 0 === n ? void 0 : n.check(this._listeners.size),
                                c = (0, s.OF)((() => {
                                    if (l && l(), !this._disposed && (a(), this._options && this._options.onLastListenerRemove)) {
                                        this._listeners && !this._listeners.isEmpty() || this._options.onLastListenerRemove(this)
                                    }
                                }));
                            return i instanceof s.SL ? i.add(c) : Array.isArray(i) && i.push(c), c
                        }), this._event
                    }
                    fire(e) {
                        var t, i;
                        if (this._listeners) {
                            this._deliveryQueue || (this._deliveryQueue = new r.S);
                            for (let t of this._listeners) this._deliveryQueue.push([t, e]);
                            for (null === (t = this._perfMon) || void 0 === t || t.start(this._deliveryQueue.size); this._deliveryQueue.size > 0;) {
                                const [e, t] = this._deliveryQueue.shift();
                                try {
                                    "function" == typeof e ? e.call(void 0, t) : e[0].call(e[1], t)
                                } catch (e) {
                                    (0, o.dL)(e)
                                }
                            }
                            null === (i = this._perfMon) || void 0 === i || i.stop()
                        }
                    }
                    dispose() {
                        var e, t, i, n, o;
                        this._disposed || (this._disposed = !0, null === (e = this._listeners) || void 0 === e || e.clear(), null === (t = this._deliveryQueue) || void 0 === t || t.clear(), null === (n = null === (i = this._options) || void 0 === i ? void 0 : i.onLastListenerRemove) || void 0 === n || n.call(i), null === (o = this._leakageMon) || void 0 === o || o.dispose())
                    }
                }
                class d extends c {
                    constructor(e) {
                        super(e), this._isPaused = 0, this._eventQueue = new r.S, this._mergeFn = null == e ? void 0 : e.merge
                    }
                    pause() {
                        this._isPaused++
                    }
                    resume() {
                        if (0 !== this._isPaused && 0 == --this._isPaused)
                            if (this._mergeFn) {
                                const e = Array.from(this._eventQueue);
                                this._eventQueue.clear(), super.fire(this._mergeFn(e))
                            } else
                                for (; !this._isPaused && 0 !== this._eventQueue.size;) super.fire(this._eventQueue.shift())
                    }
                    fire(e) {
                        this._listeners && (0 !== this._isPaused ? this._eventQueue.push(e) : super.fire(e))
                    }
                }
                class h extends d {
                    constructor(e) {
                        var t;
                        super(e), this._delay = null !== (t = e.delay) && void 0 !== t ? t : 100
                    }
                    fire(e) {
                        this._handle || (this.pause(), this._handle = setTimeout((() => {
                            this._handle = void 0, this.resume()
                        }), this._delay)), super.fire(e)
                    }
                }
                class u {
                    constructor() {
                        this.buffers = []
                    }
                    wrapEvent(e) {
                        return (t, i, n) => e((e => {
                            const n = this.buffers[this.buffers.length - 1];
                            n ? n.push((() => t.call(i, e))) : t.call(i, e)
                        }), void 0, n)
                    }
                    bufferEvents(e) {
                        const t = [];
                        this.buffers.push(t);
                        const i = e();
                        return this.buffers.pop(), t.forEach((e => e())), i
                    }
                }
                class g {
                    constructor() {
                        this.listening = !1, this.inputEvent = n.None, this.inputEventListener = s.JT.None, this.emitter = new c({
                            onFirstListenerDidAdd: () => {
                                this.listening = !0, this.inputEventListener = this.inputEvent(this.emitter.fire, this.emitter)
                            },
                            onLastListenerRemove: () => {
                                this.listening = !1, this.inputEventListener.dispose()
                            }
                        }), this.event = this.emitter.event
                    }
                    set input(e) {
                        this.inputEvent = e, this.listening && (this.inputEventListener.dispose(), this.inputEventListener = e(this.emitter.fire, this.emitter))
                    }
                    dispose() {
                        this.inputEventListener.dispose(), this.emitter.dispose()
                    }
                }
            },
            15527: (e, t, i) => {
                "use strict";
                i.d(t, {
                    KM: () => a,
                    fn: () => r,
                    oP: () => c,
                    vY: () => l
                });
                var n = i(88721),
                    o = i(1432),
                    s = i(97295);

                function r(e) {
                    return -1 === e.indexOf("/") && (e = function(e) {
                        return e.replace(/[\\/]/g, n.KR.sep)
                    }(e)), /^[a-zA-Z]:(\/|$)/.test(e) && (e = "/" + e), e
                }

                function a(e, t, i, o = n.ir) {
                    if (e === t) return !0;
                    if (!e || !t) return !1;
                    if (t.length > e.length) return !1;
                    if (i) {
                        if (!(0, s.ok)(e, t)) return !1;
                        if (t.length === e.length) return !0;
                        let i = t.length;
                        return t.charAt(t.length - 1) === o && i--, e.charAt(i) === o
                    }
                    return t.charAt(t.length - 1) !== o && (t += o), 0 === e.indexOf(t)
                }

                function l(e) {
                    const t = (0, n.Fv)(e);
                    return o.ED ? !(e.length > 3) && (c(t) && (2 === e.length || 92 === t.charCodeAt(2))) : t === n.KR.sep
                }

                function c(e) {
                    return !!o.ED && (((t = e.charCodeAt(0)) >= 65 && t <= 90 || t >= 97 && t <= 122) && 58 === e.charCodeAt(1));
                    var t
                }
            },
            75392: (e, t, i) => {
                "use strict";
                i.d(t, {
                    CL: () => z,
                    EW: () => j,
                    Ji: () => r,
                    KZ: () => w,
                    Oh: () => L,
                    ir: () => a,
                    jB: () => N,
                    l7: () => $,
                    mB: () => D,
                    or: () => s
                });
                var n = i(43702),
                    o = i(97295);

                function s(...e) {
                    return function(t, i) {
                        for (let n = 0, o = e.length; n < o; n++) {
                            const o = e[n](t, i);
                            if (o) return o
                        }
                        return null
                    }
                }
                const r = function(e, t, i) {
                    if (!i || i.length < t.length) return null;
                    let n;
                    n = e ? o.ok(i, t) : 0 === i.indexOf(t);
                    if (!n) return null;
                    return t.length > 0 ? [{
                        start: 0,
                        end: t.length
                    }] : []
                }.bind(void 0, !0);

                function a(e, t) {
                    const i = t.toLowerCase().indexOf(e.toLowerCase());
                    return -1 === i ? null : [{
                        start: i,
                        end: i + e.length
                    }]
                }

                function l(e, t, i, n) {
                    if (i === e.length) return [];
                    if (n === t.length) return null;
                    if (e[i] === t[n]) {
                        let o = null;
                        return (o = l(e, t, i + 1, n + 1)) ? m({
                            start: n,
                            end: n + 1
                        }, o) : null
                    }
                    return l(e, t, i, n + 1)
                }

                function c(e) {
                    return 97 <= e && e <= 122
                }

                function d(e) {
                    return 65 <= e && e <= 90
                }

                function h(e) {
                    return 48 <= e && e <= 57
                }

                function u(e) {
                    return 32 === e || 9 === e || 10 === e || 13 === e
                }
                const g = new Set;

                function p(e) {
                    return u(e) || g.has(e)
                }

                function f(e) {
                    return c(e) || d(e) || h(e)
                }

                function m(e, t) {
                    return 0 === t.length ? t = [e] : e.end === t[0].start ? t[0].start = e.start : t.unshift(e), t
                }

                function v(e, t) {
                    for (let i = t; i < e.length; i++) {
                        const t = e.charCodeAt(i);
                        if (d(t) || h(t) || i > 0 && !f(e.charCodeAt(i - 1))) return i
                    }
                    return e.length
                }

                function _(e, t, i, n) {
                    if (i === e.length) return [];
                    if (n === t.length) return null;
                    if (e[i] !== t[n].toLowerCase()) return null; {
                        let o = null,
                            s = n + 1;
                        for (o = _(e, t, i + 1, n + 1); !o && (s = v(t, s)) < t.length;) o = _(e, t, i + 1, s), s++;
                        return null === o ? null : m({
                            start: n,
                            end: n + 1
                        }, o)
                    }
                }

                function b(e, t) {
                    if (!t) return null;
                    if (0 === (t = t.trim()).length) return null;
                    if (! function(e) {
                            let t = 0,
                                i = 0,
                                n = 0,
                                o = 0;
                            for (let s = 0; s < e.length; s++) n = e.charCodeAt(s), d(n) && t++, c(n) && i++, u(n) && o++;
                            return 0 !== t && 0 !== i || 0 !== o ? t <= 5 : e.length <= 30
                        }(e)) return null;
                    if (t.length > 60) return null;
                    const i = function(e) {
                        let t = 0,
                            i = 0,
                            n = 0,
                            o = 0,
                            s = 0;
                        for (let r = 0; r < e.length; r++) s = e.charCodeAt(r), d(s) && t++, c(s) && i++, f(s) && n++, h(s) && o++;
                        return {
                            upperPercent: t / e.length,
                            lowerPercent: i / e.length,
                            alphaPercent: n / e.length,
                            numericPercent: o / e.length
                        }
                    }(t);
                    if (! function(e) {
                            const {
                                upperPercent: t,
                                lowerPercent: i,
                                alphaPercent: n,
                                numericPercent: o
                            } = e;
                            return i > .2 && t < .8 && n > .6 && o < .2
                        }(i)) {
                        if (! function(e) {
                                const {
                                    upperPercent: t,
                                    lowerPercent: i
                                } = e;
                                return 0 === i && t > .6
                            }(i)) return null;
                        t = t.toLowerCase()
                    }
                    let n = null,
                        o = 0;
                    for (e = e.toLowerCase(); o < t.length && null === (n = _(e, t, 0, o));) o = v(t, o + 1);
                    return n
                }

                function w(e, t, i = !1) {
                    if (!t || 0 === t.length) return null;
                    let n = null,
                        o = 0;
                    for (e = e.toLowerCase(), t = t.toLowerCase(); o < t.length && null === (n = y(e, t, 0, o, i));) o = C(t, o + 1);
                    return n
                }

                function y(e, t, i, n, o) {
                    if (i === e.length) return [];
                    if (n === t.length) return null;
                    if (s = e.charCodeAt(i), r = t.charCodeAt(n), s === r || p(s) && p(r)) {
                        let s = null,
                            r = n + 1;
                        if (s = y(e, t, i + 1, n + 1, o), !o)
                            for (; !s && (r = C(t, r)) < t.length;) s = y(e, t, i + 1, r, o), r++;
                        return null === s ? null : m({
                            start: n,
                            end: n + 1
                        }, s)
                    }
                    return null;
                    var s, r
                }

                function C(e, t) {
                    for (let i = t; i < e.length; i++)
                        if (p(e.charCodeAt(i)) || i > 0 && p(e.charCodeAt(i - 1))) return i;
                    return e.length
                }
                "`~!@#$%^&*()-=+[{]}\\|;:'\",.<>/?".split("").forEach((e => g.add(e.charCodeAt(0))));
                const x = s(r, b, a),
                    S = s(r, b, (function(e, t) {
                        return l(e.toLowerCase(), t.toLowerCase(), 0, 0)
                    })),
                    k = new n.z6(1e4);

                function L(e, t, i = !1) {
                    if ("string" != typeof e || "string" != typeof t) return null;
                    let n = k.get(e);
                    n || (n = new RegExp(o.un(e), "i"), k.set(e, n));
                    const s = n.exec(t);
                    return s ? [{
                        start: s.index,
                        end: s.index + s[0].length
                    }] : i ? S(e, t) : x(e, t)
                }

                function N(e, t, i, n, o, s) {
                    const r = Math.min(13, e.length);
                    for (; i < r; i++) {
                        const r = j(e, t, i, n, o, s, !1);
                        if (r) return r
                    }
                    return [0, s]
                }

                function D(e) {
                    if (void 0 === e) return [];
                    const t = [],
                        i = e[1];
                    for (let n = e.length - 1; n > 1; n--) {
                        const o = e[n] + i,
                            s = t[t.length - 1];
                        s && s.end === o ? s.end = o + 1 : t.push({
                            start: o,
                            end: o + 1
                        })
                    }
                    return t
                }
                const I = 128;

                function E() {
                    const e = [],
                        t = [];
                    for (let e = 0; e <= I; e++) t[e] = 0;
                    for (let i = 0; i <= I; i++) e.push(t.slice(0));
                    return e
                }

                function T(e) {
                    const t = [];
                    for (let i = 0; i <= e; i++) t[i] = 0;
                    return t
                }
                const M = T(2 * I),
                    A = T(2 * I),
                    O = E(),
                    P = E(),
                    R = E(),
                    F = !1;

                function B(e, t, i, n, o) {
                    function s(e, t, i = " ") {
                        for (; e.length < t;) e = i + e;
                        return e
                    }
                    let r = ` |   |${n.split("").map((e=>s(e,3))).join("|")}\n`;
                    for (let n = 0; n <= i; n++) r += 0 === n ? " |" : `${t[n-1]}|`, r += e[n].slice(0, o + 1).map((e => s(e.toString(), 3))).join("|") + "\n";
                    return r
                }

                function V(e, t) {
                    if (t < 0 || t >= e.length) return !1;
                    const i = e.codePointAt(t);
                    switch (i) {
                        case 95:
                        case 45:
                        case 46:
                        case 32:
                        case 47:
                        case 92:
                        case 39:
                        case 34:
                        case 58:
                        case 36:
                        case 60:
                        case 40:
                        case 91:
                            return !0;
              