/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshotContext;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.HashingOutputStream;

public class RuntimeClasspathResourceHasher
implements ResourceHasher {
    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshotContext fileSnapshotContext) {
        return fileSnapshotContext.getSnapshot().getHash();
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        HashingOutputStream hasher = Hashing.primitiveStreamHasher();
        return (HashCode)zipEntryContext.getEntry().withInputStream(inputStream -> {
            ByteStreams.copy((InputStream)inputStream, (OutputStream)hasher);
            return hasher.hash();
        });
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
    }
}

