/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class PathTracker
implements RelativePathSupplier {
    private final Deque<String> segments = new ArrayDeque<String>();
    private String rootName;

    public void enter(FileSystemLocationSnapshot snapshot) {
        this.enter(snapshot.getName());
    }

    public void enter(String name) {
        if (this.rootName == null) {
            this.rootName = name;
        } else {
            this.segments.addLast(name);
        }
    }

    public String leave() {
        String name = this.segments.pollLast();
        if (name == null) {
            name = this.rootName;
            this.rootName = null;
        }
        return name;
    }

    @Override
    public boolean isRoot() {
        return this.segments.isEmpty();
    }

    @Override
    public Collection<String> getSegments() {
        return this.segments;
    }

    public String toAbsolutePath() {
        if (this.segments.isEmpty()) {
            return this.rootName;
        }
        int length = this.rootName.length() + this.segments.size();
        for (String segment : this.segments) {
            length += segment.length();
        }
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(this.rootName);
        for (String segment : this.segments) {
            buffer.append(File.separatorChar);
            buffer.append(segment);
        }
        return buffer.toString();
    }

    @Override
    public String toRelativePath() {
        switch (this.segments.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.segments.getLast();
            }
        }
        int length = this.segments.size() - 1;
        for (String segment : this.segments) {
            length += segment.length();
        }
        StringBuilder buffer = new StringBuilder(length);
        Iterator<String> iterator = this.segments.iterator();
        while (true) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) break;
            buffer.append('/');
        }
        return buffer.toString();
    }
}

