/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.ex;

import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.EdtReplacementThread;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.Semaphore;
import org.jetbrains.kotlin.com.intellij.util.ui.UIUtil;

public class ApplicationUtil {
    public static void invokeLaterSomewhere(@NotNull Runnable r, @NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState) {
        if (r == null) {
            ApplicationUtil.$$$reportNull$$$0(9);
        }
        if (thread == null) {
            ApplicationUtil.$$$reportNull$$$0(10);
        }
        if (modalityState == null) {
            ApplicationUtil.$$$reportNull$$$0(11);
        }
        switch (thread) {
            case EDT: {
                SwingUtilities.invokeLater(r);
                break;
            }
            case WT: {
                ApplicationManager.getApplication().invokeLaterOnWriteThread(r, modalityState);
                break;
            }
            case EDT_WITH_IW: {
                ApplicationManager.getApplication().invokeLater(r, modalityState);
            }
        }
    }

    public static void invokeAndWaitSomewhere(Runnable runnable, EdtReplacementThread thread) {
        ApplicationUtil.invokeAndWaitSomewhere(runnable, thread, ApplicationManager.getApplication().getDefaultModalityState());
    }

    public static void invokeAndWaitSomewhere(@NotNull Runnable r, @NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState) {
        if (r == null) {
            ApplicationUtil.$$$reportNull$$$0(12);
        }
        if (thread == null) {
            ApplicationUtil.$$$reportNull$$$0(13);
        }
        if (modalityState == null) {
            ApplicationUtil.$$$reportNull$$$0(14);
        }
        switch (thread) {
            case EDT: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                UIUtil.invokeAndWaitIfNeeded((Runnable)r);
                break;
            }
            case WT: {
                if (ApplicationManager.getApplication().isWriteThread()) {
                    r.run();
                    break;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from EDT to WT");
                    break;
                }
                Semaphore s = new Semaphore(1);
                AtomicReference throwable = new AtomicReference();
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        throwable.set(t);
                    }
                    finally {
                        s.up();
                    }
                }, modalityState);
                s.waitFor();
                if (throwable.get() == null) break;
                ExceptionUtil.rethrow((Throwable)throwable.get());
                break;
            }
            case EDT_WITH_IW: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                ApplicationManager.getApplication().invokeAndWait(r, modalityState);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/ex/ApplicationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryRunReadAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithCheckCanceled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogAfterWriteAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLaterSomewhere";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAndWaitSomewhere";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

