/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.unix.IntegerUnixChannelOption;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.net.SocketOption;

public class IpDontFragmentProvider {
    private static final ChannelOption<?> IP_DONT_FRAGMENT_OPTION;
    private static final Object IP_DONT_FRAGMENT_TRUE_VALUE;
    private static final Object IP_DONT_FRAGMENT_FALSE_VALUE;

    public static <T> boolean trySet(Channel channel, boolean value) {
        if (IP_DONT_FRAGMENT_OPTION == null) {
            return false;
        }
        boolean success = channel.config().setOption(IP_DONT_FRAGMENT_OPTION, value ? IP_DONT_FRAGMENT_TRUE_VALUE : IP_DONT_FRAGMENT_FALSE_VALUE);
        return success ? value : !value;
    }

    static {
        ChannelOption ipDontFragmentOption = null;
        Constable ipDontFragmentTrueValue = null;
        Constable ipDontFragmentFalseValue = null;
        try {
            Class<?> c = Class.forName("jdk.net.ExtendedSocketOptions");
            Field f = c.getField("IP_DONTFRAGMENT");
            ipDontFragmentOption = NioChannelOption.of((SocketOption)f.get(null));
            ipDontFragmentTrueValue = Boolean.valueOf(true);
            ipDontFragmentFalseValue = Boolean.valueOf(false);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            ipDontFragmentOption = new IntegerUnixChannelOption("IP_DONTFRAG", 0, 10);
            ipDontFragmentTrueValue = 2;
            ipDontFragmentFalseValue = 0;
        }
        IP_DONT_FRAGMENT_OPTION = ipDontFragmentOption;
        IP_DONT_FRAGMENT_TRUE_VALUE = ipDontFragmentTrueValue;
        IP_DONT_FRAGMENT_FALSE_VALUE = ipDontFragmentFalseValue;
    }
}

