/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.math.vector.Vector4i;
import org.cloudburstmc.math.vector.VectorNd;
import org.cloudburstmc.math.vector.VectorNf;
import org.cloudburstmc.math.vector.VectorNl;
import org.cloudburstmc.math.vector.Vectori;

@ParametersAreNonnullByDefault
public class VectorNi
implements Vectori,
Comparable<VectorNi>,
Serializable,
Cloneable {
    public static VectorNi ZERO_2 = new ImmutableZeroVectorN(0, 0);
    public static VectorNi ZERO_3 = new ImmutableZeroVectorN(0, 0, 0);
    public static VectorNi ZERO_4 = new ImmutableZeroVectorN(0, 0, 0, 0);
    private static final long serialVersionUID = 1L;
    private final int[] vec;

    private VectorNi(int[] v) {
        this.vec = (int[])v.clone();
    }

    public int size() {
        return this.vec.length;
    }

    public int get(int comp) {
        return this.vec[comp];
    }

    public void set(int comp, int val2) {
        this.vec[comp] = val2;
    }

    public void setZero() {
        Arrays.fill(this.vec, 0);
    }

    @Nonnull
    public VectorNi resize(int size) {
        VectorNi d = VectorNi.from(size);
        System.arraycopy(this.vec, 0, d.vec, 0, Math.min(size, this.size()));
        return d;
    }

    @Nonnull
    public VectorNi add(VectorNi v) {
        return this.add(v.vec);
    }

    @Nonnull
    public VectorNi add(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = this.vec[comp] + v[comp];
        }
        return d;
    }

    @Nonnull
    public VectorNi sub(VectorNi v) {
        return this.sub(v.vec);
    }

    @Nonnull
    public VectorNi sub(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = this.vec[comp] - v[comp];
        }
        return d;
    }

    @Nonnull
    public VectorNi mul(double a) {
        return this.mul(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public VectorNi mul(int a) {
        int size = this.size();
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = this.vec[comp] * a;
        }
        return d;
    }

    @Nonnull
    public VectorNi mul(VectorNi v) {
        return this.mul(v.vec);
    }

    @Nonnull
    public VectorNi mul(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = this.vec[comp] * v[comp];
        }
        return d;
    }

    @Nonnull
    public VectorNi div(double a) {
        return this.div(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public VectorNi div(int a) {
        int size = this.size();
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = this.vec[comp] / a;
        }
        return d;
    }

    @Nonnull
    public VectorNi div(VectorNi v) {
        return this.div(v.vec);
    }

    @Nonnull
    public VectorNi div(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = this.vec[comp] / v[comp];
        }
        return d;
    }

    public int dot(VectorNi v) {
        return this.dot(v.vec);
    }

    public int dot(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        int d = 0;
        for (int comp = 0; comp < size; ++comp) {
            d += this.vec[comp] * v[comp];
        }
        return d;
    }

    @Nonnull
    public VectorNi project(VectorNi v) {
        return this.project(v.vec);
    }

    @Nonnull
    public VectorNi project(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        int lengthSquared = 0;
        for (int comp = 0; comp < size; ++comp) {
            lengthSquared += v[comp] * v[comp];
        }
        if (lengthSquared == 0) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        float a = (float)this.dot(v) / (float)lengthSquared;
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = GenericMath.floor(a * (float)v[comp]);
        }
        return d;
    }

    @Nonnull
    public VectorNi pow(double pow) {
        return this.pow(GenericMath.floor(pow));
    }

    @Override
    @Nonnull
    public VectorNi pow(int power) {
        int size = this.size();
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = GenericMath.floor(Math.pow(this.vec[comp], power));
        }
        return d;
    }

    @Override
    @Nonnull
    public VectorNi abs() {
        int size = this.size();
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = Math.abs(this.vec[comp]);
        }
        return d;
    }

    @Override
    @Nonnull
    public VectorNi negate() {
        int size = this.size();
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = -this.vec[comp];
        }
        return d;
    }

    @Nonnull
    public VectorNi min(VectorNi v) {
        return this.min(v.vec);
    }

    @Nonnull
    public VectorNi min(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = Math.min(this.vec[comp], v[comp]);
        }
        return d;
    }

    @Nonnull
    public VectorNi max(VectorNi v) {
        return this.max(v.vec);
    }

    @Nonnull
    public VectorNi max(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        VectorNi d = VectorNi.from(size);
        for (int comp = 0; comp < size; ++comp) {
            d.vec[comp] = Math.max(this.vec[comp], v[comp]);
        }
        return d;
    }

    public int distanceSquared(VectorNi v) {
        return this.distanceSquared(v.vec);
    }

    public int distanceSquared(int ... v) {
        int size = this.size();
        if (size != v.length) {
            throw new IllegalArgumentException("Vector sizes must be the same");
        }
        int d = 0;
        for (int comp = 0; comp < size; ++comp) {
            int delta = this.vec[comp] - v[comp];
            d += delta * delta;
        }
        return d;
    }

    public float distance(VectorNi v) {
        return this.distance(v.vec);
    }

    public float distance(int ... v) {
        return (float)Math.sqrt(this.distanceSquared(v));
    }

    @Override
    public int lengthSquared() {
        int size = this.size();
        int l = 0;
        for (int comp = 0; comp < size; ++comp) {
            l += this.vec[comp] * this.vec[comp];
        }
        return l;
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    public int getMinAxis() {
        int axis = 0;
        int value = this.vec[axis];
        int size = this.size();
        for (int comp = 1; comp < size; ++comp) {
            if (this.vec[comp] >= value) continue;
            value = this.vec[comp];
            axis = comp;
        }
        return axis;
    }

    @Override
    public int getMaxAxis() {
        int axis = 0;
        int value = this.vec[axis];
        int size = this.size();
        for (int comp = 1; comp < size; ++comp) {
            if (this.vec[comp] <= value) continue;
            value = this.vec[comp];
            axis = comp;
        }
        return axis;
    }

    @Nonnull
    public Vector2i toVector2() {
        return Vector2i.from(this);
    }

    @Nonnull
    public Vector3i toVector3() {
        return Vector3i.from(this);
    }

    @Nonnull
    public Vector4i toVector4() {
        return Vector4i.from(this);
    }

    @Override
    @Nonnull
    public int[] toArray() {
        return (int[])this.vec.clone();
    }

    @Override
    @Nonnull
    public VectorNi toInt() {
        int size = this.size();
        int[] intVec = new int[size];
        for (int comp = 0; comp < size; ++comp) {
            intVec[comp] = this.vec[comp];
        }
        return VectorNi.from(intVec);
    }

    @Override
    @Nonnull
    public VectorNl toLong() {
        int size = this.size();
        long[] longVec = new long[size];
        for (int comp = 0; comp < size; ++comp) {
            longVec[comp] = this.vec[comp];
        }
        return VectorNl.from(longVec);
    }

    @Override
    @Nonnull
    public VectorNf toFloat() {
        int size = this.size();
        float[] floatVec = new float[size];
        for (int comp = 0; comp < size; ++comp) {
            floatVec[comp] = this.vec[comp];
        }
        return VectorNf.from(floatVec);
    }

    @Override
    @Nonnull
    public VectorNd toDouble() {
        int size = this.size();
        double[] doubleVec = new double[size];
        for (int comp = 0; comp < size; ++comp) {
            doubleVec[comp] = this.vec[comp];
        }
        return VectorNd.from(doubleVec);
    }

    @Override
    public int compareTo(VectorNi v) {
        return this.lengthSquared() - v.lengthSquared();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorNi)) {
            return false;
        }
        return Arrays.equals(this.vec, ((VectorNi)obj).vec);
    }

    public int hashCode() {
        return 335 + Arrays.hashCode(this.vec);
    }

    @Nonnull
    public VectorNi clone() {
        return VectorNi.from(this);
    }

    @Nonnull
    public String toString() {
        return Arrays.toString(this.vec).replace('[', '(').replace(']', ')');
    }

    @Nonnull
    public static VectorNi from(int size) {
        return VectorNi.from(new int[size]);
    }

    @Nonnull
    public static VectorNi from(Vector2i v) {
        return VectorNi.from(v.getX(), v.getY());
    }

    @Nonnull
    public static VectorNi from(Vector3i v) {
        return VectorNi.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static VectorNi from(Vector4i v) {
        return VectorNi.from(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public static VectorNi from(VectorNi v) {
        return VectorNi.from(v.vec);
    }

    @Nonnull
    public static VectorNi from(int ... v) {
        if (v.length < 2) {
            throw new IllegalArgumentException("Minimum vector size is 2");
        }
        return new VectorNi((int[])v.clone());
    }

    @ParametersAreNonnullByDefault
    private static class ImmutableZeroVectorN
    extends VectorNi {
        public ImmutableZeroVectorN(int ... v) {
            super(v);
        }

        @Override
        public void set(int comp, int val2) {
            throw new UnsupportedOperationException("You may not alter this vector");
        }
    }
}

