/*
 * Decompiled with CFR 0.152.
 */
package net.cubespace.Yamler.Config;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import net.cubespace.Yamler.Config.Comment;
import net.cubespace.Yamler.Config.Comments;
import net.cubespace.Yamler.Config.ConfigMapper;
import net.cubespace.Yamler.Config.ConfigMode;
import net.cubespace.Yamler.Config.ConfigSection;
import net.cubespace.Yamler.Config.IConfig;
import net.cubespace.Yamler.Config.InvalidConfigurationException;
import net.cubespace.Yamler.Config.Path;

public class YamlConfig
extends ConfigMapper
implements IConfig {
    public YamlConfig() {
    }

    public YamlConfig(String filename) {
        this.CONFIG_FILE = new File(filename + (filename.endsWith(".yml") ? "" : ".yml"));
    }

    public void save(boolean withComments) throws InvalidConfigurationException {
        if (this.CONFIG_FILE == null) {
            throw new IllegalArgumentException("Saving a config without given File");
        }
        if (this.root == null) {
            this.root = new ConfigSection();
        }
        if (!withComments) {
            this.clearComments();
        }
        this.internalSave(this.getClass());
        this.saveToYaml();
    }

    @Override
    public void save() throws InvalidConfigurationException {
        this.save(true);
    }

    private void internalSave(Class clazz) throws InvalidConfigurationException {
        if (!clazz.getSuperclass().equals(YamlConfig.class)) {
            this.internalSave(clazz.getSuperclass());
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (this.doSkip(field)) continue;
            String path = "";
            switch (this.CONFIG_MODE) {
                case PATH_BY_UNDERSCORE: {
                    path = field.getName().replace("_", ".");
                    break;
                }
                case FIELD_IS_KEY: {
                    path = field.getName();
                    break;
                }
                default: {
                    String fieldName = field.getName();
                    path = fieldName.contains("_") ? field.getName().replace("_", ".") : field.getName();
                }
            }
            ArrayList<String> comments = new ArrayList<String>();
            for (Annotation annotation : field.getAnnotations()) {
                Annotation comment;
                if (annotation instanceof Comment) {
                    comment = (Comment)annotation;
                    comments.add(comment.value());
                }
                if (!(annotation instanceof Comments)) continue;
                comment = (Comments)annotation;
                comments.addAll(Arrays.asList(comment.value()));
            }
            if (field.isAnnotationPresent(Path.class)) {
                Path path1 = field.getAnnotation(Path.class);
                path = path1.value();
            }
            if (comments.size() > 0) {
                for (String comment : comments) {
                    this.addComment(path, comment);
                }
            }
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
            }
            try {
                this.converter.toConfig(this, field, this.root, path);
                this.converter.fromConfig(this, field, this.root, path);
            }
            catch (Exception e) {
                if (this.skipFailedObjects) continue;
                throw new InvalidConfigurationException("Could not save the Field", e);
            }
        }
    }

    @Override
    public void save(File file) throws InvalidConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("File argument can not be null");
        }
        this.CONFIG_FILE = file;
        this.save();
    }

    @Override
    public void init() throws InvalidConfigurationException {
        if (!this.CONFIG_FILE.exists()) {
            if (this.CONFIG_FILE.getParentFile() != null) {
                this.CONFIG_FILE.getParentFile().mkdirs();
            }
            try {
                this.CONFIG_FILE.createNewFile();
                this.save();
            }
            catch (IOException e) {
                throw new InvalidConfigurationException("Could not create new empty Config", e);
            }
        } else {
            this.load();
        }
    }

    @Override
    public void init(File file) throws InvalidConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("File argument can not be null");
        }
        this.CONFIG_FILE = file;
        this.init();
    }

    @Override
    public void reload() throws InvalidConfigurationException {
        this.loadFromYaml();
        this.internalLoad(this.getClass());
    }

    @Override
    public void load() throws InvalidConfigurationException {
        if (this.CONFIG_FILE == null) {
            throw new IllegalArgumentException("Loading a config without given File");
        }
        this.loadFromYaml();
        this.update(this.root);
        this.internalLoad(this.getClass());
    }

    private void internalLoad(Class clazz) throws InvalidConfigurationException {
        if (!clazz.getSuperclass().equals(YamlConfig.class)) {
            this.internalLoad(clazz.getSuperclass());
        }
        boolean save = false;
        for (Field field : clazz.getDeclaredFields()) {
            String path;
            if (this.doSkip(field)) continue;
            String string = path = this.CONFIG_MODE.equals((Object)ConfigMode.PATH_BY_UNDERSCORE) ? field.getName().replaceAll("_", ".") : field.getName();
            if (field.isAnnotationPresent(Path.class)) {
                Path path1 = field.getAnnotation(Path.class);
                path = path1.value();
            }
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
            }
            if (this.root.has(path)) {
                try {
                    this.converter.fromConfig(this, field, this.root, path);
                    continue;
                }
                catch (Exception e) {
                    throw new InvalidConfigurationException("Could not set field " + field.getName(), e);
                }
            }
            try {
                this.converter.toConfig(this, field, this.root, path);
                this.converter.fromConfig(this, field, this.root, path);
                save = true;
            }
            catch (Exception e) {
                if (this.skipFailedObjects) continue;
                throw new InvalidConfigurationException("Could not get field", e);
            }
        }
        if (save) {
            this.saveToYaml();
        }
    }

    @Override
    public void load(File file) throws InvalidConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("File argument can not be null");
        }
        this.CONFIG_FILE = file;
        this.load();
    }
}

