/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.types;

import dev.waterdog.waterdogpe.logger.Color;
import dev.waterdog.waterdogpe.logger.MainLogger;

public class TextContainer
implements Cloneable {
    private String message;

    public TextContainer(String message) {
        this(message, new String[0]);
    }

    public TextContainer(String message, String ... args) {
        if (args != null && args.length >= 1) {
            message = this.translate(message, args);
        }
        this.message = message;
    }

    protected String translate(String message, String ... args) {
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("{%" + i + "}", args[i]);
        }
        return message;
    }

    public String getMessage() {
        return this.message;
    }

    public String clean() {
        return Color.clean(this.message);
    }

    public String toString() {
        return this.message;
    }

    protected TextContainer clone() {
        try {
            return (TextContainer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            MainLogger.getLogger().throwing(e);
            return null;
        }
    }
}

