/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.reporting;

import com.bugsnag.Bugsnag;
import com.bugsnag.Severity;
import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.WaterdogPE;
import dev.waterdog.waterdogpe.utils.reporting.Log4j2ErrorReporter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ErrorReporting {
    private Bugsnag bugsnag = null;

    public ErrorReporting(ProxyServer server) {
        if (server.getConfiguration().isEnableAnonymousErrorReporting()) {
            this.bugsnag = new Bugsnag("69403750fbff896b2e37022a56e3cde4");
            this.bugsnag.setAppVersion(WaterdogPE.version().baseVersion());
            this.bugsnag.addCallback(report -> {
                report.addToTab("version", "commitId", WaterdogPE.version().commitId());
                report.addToTab("version", "buildVersion", WaterdogPE.version().buildVersion());
                report.addToTab("version", "baseVersion", WaterdogPE.version().baseVersion());
                report.addToTab("version", "branchName", WaterdogPE.version().branchName());
                report.addToTab("version", "latestProtocolVersion", WaterdogPE.version().latestProtocolVersion());
                report.addToTab("java", "JVM version", System.getProperty("java.version"));
                report.addToTab("java", "JVM runtime", System.getProperty("java.runtime.name"));
                report.addToTab("java", "JVM runtime version", System.getProperty("java.runtime.version"));
                report.addToTab("os", "Name", System.getProperty("os.name"));
                report.addToTab("os", "Version", System.getProperty("os.version"));
                report.addToTab("os", "Architecture", System.getProperty("os.arch"));
            });
            this.setupErrorLogger();
            server.getLogger().info("Anonymous error reporting is enabled.");
        }
    }

    private void setupErrorLogger() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        PatternLayout layout = PatternLayout.createDefaultLayout(config);
        Log4j2ErrorReporter reporter = new Log4j2ErrorReporter("ExceptionAppender", null, layout, false);
        reporter.start();
        config.addAppender(reporter);
        ctx.getRootLogger().addAppender(reporter);
        ctx.updateLoggers();
    }

    public boolean isEnabled() {
        return this.bugsnag != null;
    }

    public void reportError(Throwable t, Severity severity) {
        if (this.isEnabled()) {
            this.bugsnag.notify(t, severity);
        }
    }
}

