/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.config.serializer;

import dev.waterdog.waterdogpe.utils.config.ServerEntry;
import dev.waterdog.waterdogpe.utils.config.ServerList;
import java.lang.reflect.ParameterizedType;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import net.cubespace.Yamler.Config.ConfigSection;
import net.cubespace.Yamler.Config.Converter.Converter;
import net.cubespace.Yamler.Config.InternalConverter;

public class ServerListConverter
implements Converter {
    private final InternalConverter internalConverter;

    public ServerListConverter(InternalConverter internalConverter) {
        this.internalConverter = internalConverter;
    }

    @Override
    public Object toConfig(Class<?> type, Object object, ParameterizedType parameterizedType) throws RuntimeException {
        ServerList list = (ServerList)object;
        ConfigSection section = new ConfigSection();
        Converter converter = this.internalConverter.getConverter(InetSocketAddress.class);
        for (ServerEntry serverEntry : list.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                map.put("address", converter.toConfig(InetSocketAddress.class, serverEntry.getAddress(), null));
                if (serverEntry.getPublicAddress() != null) {
                    map.put("public_address", converter.toConfig(InetSocketAddress.class, serverEntry.getPublicAddress(), null));
                }
                if (serverEntry.getServerType() != null) {
                    map.put("server_type", serverEntry.getServerType().toString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("ServerListConverter#toConfig converter.toConfig threw exception", e);
            }
            section.set(serverEntry.getServerName(), map);
        }
        return section;
    }

    @Override
    public Object fromConfig(Class<?> type, Object object, ParameterizedType parameterizedType) throws RuntimeException {
        ConfigSection section = (ConfigSection)object;
        Map<Object, Object> values = section.getValues(true);
        ServerList list = new ServerList();
        Converter converter = this.internalConverter.getConverter(ServerEntry.class);
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            Map map = (Map)entry.getValue();
            String name = (String)entry.getKey();
            try {
                HashMap<String, Map> entryMap = new HashMap<String, Map>();
                entryMap.put(name, map);
                list.putIfAbsent(name, (ServerEntry)converter.fromConfig(ServerEntry.class, entryMap, null));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot parse server info for " + name, e);
            }
        }
        return list;
    }

    @Override
    public boolean supports(Class<?> type) {
        return ServerList.class.isAssignableFrom(type);
    }
}

