/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.config.serializer;

import dev.waterdog.waterdogpe.network.serverinfo.ServerInfoType;
import dev.waterdog.waterdogpe.utils.config.ServerEntry;
import java.lang.reflect.ParameterizedType;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.cubespace.Yamler.Config.ConfigSection;
import net.cubespace.Yamler.Config.Converter.Converter;
import net.cubespace.Yamler.Config.InternalConverter;

public class ServerEntryConverter
implements Converter {
    private final InternalConverter internalConverter;

    public ServerEntryConverter(InternalConverter internalConverter) {
        this.internalConverter = internalConverter;
    }

    @Override
    public Object toConfig(Class<?> type, Object object, ParameterizedType parameterizedType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ServerEntry serverEntry = (ServerEntry)object;
        map.put("address", serverEntry.getAddress().getAddress().getHostAddress() + ":" + serverEntry.getAddress().getPort());
        if (serverEntry.getPublicAddress() != null && serverEntry.getPublicAddress() != serverEntry.getAddress()) {
            map.put("public_address", serverEntry.getAddress().getAddress().getHostAddress() + ":" + serverEntry.getAddress().getPort());
        }
        if (serverEntry.getServerType() != null) {
            map.put("server_type", serverEntry.getServerType().toString());
        }
        return map;
    }

    @Override
    public Object fromConfig(Class<?> type, Object object, ParameterizedType parameterizedType) throws Exception {
        Map map;
        Iterator iterator;
        if (object == null) {
            return null;
        }
        Converter inetConverter = this.internalConverter.getConverter(InetSocketAddress.class);
        if (object instanceof ConfigSection) {
            ConfigSection section = (ConfigSection)object;
            InetSocketAddress address = (InetSocketAddress)inetConverter.fromConfig(InetSocketAddress.class, section.get("address"), null);
            InetSocketAddress publicAddress = (InetSocketAddress)inetConverter.fromConfig(InetSocketAddress.class, section.get("public_address"), null);
            String serverType = (String)inetConverter.fromConfig(String.class, section.get("server_type"), null);
            return new ServerEntry((String)section.get("name"), address, publicAddress, this.validateServerType(serverType));
        }
        if (object instanceof Map && (iterator = (map = (Map)object).entrySet().iterator()).hasNext()) {
            Map.Entry subMap = iterator.next();
            InetSocketAddress address = (InetSocketAddress)inetConverter.fromConfig(InetSocketAddress.class, ((Map)subMap.getValue()).get("address"), null);
            InetSocketAddress publicAddress = (InetSocketAddress)inetConverter.fromConfig(InetSocketAddress.class, ((Map)subMap.getValue()).get("public_address"), null);
            String serverType = (String)((Map)subMap.getValue()).get("server_type");
            return new ServerEntry((String)subMap.getKey(), address, publicAddress, this.validateServerType(serverType));
        }
        throw new IllegalArgumentException("ServerInfoConverter#fromConfig cannot parse obj: " + object.getClass().getName());
    }

    private String validateServerType(String serverType) {
        if (serverType == null || serverType.isEmpty()) {
            return ServerInfoType.BEDROCK.getIdentifier();
        }
        return serverType;
    }

    @Override
    public boolean supports(Class<?> type) {
        return ServerEntry.class.isAssignableFrom(type);
    }
}

