/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.config.serializer;

import java.lang.reflect.ParameterizedType;
import java.net.InetSocketAddress;
import net.cubespace.Yamler.Config.Converter.Converter;
import net.cubespace.Yamler.Config.InternalConverter;

public class InetSocketAddressConverter
implements Converter {
    private final InternalConverter internalConverter;

    public InetSocketAddressConverter(InternalConverter internalConverter) {
        this.internalConverter = internalConverter;
    }

    @Override
    public Object toConfig(Class<?> type, Object object, ParameterizedType parameterizedType) throws Exception {
        if (object == null) {
            return null;
        }
        InetSocketAddress address = (InetSocketAddress)object;
        return address.getHostName() + ":" + address.getPort();
    }

    @Override
    public Object fromConfig(Class<?> type, Object object, ParameterizedType parameterizedType) throws Exception {
        if (object == null) {
            return null;
        }
        String string = (String)object;
        String address = string.substring(0, string.lastIndexOf(":"));
        int port = Integer.parseInt(string.substring(string.lastIndexOf(":") + 1));
        return new InetSocketAddress(address, port);
    }

    @Override
    public boolean supports(Class<?> type) {
        return InetSocketAddress.class.isAssignableFrom(type);
    }
}

