/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.config.proxy;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import dev.waterdog.waterdogpe.utils.config.ServerList;
import dev.waterdog.waterdogpe.utils.config.proxy.NetworkSettings;
import dev.waterdog.waterdogpe.utils.config.serializer.CompressionAlgorithmConverter;
import dev.waterdog.waterdogpe.utils.config.serializer.InetSocketAddressConverter;
import dev.waterdog.waterdogpe.utils.config.serializer.ServerEntryConverter;
import dev.waterdog.waterdogpe.utils.config.serializer.ServerListConverter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.cubespace.Yamler.Config.Comment;
import net.cubespace.Yamler.Config.Comments;
import net.cubespace.Yamler.Config.InvalidConverterException;
import net.cubespace.Yamler.Config.Path;
import net.cubespace.Yamler.Config.SerializeOptions;
import net.cubespace.Yamler.Config.YamlConfig;

@SerializeOptions(skipFailedObjects=true)
public class ProxyConfig
extends YamlConfig {
    @Path(value="listener.motd")
    @Comment(value="The Motd which will be displayed in the server tab of a player and returned during ping")
    private String motd = "\u00a7bWaterdog\u00a73PE";
    @Path(value="listener.name")
    @Comment(value="The name that is shown up in the player list (pause menu)")
    private String name = "\u00a7bWaterdog\u00a73PE";
    @Path(value="listener.priorities")
    @Comment(value="The server priority list. If not changed by plugins, the proxy will connect the player to the first of those servers")
    private List<String> priorities = new ArrayList<String>(Collections.singletonList("lobby1"));
    @Path(value="listener.host")
    @Comment(value="The address to bind the server to")
    private InetSocketAddress bindAddress = new InetSocketAddress("0.0.0.0", 19132);
    @Path(value="listener.max_players")
    @Comment(value="The maximum amount of players that can connect to this proxy instance")
    private int maxPlayerCount = 20;
    @Path(value="listener.forced_hosts")
    @Comments(value={"Map the ip a player joined through to a specific server", "for example skywars.xyz.com => SkyWars-1", "when a player connects using skywars-xyz.com as the serverIp, he will be connected to SkyWars-1 directly"})
    private Map<String, String> forcedHosts = new HashMap<String, String>();
    @Path(value="servers")
    @Comments(value={"A list of all downstream servers that are available right after starting", "address field is formatted using ip:port", "publicAddress is optional and can be set to the ip players can directly connect through"})
    private ServerList serverList = new ServerList().initEmpty();
    @Path(value="network_settings")
    @Comment(value="Connection and security related settings. Do NOT edit unless you know what you are doing!")
    private NetworkSettings networkSettings = new NetworkSettings();
    @Path(value="permissions")
    @Comment(value="Case-Sensitive permission list for players (empty using {})")
    private Object2ObjectOpenHashMap<String, List<String>> playerPermissions = new Object2ObjectOpenHashMap<String, List<String>>(){
        {
            this.put("alemiz003", Arrays.asList("waterdog.player.transfer", "waterdog.player.list"));
            this.put("TobiasDev", Arrays.asList("waterdog.player.transfer", "waterdog.player.list"));
        }
    };
    @Path(value="permissions_default")
    @Comment(value="List of permissions each player should get by default (empty using [])")
    private List<String> defaultPermissions = new ArrayList<String>(Arrays.asList("waterdog.command.help", "waterdog.command.info"));
    @Path(value="enable_debug")
    @Comment(value="Whether the debug output in the console should be enabled or not")
    private boolean debug;
    @Path(value="upstream_encryption")
    @Comment(value="If enabled, encrypted connection between client and proxy will be created")
    private boolean upstreamEncryption = true;
    @Path(value="online_mode")
    @Comment(value="If enabled, only players which are authenticated with XBOX Live can join. If disabled, anyone can connect *with any name*")
    private boolean onlineMode = true;
    @Path(value="listener.additional_ports")
    @Comment(value="Additional ports to listen to")
    private List<Integer> additionalPorts = new ArrayList<Integer>();
    @Path(value="listener.join_handler")
    @Comment(value="The join handler used to determine the first entered server. Possible options: DefaultJoinHandler")
    private String joinHandler = "DefaultJoinHandler";
    @Path(value="listener.reconnect_handler")
    @Comment(value="The reconnect handler used to determine fallback connections. Possible options: DefaultReconnectHandler, RoundRobinReconnectHandler")
    private String reconnectHandler = "DefaultReconnectHandler";
    @Path(value="use_login_extras")
    @Comment(value="If enabled, the proxy will pass information like XUID or IP to the downstream server using custom fields in the LoginPacket")
    private boolean useLoginExtras = false;
    @Path(value="replace_username_spaces")
    @Comment(value="Replaces username spaces with underscores if enabled")
    private boolean replaceUsernameSpaces = false;
    @Path(value="netease_client")
    @Comment(value="\u542f\u7528Netease\u7248\u672c\u652f\u6301\uff0c\u5141\u8bb8Netease\u5ba2\u6237\u7aef\u8fde\u63a5")
    private boolean netEaseClient = false;
    @Path(value="enable_query")
    @Comment(value="Whether server query should be enabled")
    private boolean enableQuery = true;
    @Path(value="prefer_fast_transfer")
    @Comment(value="If enabled, when receiving a McpeTransferPacket, the proxy will check if the target server is in the downstream list, and if yes, use the fast transfer mechanism")
    private boolean useFastTransfer = true;
    @Path(value="inject_proxy_commands")
    @Comment(value="If enabled, the proxy will inject all the proxy commands in the AvailableCommandsPacket, enabling autocompletion")
    private boolean injectCommands = true;
    @Path(value="compression")
    @Comments(value={"Algorithm used for upstream compression. Currently supported: zlib, snappy", "This is only applicable on 1.19.30 and newer versions"})
    private CompressionType compression = CompressionType.ZLIB;
    @Path(value="upstream_compression_level")
    @Comment(value="Upstream server compression ratio(proxy to client), higher = less bandwidth, more cpu, lower vice versa")
    private int upstreamCompression = 6;
    @Path(value="downstream_compression_level")
    @Comment(value="Downstream server compression ratio(proxy to downstream server), higher = less bandwidth, more cpu, lower vice versa")
    private int downstreamCompression = 2;
    @Path(value="enable_edu_features")
    @Comment(value="Education features require small adjustments to work correctly. Enable this option if any of downstream servers support education features.")
    private boolean enableEducationFeatures = true;
    @Path(value="enable_packs")
    @Comment(value="Enable/Disable the resource pack system")
    private boolean enableResourcePacks = true;
    @Path(value="overwrite_client_packs")
    @Comment(value="If this is enabled, the client will not be able to use custom packs")
    private boolean overwriteClientPacks = false;
    @Path(value="force_server_packs")
    @Comment(value="If enabled, the client will be forced to accept server-sided resource packs")
    private boolean forceServerPacks = false;
    @Path(value="pack_cache_size")
    @Comment(value="You can set maximum pack size in MB to be cached.")
    private int packCacheSize = 16;
    @Path(value="default_idle_threads")
    @Comment(value="Creating threads may be in some situations expensive. Specify minimum count of idle threads per internal thread executors. Set to -1 to auto-detect by core count.")
    private int defaultIdleThreads = -1;
    @Path(value="enable_statistics")
    @Comment(value="Enable anonymous statistics that are sent to bstats. For more information, check out our bstats page at https://bstats.org/plugin/server-implementation/WaterdogPE/15678")
    private boolean enableAnonymousStatistics = true;
    @Path(value="enable_error_reporting")
    @Comment(value="Enables anonymous error reporting using bugsnag. This allows the WaterdogPE team to automatically collect issues occurring on WaterdogPE instances.")
    private boolean enableAnonymousErrorReporting = true;

    public ProxyConfig(File file) {
        this.CONFIG_HEADER = new String[]{"Waterdog Main Configuration file", "Configure your desired network settings here."};
        this.CONFIG_FILE = file;
        try {
            this.addConverter(InetSocketAddressConverter.class);
            this.addConverter(ServerEntryConverter.class);
            this.addConverter(ServerListConverter.class);
            this.addConverter(CompressionAlgorithmConverter.class);
        }
        catch (InvalidConverterException e) {
            ProxyServer.getInstance().getLogger().error("Error while initiating config converters", e);
        }
    }

    public int getIdleThreads() {
        return this.defaultIdleThreads < 1 ? Runtime.getRuntime().availableProcessors() : this.defaultIdleThreads;
    }

    public boolean netEaseClient() {
        return this.netEaseClient;
    }

    public void setNetEaseClient(boolean netEaseMode) {
        this.netEaseClient = netEaseMode;
    }

    public String getMotd() {
        return this.motd;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPriorities() {
        return this.priorities;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public int getMaxPlayerCount() {
        return this.maxPlayerCount;
    }

    public Map<String, String> getForcedHosts() {
        return this.forcedHosts;
    }

    public ServerList getServerList() {
        return this.serverList;
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public Object2ObjectOpenHashMap<String, List<String>> getPlayerPermissions() {
        return this.playerPermissions;
    }

    public List<String> getDefaultPermissions() {
        return this.defaultPermissions;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUpstreamEncryption() {
        return this.upstreamEncryption;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public List<Integer> getAdditionalPorts() {
        return this.additionalPorts;
    }

    public String getJoinHandler() {
        return this.joinHandler;
    }

    public String getReconnectHandler() {
        return this.reconnectHandler;
    }

    public boolean useLoginExtras() {
        return this.useLoginExtras;
    }

    public boolean isReplaceUsernameSpaces() {
        return this.replaceUsernameSpaces;
    }

    public boolean isNetEaseClient() {
        return this.netEaseClient;
    }

    public boolean enableQuery() {
        return this.enableQuery;
    }

    public boolean useFastTransfer() {
        return this.useFastTransfer;
    }

    public boolean injectCommands() {
        return this.injectCommands;
    }

    public CompressionType getCompression() {
        return this.compression;
    }

    public int getUpstreamCompression() {
        return this.upstreamCompression;
    }

    public int getDownstreamCompression() {
        return this.downstreamCompression;
    }

    public boolean enableEducationFeatures() {
        return this.enableEducationFeatures;
    }

    public boolean enableResourcePacks() {
        return this.enableResourcePacks;
    }

    public boolean isOverwriteClientPacks() {
        return this.overwriteClientPacks;
    }

    public boolean isForceServerPacks() {
        return this.forceServerPacks;
    }

    public int getPackCacheSize() {
        return this.packCacheSize;
    }

    public int getDefaultIdleThreads() {
        return this.defaultIdleThreads;
    }

    public boolean isEnableAnonymousStatistics() {
        return this.enableAnonymousStatistics;
    }

    public boolean isEnableAnonymousErrorReporting() {
        return this.enableAnonymousErrorReporting;
    }

    public void setMotd(String motd) {
        this.motd = motd;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriorities(List<String> priorities) {
        this.priorities = priorities;
    }

    public void setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setMaxPlayerCount(int maxPlayerCount) {
        this.maxPlayerCount = maxPlayerCount;
    }

    public void setForcedHosts(Map<String, String> forcedHosts) {
        this.forcedHosts = forcedHosts;
    }

    public void setServerList(ServerList serverList) {
        this.serverList = serverList;
    }

    public void setNetworkSettings(NetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    public void setPlayerPermissions(Object2ObjectOpenHashMap<String, List<String>> playerPermissions) {
        this.playerPermissions = playerPermissions;
    }

    public void setDefaultPermissions(List<String> defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setUpstreamEncryption(boolean upstreamEncryption) {
        this.upstreamEncryption = upstreamEncryption;
    }

    public void setOnlineMode(boolean onlineMode) {
        this.onlineMode = onlineMode;
    }

    public void setAdditionalPorts(List<Integer> additionalPorts) {
        this.additionalPorts = additionalPorts;
    }

    public void setJoinHandler(String joinHandler) {
        this.joinHandler = joinHandler;
    }

    public void setReconnectHandler(String reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
    }

    public ProxyConfig useLoginExtras(boolean useLoginExtras) {
        this.useLoginExtras = useLoginExtras;
        return this;
    }

    public void setReplaceUsernameSpaces(boolean replaceUsernameSpaces) {
        this.replaceUsernameSpaces = replaceUsernameSpaces;
    }

    public ProxyConfig enableQuery(boolean enableQuery) {
        this.enableQuery = enableQuery;
        return this;
    }

    public ProxyConfig useFastTransfer(boolean useFastTransfer) {
        this.useFastTransfer = useFastTransfer;
        return this;
    }

    public ProxyConfig injectCommands(boolean injectCommands) {
        this.injectCommands = injectCommands;
        return this;
    }

    public void setCompression(CompressionType compression) {
        this.compression = compression;
    }

    public void setUpstreamCompression(int upstreamCompression) {
        this.upstreamCompression = upstreamCompression;
    }

    public void setDownstreamCompression(int downstreamCompression) {
        this.downstreamCompression = downstreamCompression;
    }

    public ProxyConfig enableEducationFeatures(boolean enableEducationFeatures) {
        this.enableEducationFeatures = enableEducationFeatures;
        return this;
    }

    public ProxyConfig enableResourcePacks(boolean enableResourcePacks) {
        this.enableResourcePacks = enableResourcePacks;
        return this;
    }

    public void setOverwriteClientPacks(boolean overwriteClientPacks) {
        this.overwriteClientPacks = overwriteClientPacks;
    }

    public void setForceServerPacks(boolean forceServerPacks) {
        this.forceServerPacks = forceServerPacks;
    }

    public void setPackCacheSize(int packCacheSize) {
        this.packCacheSize = packCacheSize;
    }

    public void setDefaultIdleThreads(int defaultIdleThreads) {
        this.defaultIdleThreads = defaultIdleThreads;
    }

    public void setEnableAnonymousStatistics(boolean enableAnonymousStatistics) {
        this.enableAnonymousStatistics = enableAnonymousStatistics;
    }

    public void setEnableAnonymousErrorReporting(boolean enableAnonymousErrorReporting) {
        this.enableAnonymousErrorReporting = enableAnonymousErrorReporting;
    }
}

