/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.config;

import dev.waterdog.waterdogpe.network.serverinfo.ServerInfoType;
import java.net.InetSocketAddress;
import org.cloudburstmc.protocol.common.util.Preconditions;

public class ServerEntry {
    private final String serverName;
    private final InetSocketAddress address;
    private final InetSocketAddress publicAddress;
    private final String serverType;

    public ServerEntry(String serverName, InetSocketAddress address, InetSocketAddress publicAddress, String serverType) {
        Preconditions.checkArgument(serverName != null && !serverName.isEmpty(), "Server name is not valid");
        Preconditions.checkNotNull(address, "Server address can not be null");
        Preconditions.checkNotNull(serverType, "ServerInfoType can not be null");
        this.serverName = serverName;
        this.address = address;
        this.publicAddress = publicAddress;
        this.serverType = serverType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getPublicAddress() {
        return this.publicAddress;
    }

    public String getServerType() {
        return this.serverType;
    }

    public ServerInfoType getServerInfoType() {
        ServerInfoType serverInfoType = ServerInfoType.fromString(this.serverType);
        if (serverInfoType == null) {
            throw new IllegalArgumentException("Unsupported ServerInfoType " + this.serverType + "! Make sure your config is valid and provided ServerInfoType was registered");
        }
        return serverInfoType;
    }

    public String toString() {
        return "ServerEntry(serverName=" + this.getServerName() + ", address=" + this.getAddress() + ", publicAddress=" + this.getPublicAddress() + ", serverType=" + this.getServerType() + ")";
    }
}

