/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.config;

import dev.waterdog.waterdogpe.logger.MainLogger;
import dev.waterdog.waterdogpe.utils.FileUtils;
import dev.waterdog.waterdogpe.utils.types.TextContainer;
import dev.waterdog.waterdogpe.utils.types.TranslationContainer;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;

public class LangConfig {
    protected final Object2ObjectMap<String, String> transactionMap = new Object2ObjectOpenHashMap<String, String>();
    private final File file;

    public LangConfig(File file) {
        this.file = file;
        this.load();
    }

    public void load() {
        try {
            String content = FileUtils.readFile(this.file);
            for (String line : content.split("\n")) {
                String[] t;
                if ((line = line.trim()).equals("") || line.charAt(0) == '#' || (t = line.split("=")).length < 2) continue;
                String key = t[0];
                StringBuilder value = new StringBuilder();
                for (int i = 1; i < t.length - 1; ++i) {
                    value.append(t[i]).append("=");
                }
                value.append(t[t.length - 1]);
                if (value.toString().equals("")) continue;
                this.transactionMap.put(key, value.toString());
            }
        }
        catch (IOException e) {
            MainLogger.getLogger().error("Unable to load Config " + this.file.toString());
        }
    }

    public String translateString(String key, String ... args) {
        String string = this.getTransaction(key);
        if (string == null) {
            return key;
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                string = string.replace("{%" + i + "}", String.valueOf(args[i]));
            }
        }
        return string;
    }

    public String translateContainer(TextContainer textContainer) {
        if (!(textContainer instanceof TranslationContainer)) {
            return textContainer.getMessage();
        }
        return this.translateString(textContainer.getMessage(), ((TranslationContainer)textContainer).getParams());
    }

    public String getTransaction(String key) {
        return (String)this.transactionMap.get(key);
    }

    public Object2ObjectMap<String, String> getTransactionMap() {
        return this.transactionMap;
    }
}

