/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils.bstats;

import dev.waterdog.MetricsBase;
import dev.waterdog.charts.CustomChart;
import dev.waterdog.charts.DrilldownPie;
import dev.waterdog.charts.SimplePie;
import dev.waterdog.charts.SingleLineChart;
import dev.waterdog.config.MetricsConfig;
import dev.waterdog.json.JsonObjectBuilder;
import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.WaterdogPE;
import dev.waterdog.waterdogpe.utils.config.proxy.ProxyConfig;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Metrics {
    private static final Logger log = LogManager.getLogger(Metrics.class);
    private static Metrics instance;
    private MetricsBase metricsBase;

    private Metrics(int serviceId, boolean defaultEnabled) {
        MetricsConfig config;
        File configFile = Path.of("plugins", "bStats", "config.txt").toFile();
        try {
            config = new MetricsConfig(configFile, defaultEnabled);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create bStats config", e);
        }
        this.metricsBase = new MetricsBase("server-implementation", config.getServerUUID(), serviceId, config.isEnabled(), this::appendPlatformData, jsonObjectBuilder -> {}, null, () -> ProxyServer.getInstance().isRunning(), log::warn, log::info, config.isLogErrorsEnabled(), config.isLogSentDataEnabled(), config.isLogResponseStatusTextEnabled());
        if (!config.didExistBefore()) {
            log.info("WaterdogPE and some of its plugins collect metrics and send them to bStats (https://bStats.org).");
            log.info("bStats collects some basic information for plugin authors, like how many people use");
            log.info("their plugin and their total player count. It's recommended to keep bStats enabled, but");
            log.info("if you're not comfortable with this, you can opt-out by editing the config.txt file in");
            log.info("the '/bStats/' folder and setting enabled to false.");
        }
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    public void shutdown() {
        this.metricsBase.shutdown();
    }

    public static void startMetrics(ProxyServer server, ProxyConfig metricsConfig) {
        if (instance != null) {
            throw new IllegalStateException("Metrics were already initialised");
        }
        Metrics metrics = new Metrics(WaterdogPE.version().metricsId(), metricsConfig.isEnableAnonymousStatistics());
        metrics.addCustomChart(new SingleLineChart("players", () -> server.getPlayers().size()));
        metrics.addCustomChart(new SingleLineChart("managed_servers", () -> server.getServers().size()));
        metrics.addCustomChart(new SimplePie("online_mode", () -> server.getConfiguration().isOnlineMode() ? "online" : "offline"));
        metrics.addCustomChart(new SimplePie("waterdog_version", () -> WaterdogPE.version().baseVersion()));
        metrics.addCustomChart(new DrilldownPie("java_version", () -> {
            String release;
            HashMap map = new HashMap();
            String javaVersion = System.getProperty("java.version");
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            String majorVersion = javaVersion.split("\\.")[0];
            int indexOf = javaVersion.lastIndexOf(46);
            if (majorVersion.equals("1")) {
                release = "Java " + javaVersion.substring(0, indexOf);
            } else {
                Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                if (versionMatcher.find()) {
                    majorVersion = versionMatcher.group(0);
                }
                release = "Java " + majorVersion;
            }
            map.put((CallSite)((Object)release), entry);
            return map;
        }));
        instance = metrics;
    }

    public static Metrics get() {
        return instance;
    }
}

