/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils;

import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadFactoryBuilder
implements ThreadFactory {
    private static final ThreadFactory backingFactory = Executors.defaultThreadFactory();
    private final AtomicInteger count = new AtomicInteger(0);
    private final boolean daemon;
    private final String format;
    private final int priority;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    private static String format(String format, int count) {
        return String.format(Locale.ROOT, format, count);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = backingFactory.newThread(runnable);
        if (this.format != null) {
            thread.setName(ThreadFactoryBuilder.format(this.format, this.count.getAndIncrement()));
        }
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        if (this.exceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.exceptionHandler);
        }
        return thread;
    }

    private static int $default$priority() {
        return Thread.currentThread().getPriority();
    }

    ThreadFactoryBuilder(boolean daemon, String format, int priority, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.daemon = daemon;
        this.format = format;
        this.priority = priority;
        this.exceptionHandler = exceptionHandler;
    }

    public static ThreadFactoryBuilderBuilder builder() {
        return new ThreadFactoryBuilderBuilder();
    }

    public static class ThreadFactoryBuilderBuilder {
        private boolean daemon;
        private String format;
        private boolean priority$set;
        private int priority$value;
        private Thread.UncaughtExceptionHandler exceptionHandler;

        ThreadFactoryBuilderBuilder() {
        }

        public ThreadFactoryBuilderBuilder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public ThreadFactoryBuilderBuilder format(String format) {
            this.format = format;
            return this;
        }

        public ThreadFactoryBuilderBuilder priority(int priority) {
            this.priority$value = priority;
            this.priority$set = true;
            return this;
        }

        public ThreadFactoryBuilderBuilder exceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public ThreadFactoryBuilder build() {
            int priority$value = this.priority$value;
            if (!this.priority$set) {
                priority$value = ThreadFactoryBuilder.$default$priority();
            }
            return new ThreadFactoryBuilder(this.daemon, this.format, priority$value, this.exceptionHandler);
        }

        public String toString() {
            return "ThreadFactoryBuilder.ThreadFactoryBuilderBuilder(daemon=" + this.daemon + ", format=" + this.format + ", priority$value=" + this.priority$value + ", exceptionHandler=" + this.exceptionHandler + ")";
        }
    }
}

