/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.waterdog.waterdogpe.packs.types.PackedVersion;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class FileUtils {
    public static final int INT_MEGABYTE = 0x100000;
    public static final Gson GSON;

    public static void saveFromResources(String fileName, File targetFile) throws IOException {
        if (targetFile.exists()) {
            return;
        }
        targetFile.createNewFile();
        InputStream inputStream = FileUtils.class.getClassLoader().getResourceAsStream(fileName);
        byte[] buffer = new byte[inputStream.available()];
        inputStream.read(buffer);
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        ((OutputStream)outputStream).write(buffer);
        inputStream.close();
    }

    public static String readFile(File file) throws IOException {
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        return FileUtils.readFile(new FileInputStream(file));
    }

    public static String readFile(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        return FileUtils.readFile(new FileInputStream(file));
    }

    public static String readFile(InputStream inputStream) throws IOException {
        return FileUtils.readFile(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    private static String readFile(Reader reader) throws IOException {
        try (BufferedReader br = new BufferedReader(reader);){
            StringBuilder stringBuilder = new StringBuilder();
            String temp = br.readLine();
            while (temp != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(temp);
                temp = br.readLine();
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static void writeFile(String fileName, String content) throws IOException {
        FileUtils.writeFile(fileName, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    public static void writeFile(String fileName, InputStream content) throws IOException {
        FileUtils.writeFile(new File(fileName), content);
    }

    public static void writeFile(File file, String content) throws IOException {
        FileUtils.writeFile(file, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    public static void writeFile(File file, InputStream content) throws IOException {
        int length;
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null!");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream stream = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        while ((length = content.read(buffer)) != -1) {
            stream.write(buffer, 0, length);
        }
        content.close();
        stream.close();
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)PackedVersion.class), new PackedVersion.Serializer());
        builder.registerTypeAdapter((Type)((Object)PackedVersion.class), new PackedVersion.Deserializer());
        GSON = builder.create();
    }
}

