/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.utils;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfoMap;
import dev.waterdog.waterdogpe.plugin.PluginClassLoader;
import dev.waterdog.waterdogpe.plugin.PluginManager;
import dev.waterdog.waterdogpe.utils.FileUtils;
import dev.waterdog.waterdogpe.utils.config.Configuration;
import dev.waterdog.waterdogpe.utils.config.JsonConfig;
import dev.waterdog.waterdogpe.utils.config.LangConfig;
import dev.waterdog.waterdogpe.utils.config.ServerEntry;
import dev.waterdog.waterdogpe.utils.config.YamlConfig;
import dev.waterdog.waterdogpe.utils.config.proxy.ProxyConfig;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ServiceLoader;
import net.cubespace.Yamler.Config.InvalidConfigurationException;

public class ConfigurationManager {
    private final ProxyServer proxy;
    private ProxyConfig proxyConfig;
    private LangConfig langConfig;

    public ConfigurationManager(ProxyServer proxy) {
        this.proxy = proxy;
    }

    @Deprecated
    public static Configuration newConfig(File file, Type type) {
        return ConfigurationManager.newConfig(file.toString(), type);
    }

    @Deprecated
    public static Configuration newConfig(String file, Type type) {
        switch (type) {
            case YAML: {
                return new YamlConfig(file);
            }
            case JSON: {
                return new JsonConfig(file);
            }
        }
        return null;
    }

    public void loadProxyConfig() throws InvalidConfigurationException {
        File configFile = new File(this.proxy.getDataPath().toString() + "/config.yml");
        ProxyConfig config = new ProxyConfig(configFile);
        config.init();
        this.proxyConfig = config;
    }

    public void loadServerInfos(ServerInfoMap serverInfoMap) {
        for (ServerEntry entry : this.proxyConfig.getServerList().values()) {
            try {
                serverInfoMap.putIfAbsent(entry.getServerName(), serverInfoMap.fromServerEntry(entry));
            }
            catch (Exception e) {
                this.proxy.getLogger().error("Failed to create ServerInfo from " + entry, e);
            }
        }
    }

    public void loadLanguage() {
        File langFile = new File(this.proxy.getDataPath().toString() + "/lang.ini");
        if (!langFile.exists()) {
            try {
                FileUtils.saveFromResources("lang.ini", langFile);
            }
            catch (IOException e) {
                this.proxy.getLogger().error("Can not save lang file!", e);
            }
        }
        this.langConfig = new LangConfig(langFile);
    }

    public <T> T loadServiceProvider(String providerName, Class<T> clazz) {
        return this.loadServiceProvider(providerName, clazz, null);
    }

    public <T> T loadServiceProvider(String providerName, Class<T> clazz, PluginManager pluginManager) {
        HashSet providers = new HashSet();
        ServiceLoader.load(clazz).stream().forEach(providers::add);
        if (pluginManager != null) {
            for (PluginClassLoader loader : pluginManager.getPluginClassLoaders()) {
                ServiceLoader.load(clazz, loader).stream().forEach(providers::add);
            }
        }
        for (ServiceLoader.Provider provider : providers) {
            if (!provider.type().getSimpleName().equals(providerName)) continue;
            return (T)provider.get();
        }
        return null;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public LangConfig getLangConfig() {
        return this.langConfig;
    }

    public static enum Type {
        JSON(1),
        YAML(2),
        UNKNOWN(-1);

        private final int id;

        public static Type getTypeById(int id) {
            return Arrays.stream(Type.values()).filter(type -> type.getId() == id).findFirst().orElse(UNKNOWN);
        }

        private Type(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

