/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.security;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.protocol.user.HandshakeEntry;
import dev.waterdog.waterdogpe.security.ConnectionThrottle;
import dev.waterdog.waterdogpe.security.SecurityListener;
import dev.waterdog.waterdogpe.utils.config.proxy.NetworkSettings;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SecurityManager {
    private final ProxyServer proxy;
    private final ConnectionThrottle connectionThrottle;
    private final ConnectionThrottle loginThrottle;
    private final Map<InetAddress, Long> blockedConnections = new ConcurrentHashMap<InetAddress, Long>();
    private SecurityListener listener;

    public SecurityManager(ProxyServer proxy) {
        this.proxy = proxy;
        NetworkSettings settings = proxy.getNetworkSettings();
        int time = settings.getConnectionThrottleTime();
        if (time < 50) {
            throw new IllegalArgumentException("For performance reasons connection throttle time should be 50ms or more.");
        }
        this.connectionThrottle = settings.getConnectionThrottle() > 0 ? new ConnectionThrottle(settings.getConnectionThrottle(), time) : null;
        this.loginThrottle = settings.getConnectionThrottle() > 0 ? new ConnectionThrottle(settings.getLoginThrottle(), time) : null;
        proxy.getScheduler().scheduleRepeating(this::onBlockedTick, 1);
    }

    private void onBlockedTick() {
        long currTime = System.currentTimeMillis();
        Iterator<Map.Entry<InetAddress, Long>> iterator = this.blockedConnections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InetAddress, Long> entry = iterator.next();
            if (entry.getValue() == 0L || currTime <= entry.getValue()) continue;
            iterator.remove();
            this.proxy.getLogger().info("Unblocked address {}", entry.getKey());
        }
    }

    public void blockAddress(InetAddress address, long time, TimeUnit unit) {
        long millis = unit.toMillis(time);
        this.blockedConnections.put(address, System.currentTimeMillis() + millis);
        this.proxy.getLogger().info("Connection from {} is blocked for {}ms", address, millis);
    }

    public void unblockAddress(InetAddress address) {
        if (this.blockedConnections.remove(address) != null) {
            this.proxy.getLogger().info("Unblocked address {}", address);
        }
    }

    public boolean isAddressBlocked(InetAddress address) {
        return this.blockedConnections.containsKey(address);
    }

    public boolean onConnectionCreated(SocketAddress address) {
        InetSocketAddress addr;
        boolean success = true;
        if (this.connectionThrottle != null && address instanceof InetSocketAddress && !(success = this.connectionThrottle.throttle((addr = (InetSocketAddress)address).getAddress())) && this.listener != null) {
            this.listener.onThrottleReached(addr.getAddress(), this.connectionThrottle);
        }
        if (this.listener != null && !this.listener.onConnectionCreated(address)) {
            success = false;
        }
        return success;
    }

    public boolean onLoginAttempt(SocketAddress address) {
        InetSocketAddress addr;
        boolean success = true;
        if (this.loginThrottle != null && address instanceof InetSocketAddress && !(success = this.loginThrottle.throttle((addr = (InetSocketAddress)address).getAddress())) && this.listener != null) {
            this.listener.onThrottleReached(addr.getAddress(), this.loginThrottle);
        }
        if (this.listener != null && !this.listener.onLoginAttempt(address)) {
            success = false;
        }
        return success;
    }

    public String onLoginFailed(SocketAddress address, HandshakeEntry handshakeEntry, Throwable throwable, String reason) {
        if (this.listener != null) {
            return this.listener.onLoginFailed(address, handshakeEntry, throwable, reason);
        }
        return reason;
    }

    public void setListener(SecurityListener listener) {
        this.listener = listener;
    }

    public SecurityListener getListener() {
        return this.listener;
    }

    public ConnectionThrottle getConnectionThrottle() {
        return this.connectionThrottle;
    }

    public ConnectionThrottle getLoginThrottle() {
        return this.loginThrottle;
    }
}

