/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.security;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

public class ConnectionThrottle {
    private final ExpiringMap<InetAddress, Entry> map;
    private int limit;

    public ConnectionThrottle(int limit, int throttleTime) {
        this.limit = limit;
        this.map = ExpiringMap.builder().expiration(throttleTime, TimeUnit.MILLISECONDS).expirationPolicy(ExpirationPolicy.ACCESSED).variableExpiration().build();
    }

    public boolean throttle(InetAddress address) {
        int value;
        Entry entry = this.map.get(address);
        if (entry == null) {
            entry = new Entry(this.limit);
            this.map.put(address, entry, ExpirationPolicy.ACCESSED);
        }
        return (value = entry.value.incrementAndGet()) <= entry.limit;
    }

    public void unthrottle(InetAddress address) {
        Entry entry = this.map.get(address);
        if (entry != null) {
            entry.value.decrementAndGet();
        }
    }

    public void reset(InetAddress address) {
        this.map.remove(address);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    private static class Entry {
        private final AtomicInteger value = new AtomicInteger();
        private volatile int limit;

        public AtomicInteger getValue() {
            return this.value;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            AtomicInteger this$value = this.getValue();
            AtomicInteger other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLimit();
            AtomicInteger $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ConnectionThrottle.Entry(value=" + this.getValue() + ", limit=" + this.getLimit() + ")";
        }

        public Entry(int limit) {
            this.limit = limit;
        }
    }
}

