/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.scheduler;

import dev.waterdog.waterdogpe.logger.MainLogger;
import dev.waterdog.waterdogpe.scheduler.TaskHandler;

public abstract class Task
implements Runnable {
    private TaskHandler<Task> handler;

    public abstract void onRun(int var1);

    public abstract void onCancel();

    public void onError(Throwable error) {
        MainLogger.getLogger().error("Unable to complete task!", error);
    }

    @Override
    public void run() {
        this.onRun(this.handler.getLastRunTick());
    }

    public int getTaskId() {
        return this.handler == null ? -1 : this.handler.getTaskId();
    }

    public void cancel() {
        this.handler.cancel();
    }

    public TaskHandler<Task> getHandler() {
        return this.handler;
    }

    public void setHandler(TaskHandler<Task> handler) {
        if (this.handler != null) {
            throw new SecurityException("Can not change task handler!");
        }
        this.handler = handler;
    }
}

