/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.scheduler;

import dev.waterdog.waterdogpe.scheduler.Task;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CallbackTask<T>
extends Task {
    private final Supplier<T> task;
    private List<Consumer<T>> callbacks;

    public CallbackTask(Supplier<T> task) {
        this.task = task;
    }

    public CallbackTask(Supplier<T> task, Consumer<T> callback) {
        this.task = task;
        this.addCallback(callback);
    }

    @Override
    public void onRun(int currentTick) {
        this.complete(this.task.get());
    }

    @Override
    public void onCancel() {
        this.complete(null);
    }

    private void complete(T result) {
        if (this.callbacks != null && !this.callbacks.isEmpty()) {
            for (Consumer<T> callback : this.callbacks) {
                callback.accept(result);
            }
        }
    }

    public void addCallback(Consumer<T> callback) {
        if (this.callbacks == null) {
            this.callbacks = Collections.synchronizedList(new ObjectArrayList());
        }
        this.callbacks.add(callback);
    }
}

