/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.plugin;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.plugin.Plugin;
import dev.waterdog.waterdogpe.plugin.PluginClassLoader;
import dev.waterdog.waterdogpe.plugin.PluginLoader;
import dev.waterdog.waterdogpe.plugin.PluginYAML;
import dev.waterdog.waterdogpe.utils.exceptions.PluginChangeStateException;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class PluginManager {
    public static final Yaml yamlLoader;
    private final ProxyServer proxy;
    private final PluginLoader pluginLoader;
    protected final Object2ObjectMap<String, PluginClassLoader> pluginClassLoaders = new Object2ObjectArrayMap<String, PluginClassLoader>();
    private final Object2ObjectMap<String, Plugin> pluginMap = new Object2ObjectArrayMap<String, Plugin>();
    private final Object2ObjectMap<String, Class<?>> cachedClasses = new Object2ObjectArrayMap();
    private final List<Pair<PluginYAML, Path>> pluginsToLoad = new ObjectArrayList<Pair<PluginYAML, Path>>();

    public PluginManager(ProxyServer proxy) {
        this.proxy = proxy;
        this.pluginLoader = new PluginLoader(this);
        try {
            this.loadPluginsInside(this.proxy.getPluginPath());
        }
        catch (IOException e) {
            this.proxy.getLogger().error("Error while filtering plugin files", e);
        }
    }

    private void loadPluginsInside(Path folderPath) throws IOException {
        Comparator comparator = (o1, o2) -> {
            if (o2.getName().equals(o1.getName())) {
                return 0;
            }
            if (o2.getDepends() == null) {
                return 1;
            }
            return o2.getDepends().contains(o1.getName()) ? -1 : 1;
        };
        TreeMap<PluginYAML, Path> plugins = new TreeMap<PluginYAML, Path>(comparator);
        try (Stream<Path> stream = Files.walk(folderPath, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(PluginLoader::isJarFile).forEach(jarPath -> {
                PluginYAML config = this.loadPluginConfig((Path)jarPath);
                if (config != null) {
                    plugins.put(config, (Path)jarPath);
                }
            });
        }
        plugins.forEach(this::registerClassLoader);
    }

    private PluginYAML loadPluginConfig(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0]) || !PluginLoader.isJarFile(path)) {
            this.proxy.getLogger().warning("Cannot load plugin: Provided file is no jar file: " + path.getFileName());
            return null;
        }
        File pluginFile = path.toFile();
        if (!pluginFile.exists()) {
            return null;
        }
        return this.pluginLoader.loadPluginData(pluginFile, yamlLoader);
    }

    private PluginClassLoader registerClassLoader(PluginYAML config, Path path) {
        if (this.getPluginByName(config.getName()) != null) {
            this.proxy.getLogger().warning("Plugin is already loaded: {}", config.getName());
            return null;
        }
        PluginClassLoader classLoader = this.pluginLoader.loadClassLoader(config, path.toFile());
        if (classLoader != null) {
            this.pluginClassLoaders.put(config.getName(), classLoader);
            this.pluginsToLoad.add(ObjectObjectImmutablePair.of(config, path));
            this.proxy.getLogger().debug("Loaded class loader from {}", path.getFileName());
        }
        return classLoader;
    }

    public void loadAllPlugins() {
        for (Pair<PluginYAML, Path> pair : this.pluginsToLoad) {
            this.loadPlugin(pair.key(), pair.value());
        }
        this.pluginsToLoad.clear();
    }

    public Plugin loadPlugin(PluginYAML config, Path path) {
        File pluginFile = path.toFile();
        if (this.getPluginByName(config.getName()) != null) {
            this.proxy.getLogger().warning("Plugin is already loaded: {}", config.getName());
            return null;
        }
        PluginClassLoader classLoader = (PluginClassLoader)this.pluginClassLoaders.get(config.getName());
        if (classLoader == null) {
            classLoader = this.registerClassLoader(config, path);
        }
        if (classLoader == null) {
            return null;
        }
        Plugin plugin = this.pluginLoader.loadPluginJAR(config, pluginFile, classLoader);
        if (plugin == null) {
            return null;
        }
        try {
            plugin.onStartup();
        }
        catch (Exception e) {
            this.proxy.getLogger().error("Failed to load plugin {}!", config.getName(), e);
            return null;
        }
        this.proxy.getLogger().info("Loaded plugin {} successfully! (version={}, author={})", config.getName(), config.getVersion(), config.getAuthor());
        this.pluginMap.put(config.getName(), plugin);
        return plugin;
    }

    public void enableAllPlugins() {
        LinkedList<Plugin> failed = new LinkedList<Plugin>();
        for (Plugin plugin : this.pluginMap.values()) {
            if (this.enablePlugin(plugin, null)) continue;
            failed.add(plugin);
        }
        if (failed.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("\u00a7cFailed to load plugins: \u00a7e");
        while (failed.peek() != null) {
            Plugin plugin;
            plugin = (Plugin)failed.poll();
            builder.append(plugin.getName());
            if (failed.peek() == null) continue;
            builder.append(", ");
        }
        this.proxy.getLogger().warning(builder.toString());
    }

    public boolean enablePlugin(Plugin plugin, String parent) {
        if (plugin.isEnabled()) {
            return true;
        }
        String pluginName = plugin.getName();
        if (plugin.getDescription().getDepends() != null) {
            for (String depend : plugin.getDescription().getDepends()) {
                if (depend.equals(parent)) {
                    this.proxy.getLogger().warning("\u00a7cCan not enable plugin " + pluginName + " circular dependency " + parent + "!");
                    return false;
                }
                Plugin dependPlugin = this.getPluginByName(depend);
                if (dependPlugin == null) {
                    this.proxy.getLogger().warning("\u00a7cCan not enable plugin " + pluginName + " missing dependency " + depend + "!");
                    return false;
                }
                if (dependPlugin.isEnabled() || this.enablePlugin(dependPlugin, pluginName)) continue;
                return false;
            }
        }
        try {
            plugin.setEnabled(true);
        }
        catch (PluginChangeStateException e) {
            this.proxy.getLogger().error(e.getMessage(), e.getCause());
            return false;
        }
        return true;
    }

    public void disableAllPlugins() {
        for (Plugin plugin : this.pluginMap.values()) {
            this.proxy.getLogger().info("Disabling plugin " + plugin.getName() + "!");
            try {
                plugin.setEnabled(false);
            }
            catch (PluginChangeStateException e) {
                this.proxy.getLogger().error(e.getMessage(), e.getCause());
            }
        }
    }

    public Class<?> getClassFromCache(String className) {
        Class<?> clazz = (Class<?>)this.cachedClasses.get(className);
        if (clazz != null) {
            return clazz;
        }
        for (PluginClassLoader loader : this.pluginClassLoaders.values()) {
            try {
                clazz = loader.findClass(className, false);
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    protected void cacheClass(String className, Class<?> clazz) {
        this.cachedClasses.putIfAbsent(className, clazz);
    }

    public Map<String, Plugin> getPluginMap() {
        return Collections.unmodifiableMap(this.pluginMap);
    }

    public Collection<Plugin> getPlugins() {
        return Collections.unmodifiableCollection(this.pluginMap.values());
    }

    public Collection<PluginClassLoader> getPluginClassLoaders() {
        return Collections.unmodifiableCollection(this.pluginClassLoaders.values());
    }

    public Plugin getPluginByName(String pluginName) {
        return this.pluginMap.getOrDefault(pluginName, null);
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    static {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        yamlLoader = new Yaml(new CustomClassLoaderConstructor(PluginManager.class.getClassLoader()), representer);
    }
}

