/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.plugin;

import dev.waterdog.waterdogpe.plugin.Plugin;
import dev.waterdog.waterdogpe.plugin.PluginClassLoader;
import dev.waterdog.waterdogpe.plugin.PluginManager;
import dev.waterdog.waterdogpe.plugin.PluginYAML;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class PluginLoader {
    private static final Logger log = LogManager.getLogger(PluginLoader.class);
    private final PluginManager pluginManager;

    public PluginLoader(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    protected static boolean isJarFile(Path file) {
        return file.getFileName().toString().endsWith(".jar");
    }

    protected PluginClassLoader loadClassLoader(PluginYAML pluginConfig, File pluginJar) {
        try {
            return new PluginClassLoader(this.pluginManager, this.getClass().getClassLoader(), pluginJar);
        }
        catch (MalformedURLException e) {
            log.error("Error while creating class loader(plugin={})", (Object)pluginConfig.getName());
            return null;
        }
    }

    protected Plugin loadPluginJAR(PluginYAML pluginConfig, File pluginJar, PluginClassLoader loader) {
        try {
            Class<?> mainClass = loader.loadClass(pluginConfig.getMain());
            if (!Plugin.class.isAssignableFrom(mainClass)) {
                return null;
            }
            Class<Plugin> castedMain = mainClass.asSubclass(Plugin.class);
            Plugin plugin = castedMain.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            plugin.init(pluginConfig, this.pluginManager.getProxy(), pluginJar);
            return plugin;
        }
        catch (Exception e) {
            log.error("Error while loading plugin main class(main={}, plugin={})", (Object)pluginConfig.getMain(), (Object)pluginConfig.getName(), (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PluginYAML loadPluginData(File file, Yaml yaml) {
        try (JarFile pluginJar = new JarFile(file);){
            JarEntry configEntry = pluginJar.getJarEntry("waterdog.yml");
            if (configEntry == null) {
                configEntry = pluginJar.getJarEntry("plugin.yml");
            }
            if (configEntry == null) {
                log.warn("Jar file " + file.getName() + " doesnt contain a waterdog.yml or plugin.yml!");
                PluginYAML pluginYAML = null;
                return pluginYAML;
            }
            try (InputStream fileStream = pluginJar.getInputStream(configEntry);){
                PluginYAML pluginConfig = yaml.loadAs(fileStream, PluginYAML.class);
                if (pluginConfig.getMain() != null && pluginConfig.getName() != null) {
                    PluginYAML pluginYAML = pluginConfig;
                    return pluginYAML;
                }
            }
            log.warn("Invalid plugin.yml for " + file.getName() + ": main and/or name property missing");
            return null;
        }
        catch (Exception e) {
            log.error("Can not load plugin files in " + file.getPath(), (Throwable)e);
        }
        return null;
    }
}

