/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.plugin;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.WaterdogPE;
import dev.waterdog.waterdogpe.plugin.PluginYAML;
import dev.waterdog.waterdogpe.utils.FileUtils;
import dev.waterdog.waterdogpe.utils.config.Configuration;
import dev.waterdog.waterdogpe.utils.config.YamlConfig;
import dev.waterdog.waterdogpe.utils.exceptions.PluginChangeStateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.cloudburstmc.protocol.common.util.Preconditions;

public abstract class Plugin {
    private static final Logger log = LogManager.getLogger(Plugin.class);
    protected boolean enabled = false;
    private PluginYAML description;
    private ProxyServer proxy;
    private Logger logger;
    private File pluginFile;
    private File dataFolder;
    private File configFile;
    private Configuration config;
    private boolean initialized = false;

    protected final void init(PluginYAML description, ProxyServer proxy, File pluginFile) {
        Preconditions.checkArgument(!this.initialized, "Plugin has been already initialized!");
        this.initialized = true;
        this.description = description;
        this.proxy = proxy;
        this.logger = this.buildLogger();
        this.pluginFile = pluginFile;
        this.dataFolder = new File(proxy.getPluginPath() + "/" + description.getName().toLowerCase() + "/");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.configFile = new File(this.dataFolder, "config.yml");
    }

    private Logger buildLogger() {
        LoggerContext context = (LoggerContext)LogManager.getContext(false);
        org.apache.logging.log4j.core.config.Configuration config = context.getConfiguration();
        Level logLevel = WaterdogPE.version().debug() ? Level.DEBUG : Level.INFO;
        AppenderRef[] appenderRefs = new AppenderRef[]{AppenderRef.createAppenderRef("File-Plugin", null, null), AppenderRef.createAppenderRef("Console-Plugin", logLevel, null)};
        LoggerConfig logger = LoggerConfig.createLogger(false, logLevel, this.getName(), "", appenderRefs, null, config, null);
        logger.addAppender((Appender)config.getAppender("File-Plugin"), null, null);
        logger.addAppender((Appender)config.getAppender("Console-Plugin"), logLevel, null);
        config.addLogger(this.getName(), logger);
        LoggerConfig clazzLogger = LoggerConfig.createLogger(false, logLevel, this.getClass().getCanonicalName(), "", appenderRefs, null, config, null);
        clazzLogger.getAppenders().keySet().forEach(clazzLogger::removeAppender);
        clazzLogger.addAppender((Appender)config.getAppender("File-Plugin"), null, null);
        clazzLogger.addAppender((Appender)config.getAppender("Console-Plugin"), logLevel, null);
        config.addLogger(this.getClass().getCanonicalName(), clazzLogger);
        context.updateLoggers();
        return LogManager.getLogger(this.getName());
    }

    public void onStartup() {
    }

    public abstract void onEnable();

    public void onDisable() {
    }

    public InputStream getResourceFile(String filename) {
        try {
            JarFile pluginJar = new JarFile(this.pluginFile);
            JarEntry entry = pluginJar.getJarEntry(filename);
            return pluginJar.getInputStream(entry);
        }
        catch (IOException e) {
            this.proxy.getLogger().error("Can not get plugin resource!", e);
            return null;
        }
    }

    public boolean saveResource(String filename) {
        return this.saveResource(filename, false);
    }

    public boolean saveResource(String filename, boolean replace) {
        return this.saveResource(filename, filename, replace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveResource(String filename, String outputName, boolean replace) {
        Preconditions.checkArgument(filename != null && !filename.trim().isEmpty(), "Filename can not be null!");
        File file = new File(this.dataFolder, outputName);
        if (file.exists() && !replace) {
            return false;
        }
        try (InputStream resource = this.getResourceFile(filename);){
            if (resource == null) {
                boolean bl = false;
                return bl;
            }
            File outFolder = file.getParentFile();
            if (!outFolder.exists()) {
                outFolder.mkdirs();
            }
            FileUtils.writeFile(file, resource);
            return true;
        }
        catch (IOException e) {
            this.proxy.getLogger().error("Can not save plugin file!", e);
            return false;
        }
    }

    public void loadConfig() {
        try {
            this.saveResource("config.yml");
            this.config = new YamlConfig(this.configFile);
        }
        catch (Exception e) {
            this.proxy.getLogger().error("Can not load plugin config!");
        }
    }

    public Configuration getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) throws PluginChangeStateException {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        try {
            if (enabled) {
                this.onEnable();
            } else {
                this.onDisable();
            }
        }
        catch (Exception e) {
            throw new PluginChangeStateException("Can not " + (enabled ? "enable" : "disable") + " plugin " + this.description.getName() + "!", e);
        }
    }

    public PluginYAML getDescription() {
        return this.description;
    }

    public String getName() {
        return this.description.getName();
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }
}

