/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.player;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.utils.types.Permission;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerManager {
    private final ProxyServer proxy;
    private final Map<UUID, ProxiedPlayer> players = new ConcurrentHashMap<UUID, ProxiedPlayer>();

    public PlayerManager(ProxyServer proxy) {
        this.proxy = proxy;
    }

    public boolean registerPlayer(ProxiedPlayer player) {
        if (player == null) {
            return false;
        }
        ProxiedPlayer previousSession = this.players.remove(player.getUniqueId());
        if (previousSession != null && previousSession.getConnection().isConnected()) {
            previousSession.disconnect("disconnectionScreen.loggedinOtherLocation");
        }
        this.players.put(player.getUniqueId(), player);
        return true;
    }

    public void subscribePermissions(ProxiedPlayer player) {
        this.proxy.getConfiguration().getDefaultPermissions().forEach(perm -> player.addPermission(new Permission((String)perm, true)));
        List<String> permissions = this.proxy.getConfiguration().getPlayerPermissions().get(player.getName());
        if (permissions == null) {
            return;
        }
        for (String perm2 : permissions) {
            player.addPermission(new Permission(perm2, true));
        }
    }

    public void removePlayer(ProxiedPlayer player) {
        if (player != null) {
            this.players.remove(player.getUniqueId());
        }
    }

    public ProxiedPlayer getPlayer(UUID uuid) {
        return uuid == null ? null : this.players.get(uuid);
    }

    public ProxiedPlayer getPlayer(String playerName) {
        if (playerName == null) {
            return null;
        }
        for (ProxiedPlayer player : this.players.values()) {
            if (!player.getName().toLowerCase().startsWith(playerName.toLowerCase()) || player.getName().length() - playerName.length() != 0) continue;
            return player;
        }
        return null;
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public Map<UUID, ProxiedPlayer> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }
}

