/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.packs.types;

import dev.waterdog.waterdogpe.packs.types.PackManifest;
import dev.waterdog.waterdogpe.packs.types.PackedVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.UUID;

public abstract class ResourcePack {
    public static final String TYPE_RESOURCES = "resources";
    public static final String TYPE_DATA = "data";
    protected final Path packPath;
    protected PackManifest packManifest;
    protected String contentKey;

    public ResourcePack(Path packPath) {
        this.packPath = packPath;
    }

    public abstract long getPackSize();

    public abstract byte[] getHash();

    public abstract byte[] getChunk(int var1, int var2);

    public abstract void saveToCache() throws IOException;

    public abstract ByteBuffer getCachedPack();

    public abstract InputStream getStream(Path var1) throws IOException;

    public boolean loadManifest() throws IOException {
        try (InputStream stream = this.getStream(PackManifest.MANIFEST_PATH);){
            if (stream != null) {
                this.packManifest = PackManifest.fromStream(stream);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public PackManifest getPackManifest() {
        return this.packManifest;
    }

    public String getPackName() {
        return this.packManifest.getHeader().getName();
    }

    public UUID getPackId() {
        return this.packManifest.getHeader().getUuid();
    }

    public PackedVersion getVersion() {
        return this.packManifest.getHeader().getVersion();
    }

    public String getType() {
        return this.packManifest.getModules().get(0).getType();
    }

    public Path getPackPath() {
        return this.packPath;
    }

    public String getContentKey() {
        return this.contentKey;
    }

    public void setContentKey(String contentKey) {
        this.contentKey = contentKey;
    }
}

