/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.packs.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.waterdog.waterdogpe.utils.FileUtils;
import java.lang.reflect.Type;

public class PackedVersion {
    private final int[] version;

    public PackedVersion(int major, int minor, int patch) {
        this.version = new int[]{major, minor, patch};
    }

    public String toString() {
        return String.format("%d.%d.%d", this.version[0], this.version[1], this.version[2]);
    }

    public static class Deserializer
    implements JsonDeserializer<PackedVersion> {
        @Override
        public PackedVersion deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int[] version = (int[])context.deserialize(json, (Type)((Object)int[].class));
            return new PackedVersion(version[0], version[1], version[2]);
        }
    }

    public static class Serializer
    implements JsonSerializer<PackedVersion> {
        @Override
        public JsonElement serialize(PackedVersion version, Type typeOfSrc, JsonSerializationContext context) {
            return FileUtils.GSON.toJsonTree(version.version);
        }
    }
}

