/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.packs.types;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import dev.waterdog.waterdogpe.packs.types.PackedVersion;
import dev.waterdog.waterdogpe.utils.FileUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class PackManifest {
    public static final Path MANIFEST_PATH = Paths.get("manifest.json", new String[0]);
    public static final String BEHAVIOR_PACK = "behavior";
    public static final String RESOURCE_PACK = "resources";
    @SerializedName(value="format_version")
    private String formatVersion;
    private ManifestHeader header;
    private List<PackModule> modules = Collections.emptyList();
    private JsonElement metadata;
    private List<JsonElement> dependencies = Collections.emptyList();
    private List<String> capabilities = Collections.emptyList();
    @SerializedName(value="subpacks")
    private List<JsonElement> subPacks = Collections.emptyList();

    public static PackManifest fromStream(InputStream stream) {
        return FileUtils.GSON.fromJson((Reader)new InputStreamReader(stream), PackManifest.class);
    }

    public boolean validate() {
        if (this.formatVersion == null || this.header == null || this.modules == null) {
            return false;
        }
        return this.header.description != null && this.header.name != null && this.header.uuid != null && this.header.version != null;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public ManifestHeader getHeader() {
        return this.header;
    }

    public List<PackModule> getModules() {
        return this.modules;
    }

    public JsonElement getMetadata() {
        return this.metadata;
    }

    public List<JsonElement> getDependencies() {
        return this.dependencies;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public List<JsonElement> getSubPacks() {
        return this.subPacks;
    }

    public void setFormatVersion(String formatVersion) {
        this.formatVersion = formatVersion;
    }

    public void setHeader(ManifestHeader header) {
        this.header = header;
    }

    public void setModules(List<PackModule> modules) {
        this.modules = modules;
    }

    public void setMetadata(JsonElement metadata) {
        this.metadata = metadata;
    }

    public void setDependencies(List<JsonElement> dependencies) {
        this.dependencies = dependencies;
    }

    public void setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
    }

    public void setSubPacks(List<JsonElement> subPacks) {
        this.subPacks = subPacks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackManifest)) {
            return false;
        }
        PackManifest other = (PackManifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$formatVersion = this.getFormatVersion();
        String other$formatVersion = other.getFormatVersion();
        if (this$formatVersion == null ? other$formatVersion != null : !this$formatVersion.equals(other$formatVersion)) {
            return false;
        }
        ManifestHeader this$header = this.getHeader();
        ManifestHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List<PackModule> this$modules = this.getModules();
        List<PackModule> other$modules = other.getModules();
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        JsonElement this$metadata = this.getMetadata();
        JsonElement other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        List<JsonElement> this$dependencies = this.getDependencies();
        List<JsonElement> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<String> this$capabilities = this.getCapabilities();
        List<String> other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        List<JsonElement> this$subPacks = this.getSubPacks();
        List<JsonElement> other$subPacks = other.getSubPacks();
        return !(this$subPacks == null ? other$subPacks != null : !((Object)this$subPacks).equals(other$subPacks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackManifest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $formatVersion = this.getFormatVersion();
        result = result * 59 + ($formatVersion == null ? 43 : $formatVersion.hashCode());
        ManifestHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List<PackModule> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        JsonElement $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        List<JsonElement> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<String> $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        List<JsonElement> $subPacks = this.getSubPacks();
        result = result * 59 + ($subPacks == null ? 43 : ((Object)$subPacks).hashCode());
        return result;
    }

    public String toString() {
        return "PackManifest(formatVersion=" + this.getFormatVersion() + ", header=" + this.getHeader() + ", modules=" + this.getModules() + ", metadata=" + this.getMetadata() + ", dependencies=" + this.getDependencies() + ", capabilities=" + this.getCapabilities() + ", subPacks=" + this.getSubPacks() + ")";
    }

    public static class ManifestHeader {
        private String name;
        private UUID uuid;
        private String description;
        private PackedVersion version;
        @SerializedName(value="platform_locked")
        private boolean platformLocked;
        @SerializedName(value="min_engine_version")
        private PackedVersion minEngineVersion;
        @SerializedName(value="pack_scope")
        private String packScope = "global";
        @SerializedName(value="directory_load")
        private boolean directoryLoad;
        @SerializedName(value="load_before_game")
        private boolean loadBeforeGame;
        @SerializedName(value="lock_template_options")
        private boolean lockTemplateOptions;
        @SerializedName(value="population_control")
        private boolean populationControl;

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getDescription() {
            return this.description;
        }

        public PackedVersion getVersion() {
            return this.version;
        }

        public boolean isPlatformLocked() {
            return this.platformLocked;
        }

        public PackedVersion getMinEngineVersion() {
            return this.minEngineVersion;
        }

        public String getPackScope() {
            return this.packScope;
        }

        public boolean isDirectoryLoad() {
            return this.directoryLoad;
        }

        public boolean isLoadBeforeGame() {
            return this.loadBeforeGame;
        }

        public boolean isLockTemplateOptions() {
            return this.lockTemplateOptions;
        }

        public boolean isPopulationControl() {
            return this.populationControl;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setVersion(PackedVersion version) {
            this.version = version;
        }

        public void setPlatformLocked(boolean platformLocked) {
            this.platformLocked = platformLocked;
        }

        public void setMinEngineVersion(PackedVersion minEngineVersion) {
            this.minEngineVersion = minEngineVersion;
        }

        public void setPackScope(String packScope) {
            this.packScope = packScope;
        }

        public void setDirectoryLoad(boolean directoryLoad) {
            this.directoryLoad = directoryLoad;
        }

        public void setLoadBeforeGame(boolean loadBeforeGame) {
            this.loadBeforeGame = loadBeforeGame;
        }

        public void setLockTemplateOptions(boolean lockTemplateOptions) {
            this.lockTemplateOptions = lockTemplateOptions;
        }

        public void setPopulationControl(boolean populationControl) {
            this.populationControl = populationControl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManifestHeader)) {
                return false;
            }
            ManifestHeader other = (ManifestHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPlatformLocked() != other.isPlatformLocked()) {
                return false;
            }
            if (this.isDirectoryLoad() != other.isDirectoryLoad()) {
                return false;
            }
            if (this.isLoadBeforeGame() != other.isLoadBeforeGame()) {
                return false;
            }
            if (this.isLockTemplateOptions() != other.isLockTemplateOptions()) {
                return false;
            }
            if (this.isPopulationControl() != other.isPopulationControl()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            PackedVersion this$version = this.getVersion();
            PackedVersion other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            PackedVersion this$minEngineVersion = this.getMinEngineVersion();
            PackedVersion other$minEngineVersion = other.getMinEngineVersion();
            if (this$minEngineVersion == null ? other$minEngineVersion != null : !this$minEngineVersion.equals(other$minEngineVersion)) {
                return false;
            }
            String this$packScope = this.getPackScope();
            String other$packScope = other.getPackScope();
            return !(this$packScope == null ? other$packScope != null : !this$packScope.equals(other$packScope));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ManifestHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPlatformLocked() ? 79 : 97);
            result = result * 59 + (this.isDirectoryLoad() ? 79 : 97);
            result = result * 59 + (this.isLoadBeforeGame() ? 79 : 97);
            result = result * 59 + (this.isLockTemplateOptions() ? 79 : 97);
            result = result * 59 + (this.isPopulationControl() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            PackedVersion $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            PackedVersion $minEngineVersion = this.getMinEngineVersion();
            result = result * 59 + ($minEngineVersion == null ? 43 : $minEngineVersion.hashCode());
            String $packScope = this.getPackScope();
            result = result * 59 + ($packScope == null ? 43 : $packScope.hashCode());
            return result;
        }

        public String toString() {
            return "PackManifest.ManifestHeader(name=" + this.getName() + ", uuid=" + this.getUuid() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", platformLocked=" + this.isPlatformLocked() + ", minEngineVersion=" + this.getMinEngineVersion() + ", packScope=" + this.getPackScope() + ", directoryLoad=" + this.isDirectoryLoad() + ", loadBeforeGame=" + this.isLoadBeforeGame() + ", lockTemplateOptions=" + this.isLockTemplateOptions() + ", populationControl=" + this.isPopulationControl() + ")";
        }
    }

    public static class PackModule {
        private UUID uuid;
        private String description;
        private PackedVersion version;
        private String type;

        public UUID getUuid() {
            return this.uuid;
        }

        public String getDescription() {
            return this.description;
        }

        public PackedVersion getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setVersion(PackedVersion version) {
            this.version = version;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackModule)) {
                return false;
            }
            PackModule other = (PackModule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            PackedVersion this$version = this.getVersion();
            PackedVersion other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PackModule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            PackedVersion $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "PackManifest.PackModule(uuid=" + this.getUuid() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", type=" + this.getType() + ")";
        }
    }
}

