/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.serverinfo;

import dev.waterdog.waterdogpe.network.serverinfo.BedrockServerInfo;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Predicate;
import org.cloudburstmc.protocol.common.util.Preconditions;

public class ServerInfoType
implements Comparable<ServerInfoType> {
    private static final Predicate<ServerInfoType> PREDICATE_TRUE = server -> true;
    private static final Map<String, ServerInfoType> types = new ConcurrentSkipListMap<String, ServerInfoType>(String.CASE_INSENSITIVE_ORDER);
    public static final ServerInfoType BEDROCK = ServerInfoType.builder().identifier("bedrock").serverInfoFactory(BedrockServerInfo::new).register();
    private final String identifier;
    private final ServerInfoFactory serverInfoFactory;

    public static ServerInfoType fromString(String string) {
        Preconditions.checkNotNull(string, "ServerInfoType name can not be null");
        Preconditions.checkArgument(!string.isEmpty(), "ServerInfoType name can not be empty");
        return types.get(string);
    }

    public static Collection<ServerInfoType> values() {
        return Collections.unmodifiableCollection(types.values());
    }

    public String toString() {
        return this.identifier;
    }

    @Override
    public int compareTo(ServerInfoType serverInfoType) {
        return this.identifier.compareTo(serverInfoType.getIdentifier());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ServerInfoFactory getServerInfoFactory() {
        return this.serverInfoFactory;
    }

    private ServerInfoType(String identifier, ServerInfoFactory serverInfoFactory) {
        this.identifier = identifier;
        this.serverInfoFactory = serverInfoFactory;
    }

    public static class Builder {
        private String identifier;
        private ServerInfoFactory serverInfoFactory;

        public Builder identifier(String name) {
            this.identifier = name;
            return this;
        }

        public Builder serverInfoFactory(ServerInfoFactory factory) {
            this.serverInfoFactory = factory;
            return this;
        }

        public ServerInfoType register() {
            Preconditions.checkNotNull(this.identifier, "identifier");
            Preconditions.checkNotNull(this.serverInfoFactory, "server info factory");
            Preconditions.checkArgument(!types.containsKey(this.identifier), "ServerInfoType " + this.identifier + " already exists");
            ServerInfoType type = new ServerInfoType(this.identifier, this.serverInfoFactory);
            types.put(this.identifier, type);
            return type;
        }
    }

    public static interface ServerInfoFactory {
        public ServerInfo createServerInfo(String var1, InetSocketAddress var2, InetSocketAddress var3);
    }
}

