/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.serverinfo;

import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfoType;
import dev.waterdog.waterdogpe.utils.config.ServerEntry;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class ServerInfoMap {
    public static final ServerInfoType DEFAULT_TYPE = ServerInfoType.BEDROCK;
    private final Map<String, ServerInfo> serverList = new ConcurrentSkipListMap<String, ServerInfo>(String.CASE_INSENSITIVE_ORDER);

    public ServerInfo get(String name) {
        return this.serverList.get(name);
    }

    public ServerInfo putIfAbsent(String name, ServerInfo info) {
        return this.serverList.putIfAbsent(name, info);
    }

    public ServerInfo remove(String name) {
        return this.serverList.remove(name);
    }

    public ServerInfo put(String name, ServerInfo info) {
        return this.serverList.put(name, info);
    }

    public Collection<ServerInfo> values() {
        return Collections.unmodifiableCollection(this.serverList.values());
    }

    public ServerInfo createServerInfo(String serverName, InetSocketAddress address, InetSocketAddress publicAddress, ServerInfoType serverType) {
        return serverType.getServerInfoFactory().createServerInfo(serverName, address, publicAddress);
    }

    public ServerInfo fromServerEntry(ServerEntry entry) {
        return this.createServerInfo(entry.getServerName(), entry.getAddress(), entry.getPublicAddress(), entry.getServerInfoType());
    }
}

