/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.serverinfo;

import dev.waterdog.waterdogpe.network.connection.client.ClientConnection;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfoType;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import io.netty.util.concurrent.Future;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;

public abstract class ServerInfo {
    private final String serverName;
    private final InetSocketAddress address;
    private final InetSocketAddress publicAddress;
    private final Set<ClientConnection> connections = ObjectSets.synchronize(new ObjectOpenHashSet());
    private final Set<ProxiedPlayer> players = ObjectSets.synchronize(new ObjectOpenHashSet());

    public ServerInfo(String serverName, InetSocketAddress address, InetSocketAddress publicAddress) {
        this.serverName = serverName;
        this.address = address;
        if (publicAddress == null) {
            publicAddress = address;
        }
        this.publicAddress = publicAddress;
    }

    public abstract ServerInfoType getServerType();

    public abstract Future<ClientConnection> createConnection(ProxiedPlayer var1);

    public boolean matchAddress(String address, int port) {
        InetAddress inetAddress = this.publicAddress.getAddress();
        boolean addressMatch = inetAddress == null ? this.publicAddress.getHostString().equals(address) || this.publicAddress.getHostName().equals(address) : inetAddress.getHostAddress().equals(address) || inetAddress.getHostName().equals(address);
        return addressMatch && this.publicAddress.getPort() == port;
    }

    public void addConnection(ClientConnection connection) {
        if (connection != null && connection.isConnected()) {
            this.players.add(connection.getPlayer());
            this.connections.add(connection);
        }
    }

    public void removeConnection(ClientConnection connection) {
        if (connection != null) {
            this.connections.remove(connection);
            this.players.remove(connection.getPlayer());
        }
    }

    public Set<ProxiedPlayer> getPlayers() {
        return Collections.unmodifiableSet(this.players);
    }

    public Set<ClientConnection> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }

    public String getServerName() {
        return this.serverName;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getPublicAddress() {
        return this.publicAddress;
    }

    public String toString() {
        return "ServerInfo(serverName=" + this.getServerName() + ", address=" + this.getAddress() + ", publicAddress=" + this.getPublicAddress() + ", connections=" + this.getConnections() + ")";
    }
}

