/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.serverinfo;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.EventLoops;
import dev.waterdog.waterdogpe.network.connection.client.ClientConnection;
import dev.waterdog.waterdogpe.network.connection.codec.client.ClientPingHandler;
import dev.waterdog.waterdogpe.network.connection.codec.initializer.ProxiedClientSessionInitializer;
import dev.waterdog.waterdogpe.network.netease.NetEaseUtils;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfoType;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.utils.config.proxy.NetworkSettings;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.cloudburstmc.netty.channel.raknet.RakPing;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.BedrockPong;

public class BedrockServerInfo
extends ServerInfo {
    private static final Logger log = LogManager.getLogger(BedrockServerInfo.class);

    public BedrockServerInfo(String serverName, InetSocketAddress address, InetSocketAddress publicAddress) {
        super(serverName, address, publicAddress);
    }

    @Override
    public ServerInfoType getServerType() {
        return ServerInfoType.BEDROCK;
    }

    @Override
    public Future<ClientConnection> createConnection(ProxiedPlayer player) {
        ProtocolVersion version = player.getProtocol();
        NetworkSettings networkSettings = player.getProxy().getNetworkSettings();
        int rakVersion = version.getRaknetVersion();
        int clientRakVersion = player.getConnection().getPeer().getRakVersion();
        boolean isNetEaseClient = NetEaseUtils.isNetEaseClient(clientRakVersion, version.getProtocol());
        if (isNetEaseClient) {
            rakVersion = clientRakVersion;
        }
        EventLoop eventLoop = player.getProxy().getWorkerEventLoopGroup().next();
        Promise<ClientConnection> promise = eventLoop.newPromise();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(RakChannelFactory.client(EventLoops.getChannelType().getDatagramChannel()))).group(eventLoop)).option(RakChannelOption.RAK_PROTOCOL_VERSION, rakVersion)).option(RakChannelOption.RAK_ORDERING_CHANNELS, 1)).option(RakChannelOption.RAK_CONNECT_TIMEOUT, (long)networkSettings.getConnectTimeout() * 1000L)).option(RakChannelOption.RAK_SESSION_TIMEOUT, 10000L)).option(RakChannelOption.RAK_MTU, networkSettings.getMaximumDownstreamMtu())).handler(new ProxiedClientSessionInitializer(player, this, promise))).connect(this.getAddress()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> {
            if (!future.isSuccess()) {
                promise.tryFailure(future.cause());
                future.channel().close();
            }
        }));
        return promise;
    }

    public Future<BedrockPong> ping(long timeout, TimeUnit timeUnit) {
        EventLoop eventLoop = ProxyServer.getInstance().getWorkerEventLoopGroup().next();
        Promise<BedrockPong> promise = eventLoop.newPromise();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(RakChannelFactory.client(EventLoops.getChannelType().getDatagramChannel()))).group(eventLoop)).option(RakChannelOption.RAK_GUID, ThreadLocalRandom.current().nextLong())).handler(new ClientPingHandler(promise, timeout, timeUnit))).bind(ThreadLocalRandom.current().nextInt(10000, 15000)).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> {
            if (future.cause() != null) {
                promise.tryFailure(future.cause());
                future.channel().close();
            } else {
                RakPing ping = new RakPing(System.currentTimeMillis(), this.getAddress());
                future.channel().writeAndFlush(ping).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future1 -> {
                    if (future1.cause() != null) {
                        promise.tryFailure(future1.cause());
                        future.channel().close();
                    }
                }));
            }
        }));
        return promise;
    }
}

