/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.user;

import java.util.HashMap;
import java.util.Map;

public enum Platform {
    UNKNOWN("Unknown", -1),
    ANDROID("Android", 1),
    IOS("iOS", 2),
    MAC_OS("macOS", 3),
    FIRE_OS("FireOS", 4),
    GEAR_VR("Gear VR", 5),
    HOLOLENS("Hololens", 6),
    WINDOWS_10("Windows 10", 7),
    WINDOWS("Windows", 8),
    DEDICATED("Dedicated", 9),
    TVOS("TVOS", 10),
    PLAYSTATION("PlayStation", 11),
    SWITCH("Switch", 12),
    XBOX_ONE("Xbox One", 13),
    WINDOWS_PHONE("Windows Phone", 14),
    LINUX("Linux", 15);

    private static Map<Integer, Platform> PLATFORM_BY_ID;
    public static Platform[] VALUES;
    private final String name;
    private final int id;

    public static Platform getPlatformByID(int id) {
        if (PLATFORM_BY_ID.containsKey(id)) {
            return PLATFORM_BY_ID.get(id);
        }
        return UNKNOWN;
    }

    private Platform(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    static {
        PLATFORM_BY_ID = new HashMap<Integer, Platform>();
        for (Platform platform : Platform.values()) {
            PLATFORM_BY_ID.put(platform.getId(), platform);
        }
        VALUES = Platform.values();
    }
}

